/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.internal.registry;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.MessageResource;
import com.ibm.adapter.framework.internal.registry.ClassificationHelper;
import com.ibm.adapter.framework.internal.registry.PersistenceAgentProxy;
import com.ibm.adapter.framework.internal.registry.PersistenceAgentRegObject;
import com.ibm.adapter.framework.internal.registry.RegistryConstants;
import com.ibm.adapter.framework.persistence.IPersistenceAgent;
import com.ibm.adapter.framework.persistence.IPersistenceManager;
import com.ibm.adapter.framework.persistence.IRegistry;
import com.ibm.adapter.framework.registry.IConfiguration;
import com.ibm.adapter.framework.registry.IRegistryObject;
import com.ibm.adapter.framework.spi.persistence.BasePersistenceAgent;
import com.ibm.adapter.framework.util.QNameHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PersistenceRegistry
implements IRegistry,
com.ibm.adapter.framework.spi.persistence.IRegistry,
RegistryConstants {
    private static PersistenceRegistry _instance;
    private Map _persistenceConfigurationRegistry = Collections.synchronizedMap(new HashMap());
    private Map _persistenceAgentRegistry = Collections.synchronizedMap(new HashMap());
    private static final List TYPES;

    static {
        TYPES = new ArrayList();
        TYPES.add("IMPORT_CONFIGURATION_TYPE");
        TYPES.add("DISCOVERY_AGENT_TYPE");
        TYPES.add("WORKSPACE_RESOURCE_WRITER_TYPE");
    }

    private PersistenceRegistry() {
        this.initialize();
    }

    public static PersistenceRegistry getRegistry() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (_instance == null) {
            PersistenceRegistry.initializeInstance();
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return _instance;
    }

    private static synchronized void initializeInstance() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (_instance == null) {
            _instance = new PersistenceRegistry();
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    private void initialize() {
        String path;
        IConfigurationElement[] classificationElements;
        IPath[] classifications;
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        IConfigurationElement[] persistenceConfigurationExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.framework.PersistenceConfiguration");
        int i = 0;
        while (i < persistenceConfigurationExtensionPoints.length) {
            try {
                IConfigurationElement configuration = persistenceConfigurationExtensionPoints[i];
                String name = configuration.getAttribute("QName");
                if (LogFacility.trace) {
                    LogFacility.Trace(new StringBuffer("Found extension point Persistence Configuration: ").append(name).toString(), (short)10);
                }
                QNameHelper.createQName(name);
                configuration.getAttribute("Description");
                configuration.getAttribute("DisplayName");
                String agent = configuration.getAttribute("Agent");
                QNameHelper.createQName(agent);
                configuration.getAttribute("Type");
                classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                classificationElements = configuration.getChildren("Classification");
                if (classificationElements != null && classificationElements.length > 0) {
                    classifications = new IPath[classificationElements.length];
                    int j = 0;
                    while (j < classificationElements.length) {
                        path = classificationElements[j].getValue();
                        if (path != null) {
                            classifications[j] = new Path(path);
                        }
                        ++j;
                    }
                }
            }
            catch (Throwable ex) {
                LogFacility.logErrorMessage(ex.getLocalizedMessage(), ex);
            }
            ++i;
        }
        IConfigurationElement[] persistenceAgentExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.framework.PersistenceAgent");
        int i2 = 0;
        while (i2 < persistenceAgentExtensionPoints.length) {
            try {
                IConfigurationElement agent = persistenceAgentExtensionPoints[i2];
                String name = agent.getAttribute("QName");
                if (LogFacility.trace) {
                    LogFacility.Trace(new StringBuffer("Found extension point Persistence Agent: ").append(name).toString(), (short)10);
                }
                QNameHelper.validateQName(QNameHelper.createQName(name));
                classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                classificationElements = agent.getChildren("Classification");
                if (classificationElements != null && classificationElements.length > 0) {
                    classifications = new IPath[classificationElements.length];
                    int j = 0;
                    while (j < classificationElements.length) {
                        path = classificationElements[j].getValue();
                        if (path != null) {
                            classifications[j] = new Path(path);
                        }
                        ++j;
                    }
                }
                PersistenceAgentProxy persistenceAgentProxy = new PersistenceAgentProxy();
                persistenceAgentProxy.setConfiguartionElement(agent);
                this.registerPersistenceAgent(persistenceAgentProxy, classifications);
                if (LogFacility.trace) {
                    LogFacility.Trace(new StringBuffer("Loaded extension point Persistence Agent: ").append(agent).toString(), (short)10);
                }
            }
            catch (Throwable ex) {
                LogFacility.logErrorMessage(ex.getLocalizedMessage(), ex);
            }
            ++i2;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPersistenceAgent(IPersistenceAgent newAgent, IPath[] classifications) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            QName agentName = newAgent.getName();
            if (LogFacility.trace) {
                LogFacility.Trace(new StringBuffer("Registering a new IPersistenceAgent: ").append(agentName).toString(), (short)10);
            }
            Map map = this._persistenceAgentRegistry;
            synchronized (map) {
                if (!this._persistenceAgentRegistry.containsKey(agentName)) {
                    if (classifications == null) {
                        classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                    }
                } else {
                    String message = MessageResource.bind((String)MessageResource.MSG_ERROR__PERSISTENCE_AGENT__ALREADY_REGISTERED, (Object)agentName.toString());
                    BaseException e = BaseException.createException(message, null);
                    LogFacility.logErrorMessage(e.getStatus());
                    throw e;
                }
                PersistenceAgentRegObject registryObj = new PersistenceAgentRegObject(newAgent, classifications);
                this._persistenceAgentRegistry.put(agentName, registryObj);
            }
            if (LogFacility.trace) {
                LogFacility.Trace(new StringBuffer("Finished registering IPersistenceAgent: ").append(agentName).toString(), (short)10);
            }
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (LogFacility.trace) {
                LogFacility.Trace("Error registering a new IConfiguration: ", (short)10);
            }
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void registerPersistenceManager(IPersistenceManager persistenceManager, IPath[] configurationClassifications) throws BaseException {
    }

    @Override
    public void registerPersistenceManager(IPersistenceManager persistenceManager, QName configurationName) throws BaseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePersistenceAgent(QName agentName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (LogFacility.trace) {
                LogFacility.Trace(new StringBuffer("Removing Persistence Agent: ").append(agentName).toString(), (short)10);
            }
            Map map = this._persistenceAgentRegistry;
            synchronized (map) {
                if (this._persistenceAgentRegistry.containsKey(agentName)) {
                    IRegistryObject cfr_ignored_0 = (IRegistryObject)this._persistenceAgentRegistry.get(agentName);
                    this._persistenceAgentRegistry.remove(agentName);
                    if (LogFacility.trace) {
                        LogFacility.Trace(new StringBuffer("Removed Persistence Agent: ").append(agentName).toString(), (short)10);
                    }
                } else if (LogFacility.trace) {
                    LogFacility.Trace(new StringBuffer("Could not find Persistence Agent: ").append(agentName).append(" to remove it.").toString(), (short)10);
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void removePersistenceManager(QName persistenceManagerName) throws BaseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPersistenceAgent getPersistenceAgent(QName persistenceAgentName) {
        block11: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                QNameHelper.validateQName(persistenceAgentName);
                Collection agents = this._persistenceAgentRegistry.values();
                Map map = this._persistenceAgentRegistry;
                synchronized (map) {
                    for (BasePersistenceAgent agent : agents) {
                        if (!persistenceAgentName.equals(agent.getName())) continue;
                        if (LogFacility.trace) {
                            LogFacility.TrcExit();
                        }
                        return agent;
                    }
                }
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (!LogFacility.trace) break block11;
                LogFacility.TrcExit();
            }
        }
        return null;
    }

    @Override
    public IPersistenceManager getPersistenceManager(IConfiguration configuration) {
        return null;
    }
}

