/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.internal.registry;

import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.registry.Classification;
import com.ibm.adapter.framework.internal.registry.Concept;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ClassificationHelper {
    public static final IPath UNCLASSIFIED = new Path("UNCLASSIFIED");
    public static final IPath[] UNCLASSIFIED_PATH = new IPath[]{UNCLASSIFIED};

    public static Classification createClassification(IPath classification) {
        block8: {
            if (classification != null) break block8;
            return null;
        }
        try {
            IPath currentPath = classification;
            Concept currentConcept = null;
            while (currentPath.segmentCount() > 1) {
                String identifier = currentPath.lastSegment();
                if (currentConcept == null) {
                    currentConcept = new Concept(identifier);
                } else {
                    Concept childConcept = currentConcept;
                    currentConcept = new Concept(identifier);
                    currentConcept.addChildConcept(childConcept);
                }
                currentPath = currentPath.removeLastSegments(1);
            }
            Concept topLevelConcept = new Concept(currentPath.lastSegment());
            if (currentConcept != null) {
                topLevelConcept.addChildConcept(currentConcept);
            }
            return new Classification(topLevelConcept);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static Classification[] createClassification(IPath[] classifications) {
        block5: {
            if (classifications != null) break block5;
            return null;
        }
        try {
            Classification[] c = new Classification[classifications.length];
            int i = classifications.length;
            while (--i >= 0) {
                Classification result;
                IPath currentPath = classifications[i];
                c[i] = result = ClassificationHelper.createClassification(currentPath);
            }
            return c;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static boolean containsClassifier(Classification classificationObject, IPath classifier, boolean exactMatch) {
        Concept concept;
        if (classifier == null) {
            classifier = UNCLASSIFIED;
        }
        return classificationObject != null && (exactMatch ? (concept = classificationObject.getChildConcept(classifier)) != null && (concept.getChildren() == null || concept.getChildren().length == 0) : classificationObject.containsConcept(classifier));
    }
}

