/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.internal.build.spi;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.build.IOperation;
import com.ibm.propertygroup.IPropertyGroup;

public abstract class Operation
implements IOperation {
    protected IPropertyGroup currentDefinitionGroup;
    protected IPropertyGroup currentBindingGroup;
    protected IPropertyGroup definitionGroup;
    protected IPropertyGroup bindingGroup;
    protected String name;
    protected String description;
    protected String displayName;

    public void setDefinitionPropertyGroup(IPropertyGroup definitionGroup) {
        this.definitionGroup = definitionGroup;
    }

    public IPropertyGroup getActiveDefinitionPropertyGroup() {
        return this.currentDefinitionGroup;
    }

    public void setBindingPropertyGroup(IPropertyGroup bindingGroup) {
        this.bindingGroup = bindingGroup;
    }

    public IPropertyGroup getActiveBindingPropertyGroup() {
        return this.currentBindingGroup;
    }

    @Override
    public void applyBindingPropertyGroup(IPropertyGroup bindingProperties) throws BaseException {
        this.currentBindingGroup = bindingProperties;
    }

    @Override
    public void applyDefinitionPropertyGroup(IPropertyGroup defProperties) throws BaseException {
        this.currentDefinitionGroup = defProperties;
    }

    @Override
    public IPropertyGroup createBindingPropertyGroup() throws BaseException {
        try {
            if (this.currentBindingGroup != null) {
                return (IPropertyGroup)this.currentBindingGroup.clone();
            }
            if (this.bindingGroup != null) {
                return (IPropertyGroup)this.bindingGroup.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public IPropertyGroup createDefinitionPropertyGroup() throws BaseException {
        try {
            if (this.currentDefinitionGroup != null) {
                return (IPropertyGroup)this.currentDefinitionGroup.clone();
            }
            if (this.definitionGroup != null) {
                return (IPropertyGroup)this.definitionGroup.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setName(String name) {
        this.name = name;
    }
}

