/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.internal.build.registry;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.MessageResource;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.framework.internal.build.registry.IBuildConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class BuildConfigurationImpl
implements IBuildConfiguration {
    protected QName configurationName;
    protected String description;
    protected IBuildAgent buildAgent;
    protected String displayName;
    protected IResourceWriter resourceWriter;
    protected ArrayList buildAgentConfigurationProperties = new ArrayList();
    protected ArrayList resourceWriterConfigurationProperties = new ArrayList();

    public BuildConfigurationImpl(QName name, IBuildAgent buildAgent, IResourceWriter resourceWriter, String displayName, String description) {
        this.configurationName = name;
        this.buildAgent = buildAgent;
        this.resourceWriter = resourceWriter;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public QName getName() {
        return this.configurationName;
    }

    @Override
    public IBuildAgent createBuildAgent() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IBuildAgent agent = this.buildAgent.newInstance();
            if (agent != null) {
                if (LogFacility.trace) {
                    Iterator i = this.buildAgentConfigurationProperties.iterator();
                    while (i.hasNext()) {
                        String name = i.next().toString();
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_CONFIGURE_BUILD_AGENT, (Object)name), (short)10);
                    }
                }
                try {
                    if (!this.buildAgentConfigurationProperties.isEmpty()) {
                        this.buildAgent.setConfiguration(this.buildAgentConfigurationProperties.toArray(new String[0]));
                    }
                }
                catch (BaseException e) {
                    LogFacility.logInfoMessage(e.getStatus());
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return agent;
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    @Override
    public IResourceWriter createResourceWriter() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IResourceWriter writer = this.resourceWriter.newInstance();
            if (this.resourceWriter != null) {
                if (LogFacility.trace) {
                    Iterator i = this.resourceWriterConfigurationProperties.iterator();
                    while (i.hasNext()) {
                        String name = i.next().toString();
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_CONFIGURE_RESOURCE_WRITER, (Object)name), (short)10);
                    }
                }
                try {
                    if (!this.resourceWriterConfigurationProperties.isEmpty()) {
                        this.resourceWriter.setConfiguration(this.resourceWriterConfigurationProperties.toArray(new String[0]));
                    }
                }
                catch (BaseException e) {
                    LogFacility.logInfoMessage(e.getStatus());
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return writer;
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    public void addBuildAgentConfigurationProperty(String name) {
        this.buildAgentConfigurationProperties.add(name);
    }

    public void addResourceWriterConfigurationProperty(String name) {
        this.resourceWriterConfigurationProperties.add(name);
    }

    @Override
    public IDiscoveryAgent createDiscoveryAgent() {
        return null;
    }
}

