/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.controller.editor.DatasetModel;
import com.ibm.im.ims.workbench.model.AreaStmt;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.HidamDataSetModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class Utility {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String MARKER_CATEGORY = "com.ibm.im.ims.explorer.marker.category";
    public static final String DATA_CONV_INFO_MISSING = "DATA_CONV_INFO_MISSING";
    private static char[] specialChar = new char[]{'<', '>', '&', '\\', '/', '!', '%', '(', ')', '*', '|', '+', '-', ',', '.', ':', ';', '=', '?', '[', ']', '{', '}', '^', '`', '~', ' ', '\"', '\''};
    private static final String[] reservedNames = new String[]{"BASICEDT", "DBCDM", "DBRC", "ISCEDT", "MSDB", "SDB", "WTOR"};
    private static final String[] reservedIMSRoutines = new String[]{"DFS", "DBF", "DSP", "DXR", "BPE", " CQS", "CSL"};
    private static final String[] reservedSQLKeywords = new String[]{"ABORT", "ANALYZE", "AND", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AVG", "BEGIN", "BETWEEN", "BINARY", "BIT", "BOOLEAN", "BOTH", "BY", "CASCADE", "CAST", "CHAR", "CHARACTER", "CHECK", "CLOSE", "CLUSTER", "COLLATE", "COLUMN", "COMMIT", "CONSTRAINT", "COPY", "COUNT", "CREATE", "CROSS", "CURRENT", "CURSOR", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DO", "DOUBLE", "DROP", "END", "EXECUTE", "EXISTS", "EXPLAIN", "EXTRACT", "EXTEND", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IN", "INNER", "INSERT", "INT", "INTEGER", "INTERVAL", "INTO", "IS", "JOIN", "LAST", "LEADING", "LEFT", "LIKE", "LISTEN", "LOAD", "LOCAL", "LOCK", "MAX", "MIN", "MOVE", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEW", "NO", "NONE", "NOT", "NOTIFY", "NULL", "NUMERIC", "ON", "ONLY", "OR", "ORDER", "OUTER", "PARTIAL", "POSITION", "PRECISION", "PRIMARY", "PRIVILEGES", "PROCEDURE", "PUBLIC", "REAL", "REFERENCES", "RESET", "REVOKE", "RIGHT", "ROLLBACK", "ROW", "ROWS", "SELECT", "SET", "SETOF", "SHOW", "SMALLINT", "SUBSTRING", "SUM", "TABLE", "TO", "TRAILING", "TRANSACTION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", "WHERE", "WITH", "WORK"};

    public static String preparePSBds(String file) {
        int index = file.lastIndexOf(File.separator);
        return file.substring(index + 1);
    }

    public static int getMaxSize(int[] labelSize) {
        Arrays.sort(labelSize);
        return labelSize[labelSize.length - 1];
    }

    public static int getTextWidth(Composite composite, int style, String label) {
        Text text = new Text(composite, style);
        text.setText(label);
        text.setFont(composite.getFont());
        int retVal = text.computeSize((int)-1, (int)-1).x;
        text.dispose();
        return retVal;
    }

    public static String removeFileExt(String name) {
        int marker = name.indexOf(".");
        if (marker > -1) {
            return name.substring(0, marker);
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    public static void deleteTempFile(IFile tempFile) {
        block3: {
            try {
                if (tempFile == null || !tempFile.exists()) break block3;
                tempFile.refreshLocal(1, null);
                tempFile.delete(true, null);
                break block3;
            }
            catch (CoreException v0) {
                System.gc();
                file = new File(tempFile.getLocation().toOSString());
                ** while (file.exists())
            }
lbl-1000:
            // 1 sources

            {
                file.delete();
                continue;
            }
        }
    }

    public static File createFileWithNewExtension(String folderName, String fileName, String newExt) {
        Object fileNameWithoutExt = null;
        int extIx = fileName.indexOf(".");
        fileNameWithoutExt = extIx > -1 ? fileName.substring(0, extIx) : fileName;
        fileNameWithoutExt = ((String)fileNameWithoutExt).replace('-', '_');
        int counter = 1;
        if (Utility.isStringNumeric(((String)fileNameWithoutExt).substring(0, 1))) {
            fileNameWithoutExt = "T" + (String)fileNameWithoutExt;
        }
        File newFile = new File(folderName + File.separator + (String)fileNameWithoutExt + newExt);
        while (newFile.exists()) {
            newFile = new File(folderName + File.separator + (String)fileNameWithoutExt + "_" + counter + newExt);
            ++counter;
        }
        return newFile;
    }

    public static void copy(File source, File target) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static File renameFile(File source, String newFileExt) {
        String fullPath = source.getAbsolutePath();
        int lastSeparatorIx = fullPath.lastIndexOf(File.separator);
        String shortFileName = fullPath.substring(lastSeparatorIx + 1);
        String path = fullPath.substring(0, lastSeparatorIx);
        int extIx = shortFileName.indexOf(".");
        if (extIx > -1) {
            shortFileName = shortFileName.substring(0, extIx);
        }
        File target = new File(path + File.separator + shortFileName + newFileExt);
        int counter = 1;
        while (target.exists()) {
            target = new File(path + File.separator + shortFileName + "_" + counter + newFileExt);
            ++counter;
        }
        source.renameTo(target);
        return target;
    }

    public static boolean isValidCaseOrMappingName(String name) {
        char[] chars = new char[name.length()];
        name.getChars(0, chars.length, chars, 0);
        if (name.startsWith("DFS")) {
            return false;
        }
        int i = 0;
        while (i < chars.length) {
            int x = 0;
            while (x < specialChar.length) {
                if (chars[i] == specialChar[x]) {
                    return false;
                }
                ++x;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidName(String name) {
        Object invalidChars = "";
        char[] cArray = specialChar;
        int n = specialChar.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            invalidChars = (String)invalidChars + c;
            ++n2;
        }
        int i = 0;
        while (i < name.length()) {
            if (((String)invalidChars).contains(String.valueOf(name.charAt(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSpecialChar(char ch) {
        char[] cArray = specialChar;
        int n = specialChar.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (ch == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getInvalidRemarksCharacter(String remarks) {
        String retVal = null;
        if (remarks.indexOf("<") >= 0) {
            retVal = "<";
        } else if (remarks.indexOf(">") >= 0) {
            retVal = ">";
        } else if (remarks.indexOf("&") >= 0) {
            retVal = "&";
        } else if (remarks.indexOf(34) >= 0) {
            retVal = "\"";
        } else if (remarks.indexOf("'") >= 0) {
            retVal = "'";
        }
        return retVal;
    }

    public static boolean hasReservedSQLKeywords(String text) {
        if (text != null) {
            int i = 0;
            while (i < reservedSQLKeywords.length) {
                if (text.toUpperCase().equals(reservedSQLKeywords[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean hasReservedName(String text) {
        int i = 0;
        while (i < reservedNames.length) {
            if (text.toUpperCase().equals(reservedNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasReservedIMSRoutines(String text) {
        int i = 0;
        while (i < reservedIMSRoutines.length) {
            if (text.toUpperCase().equals(reservedIMSRoutines[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isStringNumeric(String text) {
        try {
            if (text != null && text.length() > 0) {
                Integer.parseInt(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isStringDecimal(String text) {
        try {
            if (text != null && text.length() > 0) {
                new BigDecimal(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean hasSpecialChar(String text, boolean isExternalName) {
        int i = 0;
        while (i < specialChar.length) {
            if (text.indexOf(specialChar[i]) >= 0 || !isExternalName && text.indexOf("_") >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isFieldFit(SegmentModel segmentModel, FieldModel fieldModel) {
        return fieldModel.getStartPos() <= segmentModel.getMaxBytes() && fieldModel.getBytes() <= segmentModel.getMaxBytes() && fieldModel.getStartPos() + fieldModel.getBytes() - 1 <= segmentModel.getMaxBytes();
    }

    public static String doReplace(String strIn) {
        StringBuffer finalStr = new StringBuffer();
        String digit = "0123456789";
        int i = 0;
        while (i < strIn.length()) {
            char ch = strIn.charAt(i);
            if (digit.indexOf(ch) != -1) {
                ch = '%';
            }
            finalStr.append(ch);
            ++i;
        }
        return finalStr.toString();
    }

    public static String getTimeStamp() {
        Date date = new Date();
        String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss z";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(date);
    }

    public static void displayMessageForDatabase(String projectName, String dbdName, String errMsg, int severity) throws CoreException {
        IMarker marker = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder("DBD");
        marker = databaseFolder.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("lineNumber", 1);
        marker.setAttribute("severity", 1);
        marker.setAttribute("message", (Object)("[" + Utility.getTimeStamp() + "] " + errMsg));
        marker.setAttribute("location", (Object)ProjectTreeFileHelper.getProjectPathStr(projectName));
    }

    public static void reportProblem(IFile dbdFile, String errMsg, int severity) throws CoreException {
        IMarker marker = null;
        marker = dbdFile.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("lineNumber", 1);
        marker.setAttribute("severity", severity);
        marker.setAttribute("message", (Object)("[" + Utility.getTimeStamp() + "] " + errMsg));
        marker.setAttribute("location", (Object)dbdFile.getFullPath().toString());
        marker.setAttribute(MARKER_CATEGORY, (Object)DATA_CONV_INFO_MISSING);
    }

    public static boolean stringsDifferent(String s1, String s2) {
        return s1 == null ? s2 != null : !s1.equals(s2);
    }

    public static boolean closeOpenedEditorForResourceFile(IFile resourceFile, String projectName) {
        boolean editorWasOpen = false;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] openEditorRefs = page.getEditorReferences();
        int j = 0;
        while (j < openEditorRefs.length) {
            IFile file;
            IEditorInput input;
            IEditorPart currEditor = openEditorRefs[j].getEditor(false);
            if (currEditor != null && (input = currEditor.getEditorInput()) instanceof FileEditorInput && (file = ((IFileEditorInput)input).getFile()).getFullPath().segment(0).equals(projectName) && file.getFullPath().lastSegment().equals(resourceFile.getFullPath().lastSegment())) {
                page.closeEditor(currEditor, false);
                editorWasOpen = true;
            }
            ++j;
        }
        return editorWasOpen;
    }

    public static IEditorPart[] getDirtyEditors(String projectName) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart[] dirtyEditors = page.getDirtyEditors();
        return dirtyEditors;
    }

    public static IEditorPart getDirtyEditor(IFile dbdFile, String projectName) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] openEditorRefs = page.getEditorReferences();
        int j = 0;
        while (j < openEditorRefs.length) {
            IFile file;
            IEditorInput input;
            IEditorPart currEditor = openEditorRefs[j].getEditor(false);
            if (currEditor != null && (input = currEditor.getEditorInput()) instanceof FileEditorInput && (file = ((IFileEditorInput)input).getFile()).getFullPath().segment(0).equals(projectName) && file.getFullPath().lastSegment().equals(dbdFile.getFullPath().lastSegment()) && currEditor.isDirty()) {
                return currEditor;
            }
            ++j;
        }
        return null;
    }

    public static boolean isEditorDirty(IFile dbdFile, String projectName) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] openEditorRefs = page.getEditorReferences();
        int j = 0;
        while (j < openEditorRefs.length) {
            IFile file;
            IEditorInput input;
            IEditorPart currEditor = openEditorRefs[j].getEditor(false);
            if (currEditor != null && (input = currEditor.getEditorInput()) instanceof FileEditorInput && (file = ((IFileEditorInput)input).getFile()).getFullPath().segment(0).equals(projectName) && file.getFullPath().lastSegment().equals(dbdFile.getFullPath().lastSegment()) && currEditor.isDirty()) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static boolean isQuoteNeeded(String name) {
        boolean retVal = false;
        if (!name.isEmpty() && (Utility.isStringNumeric(name.substring(0, 1)) || name.length() >= 3 && (name.substring(0, 3).toUpperCase().equals("/SX") || name.substring(0, 3).toUpperCase().equals("/CK")))) {
            retVal = true;
        }
        return retVal;
    }

    public static String getEBCDICValue(char input) {
        String retVal = String.valueOf(input);
        switch (input) {
            case ' ': {
                retVal = "40";
                break;
            }
            case '\u00a2': {
                retVal = "4A";
                break;
            }
            case '.': {
                retVal = "4B";
                break;
            }
            case '<': {
                retVal = "4C";
                break;
            }
            case '(': {
                retVal = "4D";
                break;
            }
            case '+': {
                retVal = "4E";
                break;
            }
            case '|': {
                retVal = "4F";
                break;
            }
            case '!': {
                retVal = "5A";
                break;
            }
            case '$': {
                retVal = "5B";
                break;
            }
            case '*': {
                retVal = "5C";
                break;
            }
            case ')': {
                retVal = "5D";
                break;
            }
            case ';': {
                retVal = "5E";
                break;
            }
            case '\u00ac': {
                retVal = "5F";
                break;
            }
            case '-': {
                retVal = "60";
                break;
            }
            case '/': {
                retVal = "61";
                break;
            }
            case '\u00a6': {
                retVal = "6A";
                break;
            }
            case ',': {
                retVal = "6B";
                break;
            }
            case '%': {
                retVal = "6C";
                break;
            }
            case '_': {
                retVal = "6D";
                break;
            }
            case '>': {
                retVal = "6E";
                break;
            }
            case '?': {
                retVal = "6F";
                break;
            }
            case '`': {
                retVal = "79";
                break;
            }
            case ':': {
                retVal = "7A";
                break;
            }
            case '#': {
                retVal = "7B";
                break;
            }
            case '@': {
                retVal = "7C";
                break;
            }
            case '\'': {
                retVal = "7D";
                break;
            }
            case '=': {
                retVal = "7E";
                break;
            }
            case '\"': {
                retVal = "7F";
                break;
            }
            case 'a': {
                retVal = "81";
                break;
            }
            case 'b': {
                retVal = "82";
                break;
            }
            case 'c': {
                retVal = "83";
                break;
            }
            case 'd': {
                retVal = "84";
                break;
            }
            case 'e': {
                retVal = "85";
                break;
            }
            case 'f': {
                retVal = "86";
                break;
            }
            case 'g': {
                retVal = "87";
                break;
            }
            case 'h': {
                retVal = "88";
                break;
            }
            case 'i': {
                retVal = "89";
                break;
            }
            case 'j': {
                retVal = "91";
                break;
            }
            case 'k': {
                retVal = "92";
                break;
            }
            case 'l': {
                retVal = "93";
                break;
            }
            case 'm': {
                retVal = "94";
                break;
            }
            case 'n': {
                retVal = "95";
                break;
            }
            case 'o': {
                retVal = "96";
                break;
            }
            case 'p': {
                retVal = "97";
                break;
            }
            case 'q': {
                retVal = "98";
                break;
            }
            case 'r': {
                retVal = "99";
                break;
            }
            case '~': {
                retVal = "A1";
                break;
            }
            case 's': {
                retVal = "A2";
                break;
            }
            case 't': {
                retVal = "A3";
                break;
            }
            case 'u': {
                retVal = "A4";
                break;
            }
            case 'v': {
                retVal = "A5";
                break;
            }
            case 'w': {
                retVal = "A6";
                break;
            }
            case 'x': {
                retVal = "A7";
                break;
            }
            case 'y': {
                retVal = "A8";
                break;
            }
            case 'z': {
                retVal = "A9";
                break;
            }
            case '{': {
                retVal = "C0";
                break;
            }
            case 'A': {
                retVal = "C1";
                break;
            }
            case 'B': {
                retVal = "C2";
                break;
            }
            case 'C': {
                retVal = "C3";
                break;
            }
            case 'D': {
                retVal = "C4";
                break;
            }
            case 'E': {
                retVal = "C5";
                break;
            }
            case 'F': {
                retVal = "C6";
                break;
            }
            case 'G': {
                retVal = "C7";
                break;
            }
            case 'H': {
                retVal = "C8";
                break;
            }
            case 'I': {
                retVal = "C9";
                break;
            }
            case '}': {
                retVal = "D0";
                break;
            }
            case 'J': {
                retVal = "D1";
                break;
            }
            case 'K': {
                retVal = "D2";
                break;
            }
            case 'L': {
                retVal = "D3";
                break;
            }
            case 'M': {
                retVal = "D4";
                break;
            }
            case 'N': {
                retVal = "D5";
                break;
            }
            case 'O': {
                retVal = "D6";
                break;
            }
            case 'P': {
                retVal = "D7";
                break;
            }
            case 'Q': {
                retVal = "D8";
                break;
            }
            case 'R': {
                retVal = "D9";
                break;
            }
            case '\\': {
                retVal = "E0";
                break;
            }
            case 'S': {
                retVal = "E2";
                break;
            }
            case 'T': {
                retVal = "E3";
                break;
            }
            case 'U': {
                retVal = "E4";
                break;
            }
            case 'V': {
                retVal = "E5";
                break;
            }
            case 'W': {
                retVal = "E6";
                break;
            }
            case 'X': {
                retVal = "E7";
                break;
            }
            case 'Y': {
                retVal = "E8";
                break;
            }
            case 'Z': {
                retVal = "E9";
                break;
            }
            case '0': {
                retVal = "F0";
                break;
            }
            case '1': {
                retVal = "F1";
                break;
            }
            case '2': {
                retVal = "F2";
                break;
            }
            case '3': {
                retVal = "F3";
                break;
            }
            case '4': {
                retVal = "F4";
                break;
            }
            case '5': {
                retVal = "F5";
                break;
            }
            case '6': {
                retVal = "F6";
                break;
            }
            case '7': {
                retVal = "F7";
                break;
            }
            case '8': {
                retVal = "F8";
                break;
            }
            case '9': {
                retVal = "F9";
            }
        }
        return retVal;
    }

    public static ArrayList<DatasetModel> getDatasetModels(DbdModel dbdModel) {
        ArrayList<DatasetModel> retVal = new ArrayList<DatasetModel>();
        DBDConstants accessType = dbdModel.getAccessType();
        if (accessType == DBDConstants.DEDB) {
            ArrayList<AreaStmt> areas = dbdModel.getAreaList();
            int i = 0;
            while (i < areas.size()) {
                AreaStmt area = areas.get(i);
                DatasetModel ds = new DatasetModel(area.getDd1(), area.getDevice(), area.getRemarks());
                ds.setRootOrBlock1(area.getRootNumber2());
                ds.setRootOrBlock2(area.getRootOverflow2());
                ds.setUowOrRecord1(area.getUowNumber1());
                ds.setUowOrRecord2(area.getUowOverflow1());
                ds.setSize1(area.getSize());
                retVal.add(ds);
                ++i;
            }
        } else if (accessType == DBDConstants.HDAM || accessType == DBDConstants.HIDAM) {
            ArrayList<HidamDataSetModel> hdamDatasets = dbdModel.getHidamDataset();
            int i = 0;
            while (i < hdamDatasets.size()) {
                HidamDataSetModel hdamDs = hdamDatasets.get(i);
                DatasetModel ds = new DatasetModel(hdamDs.getDdname1(), hdamDs.getDevice(), hdamDs.getRemarks());
                ds.setLabel(hdamDs.getLabel());
                ds.setRootOrBlock1(hdamDs.getSize0());
                ds.setSize1(hdamDs.getSize1());
                ds.setScan(hdamDs.getCyls());
                ds.setFreeBlock(hdamDs.getFbff());
                ds.setFreeSpace(hdamDs.getFspf());
                ds.setSearchAlgorithm(hdamDs.getSearcha());
                retVal.add(ds);
                ++i;
            }
        } else {
            DatasetModel ds = new DatasetModel(dbdModel.getDataSetDdname1(), dbdModel.getDevice(), dbdModel.getDatasetRemarks());
            if (accessType == DBDConstants.HISAM || accessType == DBDConstants.INDEX) {
                ds.setOutPutOrOverflow(dbdModel.getOvflw());
            } else {
                ds.setOutPutOrOverflow(dbdModel.getDdname2());
            }
            ds.setRootOrBlock1(dbdModel.getBLOCKBlkfact1());
            ds.setRootOrBlock2(dbdModel.getBLOCKBlkfact2());
            ds.setSize1(dbdModel.getSize1());
            ds.setSize2(dbdModel.getSize2());
            ds.setUowOrRecord1(dbdModel.getRECORDReclen1());
            ds.setUowOrRecord2(dbdModel.getRECORDReclen2());
            ds.setRecordFormat(dbdModel.getRecfm());
            ds.setRelType(dbdModel.getRelType());
            ds.setRelName(dbdModel.getRelFldnm());
            retVal.add(ds);
        }
        return retVal;
    }
}

