/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ImsTokenizer;
import com.ibm.im.ims.workbench.model.utilities.ModelErrorMessages;
import com.ibm.im.ims.workbench.model.utilities.Parameter;
import com.ibm.im.ims.workbench.model.utilities.Statement;
import com.ibm.im.ims.workbench.model.utilities.StatementSet;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class StatementSetReader {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ArrayList<StatementSet> statementSets = new ArrayList();
    private String dbdName = null;
    private String accessType = null;
    private PS parseState;
    private BufferedReader br;
    private String currLine;
    private String prevLine;
    private String statementBuf;
    private int currIx;
    private int startIx;
    private String filePath;
    private String currOperation;
    private StatementSet currentStatementSet;
    int lineNum;
    int bytesRead;

    public StatementSetReader() {
    }

    public StatementSetReader(BufferedReader fileReader, String filePath) throws IOException, ImporterException {
        this.br = fileReader;
        this.filePath = filePath;
        this.parseState = PS.PARSING_NAME;
        this.lineNum = 0;
        this.bytesRead = 0;
        this.readNextLine();
    }

    public boolean hasMoreStatementSets() throws IOException, ImporterException {
        this.currentStatementSet = this.getNextStatementSet();
        return this.currentStatementSet != null;
    }

    public StatementSet nextStatementSet() {
        return this.currentStatementSet;
    }

    public boolean getQuickStatementSet(String filePath) throws IOException {
        try {
            this.getStatementSets(filePath, true);
            return this.dbdName != null && this.accessType != null;
        }
        catch (ImporterException importerException) {
            return false;
        }
    }

    public ArrayList<StatementSet> getStatementSet(String filePath) throws IOException, ImporterException {
        return this.getStatementSets(filePath, false);
    }

    public ArrayList<StatementSet> getStatementSets(ByteArrayOutputStream outStream, String fileName, boolean quickParse) throws IOException, ImporterException {
        ByteArrayInputStream in = new ByteArrayInputStream(outStream.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        BufferedReader bufReader = new BufferedReader(reader);
        ArrayList<StatementSet> retVal = this.getStatementSetsNew(bufReader, fileName, quickParse);
        int i = 0;
        while (i < retVal.size()) {
            StatementSet sSet = retVal.get(i);
            sSet.contents = outStream;
            ++i;
        }
        return retVal;
    }

    public ArrayList<StatementSet> getStatementSets(String filePath, boolean quickParse) throws IOException, ImporterException {
        BufferedReader br = this.getBufferedReader(filePath);
        return this.getStatementSetsNew(br, filePath, quickParse);
    }

    private void readNextLine() throws IOException, ImporterException {
        this.prevLine = this.currLine;
        do {
            this.currLine = this.br.readLine();
            if (this.currLine != null) {
                this.bytesRead += this.currLine.length();
            }
            ++this.lineNum;
        } while (this.currLine != null && this.isCurrLineBlank());
        if (this.currLine == null) {
            if (this.parseState == PS.PARSING_NAME) {
                this.parseState = PS.EOF;
            } else {
                Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
                throw new ImporterException(ModelErrorMessages.getModelBundle().getString("CONT_EMPTY", inserts), ImporterException.SEVERITY.SEVERE);
            }
        }
    }

    private boolean isCurrLineBlank() {
        if (this.currLine.isEmpty()) {
            return true;
        }
        char[] line = this.currLine.toCharArray();
        int i = 0;
        while (i < line.length) {
            if (line[i] != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private StatementSet getNextStatementSet() throws ImporterException, IOException {
        if (this.parseState == PS.EOF) {
            return null;
        }
        StatementSet sSet = new StatementSet(this.filePath);
        try {
            this.currIx = 0;
            this.startIx = 0;
            boolean statementSetEnd = false;
            this.bytesRead = 0;
            while (!statementSetEnd && this.parseState != PS.EOF) {
                switch (this.parseState) {
                    case PARSING_NAME: {
                        this.parseName();
                        break;
                    }
                    case PARSING_OPERATION: {
                        this.parseOperation();
                        break;
                    }
                    case PARSING_OPERANDS: {
                        this.parseOperands();
                        break;
                    }
                    case PARSING_QUOTED_VALUE: {
                        this.parseQuotedValue();
                        break;
                    }
                    case PARSING_COMMENTS: {
                        this.parseComments();
                        break;
                    }
                    case CURR_STATEMENT_END: {
                        this.buildStatement(sSet, false);
                        break;
                    }
                    case STATEMENT_SET_END: {
                        this.parseState = PS.PARSING_NAME;
                        statementSetEnd = true;
                        this.readNextLine();
                    }
                }
            }
        }
        catch (ImporterException e) {
            logger.throwing(this.getClass().getName(), "getNextStatementSet()", (Throwable)e);
            throw e;
        }
        return sSet;
    }

    private ArrayList<StatementSet> getStatementSetsNew(BufferedReader br, String filePath, boolean quickParse) throws IOException, ImporterException {
        try {
            try {
                StatementSet sSet = new StatementSet(filePath);
                this.br = br;
                this.filePath = filePath;
                this.parseState = PS.PARSING_NAME;
                this.readNextLine();
                this.currIx = 0;
                this.startIx = 0;
                while (this.parseState != PS.EOF) {
                    switch (this.parseState) {
                        case PARSING_NAME: {
                            this.parseName();
                            break;
                        }
                        case PARSING_OPERATION: {
                            this.parseOperation();
                            break;
                        }
                        case PARSING_OPERANDS: {
                            this.parseOperands();
                            break;
                        }
                        case PARSING_QUOTED_VALUE: {
                            this.parseQuotedValue();
                            break;
                        }
                        case PARSING_COMMENTS: {
                            this.parseComments();
                            break;
                        }
                        case CURR_STATEMENT_END: {
                            this.buildStatement(sSet, quickParse);
                            break;
                        }
                        case STATEMENT_SET_END: {
                            sSet = new StatementSet(filePath);
                            this.startIx = 0;
                            this.currIx = 0;
                            this.parseState = PS.PARSING_NAME;
                            this.readNextLine();
                        }
                    }
                }
            }
            catch (ImporterException e) {
                logger.throwing(this.getClass().getName(), "getStatementSets()", (Throwable)e);
                throw e;
            }
        }
        finally {
            br.close();
        }
        if (quickParse) {
            return null;
        }
        return this.statementSets;
    }

    private void parseComments() throws ImporterException, IOException {
        int currLineLength = this.currLine.length();
        boolean isContinued = currLineLength > 71 && this.currLine.charAt(71) != ' ';
        this.moveToFirstCharOfComments();
        if (this.currIx == currLineLength) {
            this.currIx = 0;
            this.startIx = 0;
            this.parseState = PS.PARSING_NAME;
            this.readNextLine();
            return;
        }
        if (isContinued) {
            this.currIx = 0;
            this.startIx = 0;
            this.br.mark(72);
            this.currLine = this.br.readLine();
            if (this.isCurrLineBlank()) {
                this.parseState = PS.CURR_STATEMENT_END;
            }
            this.br.reset();
            this.readNextLine();
            return;
        }
        this.currIx = 0;
        this.startIx = 0;
        this.parseState = PS.CURR_STATEMENT_END;
    }

    private void buildStatement(StatementSet sSet, boolean quickParse) throws IOException, ImporterException {
        if (quickParse) {
            this.handleQuickLine(this.statementBuf);
            this.parseState = PS.EOF;
        } else {
            Statement stat = this.handleLine(this.statementBuf);
            if (stat != null) {
                sSet.statements.addElement(stat);
                ++sSet.size;
                if (stat.type.equals("END")) {
                    this.parseState = PS.STATEMENT_SET_END;
                } else {
                    this.startIx = 0;
                    this.currIx = 0;
                    this.parseState = PS.PARSING_NAME;
                    if (this.currLine != null && this.prevLine != null && this.prevLine.trim().isEmpty() && !stat.type.equals("DBDGEN")) {
                        this.br.mark(0);
                    } else {
                        this.readNextLine();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseQuotedValue() throws IOException, ImporterException {
        boolean isContinued;
        int currLineLength = this.currLine.length();
        boolean bl = isContinued = currLineLength > 71 && this.currLine.charAt(71) != ' ';
        if (this.startIx == 0) {
            this.moveToFirstCharOfOperands();
            this.startIx = this.currIx;
        }
        while (this.currIx < currLineLength && this.currIx < 71) {
            char currChar = this.currLine.charAt(this.currIx);
            if (currChar == '\'') {
                if (this.currIx + 1 >= currLineLength) {
                    this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx);
                    this.startIx = 0;
                    this.currIx = 0;
                    this.parseState = PS.CURR_STATEMENT_END;
                    return;
                }
                if (this.currLine.charAt(this.currIx + 1) == '\'') {
                    ++this.currIx;
                } else {
                    if (this.currIx == 70) {
                        if (isContinued) {
                            this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, 71);
                            this.parseState = PS.PARSING_OPERANDS;
                            this.startIx = 0;
                            this.currIx = 0;
                            this.readNextLine();
                            return;
                        }
                        this.statementBuf = currLineLength > 71 ? String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, 71) : String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx);
                        this.parseState = PS.CURR_STATEMENT_END;
                        this.startIx = 0;
                        this.currIx = 0;
                        return;
                    }
                    ++this.currIx;
                    if (this.currIx < currLineLength) {
                        this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, this.currIx);
                        this.startIx = this.currIx;
                        this.parseState = PS.PARSING_OPERANDS;
                        return;
                    }
                    this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx);
                    this.startIx = 0;
                    this.currIx = 0;
                    this.parseState = PS.CURR_STATEMENT_END;
                    return;
                }
            }
            ++this.currIx;
        }
        if (!isContinued) {
            Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("INCOMPLETE_QUOTED_VALUE", inserts), ImporterException.SEVERITY.SEVERE);
        }
        this.statementBuf = currLineLength > 71 ? String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, 71) : String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx);
        int bufLen = this.statementBuf.length();
        int i = bufLen - 1;
        while (i > 0) {
            char currChar = this.statementBuf.charAt(i);
            if (currChar != ' ') {
                if (i >= bufLen - 2) break;
                this.statementBuf = this.statementBuf.substring(0, i + 2);
                break;
            }
            --i;
        }
        this.startIx = 0;
        this.currIx = 0;
        this.readNextLine();
    }

    private void parseName() throws IOException, ImporterException {
        if (this.currLine == null) {
            this.parseState = PS.EOF;
            this.readNextLine();
            return;
        }
        if (this.currLine.length() == 0) {
            this.readNextLine();
            return;
        }
        char c = this.currLine.charAt(0);
        if (Character.isWhitespace(c)) {
            this.statementBuf = " ";
            this.currIx = 1;
            this.startIx = 1;
            this.parseState = PS.PARSING_OPERATION;
            return;
        }
        if (Character.isLetterOrDigit(c)) {
            int blankIx = this.currLine.indexOf(32);
            if (blankIx + 1 > 63) {
                Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
                throw new ImporterException(ModelErrorMessages.getModelBundle().getString("SYMBOL_TOO_LONG", inserts), ImporterException.SEVERITY.SEVERE);
            }
            if (blankIx == -1) {
                Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
                throw new ImporterException(ModelErrorMessages.getModelBundle().getString("INVALID_LINE", inserts), ImporterException.SEVERITY.SEVERE);
            }
            this.statementBuf = this.currLine.substring(0, blankIx) + " ";
            this.startIx = this.currIx = blankIx + 1;
            this.parseState = PS.PARSING_OPERATION;
        } else {
            this.readNextLine();
        }
    }

    private void parseOperation() throws ImporterException, IOException {
        int currLineLength = this.currLine.length();
        this.currIx = this.startIx;
        while (this.currIx < currLineLength) {
            if (this.currLine.charAt(this.currIx) != ' ') {
                this.startIx = this.currIx;
                break;
            }
            ++this.currIx;
        }
        if (this.currIx == this.currLine.length() || this.currIx > 71) {
            this.startIx = 0;
            this.currIx = 0;
            this.parseState = PS.PARSING_NAME;
            this.readNextLine();
            return;
        }
        this.startIx = this.currIx;
        while (this.currIx < this.currLine.length()) {
            if (this.currLine.charAt(this.currIx) == ' ') break;
            ++this.currIx;
        }
        if (this.currIx - this.startIx > 63) {
            Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("SYMBOL_TOO_LONG", inserts), ImporterException.SEVERITY.SEVERE);
        }
        this.currOperation = this.currLine.substring(this.startIx, this.currIx);
        this.startIx = this.currIx;
        this.moveToFirstCharOfOperands();
        if (this.currIx >= currLineLength || this.currIx >= 71) {
            boolean isContinued;
            boolean bl = isContinued = currLineLength > 71 && this.currLine.charAt(71) != ' ';
            if (isContinued) {
                this.statementBuf = String.valueOf(this.statementBuf) + this.currOperation + " ";
                this.startIx = 0;
                this.currIx = 0;
                this.parseState = PS.PARSING_OPERANDS;
                this.readNextLine();
                return;
            }
            this.statementBuf = String.valueOf(this.statementBuf) + this.currOperation;
            this.startIx = 0;
            this.currIx = 0;
            this.parseState = PS.CURR_STATEMENT_END;
            return;
        }
        this.statementBuf = String.valueOf(this.statementBuf) + this.currOperation + " ";
        this.startIx = this.currIx;
        this.parseState = PS.PARSING_OPERANDS;
    }

    private void moveToFirstCharOfOperands() throws ImporterException {
        this.currIx = this.startIx;
        while (this.currIx < this.currLine.length() && this.currIx < 71) {
            if (this.currLine.charAt(this.currIx) != ' ') break;
            ++this.currIx;
        }
        if (this.startIx == 0) {
            if (this.currLine.charAt(0) != ' ') {
                Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
                throw new ImporterException(ModelErrorMessages.getModelBundle().getString("CONT_FMTERR", inserts), ImporterException.SEVERITY.SEVERE);
            }
            if (this.currIx < 15) {
                Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
                throw new ImporterException(ModelErrorMessages.getModelBundle().getString("CONT_WRONG_COLUMN", inserts), ImporterException.SEVERITY.SEVERE);
            }
        }
    }

    private void moveToFirstCharOfComments() throws ImporterException {
        this.currIx = this.startIx;
        while (this.currIx < this.currLine.length()) {
            if (this.currLine.charAt(this.currIx) != ' ') break;
            ++this.currIx;
        }
        if (this.startIx == 0) {
            if (this.currLine.isEmpty()) {
                this.startIx = 0;
                this.currIx = 0;
                this.parseState = PS.CURR_STATEMENT_END;
                return;
            }
            if (this.currLine.charAt(0) != ' ') {
                Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
                throw new ImporterException(ModelErrorMessages.getModelBundle().getString("CONT_FMTERR", inserts), ImporterException.SEVERITY.SEVERE);
            }
            if (this.currIx != 16) {
                Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
                throw new ImporterException(ModelErrorMessages.getModelBundle().getString("CONT_COMMENT_WRONG_COLUMN", inserts), ImporterException.SEVERITY.SEVERE);
            }
        }
    }

    private void parseOperands() throws ImporterException, IOException {
        boolean isContinued;
        int currLineLength = this.currLine.length();
        boolean bl = isContinued = currLineLength > 71 && this.currLine.charAt(71) != ' ';
        if (this.startIx == 0) {
            this.moveToFirstCharOfOperands();
            this.startIx = this.currIx;
        }
        while (this.currIx < currLineLength && this.currIx < 71) {
            char currChar = this.currLine.charAt(this.currIx);
            if (currChar == '\'') {
                ++this.currIx;
                if (currLineLength == this.currIx) {
                    Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
                    throw new ImporterException(ModelErrorMessages.getModelBundle().getString("CONT_FMTERR", inserts), ImporterException.SEVERITY.SEVERE);
                }
                this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, this.currIx);
                this.startIx = this.currIx;
                this.parseState = PS.PARSING_QUOTED_VALUE;
                return;
            }
            if (currChar == ' ') {
                if (isContinued) {
                    if (this.currLine.charAt(this.currIx - 1) == ',') {
                        this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, this.currIx);
                        this.startIx = 0;
                        this.currIx = 0;
                        this.readNextLine();
                        return;
                    }
                    this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, this.currIx);
                    this.parseState = PS.PARSING_COMMENTS;
                    this.startIx = this.currIx;
                    return;
                }
                this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, this.currIx);
                this.parseState = PS.CURR_STATEMENT_END;
                return;
            }
            ++this.currIx;
        }
        if (isContinued) {
            this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, 71);
            this.startIx = 0;
            this.currIx = 0;
            this.readNextLine();
            return;
        }
        if (this.currIx == 71) {
            if (this.currLine.charAt(this.currIx - 1) == ',') {
                Object[] inserts = new Object[]{this.currLine, this.prevLine, this.filePath};
                throw new ImporterException(ModelErrorMessages.getModelBundle().getString("CONT_FMTERR", inserts), ImporterException.SEVERITY.SEVERE);
            }
            this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx, 71);
            this.parseState = PS.CURR_STATEMENT_END;
            return;
        }
        this.statementBuf = String.valueOf(this.statementBuf) + this.currLine.substring(this.startIx);
        this.parseState = PS.CURR_STATEMENT_END;
    }

    private BufferedReader getBufferedReader(String filePath) throws FileNotFoundException {
        return new BufferedReader(new FileReader(filePath));
    }

    private Statement handleLine(String line) {
        Statement stat = new Statement();
        stat.count = 0;
        ImsTokenizer it = new ImsTokenizer(line);
        try {
            String s = it.nextToken();
            if (line.charAt(0) != ' ') {
                stat.label = s;
                stat.type = s = it.nextToken();
            } else {
                stat.type = s;
            }
            s = it.nextToken();
            do {
                if (s.indexOf(61) == -1) {
                    p = new Parameter(false, 0, s, "");
                    stat.params[stat.count++] = p;
                } else {
                    p = new Parameter(false, 1, s.substring(0, s.indexOf(61)), s.substring(s.indexOf(61) + 1, s.length()));
                    stat.params[stat.count++] = p;
                }
                s = it.nextToken();
            } while (it.previousSeparator() != ' ');
            throw new NoSuchElementException();
        }
        catch (NoSuchElementException noSuchElementException) {
            try {
                if (stat.type.equalsIgnoreCase("FLD")) {
                    stat.type = "FIELD";
                } else if (stat.type.equalsIgnoreCase("FLDK")) {
                    stat.type = "FIELD";
                    stat.params[0].value = "(" + stat.params[0].value + ",SEQ)";
                }
                return stat;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
    }

    private boolean handleQuickLine(String line) {
        String s;
        boolean done;
        ImsTokenizer it;
        String temp;
        block9: {
            temp = null;
            it = new ImsTokenizer(line);
            done = false;
            s = it.nextToken();
            if (line.charAt(0) == ' ' || s.equalsIgnoreCase("DBD") || (s = it.nextToken()).equalsIgnoreCase("DBD")) break block9;
            return false;
        }
        try {
            s = it.nextToken();
            while (true) {
                if (s.indexOf(61) != -1) {
                    if (s.substring(0, s.indexOf(61)).equalsIgnoreCase("NAME")) {
                        this.dbdName = s.substring(s.indexOf(61) + 1, s.length());
                    } else if (s.substring(0, s.indexOf(61)).equalsIgnoreCase("ACCESS")) {
                        temp = s.substring(s.indexOf(61) + 1, s.length());
                        this.accessType = this.parseAccess(temp);
                        done = true;
                    }
                }
                if (!done) {
                    s = it.nextToken();
                    continue;
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return done;
    }

    private String parseAccess(String temp) {
        String accessType = null;
        accessType = temp.indexOf(",") == -1 ? (temp.indexOf("(") == -1 ? temp : temp.substring(1, temp.length() - 1)) : temp.substring(1, temp.indexOf(44));
        return accessType;
    }

    public String getDbdName() {
        return this.dbdName;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public long getLineNum() {
        return this.lineNum;
    }

    public String getFilePath() {
        return this.filePath;
    }

    private static enum PS {
        PARSING_NAME,
        PARSING_OPERATION,
        PARSING_OPERANDS,
        PARSING_QUOTED_VALUE,
        PARSING_COMMENTS,
        CURR_STATEMENT_END,
        STATEMENT_SET_END,
        EOF;

    }
}

