/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ModelErrorMessages;
import com.ibm.im.ims.workbench.model.utilities.Parameter;
import com.ibm.im.ims.workbench.model.utilities.SubParm;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Statement {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public String label = null;
    public String type = null;
    public Parameter[] params = new Parameter[100];
    public int count = 0;

    public String getStatementContents() {
        Object retVal = this.label != null ? this.label : "";
        retVal = (String)retVal + " " + this.type + " ";
        retVal = (String)retVal + this.params[0].getParameterContents();
        int i = 1;
        while (i < this.count) {
            retVal = (String)retVal + "," + this.params[i].getParameterContents();
            ++i;
        }
        return retVal;
    }

    public List<String> getSRCHParameters(String aParam, boolean throwIfNull) throws ImporterException {
        ArrayList<String> strList = new ArrayList<String>();
        List<String> tempParms = this.getExitParameters(aParam, throwIfNull);
        Object searchField = "";
        boolean nextField = true;
        int j = 0;
        while (j < tempParms.size()) {
            Object parm = tempParms.get(j);
            if (Utility.isStringNumeric((String)parm)) {
                nextField = false;
                parm = "," + (String)parm;
            } else {
                nextField = true;
            }
            if (nextField && !((String)searchField).isEmpty()) {
                if (((String)searchField).contains(",")) {
                    searchField = "(" + (String)searchField + ")";
                }
                strList.add((String)searchField);
                searchField = "";
            }
            searchField = (String)searchField + (String)parm;
            ++j;
        }
        if (tempParms.size() > 0) {
            if (((String)searchField).contains(",")) {
                searchField = "(" + (String)searchField + ")";
            }
            strList.add((String)searchField);
        } else {
            strList = null;
        }
        return strList;
    }

    public List<String> getExitParameters(String aParam, boolean throwIfNull) throws ImporterException {
        List<String> strList = new ArrayList<String>();
        Parameter tParm = null;
        int i = 0;
        while (i < this.count) {
            if (this.params[i].keyword.equals(aParam)) {
                tParm = this.params[i];
                break;
            }
            ++i;
        }
        if (throwIfNull && tParm == null) {
            Object[] inserts = new Object[]{aParam, this.type, "Statement.getParameterByName"};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("PARAM_NOFND", inserts), ImporterException.SEVERITY.WARNING);
        }
        if (tParm != null) {
            strList = Statement.parseExitSubParms(tParm.value);
        }
        if (throwIfNull && strList == null) {
            Object[] inserts = new Object[]{aParam, tParm.value, "Statement.getParameterByName"};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("PARAM_NOPARSE", inserts), ImporterException.SEVERITY.WARNING);
        }
        return strList;
    }

    public SubParm[] getParameterByName(String aParam, boolean throwIfNull) throws ImporterException {
        Parameter tParm = null;
        SubParm[] subParms = null;
        int i = 0;
        while (i < this.count) {
            if (this.params[i].keyword.equals(aParam)) {
                tParm = this.params[i];
                break;
            }
            ++i;
        }
        if (throwIfNull && tParm == null) {
            Object[] inserts = new Object[]{aParam, this.type, "Statement.getParameterByName"};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("PARAM_NOFND", inserts), ImporterException.SEVERITY.WARNING);
        }
        if (this.type.equals("XDFLD") && (aParam.equals("CONST") || aParam.equals("NULLVAL"))) {
            if (tParm == null) {
                subParms = null;
            } else {
                SubParm[] pArray = new SubParm[2];
                String[] strArray = new String[20];
                strArray[0] = tParm.value;
                pArray[0] = new SubParm(strArray, 1);
                subParms = pArray;
            }
        } else if (tParm != null) {
            subParms = Statement.parseSubParms(tParm.value);
        }
        if (throwIfNull && subParms == null) {
            Object[] inserts = new Object[]{aParam, tParm.value, "Statement.getParameterByName"};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("PARAM_NOPARSE", inserts), ImporterException.SEVERITY.WARNING);
        }
        return subParms;
    }

    public String getParameterTokenByName(String aParam, int sp, int tok, boolean throwIfNull) throws ImporterException {
        SubParm[] subParms = this.getParameterByName(aParam, throwIfNull);
        String result = subParms != null && sp < 2 && subParms[sp] != null && tok < subParms[sp].tokens.length ? subParms[sp].tokens[tok] : null;
        if (result == null && throwIfNull) {
            Object[] inserts = new Object[]{aParam, String.valueOf(sp), String.valueOf(tok), "getParameterTokenByName"};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("TOK_NULL", inserts), ImporterException.SEVERITY.WARNING);
        }
        return result;
    }

    public static List<String> parseExitSubParms(String aParam) throws ImporterException {
        ArrayList<String> strList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(aParam, "(),", true);
        boolean insideCascade = false;
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("(")) {
                token = st.nextToken();
                if (token.equals("(")) continue;
                if (token.equals("CASCADE")) {
                    strList.add(count, "(");
                    strList.add(count + 1, "CASCADEOPTIONS");
                    count += 2;
                    insideCascade = true;
                    continue;
                }
                if (token.equals("NOCASCADE")) {
                    strList.add(count, "(");
                    strList.add(count + 1, "NOCASCADEOPTIONS");
                    count += 2;
                    insideCascade = true;
                    continue;
                }
                strList.add(count, token);
                ++count;
                continue;
            }
            if (token.equals(")")) {
                if (!insideCascade) continue;
                strList.add(count, ")");
                insideCascade = false;
                ++count;
                continue;
            }
            if (token.equals(",")) continue;
            strList.add(count, token);
            ++count;
        }
        if (strList.size() == 0) {
            return null;
        }
        return strList;
    }

    public static SubParm[] parseSubParms(String aParam) throws ImporterException {
        boolean commaSw;
        String token;
        SubParm[] pArray = new SubParm[2];
        String[] strArray = new String[20];
        if (aParam.startsWith("'")) {
            strArray[0] = Statement.scrubSingleQuotes(aParam.substring(1, aParam.length() - 1));
            pArray[0] = new SubParm(strArray, 1);
            return pArray;
        }
        int parenCount = 0;
        int maxParenCount = 0;
        StringTokenizer st = new StringTokenizer(aParam, "(),", true);
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals("(")) {
                if (++parenCount <= maxParenCount) continue;
                maxParenCount = parenCount;
                continue;
            }
            if (!token.equals(")")) continue;
            commaSw = false;
            if (--parenCount >= 0) continue;
            Object[] inserts = new Object[]{aParam, "1", "Statement.parseSubParms"};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("PARAM_INVLD_PAREN", inserts), ImporterException.SEVERITY.WARNING);
        }
        if (maxParenCount > 2) {
            Object[] inserts = new Object[]{aParam, "Statement.parseSubParms"};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("PARAM_TOOMAN_PAREN", inserts), ImporterException.SEVERITY.WARNING);
        }
        if (maxParenCount == 0) {
            st = new StringTokenizer(aParam, "'(),", true);
            int count = 0;
            if (st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equals("'")) {
                    strArray[0] = token = st.nextToken("'");
                    ++count;
                } else {
                    if (token.equals(",") || token.equals("(") || token.equals(")")) {
                        Object[] inserts = new Object[]{aParam, "2", "Statement.parseSubParms"};
                        throw new ImporterException(ModelErrorMessages.getModelBundle().getString("PARAM_INVLD_PAREN", inserts), ImporterException.SEVERITY.WARNING);
                    }
                    strArray[0] = token;
                    ++count;
                }
            }
            if (count > 0) {
                pArray[0] = new SubParm(strArray, 1);
            }
            if (pArray[0] == null && pArray[1] == null) {
                return null;
            }
            return pArray;
        }
        if (maxParenCount == 1) {
            st = new StringTokenizer(aParam, "(),", true);
            commaSw = false;
            boolean lParenSw = false;
            boolean quote = false;
            int i = 0;
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equals("'")) {
                    quote = true;
                    continue;
                }
                if (token.equals(",") && !quote) {
                    if (commaSw) {
                        strArray[i++] = null;
                    }
                    commaSw = true;
                    if (lParenSw) {
                        strArray[i++] = null;
                    }
                    lParenSw = false;
                    quote = false;
                    continue;
                }
                if (token.equals("(")) {
                    commaSw = false;
                    lParenSw = true;
                    continue;
                }
                if (token.equals(")")) {
                    commaSw = false;
                    lParenSw = false;
                    continue;
                }
                commaSw = false;
                lParenSw = false;
                strArray[i++] = token;
            }
            pArray[0] = new SubParm(strArray, i);
            if (pArray[0] == null && pArray[1] == null) {
                return null;
            }
            return pArray;
        }
        if (maxParenCount == 2) {
            st = new StringTokenizer(aParam, "(),", true);
            parenCount = 0;
            int j = 0;
            do {
                strArray = new String[20];
                int i = 0;
                commaSw = false;
                boolean lParenSw = false;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.equals("(")) {
                        ++parenCount;
                        commaSw = false;
                        lParenSw = true;
                        continue;
                    }
                    if (token.equals(")")) {
                        --parenCount;
                        commaSw = false;
                        lParenSw = false;
                        break;
                    }
                    if (token.equals(",")) {
                        if (commaSw) {
                            strArray[i++] = null;
                        }
                        commaSw = true;
                        if (lParenSw && parenCount == 1) {
                            lParenSw = false;
                            break;
                        }
                        if (!lParenSw || parenCount != 2) continue;
                        lParenSw = false;
                        strArray[i++] = null;
                        continue;
                    }
                    commaSw = false;
                    lParenSw = false;
                    strArray[i++] = token;
                }
                pArray[j] = i > 0 ? new SubParm(strArray, i) : null;
            } while (++j <= 1);
            if (pArray[0] == null && pArray[1] == null) {
                return null;
            }
            return pArray;
        }
        return null;
    }

    private static String scrubSingleQuotes(String quotedStr) {
        int length = quotedStr.length();
        char[] charArray = quotedStr.toCharArray();
        int i = 0;
        while (i < length) {
            char c = charArray[i];
            if (c == '\'' && i + 1 < length && charArray[i + 1] == '\'') {
                int j = i + 1;
                while (j < length) {
                    charArray[j - 1] = charArray[j];
                    ++j;
                }
                --length;
            }
            ++i;
        }
        char[] retVal = new char[length];
        int i2 = 0;
        while (i2 < retVal.length) {
            retVal[i2] = charArray[i2];
            ++i2;
        }
        return new String(retVal);
    }

    public String getParameterByNameAsString(String aParam, boolean throwIfNull) throws ImporterException {
        Parameter tParm = null;
        int i = 0;
        while (i < this.count) {
            if (this.params[i].keyword.equals(aParam)) {
                tParm = this.params[i];
                break;
            }
            ++i;
        }
        if (throwIfNull && tParm == null) {
            Object[] inserts = new Object[]{aParam, this.type, "getParameterByNameAsString"};
            throw new ImporterException(ModelErrorMessages.getModelBundle().getString("PARAM_NOFND", inserts), ImporterException.SEVERITY.WARNING);
        }
        if (tParm == null) {
            return null;
        }
        return tParm.value;
    }
}

