/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.metadata.dbd.AlteredCaseType;
import com.ibm.im.ims.metadata.dbd.AlteredFieldType;
import com.ibm.im.ims.metadata.dbd.AlteredMapType;
import com.ibm.im.ims.metadata.dbd.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.dbd.DatatypeType;
import com.ibm.im.ims.metadata.dbd.DependingOnFieldValueType;
import com.ibm.im.ims.metadata.dbd.FieldType;
import com.ibm.im.ims.metadata.dbd.MappingCaseType;
import com.ibm.im.ims.metadata.dbd.MappingType;
import com.ibm.im.ims.metadata.dbd.MarshallerType;
import com.ibm.im.ims.metadata.dbd.PhysicalDatatypeType;
import com.ibm.im.ims.metadata.dbd.PropertyType;
import com.ibm.im.ims.metadata.dbd.RemovedCaseType;
import com.ibm.im.ims.metadata.dbd.RemovedFieldType;
import com.ibm.im.ims.metadata.dbd.RemovedMapType;
import com.ibm.im.ims.metadata.dbd.SegmentDifferences;
import com.ibm.im.ims.metadata.dbd.ValueDatatypeType;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.controller.compare.ModelCompareException;
import com.ibm.im.ims.workbench.controller.compare.SegmentCompare;
import com.ibm.im.ims.workbench.model.AlteredRemarksMappingCaseModel;
import com.ibm.im.ims.workbench.model.AlteredRemarksMappingModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SegmentDDLGenerator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015-2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ArrayList<String> topLevelAlterOptionsStmts = new ArrayList();
    private ArrayList<String> topLevelCommentStmts = new ArrayList();
    private static String CR = System.getProperty("line.separator");
    private static String TAB = "    ";
    public static final String END = ";";
    private static final String QUOTE = "\"";
    private SegmentCompare segmentCompare;
    private SegmentDifferences segmentDifferences;
    private String segmentName;
    private String dbdName;
    private DBDConstants dbdAccessType;

    public SegmentDDLGenerator(SegmentCompare segmentCompare, String dbdName, DBDConstants dbdAccessType) {
        this.segmentCompare = segmentCompare;
        this.segmentDifferences = segmentCompare.getSegmentDifferences();
        this.segmentName = this.segmentDifferences.getSegmentName();
        this.dbdName = dbdName;
        this.dbdAccessType = dbdAccessType;
    }

    public String doGen() throws ModelCompareException {
        return this.genAlteredSegmentStmt() + this.genCommentOnSegmentStmt();
    }

    private String genCommentOnSegmentStmt() {
        ArrayList<AlteredRemarksMappingModel> alteredRemarksMappingModel;
        ArrayList<MappingType> createdRemarksMappingModel;
        Object commentOnSegmentStmt = "";
        ArrayList<FieldType> alteredRemarksUFields = this.segmentCompare.getAlteredRemarksUFields();
        if (alteredRemarksUFields != null) {
            for (FieldType alteredField : alteredRemarksUFields) {
                this.genCommentOnUFieldStmt(alteredField);
            }
        }
        if ((createdRemarksMappingModel = this.segmentCompare.getCreatedMapswRemarks()) != null) {
            for (MappingType createdMap : createdRemarksMappingModel) {
                this.genCommentOnCreatedMapStmt(createdMap);
            }
        }
        if ((alteredRemarksMappingModel = this.segmentCompare.getAlteredMapswRemarks()) != null) {
            for (AlteredRemarksMappingModel alteredMap : alteredRemarksMappingModel) {
                this.genCommentOnAlteredMapStmt(alteredMap);
            }
        }
        if (!this.topLevelCommentStmts.isEmpty()) {
            int i = 0;
            while (i < this.topLevelCommentStmts.size()) {
                commentOnSegmentStmt = i == 0 ? (String)commentOnSegmentStmt + this.topLevelCommentStmts.get(i) : (String)commentOnSegmentStmt + END + CR + this.topLevelCommentStmts.get(i);
                ++i;
            }
            commentOnSegmentStmt = (String)commentOnSegmentStmt + END + CR + CR;
        }
        return commentOnSegmentStmt;
    }

    private void genCommentOnUFieldStmt(FieldType fieldType) {
        String fieldName = fieldType.getName();
        if (fieldType.getRemarks() != null) {
            String commentOnUFieldStmt = "COMMENT ON COLUMN " + this.segmentName + "." + fieldName + " IN " + this.dbdName + " IS " + CR + TAB + "'" + fieldType.getRemarks() + "'";
            this.topLevelCommentStmts.add(commentOnUFieldStmt);
        }
    }

    private void genCommentOnAlteredMapStmt(AlteredRemarksMappingModel alteredRemarksMappingModel) {
        String mapName = alteredRemarksMappingModel.getMappingType().getName();
        if (alteredRemarksMappingModel.isAlteredRemarks()) {
            String commentOnMapStmt = "COMMENT ON MAP " + this.segmentName + "." + mapName + " IN " + this.dbdName + " IS " + CR + TAB + "'" + alteredRemarksMappingModel.getMappingType().getRemarks() + "'";
            this.topLevelCommentStmts.add(commentOnMapStmt);
        }
        ArrayList<AlteredRemarksMappingCaseModel> alteredRemarksMappingCaseModel = alteredRemarksMappingModel.getCases();
        int i = 0;
        while (i < alteredRemarksMappingCaseModel.size()) {
            this.genCommentOnAlteredCaseStmt(mapName, (AlteredRemarksMappingCaseModel)alteredRemarksMappingCaseModel.get(i));
            ++i;
        }
    }

    private void genCommentOnAlteredCaseStmt(String mapName, AlteredRemarksMappingCaseModel alteredRemarksMappingCaseModel) {
        String caseName = alteredRemarksMappingCaseModel.getMappingCaseType().getName();
        if (alteredRemarksMappingCaseModel.isAlteredRemarks()) {
            String commentOnCaseStmt = "COMMENT ON CASE " + this.segmentName + "." + mapName + "." + caseName + " IN " + this.dbdName + " IS " + CR + TAB + "'" + alteredRemarksMappingCaseModel.getMappingCaseType().getRemarks() + "'";
            this.topLevelCommentStmts.add(commentOnCaseStmt);
        }
        List<FieldType> alteredRemarksField = alteredRemarksMappingCaseModel.getMappingCaseType().getField();
        for (FieldType alteredField : alteredRemarksField) {
            this.genCommentOnFieldStmt(mapName, caseName, alteredField);
        }
    }

    private void genCommentOnCreatedMapStmt(MappingType CreatedRemarksMappingModel) {
        String mapName = CreatedRemarksMappingModel.getName();
        if (CreatedRemarksMappingModel.getRemarks() != null && !CreatedRemarksMappingModel.getRemarks().isEmpty()) {
            String commentOnMapStmt = "COMMENT ON MAP " + this.segmentName + "." + mapName + " IN " + this.dbdName + " IS " + CR + TAB + "'" + CreatedRemarksMappingModel.getRemarks() + "'";
            this.topLevelCommentStmts.add(commentOnMapStmt);
        }
        List<MappingCaseType> createdRemarksMappingCaseModel = CreatedRemarksMappingModel.getCase();
        for (MappingCaseType createdCase : createdRemarksMappingCaseModel) {
            if (createdCase.getRemarks() == null || createdCase.getRemarks().isEmpty()) continue;
            this.genCommentOnCreatedCaseStmt(mapName, createdCase);
        }
    }

    private void genCommentOnCreatedCaseStmt(String mapName, MappingCaseType CaseRemarksMappingCaseModel) {
        String caseName = CaseRemarksMappingCaseModel.getName();
        if (CaseRemarksMappingCaseModel.getRemarks() != null && !CaseRemarksMappingCaseModel.getRemarks().isEmpty()) {
            String commentOnCaseStmt = "COMMENT ON CASE " + this.segmentName + "." + mapName + "." + caseName + " IN " + this.dbdName + " IS " + CR + TAB + "'" + CaseRemarksMappingCaseModel.getRemarks() + "'";
            this.topLevelCommentStmts.add(commentOnCaseStmt);
        }
        List<FieldType> createdRemarksField = CaseRemarksMappingCaseModel.getField();
        for (FieldType createdField : createdRemarksField) {
            this.genCommentOnFieldStmt(mapName, caseName, createdField);
        }
    }

    private void genCommentOnFieldStmt(String mapName, String caseName, FieldType fieldType) {
        String fieldName = fieldType.getName();
        if (fieldType.getRemarks() != null) {
            String commentOnFieldStmt = "COMMENT ON COLUMN " + this.segmentName + "." + mapName + "." + caseName + "." + fieldName + " IN " + this.dbdName + " IS " + CR + TAB + "'" + fieldType.getRemarks() + "'";
            this.topLevelCommentStmts.add(commentOnFieldStmt);
        }
    }

    private String genAlteredSegmentStmt() throws ModelCompareException {
        Object alteredSegmentStmt = "";
        Object tableName = this.segmentDifferences.getSegmentName();
        if (tableName == null || ((String)tableName).isEmpty()) {
            ModelCompareException mce = new ModelCompareException("Segment size mismatch.");
            throw mce;
        }
        if (Utility.isQuoteNeeded((String)tableName)) {
            tableName = QUOTE + (String)tableName + QUOTE;
        }
        String alterTableStr = "ALTER TABLE " + (String)tableName + " IN DATABASE " + this.dbdName + CR;
        ArrayList<FieldType> createdUnmappedFields = new ArrayList<FieldType>();
        ArrayList<RemovedFieldType> removedUnmappedFields = new ArrayList<RemovedFieldType>();
        ArrayList<AlteredFieldType> alteredUnmappedFields = new ArrayList<AlteredFieldType>();
        createdUnmappedFields.addAll(this.segmentDifferences.getCreatedFields());
        removedUnmappedFields.addAll(this.segmentDifferences.getRemovedFields());
        alteredUnmappedFields.addAll(this.segmentDifferences.getAlteredFields());
        ArrayList<MappingType> createdMaps = new ArrayList<MappingType>();
        ArrayList<RemovedMapType> removedMaps = new ArrayList<RemovedMapType>();
        ArrayList<AlteredMapType> alteredMaps = new ArrayList<AlteredMapType>();
        createdMaps.addAll(this.segmentDifferences.getCreatedMaps());
        removedMaps.addAll(this.segmentDifferences.getRemovedMaps());
        alteredMaps.addAll(this.segmentDifferences.getAlteredMaps());
        int i = 0;
        while (i < removedUnmappedFields.size()) {
            String droppedUnmappedColStmt = alterTableStr + this.genRemovedUnmappedFieldStmt((RemovedFieldType)removedUnmappedFields.get(i));
            this.topLevelAlterOptionsStmts.add(droppedUnmappedColStmt);
            ++i;
        }
        i = 0;
        while (i < createdUnmappedFields.size()) {
            String createdUnmappedColStmt = alterTableStr + "ADD " + this.genCreatedUnmappedFieldStmt(this.segmentName, (FieldType)createdUnmappedFields.get(i));
            this.topLevelAlterOptionsStmts.add(createdUnmappedColStmt);
            ++i;
        }
        i = 0;
        while (i < alteredUnmappedFields.size()) {
            String alteredUnmappedColStmt = alterTableStr + "ALTER " + this.genCreatedUnmappedFieldStmt(this.segmentName, ((AlteredFieldType)alteredUnmappedFields.get(i)).getNewField());
            this.topLevelAlterOptionsStmts.add(alteredUnmappedColStmt);
            ++i;
        }
        i = 0;
        while (i < removedMaps.size()) {
            String droppedMapStmt = alterTableStr + this.genRemovedMapStmt((RemovedMapType)removedMaps.get(i));
            this.topLevelAlterOptionsStmts.add(droppedMapStmt);
            ++i;
        }
        i = 0;
        while (i < createdMaps.size()) {
            String createdMapStmt = alterTableStr + this.genCreatedMapStmt(this.segmentName, (MappingType)createdMaps.get(i));
            this.topLevelAlterOptionsStmts.add(createdMapStmt);
            ++i;
        }
        i = 0;
        while (i < alteredMaps.size()) {
            this.genAlteredMapStmt(this.segmentName, (AlteredMapType)alteredMaps.get(i), alterTableStr);
            ++i;
        }
        if (!this.topLevelAlterOptionsStmts.isEmpty()) {
            i = 0;
            while (i < this.topLevelAlterOptionsStmts.size()) {
                alteredSegmentStmt = i == 0 ? (String)alteredSegmentStmt + this.topLevelAlterOptionsStmts.get(i) : (String)alteredSegmentStmt + CR + this.topLevelAlterOptionsStmts.get(i);
                ++i;
            }
            alteredSegmentStmt = (String)alteredSegmentStmt + CR + CR;
        } else {
            alteredSegmentStmt = "";
        }
        LinkedHashMap<String, String> attributes = this.segmentCompare.getAlteredAttributes();
        if (!attributes.isEmpty()) {
            alteredSegmentStmt = (String)alteredSegmentStmt + "ALTER TABLE " + (String)tableName + " IN DATABASE " + this.dbdName + CR;
            Set<Map.Entry<String, String>> keys = attributes.entrySet();
            Iterator<Map.Entry<String, String>> iter = keys.iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> current = iter.next();
                String key = current.getKey();
                String value = current.getValue();
                alteredSegmentStmt = (String)alteredSegmentStmt + TAB + key + " " + value + (iter.hasNext() ? CR : END);
            }
            alteredSegmentStmt = (String)alteredSegmentStmt + CR + CR;
        }
        return alteredSegmentStmt;
    }

    private String genCreatedUnmappedFieldStmt(String segmentName, FieldType fieldType) {
        String unmappedColStmt = null;
        if (!fieldType.getName().isEmpty()) {
            String columnDefinition = SegmentDDLGenerator.addFieldNAME(fieldType) + " " + this.genColumnSyntax(fieldType, "");
            unmappedColStmt = "COLUMN " + columnDefinition;
        }
        return unmappedColStmt + END;
    }

    private String genRemovedUnmappedFieldStmt(RemovedFieldType removedFieldType) {
        return TAB + "DROP COLUMN " + removedFieldType.getExternalName() + " RESTRICT;";
    }

    private String genCreatedMapStmt(String segmentName, MappingType mappingType) {
        String dependingOnField;
        String mapName = mappingType.getName();
        String mapDefinition = null;
        if (mapName != null & (dependingOnField = mappingType.getDependingOnField()) != null) {
            mapDefinition = TAB + "ADD MAP " + dependingOnField + " AS " + mapName + " (" + CR;
            ArrayList<MappingCaseType> createdCases = new ArrayList<MappingCaseType>();
            createdCases.addAll(mappingType.getCase());
            int i = 0;
            while (i < createdCases.size()) {
                String caseStr = TAB + TAB + this.genCreatedCaseForNewMapStmt(mapName, (MappingCaseType)createdCases.get(i));
                mapDefinition = i == 0 ? mapDefinition + caseStr : mapDefinition + "," + CR + caseStr;
                ++i;
            }
            mapDefinition = mapDefinition + ");";
        }
        return mapDefinition;
    }

    private void genAlteredMapStmt(String segmentName, AlteredMapType alteredMapType, String alterTableStr) {
        String dependingOnField;
        String mapName = alteredMapType.getMapName();
        if (mapName != null & (dependingOnField = alteredMapType.getControlField()) != null) {
            this.topLevelAlterOptionsStmts.add(alterTableStr + TAB + "ALTER MAP " + mapName + " DEPENDINGON " + dependingOnField);
        } else {
            this.topLevelAlterOptionsStmts.add(alterTableStr.substring(0, alterTableStr.length() - TAB.length()));
        }
        ArrayList<MappingCaseType> createdCases = new ArrayList<MappingCaseType>();
        ArrayList<RemovedCaseType> removedCases = new ArrayList<RemovedCaseType>();
        ArrayList<AlteredCaseType> alteredCases = new ArrayList<AlteredCaseType>();
        createdCases.addAll(alteredMapType.getCreatedCases());
        removedCases.addAll(alteredMapType.getRemovedCases());
        alteredCases.addAll(alteredMapType.getAlteredCases());
        int i = 0;
        while (i < removedCases.size()) {
            this.genRemovedCaseStmt(mapName, (RemovedCaseType)removedCases.get(i));
            ++i;
        }
        i = 0;
        while (i < createdCases.size()) {
            this.genCreatedCaseStmt(mapName, (MappingCaseType)createdCases.get(i));
            ++i;
        }
        i = 0;
        while (i < alteredCases.size()) {
            this.genAlteredCaseStmt(mapName, (AlteredCaseType)alteredCases.get(i));
            ++i;
        }
        if (removedCases.size() + createdCases.size() + alteredCases.size() > 0) {
            this.topLevelAlterOptionsStmts.add(END);
        }
    }

    private String genRemovedMapStmt(RemovedMapType removedMapType) {
        return TAB + "DROP MAP " + removedMapType.getMapName() + END;
    }

    private void genCreatedCaseStmt(String mapName, MappingCaseType mappingCaseType) {
        String caseDefinition = null;
        String caseName = mappingCaseType.getName();
        DependingOnFieldValueType dependingOnField = mappingCaseType.getDependingOnFieldValue();
        Object caseId = dependingOnField.getValue();
        ValueDatatypeType caseIdType = dependingOnField.getValueDatatype();
        if (caseName != null) {
            caseId = "'" + (String)caseId + "'";
            if (caseIdType == ValueDatatypeType.X) {
                caseId = "X" + (String)caseId;
            }
            caseDefinition = TAB + "ADD CASE " + (String)caseId + " IN " + mapName + " AS " + caseName;
        }
        this.topLevelAlterOptionsStmts.add(caseDefinition);
        List<Object> createdFields = new ArrayList();
        createdFields = this.getFlatFieldList(mappingCaseType.getField());
        int i = 0;
        while (i < createdFields.size()) {
            String createdCaseColStr = TAB + TAB + "ADD " + this.genCaseColumnStmt(mapName, caseName, (FieldType)createdFields.get(i));
            this.topLevelAlterOptionsStmts.add(createdCaseColStr);
            ++i;
        }
    }

    private String genCreatedCaseForNewMapStmt(String mapName, MappingCaseType mappingCaseType) {
        String caseDefinition = null;
        String caseName = mappingCaseType.getName();
        DependingOnFieldValueType dependingOnField = mappingCaseType.getDependingOnFieldValue();
        Object caseId = dependingOnField.getValue();
        ValueDatatypeType caseIdType = dependingOnField.getValueDatatype();
        if (caseName != null) {
            caseId = "'" + (String)caseId + "'";
            if (caseIdType == ValueDatatypeType.X) {
                caseId = "X" + (String)caseId;
            }
            caseDefinition = TAB + "CASE " + (String)caseId + " AS " + caseName + " (" + CR;
        }
        List<Object> createdFields = new ArrayList();
        createdFields = this.getFlatFieldList(mappingCaseType.getField());
        int i = 0;
        while (i < createdFields.size()) {
            String colSyntax = SegmentDDLGenerator.addFieldNAME((FieldType)createdFields.get(i)) + " " + this.genColumnSyntax((FieldType)createdFields.get(i), "");
            caseDefinition = i == 0 ? caseDefinition + TAB + TAB + colSyntax : caseDefinition + "," + CR + TAB + TAB + colSyntax;
            ++i;
        }
        return caseDefinition + ")";
    }

    private List<FieldType> getFlatFieldList(List<FieldType> curRegFieldList) {
        ArrayList<FieldType> currentLevelFieldList = new ArrayList<FieldType>();
        int i = 0;
        while (i < curRegFieldList.size()) {
            FieldType curRegField = curRegFieldList.get(i);
            currentLevelFieldList.add(curRegField);
            if (!curRegField.getField().isEmpty()) {
                currentLevelFieldList.addAll(this.getFlatFieldList(curRegField.getField()));
            }
            ++i;
        }
        return currentLevelFieldList;
    }

    private void genAlteredCaseStmt(String mapName, AlteredCaseType alteredCaseType) {
        String caseName = alteredCaseType.getCaseName();
        Object caseID = alteredCaseType.getCaseID();
        String caseIDType = alteredCaseType.getCaseIDType();
        if (caseName != null && caseID != null && caseIDType != null) {
            caseID = "'" + (String)caseID + "'";
            if (caseIDType.equals(ValueDatatypeType.X.value())) {
                caseID = "X" + (String)caseID;
            }
            this.topLevelAlterOptionsStmts.add(TAB + TAB + "ALTER CASE " + caseName + " IN " + mapName + " CASEID " + (String)caseID);
        }
        ArrayList<FieldType> createdFields = new ArrayList<FieldType>();
        ArrayList<RemovedFieldType> removedFields = new ArrayList<RemovedFieldType>();
        ArrayList<AlteredFieldType> alteredFields = new ArrayList<AlteredFieldType>();
        createdFields.addAll(alteredCaseType.getCreatedFields());
        removedFields.addAll(alteredCaseType.getRemovedFields());
        alteredFields.addAll(alteredCaseType.getAlteredFields());
        int i = 0;
        while (i < removedFields.size()) {
            this.genRemovedFieldStmt(mapName, caseName, (RemovedFieldType)removedFields.get(i));
            ++i;
        }
        i = 0;
        while (i < createdFields.size()) {
            String createdCaseColStmt = "ADD " + this.genCaseColumnStmt(mapName, caseName, (FieldType)createdFields.get(i));
            this.topLevelAlterOptionsStmts.add(createdCaseColStmt);
            ++i;
        }
        i = 0;
        while (i < alteredFields.size()) {
            String alterCaseColStr = "ALTER " + this.genCaseColumnStmt(mapName, caseName, ((AlteredFieldType)alteredFields.get(i)).getNewField());
            this.topLevelAlterOptionsStmts.add(alterCaseColStr);
            ++i;
        }
    }

    private void genRemovedCaseStmt(String mapName, RemovedCaseType removedCaseType) {
        this.topLevelAlterOptionsStmts.add(TAB + TAB + "DROP CASE " + removedCaseType.getCaseName() + " IN " + mapName);
    }

    private String genCaseColumnStmt(String mapName, String caseName, FieldType fieldType) {
        String createdCaseColStr = null;
        String fieldName = fieldType.getName();
        String mapPadding = TAB + TAB;
        if (!fieldName.isEmpty()) {
            String columnSyntax = this.genColumnSyntax(fieldType, mapPadding);
            createdCaseColStr = "CASECOLUMN " + fieldName + " IN " + mapName + "." + caseName + " " + columnSyntax;
        }
        return createdCaseColStr;
    }

    private String genColumnSyntax(FieldType fieldType, String mapPadding) {
        Object columnDefinition = null;
        if (this.dbdAccessType == DBDConstants.HSAM || this.dbdAccessType == DBDConstants.SHSAM || this.dbdAccessType == DBDConstants.HISAM || this.dbdAccessType == DBDConstants.SHISAM || this.dbdAccessType == DBDConstants.HDAM || this.dbdAccessType == DBDConstants.PHDAM || this.dbdAccessType == DBDConstants.HIDAM || this.dbdAccessType == DBDConstants.PHIDAM || this.dbdAccessType == DBDConstants.DEDB || this.dbdAccessType == DBDConstants.INDEX || this.dbdAccessType == DBDConstants.PSINDEX) {
            columnDefinition = CR + TAB + TAB + TAB;
            columnDefinition = SegmentDDLGenerator.addFieldDataTYPE((String)columnDefinition, fieldType);
            columnDefinition = SegmentDDLGenerator.addFieldBYTES((String)columnDefinition, fieldType);
            columnDefinition = SegmentDDLGenerator.addFieldSTART((String)columnDefinition, fieldType);
            columnDefinition = SegmentDDLGenerator.addMinMaxOccursDependsOn((String)columnDefinition, fieldType, mapPadding);
            columnDefinition = SegmentDDLGenerator.addFieldTYPE((String)columnDefinition, fieldType, mapPadding);
            columnDefinition = SegmentDDLGenerator.addFieldInternalNAME((String)columnDefinition, fieldType, mapPadding);
            columnDefinition = SegmentDDLGenerator.addFieldKEY((String)columnDefinition, fieldType, mapPadding);
            columnDefinition = SegmentDDLGenerator.addFieldParent((String)columnDefinition, fieldType, mapPadding);
            columnDefinition = SegmentDDLGenerator.addRedefines((String)columnDefinition, fieldType, mapPadding);
            String marshalerStr = SegmentDDLGenerator.genDFSMARSHStmts(fieldType, mapPadding);
            if (marshalerStr != null) {
                columnDefinition = (String)columnDefinition + marshalerStr;
            }
        }
        return columnDefinition;
    }

    private void genRemovedFieldStmt(String mapName, String caseName, RemovedFieldType removedFieldType) {
        this.topLevelAlterOptionsStmts.add("DROP CASECOLUMN " + removedFieldType.getExternalName() + " IN " + mapName + "." + caseName);
    }

    private static String addFieldNAME(FieldType fieldType) {
        Object externalName = fieldType.getName();
        if (externalName == null || externalName != null && ((String)externalName).length() == 0) {
            externalName = fieldType.getImsName();
            fieldType.setName((String)externalName);
        }
        if (Utility.hasReservedSQLKeywords((String)externalName)) {
            externalName = (String)externalName + "1";
            fieldType.setName((String)externalName);
        }
        if (Utility.isQuoteNeeded((String)externalName)) {
            externalName = QUOTE + (String)externalName + QUOTE;
        }
        return externalName;
    }

    private static String addFieldDataTYPE(String fieldStmt, FieldType fieldType) {
        DatatypeType dt;
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        DBDConstants dataType = adt == null ? null : ((dt = adt.getDatatype()) == null ? null : DBDConstants.valueOf(dt.toString()));
        if (dataType != null) {
            fieldStmt = (String)fieldStmt + " " + String.valueOf(dataType);
            if (dataType == DBDConstants.DECIMAL) {
                Integer precision = fieldType.getApplicationDatatype().getPrecision();
                Integer scale = fieldType.getApplicationDatatype().getScale();
                if (precision != null && scale != null) {
                    fieldStmt = (String)fieldStmt + "(";
                    if (precision != null) {
                        fieldStmt = (String)fieldStmt + String.valueOf(precision);
                    }
                    fieldStmt = (String)fieldStmt + ",";
                    if (scale != null) {
                        fieldStmt = (String)fieldStmt + String.valueOf(scale);
                    }
                    fieldStmt = (String)fieldStmt + ") ";
                }
            }
        }
        return fieldStmt;
    }

    private static String addFieldBYTES(String fieldStmt, FieldType fieldType) {
        DatatypeType dt;
        ApplicationDatatypeType adt;
        Integer maxBytes;
        Integer bytes = fieldType.getBytes();
        if (bytes == null) {
            bytes = 0;
            fieldType.setBytes(bytes);
        }
        if ((maxBytes = fieldType.getMaxBytes()) == null) {
            maxBytes = 0;
            fieldType.setMaxBytes(maxBytes);
        }
        DBDConstants appDatatype = (adt = fieldType.getApplicationDatatype()) == null ? null : ((dt = adt.getDatatype()) == null ? null : DBDConstants.valueOf(dt.toString()));
        char padding = ((String)fieldStmt).charAt(((String)fieldStmt).length() - 1);
        if (bytes > 0) {
            if (appDatatype == DBDConstants.CHAR) {
                fieldStmt = (String)fieldStmt + "(" + Integer.toString(bytes) + ")";
            } else if (appDatatype != DBDConstants.BIT && appDatatype != DBDConstants.BYTE && appDatatype != DBDConstants.UBYTE && appDatatype != DBDConstants.SHORT && appDatatype != DBDConstants.USHORT && appDatatype != DBDConstants.INT && appDatatype != DBDConstants.UINT && appDatatype != DBDConstants.LONG && appDatatype != DBDConstants.ULONG && appDatatype != DBDConstants.FLOAT && appDatatype != DBDConstants.DOUBLE) {
                fieldStmt = padding != ' ' && padding != '\t' ? (String)fieldStmt + " BYTES " + Integer.toString(bytes) : (String)fieldStmt + "BYTES " + Integer.toString(bytes);
            }
        } else if (maxBytes > 0) {
            fieldStmt = padding != ' ' && padding != '\t' ? (String)fieldStmt + " MAXBYTES " + Integer.toString(maxBytes) : (String)fieldStmt + "MAXBYTES " + Integer.toString(maxBytes);
        }
        return fieldStmt;
    }

    private static String addFieldSTART(String fieldStmt, FieldType fieldType) {
        Integer relativeStartPos;
        Integer startPos = fieldType.getStartPos();
        if (startPos == null) {
            startPos = 0;
        }
        if ((relativeStartPos = fieldType.getRelativeStart()) == null) {
            relativeStartPos = 0;
        }
        String startAfterField = fieldType.getStartAfter();
        if (startPos > 0) {
            fieldStmt = (String)fieldStmt + " START " + Integer.toString(startPos);
        } else if (startAfterField != null && !startAfterField.isEmpty()) {
            fieldStmt = (String)fieldStmt + " STARTAFTER " + startAfterField;
        } else if (relativeStartPos > 0) {
            fieldStmt = (String)fieldStmt + " RELSTART " + Integer.toString(relativeStartPos);
        }
        return fieldStmt;
    }

    private static String addMinMaxOccursDependsOn(String fieldStmt, FieldType fieldType, String mapPadding) {
        DatatypeType dt;
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        DBDConstants dataType = adt == null ? null : ((dt = adt.getDatatype()) == null ? null : DBDConstants.valueOf(dt.toString()));
        if (dataType == DBDConstants.ARRAY) {
            String dependsOnField;
            Integer maxOccurs;
            String padding = "";
            Integer minOccurs = fieldType.getMinOccurs();
            if (minOccurs != null) {
                fieldStmt = (String)fieldStmt + CR + TAB + TAB + TAB + mapPadding;
                fieldStmt = (String)fieldStmt + "MINOCCURS " + minOccurs.toString();
                padding = " ";
            }
            if ((maxOccurs = fieldType.getMaxOccurs()) != null) {
                if (padding.isEmpty()) {
                    fieldStmt = (String)fieldStmt + CR + TAB + TAB + TAB + mapPadding;
                }
                fieldStmt = (String)fieldStmt + padding + "MAXOCCURS " + maxOccurs.toString();
                padding = " ";
            }
            if (!padding.isEmpty() && (dependsOnField = fieldType.getDependsOn()) != null && !dependsOnField.isEmpty()) {
                fieldStmt = (String)fieldStmt + padding + "DEPENDSON " + dependsOnField;
            }
            if (!padding.isEmpty()) {
                fieldStmt = (String)fieldStmt + CR + TAB + TAB + TAB + mapPadding;
            }
        }
        return fieldStmt;
    }

    private static String addFieldTYPE(String fieldStmt, FieldType fieldType, String mapPadding) {
        DBDConstants type = fieldType.getImsDatatype() == null ? null : DBDConstants.valueOf(fieldType.getImsDatatype().toString());
        if (type != null) {
            char padding = ((String)fieldStmt).charAt(((String)fieldStmt).length() - 1);
            fieldStmt = padding != ' ' && padding != '\t' ? (String)fieldStmt + " TYPE " + String.valueOf((Object)type) : (String)fieldStmt + mapPadding + "TYPE " + String.valueOf((Object)type);
        }
        return fieldStmt;
    }

    private static String addFieldInternalNAME(String fieldStmt, FieldType fieldType, String mapPadding) {
        Object internalName = fieldType.getImsName();
        if (internalName == null) {
            internalName = "";
            fieldType.setImsName((String)internalName);
        }
        if (internalName != null && !((String)internalName).isEmpty()) {
            char padding;
            if (Utility.isQuoteNeeded((String)internalName)) {
                internalName = QUOTE + (String)internalName + QUOTE;
            }
            fieldStmt = (padding = ((String)fieldStmt).charAt(((String)fieldStmt).length() - 1)) != ' ' && padding != '\t' ? (String)fieldStmt + " INTERNALNAME " + (String)internalName : (String)fieldStmt + mapPadding + "INTERNALNAME " + (String)internalName;
        }
        return fieldStmt;
    }

    private static String addFieldKEY(String fieldStmt, FieldType fieldType, String mapPadding) {
        DBDConstants keyType = fieldType.getSeqType() == null ? null : DBDConstants.valueOf(fieldType.getSeqType().toString());
        if (keyType != null) {
            char padding = ((String)fieldStmt).charAt(((String)fieldStmt).length() - 1);
            fieldStmt = padding != ' ' && padding != '\t' ? (String)fieldStmt + " PRIMARY KEY" : (String)fieldStmt + mapPadding + "PRIMARY KEY";
            if (keyType == DBDConstants.M) {
                fieldStmt = (String)fieldStmt + " NON UNIQUE";
            }
        }
        return fieldStmt;
    }

    private static String addFieldParent(String fieldStmt, FieldType fieldType, String mapPadding) {
        String parentFieldName = fieldType.getParentField();
        if (parentFieldName != null) {
            char padding;
            Object parentName = parentFieldName;
            if (Utility.isQuoteNeeded((String)parentName)) {
                parentName = QUOTE + (String)parentName + QUOTE;
            }
            fieldStmt = (padding = ((String)fieldStmt).charAt(((String)fieldStmt).length() - 1)) != ' ' && padding != '\t' ? (String)fieldStmt + " IN " + (String)parentName : (String)fieldStmt + mapPadding + "IN " + (String)parentName;
        }
        return fieldStmt;
    }

    private static String addRedefines(String fieldStmt, FieldType fieldType, String mapPadding) {
        Object redefinesName = fieldType.getRedefines();
        if (redefinesName != null) {
            char padding;
            if (Utility.isQuoteNeeded((String)redefinesName)) {
                redefinesName = QUOTE + (String)redefinesName + QUOTE;
            }
            fieldStmt = (padding = ((String)fieldStmt).charAt(((String)fieldStmt).length() - 1)) != ' ' && padding != '\t' ? (String)fieldStmt + " REDEFINES " + (String)redefinesName : (String)fieldStmt + mapPadding + "REDEFINES " + (String)redefinesName;
        }
        return fieldStmt;
    }

    private static String genDFSMARSHStmts(FieldType fieldType, String mapPadding) {
        String dfsmarshStmt = null;
        MarshallerType typeConverterMarshaller = fieldType.getMarshaller();
        PhysicalDatatypeType typeConverter = typeConverterMarshaller != null ? typeConverterMarshaller.getTypeConverter() : null;
        MarshallerType userTypeConverterMarshaller = fieldType.getMarshaller();
        if (userTypeConverterMarshaller == null) {
            userTypeConverterMarshaller = new MarshallerType();
            fieldType.setMarshaller(userTypeConverterMarshaller);
        }
        String userTypeConverter = userTypeConverterMarshaller.getUserTypeConverter();
        MarshallerType patternMarshaller = fieldType.getMarshaller();
        String pattern = patternMarshaller != null ? patternMarshaller.getPattern() : null;
        if (pattern != null || typeConverter != null || userTypeConverter != null) {
            YesnoType ynType;
            DatatypeType dt;
            ApplicationDatatypeType adt;
            dfsmarshStmt = CR + TAB + TAB + TAB;
            MarshallerType marshaller = fieldType.getMarshaller();
            if (marshaller == null) {
                marshaller = new MarshallerType();
                fieldType.setMarshaller(marshaller);
            }
            ArrayList pv = (ArrayList)fieldType.getMarshaller().getProperty();
            int numProperties = pv.size();
            if (typeConverter != null) {
                dfsmarshStmt = dfsmarshStmt + mapPadding + "INTERNAL TYPECONVERTER " + String.valueOf((Object)typeConverter);
            } else if (userTypeConverter != null) {
                dfsmarshStmt = dfsmarshStmt + mapPadding + "USER TYPECONVERTER '" + userTypeConverter + "' ";
                if (numProperties > 0) {
                    dfsmarshStmt = dfsmarshStmt + "PROPERTIES (" + CR + TAB + TAB + TAB + mapPadding;
                    int i = 0;
                    while (i < numProperties) {
                        String value;
                        String name;
                        PropertyType p = null;
                        if (pv.isEmpty()) {
                            name = null;
                            value = null;
                        } else {
                            if (i < 0 || i >= pv.size()) {
                                name = null;
                                value = null;
                            }
                            p = (PropertyType)pv.get(i);
                            name = p.getName();
                            value = p.getValue();
                        }
                        String newStr = "'" + name + "'='" + value + "'";
                        dfsmarshStmt = i == numProperties - 1 ? dfsmarshStmt + newStr + CR + TAB + TAB + TAB + mapPadding : dfsmarshStmt + newStr + ", " + CR + TAB + TAB + TAB + mapPadding;
                        ++i;
                    }
                    dfsmarshStmt = dfsmarshStmt + ")";
                }
            }
            String padding = "";
            MarshallerType encodingOverrideMarshaller = fieldType.getMarshaller();
            String fieldEncodingOverride = encodingOverrideMarshaller != null ? encodingOverrideMarshaller.getEncoding() : null;
            if (fieldEncodingOverride != null && !fieldEncodingOverride.isEmpty() && typeConverter == PhysicalDatatypeType.CHAR) {
                dfsmarshStmt = dfsmarshStmt + CR + TAB + TAB + TAB + mapPadding;
                dfsmarshStmt = dfsmarshStmt + "CCSID '" + fieldEncodingOverride + "'";
                padding = " ";
            }
            DBDConstants fieldDataType = (adt = fieldType.getApplicationDatatype()) == null ? null : ((dt = adt.getDatatype()) == null ? null : DBDConstants.valueOf(dt.toString()));
            MarshallerType isSignedMarshaller = fieldType.getMarshaller();
            DBDConstants getIsSigned = isSignedMarshaller != null ? ((ynType = isSignedMarshaller.getIsSigned()) == null ? null : DBDConstants.valueOf(ynType.toString())) : null;
            if (fieldDataType == DBDConstants.DECIMAL && getIsSigned != null) {
                if (padding.isEmpty()) {
                    dfsmarshStmt = dfsmarshStmt + CR + TAB + TAB + TAB + mapPadding;
                }
                String isSigned = "YES";
                if (getIsSigned == DBDConstants.N) {
                    isSigned = "NO";
                }
                dfsmarshStmt = dfsmarshStmt + padding + "ISSIGNED" + isSigned;
            }
            if (pattern != null && !pattern.isEmpty()) {
                if (padding.isEmpty()) {
                    dfsmarshStmt = dfsmarshStmt + CR + TAB + TAB + TAB + mapPadding;
                }
                char beginChar = pattern.charAt(0);
                char endChar = pattern.charAt(pattern.length() - 1);
                dfsmarshStmt = beginChar != '\'' ? dfsmarshStmt + padding + "PATTERN '" + pattern : dfsmarshStmt + padding + "PATTERN " + pattern;
                if (endChar != '\'') {
                    dfsmarshStmt = dfsmarshStmt + "'";
                }
            }
        }
        return dfsmarshStmt;
    }

    public static String remarksHelper(String comments) {
        int commentsLen = comments.length();
        StringBuffer cbuf = new StringBuffer(commentsLen + 10);
        cbuf.append(comments);
        int i = 0;
        while (i < commentsLen) {
            char currentChar = cbuf.charAt(i);
            if (currentChar == '\'') {
                cbuf.insert(i + 1, '\'');
                ++commentsLen;
                ++i;
            }
            ++i;
        }
        cbuf.insert(0, '\'');
        cbuf.insert(commentsLen + 1, '\'');
        return cbuf.toString();
    }
}

