/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.metadata.dbd.Dbd;
import com.ibm.im.ims.metadata.imsresourcetemplates.ImsResourceTemplates;
import com.ibm.im.ims.metadata.psb.Psb;
import com.ibm.im.ims.workbench.model.ConnectionProfileModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.ResourceTemplatesModel;
import com.ibm.im.ims.workbench.model.TemplateModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import com.ibm.im.ims.workbench.model.utilities.DLIDatabaseViewGenerator;
import com.ibm.im.ims.workbench.model.utilities.DatabaseDDLGenerator;
import com.ibm.im.ims.workbench.model.utilities.DatabaseViewGeneratorException;
import com.ibm.im.ims.workbench.model.utilities.FindRelatedPsbHelper;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.PSBSourceGenerator;
import com.ibm.im.ims.workbench.model.utilities.ProgramDDLGenerator;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.ExplorerCommonPlugin;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectTreeFileHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2015. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final String CATALOG_PROJECT_NAME = "IMS_Explorer_Catalog_ReadOnly";
    public static final String DBD_META_EXTENTION = ".dbd";
    public static final String PSB_META_EXTENTION = ".psb";
    public static final String JAVA_METADATA_FOLDER = "IMS Universal Drivers Metadata";
    public static final String TOP_DBD_FOLDER = "DBD";
    public static final String TOP_DBD_SOURCE_FOLDER = WorkbenchModelBundle.getLabel().getString("WB816");
    public static final String TOP_PSB_FOLDER = "PSB";
    public static final String TOP_PSB_SOURCE_FOLDER = WorkbenchModelBundle.getLabel().getString("WB815");
    public static final String IMPORTED_SOURCE_FOLDER = WorkbenchModelBundle.getLabel().getString("SOURCE_IMPORTED");
    public static final String GENED_SOURCE_FOLDER = WorkbenchModelBundle.getLabel().getString("SOURCE_GENERATED");
    public static final String Catalog_DBD_SOURCE_FOLDER = WorkbenchModelBundle.getLabel().getString("CATALOG_DBD_FOLDER");
    public static final String Catalog_PSB_SOURCE_FOLDER = WorkbenchModelBundle.getLabel().getString("CATALOG_PSB_FOLDER");
    public static final String LIB_PATH = "lib/";
    public static final String PROJ_PREF_NODE_ID = "com.ibm.im.ims.workbench";
    public static final String PROJ_PREF_ProjectUUID = "ProjectUUID";
    public static final String dbFileExtension = "DatabaseView.java";
    public static final String EXPLORER_PROJ_NATURE = "com.ibm.im.ims.workbench.nature";
    private static final String COMMIT_DDL = System.getProperty("line.separator") + System.getProperty("line.separator") + "COMMIT DDL;";
    private static String currentDir;
    private static IPath fileLocation;
    private static boolean fileFound;
    private static String TEMPLATE_EXTENTION;

    static {
        fileFound = false;
        TEMPLATE_EXTENTION = ".replacementTemplates";
    }

    public static HashMap<String, String> getAllProjectFromOS() {
        HashMap<String, String> projHash = new HashMap<String, String>();
        File root = Platform.getLocation().toFile();
        if (root.isDirectory()) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    projHash.put(f.getName().toUpperCase(), f.getName());
                }
                ++n2;
            }
        }
        return projHash;
    }

    public static void removeAllTempResources(IProgressMonitor monitor) throws CoreException {
        Vector<IFile> dbdFiles = ProjectTreeFileHelper.getDbdMetadataFileList(CATALOG_PROJECT_NAME);
        int i = 0;
        while (i < dbdFiles.size()) {
            IFile currFile = dbdFiles.get(i);
            currFile.delete(true, monitor);
            ++i;
        }
        Vector<IFile> psbFiles = ProjectTreeFileHelper.getPsbMetadataFileList(CATALOG_PROJECT_NAME);
        int i2 = 0;
        while (i2 < psbFiles.size()) {
            IFile currFile = psbFiles.get(i2);
            currFile.delete(true, monitor);
            ++i2;
        }
    }

    public static void deleteProject(String containerName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(containerName);
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (project.exists()) {
            project.delete(true, (IProgressMonitor)monitor);
        }
    }

    public static void createNewProject(String containerName) throws CoreException, IOException {
        IFolder javaMetadataFolder;
        IFolder progFolder;
        logger.entering("com.ibm.im.ims.workbench.utilities.ProjectTreeFileHelper", "createNewProject(String containerName)", new Object[0]);
        String[] natures = new String[]{EXPLORER_PROJ_NATURE, "org.eclipse.jdt.core.javanature"};
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(containerName);
        if (project.exists()) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        project.create((IProgressMonitor)monitor);
        project.open((IProgressMonitor)monitor);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(natures);
        project.setDescription(desc, (IProgressMonitor)monitor);
        IFolder dbFolder = ProjectTreeFileHelper.getDatabaseFolder(containerName);
        if (!dbFolder.exists()) {
            dbFolder.create(false, true, (IProgressMonitor)monitor);
        }
        if (!(progFolder = ProjectTreeFileHelper.getProgramFolder(containerName)).exists()) {
            progFolder.create(false, true, (IProgressMonitor)monitor);
        }
        if ((javaMetadataFolder = ProjectTreeFileHelper.getTopJavaMetadataFolder(containerName)) != null && !javaMetadataFolder.exists()) {
            javaMetadataFolder.create(false, true, (IProgressMonitor)monitor);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        File javaHome = new File(System.getProperty("java.home"));
        IPath jreLibPath = new Path(javaHome.getPath()).append("lib").append("rt.jar");
        String imsjavaPathStr = ExplorerCommonPlugin.getLibJarPath((String)"imsudb.jar", (IExplorerLogger)logger);
        logger.finest("imsjavaPathStr: " + imsjavaPathStr);
        JavaCore.setClasspathVariable((String)"JRE_LIB", (IPath)jreLibPath, (IProgressMonitor)monitor);
        IPath javaMetadataPath = project.getFullPath().append(JAVA_METADATA_FOLDER);
        javaProject.setOutputLocation(javaMetadataPath, (IProgressMonitor)monitor);
        IClasspathEntry[] cpEntry = new IClasspathEntry[3];
        cpEntry[0] = JavaCore.newSourceEntry((IPath)javaMetadataPath);
        cpEntry[1] = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
        if (imsjavaPathStr != null) {
            logger.finest("imsjavaPathStr: " + imsjavaPathStr);
            cpEntry[2] = JavaCore.newLibraryEntry((IPath)new Path(imsjavaPathStr), null, null);
        }
        javaProject.setRawClasspath(cpEntry, (IProgressMonitor)monitor);
        logger.exiting("com.ibm.im.ims.workbench.utilities.ProjectTreeFileHelper", "createNewProject(String containerName)", new Object[0]);
    }

    public static void marshallGeneratedDbdFile(String projectName, DbdModel dbdModel) throws ModelException, CoreException {
        IFile generatedSrcDbdFile = ProjectTreeFileHelper.getGenedSrcDbdFile(projectName, dbdModel.getDbd().getDbdName());
        ByteArrayInputStream genSrcDbdInputStream = DBDSourceGenerator.genDbdSrc(dbdModel, false);
        if (!generatedSrcDbdFile.exists()) {
            generatedSrcDbdFile.create((InputStream)genSrcDbdInputStream, true, null);
        } else {
            generatedSrcDbdFile.setContents((InputStream)genSrcDbdInputStream, true, true, null);
        }
        generatedSrcDbdFile.setDerived(true, null);
    }

    public static void marshallGeneratedDdlFile(String projectName, DbdModel dbdModel) throws ModelException, CoreException {
        if (dbdModel.getAccessType() != DBDConstants.MSDB) {
            IFile generatedDdlFile = ProjectTreeFileHelper.getGenedSrcDbdFile(projectName, dbdModel.getDbd().getDbdName() + ".ddl");
            Object ddlStatements = DatabaseDDLGenerator.genDbdDdl(dbdModel, true, false, true);
            if (ddlStatements != null) {
                ddlStatements = (String)ddlStatements + COMMIT_DDL;
                ByteArrayInputStream genSrcDbdInputStream = new ByteArrayInputStream(((String)ddlStatements).getBytes());
                if (!generatedDdlFile.exists()) {
                    generatedDdlFile.create((InputStream)genSrcDbdInputStream, true, null);
                } else {
                    generatedDdlFile.setContents((InputStream)genSrcDbdInputStream, true, true, null);
                }
                generatedDdlFile.setDerived(true, null);
            }
        }
    }

    public static void marshallGeneratedDdlFile(String projectName, PsbModel psbModel) throws ModelException, CoreException {
        IFile generatedDdlFile = ProjectTreeFileHelper.getGenedSrcPsbFile(projectName, psbModel.getPsbName() + ".ddl");
        Object ddlStatements = ProgramDDLGenerator.genPsbDdl(projectName, psbModel, null, false, false, true);
        if (ddlStatements != null) {
            ddlStatements = (String)ddlStatements + COMMIT_DDL;
            ByteArrayInputStream genSrcPsbInputStream = new ByteArrayInputStream(((String)ddlStatements).getBytes());
            if (!generatedDdlFile.exists()) {
                generatedDdlFile.create((InputStream)genSrcPsbInputStream, true, null);
            } else {
                generatedDdlFile.setContents((InputStream)genSrcPsbInputStream, true, true, null);
            }
            generatedDdlFile.setDerived(true, null);
        }
    }

    public static void marshallGeneratedPsbFile(String projectName, PsbModel psbModel) throws CoreException {
        IFile generatedSrcPsbFile = ProjectTreeFileHelper.getGenedSrcPsbFile(projectName, psbModel.getPsbName());
        ByteArrayInputStream genSrcPsbInputStream = PSBSourceGenerator.genPsbSrc(psbModel, false);
        if (!generatedSrcPsbFile.exists()) {
            generatedSrcPsbFile.create((InputStream)genSrcPsbInputStream, true, null);
        } else {
            generatedSrcPsbFile.setContents((InputStream)genSrcPsbInputStream, true, true, null);
        }
        generatedSrcPsbFile.setDerived(true, null);
    }

    public static void moveImportedPsbFileToTarget(String projectName, String currPsbName) throws CoreException {
        IFile destFile = ProjectTreeFileHelper.getImportedPsbSourceFile(projectName, currPsbName);
        IFile srcFile = ProjectTreeFileHelper.getImportedPsbSourceFile(CATALOG_PROJECT_NAME, currPsbName);
        if (destFile.exists()) {
            destFile.delete(true, null);
        }
        srcFile.move(destFile.getFullPath(), true, null);
        destFile.setDerived(true, null);
    }

    public static void moveImportedDbdFileToTarget(String projectName, String currDbdName) throws CoreException {
        IFile destFile = ProjectTreeFileHelper.getImportedDbdSourceFile(projectName, currDbdName);
        IFile srcFile = ProjectTreeFileHelper.getImportedDbdSourceFile(CATALOG_PROJECT_NAME, currDbdName);
        if (destFile.exists()) {
            destFile.delete(true, null);
        }
        srcFile.move(destFile.getFullPath(), true, null);
        destFile.setDerived(true, null);
    }

    public static void marshallImportedPsbFile(String projectName, String fileName, InputStream is) throws CoreException {
        IFile newFile = ProjectTreeFileHelper.getImportedPsbSourceFile(projectName, fileName);
        if (newFile.exists()) {
            newFile.setContents(is, 1, null);
        } else {
            newFile.create(is, true, null);
        }
        newFile.setDerived(true, null);
    }

    public static void marshallImportedDbdFile(String projectName, String fileName, InputStream is) throws CoreException {
        IFile newFile = ProjectTreeFileHelper.getImportedDbdSourceFile(projectName, fileName);
        if (newFile.exists()) {
            newFile.setContents(is, 1, null);
        } else {
            newFile.create(is, true, null);
        }
        newFile.setDerived(true, null);
    }

    public static void marshallCatalogEnabledGeneratedDbdFile(String projectName, DbdModel dbdModel) throws ModelException, CoreException {
        IFile generatedCatSrcDbdFile = ProjectTreeFileHelper.getGenedCatalogSrcDbdFile(projectName, dbdModel.getDbd().getDbdName());
        ByteArrayInputStream genSrcDbdInputStream = DBDSourceGenerator.genDbdSrc(dbdModel, true);
        if (!generatedCatSrcDbdFile.exists()) {
            generatedCatSrcDbdFile.create((InputStream)genSrcDbdInputStream, true, null);
        } else {
            generatedCatSrcDbdFile.setContents((InputStream)genSrcDbdInputStream, true, true, null);
        }
        generatedCatSrcDbdFile.setDerived(true, null);
    }

    public static void marshallCatalogEnabledGeneratedPsbFile(String projectName, PsbModel psbModel) throws ModelException, CoreException {
        IFile generatedCatSrcPsbFile = ProjectTreeFileHelper.getGenedCatalogSrcPsbFile(projectName, psbModel.getPsbName());
        ByteArrayInputStream genSrcPsbInputStream = PSBSourceGenerator.genPsbSrc(psbModel, true);
        if (!generatedCatSrcPsbFile.exists()) {
            generatedCatSrcPsbFile.create((InputStream)genSrcPsbInputStream, true, null);
        } else {
            generatedCatSrcPsbFile.setContents((InputStream)genSrcPsbInputStream, true, true, null);
        }
        generatedCatSrcPsbFile.setDerived(true, null);
    }

    public static Vector<DatabaseViewGeneratorException> marshallGeneratedDbView(String projectName, PsbModel psbModel) throws CoreException {
        DLIDatabaseViewGenerator dbViewGenerator = new DLIDatabaseViewGenerator(projectName);
        Vector<DatabaseViewGeneratorException> exc = null;
        try {
            ResourceTemplatesModel resourceTemplateModel = ProjectTreeFileHelper.unmarshallTemplate(projectName);
            ArrayList<TemplateModel> templates = resourceTemplateModel.getTemplateModels();
            boolean didReplace = false;
            psbModel.getPsbName();
            if (templates != null && !templates.isEmpty()) {
                didReplace = ProjectTreeFileHelper.doReplacement(exc, projectName, psbModel, templates, dbViewGenerator);
                exc = dbViewGenerator.getDBViewExceptions();
            }
            if (!didReplace) {
                String scrubbedPsbName = dbViewGenerator.generateDBViewClass(psbModel);
                exc = dbViewGenerator.getDBViewExceptions();
                ProjectTreeFileHelper.saveDatabaseViewFile(projectName, scrubbedPsbName, dbViewGenerator, exc);
            }
        }
        catch (DatabaseViewGeneratorException e) {
            logger.throwing("com.ibm.im.ims.workbench.utilities.ProjectTreeFileHelper", "marshallGeneratedDbView(String projectName, PsbModel psbModel)", (Throwable)e);
            if (exc == null) {
                exc = new Vector<DatabaseViewGeneratorException>(1);
            }
            exc.add(e);
        }
        catch (Throwable e) {
            logger.throwing("com.ibm.im.ims.workbench.utilities.ProjectTreeFileHelper", "marshallGeneratedDbView(String projectName, PsbModel psbModel)", e);
            logger.error(e);
        }
        return exc;
    }

    public static Vector<DatabaseViewGeneratorException> marshallGeneratedDbView(String projectName, String psbName) throws CoreException, ModelException {
        PsbModel psbModel = ProjectTreeFileHelper.unmarshalPsb(psbName, projectName);
        DLIDatabaseViewGenerator dbViewGenerator = new DLIDatabaseViewGenerator(projectName);
        Vector<DatabaseViewGeneratorException> exc = null;
        try {
            ResourceTemplatesModel resourceTemplateModel = ProjectTreeFileHelper.unmarshallTemplate(projectName);
            ArrayList<TemplateModel> templates = resourceTemplateModel.getTemplateModels();
            boolean didReplace = false;
            if (templates != null && !templates.isEmpty()) {
                didReplace = ProjectTreeFileHelper.doReplacement(exc, projectName, psbModel, templates, dbViewGenerator);
                exc = dbViewGenerator.getDBViewExceptions();
            }
            if (!didReplace) {
                String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
                String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
                if (JavaConventions.validateIdentifier((String)psbName, (String)sourceLevel, (String)complianceLevel).isOK()) {
                    String scrubbedPsbName = dbViewGenerator.generateDBViewClass(psbModel);
                    exc = dbViewGenerator.getDBViewExceptions();
                    ProjectTreeFileHelper.saveDatabaseViewFile(projectName, scrubbedPsbName, dbViewGenerator, exc);
                }
            }
        }
        catch (DatabaseViewGeneratorException e) {
            logger.throwing("com.ibm.im.ims.workbench.utilities.ProjectTreeFileHelper", "marshallGeneratedDbView(String projectName, PsbModel psbModel)", (Throwable)e);
            if (exc == null) {
                exc = new Vector<DatabaseViewGeneratorException>(1);
            }
            exc.add(e);
        }
        catch (Throwable e) {
            logger.throwing("com.ibm.im.ims.workbench.utilities.ProjectTreeFileHelper", "marshallGeneratedDbView(String projectName, PsbModel psbModel)", e);
            logger.error(e);
        }
        return exc;
    }

    private static boolean doReplacement(Vector<DatabaseViewGeneratorException> exc, String projectName, PsbModel psbModel, ArrayList<TemplateModel> templates, DLIDatabaseViewGenerator dbViewGenerator) throws CoreException, DatabaseViewGeneratorException, ModelException {
        String psbName = psbModel.getPsbName();
        boolean didReplace = false;
        int i = 0;
        while (i < templates.size()) {
            TemplateModel currTemplate = templates.get(i);
            String varString = currTemplate.getVarString();
            if (varString != null && varString != "" && psbModel.hasVariableString(varString)) {
                didReplace = true;
                ArrayList<String> replacementStrings = currTemplate.getRepStrings();
                if (replacementStrings != null && !replacementStrings.isEmpty()) {
                    List<PcbGsamModel> gsamPcbList = psbModel.getGsamPcbList();
                    ArrayList<String> gsamPcbNames = new ArrayList<String>();
                    ArrayList<String> gsamPcbAliases = new ArrayList<String>();
                    if (gsamPcbList != null && !gsamPcbList.isEmpty()) {
                        int x = 0;
                        while (x < gsamPcbList.size()) {
                            String pcbNameOrLabel = gsamPcbList.get(x).getPcbName();
                            if (pcbNameOrLabel == null || pcbNameOrLabel.equalsIgnoreCase("")) {
                                pcbNameOrLabel = gsamPcbList.get(x).getLabel();
                            }
                            gsamPcbNames.add(pcbNameOrLabel);
                            gsamPcbAliases.add(gsamPcbList.get(x).getPcbAlias());
                            ++x;
                        }
                    }
                    List<PcbDBModel> dbPcbList = psbModel.getDBPcbList();
                    ArrayList<String> dbPcbNames = new ArrayList<String>();
                    ArrayList<String> dbPcbAliases = new ArrayList<String>();
                    if (dbPcbList != null && !dbPcbList.isEmpty()) {
                        int x = 0;
                        while (x < dbPcbList.size()) {
                            String pcbNameOrLabel = dbPcbList.get(x).getPcbName();
                            if (pcbNameOrLabel == null || pcbNameOrLabel.equalsIgnoreCase("")) {
                                pcbNameOrLabel = dbPcbList.get(x).getLabel();
                            }
                            dbPcbNames.add(pcbNameOrLabel);
                            dbPcbAliases.add(dbPcbList.get(x).getPcbAlias());
                            ++x;
                        }
                    }
                    int j = 0;
                    while (j < replacementStrings.size()) {
                        int x;
                        String literalVarString = Matcher.quoteReplacement(varString);
                        String replacementString = Matcher.quoteReplacement(replacementStrings.get(j));
                        String newPsbName = psbName.replaceFirst(literalVarString, replacementString);
                        psbModel.setPsbName(newPsbName);
                        if (gsamPcbList != null && !gsamPcbList.isEmpty()) {
                            x = 0;
                            while (x < gsamPcbList.size()) {
                                String tempGsamPcbName = (String)gsamPcbNames.get(x);
                                String tempGsamPcbAlias = (String)gsamPcbAliases.get(x);
                                if (tempGsamPcbName != null) {
                                    gsamPcbList.get(x).setPcbName(tempGsamPcbName.replaceFirst(literalVarString, replacementString));
                                }
                                if (tempGsamPcbAlias != null) {
                                    gsamPcbList.get(x).setPcbAlias(tempGsamPcbAlias.replaceFirst(literalVarString, replacementString));
                                }
                                ++x;
                            }
                        }
                        if (dbPcbList != null && !dbPcbList.isEmpty()) {
                            x = 0;
                            while (x < dbPcbList.size()) {
                                String tempDbPcbName = (String)dbPcbNames.get(x);
                                String tempDbPcbAlias = (String)dbPcbAliases.get(x);
                                if (tempDbPcbName != null) {
                                    dbPcbList.get(x).setPcbName(tempDbPcbName.replaceFirst(literalVarString, replacementString));
                                }
                                if (tempDbPcbAlias != null) {
                                    dbPcbList.get(x).setPcbAlias(tempDbPcbAlias.replaceFirst(literalVarString, replacementString));
                                }
                                ++x;
                            }
                        }
                        String scrubbedPsbName = dbViewGenerator.generateDBViewClass(psbModel);
                        exc = dbViewGenerator.getDBViewExceptions();
                        ProjectTreeFileHelper.saveDatabaseViewFile(projectName, scrubbedPsbName, dbViewGenerator, exc);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return didReplace;
    }

    private static void saveDatabaseViewFile(String projectName, String psbName, DLIDatabaseViewGenerator dbViewGenerator, Vector<DatabaseViewGeneratorException> exc) throws CoreException {
        try {
            String fileName;
            IFile sourceFile;
            IFolder javaMetadataPackageFolder = ProjectTreeFileHelper.getJavaMetadataPackageFolder(projectName, psbName);
            if (!javaMetadataPackageFolder.exists()) {
                javaMetadataPackageFolder.create(false, true, null);
            }
            if ((sourceFile = javaMetadataPackageFolder.getFile((IPath)new Path(fileName = psbName + dbFileExtension))).exists()) {
                sourceFile.setContents((InputStream)new ByteArrayInputStream(dbViewGenerator.getByteArray()), true, true, null);
            } else {
                sourceFile.create((InputStream)new ByteArrayInputStream(dbViewGenerator.getByteArray()), true, null);
            }
            sourceFile.setDerived(true, null);
        }
        catch (DatabaseViewGeneratorException e) {
            logger.throwing("com.ibm.im.ims.workbench.utilities.ProjectTreeFileHelper", "marshallGeneratedDbView(String projectName, PsbModel psbModel)", (Throwable)e);
            if (exc == null) {
                exc = new Vector(1);
            }
            exc.add(e);
        }
    }

    private void cleanUpWarnings(String projectName) throws CoreException {
        IFolder dbdFolder = ProjectTreeFileHelper.getDatabaseFolder(projectName);
        dbdFolder.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
    }

    public static boolean isPathForProgram(IPath path) {
        boolean retVal = false;
        if (path.segments()[1].equals(TOP_PSB_FOLDER)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isPathForDatabase(IPath path) {
        boolean retVal = false;
        if (path.segments()[1].equals(TOP_DBD_FOLDER)) {
            retVal = true;
        }
        return retVal;
    }

    public static IFile getImportedPsbSourceFile(String projectName, String unqualPsbFileName) throws CoreException {
        IFolder importedPsbSrcFolder = ProjectTreeFileHelper.getImportedPSBSourceFolder(projectName);
        IFile retVal = importedPsbSrcFolder.getFile((IPath)new Path(unqualPsbFileName));
        return retVal;
    }

    public static IFile getImportedDbdSourceFile(String projectName, String unqualDbdFileName) throws CoreException {
        IFolder importedDbdSrcFolder = ProjectTreeFileHelper.getImportedDBDSourceFolder(projectName);
        IFile retVal = importedDbdSrcFolder.getFile((IPath)new Path(unqualDbdFileName));
        return retVal;
    }

    public static IFolder getImportedDBDSourceFolder(String projectName) throws CoreException {
        IFolder retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dbdSourceFolder = project.getFolder(TOP_DBD_SOURCE_FOLDER);
        if (!dbdSourceFolder.exists()) {
            dbdSourceFolder.create(true, true, null);
        }
        if (!(retVal = dbdSourceFolder.getFolder((IPath)new Path(IMPORTED_SOURCE_FOLDER))).exists()) {
            retVal.create(true, true, null);
        }
        return retVal;
    }

    public static IFolder getGenedDBDSourceFolder(String projectName) throws CoreException {
        IFolder retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dbdSourceFolder = project.getFolder(TOP_DBD_SOURCE_FOLDER);
        if (!dbdSourceFolder.exists()) {
            dbdSourceFolder.create(true, true, null);
        }
        if (!(retVal = dbdSourceFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists()) {
            retVal.create(true, true, null);
        }
        return retVal;
    }

    public static IFolder getGenedCatalogDBDSourceFolder(String projectName) throws CoreException {
        IFolder genSourceFolder;
        IFolder retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dbdSourceFolder = project.getFolder(TOP_DBD_SOURCE_FOLDER);
        if (!dbdSourceFolder.exists()) {
            dbdSourceFolder.create(true, true, null);
        }
        if (!(genSourceFolder = dbdSourceFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists()) {
            genSourceFolder.create(true, true, null);
        }
        if (!(retVal = genSourceFolder.getFolder((IPath)new Path(Catalog_DBD_SOURCE_FOLDER))).exists()) {
            retVal.create(true, true, null);
        }
        return retVal;
    }

    public static IFolder getTopDBDSourceFolder(String projectName) throws CoreException {
        IFolder retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        retVal = project.getFolder(TOP_DBD_SOURCE_FOLDER);
        if (!retVal.exists()) {
            retVal.create(true, true, null);
        }
        return retVal;
    }

    public static IFolder getTopPSBSourceFolder(String projectName) throws CoreException {
        IFolder retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        retVal = project.getFolder(TOP_PSB_SOURCE_FOLDER);
        if (!retVal.exists()) {
            retVal.create(true, true, null);
        }
        return retVal;
    }

    public static IProject getProject(String projectName) throws CoreException {
        IProject retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        retVal = wsRoot.getProject(projectName);
        return retVal;
    }

    public static String getUUIDForProject(String projectName, String prefNodeID) throws BackingStoreException, CoreException {
        if (prefNodeID == null || prefNodeID.isEmpty()) {
            prefNodeID = PROJ_PREF_NODE_ID;
        }
        return ProjectTreeFileHelper.getUUIDForProject(ProjectTreeFileHelper.getProject(projectName), prefNodeID);
    }

    public static String getUUIDForProject(IProject project, String prefNodeID) throws BackingStoreException, CoreException {
        String retVal = null;
        QualifiedName propertyName = new QualifiedName(prefNodeID, PROJ_PREF_ProjectUUID);
        retVal = project.getPersistentProperty(propertyName);
        if (retVal == null) {
            UUID randomUUID = UUID.randomUUID();
            retVal = randomUUID.toString();
            project.setPersistentProperty(propertyName, retVal);
        }
        return retVal;
    }

    public static void clearUUIDForProject(IProject project, String prefNodeID) throws BackingStoreException, CoreException {
        QualifiedName propertyName = new QualifiedName(prefNodeID, PROJ_PREF_ProjectUUID);
        project.setPersistentProperty(propertyName, null);
    }

    public static IFolder getGenedPSBSourceFolder(String projectName) throws CoreException {
        IFolder retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder psbSourceFolder = project.getFolder(TOP_PSB_SOURCE_FOLDER);
        if (!psbSourceFolder.exists()) {
            psbSourceFolder.create(true, true, null);
        }
        if (!(retVal = psbSourceFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists()) {
            retVal.create(true, true, null);
        }
        return retVal;
    }

    public static IFolder getGenedCatalogPSBSourceFolder(String projectName) throws CoreException {
        IFolder genSourceFolder;
        IFolder retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder psbSourceFolder = project.getFolder(TOP_PSB_SOURCE_FOLDER);
        if (!psbSourceFolder.exists()) {
            psbSourceFolder.create(true, true, null);
        }
        if (!(genSourceFolder = psbSourceFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists()) {
            genSourceFolder.create(true, true, null);
        }
        if (!(retVal = genSourceFolder.getFolder((IPath)new Path(Catalog_PSB_SOURCE_FOLDER))).exists()) {
            retVal.create(true, true, null);
        }
        return retVal;
    }

    public static IFolder getImportedPSBSourceFolder(String projectName) throws CoreException {
        IFolder retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder psbSourceFolder = project.getFolder(TOP_PSB_SOURCE_FOLDER);
        if (!psbSourceFolder.exists()) {
            psbSourceFolder.create(true, true, null);
        }
        if (!(retVal = psbSourceFolder.getFolder((IPath)new Path(IMPORTED_SOURCE_FOLDER))).exists()) {
            retVal.create(true, true, null);
        }
        return retVal;
    }

    public static IFile getGenedSrcDbdFile(String projectName, String dbdName) throws CoreException {
        IFolder genedDbdSrcFolder = ProjectTreeFileHelper.getGenedDBDSourceFolder(projectName);
        IFile retVal = genedDbdSrcFolder.getFile((IPath)new Path(dbdName));
        return retVal;
    }

    public static IFile getGenedCatalogSrcDbdFile(String projectName, String dbdName) throws CoreException {
        IFolder genedCatalogDbdSrcFolder = ProjectTreeFileHelper.getGenedCatalogDBDSourceFolder(projectName);
        IFile retVal = genedCatalogDbdSrcFolder.getFile((IPath)new Path(dbdName));
        return retVal;
    }

    public static IFile getGenedSrcPsbFile(String projectName, String psbName) throws CoreException {
        IFolder genedPsbSrcFolder = ProjectTreeFileHelper.getGenedPSBSourceFolder(projectName);
        IFile retVal = genedPsbSrcFolder.getFile((IPath)new Path(psbName));
        return retVal;
    }

    public static IFile getGenedCatalogSrcPsbFile(String projectName, String psbName) throws CoreException {
        IFolder genedCatalogPsbSrcFolder = ProjectTreeFileHelper.getGenedCatalogPSBSourceFolder(projectName);
        IFile retVal = genedCatalogPsbSrcFolder.getFile((IPath)new Path(psbName));
        return retVal;
    }

    public static IFile getPsbMetadataFile(String projectName, String psbName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder psbFolder = project.getFolder(TOP_PSB_FOLDER);
        if (!psbFolder.exists()) {
            psbFolder.create(true, true, null);
        }
        IFile retVal = psbFolder.getFile((IPath)new Path(psbName + PSB_META_EXTENTION));
        return retVal;
    }

    public static IFile getPsbCatalogMetadataFile(PsbModel psbModel) throws CoreException, ModelException {
        IProject project = ProjectTreeFileHelper.getCatalogReadOnlyProject();
        IFolder psbFolder = project.getFolder(TOP_PSB_FOLDER);
        if (!psbFolder.exists()) {
            psbFolder.create(true, true, null);
        }
        IFile retVal = psbFolder.getFile((IPath)new Path(psbModel.getPsbName() + PSB_META_EXTENTION));
        ByteArrayOutputStream psbOutputStream = new ByteArrayOutputStream();
        psbModel.marshall(psbOutputStream);
        if (retVal.exists()) {
            retVal.setContents((InputStream)new ByteArrayInputStream(psbOutputStream.toByteArray()), true, true, null);
        } else {
            retVal.create((InputStream)new ByteArrayInputStream(psbOutputStream.toByteArray()), true, null);
        }
        return retVal;
    }

    public static IFile getDbdMetadataFile(String projectName, String dbdName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dbdFolder = project.getFolder(TOP_DBD_FOLDER);
        if (!dbdFolder.exists()) {
            dbdFolder.create(true, true, null);
        }
        IFile retVal = dbdFolder.getFile((IPath)new Path(dbdName.toUpperCase() + DBD_META_EXTENTION));
        return retVal;
    }

    public static IProject getCatalogReadOnlyProject() throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(CATALOG_PROJECT_NAME);
        (new String[1])[0] = "com.ibm.im.ims.workbench.catalog.readonly.nature";
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!project.exists()) {
            project.create((IProgressMonitor)monitor);
        }
        project.open((IProgressMonitor)monitor);
        return project;
    }

    public static IFile marshallDbdToReadOnlyProject(DbdModel dbdModel) throws CoreException, ModelException {
        IProject project = ProjectTreeFileHelper.getCatalogReadOnlyProject();
        IFolder dbdFolder = project.getFolder(TOP_DBD_FOLDER);
        if (!dbdFolder.exists()) {
            dbdFolder.create(true, true, null);
        }
        IFile retVal = dbdFolder.getFile((IPath)new Path(dbdModel.getDBDName() + DBD_META_EXTENTION));
        ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
        dbdModel.marshall(dbdOutputStream);
        if (retVal.exists()) {
            retVal.setContents((InputStream)new ByteArrayInputStream(dbdOutputStream.toByteArray()), true, true, null);
        } else {
            retVal.create((InputStream)new ByteArrayInputStream(dbdOutputStream.toByteArray()), true, null);
        }
        return retVal;
    }

    public static IFile marshallDbConnProfToReadOnlyProject(ConnectionProfileModel connProfModel) throws CoreException, ModelException {
        IProject project = ProjectTreeFileHelper.getCatalogReadOnlyProject();
        IFolder dbdFolder = project.getFolder(TOP_DBD_FOLDER);
        if (!dbdFolder.exists()) {
            dbdFolder.create(true, true, null);
        }
        IFile retVal = dbdFolder.getFile((IPath)new Path(connProfModel.getProfileName() + DBD_META_EXTENTION));
        ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
        connProfModel.marshall(dbdOutputStream);
        if (retVal.exists()) {
            retVal.setContents((InputStream)new ByteArrayInputStream(dbdOutputStream.toByteArray()), true, true, null);
        } else {
            retVal.create((InputStream)new ByteArrayInputStream(dbdOutputStream.toByteArray()), true, null);
        }
        return retVal;
    }

    public static IFile marshallDBD(DbdModel dbdModel, String projectName) throws JAXBException, CoreException {
        IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile(projectName, dbdModel.getDBDName());
        ProjectTreeFileHelper.marshallDBD(dbdModel, dbdFile.getLocationURI());
        dbdFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        return dbdFile;
    }

    public static void marshallDBD(DbdModel dbdModel, URI fileURI) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.dbd", (ClassLoader)Dbd.class.getClassLoader());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)dbdModel.getDbd(), new File(fileURI));
    }

    public static IFile marshallPSB(PsbModel psbModel, String projectName) throws JAXBException, CoreException {
        IFile psbFile = ProjectTreeFileHelper.getPsbMetadataFile(projectName, psbModel.getPsbName());
        ProjectTreeFileHelper.marshallPSB(psbModel, psbFile.getLocationURI());
        psbFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        return psbFile;
    }

    public static void marshallPSB(PsbModel psbModel, URI fileURI) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.psb", (ClassLoader)Psb.class.getClassLoader());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)psbModel.getJaxbPsb(), new File(fileURI));
    }

    public static Vector<IFile> getDbdMetadataFileList(String projectName) throws CoreException {
        Vector<IFile> retVal = new Vector<IFile>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dbdFolder = project.getFolder(TOP_DBD_FOLDER);
        if (dbdFolder.exists()) {
            IResource[] members = dbdFolder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member.getFileExtension().equals(DBD_META_EXTENTION.substring(1))) {
                    String fileName = member.getName();
                    IFile fileEntry = dbdFolder.getFile((IPath)new Path(fileName));
                    retVal.addElement(fileEntry);
                }
                ++i;
            }
        }
        return retVal;
    }

    public static Vector<IFile> getPsbMetadataFileList(String projectName) throws CoreException {
        Vector<IFile> retVal = new Vector<IFile>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder psbFolder = project.getFolder(TOP_PSB_FOLDER);
        if (psbFolder.exists()) {
            IResource[] members = psbFolder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member.getFileExtension().equals(PSB_META_EXTENTION.substring(1))) {
                    String fileName = member.getName();
                    IFile fileEntry = psbFolder.getFile((IPath)new Path(fileName));
                    retVal.addElement(fileEntry);
                }
                ++i;
            }
        }
        return retVal;
    }

    public static IFile getTempFile(String projectName, String tempFileName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile tempFile = project.getFile(tempFileName);
        return tempFile;
    }

    public static boolean isDbdMetadataFileExists(String projectName, String dbdName) throws CoreException {
        IFile ifile;
        boolean retVal = false;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder(TOP_DBD_FOLDER);
        if (databaseFolder.exists() && (ifile = databaseFolder.getFile((IPath)new Path(dbdName.toUpperCase() + DBD_META_EXTENTION))).exists()) {
            retVal = true;
        }
        return retVal;
    }

    public static void deleteDbdMetadataFile(String projectName, String dbdName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder(TOP_DBD_FOLDER);
        if (!databaseFolder.exists()) {
            return;
        }
        IFolder dbdFolder = databaseFolder.getFolder(dbdName.toLowerCase());
        if (!dbdFolder.exists()) {
            return;
        }
        IFile dbdFile = dbdFolder.getFile((IPath)new Path(dbdName.toUpperCase() + DBD_META_EXTENTION));
        dbdFile.delete(true, null);
        dbdFolder.delete(true, null);
    }

    public static Vector<String> getDbdNamesInProject(String projectName) throws CoreException {
        Vector<String> retVal = new Vector<String>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder(TOP_DBD_FOLDER);
        if (databaseFolder.exists()) {
            IResource[] members = databaseFolder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member.getFileExtension().equals(DBD_META_EXTENTION.substring(1))) {
                    String dbdName = member.getName();
                    dbdName = dbdName.substring(0, dbdName.indexOf("."));
                    retVal.addElement(dbdName.toUpperCase());
                }
                ++i;
            }
        }
        return retVal;
    }

    public static Vector<String> getPSBNamesInProject(String projectName) throws CoreException {
        Vector<String> retVal = new Vector<String>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder psbFolder = project.getFolder(TOP_PSB_FOLDER);
        if (psbFolder.exists()) {
            IResource[] members = psbFolder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member.getFileExtension().equals(PSB_META_EXTENTION.substring(1))) {
                    String psbName = member.getName();
                    psbName = psbName.substring(0, psbName.indexOf("."));
                    retVal.addElement(psbName.toUpperCase());
                }
                ++i;
            }
        }
        return retVal;
    }

    public static Vector<String> getDatabaseViewPSBNames(String projectName) throws CoreException {
        Vector<String> retVal = new Vector<String>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dbViewFolder = project.getFolder(JAVA_METADATA_FOLDER);
        if (dbViewFolder.exists()) {
            IResource[] members = dbViewFolder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member instanceof IFolder) {
                    String psbName = member.getName();
                    retVal.addElement(psbName.toUpperCase());
                }
                ++i;
            }
        }
        return retVal;
    }

    public static DbdModel unmarshalDbd(String newDbdName, String projectName) throws CoreException, ModelException {
        IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile(projectName, newDbdName);
        if (dbdFile != null && dbdFile.exists()) {
            return new DbdModel(dbdFile.getContents());
        }
        return null;
    }

    public static PsbModel unmarshalPsb(String newPsbName, String projectName) throws CoreException, ModelException {
        IFile dbdFile = ProjectTreeFileHelper.getPsbMetadataFile(projectName, newPsbName);
        if (dbdFile != null && dbdFile.exists()) {
            return new PsbModel(dbdFile.getContents());
        }
        return null;
    }

    public static IFolder getDbdFolder(String projectName, String dbdName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dbdFolder = project.getFolder(TOP_DBD_FOLDER);
        return dbdFolder;
    }

    public static IFolder getDatabaseFolder(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = null;
        if (project.isOpen()) {
            databaseFolder = project.getFolder(TOP_DBD_FOLDER);
        }
        return databaseFolder;
    }

    public static String getProjectPathStr(String projectName) {
        IPath path;
        String retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        if (project.isOpen() && (path = project.getLocation()) != null) {
            retVal = path.toString();
        }
        return retVal;
    }

    public static IFolder getProgramFolder(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder programFolder = null;
        if (project.isOpen()) {
            programFolder = project.getFolder(TOP_PSB_FOLDER);
        }
        return programFolder;
    }

    public static IFolder getTopJavaMetadataFolder(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder retVal = null;
        if (project.isOpen()) {
            retVal = project.getFolder(JAVA_METADATA_FOLDER);
        }
        return retVal;
    }

    public static IFolder getJavaMetadataPackageFolder(String projectName, String psbName) throws CoreException {
        IFolder psbJavaMetadataFolder = null;
        IFolder topJavaMetadataFolder = ProjectTreeFileHelper.getTopJavaMetadataFolder(projectName);
        if (topJavaMetadataFolder != null) {
            if (!topJavaMetadataFolder.exists()) {
                topJavaMetadataFolder.create(false, true, null);
            }
            psbJavaMetadataFolder = topJavaMetadataFolder.getFolder(psbName.toLowerCase());
        }
        return psbJavaMetadataFolder;
    }

    public static IFolder getPSBFolder(String projectName, String psbName) {
        IFolder psbFolder = ProjectTreeFileHelper.getProgramFolder(projectName);
        return psbFolder;
    }

    public static ArrayList<String> getProjectList(String[] projectNature) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<String> projectNames = new ArrayList<String>();
        IResource[] resources = root.members();
        if (resources.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < resources.length) {
            try {
                IProject temp = (IProject)resources[i];
                if (temp.isOpen()) {
                    boolean strCompare = Arrays.equals(temp.getDescription().getNatureIds(), projectNature);
                    if (resources[i] instanceof IProject && strCompare) {
                        projectNames.add(temp.getName());
                    }
                }
            }
            catch (Throwable e) {
                logger.throwing("ProjectTreeFileHelper", "getProjectList(String[] projectNature)", e);
            }
            ++i;
        }
        return projectNames;
    }

    public static String getDBViewPath(String projectName, String psbName) {
        String path = null;
        fileLocation = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        if (project != null && project.isOpen()) {
            IFolder psbPackage = (IFolder)project.findMember(psbName.toLowerCase());
            boolean DBViewFileFound = false;
            if (psbPackage != null) {
                DBViewFileFound = ProjectTreeFileHelper.searchFileRecursive(psbName, psbPackage);
                if (!DBViewFileFound) {
                    path = "";
                } else {
                    path = ProjectTreeFileHelper.formatFileLocationString();
                    fileLocation = null;
                    fileFound = false;
                }
            }
        }
        return path;
    }

    private static boolean searchFileRecursive(String psbName, IFolder psbFolder) {
        String fileName = psbName + dbFileExtension;
        try {
            IResource[] resource = psbFolder.members();
            int i = 0;
            while (i < resource.length && !fileFound) {
                if (resource[i] instanceof IFolder) {
                    fileFound = ProjectTreeFileHelper.searchFileRecursive(psbName, (IFolder)resource[i]);
                } else if (resource[i] instanceof IFile && resource[i].getName().equals(fileName)) {
                    fileLocation = resource[i].getFullPath();
                    fileFound = true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            logger.throwing("ProjectTreeFileHelper", "searchFileRecursive()", (Throwable)e);
            logger.error((Throwable)e);
        }
        return fileFound;
    }

    public static String formatFileLocationString() {
        Object path = null;
        path = String.valueOf(fileLocation.removeFirstSegments(1));
        path = ((String)path).replaceAll("/", ".");
        return path;
    }

    public static String getCurrentDir() {
        currentDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        return currentDir;
    }

    public static boolean checkDBDFileInProjectTree(String projectName, String dbdName) throws CoreException {
        fileFound = false;
        IFolder dbdFolder = ProjectTreeFileHelper.getDbdFolder(projectName, dbdName);
        if (dbdFolder.exists()) {
            IResource[] resources = dbdFolder.members();
            int i = 0;
            while (i < resources.length && !fileFound) {
                if (resources[i] instanceof IFile) {
                    String localDbdName = resources[i].getName();
                    if (localDbdName.contains(DBD_META_EXTENTION)) {
                        int len = localDbdName.indexOf(DBD_META_EXTENTION);
                        localDbdName = localDbdName.substring(0, len);
                    }
                    if (localDbdName.equals(dbdName.toUpperCase())) {
                        fileFound = true;
                    }
                }
                ++i;
            }
        }
        return fileFound;
    }

    public static boolean checkPSBFileInProjectTree(String projectName, String psbName) throws CoreException {
        fileFound = false;
        IFolder psbFolder = ProjectTreeFileHelper.getPSBFolder(projectName, psbName);
        if (psbFolder != null && psbFolder.exists()) {
            IResource[] resources = psbFolder.members();
            int i = 0;
            while (i < resources.length && !fileFound) {
                if (resources[i] instanceof IFile) {
                    String localPsbName = resources[i].getName();
                    if (localPsbName.contains(PSB_META_EXTENTION)) {
                        int len = localPsbName.indexOf(PSB_META_EXTENTION);
                        localPsbName = localPsbName.substring(0, len);
                    }
                    if (localPsbName.equals(psbName.toUpperCase())) {
                        fileFound = true;
                    }
                }
                ++i;
            }
        }
        return fileFound;
    }

    public static String getLibPath() {
        try {
            Location loc = Platform.getInstallLocation();
            URL url = loc.getURL();
            String installPathStr = url.getPath();
            logger.finest("IMS Explorer install location: " + installPathStr);
            File folder = new File(installPathStr);
            File[] files = folder.listFiles();
            File libDir = null;
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory() && files[i].getName().equals("lib")) {
                    libDir = files[i];
                    break;
                }
                ++i;
            }
            if (libDir == null) {
                throw new Exception("IMS Explorer cannot find file imsudb.jar in dir: " + installPathStr + "/lib");
            }
            return libDir.getAbsolutePath();
        }
        catch (Exception e) {
            logger.throwing("com.ibm.im.ims.workbench.utilities.ProjectTreeFileHelper", "getURL(String path)", (Throwable)e);
            logger.error((Throwable)e);
            return null;
        }
    }

    public static String getUnqualFileName(String resource) {
        Object unqualFileName = resource.substring(resource.lastIndexOf(File.separator) + 1);
        if (((String)unqualFileName).contains(".")) {
            int dotPos = ((String)unqualFileName).lastIndexOf(".") + 1;
            String extension = ((String)unqualFileName).substring(dotPos);
            unqualFileName = ((String)unqualFileName).substring(0, ((String)unqualFileName).lastIndexOf(".")) + "_" + extension;
        }
        return unqualFileName;
    }

    public static List<PsbModel> buildPsbList(String projectName, List<PsbModel> inMemoryPsbs) throws ModelException, CoreException, FileNotFoundException {
        ArrayList<PsbModel> retVal = new ArrayList<PsbModel>();
        Vector<String> allPsbs = ProjectTreeFileHelper.getPSBNamesInProject(projectName);
        for (String psbName : allPsbs) {
            IFile psbFile;
            PsbModel currPsb = ProjectTreeFileHelper.getPsbIfInMemory(psbName, inMemoryPsbs);
            if (currPsb == null && (psbFile = ProjectTreeFileHelper.getPsbMetadataFile(projectName, psbName)).exists()) {
                currPsb = new PsbModel(psbFile.getContents());
            }
            retVal.add(currPsb);
        }
        return retVal;
    }

    private static PsbModel getPsbIfInMemory(String psbName, List<PsbModel> inMemoryPsbs) {
        PsbModel retVal = null;
        int i = 0;
        while (i < inMemoryPsbs.size()) {
            PsbModel currPsb = inMemoryPsbs.get(i);
            if (currPsb.getPsbName().equals(psbName)) {
                retVal = currPsb;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public static List<PsbModel> findRelatedPSBs(String projectName, List<String> listDBD) throws CoreException, ModelException, FileNotFoundException {
        return ProjectTreeFileHelper.findRelatedPSBs(projectName, listDBD, new ArrayList<PsbModel>());
    }

    public static List<PsbModel> findRelatedPSBs(String projectName, List<String> listDBD, List<PsbModel> inMemoryPsbs) throws CoreException, ModelException, FileNotFoundException {
        List<PsbModel> allProjectPsbs = ProjectTreeFileHelper.buildPsbList(projectName, inMemoryPsbs);
        FindRelatedPsbHelper helper = new FindRelatedPsbHelper(projectName);
        Collection<PsbModel> psbCollection = helper.findRelatedPsbs(allProjectPsbs, listDBD);
        ArrayList<PsbModel> listPsbOut = new ArrayList<PsbModel>();
        Iterator<PsbModel> psbIter = psbCollection.iterator();
        while (psbIter.hasNext()) {
            listPsbOut.add(psbIter.next());
        }
        return listPsbOut;
    }

    public static List<String> findRelatedPSBNames(String projectName, List<String> newImportedDbds, IProgressMonitor monitor, List<String> allProjectPsbs) throws CoreException, ModelException, FileNotFoundException {
        FindRelatedPsbHelper helper = new FindRelatedPsbHelper(projectName);
        List<String> listPsbOut = helper.findRelatedPsbNames(allProjectPsbs, newImportedDbds, monitor);
        return listPsbOut;
    }

    public static List<IFile> getGenedSrcDbdList(String projectName) throws CoreException {
        IFolder genedDbdSrcFolder;
        ArrayList<IFile> srcDbdList = new ArrayList<IFile>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder(TOP_DBD_SOURCE_FOLDER);
        if (databaseFolder.exists() && (genedDbdSrcFolder = databaseFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists()) {
            IResource[] members = genedDbdSrcFolder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFile) {
                    srcDbdList.add((IFile)members[i]);
                }
                ++i;
            }
        }
        return srcDbdList;
    }

    public static List<IFile> getGenedSrcCatalogDbdList(String projectName) throws CoreException {
        IFolder catalogDbdSrcFolder;
        IFolder genedDbdSrcFolder;
        ArrayList<IFile> srcDbdList = new ArrayList<IFile>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder(TOP_DBD_SOURCE_FOLDER);
        if (databaseFolder.exists() && (genedDbdSrcFolder = databaseFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists() && (catalogDbdSrcFolder = genedDbdSrcFolder.getFolder((IPath)new Path(Catalog_DBD_SOURCE_FOLDER))).exists()) {
            IResource[] members = catalogDbdSrcFolder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFile) {
                    srcDbdList.add((IFile)members[i]);
                }
                ++i;
            }
        }
        return srcDbdList;
    }

    public static List<IFile> getGenedSrcPsbList(String projectName) throws CoreException {
        IFolder genedPsbSrcFolder;
        ArrayList<IFile> srcDbdList = new ArrayList<IFile>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder(TOP_PSB_SOURCE_FOLDER);
        if (databaseFolder.exists() && (genedPsbSrcFolder = databaseFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists()) {
            IResource[] members = genedPsbSrcFolder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFile) {
                    srcDbdList.add((IFile)members[i]);
                }
                ++i;
            }
        }
        return srcDbdList;
    }

    public static List<IFile> getGenedSrcCatalogPsbList(String projectName) throws CoreException {
        IFolder catalogPsbSrcFolder;
        IFolder genedPsbSrcFolder;
        ArrayList<IFile> srcDbdList = new ArrayList<IFile>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder(TOP_PSB_SOURCE_FOLDER);
        if (databaseFolder.exists() && (genedPsbSrcFolder = databaseFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists() && (catalogPsbSrcFolder = genedPsbSrcFolder.getFolder((IPath)new Path(Catalog_PSB_SOURCE_FOLDER))).exists()) {
            IResource[] members = catalogPsbSrcFolder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFile) {
                    srcDbdList.add((IFile)members[i]);
                }
                ++i;
            }
        }
        return srcDbdList;
    }

    public static List<IFile> getGenedSrcCatalogDbdDdlList(String projectName) throws CoreException {
        IFolder genedDdlSrcFolder;
        ArrayList<IFile> srcDdlList = new ArrayList<IFile>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder(TOP_DBD_SOURCE_FOLDER);
        if (databaseFolder.exists() && (genedDdlSrcFolder = databaseFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists()) {
            IResource[] members = genedDdlSrcFolder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFile) {
                    srcDdlList.add((IFile)members[i]);
                }
                ++i;
            }
        }
        return srcDdlList;
    }

    public static List<IFile> getGenedSrcCatalogPsbDdlList(String projectName) throws CoreException {
        IFolder genedDdlSrcFolder;
        ArrayList<IFile> srcDdlList = new ArrayList<IFile>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder databaseFolder = project.getFolder(TOP_PSB_SOURCE_FOLDER);
        if (databaseFolder.exists() && (genedDdlSrcFolder = databaseFolder.getFolder((IPath)new Path(GENED_SOURCE_FOLDER))).exists()) {
            IResource[] members = genedDdlSrcFolder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFile) {
                    srcDdlList.add((IFile)members[i]);
                }
                ++i;
            }
        }
        return srcDdlList;
    }

    public static void marshallTemplate(ResourceTemplatesModel resourceTemplatesModel, String projectName) throws JAXBException, IOException, CoreException, ModelException {
        File outTemplatesFile = ProjectTreeFileHelper.getResourceTemplatesFile(projectName);
        if (outTemplatesFile == null) {
            return;
        }
        if (!outTemplatesFile.exists()) {
            outTemplatesFile.createNewFile();
        }
        JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.imsresourcetemplates", (ClassLoader)ImsResourceTemplates.class.getClassLoader());
        Marshaller templateMarshaller = jc.createMarshaller();
        templateMarshaller.marshal((Object)resourceTemplatesModel.getImsResourceTemplates(), (OutputStream)new FileOutputStream(outTemplatesFile));
        Vector<String> psbNames = ProjectTreeFileHelper.getPSBNamesInProject(projectName);
        ArrayList<TemplateModel> templateModelsList = resourceTemplatesModel.getTemplateModels();
        int i = 0;
        while (i < psbNames.size()) {
            String currentPsbName = psbNames.get(i);
            int j = 0;
            while (j < templateModelsList.size()) {
                IFile psbFile;
                String varString = templateModelsList.get(j).getVarString();
                if (currentPsbName.contains(varString) && (psbFile = ProjectTreeFileHelper.getPsbMetadataFile(projectName, currentPsbName)).exists()) {
                    PsbModel psbModel = new PsbModel(psbFile.getContents());
                    ProjectTreeFileHelper.marshallGeneratedDbView(projectName, psbModel);
                }
                ++j;
            }
            ++i;
        }
    }

    public static ResourceTemplatesModel unmarshallTemplate(String projectName) throws JAXBException {
        File templateFile = ProjectTreeFileHelper.getResourceTemplatesFile(projectName);
        if (templateFile != null && templateFile.exists()) {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.imsresourcetemplates", (ClassLoader)ImsResourceTemplates.class.getClassLoader());
            Unmarshaller templateUnmarshaller = jc.createUnmarshaller();
            ImsResourceTemplates resourcesTemplate = (ImsResourceTemplates)templateUnmarshaller.unmarshal(templateFile);
            return new ResourceTemplatesModel(resourcesTemplate);
        }
        return new ResourceTemplatesModel();
    }

    public static File getResourceTemplatesFile(String projectName) {
        String projectPathStr = ProjectTreeFileHelper.getProjectPathStr(projectName);
        if (projectPathStr == null) {
            return null;
        }
        String pathStr = projectPathStr + File.separator + TEMPLATE_EXTENTION;
        Path path = new Path(pathStr);
        return path.toFile();
    }

    public static void ensureValidXml(String psbName, String projectName) throws CoreException, ModelException, JAXBException {
        PsbModel psbModel = ProjectTreeFileHelper.unmarshalPsb(psbName, projectName);
        boolean needToMarshallPsb = psbModel.getAtLeastOneDbpcbDidNotHaveName().myBool || psbModel.getAtLeastOneDbpcbDidNotHaveTimestamp().myBool;
        List<PcbDBModel> dbPcbList = psbModel.getDBPcbList();
        for (PcbDBModel currDbPCB : dbPcbList) {
            DbdModel currDbd = ProjectTreeFileHelper.unmarshalDbd(currDbPCB.getDbdName(), projectName);
            if (currDbd == null) continue;
            if (currDbd.getAtLeastOneSegmentDidNotHaveAlias().myBool) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.info("Scrubbing xml for DBD: " + currDbd.getDBDName() + ". At least one segment did not have a segment alias defined.", new Object[0]);
                }
                ProjectTreeFileHelper.marshallDBD(currDbd, projectName);
                continue;
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.info("Scrubbing xml for DBD: " + currDbd.getDBDName() + ". No changes necessary. All segments had an alias.", new Object[0]);
        }
        if (needToMarshallPsb) {
            if (logger.isLoggable(Level.FINER)) {
                logger.info("Scrubbing xml for PSB: " + psbModel.getPsbName() + ". At least one dbPcb was missing a Timestamp or alias.", new Object[0]);
            }
            ProjectTreeFileHelper.marshallPSB(psbModel, projectName);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.info("Scrubbing xml for PSB: " + psbModel.getPsbName() + ". No changes necessary. All dbPcbs had a Timestamp and alias.", new Object[0]);
        }
    }

    public static boolean deletePSBMetadataFile(String projectName, String psbName) throws CoreException {
        boolean fileDeleted = false;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder javaFolder = project.getFolder(JAVA_METADATA_FOLDER);
        if (!javaFolder.exists()) {
            return false;
        }
        IFolder psbFolder = javaFolder.getFolder(psbName.toLowerCase());
        if (!psbFolder.exists()) {
            return false;
        }
        IFile dbFile = psbFolder.getFile((IPath)new Path(psbName.toUpperCase() + dbFileExtension));
        if (dbFile != null && dbFile.exists()) {
            dbFile.delete(true, null);
            fileDeleted = true;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        psbFolder.refreshLocal(2, null);
        if (psbFolder.members().length == 0) {
            psbFolder.delete(true, null);
        }
        return fileDeleted;
    }

    public static URI generateTempMetadataFile(byte[] xml, boolean isPsb) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        FileOutputStream fos = null;
        String fullpathname = isPsb ? wsRoot.getRawLocation().toString() + "//tempfile.psb" : wsRoot.getRawLocation().toString() + "//tempfile.dbd";
        File tempFile = new File(fullpathname);
        try {
            fos = new FileOutputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            bos.write(xml);
            bos.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tempFile.toURI();
    }

    public static enum dsLang {
        cobol,
        pli;

    }
}

