/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PcbTPModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.ConnectionMetadataHelper;
import com.ibm.im.ims.workbench.model.utilities.DatabaseDDLGenerator;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.metadata.db.connections.ConnectionProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;

public class ProgramDDLGenerator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static String CR = System.getProperty("line.separator");
    private static String TAB = "    ";
    private static final String QUOTE = "\"";
    private static Vector<PcbTPModel> tpPcbsWithRemarks;
    private static Vector<PcbDBModel> dbPcbsWithRemarks;
    private static Vector<PcbGsamModel> gsamPcbsWithRemarks;
    private static Vector<Object[]> segmentsWithRemarks;
    private static Vector<Object[]> fieldsWithRemarks;
    private static ArrayList<String> schemaNames;
    private static int numberOfPcbs;
    private static boolean isDropProgram;
    private static boolean isAutoDrop;
    private static boolean generateComments;
    private static ConnectionProfile connProfile;

    static {
        isDropProgram = false;
        isAutoDrop = false;
        generateComments = true;
    }

    public static void setStatementFormat(boolean needFormat) {
        if (!needFormat) {
            CR = "";
            TAB = " ";
        }
    }

    public static void setConnProfile(ConnectionProfile connProfile) {
        ProgramDDLGenerator.connProfile = connProfile;
    }

    public static String genPsbDdl(String projectName, PsbModel psbModel, boolean isDrop, boolean autoDrop, boolean genComments) {
        Object genPsbSource = "";
        try {
            tpPcbsWithRemarks = new Vector();
            dbPcbsWithRemarks = new Vector();
            gsamPcbsWithRemarks = new Vector();
            segmentsWithRemarks = new Vector();
            fieldsWithRemarks = new Vector();
            numberOfPcbs = 0;
            schemaNames = psbModel.getDbPcbAliases();
            isDropProgram = isDrop;
            isAutoDrop = autoDrop;
            generateComments = genComments;
            String psbStmt = ProgramDDLGenerator.genPSBStmts(psbModel);
            if (!isDrop) {
                String pcbStmts = ProgramDDLGenerator.genPCBStmts(projectName, psbModel);
                String psbgenStmt = ProgramDDLGenerator.genPSBGENStmt(psbModel);
                genPsbSource = psbStmt + pcbStmts + psbgenStmt;
            } else {
                genPsbSource = psbStmt;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return genPsbSource;
    }

    private static String genPSBStmts(PsbModel psbModel) {
        Object psbStmt = null;
        String psbName = psbModel.getPsbName();
        if (!isDropProgram) {
            psbStmt = "CREATE PROGRAMVIEW " + psbName + " (" + CR;
        } else {
            String autoDrop = "";
            if (isAutoDrop) {
                autoDrop = " CASCADE";
            }
            psbStmt = DatabaseDDLGenerator.wrapStmt("DROP PROGRAMVIEW " + psbName + autoDrop);
        }
        return psbStmt;
    }

    private static String genPCBStmts(String projectName, PsbModel psbModel) throws ModelException {
        Object pcbStmts = "";
        List<PcbTPModel> tpPcbList = psbModel.getTPPcbList();
        List<PcbDBModel> dbPcbList = psbModel.getDBPcbList();
        List<PcbGsamModel> gsamPcbList = psbModel.getGsamPcbList();
        int tpPcbNum = 0;
        int dbPcbNum = 0;
        int gsamPcbNum = 0;
        if (tpPcbList != null && tpPcbList.size() > 0) {
            tpPcbNum = tpPcbList.size();
            numberOfPcbs += tpPcbNum;
        }
        if (dbPcbList != null && dbPcbList.size() > 0) {
            dbPcbNum = dbPcbList.size();
            if (schemaNames != null && schemaNames.size() > 0) {
                dbPcbNum = schemaNames.size();
            }
            numberOfPcbs += dbPcbNum;
        }
        if (gsamPcbList != null && gsamPcbList.size() > 0) {
            gsamPcbNum = gsamPcbList.size();
            numberOfPcbs += gsamPcbNum;
        }
        if (tpPcbNum > 0) {
            pcbStmts = (String)pcbStmts + ProgramDDLGenerator.genTPPCBStmts(tpPcbList, 0);
        }
        if (dbPcbNum > 0) {
            pcbStmts = (String)pcbStmts + ProgramDDLGenerator.genDBPCBStmts(projectName, dbPcbList, tpPcbNum);
        }
        if (gsamPcbNum > 0) {
            pcbStmts = (String)pcbStmts + ProgramDDLGenerator.genGSAMPCBStmts(gsamPcbList, tpPcbNum + dbPcbNum);
        }
        return pcbStmts;
    }

    private static String genTPPCBStmts(List<PcbTPModel> tpPcbList, int startPcbNum) {
        Iterator<PcbTPModel> tpPcbIter = tpPcbList.iterator();
        Object tpPcbStmts = "";
        String spacing = " ";
        while (tpPcbIter.hasNext()) {
            DBDConstants sametrm;
            Object extName;
            PcbTPModel pcbModel = tpPcbIter.next();
            Object pcbStmt = TAB;
            Object pcbName = pcbModel.getPcbNameOrLabel();
            if (pcbName == null) {
                pcbName = "PCB#" + pcbModel.getPcbNum();
            } else if (Utility.isQuoteNeeded((String)pcbName)) {
                pcbName = QUOTE + (String)pcbName + QUOTE;
            }
            pcbStmt = (String)pcbStmt + "CREATE SCHEMA TP " + (String)pcbName;
            Object lterm = pcbModel.getLtermName();
            if (lterm == null) {
                lterm = pcbModel.getTrancodeName();
            }
            if (lterm != null && !((String)lterm).isEmpty()) {
                if (Utility.isQuoteNeeded((String)lterm)) {
                    lterm = QUOTE + (String)lterm + QUOTE;
                }
                pcbStmt = (String)pcbStmt + spacing + "USING " + (String)lterm;
            }
            if ((extName = pcbModel.getExternalName()) != null && !((String)extName).isEmpty()) {
                if (Utility.isQuoteNeeded((String)extName)) {
                    extName = QUOTE + (String)extName + QUOTE;
                }
                pcbStmt = (String)pcbStmt + CR + TAB + TAB + "AS " + (String)extName;
            }
            pcbStmt = (sametrm = pcbModel.getSametrm()) != null && sametrm.toString().equals("Y") ? (String)pcbStmt + CR + TAB + TAB + "SAMETRMYES" : (String)pcbStmt + CR + TAB + TAB + "SAMETRMNO";
            DBDConstants modify = pcbModel.getModify();
            pcbStmt = modify != null && modify.toString().equals("Y") ? (String)pcbStmt + spacing + "MODIFYYES" : (String)pcbStmt + spacing + "MODIFYNO";
            DBDConstants express = pcbModel.getExpress();
            pcbStmt = express != null && express.toString().equals("Y") ? (String)pcbStmt + CR + TAB + TAB + "EXPRESSYES" : (String)pcbStmt + CR + TAB + TAB + "EXPRESSNO";
            DBDConstants list = pcbModel.getList();
            pcbStmt = list != null && list.toString().equals("N") ? (String)pcbStmt + spacing + "LISTNO" : (String)pcbStmt + spacing + "LISTYES";
            DBDConstants altresp = pcbModel.getAltresp();
            pcbStmt = altresp != null && altresp.toString().equals("Y") ? (String)pcbStmt + CR + TAB + TAB + "ALTRESPYES" : (String)pcbStmt + CR + TAB + TAB + "ALTRESPNO";
            tpPcbStmts = (String)tpPcbStmts + (String)pcbStmt + (String)(startPcbNum < numberOfPcbs - 1 ? "," + CR : "");
            ++startPcbNum;
            String remarks = pcbModel.getRemarks();
            if (remarks == null || remarks.isEmpty()) continue;
            tpPcbsWithRemarks.add(pcbModel);
        }
        return tpPcbStmts;
    }

    private static boolean schemaExists(String dbdName) {
        boolean retVal = false;
        Iterator<String> iter = schemaNames.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(dbdName)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private static String genDBPCBStmts(String projectName, List<PcbDBModel> dbPcbList, int startPcbNum) throws ModelException {
        Iterator<PcbDBModel> dbPcbIter = dbPcbList.iterator();
        Object dbPcbStmts = "";
        String spacing = " ";
        while (dbPcbIter.hasNext()) {
            String procseq;
            DBDConstants list;
            int copies;
            String procopt;
            PcbDBModel pcbModel = dbPcbIter.next();
            Object pcbName = pcbModel.getPcbNameOrLabel();
            if (pcbName == null) {
                pcbName = "PCB#" + pcbModel.getPcbNum();
            } else if (Utility.isQuoteNeeded((String)pcbName)) {
                pcbName = QUOTE + (String)pcbName + QUOTE;
            }
            if (schemaNames != null && !schemaNames.isEmpty() && !ProgramDDLGenerator.schemaExists((String)pcbName)) continue;
            Object pcbStmt = TAB;
            pcbStmt = (String)pcbStmt + "CREATE SCHEMA " + (String)pcbName;
            String dbdName = pcbModel.getDbdName();
            pcbStmt = (String)pcbStmt + spacing + "USING " + dbdName;
            Object extName = pcbModel.getExternalName();
            if (extName != null && !((String)extName).isEmpty()) {
                if (Utility.isQuoteNeeded((String)extName)) {
                    extName = QUOTE + (String)extName + QUOTE;
                }
                pcbStmt = (String)pcbStmt + CR + TAB + TAB + "AS " + (String)extName;
            }
            boolean needParent = ProgramDDLGenerator.isLogicalDbd(projectName, dbdName) || ProgramDDLGenerator.isProcSeqPcb(pcbModel);
            SensegModel rootSenseg = pcbModel.getRootSenseg();
            if (rootSenseg != null) {
                pcbStmt = (String)pcbStmt + spacing + "(" + CR;
                pcbStmt = (String)pcbStmt + ProgramDDLGenerator.genSensegSenfldStmts(rootSenseg, pcbModel, needParent);
                pcbStmt = ((String)pcbStmt).substring(0, ((String)pcbStmt).length() - CR.length() - 1) + ")";
            }
            if ((procopt = pcbModel.getProcopt()) == null) {
                procopt = "A";
            }
            pcbStmt = (String)pcbStmt + CR + TAB + TAB + "PROCOPT '" + procopt + "'";
            Integer dbverInt = pcbModel.getDbdUserVersion();
            if (dbverInt != null) {
                pcbStmt = (String)pcbStmt + spacing + "DBVER " + dbverInt.toString();
            }
            if ((copies = pcbModel.getCopies()) > 0) {
                pcbStmt = (String)pcbStmt + CR + TAB + TAB + "COPIES " + copies;
            }
            pcbStmt = (list = pcbModel.getList()) != null && list.toString().equals("N") ? (String)pcbStmt + spacing + "LISTNO" : (String)pcbStmt + spacing + "LISTYES";
            DBDConstants pos = pcbModel.getPos();
            pcbStmt = pos != null && pos.toString().equals("M") ? (String)pcbStmt + CR + TAB + TAB + "POSMULT" : (String)pcbStmt + CR + TAB + TAB + "POSSNGL";
            DBDConstants sb = pcbModel.getSb();
            pcbStmt = sb != null && sb.toString().equals("COND") ? (String)pcbStmt + spacing + "SBCOND" : (String)pcbStmt + spacing + "SBNO";
            DBDConstants view = pcbModel.getView();
            if (view != null) {
                pcbStmt = (String)pcbStmt + spacing + view.toString() + "VIEW";
            }
            if ((procseq = pcbModel.getProcSequence()) != null && !procseq.isEmpty()) {
                pcbStmt = (String)pcbStmt + CR + TAB + TAB + "PROCSEQ " + procseq;
            } else {
                String procseqd = pcbModel.getProcSequenceD();
                if (procseqd != null && !procseqd.isEmpty()) {
                    String accessType;
                    pcbStmt = (String)pcbStmt + CR + TAB + TAB + "PROCSEQD " + procseqd;
                    String pselopt = pcbModel.getPselOpt();
                    if (pselopt != null) {
                        if (pselopt.equals("S")) {
                            pcbStmt = (String)pcbStmt + spacing + "PSELSNGL";
                        } else if (pselopt.equals("M")) {
                            pcbStmt = (String)pcbStmt + spacing + "PSELMULT";
                        }
                    }
                    pcbStmt = (accessType = pcbModel.getAccess()) != null && accessType.equals("I") ? (String)pcbStmt + spacing + "ACCESS INDEX VSAM" : (String)pcbStmt + spacing + "ACCESS DB";
                }
            }
            dbPcbStmts = (String)dbPcbStmts + (String)pcbStmt + (String)(startPcbNum < numberOfPcbs - 1 ? "," + CR : "");
            ++startPcbNum;
            String remarks = pcbModel.getRemarks();
            if (remarks == null || remarks.isEmpty()) continue;
            dbPcbsWithRemarks.add(pcbModel);
        }
        return dbPcbStmts;
    }

    private static boolean isProcSeqPcb(PcbDBModel pcbModel) {
        boolean retVal = false;
        if (pcbModel != null) {
            String procSeq = pcbModel.getProcSequence();
            String procSeqD = pcbModel.getProcSequenceD();
            retVal = procSeq != null && !procSeq.isEmpty() || procSeqD != null && !procSeqD.isEmpty();
        }
        return retVal;
    }

    private static boolean isLogicalDbd(String projectName, String dbdName) {
        boolean retVal = false;
        try {
            IFile dbdFile;
            if (projectName != null) {
                if (ProjectTreeFileHelper.isDbdMetadataFileExists(projectName, dbdName)) {
                    IFile dbdFile2 = ProjectTreeFileHelper.getDbdMetadataFile(projectName, dbdName);
                    DbdModel dbdModel = new DbdModel(dbdFile2.getContents());
                    retVal = dbdModel.getAccessType() == DBDConstants.LOGICAL;
                }
            } else if (connProfile != null && (dbdFile = ConnectionMetadataHelper.getDbdFile(connProfile, dbdName)).exists()) {
                DbdModel dbdModel = new DbdModel(dbdFile.getContents());
                retVal = dbdModel.getAccessType() == DBDConstants.LOGICAL;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return retVal;
    }

    private static String genGSAMPCBStmts(List<PcbGsamModel> gsamPcbList, int startPcbNum) {
        Iterator<PcbGsamModel> gsamPcbIter = gsamPcbList.iterator();
        Object gsamPcbStmts = "";
        String spacing = " ";
        while (gsamPcbIter.hasNext()) {
            DBDConstants procopt;
            PcbGsamModel pcbModel = gsamPcbIter.next();
            Object pcbStmt = TAB;
            Object pcbName = pcbModel.getPcbNameOrLabel();
            if (pcbName == null) {
                pcbName = "PCB#" + pcbModel.getPcbNum();
            } else if (Utility.isQuoteNeeded((String)pcbName)) {
                pcbName = QUOTE + (String)pcbName + QUOTE;
            }
            pcbStmt = (String)pcbStmt + "CREATE SCHEMA GSAM " + (String)pcbName;
            pcbStmt = (String)pcbStmt + spacing + "USING " + pcbModel.getDbdName();
            Object extName = pcbModel.getExternalName();
            if (extName != null) {
                if (Utility.isQuoteNeeded((String)extName)) {
                    extName = QUOTE + (String)extName + QUOTE;
                }
                pcbStmt = (String)pcbStmt + CR + TAB + TAB + "AS " + (String)extName;
            }
            pcbStmt = (procopt = pcbModel.getProcopt()) == null ? (String)pcbStmt + CR + TAB + TAB + "PROCOPT 'G'" : (String)pcbStmt + CR + TAB + TAB + "PROCOPT '" + procopt.toString() + "'";
            DBDConstants list = pcbModel.getList();
            pcbStmt = list != null && list.toString().equals("N") ? (String)pcbStmt + spacing + "LISTNO" : (String)pcbStmt + spacing + "LISTYES";
            gsamPcbStmts = (String)gsamPcbStmts + (String)pcbStmt + (String)(startPcbNum < numberOfPcbs - 1 ? "," + CR : "");
            ++startPcbNum;
            String remarks = pcbModel.getRemarks();
            if (remarks == null || remarks.isEmpty()) continue;
            gsamPcbsWithRemarks.add(pcbModel);
        }
        return gsamPcbStmts;
    }

    private static String genSensegSenfldStmts(SensegModel currentSenseg, PcbDBModel pcbModel, boolean needParent) throws ModelException {
        ArrayList<SensegModel> sensegList;
        int numSsptrs;
        List<String> indicesList;
        String procopt;
        SensegModel parent;
        Object sensegStmts = "";
        String oneSensegStmt = TAB + TAB + TAB;
        Object senSegName = currentSenseg.getName();
        if (Utility.isQuoteNeeded((String)senSegName)) {
            senSegName = QUOTE + (String)senSegName + QUOTE;
        }
        oneSensegStmt = oneSensegStmt + "CREATE SENSEGVIEW " + (String)senSegName;
        oneSensegStmt = oneSensegStmt + ProgramDDLGenerator.genSenfldStmt(currentSenseg, pcbModel);
        Object withString = "";
        if (needParent && (parent = currentSenseg.getParent()) != null) {
            withString = " WITH ";
            Object parentName = parent.getName();
            if (Utility.isQuoteNeeded((String)parentName)) {
                parentName = QUOTE + (String)parentName + QUOTE;
            }
            oneSensegStmt = oneSensegStmt + (String)withString + "REFERENCES " + (String)parentName;
        }
        if ((procopt = currentSenseg.getProcopt()) != null && !procopt.isEmpty() && procopt.indexOf("GO") < 0) {
            withString = ((String)withString).isEmpty() ? " WITH " : CR + TAB + TAB + TAB + TAB;
            oneSensegStmt = oneSensegStmt + (String)withString + "PROCOPT '" + procopt + "'";
        }
        if ((indicesList = currentSenseg.getIndices()) != null && !indicesList.isEmpty()) {
            withString = ((String)withString).isEmpty() ? " WITH" : "";
            Iterator<String> indicesIter = indicesList.iterator();
            oneSensegStmt = oneSensegStmt + (String)withString + CR + TAB + TAB + TAB + TAB + "INDICES (";
            while (indicesIter.hasNext()) {
                oneSensegStmt = oneSensegStmt + indicesIter.next();
                oneSensegStmt = indicesIter.hasNext() ? oneSensegStmt + ", " : oneSensegStmt + ")";
            }
        }
        if ((numSsptrs = currentSenseg.getSsptrListSize()) > 0) {
            withString = ((String)withString).isEmpty() ? " WITH" : "";
            oneSensegStmt = oneSensegStmt + (String)withString + CR + TAB + TAB + TAB + TAB + "SSPTR (";
            int i = 0;
            while (i < numSsptrs) {
                oneSensegStmt = oneSensegStmt + currentSenseg.getSsptrNum(i) + " ";
                String ssptrSensitivity = currentSenseg.getSsptrSensitivity(i);
                oneSensegStmt = oneSensegStmt + ssptrSensitivity;
                oneSensegStmt = i < numSsptrs - 1 ? oneSensegStmt + ", " : oneSensegStmt + ")";
                ++i;
            }
        }
        sensegStmts = (String)sensegStmts + oneSensegStmt + "," + CR;
        String comments = currentSenseg.getRemarks();
        if (comments != null && !comments.isEmpty()) {
            Object pcbName = pcbModel.getPcbNameOrLabel();
            if (pcbName == null) {
                pcbName = "PCB#" + pcbModel.getPcbNum();
            }
            segmentsWithRemarks.add(new Object[]{pcbName, currentSenseg});
        }
        if ((sensegList = currentSenseg.getChildren()) != null && !sensegList.isEmpty()) {
            Iterator<SensegModel> childrenSensegIter = sensegList.iterator();
            while (childrenSensegIter.hasNext()) {
                sensegStmts = (String)sensegStmts + ProgramDDLGenerator.genSensegSenfldStmts(childrenSensegIter.next(), pcbModel, needParent);
            }
        }
        return sensegStmts;
    }

    private static String genSenfldStmt(SensegModel currentSenseg, PcbDBModel pcbModel) throws ModelException {
        Object retVal = "";
        String spacing = " ";
        ArrayList<SenfieldModel> senfldList = currentSenseg.getSenfields();
        if (senfldList != null && !senfldList.isEmpty()) {
            retVal = (String)retVal + " (" + CR;
            Iterator<SenfieldModel> senfldIter = senfldList.iterator();
            Object senfldStmts = "";
            while (senfldIter.hasNext()) {
                SenfieldModel senfld = senfldIter.next();
                boolean isProcoptKSpecified = false;
                boolean isProcoptIorL = false;
                String sensegProcoptStr = currentSenseg.getProcopt();
                if (sensegProcoptStr != null && "K".equals(sensegProcoptStr)) {
                    isProcoptKSpecified = true;
                }
                if (sensegProcoptStr != null && sensegProcoptStr.length() > 0) {
                    isProcoptIorL = ProgramDDLGenerator.isProcoptIorL(sensegProcoptStr);
                } else {
                    sensegProcoptStr = pcbModel.getProcopt();
                    if (sensegProcoptStr != null) {
                        isProcoptIorL = ProgramDDLGenerator.isProcoptIorL(sensegProcoptStr);
                    }
                }
                boolean isFieldLogicalChild = senfld.isLogicalChild();
                if (isProcoptKSpecified || isProcoptIorL && isFieldLogicalChild) continue;
                String oneSenfldStmt = TAB + TAB + TAB + TAB;
                Object senFldName = senfld.getName();
                if (Utility.isQuoteNeeded((String)senFldName)) {
                    senFldName = QUOTE + (String)senFldName + QUOTE;
                }
                oneSenfldStmt = oneSenfldStmt + (String)senFldName;
                oneSenfldStmt = oneSenfldStmt + spacing + "WITH START (" + Integer.toString(senfld.getStart()) + ")";
                DBDConstants replace = senfld.getReplace();
                oneSenfldStmt = replace != null && replace.toString().equals("N") ? oneSenfldStmt + spacing + "REPLNO" : oneSenfldStmt + spacing + "REPLYES";
                senfldStmts = (String)senfldStmts + oneSenfldStmt + (String)(senfldIter.hasNext() ? "," + CR : "");
                String comments1 = senfld.getRemarks();
                if (comments1 == null) continue;
                Object pcbName = pcbModel.getPcbNameOrLabel();
                if (pcbName == null) {
                    pcbName = "PCB#" + pcbModel.getPcbNum();
                }
                fieldsWithRemarks.add(new Object[]{pcbName, currentSenseg.getName(), senfld});
            }
            retVal = (String)retVal + (String)senfldStmts + CR + TAB + TAB + TAB + ")";
        }
        return retVal;
    }

    private static boolean isProcoptIorL(String sensegProcoptStr) {
        int i = 0;
        while (i < sensegProcoptStr.length()) {
            char currChar = sensegProcoptStr.charAt(i);
            if (currChar == 'I' || currChar == 'L') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String genPSBGENStmt(PsbModel psbModel) {
        Object psbgenStmt = CR + ")";
        Object spacing = " ";
        String dblevel = psbModel.getDblevel();
        if (dblevel != null && !dblevel.isEmpty()) {
            psbgenStmt = (String)psbgenStmt + (String)spacing + "DBLEVEL" + dblevel;
        }
        spacing = ProgramDDLGenerator.isNewLineNeeded((String)psbgenStmt) ? CR + TAB : " ";
        DBDConstants cmpat = psbModel.getCompat();
        psbgenStmt = cmpat != null && cmpat.toString().equals("Y") ? (String)psbgenStmt + (String)spacing + "CMPATYES" : (String)psbgenStmt + (String)spacing + "CMPATNO";
        spacing = ProgramDDLGenerator.isNewLineNeeded((String)psbgenStmt) ? CR + TAB : " ";
        DBDConstants gsrolbok = psbModel.getGsamRollb();
        psbgenStmt = gsrolbok != null && gsrolbok.toString().equals("Y") ? (String)psbgenStmt + (String)spacing + "GSROLBOKYES" : (String)psbgenStmt + (String)spacing + "GSROLBOKNO";
        spacing = ProgramDDLGenerator.isNewLineNeeded((String)psbgenStmt) ? CR + TAB : " ";
        DBDConstants olic = psbModel.getOnlineDBImageCopy();
        psbgenStmt = olic != null && olic.toString().equals("Y") ? (String)psbgenStmt + (String)spacing + "OLICYES" : (String)psbgenStmt + (String)spacing + "OLICNO";
        spacing = ProgramDDLGenerator.isNewLineNeeded((String)psbgenStmt) ? CR + TAB : " ";
        Integer lockmax = psbModel.getMaximumLock();
        if (lockmax != null) {
            psbgenStmt = (String)psbgenStmt + (String)spacing + "LOCKMAX " + lockmax.toString();
        }
        spacing = ProgramDDLGenerator.isNewLineNeeded((String)psbgenStmt) ? CR + TAB : " ";
        Integer ioasize = psbModel.getIoAreaSize();
        if (ioasize != null && ioasize > 0) {
            psbgenStmt = (String)psbgenStmt + (String)spacing + "IOASIZE " + ioasize.toString();
        }
        spacing = ProgramDDLGenerator.isNewLineNeeded((String)psbgenStmt) ? CR + TAB : " ";
        int maxQ = psbModel.getMaxq();
        if (maxQ > 0) {
            psbgenStmt = (String)psbgenStmt + (String)spacing + "MAXQ " + maxQ;
        }
        spacing = ProgramDDLGenerator.isNewLineNeeded((String)psbgenStmt) ? CR + TAB : " ";
        Integer ssasize = psbModel.getSsaSize();
        if (ssasize != null && ssasize > 0) {
            psbgenStmt = (String)psbgenStmt + (String)spacing + "SSASIZE " + ssasize.toString();
        }
        spacing = ProgramDDLGenerator.isNewLineNeeded((String)psbgenStmt) ? CR + TAB : " ";
        DBDConstants lang = psbModel.getLang();
        if (lang != null) {
            if (lang.value().equals("PL_I")) {
                psbgenStmt = (String)psbgenStmt + (String)spacing + "LANGPLI";
            } else if (!lang.value().equals("BLANK")) {
                psbgenStmt = (String)psbgenStmt + (String)spacing + "LANG" + lang.toString();
            }
        }
        spacing = ProgramDDLGenerator.isNewLineNeeded((String)psbgenStmt) ? CR + TAB : " ";
        Integer ioeropn = psbModel.getIoeropnConditionCode();
        DBDConstants ioeropnwtor = psbModel.getIoeropnWTOR();
        if (ioeropn != null && ioeropn > 0) {
            psbgenStmt = (String)psbgenStmt + (String)spacing + "IOEROPN " + String.valueOf(ioeropn);
            psbgenStmt = ioeropnwtor != null && ioeropnwtor.equals((Object)DBDConstants.Y) ? (String)psbgenStmt + (String)spacing + "WTORYES" : (String)psbgenStmt + (String)spacing + "WTORNO";
        }
        psbgenStmt = DatabaseDDLGenerator.wrapStmt((String)psbgenStmt);
        if (generateComments) {
            String psbName = psbModel.getPsbName();
            if (psbModel.getPsbRemarks() != null) {
                psbgenStmt = (String)psbgenStmt + DatabaseDDLGenerator.wrapStmt(ProgramDDLGenerator.addPsbRemarks(psbModel, psbName));
            }
            Iterator<PcbTPModel> tpIter = tpPcbsWithRemarks.iterator();
            while (tpIter.hasNext()) {
                psbgenStmt = (String)psbgenStmt + DatabaseDDLGenerator.wrapStmt(ProgramDDLGenerator.addPcbRemarks(tpIter.next(), psbName));
            }
            for (PcbDBModel pcbModel : dbPcbsWithRemarks) {
                Object pcbName = pcbModel.getPcbNameOrLabel();
                if (pcbName == null) {
                    pcbName = "PCB#" + pcbModel.getPcbNum();
                }
                psbgenStmt = (String)psbgenStmt + DatabaseDDLGenerator.wrapStmt(ProgramDDLGenerator.addPcbRemarks(pcbModel, psbName));
            }
            for (Object[] currentObject : segmentsWithRemarks) {
                String pcbName = (String)currentObject[0];
                SensegModel senSegModel = (SensegModel)currentObject[1];
                psbgenStmt = (String)psbgenStmt + DatabaseDDLGenerator.wrapStmt(ProgramDDLGenerator.addSensegRemarks(psbName, pcbName, senSegModel));
            }
            for (Object[] currObject : fieldsWithRemarks) {
                String pcbName = (String)currObject[0];
                String segmentName = (String)currObject[1];
                SenfieldModel senfldModel = (SenfieldModel)currObject[2];
                psbgenStmt = (String)psbgenStmt + DatabaseDDLGenerator.wrapStmt(ProgramDDLGenerator.addSenfldRemarks(psbName, pcbName, segmentName, senfldModel));
            }
            Iterator<PcbGsamModel> gsamIter = gsamPcbsWithRemarks.iterator();
            while (gsamIter.hasNext()) {
                psbgenStmt = (String)psbgenStmt + DatabaseDDLGenerator.wrapStmt(ProgramDDLGenerator.addPcbRemarks(gsamIter.next(), psbName));
            }
        }
        return psbgenStmt;
    }

    private static boolean isNewLineNeeded(String string) {
        boolean retVal = false;
        int index = string.lastIndexOf(CR);
        if (index >= 0) {
            String lastLine = string.substring(index + CR.length());
            retVal = lastLine.length() > 61;
        }
        return retVal;
    }

    private static String addPsbRemarks(PsbModel psbModel, String psbName) {
        Object retVal = "";
        String comments = psbModel.getPsbRemarks();
        if (comments != null) {
            retVal = "";
            char aChar = comments.charAt(0);
            char zChar = comments.charAt(comments.length() - 1);
            retVal = aChar != '\'' ? (String)retVal + "COMMENT ON PROGRAMVIEW " + psbName + " IS " + CR + TAB + "'" + comments : (String)retVal + "COMMENT ON PROGRAMVIEW " + psbName + " IS " + CR + TAB + comments;
            if (zChar != '\'') {
                retVal = (String)retVal + "'";
            }
        }
        return retVal;
    }

    private static String addPcbRemarks(PcbTPModel pcbModel, String psbName) {
        Object retVal = "";
        String comments = pcbModel.getRemarks();
        if (comments != null) {
            retVal = "";
            Object pcbName = pcbModel.getPcbNameOrLabel();
            if (pcbName == null) {
                pcbName = "PCB#" + pcbModel.getPcbNum();
            } else if (Utility.isQuoteNeeded((String)pcbName)) {
                pcbName = QUOTE + (String)pcbName + QUOTE;
            }
            char aChar = comments.charAt(0);
            char zChar = comments.charAt(comments.length() - 1);
            retVal = aChar != '\'' ? (String)retVal + "COMMENT ON SCHEMA " + (String)pcbName + " IN " + psbName + " IS " + CR + TAB + "'" + comments : (String)retVal + "COMMENT ONS SCHEMA " + (String)pcbName + " IN " + psbName + " IS " + CR + TAB + comments;
            if (zChar != '\'') {
                retVal = (String)retVal + "'";
            }
        }
        return retVal;
    }

    private static String addPcbRemarks(PcbDBModel pcbModel, String psbName) {
        Object retVal = "";
        String comments = pcbModel.getRemarks();
        if (comments != null) {
            retVal = "";
            Object pcbName = pcbModel.getPcbNameOrLabel();
            if (pcbName == null) {
                pcbName = "PCB#" + pcbModel.getPcbNum();
            } else if (Utility.isQuoteNeeded((String)pcbName)) {
                pcbName = QUOTE + (String)pcbName + QUOTE;
            }
            char aChar = comments.charAt(0);
            char zChar = comments.charAt(comments.length() - 1);
            retVal = aChar != '\'' ? (String)retVal + "COMMENT ON SCHEMA " + (String)pcbName + " IN " + psbName + " IS " + CR + TAB + "'" + comments : (String)retVal + "COMMENT ONS SCHEMA " + (String)pcbName + " IN " + psbName + " IS " + CR + TAB + comments;
            if (zChar != '\'') {
                retVal = (String)retVal + "'";
            }
        }
        return retVal;
    }

    private static String addPcbRemarks(PcbGsamModel pcbModel, String psbName) {
        Object retVal = "";
        String comments = pcbModel.getRemarks();
        if (comments != null) {
            retVal = "";
            Object pcbName = pcbModel.getPcbNameOrLabel();
            if (pcbName == null) {
                pcbName = "PCB#" + pcbModel.getPcbNum();
            } else if (Utility.isQuoteNeeded((String)pcbName)) {
                pcbName = QUOTE + (String)pcbName + QUOTE;
            }
            char aChar = comments.charAt(0);
            char zChar = comments.charAt(comments.length() - 1);
            retVal = aChar != '\'' ? (String)retVal + "COMMENT ON SCHEMA " + (String)pcbName + " IN " + psbName + " IS " + CR + TAB + "'" + comments : (String)retVal + "COMMENT ONS SCHEMA " + (String)pcbName + " IN " + psbName + " IS " + CR + TAB + comments;
            if (zChar != '\'') {
                retVal = (String)retVal + "'";
            }
        }
        return retVal;
    }

    private static String addSensegRemarks(String psbName, String pcbName, SensegModel sensegModel) {
        Object retVal = "";
        String comments = sensegModel.getRemarks();
        if (comments != null) {
            retVal = "";
            Object segmentName = sensegModel.getName();
            if (Utility.isQuoteNeeded((String)segmentName)) {
                segmentName = QUOTE + (String)segmentName + QUOTE;
            }
            if (Utility.isQuoteNeeded((String)pcbName)) {
                pcbName = QUOTE + (String)pcbName + QUOTE;
            }
            char aChar = comments.charAt(0);
            char zChar = comments.charAt(comments.length() - 1);
            retVal = aChar != '\'' ? (String)retVal + "COMMENT ON SENSEGVIEW " + (String)pcbName + "." + (String)segmentName + " IN " + psbName + " IS " + CR + TAB + "'" + comments : (String)retVal + "COMMENT ON SENSEGVIEW " + (String)pcbName + "." + (String)segmentName + " IN " + psbName + " IS " + CR + TAB + comments;
            if (zChar != '\'') {
                retVal = (String)retVal + "'";
            }
        }
        return retVal;
    }

    private static String addSenfldRemarks(String psbName, String pcbName, String segmentName, SenfieldModel senFieldModel) {
        Object retVal = "";
        String comments = senFieldModel.getRemarks();
        if (comments != null && comments.length() > 0) {
            Object fieldName = senFieldModel.getName();
            if (Utility.isQuoteNeeded((String)fieldName)) {
                fieldName = QUOTE + (String)fieldName + QUOTE;
            }
            if (Utility.isQuoteNeeded((String)segmentName)) {
                segmentName = QUOTE + (String)segmentName + QUOTE;
            }
            if (Utility.isQuoteNeeded((String)pcbName)) {
                pcbName = QUOTE + (String)pcbName + QUOTE;
            }
            retVal = "";
            char aChar = comments.charAt(0);
            char zChar = comments.charAt(comments.length() - 1);
            retVal = aChar != '\'' ? (String)retVal + "COMMENT ON SENFLD " + (String)pcbName + "." + (String)segmentName + "." + (String)fieldName + " IN " + psbName + " IS " + CR + TAB + "'" + comments : (String)retVal + "COMMENT ON SENFLD " + (String)pcbName + "." + (String)segmentName + "." + (String)fieldName + " IN " + psbName + " IS " + CR + TAB + comments;
            if (zChar != '\'') {
                retVal = (String)retVal + "'";
            }
        }
        return retVal;
    }

    public static String remarksHelper(String comments) {
        int commentsLen = comments.length();
        StringBuffer cbuf = new StringBuffer(commentsLen + 10);
        cbuf.append(comments);
        int i = 0;
        while (i < commentsLen) {
            char currentChar = cbuf.charAt(i);
            if (currentChar == '\'') {
                cbuf.insert(i + 1, '\'');
                ++commentsLen;
                ++i;
            }
            ++i;
        }
        cbuf.insert(0, '\'');
        cbuf.insert(commentsLen + 1, '\'');
        return cbuf.toString();
    }

    public static String genPsbDdl(String projectName, PsbModel psbModel, ArrayList<String> schemas, boolean isDrop, boolean autoDrop, boolean genComments) {
        Object genPsbSource = "";
        try {
            tpPcbsWithRemarks = new Vector();
            dbPcbsWithRemarks = new Vector();
            gsamPcbsWithRemarks = new Vector();
            segmentsWithRemarks = new Vector();
            fieldsWithRemarks = new Vector();
            numberOfPcbs = 0;
            schemaNames = schemas;
            isDropProgram = isDrop;
            isAutoDrop = autoDrop;
            generateComments = genComments;
            String psbStmt = ProgramDDLGenerator.genPSBStmts(psbModel);
            if (!isDrop) {
                String pcbStmts = ProgramDDLGenerator.genPCBStmts(projectName, psbModel);
                String psbgenStmt = ProgramDDLGenerator.genPSBGENStmt(psbModel);
                genPsbSource = psbStmt + pcbStmts + psbgenStmt;
            } else {
                genPsbSource = psbStmt;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return genPsbSource;
    }
}

