/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PcbTPModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PSBSourceGenerator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static boolean catalogEnabled = false;

    public static ByteArrayInputStream genPsbSrc(PsbModel psbModel, boolean genOption) {
        ByteArrayInputStream genSrcPsbInputStream = null;
        catalogEnabled = genOption;
        try {
            String pcbStmts = PSBSourceGenerator.genPCBStmts(psbModel);
            String psbgenStmt = PSBSourceGenerator.genPSBGENStmt(psbModel);
            String genPsbSource = pcbStmts + psbgenStmt + "         END                                                            ";
            genSrcPsbInputStream = new ByteArrayInputStream(genPsbSource.getBytes());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return genSrcPsbInputStream;
    }

    private static String genPCBStmts(PsbModel psbModel) throws ModelException {
        List<PcbGsamModel> gsamPcbList;
        List<PcbDBModel> dbPcbList;
        Object pcbStmts = "";
        List<PcbTPModel> tpPcbList = psbModel.getTPPcbList();
        if (tpPcbList != null && tpPcbList.size() > 0) {
            pcbStmts = (String)pcbStmts + PSBSourceGenerator.genTPPCBStmts(tpPcbList);
        }
        if ((dbPcbList = psbModel.getDBPcbList()) != null && dbPcbList.size() > 0) {
            pcbStmts = (String)pcbStmts + PSBSourceGenerator.genDBPCBStmts(dbPcbList);
        }
        if ((gsamPcbList = psbModel.getGsamPcbList()) != null && gsamPcbList.size() > 0) {
            pcbStmts = (String)pcbStmts + PSBSourceGenerator.genGSAMPCBStmts(gsamPcbList);
        }
        return pcbStmts;
    }

    private static String genTPPCBStmts(List<PcbTPModel> tpPcbList) {
        Iterator<PcbTPModel> tpPcbIter = tpPcbList.iterator();
        Object tpPcbStmts = "";
        while (tpPcbIter.hasNext()) {
            DBDConstants list;
            String pcbExternalName;
            PcbTPModel pcbModel = tpPcbIter.next();
            Object pcbStmt = "";
            String label = pcbModel.getLabel();
            if (label == null) {
                pcbStmt = "         PCB TYPE=TP";
            } else {
                int spacesNeeded = 9 - label.length();
                Object spaces = "";
                int j = 0;
                while (j < spacesNeeded) {
                    spaces = (String)spaces + " ";
                    ++j;
                }
                pcbStmt = label + (String)spaces + "PCB TYPE=TP";
            }
            String lterm = pcbModel.getLtermName();
            if (lterm != null) {
                pcbStmt = (String)pcbStmt + ",LTERM=" + lterm;
            } else {
                String trancodeName = pcbModel.getTrancodeName();
                if (trancodeName != null) {
                    pcbStmt = (String)pcbStmt + ",NAME=" + trancodeName;
                }
            }
            DBDConstants altresp = pcbModel.getAltresp();
            if (altresp.toString().equals("Y")) {
                pcbStmt = (String)pcbStmt + ",ALTRESP=YES";
            } else if (altresp.toString().equals("N")) {
                pcbStmt = (String)pcbStmt + ",ALTRESP=NO";
            }
            DBDConstants sametrm = pcbModel.getSametrm();
            if (sametrm.toString().equals("Y")) {
                pcbStmt = (String)pcbStmt + ",SAMETRM=YES";
            } else if (sametrm.toString().equals("N")) {
                pcbStmt = (String)pcbStmt + ",SAMETRM=NO";
            }
            DBDConstants modify = pcbModel.getModify();
            if (modify.toString().equals("Y")) {
                pcbStmt = (String)pcbStmt + ",MODIFY=YES";
            } else if (modify.toString().equals("N")) {
                pcbStmt = (String)pcbStmt + ",MODIFY=NO";
            }
            DBDConstants express = pcbModel.getExpress();
            if (express.toString().equals("Y")) {
                pcbStmt = (String)pcbStmt + ",EXPRESS=YES";
            } else if (express.toString().equals("N")) {
                pcbStmt = (String)pcbStmt + ",EXPRESS=NO";
            }
            String pcbName = pcbModel.getPcbName();
            if (pcbName != null) {
                pcbStmt = (String)pcbStmt + ",PCBNAME=" + pcbName;
            }
            if (catalogEnabled && (pcbExternalName = pcbModel.getExternalName()) != null) {
                pcbStmt = (String)pcbStmt + ",EXTERNALNAME=" + pcbExternalName;
            }
            if ((list = pcbModel.getList()) == null) {
                pcbStmt = (String)pcbStmt + ",LIST=YES";
            } else if (list.toString().equals("Y")) {
                pcbStmt = (String)pcbStmt + ",LIST=YES";
            } else if (list.toString().equals("N")) {
                pcbStmt = (String)pcbStmt + ",LIST=NO";
            }
            if (catalogEnabled) {
                pcbStmt = PSBSourceGenerator.addPcbRemarks((String)pcbStmt, pcbModel);
            }
            tpPcbStmts = (String)tpPcbStmts + DBDSourceGenerator.wrapStmt((String)pcbStmt) + "\n";
        }
        return tpPcbStmts;
    }

    private static String genDBPCBStmts(List<PcbDBModel> dbPcbList) throws ModelException {
        Iterator<PcbDBModel> dbPcbIter = dbPcbList.iterator();
        Object dbPcbStmts = "";
        while (dbPcbIter.hasNext()) {
            DBDConstants list;
            DBDConstants view;
            String accessType;
            String pselopt;
            String procseqd;
            String procopt;
            Integer dbverInt;
            String pcbExternalName;
            PcbDBModel pcbModel = dbPcbIter.next();
            Object pcbStmt = "";
            String label = pcbModel.getLabel();
            if (label == null) {
                pcbStmt = "         PCB TYPE=DB";
            } else {
                int spacesNeeded = 9 - label.length();
                Object spaces = "";
                int j = 0;
                while (j < spacesNeeded) {
                    spaces = (String)spaces + " ";
                    ++j;
                }
                pcbStmt = label + (String)spaces + "PCB TYPE=DB";
            }
            pcbStmt = (String)pcbStmt + ",DBDNAME=" + pcbModel.getDbdName();
            String pcbName = pcbModel.getPcbName();
            if (pcbName != null) {
                pcbStmt = (String)pcbStmt + ",PCBNAME=" + pcbName;
            }
            if (catalogEnabled && (pcbExternalName = pcbModel.getExternalName()) != null) {
                pcbStmt = (String)pcbStmt + ",EXTERNALNAME=" + pcbExternalName;
            }
            if ((dbverInt = pcbModel.getDbdUserVersion()) != null) {
                pcbStmt = (String)pcbStmt + ",DBVER=" + dbverInt.toString();
            }
            pcbStmt = (procopt = pcbModel.getProcopt()) == null ? (String)pcbStmt + ",PROCOPT=A" : (String)pcbStmt + ",PROCOPT=" + procopt;
            pcbStmt = (String)pcbStmt + ",SB=" + pcbModel.getSb().toString();
            pcbStmt = (String)pcbStmt + ",KEYLEN=" + pcbModel.getKeyLength();
            DBDConstants pos = pcbModel.getPos();
            if (pos == null) {
                pcbStmt = (String)pcbStmt + ",POS=SINGLE";
            } else if (pos.toString().equals("S")) {
                pcbStmt = (String)pcbStmt + ",POS=SINGLE";
            } else if (pos.toString().equals("M")) {
                pcbStmt = (String)pcbStmt + ",POS=MULTIPLE";
            }
            String procseq = pcbModel.getProcSequence();
            if (procseq != null && !procseq.isEmpty()) {
                pcbStmt = (String)pcbStmt + ",PROCSEQ=" + procseq;
            }
            if ((procseqd = pcbModel.getProcSequenceD()) != null && !procseqd.isEmpty()) {
                pcbStmt = (String)pcbStmt + ",PROCSEQD=" + procseqd;
            }
            if ((pselopt = pcbModel.getPselOpt()) != null) {
                if (pselopt.equals("S")) {
                    pcbStmt = (String)pcbStmt + ",PSELOPT=SNGL";
                } else if (pselopt.equals("M")) {
                    pcbStmt = (String)pcbStmt + ",PSELOPT=MULT";
                }
            }
            if ((accessType = pcbModel.getAccess()) != null) {
                if (accessType.equals("D")) {
                    pcbStmt = (String)pcbStmt + ",ACCESS=DB";
                } else if (accessType.equals("I")) {
                    pcbStmt = (String)pcbStmt + ",ACCESS=INDEX";
                }
            }
            if ((view = pcbModel.getView()) != null) {
                pcbStmt = (String)pcbStmt + ",VIEW=" + view.toString();
            }
            if ((list = pcbModel.getList()) == null) {
                pcbStmt = (String)pcbStmt + ",LIST=YES";
            } else if (list.toString().equals("Y")) {
                pcbStmt = (String)pcbStmt + ",LIST=YES";
            } else if (list.toString().equals("N")) {
                pcbStmt = (String)pcbStmt + ",LIST=NO";
            }
            if (catalogEnabled) {
                pcbStmt = PSBSourceGenerator.addPcbRemarks((String)pcbStmt, pcbModel);
            }
            SensegModel rootSenseg = pcbModel.getRootSenseg();
            Object SensegSenfldStmts = "";
            if (rootSenseg != null) {
                SensegSenfldStmts = (String)SensegSenfldStmts + PSBSourceGenerator.genSensegSenfldStmts(rootSenseg, pcbModel);
            }
            dbPcbStmts = (String)dbPcbStmts + DBDSourceGenerator.wrapStmt((String)pcbStmt) + (String)SensegSenfldStmts + "\n";
        }
        return dbPcbStmts;
    }

    private static String genGSAMPCBStmts(List<PcbGsamModel> gsamPcbList) {
        Iterator<PcbGsamModel> gsamPcbIter = gsamPcbList.iterator();
        Object gsamPcbStmts = "";
        while (gsamPcbIter.hasNext()) {
            DBDConstants list;
            String pcbExternalName;
            PcbGsamModel pcbModel = gsamPcbIter.next();
            Object pcbStmt = "";
            String label = pcbModel.getLabel();
            if (label == null) {
                pcbStmt = "         PCB TYPE=GSAM";
            } else {
                int spacesNeeded = 9 - label.length();
                Object spaces = "";
                int j = 0;
                while (j < spacesNeeded) {
                    spaces = (String)spaces + " ";
                    ++j;
                }
                pcbStmt = label + (String)spaces + "PCB TYPE=GSAM";
            }
            pcbStmt = (String)pcbStmt + ",DBDNAME=" + pcbModel.getDbdName();
            DBDConstants procopt = pcbModel.getProcopt();
            pcbStmt = procopt == null ? (String)pcbStmt + ",PROCOPT=G" : (String)pcbStmt + ",PROCOPT=" + procopt.toString();
            String pcbName = pcbModel.getPcbName();
            if (pcbName != null) {
                pcbStmt = (String)pcbStmt + ",PCBNAME=" + pcbName;
            }
            if (catalogEnabled && (pcbExternalName = pcbModel.getExternalName()) != null) {
                pcbStmt = (String)pcbStmt + ",EXTERNALNAME=" + pcbExternalName;
            }
            if ((list = pcbModel.getList()) == null) {
                pcbStmt = (String)pcbStmt + ",LIST=YES";
            } else if (list.toString().equals("Y")) {
                pcbStmt = (String)pcbStmt + ",LIST=YES";
            } else if (list.toString().equals("N")) {
                pcbStmt = (String)pcbStmt + ",LIST=NO";
            }
            if (catalogEnabled) {
                pcbStmt = PSBSourceGenerator.addPcbRemarks((String)pcbStmt, pcbModel);
            }
            gsamPcbStmts = (String)gsamPcbStmts + DBDSourceGenerator.wrapStmt((String)pcbStmt) + "\n";
        }
        return gsamPcbStmts;
    }

    private static String genSensegSenfldStmts(SensegModel currentSenseg, PcbDBModel pcbModel) throws ModelException {
        ArrayList<SensegModel> sensegList;
        String comments;
        List<String> indicesList;
        int numSsptrs;
        Object sensegStmts = "";
        Object oneSensegStmt = "";
        oneSensegStmt = (String)oneSensegStmt + "\n         SENSEG NAME=" + currentSenseg.getName();
        SensegModel parent = currentSenseg.getParent();
        oneSensegStmt = parent == null ? (String)oneSensegStmt + ",PARENT=0" : (String)oneSensegStmt + ",PARENT=" + parent.getName();
        String procopt = currentSenseg.getProcopt();
        if (procopt != null && procopt.trim().length() > 0) {
            oneSensegStmt = (String)oneSensegStmt + ",PROCOPT=" + procopt;
        }
        if ((numSsptrs = currentSenseg.getSsptrListSize()) > 0) {
            oneSensegStmt = (String)oneSensegStmt + ",SSPTR=(";
            int i = 0;
            while (i < numSsptrs) {
                oneSensegStmt = (String)oneSensegStmt + "(" + currentSenseg.getSsptrNum(i) + ",";
                String ssptrSensitivity = currentSenseg.getSsptrSensitivity(i);
                oneSensegStmt = (String)oneSensegStmt + ssptrSensitivity + ")";
                if (i < numSsptrs - 1) {
                    oneSensegStmt = (String)oneSensegStmt + ",";
                }
                ++i;
            }
            oneSensegStmt = (String)oneSensegStmt + ")";
        }
        if ((indicesList = currentSenseg.getIndices()) != null && !indicesList.isEmpty()) {
            Iterator<String> indicesIter = indicesList.iterator();
            oneSensegStmt = (String)oneSensegStmt + ",INDICES=(";
            while (indicesIter.hasNext()) {
                oneSensegStmt = (String)oneSensegStmt + indicesIter.next();
                if (!indicesIter.hasNext()) continue;
                oneSensegStmt = (String)oneSensegStmt + ",";
            }
            oneSensegStmt = (String)oneSensegStmt + ")";
        }
        if (catalogEnabled && (comments = currentSenseg.getRemarks()) != null && !comments.isEmpty()) {
            oneSensegStmt = (String)oneSensegStmt + ",REMARKS=" + PSBSourceGenerator.remarksHelper(comments);
        }
        sensegStmts = (String)sensegStmts + DBDSourceGenerator.wrapStmt((String)oneSensegStmt);
        ArrayList<SenfieldModel> senfldList = currentSenseg.getSenfields();
        if (senfldList != null && !senfldList.isEmpty()) {
            Iterator<SenfieldModel> senfldIter = senfldList.iterator();
            Object senfldStmts = "";
            while (senfldIter.hasNext()) {
                String comments2;
                SenfieldModel senfld = senfldIter.next();
                boolean isProcoptKSpecified = false;
                boolean isProcoptIorL = false;
                String sensegProcoptStr = currentSenseg.getProcopt();
                if (sensegProcoptStr != null && "K".equals(sensegProcoptStr)) {
                    isProcoptKSpecified = true;
                }
                if (sensegProcoptStr != null && sensegProcoptStr.length() > 0) {
                    isProcoptIorL = PSBSourceGenerator.isProcoptIorL(sensegProcoptStr);
                } else {
                    sensegProcoptStr = pcbModel.getProcopt();
                    if (sensegProcoptStr != null) {
                        isProcoptIorL = PSBSourceGenerator.isProcoptIorL(sensegProcoptStr);
                    }
                }
                boolean isFieldLogicalChild = senfld.isLogicalChild();
                if (isProcoptKSpecified || isProcoptIorL && isFieldLogicalChild) continue;
                Object oneSenfldStmt = "";
                oneSenfldStmt = (String)oneSenfldStmt + "\n         SENFLD NAME=" + senfld.getName();
                oneSenfldStmt = (String)oneSenfldStmt + ",START=" + Integer.toString(senfld.getStart());
                DBDConstants replace = senfld.getReplace();
                if (replace != null) {
                    if (replace.toString().equals("Y")) {
                        oneSenfldStmt = (String)oneSenfldStmt + ",REPL=YES";
                    } else if (replace.toString().equals("N")) {
                        oneSenfldStmt = (String)oneSenfldStmt + ",REPL=NO";
                    }
                } else {
                    oneSenfldStmt = (String)oneSenfldStmt + ",REPL=YES";
                }
                if (catalogEnabled && (comments2 = senfld.getRemarks()) != null && comments2.length() > 0) {
                    char aChar = comments2.charAt(0);
                    char zChar = comments2.charAt(comments2.length() - 1);
                    oneSenfldStmt = aChar != '\'' ? (String)oneSenfldStmt + ",REMARKS='" + comments2 : (String)oneSenfldStmt + ",REMARKS=" + comments2;
                    if (zChar != '\'') {
                        oneSenfldStmt = (String)oneSenfldStmt + "'";
                    }
                }
                senfldStmts = (String)senfldStmts + DBDSourceGenerator.wrapStmt((String)oneSenfldStmt);
            }
            sensegStmts = (String)sensegStmts + (String)senfldStmts;
        }
        if ((sensegList = currentSenseg.getChildren()) != null && !sensegList.isEmpty()) {
            Iterator<SensegModel> childrenSensegIter = sensegList.iterator();
            while (childrenSensegIter.hasNext()) {
                sensegStmts = (String)sensegStmts + PSBSourceGenerator.genSensegSenfldStmts(childrenSensegIter.next(), pcbModel);
            }
        }
        return sensegStmts;
    }

    private static boolean isProcoptIorL(String sensegProcoptStr) {
        int i = 0;
        while (i < sensegProcoptStr.length()) {
            char currChar = sensegProcoptStr.charAt(i);
            if (currChar == 'I' || currChar == 'L') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String genPSBGENStmt(PsbModel psbModel) {
        String comments;
        DBDConstants olic;
        Integer ssasize;
        DBDConstants lang;
        String psbgenStmt = "         PSBGEN PSBNAME=" + psbModel.getPsbName();
        String dblevel = psbModel.getDblevel();
        if (dblevel != null && !dblevel.isEmpty()) {
            psbgenStmt = psbgenStmt + ",DBLEVEL=" + dblevel;
        }
        if ((lang = psbModel.getLang()) != null) {
            psbgenStmt = lang.value().equals("PL_I") ? psbgenStmt + ",LANG=PL/I" : (lang.value().equals("BLANK") ? psbgenStmt + ",LANG=" : psbgenStmt + ",LANG=" + lang.toString());
        }
        psbgenStmt = psbgenStmt + ",MAXQ=" + psbModel.getMaxq();
        DBDConstants cmpat = psbModel.getCompat();
        if (cmpat != null) {
            if (cmpat.toString().equals("Y")) {
                psbgenStmt = psbgenStmt + ",CMPAT=YES";
            } else if (cmpat.toString().equals("N")) {
                psbgenStmt = psbgenStmt + ",CMPAT=NO";
            }
        } else {
            psbgenStmt = psbgenStmt + ",CMPAT=NO";
        }
        Integer ioasize = psbModel.getIoAreaSize();
        if (ioasize != null) {
            psbgenStmt = psbgenStmt + ",IOASIZE=" + ioasize.toString();
        }
        if ((ssasize = psbModel.getSsaSize()) != null) {
            psbgenStmt = psbgenStmt + ",SSASIZE=" + ssasize.toString();
        }
        Integer ioeropn = psbModel.getIoeropnConditionCode();
        DBDConstants ioeropnwtor = psbModel.getIoeropnWTOR();
        if (ioeropn != null) {
            psbgenStmt = ioeropnwtor != null ? (ioeropnwtor.equals((Object)DBDConstants.Y) ? psbgenStmt + ",IOEROPN=(" + ioeropn.toString() + "," + String.valueOf((Object)DBDConstants.WTOR) + ")" : psbgenStmt + ",IOEROPN=(" + ioeropn.toString() + ")") : psbgenStmt + ",IOEROPN=" + ioeropn.toString();
        }
        if ((olic = psbModel.getOnlineDBImageCopy()) != null) {
            if (olic.toString().equals("Y")) {
                psbgenStmt = psbgenStmt + ",OLIC=YES";
            } else if (olic.toString().equals("N")) {
                psbgenStmt = psbgenStmt + ",OLIC=NO";
            }
        } else {
            psbgenStmt = psbgenStmt + ",OLIC=NO";
        }
        DBDConstants gsrolbok = psbModel.getGsamRollb();
        if (gsrolbok != null) {
            if (gsrolbok.toString().equals("Y")) {
                psbgenStmt = psbgenStmt + ",GSROLBOK=YES";
            } else if (gsrolbok.toString().equals("N")) {
                psbgenStmt = psbgenStmt + ",GSROLBOK=NO";
            }
        } else {
            psbgenStmt = psbgenStmt + ",GSROLBOK=NO";
        }
        Integer lockmax = psbModel.getMaximumLock();
        psbgenStmt = lockmax != null ? psbgenStmt + ",LOCKMAX=" + lockmax.toString() : psbgenStmt + ",LOCKMAX=0";
        if (catalogEnabled && (comments = psbModel.getPsbRemarks()) != null) {
            char aChar = comments.charAt(0);
            char zChar = comments.charAt(comments.length() - 1);
            psbgenStmt = aChar != '\'' ? psbgenStmt + ",REMARKS='" + comments : psbgenStmt + ",REMARKS=" + comments;
            if (zChar != '\'') {
                psbgenStmt = psbgenStmt + "'";
            }
        }
        return DBDSourceGenerator.wrapStmt(psbgenStmt) + "\n";
    }

    private static String addPcbRemarks(String pcbStmt, PcbTPModel pcbModel) {
        String comments = pcbModel.getRemarks();
        if (comments != null) {
            char aChar = comments.charAt(0);
            char zChar = comments.charAt(comments.length() - 1);
            pcbStmt = aChar != '\'' ? (String)pcbStmt + ",REMARKS='" + comments : (String)pcbStmt + ",REMARKS=" + comments;
            if (zChar != '\'') {
                pcbStmt = (String)pcbStmt + "'";
            }
        }
        return pcbStmt;
    }

    private static String addPcbRemarks(String pcbStmt, PcbDBModel pcbModel) {
        String comments = pcbModel.getRemarks();
        if (comments != null) {
            char aChar = comments.charAt(0);
            char zChar = comments.charAt(comments.length() - 1);
            pcbStmt = aChar != '\'' ? (String)pcbStmt + ",REMARKS='" + comments : (String)pcbStmt + ",REMARKS=" + comments;
            if (zChar != '\'') {
                pcbStmt = (String)pcbStmt + "'";
            }
        }
        return pcbStmt;
    }

    private static String addPcbRemarks(String pcbStmt, PcbGsamModel pcbModel) {
        String comments = pcbModel.getRemarks();
        if (comments != null && !comments.isEmpty()) {
            pcbStmt = (String)pcbStmt + ",REMARKS=" + PSBSourceGenerator.remarksHelper(comments);
        }
        return pcbStmt;
    }

    public static String remarksHelper(String comments) {
        int commentsLen = comments.length();
        StringBuffer cbuf = new StringBuffer(commentsLen + 10);
        cbuf.append(comments);
        int i = 0;
        while (i < commentsLen) {
            char currentChar = cbuf.charAt(i);
            if (currentChar == '\'') {
                cbuf.insert(i + 1, '\'');
                ++commentsLen;
                ++i;
            }
            ++i;
        }
        cbuf.insert(0, '\'');
        cbuf.insert(commentsLen + 1, '\'');
        return cbuf.toString();
    }
}

