/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.metadata.dbd.RecfmType;
import com.ibm.im.ims.metadata.psb.AccessFPIndexType;
import com.ibm.im.ims.metadata.psb.IndicesType;
import com.ibm.im.ims.metadata.psb.PseloptType;
import com.ibm.im.ims.metadata.psb.SenfldType;
import com.ibm.im.ims.metadata.psb.SensegType;
import com.ibm.im.ims.metadata.psb.SsptrSensitivityType;
import com.ibm.im.ims.metadata.psb.SsptrType;
import com.ibm.im.ims.metadata.psb.YesnoType;
import com.ibm.im.ims.workbench.model.AreaStmt;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DataExitRoutine;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.FieldModelImpl;
import com.ibm.im.ims.workbench.model.HidamDataSetModel;
import com.ibm.im.ims.workbench.model.IImsResourceModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PcbTPModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.SysRelFieldModel;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ModelErrorMessages;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.NameValidator;
import com.ibm.im.ims.workbench.model.utilities.Statement;
import com.ibm.im.ims.workbench.model.utilities.StatementSet;
import com.ibm.im.ims.workbench.model.utilities.StatementSetReader;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class IMSSourceImporter {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Vector<ImporterException> warnings;
    private boolean modelFoundInFile = false;
    private String currMapName;
    private int exitParmCount;
    private StatementSetReader currentSSReader = null;
    private IImsResourceModel currentModel;
    private Vector<ImporterException> importerExceptions = null;
    private static final int EXITNAME = 1001;
    private static final int ASTRIXNAME = 1002;
    private static final int INSIDECASCADE = 1003;
    private static final int OUTSIDECASCADE = 1004;

    public ArrayList<StatementSet> createStatementSets(String filePath) throws IOException, ImporterException {
        StatementSetReader srdr = new StatementSetReader();
        ArrayList<StatementSet> statementSets = srdr.getStatementSet(filePath);
        return statementSets;
    }

    public void setImportResourcePath(BufferedReader fileReader, String filePath) throws IOException, ImporterException {
        this.modelFoundInFile = false;
        this.currentSSReader = new StatementSetReader(fileReader, filePath);
    }

    public void resetSSReader() {
        this.currentSSReader = null;
    }

    public String getPath() {
        return this.currentSSReader.getFilePath();
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasMoreModels() throws IOException {
        retVal = false;
        if (this.currentModel != null) {
            return true;
        }
        if (this.currentSSReader == null) {
            return false;
        }
        needNextModel = true;
        ** GOTO lbl29
        {
            block8: {
                this.currentModel = this.processStatementSet(this.currentSSReader.nextStatementSet());
                if (this.currentModel == null) break block8;
                this.modelFoundInFile = true;
                return true;
            }
            do {
                try {
                    if (this.currentSSReader.hasMoreStatementSets()) continue block3;
                    needNextModel = false;
                    this.currentSSReader = null;
                }
                catch (ImporterException e) {
                    if (this.importerExceptions == null) {
                        this.importerExceptions = new Vector<E>();
                    }
                    this.importerExceptions.add(e);
                    if (e.getErrorCode() != ImporterException.SEVERITY.SEVERE) continue;
                    this.currentModel = null;
                    this.currentSSReader = null;
                    return false;
                }
lbl29:
                // 3 sources

            } while (needNextModel);
        }
        return retVal;
    }

    public Vector<ImporterException> getImporterExceptions() {
        if (this.modelFoundInFile) {
            return null;
        }
        return this.importerExceptions;
    }

    public int getBytesRead() {
        if (this.currentSSReader != null) {
            return this.currentSSReader.getBytesRead();
        }
        return 0;
    }

    public IImsResourceModel getNextResourceModel() throws ImporterException, IOException {
        IImsResourceModel retVal = this.currentModel;
        this.currentModel = null;
        return retVal;
    }

    public ArrayList<StatementSet> createStatementSets(ByteArrayOutputStream outStream, String filePath) throws IOException, ImporterException {
        StatementSetReader srdr = new StatementSetReader();
        ArrayList<StatementSet> statementSets = srdr.getStatementSets(outStream, filePath, false);
        return statementSets;
    }

    public Vector<IImsResourceModel> importImsResource(String filePath) throws IOException, ImporterException {
        Vector<IImsResourceModel> retVal;
        StatementSetReader srdr = new StatementSetReader();
        ArrayList<StatementSet> statementSets = srdr.getStatementSet(filePath);
        try {
            retVal = this.processStatementSets(statementSets);
        }
        catch (ModelException e) {
            throw new ImporterException(e);
        }
        return retVal;
    }

    private Vector<IImsResourceModel> processStatementSets(ArrayList<StatementSet> statementSets) throws ImporterException, ModelException {
        Vector<IImsResourceModel> retVal = new Vector<IImsResourceModel>();
        for (StatementSet sSet : statementSets) {
            if (sSet.getStatementByType("PSBGEN") != null) {
                PsbModel currPsb = this.importPsb(sSet);
                retVal.add(currPsb);
                continue;
            }
            if (sSet.getStatementByType("DBD") != null) {
                DbdModel currDbd = this.importDbd(sSet);
                retVal.add(currDbd);
                continue;
            }
            Object[] inserts = new Object[1];
            String errorMsg = null;
            if (sSet.statements.size() >= 1) {
                String stmtContents = ((Statement)sSet.statements.get(0)).getStatementContents();
                inserts[0] = stmtContents;
                errorMsg = WorkbenchModelBundle.getError().getString("IMPORT_WIZ_006", inserts);
            } else {
                inserts[0] = sSet.filePath;
                errorMsg = WorkbenchModelBundle.getError().getString("IMPORT_WIZ_013", inserts);
            }
            throw new ImporterException(errorMsg, ImporterException.SEVERITY.SEVERE);
        }
        return retVal;
    }

    public IImsResourceModel processStatementSet(StatementSet sSet) throws ImporterException {
        IImsResourceModel retVal;
        block6: {
            retVal = null;
            try {
                if (sSet.getStatementByType("PSBGEN") != null) {
                    retVal = this.importPsb(sSet);
                    break block6;
                }
                if (sSet.getStatementByType("DBD") != null) {
                    retVal = this.importDbd(sSet);
                    break block6;
                }
                Object[] inserts = new Object[1];
                String errorMsg = null;
                if (sSet.statements.size() >= 1) {
                    String stmtContents = ((Statement)sSet.statements.get(0)).getStatementContents();
                    inserts[0] = stmtContents;
                    errorMsg = WorkbenchModelBundle.getError().getString("IMPORT_WIZ_006", inserts);
                } else {
                    inserts[0] = sSet.filePath;
                    errorMsg = WorkbenchModelBundle.getError().getString("IMPORT_WIZ_013", inserts);
                }
                throw new ImporterException(errorMsg, ImporterException.SEVERITY.SEVERE);
            }
            catch (ModelException e) {
                throw new ImporterException(e);
            }
        }
        return retVal;
    }

    public DbdModel quickDBDParse(String filePath) throws IOException, ImporterException {
        DbdModel newDbd = null;
        StatementSetReader srdr = new StatementSetReader();
        if (srdr.getQuickStatementSet(filePath)) {
            try {
                newDbd = new DbdModel();
                newDbd.setAccessType(srdr.getAccessType());
            }
            catch (ModelException e) {
                throw new ImporterException(e);
            }
            newDbd.setPartiallyParsed(true);
            newDbd.setDbdName(srdr.getDbdName());
        }
        return newDbd;
    }

    public DbdModel importReferencedDBD(String filePath) throws IOException, ImporterException {
        if (this.warnings == null) {
            this.warnings = new Vector();
        } else {
            this.warnings.clear();
        }
        DbdModel newDbd = null;
        StatementSetReader srdr = new StatementSetReader();
        ArrayList<StatementSet> statementSets = srdr.getStatementSet(filePath);
        if (statementSets.size() > 0) {
            StatementSet sSet = statementSets.get(0);
            try {
                newDbd = this.importDbd(sSet);
            }
            catch (ModelException e) {
                throw new ImporterException(e);
            }
        }
        return newDbd;
    }

    private DbdModel importDbd(StatementSet sSet) throws ImporterException, ModelException {
        DbdModel newDbd = this.handleDbd(sSet);
        boolean endReached = false;
        boolean dbdgenEncountered = false;
        int i = 0;
        while (i < sSet.statements.size()) {
            Statement tempS = (Statement)sSet.statements.elementAt(i);
            if (tempS == null && !endReached) {
                Object[] inserts = new Object[]{newDbd.getDBDName()};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE001", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
            if (tempS.type.equals(DBDConstants.DBDGEN.toString())) {
                dbdgenEncountered = true;
            }
            if (tempS.type.equals(DBDConstants.END.toString())) {
                endReached = true;
            }
            ++i;
        }
        if (!dbdgenEncountered) {
            Object[] inserts = new Object[]{DBDConstants.DBDGEN.toString(), newDbd.getDBDName()};
            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE007", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        if (!endReached) {
            Object[] inserts = new Object[]{DBDConstants.END.toString(), newDbd.getDBDName()};
            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE007", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        return newDbd;
    }

    private PsbModel importPsb(StatementSet sSet) throws ImporterException, ModelException {
        PsbModel newPsb = this.handlePsb(sSet);
        boolean endReached = false;
        boolean psbgenEncountered = false;
        int i = 0;
        while (i < sSet.statements.size()) {
            Statement tempS = (Statement)sSet.statements.elementAt(i);
            if (tempS == null && !endReached) {
                Object[] inserts = new Object[]{newPsb.getPsbName()};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE010", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
            if (tempS.type.equals(DBDConstants.PSBGEN.toString())) {
                psbgenEncountered = true;
            }
            if (tempS.type.equals(DBDConstants.END.toString())) {
                endReached = true;
            }
            ++i;
        }
        if (!psbgenEncountered) {
            Object[] inserts = new Object[]{DBDConstants.PSBGEN.toString(), newPsb.getPsbName()};
            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE009", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        if (!endReached) {
            Object[] inserts = new Object[]{DBDConstants.END.toString(), newPsb.getPsbName()};
            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE009", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        return newPsb;
    }

    public Vector<ImporterException> getWarnings() {
        return this.warnings;
    }

    private PsbModel handlePsb(StatementSet sSet) throws ImporterException, ModelException {
        String remarks;
        String olic;
        String ioeropnw;
        String ioeropnn;
        String ssasize;
        String cmpat;
        String maxq;
        Statement stmt = sSet.getStatementByType("PSBGEN");
        if (stmt == null) {
            return null;
        }
        PsbModel psb = new PsbModel();
        psb.setPsbName(stmt.getParameterTokenByName("PSBNAME", 0, 0, true));
        psb.setDblevel(stmt.getParameterTokenByName("DBLEVEL", 0, 0, false));
        String lang = stmt.getParameterTokenByName("LANG", 0, 0, false);
        if (lang != null) {
            if (lang.equalsIgnoreCase("COBOL")) {
                psb.setLang(DBDConstants.COBOL);
            } else if (lang.equalsIgnoreCase("PLI")) {
                psb.setLang(DBDConstants.PL_I);
            } else if (lang.equalsIgnoreCase("PL1")) {
                psb.setLang(DBDConstants.PL_I);
            } else if (lang.equalsIgnoreCase("PL/I")) {
                psb.setLang(DBDConstants.PL_I);
            } else if (lang.equalsIgnoreCase("PL/1")) {
                psb.setLang(DBDConstants.PL_I);
            } else if (lang.equalsIgnoreCase("ASSEM")) {
                psb.setLang(DBDConstants.ASSEM);
            } else if (lang.equalsIgnoreCase("JAVA")) {
                psb.setLang(DBDConstants.JAVA);
            } else if (lang.equalsIgnoreCase("PASCAL")) {
                psb.setLang(DBDConstants.PASCAL);
            } else {
                psb.setLang(DBDConstants.BLANK);
            }
        }
        if ((maxq = stmt.getParameterTokenByName("MAXQ", 0, 0, false)) != null) {
            psb.setMaxq(Integer.valueOf(maxq));
        }
        if ((cmpat = stmt.getParameterTokenByName("CMPAT", 0, 0, false)) != null && cmpat.equalsIgnoreCase("YES")) {
            psb.setCompat(DBDConstants.Y);
        } else {
            psb.setCompat(DBDConstants.N);
        }
        String ioasize = stmt.getParameterTokenByName("IOASIZE", 0, 0, false);
        if (ioasize != null) {
            psb.setIoAreaSize(Integer.valueOf(ioasize));
        }
        if ((ssasize = stmt.getParameterTokenByName("SSASIZE", 0, 0, false)) != null) {
            psb.setSsaSize(Integer.valueOf(ssasize));
        }
        if ((ioeropnn = stmt.getParameterTokenByName("IOEROPN", 0, 0, false)) != null) {
            psb.setIoeropnConditionCode(Integer.valueOf(ioeropnn));
        }
        if ((ioeropnw = stmt.getParameterTokenByName("IOEROPN", 0, 1, false)) != null) {
            if (ioeropnw.equals("WTOR")) {
                psb.setIoeropnWTOR(DBDConstants.Y);
            } else {
                psb.setIoeropnWTOR(DBDConstants.N);
            }
        }
        if ((olic = stmt.getParameterTokenByName("OLIC", 0, 0, false)) != null && olic.equals("YES")) {
            psb.setOnlineDBImageCopy(DBDConstants.Y);
        } else if (olic != null && olic.equals("NO")) {
            psb.setOnlineDBImageCopy(DBDConstants.N);
        }
        String gsrolbok = stmt.getParameterTokenByName("GSROLBOK", 0, 0, false);
        if (gsrolbok != null && gsrolbok.equals("YES")) {
            psb.setGsamRollb(DBDConstants.Y);
        } else if (gsrolbok != null && gsrolbok.equals("NO")) {
            psb.setGsamRollb(DBDConstants.N);
        }
        String lockmax = stmt.getParameterTokenByName("LOCKMAX", 0, 0, false);
        if (lockmax != null) {
            psb.setMaximumLock(Integer.valueOf(lockmax));
        }
        if ((remarks = stmt.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            psb.setPsbRemarks(remarks);
        }
        this.handlePcbs(sSet, psb);
        return psb;
    }

    private DbdModel handleDbd(StatementSet sSet) throws ImporterException, ModelException {
        Statement tempS = null;
        tempS = sSet.getStatementByType("DBD");
        DbdModel newDbd = new DbdModel();
        String name = tempS.getParameterTokenByName("NAME", 0, 0, true);
        newDbd.setDbdName(name);
        String accessStr = tempS.getParameterTokenByName("ACCESS", 0, 0, true);
        newDbd.setAccessType(accessStr);
        if (newDbd.getAccessType() == DBDConstants.INDEX) {
            this.handleSecondaryIxDBDNames(tempS, newDbd);
        }
        this.handleAccess(tempS, newDbd);
        this.handleRmname(tempS, newDbd);
        this.handlePasswd(tempS, newDbd);
        this.handleExit(tempS, newDbd, null);
        this.handleVersion(tempS, newDbd);
        this.handleDbver(tempS, newDbd);
        this.handlePsname(tempS, newDbd);
        this.handleDatxexit(tempS, newDbd);
        this.handleEncoding(tempS, newDbd);
        this.handleRemarks(tempS, newDbd);
        if (newDbd.getAccessType() == DBDConstants.INDEX) {
            this.handleFpindex(tempS, newDbd);
        }
        if (newDbd.getAccessType() == DBDConstants.DEDB) {
            this.handleArea(sSet, newDbd);
        }
        this.handleDataset(sSet, newDbd);
        this.handleSegments(sSet, newDbd);
        return newDbd;
    }

    private void handleRemarks(Statement tempS, DbdModel dbd) throws ImporterException {
        String remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false);
        if (remarks != null) {
            dbd.setRemarks(remarks);
        }
    }

    private void handleEncoding(Statement tempS, DbdModel dbd) throws ImporterException {
        String encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false);
        if (encoding != null) {
            dbd.setEncoding(encoding);
        }
    }

    private void handleFpindex(Statement tempS, DbdModel dbd) throws ImporterException {
        String fpIndex = tempS.getParameterTokenByName("FPINDEX", 0, 0, false);
        if (fpIndex != null) {
            dbd.setFPindex(fpIndex);
        }
    }

    private void handleSecondaryIxDBDNames(Statement tempS, DbdModel newDbd) throws ImporterException, ModelException {
        String name = null;
        ArrayList<String> names = new ArrayList<String>();
        int i = 1;
        do {
            if ((name = tempS.getParameterTokenByName("NAME", 0, i, false)) != null) {
                names.add(name);
            }
            ++i;
        } while (name != null);
        if (names.size() > 0) {
            newDbd.setSecondaryIxDBDNames(names);
        }
    }

    private void handleDataset(StatementSet sSet, DbdModel newDbd) throws ImporterException, ModelException {
        Statement tempS = null;
        tempS = sSet.getStatementByType("DATASET");
        if (tempS == null) {
            DBDConstants accessType = newDbd.getAccessType();
            if (accessType != DBDConstants.PHDAM && accessType != DBDConstants.PHIDAM && accessType != DBDConstants.PSINDEX && accessType != DBDConstants.DEDB && accessType != DBDConstants.LOGICAL) {
                Object[] inserts = new Object[]{"DATASET", newDbd.getDBDName()};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE007", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
        } else if (newDbd.getAccessType() != DBDConstants.PHDAM && newDbd.getAccessType() != DBDConstants.PHIDAM && newDbd.getAccessType() != DBDConstants.PSINDEX && newDbd.getAccessType() != DBDConstants.DEDB) {
            if (newDbd.getAccessType() == DBDConstants.HDAM || newDbd.getAccessType() == DBDConstants.HIDAM) {
                newDbd.clearExistingLabels();
                int i = 0;
                while (i < sSet.size) {
                    tempS = (Statement)sSet.statements.get(i);
                    if (tempS.type.equals("DATASET")) {
                        String label = tempS.label;
                        boolean labelExists = false;
                        String generatedLabel = null;
                        if (label != null) {
                            ArrayList<String> currentLabelsList = newDbd.getExistingLablels();
                            int j = 0;
                            while (j < currentLabelsList.size()) {
                                if (label.equals(currentLabelsList.get(j))) {
                                    labelExists = true;
                                }
                                ++j;
                            }
                            if (!labelExists) {
                                newDbd.addToExistingLabels(label);
                            }
                        } else {
                            generatedLabel = newDbd.generateDatasetLabel();
                        }
                        if (!labelExists) {
                            String dd1name = tempS.getParameterTokenByName("DD1", 0, 0, false);
                            String size0 = tempS.getParameterTokenByName("BLOCK", 0, 0, false);
                            String cyls = tempS.getParameterTokenByName("SCAN", 0, 0, false);
                            String fbff = tempS.getParameterTokenByName("FRSPC", 0, 0, false);
                            String fspf = tempS.getParameterTokenByName("FRSPC", 0, 1, false);
                            String searcha = tempS.getParameterTokenByName("SEARCHA", 0, 0, false);
                            String device = tempS.getParameterTokenByName("DEVICE", 0, 0, false);
                            String remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false);
                            String size1 = tempS.getParameterTokenByName("SIZE", 0, 0, false);
                            if (size1 == null) {
                                size1 = tempS.getParameterTokenByName("SIZE", 0, 1, false);
                            }
                            if (dd1name == null) {
                                Object[] inserts = new Object[]{"DD1", "DATASET", newDbd.getDBDName()};
                                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
                                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                                throw e;
                            }
                            HidamDataSetModel dataSet = new HidamDataSetModel(dd1name, size0, size1, cyls, fbff, fspf, searcha, label, device, remarks);
                            if (label == null && generatedLabel != null) {
                                dataSet.setGeneratedLabel(generatedLabel);
                                newDbd.addToExistingLabels(generatedLabel);
                            }
                            newDbd.setHidamDataset(dataSet);
                        }
                    }
                    ++i;
                }
            } else if (newDbd.getAccessType() == DBDConstants.MSDB) {
                this.handleRel(tempS, newDbd);
                this.handleDatasetRemarks(tempS, newDbd);
            } else {
                this.handleDd(tempS, newDbd);
                this.handleOvflw(tempS, newDbd);
                this.handleBlock(tempS, newDbd);
                this.handleSize(tempS, newDbd);
                this.handleRecord(tempS, newDbd);
                this.handleDevice(tempS, newDbd);
                if (newDbd.getAccessType() == DBDConstants.GSAM) {
                    this.handleRecfm(tempS, newDbd);
                }
                this.handleDatasetRemarks(tempS, newDbd);
            }
        }
    }

    private void handleDevice(Statement tempS, DbdModel dbd) throws ImporterException {
        String device = tempS.getParameterTokenByName("DEVICE", 0, 0, false);
        if (device != null) {
            dbd.setDevice(device);
        }
    }

    private void handleDatasetRemarks(Statement tempS, DbdModel dbd) throws ImporterException {
        String remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false);
        if (remarks != null) {
            dbd.setDatasetRemarks(remarks);
        }
    }

    private void handleRel(Statement tempS, DbdModel dbd) throws ImporterException {
        String rel = tempS.getParameterTokenByName("REL", 0, 0, false);
        if (rel != null) {
            if (rel.equalsIgnoreCase("NO")) {
                dbd.setRel(rel, null);
            } else if (rel.equalsIgnoreCase("TERM")) {
                String fldnm = tempS.getParameterTokenByName("REL", 0, 1, false);
                dbd.setRel(rel, fldnm);
            } else if (rel.equalsIgnoreCase("FIXED")) {
                String fldnm = tempS.getParameterTokenByName("REL", 0, 1, false);
                dbd.setRel(rel, fldnm);
            } else if (rel.equalsIgnoreCase("DYNAMIC")) {
                String fldnm = tempS.getParameterTokenByName("REL", 0, 1, false);
                dbd.setRel(rel, fldnm);
            }
        } else {
            Object[] inserts = new Object[3];
            inserts[0] = "REL";
            inserts[1] = "DATASET";
            inserts[3] = dbd.getDBDName();
            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
    }

    private void handleOvflw(Statement tempS, DbdModel dbd) throws ImporterException {
        String ovflw;
        if ((dbd.getAccessType() == DBDConstants.HISAM || dbd.getAccessType() == DBDConstants.SHISAM || dbd.getAccessType() == DBDConstants.INDEX) && (ovflw = tempS.getParameterTokenByName("OVFLW", 0, 0, false)) != null) {
            dbd.setOvflw(ovflw);
        }
    }

    private void handleRecfm(Statement tempS, DbdModel dbd) throws ImporterException {
        String recfm = tempS.getParameterTokenByName("RECFM", 0, 0, false);
        if (recfm == null) {
            Object[] inserts = new Object[3];
            inserts[0] = "RECFM";
            inserts[1] = "DATASET";
            inserts[3] = dbd.getDBDName();
            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        dbd.setRecfm(DBDConstants.valueOf(recfm));
    }

    private void handleRecord(Statement tempS, DbdModel dbd) throws ImporterException {
        if (dbd.getAccessType() == DBDConstants.HSAM || dbd.getAccessType() == DBDConstants.SHSAM || dbd.getAccessType() == DBDConstants.GSAM || dbd.getAccessType() == DBDConstants.HISAM || dbd.getAccessType() == DBDConstants.SHISAM || dbd.getAccessType() == DBDConstants.INDEX) {
            String reclen1 = tempS.getParameterTokenByName("RECORD", 0, 0, false);
            String reclen2 = tempS.getParameterTokenByName("RECORD", 0, 1, false);
            if (reclen1 != null) {
                dbd.setRECORDReclen1(Integer.valueOf(reclen1));
            }
            if (reclen2 != null) {
                dbd.setRECORDReclen2(Integer.valueOf(reclen2));
            }
        }
    }

    private void handleSize(Statement tempS, DbdModel dbd) throws ImporterException {
        if (dbd.getAccessType() == DBDConstants.GSAM || dbd.getAccessType() == DBDConstants.HISAM || dbd.getAccessType() == DBDConstants.SHISAM || dbd.getAccessType() == DBDConstants.INDEX) {
            String size1 = tempS.getParameterTokenByName("SIZE", 0, 0, false);
            String size2 = tempS.getParameterTokenByName("SIZE", 0, 1, false);
            if (size1 != null) {
                dbd.setSize1(Integer.valueOf(size1));
            }
            if (size2 != null) {
                dbd.setSize2(Integer.valueOf(size2));
            }
        }
    }

    private void handleBlock(Statement tempS, DbdModel dbd) throws ImporterException {
        if (dbd.getAccessType() == DBDConstants.GSAM || dbd.getAccessType() == DBDConstants.HISAM || dbd.getAccessType() == DBDConstants.SHISAM || dbd.getAccessType() == DBDConstants.INDEX) {
            String blkfact1 = tempS.getParameterTokenByName("BLOCK", 0, 0, false);
            String blkfact2 = tempS.getParameterTokenByName("BLOCK", 0, 1, false);
            if (blkfact1 != null) {
                dbd.setBLOCKBlkfact1(Integer.valueOf(blkfact1));
            } else {
                dbd.setBLOCKBlkfact1(-1);
            }
            if (dbd.getAccessType() != DBDConstants.GSAM) {
                if (blkfact2 != null) {
                    dbd.setBLOCKBlkfact2(Integer.valueOf(blkfact2));
                } else {
                    dbd.setBLOCKBlkfact2(-1);
                }
            }
        } else if (dbd.getAccessType() == DBDConstants.HSAM || dbd.getAccessType() == DBDConstants.SHSAM) {
            dbd.setBLOCKBlkfact1(1);
            dbd.setBLOCKBlkfact2(1);
        }
    }

    private void handleDd(Statement tempS, DbdModel dbd) throws ImporterException {
        if (dbd.getAccessType() == DBDConstants.HSAM || dbd.getAccessType() == DBDConstants.SHSAM || dbd.getAccessType() == DBDConstants.GSAM || dbd.getAccessType() == DBDConstants.HISAM || dbd.getAccessType() == DBDConstants.SHISAM || dbd.getAccessType() == DBDConstants.INDEX) {
            String ddname1 = tempS.getParameterTokenByName("DD1", 0, 0, false);
            String ddname2 = tempS.getParameterTokenByName("DD2", 0, 0, false);
            dbd.setDdname1(ddname1);
            if (ddname2 != null) {
                dbd.setDdname2(ddname2);
            }
        }
    }

    private void handleSegments(StatementSet sSet, DbdModel newDbd) throws ImporterException, ModelException {
        SegmentModel segment;
        String datasetLabel = null;
        DBDConstants dbdAccessType = newDbd.getAccessType();
        int genedLabelCount = 0;
        Boolean segmFound = false;
        int i = 0;
        while (i < sSet.size) {
            Statement tempS = (Statement)sSet.statements.get(i);
            if (tempS.type.equals("DATASET") && (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM)) {
                datasetLabel = tempS.label;
                if (datasetLabel == null) {
                    datasetLabel = newDbd.getGenedDatasetLabels().get(genedLabelCount);
                    ++genedLabelCount;
                }
            } else {
                tempS = (Statement)sSet.statements.get(i);
                if (tempS.type.equals("SEGM")) {
                    segmFound = true;
                    segment = new SegmentModel(newDbd);
                    this.handleSegment(sSet, i, tempS, segment, newDbd, datasetLabel);
                    segment.getName();
                    segment.getFieldList(true, true);
                    List<MappingModel> mapModels = segment.getMapList();
                    int j = 0;
                    while (j < mapModels.size()) {
                        MappingModel currMapModel = mapModels.get(j);
                        List<MappingCaseModel> caseModels = currMapModel.getMapCaseList();
                        int k = 0;
                        while (k < caseModels.size()) {
                            MappingCaseModel currCaseModel = caseModels.get(k);
                            currCaseModel.getFieldList(true);
                            ++k;
                        }
                        ++j;
                    }
                    String parentStr = tempS.getParameterTokenByName("PARENT", 0, 0, false);
                    if (dbdAccessType == DBDConstants.INDEX) {
                        newDbd.setIndexMultipleSegments(segment);
                        if (newDbd.getRootSegment() == null) {
                            newDbd.setRootSegment(segment);
                        }
                    } else if (newDbd.getRootSegment() == null) {
                        newDbd.setRootSegment(segment);
                    } else {
                        ImporterException e;
                        Object[] inserts;
                        if (parentStr == null || parentStr.length() == 0) {
                            inserts = new Object[]{"PARENT", "SEGM NAME=" + segment.getImsName(), newDbd.getDBDName()};
                            e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
                            logger.throwing(this.getClass().getName(), "", (Throwable)e);
                            throw e;
                        }
                        if (!this.putSegmentInHierarchy(segment, newDbd.getRootSegment(), parentStr)) {
                            inserts = new Object[]{segment.getImsName()};
                            e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE014", inserts));
                            logger.throwing(this.getClass().getName(), "", (Throwable)e);
                            throw e;
                        }
                    }
                }
            }
            ++i;
        }
        if (!segmFound.booleanValue() && dbdAccessType == DBDConstants.GSAM) {
            segment = new SegmentModel(newDbd);
            segment.setSegmentType(DBDConstants.GSAM);
            segment.setName("GSAM SEGMENT");
            newDbd.setRootSegment(segment);
            RecfmType recfm = newDbd.getDbd().getAccess().getGsam().getDataSet().getRecfm();
            segment.setMaxBytes(32760);
            if (recfm.equals((Object)RecfmType.V) || recfm.equals((Object)RecfmType.VB)) {
                segment.setMaxBytes(32756);
            }
        }
    }

    private boolean putSegmentInHierarchy(SegmentModel segment, SegmentModel potentialParent, String parentStr) {
        if (potentialParent.getImsName().equalsIgnoreCase(parentStr)) {
            potentialParent.addNewSegment(segment);
            return true;
        }
        for (SegmentModel child : potentialParent.getChildSegments()) {
            if (!this.putSegmentInHierarchy(segment, child, parentStr)) continue;
            return true;
        }
        return false;
    }

    private void handleSegment(StatementSet sSet, int ssIndex, Statement tempS, SegmentModel segment, DbdModel newDbd, String datasetLabel) throws ImporterException, ModelException {
        DBDConstants dbdAccessType = newDbd.getAccessType();
        String segName = null;
        if (dbdAccessType == DBDConstants.LOGICAL) {
            segment.setSegmentType(DBDConstants.LOGICAL);
            segName = this.handleLogicalSegment(sSet, ssIndex, tempS, segment, newDbd);
        } else if (dbdAccessType == DBDConstants.HDAM) {
            segment.setSegmentType(DBDConstants.HDAM);
            segName = this.handleHdamHisamSegment(sSet, ssIndex, tempS, segment, newDbd, datasetLabel);
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            segment.setSegmentType(DBDConstants.HIDAM);
            segName = this.handleHdamHisamSegment(sSet, ssIndex, tempS, segment, newDbd, datasetLabel);
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            segment.setSegmentType(DBDConstants.PHDAM);
            segName = this.handleHdamHisamSegment(sSet, ssIndex, tempS, segment, newDbd, datasetLabel);
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            segment.setSegmentType(DBDConstants.PHIDAM);
            segName = this.handleHdamHisamSegment(sSet, ssIndex, tempS, segment, newDbd, datasetLabel);
        } else if (dbdAccessType == DBDConstants.HISAM) {
            segment.setSegmentType(DBDConstants.HISAM);
            segName = this.handleHdamHisamSegment(sSet, ssIndex, tempS, segment, newDbd, datasetLabel);
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            segment.setSegmentType(DBDConstants.SHISAM);
            segName = this.handleHdamHisamSegment(sSet, ssIndex, tempS, segment, newDbd, datasetLabel);
        } else if (dbdAccessType == DBDConstants.HSAM) {
            segment.setSegmentType(DBDConstants.HSAM);
            segName = this.handleHsamSegment(sSet, ssIndex, tempS, segment, newDbd);
        } else if (dbdAccessType == DBDConstants.SHSAM) {
            segment.setSegmentType(DBDConstants.SHSAM);
            segName = this.handleHsamSegment(sSet, ssIndex, tempS, segment, newDbd);
        } else if (dbdAccessType == DBDConstants.DEDB) {
            segment.setSegmentType(DBDConstants.DEDB);
            segName = this.handleDedbSegment(sSet, ssIndex, tempS, segment, newDbd);
        } else if (dbdAccessType == DBDConstants.MSDB) {
            segment.setSegmentType(DBDConstants.MSDB);
            segName = this.handleMsdbSegment(sSet, ssIndex, tempS, segment, newDbd);
        } else if (dbdAccessType == DBDConstants.INDEX) {
            segment.setSegmentType(DBDConstants.INDEX);
            segName = this.handleIndexSegment(sSet, ssIndex, tempS, segment, newDbd);
        } else if (dbdAccessType == DBDConstants.PSINDEX) {
            segment.setSegmentType(DBDConstants.PSINDEX);
            segName = this.handlePsindexSegment(sSet, ssIndex, tempS, segment, newDbd);
        } else if (dbdAccessType == DBDConstants.GSAM) {
            segment.setSegmentType(DBDConstants.GSAM);
            segName = this.handleGsamSegment(sSet, ssIndex, tempS, segment, newDbd);
        }
        ++ssIndex;
        logger.finest("sSet.statements.size(): " + sSet.statements.size());
        LogicalChildModel lChildType = null;
        FieldModel fieldModel = null;
        while (ssIndex < sSet.statements.size()) {
            logger.finest("ssIndex: " + ssIndex);
            tempS = (Statement)sSet.statements.elementAt(ssIndex);
            if (tempS != null) {
                String sType = tempS.type;
                if (sType.equalsIgnoreCase("SEGM")) break;
                if (sType.equalsIgnoreCase("FIELD")) {
                    String fldName = tempS.getParameterTokenByName("NAME", 0, 0, false);
                    if (fldName != null && (fldName.startsWith("/SX") || fldName.startsWith("/CK"))) {
                        fieldModel = new SysRelFieldModel();
                        fieldModel.setStartPos(0);
                        fieldModel.setBytes(0);
                    } else {
                        fieldModel = new FieldModelImpl();
                    }
                    this.handleField(tempS, fieldModel, newDbd, dbdAccessType);
                    String caseName = this.getCaseName(tempS);
                    String parent = this.getParentFieldName(tempS);
                    if (parent != null && !parent.isEmpty()) {
                        FieldModelImpl dummyParentField = new FieldModelImpl();
                        dummyParentField.setName(parent);
                        fieldModel.setParentField(dummyParentField);
                    }
                    if (caseName != null) {
                        MappingModel mapModel = segment.getMapping(this.currMapName);
                        MappingCaseModel caseModel = mapModel.getMappingCaseModel(caseName);
                        caseModel.addField(fieldModel);
                    } else {
                        segment.addField(fieldModel);
                    }
                } else if (sType.equalsIgnoreCase("DFSMARSH")) {
                    if (fieldModel != null) {
                        this.handleFieldMarshaller(tempS, fieldModel);
                    }
                } else if (sType.equalsIgnoreCase("DFSMAP")) {
                    this.handleMap(newDbd, tempS, segment);
                } else if (sType.equalsIgnoreCase("DFSCASE")) {
                    this.handleCase(newDbd, tempS, segment);
                } else if (sType.equalsIgnoreCase("LCHILD")) {
                    lChildType = new LogicalChildModel();
                    segment.addLogicalChild(lChildType);
                    this.handleLChild(tempS, lChildType, newDbd);
                } else if (sType.equalsIgnoreCase("XDFLD")) {
                    if (lChildType == null) {
                        Object[] inserts = new Object[]{segName};
                        ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE006", inserts));
                        logger.throwing(this.getClass().getName(), "", (Throwable)e);
                        throw e;
                    }
                    lChildType.createXdfld();
                    this.handleXfldType(tempS, lChildType);
                }
            }
            ++ssIndex;
        }
    }

    private String getCaseName(Statement tempS) throws ImporterException {
        String caseName = tempS.getParameterTokenByName("CASENAME", 0, 0, false);
        return caseName;
    }

    private String getParentFieldName(Statement tempS) throws ImporterException {
        String parent = tempS.getParameterTokenByName("PARENT", 0, 0, false);
        return parent;
    }

    private void handleMap(DbdModel newDbd, Statement tempS, SegmentModel segment) throws ImporterException {
        String name = tempS.getParameterTokenByName("NAME", 0, 0, true);
        String remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false);
        String fieldName = tempS.getParameterTokenByName("DEPENDINGON", 0, 0, false);
        String ctlSegnm = tempS.getParameterTokenByName("CTLSEGNM", 0, 0, false);
        this.currMapName = name;
        if (segment != null) {
            MappingModel newMapping = new MappingModel();
            newMapping.setName(NameValidator.validateName(newDbd.getDBDName(), name));
            newMapping.setRemarks(remarks);
            newMapping.setDependingOnField(NameValidator.validateName(newDbd.getDBDName(), fieldName));
            newMapping.setControlSegmentName(ctlSegnm);
            segment.addNewMappingModel(newMapping);
        }
    }

    private void handleCase(DbdModel newDbd, Statement tempS, SegmentModel segment) throws ImporterException {
        String dbdName = newDbd.getDBDName();
        String mapName = tempS.getParameterTokenByName("MAPNAME", 0, 0, false);
        String caseName = tempS.getParameterTokenByName("NAME", 0, 0, true);
        String caseId = tempS.getParameterTokenByName("CASEID", 0, 0, false);
        String caseIdType = tempS.getParameterTokenByName("CASEIDTYPE", 0, 0, false);
        String remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false);
        if (caseName != null) {
            NameValidator.validateName(dbdName, mapName);
            NameValidator.validateName(dbdName, caseName);
            if (!caseIdType.equals("X") && !caseIdType.equals("C")) {
                Object[] inserts = new Object[]{dbdName, segment.getName(), caseName};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("IMPORT_WIZ_010", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
            MappingCaseModel newCase = new MappingCaseModel();
            newCase.setName(caseName);
            newCase.setDependingOnFieldValue(caseId);
            if (caseIdType.equalsIgnoreCase("X")) {
                newCase.setDependingOnFieldValueType(DBDConstants.X);
            } else {
                newCase.setDependingOnFieldValueType(DBDConstants.C);
            }
            newCase.setRemarks(remarks);
            MappingModel mappingModel = segment.getMapping(mapName);
            if (mappingModel != null) {
                mappingModel.addNewCaseModel(newCase);
            } else {
                Object[] inserts = new Object[]{mapName, segment.getName()};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("IMPORT_WIZ_014", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
        }
    }

    private void handleFieldMarshaller(Statement tempS, FieldModel fieldModel) throws ImporterException {
        String isPureDbcs;
        String url;
        String pattern;
        String isSigned;
        String properties;
        String encoding;
        String userTypeConverter;
        String typeConverter;
        String remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false);
        if (remarks != null) {
            fieldModel.setMarshallerRemarks(remarks);
        }
        if ((typeConverter = tempS.getParameterTokenByName("INTERNALTYPECONVERTER", 0, 0, false)) != null) {
            try {
                fieldModel.setPhysicalDataType(DBDConstants.fromValue(typeConverter));
            }
            catch (Throwable throwable) {
                Object[] inserts = new Object[]{"INTERNALTYPECONVERTER", "DFSMARSH", fieldModel.getImsNameOrAlias()};
                ImporterException ie = new ImporterException(WorkbenchModelBundle.getError().getString("IMPORT_WIZ_008", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)ie);
                throw ie;
            }
        }
        if ((userTypeConverter = tempS.getParameterTokenByName("USERTYPECONVERTER", 0, 0, false)) != null) {
            fieldModel.setUserTypeConverer(userTypeConverter);
        }
        if ((encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false)) != null) {
            fieldModel.setEncoding(encoding);
        }
        if ((properties = tempS.getParameterByNameAsString("PROPERTIES", false)) != null) {
            this.parseProperties(properties, fieldModel);
        }
        if ((isSigned = tempS.getParameterTokenByName("ISSIGNED", 0, 0, false)) != null) {
            fieldModel.setIsSigned(isSigned);
        }
        if ((pattern = tempS.getParameterTokenByName("PATTERN", 0, 0, false)) != null) {
            fieldModel.setPattern(pattern);
        }
        if ((url = tempS.getParameterTokenByName("URL", 0, 0, false)) != null) {
            fieldModel.setUrl(url);
        }
        if ((isPureDbcs = tempS.getParameterTokenByName("PUREDBCS", 0, 0, false)) != null) {
            fieldModel.setIsDbcs(isPureDbcs);
        }
    }

    private void parseProperties(String properties, FieldModel fieldModel) {
        StringTokenizer paren = new StringTokenizer(properties, "()", false);
        String parenToken = paren.nextToken();
        StringTokenizer stringTokenizer = new StringTokenizer(parenToken, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            String name = token.substring(0, token.lastIndexOf("="));
            String value = token.substring(token.lastIndexOf("=") + 1, token.length());
            fieldModel.addNewProperty(name, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String handleHdamHisamSegment(StatementSet sSet, int ssIndex, Statement tempS, SegmentModel segment, DbdModel newDbd, String datasetLabel) throws ImporterException, ModelException {
        String dsgroup;
        String remarks;
        String encoding;
        String freq;
        String minbytes;
        String maxbytes;
        String segName;
        DBDConstants dbdAccessType;
        block34: {
            String lpckStr;
            block35: {
                String physicalChildPointer;
                dbdAccessType = newDbd.getAccessType();
                if (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM) {
                    segment.setDatasetLabel(datasetLabel);
                }
                segName = tempS.getParameterTokenByName("NAME", 0, 0, true);
                segment.setImsName(NameValidator.validateName(newDbd.getDBDName(), segName));
                String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
                if (externalName != null) {
                    segment.setName(NameValidator.validateName(newDbd.getDBDName(), externalName));
                } else {
                    segment.setName(segName);
                }
                tempS.getParameterTokenByName("PARENT", 0, 0, false);
                String logicalParentStr = tempS.getParameterTokenByName("PARENT", 1, 0, false);
                lpckStr = tempS.getParameterTokenByName("PARENT", 1, 1, false);
                String logicalParentDbdStr = tempS.getParameterTokenByName("PARENT", 1, 2, false);
                if (logicalParentDbdStr == null) {
                    logicalParentDbdStr = newDbd.getDBDName();
                }
                if ((dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) && (physicalChildPointer = tempS.getParameterTokenByName("PARENT", 0, 1, false)) != null) {
                    segment.setPhysicalChildPointer(physicalChildPointer);
                }
                if (logicalParentStr == null || logicalParentStr.equals("")) break block34;
                segment.createLogicalParent();
                segment.setLogicalParentName(logicalParentStr);
                if (logicalParentDbdStr == null) break block35;
                segment.setLogicalParentDbdName(logicalParentDbdStr);
                if (lpckStr != null) {
                    if ("PHYSICAL".equalsIgnoreCase(lpckStr) || "P".equalsIgnoreCase(lpckStr)) {
                        segment.setLogicalParentLpck(DBDConstants.PHYSICAL);
                        break block34;
                    } else {
                        if (!"VIRTUAL".equalsIgnoreCase(lpckStr) && !"V".equalsIgnoreCase(lpckStr)) {
                            Object[] inserts = new Object[]{newDbd.getDBDName(), segName, lpckStr};
                            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("DHB1750", inserts));
                            logger.throwing(this.getClass().getName(), "", (Throwable)e);
                            throw e;
                        }
                        segment.setLogicalParentLpck(DBDConstants.VIRTUAL);
                    }
                    break block34;
                } else {
                    segment.setLogicalParentLpck(DBDConstants.VIRTUAL);
                }
                break block34;
            }
            if (lpckStr == null) {
                segment.setLogicalParentLpck(DBDConstants.VIRTUAL);
            } else if ("PHYSICAL".equalsIgnoreCase(lpckStr) || "P".equalsIgnoreCase(lpckStr)) {
                segment.setLogicalParentLpck(DBDConstants.PHYSICAL);
            } else if ("VIRTUAL".equalsIgnoreCase(lpckStr) || "V".equalsIgnoreCase(lpckStr)) {
                segment.setLogicalParentLpck(DBDConstants.VIRTUAL);
            } else {
                segment.setLogicalParentLpck(DBDConstants.VIRTUAL);
                segment.setLogicalParentDbdName(lpckStr);
            }
        }
        if ((maxbytes = tempS.getParameterTokenByName("BYTES", 0, 0, false)) != null) {
            segment.setMaxBytes(Integer.valueOf(maxbytes));
        }
        if ((minbytes = tempS.getParameterTokenByName("BYTES", 0, 1, false)) != null) {
            segment.setMinBytes(Integer.valueOf(minbytes));
        }
        if (maxbytes == null) {
            String sourceSegment = tempS.getParameterTokenByName("SOURCE", 0, 0, false);
            String sourceData = tempS.getParameterTokenByName("SOURCE", 0, 1, false);
            String sourceDbd = tempS.getParameterTokenByName("SOURCE", 0, 2, false);
            if (sourceSegment != null && sourceSegment.length() > 0) {
                segment.createSegmentSource();
                if (sourceDbd == null) {
                    segment.setSegmentSourceDbname(sourceData);
                } else {
                    segment.setSegmentSourceDbname(sourceDbd);
                }
                segment.setSegmentSourceSegName(sourceSegment);
                if (sourceData != null && (sourceData.equalsIgnoreCase("DATA") || sourceData.equalsIgnoreCase("D"))) {
                    segment.setSegmentSourceData(DBDConstants.Y);
                } else {
                    segment.setSegmentSourceData(DBDConstants.N);
                }
            }
        }
        if ((freq = tempS.getParameterTokenByName("FREQ", 0, 0, false)) != null) {
            segment.setFreq(new BigDecimal(freq));
        }
        String ptrTest1 = tempS.getParameterTokenByName("POINTER", 0, 0, false);
        String ptrTest2 = tempS.getParameterTokenByName("PTR", 0, 0, false);
        String[] ptrKeywords = new String[5];
        if (ptrTest1 != null) {
            ptrKeywords[0] = tempS.getParameterTokenByName("POINTER", 0, 0, false);
            ptrKeywords[1] = tempS.getParameterTokenByName("POINTER", 0, 1, false);
            ptrKeywords[2] = tempS.getParameterTokenByName("POINTER", 0, 2, false);
            ptrKeywords[3] = tempS.getParameterTokenByName("POINTER", 0, 3, false);
            ptrKeywords[4] = tempS.getParameterTokenByName("POINTER", 0, 4, false);
        } else if (ptrTest2 != null) {
            ptrKeywords[0] = tempS.getParameterTokenByName("PTR", 0, 0, false);
            ptrKeywords[1] = tempS.getParameterTokenByName("PTR", 0, 1, false);
            ptrKeywords[2] = tempS.getParameterTokenByName("PTR", 0, 2, false);
            ptrKeywords[3] = tempS.getParameterTokenByName("PTR", 0, 3, false);
            ptrKeywords[4] = tempS.getParameterTokenByName("PTR", 0, 4, false);
        } else {
            ptrKeywords[0] = null;
            ptrKeywords[1] = null;
            ptrKeywords[2] = null;
            ptrKeywords[3] = null;
            ptrKeywords[4] = null;
        }
        segment.setPointer(ptrKeywords);
        String rules1 = tempS.getParameterTokenByName("RULES", 0, 0, false);
        String rules2 = tempS.getParameterTokenByName("RULES", 0, 1, false);
        if (rules1 != null || rules2 != null) {
            segment.setRules(rules1, rules2);
        }
        String[] comprtnKeywords = new String[5];
        comprtnKeywords[0] = tempS.getParameterTokenByName("COMPRTN", 0, 0, false);
        if (comprtnKeywords[0] != null) {
            comprtnKeywords[1] = tempS.getParameterTokenByName("COMPRTN", 0, 1, false);
            comprtnKeywords[2] = tempS.getParameterTokenByName("COMPRTN", 0, 2, false);
            comprtnKeywords[3] = tempS.getParameterTokenByName("COMPRTN", 0, 3, false);
            comprtnKeywords[4] = tempS.getParameterTokenByName("COMPRTN", 0, 4, false);
            segment.setComprtn(comprtnKeywords);
        }
        this.handleExit(tempS, newDbd, segment);
        if ((dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM) && (encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false)) != null) {
            segment.setEncoding(encoding);
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            segment.setRemarks(remarks);
        }
        if ((dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) && (dsgroup = tempS.getParameterTokenByName("DSGROUP", 0, 0, false)) != null) {
            segment.setDsgroup(dsgroup);
        }
        return segName;
    }

    private String handleDedbSegment(StatementSet sSet, int ssIndex, Statement tempS, SegmentModel segment, DbdModel newDbd) throws ImporterException, ModelException {
        String remarks;
        String encoding;
        String ssptr;
        String type;
        String minbytes;
        String maxbytes;
        String segName = tempS.getParameterTokenByName("NAME", 0, 0, true);
        segment.setImsName(NameValidator.validateName(newDbd.getDBDName(), segName));
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            segment.setName(NameValidator.validateName(newDbd.getDBDName(), externalName));
        } else {
            segment.setName(segName);
        }
        tempS.getParameterTokenByName("PARENT", 0, 0, false);
        String physicalChildPointer = tempS.getParameterTokenByName("PARENT", 0, 1, false);
        if (physicalChildPointer != null) {
            segment.setPhysicalChildPointer(physicalChildPointer);
        }
        if ((maxbytes = tempS.getParameterTokenByName("BYTES", 0, 0, false)) != null) {
            segment.setMaxBytes(Integer.valueOf(maxbytes));
        }
        if ((minbytes = tempS.getParameterTokenByName("BYTES", 0, 1, false)) != null) {
            segment.setMinBytes(Integer.valueOf(minbytes));
        }
        if ((type = tempS.getParameterTokenByName("TYPE", 0, 0, false)) != null) {
            if (type.equals("DIR")) {
                segment.setDedbDependentSegmentType(DBDConstants.DIR);
            } else if (type.equals("SEQ")) {
                segment.setDedbDependentSegmentType(DBDConstants.SEQ);
            } else {
                Object[] inserts = new Object[]{"SEGM", "TYPE", type};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
        }
        String rules1 = tempS.getParameterTokenByName("RULES", 0, 0, false);
        String rules2 = tempS.getParameterTokenByName("RULES", 0, 1, false);
        if (rules1 != null || rules2 != null) {
            segment.setRules(rules1, rules2);
        }
        if ((ssptr = tempS.getParameterTokenByName("SSPTR", 0, 0, false)) != null) {
            segment.setSsptr(Integer.valueOf(ssptr));
        } else {
            segment.setSsptr(-1);
        }
        String[] comprtnKeywords = new String[3];
        comprtnKeywords[0] = tempS.getParameterTokenByName("COMPRTN", 0, 0, false);
        if (comprtnKeywords[0] != null) {
            comprtnKeywords[1] = tempS.getParameterTokenByName("COMPRTN", 0, 1, false);
            comprtnKeywords[2] = tempS.getParameterTokenByName("COMPRTN", 0, 2, false);
            segment.setDedbComprtn(comprtnKeywords);
        }
        if ((encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false)) != null) {
            segment.setEncoding(encoding);
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            segment.setRemarks(remarks);
        }
        this.handleExit(tempS, newDbd, segment);
        return segName;
    }

    private String handleHsamSegment(StatementSet sSet, int ssIndex, Statement tempS, SegmentModel segment, DbdModel newDbd) throws ImporterException, ModelException {
        String remarks;
        String freq;
        String encoding;
        String segName = tempS.getParameterTokenByName("NAME", 0, 0, true);
        segment.setImsName(NameValidator.validateName(newDbd.getDBDName(), segName));
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            segment.setName(NameValidator.validateName(newDbd.getDBDName(), externalName));
        } else {
            segment.setName(segName);
        }
        tempS.getParameterTokenByName("PARENT", 0, 0, false);
        String maxbytes = tempS.getParameterTokenByName("BYTES", 0, 0, false);
        if (maxbytes != null) {
            segment.setMaxBytes(Integer.valueOf(maxbytes));
        }
        if ((encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false)) != null) {
            segment.setEncoding(encoding);
        }
        if ((freq = tempS.getParameterTokenByName("FREQ", 0, 0, false)) != null) {
            segment.setFreq(new BigDecimal(freq));
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            segment.setRemarks(remarks);
        }
        return segName;
    }

    private String handleMsdbSegment(StatementSet sSet, int ssIndex, Statement tempS, SegmentModel segment, DbdModel newDbd) throws ImporterException, ModelException {
        String remarks;
        String encoding;
        String segName = tempS.getParameterTokenByName("NAME", 0, 0, true);
        segment.setImsName(NameValidator.validateName(newDbd.getDBDName(), segName));
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            segment.setName(NameValidator.validateName(newDbd.getDBDName(), externalName));
        } else {
            segment.setName(segName);
        }
        String maxbytes = tempS.getParameterTokenByName("BYTES", 0, 0, false);
        if (maxbytes != null) {
            segment.setMaxBytes(Integer.valueOf(maxbytes));
        }
        if ((encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false)) != null) {
            segment.setEncoding(encoding);
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            segment.setRemarks(remarks);
        }
        return segName;
    }

    private String handleGsamSegment(StatementSet sSet, int ssIndex, Statement tempS, SegmentModel segment, DbdModel newDbd) throws ImporterException, ModelException {
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            String remarks;
            segment.setName(NameValidator.validateName(newDbd.getDBDName(), externalName));
            String encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false);
            if (encoding != null) {
                segment.setEncoding(encoding);
            }
            if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
                segment.setRemarks(remarks);
            }
        }
        return externalName;
    }

    private String handleIndexSegment(StatementSet sSet, int ssIndex, Statement tempS, SegmentModel segment, DbdModel newDbd) throws ImporterException, ModelException {
        String remarks;
        String encoding;
        String freq;
        String segName = tempS.getParameterTokenByName("NAME", 0, 0, true);
        segment.setImsName(NameValidator.validateName(newDbd.getDBDName(), segName));
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            segment.setName(NameValidator.validateName(newDbd.getDBDName(), externalName));
        } else {
            segment.setName(segName);
        }
        tempS.getParameterTokenByName("PARENT", 0, 0, false);
        String maxbytes = tempS.getParameterTokenByName("BYTES", 0, 0, false);
        if (maxbytes != null) {
            segment.setMaxBytes(Integer.valueOf(maxbytes));
        }
        if ((freq = tempS.getParameterTokenByName("FREQ", 0, 0, false)) != null) {
            segment.setFreq(new BigDecimal(freq));
        }
        if ((encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false)) != null) {
            segment.setEncoding(encoding);
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            segment.setRemarks(remarks);
        }
        return segName;
    }

    private String handlePsindexSegment(StatementSet sSet, int ssIndex, Statement tempS, SegmentModel segment, DbdModel newDbd) throws ImporterException, ModelException {
        String remarks;
        String encoding;
        String maxbytes;
        String segName = tempS.getParameterTokenByName("NAME", 0, 0, true);
        segment.setImsName(NameValidator.validateName(newDbd.getDBDName(), segName));
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            segment.setName(NameValidator.validateName(newDbd.getDBDName(), externalName));
        } else {
            segment.setName(segName);
        }
        String freq = tempS.getParameterTokenByName("FREQ", 0, 0, false);
        if (freq != null) {
            segment.setFreq(new BigDecimal(freq));
        }
        if ((maxbytes = tempS.getParameterTokenByName("BYTES", 0, 0, false)) == null) {
            Object[] inserts = new Object[]{"NAME", "SEGM", newDbd.getDBDName()};
            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        segment.setMaxBytes(Integer.valueOf(maxbytes));
        String dsgroup = tempS.getParameterTokenByName("DSGROUP", 0, 0, false);
        if (dsgroup != null) {
            segment.setDsgroup(dsgroup);
        }
        String rules1 = tempS.getParameterTokenByName("RULES", 0, 0, false);
        String rules2 = tempS.getParameterTokenByName("RULES", 0, 1, false);
        if (rules1 != null || rules2 != null) {
            segment.setRules(rules1, rules2);
        }
        if ((encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false)) != null) {
            segment.setEncoding(encoding);
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            segment.setRemarks(remarks);
        }
        return segName;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String handleLogicalSegment(StatementSet sSet, int ssIndex, Statement tempS, SegmentModel segment, DbdModel newDbd) throws ImporterException, ModelException {
        String remarks;
        String segName = tempS.getParameterTokenByName("NAME", 0, 0, true);
        segment.setImsName(NameValidator.validateName(newDbd.getDBDName(), segName));
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            segment.setName(NameValidator.validateName(newDbd.getDBDName(), externalName));
        } else {
            segment.setName(segName);
        }
        tempS.getParameterTokenByName("PARENT", 0, 0, false);
        String freq = tempS.getParameterTokenByName("FREQ", 0, 0, false);
        if (freq != null) {
            segment.setFreq(new BigDecimal(freq));
        }
        String sourceSegment = tempS.getParameterTokenByName("SOURCE", 0, 0, false);
        String sourceData = tempS.getParameterTokenByName("SOURCE", 0, 1, false);
        String sourceDbd = tempS.getParameterTokenByName("SOURCE", 0, 2, false);
        String sourceSegment2 = tempS.getParameterTokenByName("SOURCE", 1, 0, false);
        String sourceData2 = tempS.getParameterTokenByName("SOURCE", 1, 1, false);
        String sourceDbd2 = tempS.getParameterTokenByName("SOURCE", 1, 2, false);
        String encoding = tempS.getParameterTokenByName("ENCODING", 0, 0, false);
        if (encoding != null) {
            segment.setEncoding(encoding);
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            segment.setRemarks(remarks);
        }
        if (sourceSegment != null && sourceSegment.length() > 0 && sourceSegment2 != null && sourceSegment2.length() > 0) {
            segment.createConcatenatedSegmentSource();
            segment.setLogicalChildSourceDBName(sourceDbd);
            segment.setLogicalChildSourceSegName(sourceSegment);
            if (sourceData != null) {
                if (sourceData.equalsIgnoreCase("DATA") || sourceData.equalsIgnoreCase("D")) {
                    segment.setLogicalChildSourceData(DBDConstants.Y);
                } else {
                    if (!sourceData.equalsIgnoreCase("KEY") && !sourceData.equalsIgnoreCase("K")) {
                        Object[] inserts = new Object[]{"SEGM", "SOURCE", sourceData};
                        ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                        logger.throwing(this.getClass().getName(), "", (Throwable)e);
                        throw e;
                    }
                    segment.setLogicalChildSourceData(DBDConstants.N);
                }
            } else {
                segment.setLogicalChildSourceData(DBDConstants.Y);
            }
            segment.setTargetParentSourceDBName(sourceDbd2);
            segment.setTargetParentSourceSegName(sourceSegment2);
            if (sourceData2 == null) {
                segment.setTargetParentSourceData(DBDConstants.Y);
                return segName;
            }
            if (sourceData2.equalsIgnoreCase("DATA") || sourceData2.equalsIgnoreCase("D")) {
                segment.setTargetParentSourceData(DBDConstants.Y);
                return segName;
            }
            if (!sourceData2.equalsIgnoreCase("KEY") && !sourceData2.equalsIgnoreCase("K")) {
                Object[] inserts = new Object[]{"SEGM", "SOURCE", sourceData2};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
            segment.setTargetParentSourceData(DBDConstants.N);
            return segName;
        }
        if (sourceSegment == null) return segName;
        if (sourceSegment.length() <= 0) return segName;
        segment.createSegmentSource();
        segment.setSegmentSourceDbname(sourceDbd);
        segment.setSegmentSourceSegName(sourceSegment);
        if (sourceData == null) {
            segment.setSegmentSourceData(DBDConstants.Y);
            return segName;
        }
        if (sourceData.equalsIgnoreCase("DATA") || sourceData.equalsIgnoreCase("D")) {
            segment.setSegmentSourceData(DBDConstants.Y);
            return segName;
        }
        if (!sourceData.equalsIgnoreCase("KEY") && !sourceData.equalsIgnoreCase("K")) {
            Object[] inserts = new Object[]{"SEGM", "SOURCE", sourceData};
            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        segment.setSegmentSourceData(DBDConstants.N);
        return segName;
    }

    private void handleLChild(Statement tempS, LogicalChildModel lchildType, DbdModel dbdModel) throws ImporterException {
        String multiseg;
        String remarks;
        String rksize;
        String index;
        String rules;
        String ptrStr;
        String dbName;
        String segName = tempS.getParameterTokenByName("NAME", 0, 0, true);
        lchildType.setName(segName);
        if (dbdModel.getAccessType() == DBDConstants.DEDB) {
            List<String> secondIxDbdNames = this.handleDedbSecondIxDbdNames(tempS);
            lchildType.setDedbSecondIxDbdNames(secondIxDbdNames);
        }
        if ((dbName = tempS.getParameterTokenByName("NAME", 0, 1, false)) != null) {
            lchildType.setDbd(dbName);
        } else {
            lchildType.setDbd(dbdModel.getDBDName());
        }
        String pair = tempS.getParameterTokenByName("PAIR", 0, 0, false);
        if (pair != null) {
            lchildType.setPair(pair);
        }
        if ((ptrStr = tempS.getParameterTokenByName("POINTER", 0, 0, false)) == null || ptrStr.length() == 0) {
            ptrStr = tempS.getParameterTokenByName("PTR", 0, 0, false);
        }
        if (ptrStr != null) {
            try {
                lchildType.setPointer(DBDConstants.fromValue(ptrStr));
            }
            catch (Throwable throwable) {
                Object[] inserts = new Object[]{"POINTER", "LCHILD", lchildType.getName()};
                ImporterException ie = new ImporterException(WorkbenchModelBundle.getError().getString("IMPORT_WIZ_008", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)ie);
                throw ie;
            }
        }
        if ((rules = tempS.getParameterTokenByName("RULES", 0, 0, false)) != null) {
            if (rules.equals("FIRST") || rules.equals("LAST") || rules.equals("HERE")) {
                lchildType.setRules(DBDConstants.fromValue(rules));
            } else if (rules.equals("F")) {
                lchildType.setRules(DBDConstants.FIRST);
            } else if (rules.equals("L")) {
                lchildType.setRules(DBDConstants.LAST);
            } else if (rules.equals("H")) {
                lchildType.setRules(DBDConstants.HERE);
            } else {
                Object[] inserts = new Object[]{"LCHILD", "RULES", rules};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
        }
        if ((index = tempS.getParameterTokenByName("INDEX", 0, 0, false)) != null) {
            lchildType.setIndex(index);
        }
        if ((rksize = tempS.getParameterTokenByName("RKSIZE", 0, 0, false)) != null) {
            lchildType.setRootKeySize(Integer.valueOf(rksize));
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            lchildType.setLchildRemarks(remarks);
        }
        if ((multiseg = tempS.getParameterTokenByName("MULTISEG", 0, 0, false)) != null) {
            if (multiseg.equals("YES") || multiseg.equals("NO")) {
                lchildType.setMultiSeg(multiseg);
            } else {
                Object[] inserts = new Object[]{"LCHILD", "MULTISEG", multiseg};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
        }
    }

    private List<String> handleDedbSecondIxDbdNames(Statement tempS) throws ImporterException {
        String name = null;
        ArrayList<String> names = new ArrayList<String>();
        int i = 1;
        do {
            if ((name = tempS.getParameterTokenByName("NAME", 0, i, false)) != null) {
                names.add(name);
            }
            ++i;
        } while (name != null);
        return names;
    }

    private void handleXfldType(Statement tempS, LogicalChildModel lchild) throws ImporterException {
        String remarks;
        String nullval;
        String pselOpt;
        String pselRtn;
        String exitRoutine;
        List<String> searchParms;
        String constChar;
        String sourceSegment;
        String extname;
        int i = 0;
        String ddata = "";
        boolean hasMoreData = true;
        String name = tempS.getParameterTokenByName("NAME", 0, 0, true);
        if (name != null && name.length() != 0) {
            lchild.setXdfldImsName(name);
        }
        if ((extname = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false)) != null && extname.length() != 0) {
            lchild.setXdfldName(extname);
        }
        if ((sourceSegment = tempS.getParameterTokenByName("SEGMENT", 0, 0, false)) != null && sourceSegment.length() != 0) {
            lchild.setXfldSourceSegment(sourceSegment);
        }
        if ((constChar = tempS.getParameterTokenByName("CONST", 0, 0, false)) != null && constChar.length() != 0) {
            lchild.setXfldConst(constChar);
        }
        if ((searchParms = tempS.getSRCHParameters("SRCH", false)) != null) {
            i = 0;
            while (i < searchParms.size()) {
                lchild.addSearchField(searchParms.get(i));
                ++i;
            }
        }
        hasMoreData = true;
        i = 0;
        while (hasMoreData) {
            ddata = tempS.getParameterTokenByName("DDATA", 0, i, false);
            if (ddata != null && ddata.length() != 0) {
                lchild.addDuplicateDataField(ddata);
                ++i;
                continue;
            }
            hasMoreData = false;
        }
        List<String> subseqParms = tempS.getSRCHParameters("SUBSEQ", false);
        if (subseqParms != null) {
            i = 0;
            while (i < subseqParms.size()) {
                lchild.addSubsequenceField(subseqParms.get(i));
                ++i;
            }
        }
        if ((exitRoutine = tempS.getParameterTokenByName("EXTRTN", 0, 0, false)) != null && exitRoutine.length() != 0) {
            lchild.setXfldIndexExitRoutine(exitRoutine);
        }
        if ((pselRtn = tempS.getParameterTokenByName("PSELRTN", 0, 0, false)) != null) {
            lchild.setPselrtn(pselRtn);
        }
        if ((pselOpt = tempS.getParameterTokenByName("PSELOPT", 0, 0, false)) != null) {
            lchild.setPselopt(pselOpt);
        }
        if ((nullval = tempS.getParameterTokenByName("NULLVAL", 0, 0, false)) != null && nullval.length() != 0) {
            lchild.setXfldNullval(nullval);
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null && remarks.length() != 0) {
            lchild.setXdfldRemarks(remarks);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleField(Statement tempS, FieldModel fieldModel, DbdModel newDbd, DBDConstants accessType) throws ImporterException {
        String remarks;
        block44: {
            block47: {
                String type;
                block49: {
                    block48: {
                        String bytes;
                        String start;
                        String fldName;
                        String seq;
                        String extName;
                        block45: {
                            block46: {
                                extName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
                                if (extName != null) {
                                    try {
                                        fieldModel.setName(NameValidator.validateName(newDbd.getDBDName(), extName));
                                    }
                                    catch (ImporterException e) {
                                        logger.throwing(this.getClass().getName(), "", (Throwable)e);
                                        throw e;
                                    }
                                }
                                if ((seq = tempS.getParameterTokenByName("NAME", 0, 1, false)) == null || !seq.equals("SEQ")) break block45;
                                String unique = tempS.getParameterTokenByName("NAME", 0, 2, false);
                                if (unique == null) break block46;
                                if (unique.equals("U")) {
                                    fieldModel.setSeqType(DBDConstants.U);
                                    break block45;
                                } else if (unique.equals("M")) {
                                    fieldModel.setSeqType(DBDConstants.M);
                                }
                                break block45;
                            }
                            fieldModel.setSeqType(DBDConstants.U);
                        }
                        boolean throwIfNull = false;
                        if (extName == null || seq != null && seq.equals("SEQ")) {
                            throwIfNull = true;
                        }
                        if ((fldName = tempS.getParameterTokenByName("NAME", 0, 0, throwIfNull)) != null) {
                            try {
                                fieldModel.setImsName(NameValidator.validateName(newDbd.getDBDName(), fldName));
                            }
                            catch (ImporterException e) {
                                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                                throw e;
                            }
                        }
                        if (fieldModel.getName() == null) {
                            fieldModel.setName(fieldModel.getImsName());
                        }
                        if ((start = tempS.getParameterTokenByName("START", 0, 0, false)) != null) {
                            fieldModel.setStartPos(Integer.valueOf(start));
                        }
                        if ((bytes = tempS.getParameterTokenByName("BYTES", 0, 0, false)) != null) {
                            fieldModel.setBytes(Integer.valueOf(bytes));
                        }
                        if ((type = tempS.getParameterTokenByName("TYPE", 0, 0, false)) == null) break block47;
                        if ("X".equalsIgnoreCase(type) || "F".equalsIgnoreCase(type) || "H".equalsIgnoreCase(type)) {
                            fieldModel.setAppDatatype(DBDConstants.BINARY);
                        } else if ("C".equalsIgnoreCase(type)) {
                            fieldModel.setAppDatatype(DBDConstants.CHAR);
                        } else {
                            if (!"P".equalsIgnoreCase(type)) {
                                Object[] inserts = new Object[]{"FIELD", "TYPE", type};
                                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                                throw e;
                            }
                            fieldModel.setAppDatatype(DBDConstants.BINARY);
                        }
                        if (!"X".equalsIgnoreCase(type)) break block48;
                        fieldModel.setImsDatatype(DBDConstants.X);
                        break block44;
                    }
                    if (!"F".equalsIgnoreCase(type)) break block49;
                    fieldModel.setImsDatatype(DBDConstants.F);
                    break block44;
                }
                if ("H".equalsIgnoreCase(type)) {
                    fieldModel.setImsDatatype(DBDConstants.H);
                    break block44;
                } else if ("C".equalsIgnoreCase(type)) {
                    fieldModel.setImsDatatype(DBDConstants.C);
                    break block44;
                } else {
                    if (!"P".equalsIgnoreCase(type)) {
                        Object[] inserts = new Object[]{"FIELD", "TYPE", type};
                        ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                        logger.throwing(this.getClass().getName(), "", (Throwable)e);
                        throw e;
                    }
                    fieldModel.setImsDatatype(DBDConstants.P);
                }
                break block44;
            }
            fieldModel.setAppDatatype(DBDConstants.CHAR);
        }
        String dataType = tempS.getParameterTokenByName("DATATYPE", 0, 0, false);
        DBDConstants dataTypeEnum = null;
        if (dataType != null) {
            try {
                dataTypeEnum = DBDConstants.fromValue(dataType);
                fieldModel.setAppDatatype(dataTypeEnum);
            }
            catch (Throwable throwable) {
                Object[] inserts = new Object[]{"DATATYPE", "FIELD", fieldModel.getImsNameOrAlias()};
                ImporterException ie = new ImporterException(WorkbenchModelBundle.getError().getString("IMPORT_WIZ_008", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)ie);
                throw ie;
            }
            if (dataTypeEnum == DBDConstants.DECIMAL) {
                String precision = tempS.getParameterTokenByName("DATATYPE", 0, 1, false);
                String scale = tempS.getParameterTokenByName("DATATYPE", 0, 2, false);
                try {
                    fieldModel.setPrecision(precision);
                    if (fieldModel.getPrecision() < 1) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] inserts = new Object[]{newDbd.getDBDName(), "precision value of the DATATYPE=DECIMAL(pp, ss)", precision};
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE008", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
                try {
                    if (scale == null) {
                        fieldModel.setScale("0");
                    } else {
                        fieldModel.setScale(scale);
                    }
                    if (fieldModel.getScale() < 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] inserts = new Object[]{newDbd.getDBDName(), "scale value of the DATATYPE=DECIMAL(pp, ss)", scale};
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE008", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
            }
        }
        if (accessType != DBDConstants.MSDB) {
            String redefines;
            String maxOccurs;
            String minOccurs;
            String dependsOn;
            String startAfter;
            String relStart;
            String maxBytes;
            if ((dataTypeEnum != null & dataTypeEnum == DBDConstants.STRUCT || dataTypeEnum == DBDConstants.ARRAY) && (maxBytes = tempS.getParameterTokenByName("MAXBYTES", 0, 0, false)) != null) {
                fieldModel.setMaxBytes(Integer.valueOf(maxBytes));
            }
            if ((relStart = tempS.getParameterTokenByName("RELSTART", 0, 0, false)) != null) {
                fieldModel.setRelativeStart(Integer.valueOf(relStart));
                fieldModel.setStartPos(-1);
            }
            if ((startAfter = tempS.getParameterTokenByName("STARTAFTER", 0, 0, false)) != null) {
                fieldModel.setStartAfter(startAfter);
                fieldModel.setStartPos(-1);
            }
            if ((dependsOn = tempS.getParameterTokenByName("DEPENDSON", 0, 0, false)) != null) {
                fieldModel.setDependsOn(dependsOn);
            }
            if ((minOccurs = tempS.getParameterTokenByName("MINOCCURS", 0, 0, false)) != null) {
                fieldModel.setMinOccurs(Integer.valueOf(minOccurs));
            }
            if ((maxOccurs = tempS.getParameterTokenByName("MAXOCCURS", 0, 0, false)) != null) {
                fieldModel.setMaxOccurs(Integer.valueOf(maxOccurs));
            }
            if ((redefines = tempS.getParameterTokenByName("REDEFINES", 0, 0, false)) != null) {
                fieldModel.setRedefines(redefines);
            }
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            fieldModel.setRemarks(remarks);
        }
    }

    private void handleDatxexit(Statement tempS, DbdModel dbd) throws ImporterException {
        if (dbd.getAccessType() == DBDConstants.HDAM || dbd.getAccessType() == DBDConstants.HSAM || dbd.getAccessType() == DBDConstants.SHSAM || dbd.getAccessType() == DBDConstants.GSAM || dbd.getAccessType() == DBDConstants.HISAM || dbd.getAccessType() == DBDConstants.SHISAM || dbd.getAccessType() == DBDConstants.PHDAM || dbd.getAccessType() == DBDConstants.HIDAM || dbd.getAccessType() == DBDConstants.PHIDAM || dbd.getAccessType() == DBDConstants.INDEX || dbd.getAccessType() == DBDConstants.PSINDEX) {
            String datxexit = tempS.getParameterTokenByName("DATXEXIT", 0, 0, false);
            if (datxexit == null) {
                dbd.setDatxexit(com.ibm.im.ims.metadata.dbd.YesnoType.N);
            } else if (datxexit.equalsIgnoreCase("YES")) {
                dbd.setDatxexit(com.ibm.im.ims.metadata.dbd.YesnoType.Y);
            } else if (datxexit.equalsIgnoreCase("NO")) {
                dbd.setDatxexit(com.ibm.im.ims.metadata.dbd.YesnoType.N);
            } else {
                Object[] inserts = new Object[]{"DBD", "DATXEXIT", datxexit};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
        }
    }

    private void handleVersion(Statement tempS, DbdModel dbd) throws ImporterException {
        String version = tempS.getParameterTokenByName("VERSION", 0, 0, false);
        if (version != null) {
            dbd.setVersion(version);
        }
    }

    private void handleDbver(Statement tempS, DbdModel dbd) throws ImporterException {
        String dbver = tempS.getParameterTokenByName("DBVER", 0, 0, false);
        if (dbver != null) {
            dbd.setUserVersion(Integer.parseInt(dbver));
        }
    }

    private void handlePsname(Statement tempS, DbdModel dbd) throws ImporterException {
        String psname;
        if ((dbd.getAccessType().equals((Object)DBDConstants.PHDAM) || dbd.getAccessType().equals((Object)DBDConstants.PHIDAM) || dbd.getAccessType().equals((Object)DBDConstants.PSINDEX)) && (psname = tempS.getParameterTokenByName("PSNAME", 0, 0, false)) != null) {
            try {
                dbd.setPsname(psname);
            }
            catch (ModelException e) {
                throw new ImporterException(e);
            }
        }
    }

    private void handleExit(Statement tempS, DbdModel dbd, SegmentModel segment) throws ImporterException, ModelException {
        if (dbd.getAccessType() == DBDConstants.HDAM || dbd.getAccessType() == DBDConstants.HISAM || dbd.getAccessType() == DBDConstants.SHISAM || dbd.getAccessType() == DBDConstants.PHDAM || dbd.getAccessType() == DBDConstants.HIDAM || dbd.getAccessType() == DBDConstants.PHIDAM || dbd.getAccessType() == DBDConstants.DEDB) {
            int cascadeState = 1004;
            List<String> exitParms = tempS.getExitParameters("EXIT", false);
            if (exitParms != null && exitParms.size() > 0) {
                this.exitParmCount = 0;
                int totalParms = exitParms.size();
                DataExitRoutine dataExit = new DataExitRoutine();
                String nextParm = exitParms.get(this.exitParmCount);
                if (nextParm.equals("*")) {
                    dataExit.setExitName("*");
                } else {
                    assert (!nextParm.equals("("));
                    dataExit.setExitName(nextParm);
                }
                ++this.exitParmCount;
                while (this.exitParmCount < totalParms) {
                    nextParm = exitParms.get(this.exitParmCount);
                    if (nextParm.equals("LOG")) {
                        dataExit.setLog(DBDConstants.Y);
                    } else if (nextParm.equals("NOLOG")) {
                        dataExit.setLog(DBDConstants.N);
                    } else if (nextParm.equals("KEY")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitKey(DBDConstants.Y);
                        } else {
                            dataExit.setCascadeKey(DBDConstants.Y);
                        }
                    } else if (nextParm.equals("NOKEY")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitKey(DBDConstants.N);
                        } else {
                            dataExit.setCascadeKey(DBDConstants.N);
                        }
                    } else if (nextParm.equals("PATH")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitPath(DBDConstants.Y);
                        } else {
                            dataExit.setCascadePath(DBDConstants.Y);
                        }
                    } else if (nextParm.equals("NOPATH")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitPath(DBDConstants.N);
                        } else {
                            dataExit.setCascadePath(DBDConstants.N);
                        }
                    } else if (nextParm.equals("DATA")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitData(DBDConstants.Y);
                        } else {
                            dataExit.setCascadeData(DBDConstants.Y);
                        }
                    } else if (nextParm.equals("NODATA")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitData(DBDConstants.N);
                        } else {
                            dataExit.setCascadeData(DBDConstants.N);
                        }
                    } else if (nextParm.equals("CASCADE")) {
                        dataExit.setDoCascade(DBDConstants.Y);
                    } else if (nextParm.equals("NOCASCADE")) {
                        dataExit.setDoCascade(DBDConstants.N);
                    } else if (nextParm.equals("DLET")) {
                        dataExit.setDlet(DBDConstants.Y);
                    } else if (nextParm.equals("NODLET")) {
                        dataExit.setDlet(DBDConstants.N);
                    } else if (nextParm.equals("BEFORE")) {
                        dataExit.setBefore(DBDConstants.Y);
                    } else if (nextParm.equals("NOBEFORE")) {
                        dataExit.setBefore(DBDConstants.N);
                    } else if (nextParm.equals("SSPCMD")) {
                        dataExit.setSspcmd(DBDConstants.Y);
                    } else if (nextParm.equals("NOSSPCMD")) {
                        dataExit.setSspcmd(DBDConstants.N);
                    } else if (nextParm.equals("INPOS")) {
                        dataExit.setInpos(DBDConstants.Y);
                    } else if (nextParm.equals("NOINPOS")) {
                        dataExit.setInpos(DBDConstants.N);
                    } else if (nextParm.equals("FLD")) {
                        dataExit.setFld(DBDConstants.Y);
                    } else if (nextParm.equals("NOFLD")) {
                        dataExit.setFld(DBDConstants.N);
                    } else if (nextParm.equals("(")) {
                        if (exitParms.get(this.exitParmCount + 1).equals("CASCADEOPTIONS")) {
                            dataExit.setDoCascade(DBDConstants.Y);
                            cascadeState = 1003;
                            ++this.exitParmCount;
                        } else if (exitParms.get(this.exitParmCount + 1).equals("NOCASCADEOPTIONS")) {
                            dataExit.setDoCascade(DBDConstants.N);
                            cascadeState = 1003;
                            ++this.exitParmCount;
                        }
                    } else if (nextParm.equals(")")) {
                        assert (cascadeState == 1003);
                        cascadeState = 1004;
                    } else if (nextParm.equals("*")) {
                        assert (cascadeState != 1003);
                        if (segment != null) {
                            if (dataExit.getExitName().equalsIgnoreCase("NONE")) {
                                dataExit = null;
                                segment.setDataCaptureExitNone();
                                return;
                            }
                            segment.addDataCaptureExitRoutine(dataExit);
                        } else {
                            dbd.addDataCaptureExitRoutine(dataExit);
                        }
                        dataExit = new DataExitRoutine();
                        cascadeState = 1004;
                        dataExit.setExitName("*");
                    } else {
                        assert (cascadeState != 1003);
                        if (segment != null) {
                            if (dataExit.getExitName().equalsIgnoreCase("NONE")) {
                                dataExit = null;
                                segment.setDataCaptureExitNone();
                                return;
                            }
                            segment.addDataCaptureExitRoutine(dataExit);
                        } else {
                            dbd.addDataCaptureExitRoutine(dataExit);
                        }
                        dataExit = new DataExitRoutine();
                        cascadeState = 1004;
                        dataExit.setExitName(exitParms.get(this.exitParmCount));
                    }
                    ++this.exitParmCount;
                }
                assert (cascadeState != 1003);
                if (segment != null) {
                    if (dataExit.getExitName().equalsIgnoreCase("NONE")) {
                        dataExit = null;
                        segment.setDataCaptureExitNone();
                        return;
                    }
                    segment.addDataCaptureExitRoutine(dataExit);
                } else {
                    dbd.addDataCaptureExitRoutine(dataExit);
                }
            }
        }
    }

    private void handlePasswd(Statement tempS, DbdModel dbd) throws ImporterException {
        if (dbd.getAccessType() == DBDConstants.HDAM || dbd.getAccessType() == DBDConstants.GSAM || dbd.getAccessType() == DBDConstants.HISAM || dbd.getAccessType() == DBDConstants.SHISAM || dbd.getAccessType() == DBDConstants.PHDAM || dbd.getAccessType() == DBDConstants.HIDAM || dbd.getAccessType() == DBDConstants.PHIDAM || dbd.getAccessType() == DBDConstants.INDEX || dbd.getAccessType() == DBDConstants.PSINDEX) {
            String passwd = tempS.getParameterTokenByName("PASSWD", 0, 0, false);
            if (passwd == null) {
                dbd.setPassword(com.ibm.im.ims.metadata.dbd.YesnoType.N);
            } else if (passwd.equalsIgnoreCase("YES")) {
                dbd.setPassword(com.ibm.im.ims.metadata.dbd.YesnoType.Y);
            } else if (passwd.equalsIgnoreCase("NO")) {
                dbd.setPassword(com.ibm.im.ims.metadata.dbd.YesnoType.N);
            } else {
                Object[] inserts = new Object[]{"DBD", "PASSWD", passwd};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
        }
    }

    private void handleArea(StatementSet sSet, DbdModel newDbd) throws ImporterException, ModelException {
        int i = 0;
        while (i < sSet.size) {
            Statement tempS = (Statement)sSet.statements.get(i);
            if (tempS.type.equals("AREA")) {
                String ddname1 = tempS.getParameterTokenByName("DD1", 0, 0, false);
                String size1 = tempS.getParameterTokenByName("SIZE", 0, 0, false);
                String number1 = tempS.getParameterTokenByName("UOW", 0, 0, false);
                String overflow1 = tempS.getParameterTokenByName("UOW", 0, 1, false);
                String number2 = tempS.getParameterTokenByName("ROOT", 0, 0, false);
                String overflow2 = tempS.getParameterTokenByName("ROOT", 0, 1, false);
                String remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false);
                AreaStmt areaModel = new AreaStmt();
                if (ddname1 == null) {
                    Object[] inserts = new Object[]{"DD1", "AREA", newDbd.getDBDName()};
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
                areaModel.setDd1(ddname1);
                if (size1 == null) {
                    Object[] inserts = new Object[]{"SIZE", "AREA DD1=" + ddname1, newDbd.getDBDName()};
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
                areaModel.setSize(size1);
                if (number1 == null) {
                    Object[] inserts = new Object[]{"UOW=(number1", "AREA DD1=" + ddname1, newDbd.getDBDName()};
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
                areaModel.setUowNumber1(Integer.valueOf(number1));
                if (overflow1 == null) {
                    Object[] inserts = new Object[3];
                    inserts[0] = "UOW=(,overflow1";
                    inserts[1] = "AREA DD1=" + ddname1;
                    inserts[1] = newDbd.getDBDName();
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
                areaModel.setUowOverflow1(Integer.valueOf(overflow1));
                if (number2 == null) {
                    Object[] inserts = new Object[3];
                    inserts[0] = "ROOT=(number2";
                    inserts[1] = "AREA DD1=" + ddname1;
                    inserts[1] = newDbd.getDBDName();
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
                areaModel.setRootNumber2(Integer.valueOf(number2));
                if (overflow2 == null) {
                    Object[] inserts = new Object[3];
                    inserts[0] = "ROOT=(,overflow2";
                    inserts[1] = "AREA DD1=" + ddname1;
                    inserts[1] = newDbd.getDBDName();
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE004", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
                areaModel.setRootOverflow2(Integer.valueOf(overflow2));
                if (remarks != null) {
                    areaModel.setRemarks(remarks);
                }
                newDbd.setArea(areaModel);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleAccess(Statement tempS, DbdModel dbd) throws ImporterException, ModelException {
        String prot;
        if (dbd.getAccessType() == DBDConstants.HDAM || dbd.getAccessType() == DBDConstants.GSAM || dbd.getAccessType() == DBDConstants.HISAM || dbd.getAccessType() == DBDConstants.SHISAM || dbd.getAccessType() == DBDConstants.PHDAM || dbd.getAccessType() == DBDConstants.HIDAM || dbd.getAccessType() == DBDConstants.PHIDAM || dbd.getAccessType() == DBDConstants.INDEX || dbd.getAccessType() == DBDConstants.PSINDEX) {
            String osAccess = tempS.getParameterTokenByName("ACCESS", 0, 1, false);
            if (osAccess == null || osAccess.equalsIgnoreCase("ISAM")) {
                dbd.setOsAccess("VSAM");
            } else {
                if (!(osAccess.equalsIgnoreCase("VSAM") || osAccess.equalsIgnoreCase("OSAM") || osAccess.equalsIgnoreCase("BSAM") || osAccess.equalsIgnoreCase("SHISAM"))) {
                    Object[] inserts = new Object[]{dbd.getDBDName(), "ACCESS", osAccess};
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE008", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
                dbd.setOsAccess(osAccess);
            }
        }
        if (dbd.getAccessType() == DBDConstants.INDEX) {
            prot = tempS.getParameterTokenByName("ACCESS", 0, 2, false);
            String doscomp = tempS.getParameterTokenByName("ACCESS", 0, 3, false);
            if (prot == null) {
                dbd.setProt(com.ibm.im.ims.metadata.dbd.YesnoType.Y);
                dbd.setDoscomp(com.ibm.im.ims.metadata.dbd.YesnoType.N);
                return;
            }
            if (prot.equalsIgnoreCase("PROT")) {
                dbd.setProt(com.ibm.im.ims.metadata.dbd.YesnoType.Y);
            } else if (prot.equalsIgnoreCase("NOPROT")) {
                dbd.setProt(com.ibm.im.ims.metadata.dbd.YesnoType.N);
            } else {
                if (!prot.equalsIgnoreCase("DOSCOMP")) {
                    Object[] inserts = new Object[]{"DBD", "ACCESS", prot};
                    ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
                    logger.throwing(this.getClass().getName(), "", (Throwable)e);
                    throw e;
                }
                dbd.setProt(com.ibm.im.ims.metadata.dbd.YesnoType.Y);
                dbd.setDoscomp(com.ibm.im.ims.metadata.dbd.YesnoType.Y);
            }
            if (doscomp == null) {
                dbd.setDoscomp(com.ibm.im.ims.metadata.dbd.YesnoType.N);
                return;
            }
            if (doscomp.equalsIgnoreCase("DOSCOMP")) {
                dbd.setDoscomp(com.ibm.im.ims.metadata.dbd.YesnoType.Y);
                return;
            }
            Object[] inserts = new Object[]{"DBD", "ACCESS", doscomp};
            ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        if (dbd.getAccessType() != DBDConstants.PSINDEX) return;
        prot = tempS.getParameterTokenByName("ACCESS", 0, 2, false);
        if (prot == null) {
            dbd.setProt(com.ibm.im.ims.metadata.dbd.YesnoType.Y);
            return;
        }
        if (prot.equalsIgnoreCase("PROT")) {
            dbd.setProt(com.ibm.im.ims.metadata.dbd.YesnoType.Y);
            return;
        }
        if (prot.equalsIgnoreCase("NOPROT")) {
            dbd.setProt(com.ibm.im.ims.metadata.dbd.YesnoType.N);
            return;
        }
        Object[] inserts = new Object[]{"DBD", "ACCESS", prot};
        ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE003", inserts));
        logger.throwing(this.getClass().getName(), "", (Throwable)e);
        throw e;
    }

    private void handleRmname(Statement tempS, DbdModel dbd) throws ImporterException, ModelException {
        if (dbd.getAccessType() == DBDConstants.DEDB) {
            String rmname = tempS.getParameterTokenByName("RMNAME", 0, 0, false);
            String numAnchorPoints = tempS.getParameterTokenByName("RMNAME", 0, 1, false);
            String xci = tempS.getParameterTokenByName("RMNAME", 0, 4, false);
            if (rmname == null) {
                Object[] inserts = new Object[]{dbd.getDBDName()};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE012", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
            dbd.setRMName(rmname);
            if (numAnchorPoints != null) {
                dbd.setRmNameAnchorPoints(Integer.valueOf(numAnchorPoints));
            } else {
                dbd.setRmNameAnchorPoints(-1);
            }
            if (xci != null) {
                dbd.setXci(DBDConstants.Y.toString());
            }
        } else if (dbd.getAccessType() == DBDConstants.HDAM || dbd.getAccessType() == DBDConstants.PHDAM) {
            String rmname = tempS.getParameterTokenByName("RMNAME", 0, 0, false);
            String numAnchorPoints = tempS.getParameterTokenByName("RMNAME", 0, 1, false);
            String rbn = tempS.getParameterTokenByName("RMNAME", 0, 2, false);
            String bytes = tempS.getParameterTokenByName("RMNAME", 0, 3, false);
            if (rmname == null) {
                Object[] inserts = new Object[]{dbd.getDBDName(), dbd.getAccessType()};
                ImporterException e = new ImporterException(WorkbenchModelBundle.getError().getString("WBIE012H", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
            dbd.setRMName(rmname);
            if (numAnchorPoints != null) {
                dbd.setRmNameAnchorPoints(Integer.valueOf(numAnchorPoints));
            } else {
                dbd.setRmNameAnchorPoints(-1);
            }
            if (rbn != null) {
                dbd.setRmNameMaxRBN(Integer.valueOf(rbn));
            } else {
                dbd.setRmNameMaxRBN(-1);
            }
            if (bytes != null) {
                dbd.setRmNameBytes(Integer.valueOf(bytes));
            } else {
                dbd.setRmNameBytes(-1);
            }
        }
    }

    private void handlePcbs(StatementSet sSet, PsbModel psb) throws ImporterException, ModelException {
        int pcbSeqNumber = 0;
        int i = 0;
        while (i < sSet.size) {
            Statement tempS = (Statement)sSet.statements.get(i);
            if (tempS.type.equals("PCB")) {
                String type = tempS.getParameterTokenByName("TYPE", 0, 0, true);
                if (type.equals("DB") || type.equals("GSAM")) {
                    String dbdName = tempS.getParameterTokenByName("DBDNAME", 0, 0, false);
                    String name = tempS.getParameterTokenByName("NAME", 0, 0, false);
                    String actualDbdName = dbdName;
                    if (dbdName == null) {
                        actualDbdName = name;
                    }
                    if (actualDbdName == null) {
                        Object[] inserts = new Object[]{psb.getPsbName(), "handlePcbs()"};
                        ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("PCB_DBD_NOFND", inserts), ImporterException.SEVERITY.WARNING);
                        logger.throwing(this.getClass().getName(), "", (Throwable)e);
                        throw e;
                    }
                    if (type.equals("DB")) {
                        this.handleDbPcb(sSet, psb, i, actualDbdName, pcbSeqNumber++);
                    } else {
                        this.handleGsamPcb(sSet, psb, i, actualDbdName, pcbSeqNumber++);
                    }
                } else if (type.equals("TP")) {
                    this.handleTPPcb(sSet, psb, i, pcbSeqNumber++);
                }
            }
            ++i;
        }
    }

    private void handleDbPcb(StatementSet sSet, PsbModel psb, int ssPosition, String dbdName, int pcbSeqNumber) throws ImporterException, ModelException {
        String timestamp;
        String pcbAlias;
        String access;
        String pselopt;
        String procseqd;
        String remarks;
        String view;
        String procseq;
        String pos;
        String keylen;
        String copies;
        String sb;
        String list;
        String dbver;
        PcbDBModel pcb = new PcbDBModel();
        pcb.setDbd(dbdName);
        psb.addDBPcb(pcb);
        Statement tempS = this.locatePcbInStatementSet(sSet, ssPosition, dbdName);
        if (tempS.label != null && tempS.getParameterTokenByName("PCBNAME", 0, 0, false) != null) {
            Object[] inserts = new Object[]{dbdName, psb.getPsbName()};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("TOO_MANY_PCBNAMES", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        if (tempS.label != null && !tempS.label.isEmpty()) {
            pcb.setLabel(tempS.label);
            pcb.setPcbAlias(pcb.getLabel());
        } else if (tempS.getParameterTokenByName("PCBNAME", 0, 0, false) != null) {
            pcb.setPcbName(tempS.getParameterTokenByName("PCBNAME", 0, 0, false));
            pcb.setPcbAlias(pcb.getPcbName());
        }
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            pcb.setName(externalName);
        }
        if ((dbver = tempS.getParameterTokenByName("DBVER", 0, 0, false)) != null) {
            pcb.setDbdUserVersion(Integer.parseInt(dbver));
        }
        if ((list = tempS.getParameterTokenByName("LIST", 0, 0, false)) != null && list.equals("YES")) {
            pcb.setList(DBDConstants.Y);
        } else if (list != null && list.equals("NO")) {
            pcb.setList(DBDConstants.N);
        }
        String procopt = tempS.getParameterTokenByName("PROCOPT", 0, 0, false);
        if (procopt != null) {
            pcb.setProcopt(procopt);
        }
        if ((sb = tempS.getParameterTokenByName("SB", 0, 0, false)) != null) {
            if (sb.equals("NO")) {
                pcb.setSb(DBDConstants.NO);
            } else if (sb.equals("COND")) {
                pcb.setSb(DBDConstants.COND);
            }
        }
        if ((copies = tempS.getParameterTokenByName("COPIES", 0, 0, false)) != null) {
            pcb.setCopies(Integer.valueOf(copies));
        }
        if ((keylen = tempS.getParameterTokenByName("KEYLEN", 0, 0, false)) != null) {
            pcb.setKeyLength(Integer.valueOf(keylen));
        }
        if ((pos = tempS.getParameterTokenByName("POS", 0, 0, false)) != null) {
            if (pos.equals("SINGLE") || pos.equals("S")) {
                pcb.setPos(DBDConstants.S);
            } else if (pos.equals("MULTIPLE") || pos.equals("M")) {
                pcb.setPos(DBDConstants.M);
            }
        }
        if ((procseq = tempS.getParameterTokenByName("PROCSEQ", 0, 0, false)) != null) {
            pcb.setProcSequence(procseq);
        }
        if ((view = tempS.getParameterTokenByName("VIEW", 0, 1, false)) != null && view.equalsIgnoreCase("MSDB")) {
            pcb.setView(DBDConstants.MSDB);
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            pcb.setRemarks(remarks);
        }
        if ((procseqd = tempS.getParameterTokenByName("PROCSEQD", 0, 0, false)) != null) {
            pcb.setProcSequenceD(procseqd);
        }
        if ((pselopt = tempS.getParameterTokenByName("PSELOPT", 0, 0, false)) != null) {
            if (pselopt.equals("MULT")) {
                pcb.setPselOpt(PseloptType.M);
            } else if (pselopt.equals("SNGL")) {
                pcb.setPselOpt(PseloptType.S);
            }
        }
        if ((access = tempS.getParameterTokenByName("ACCESS", 0, 0, false)) != null) {
            if (access.equals("DB")) {
                pcb.setAccess(AccessFPIndexType.D);
            } else if (access.equals("INDEX")) {
                pcb.setAccess(AccessFPIndexType.I);
            }
        }
        if ((pcbAlias = pcb.getExternalName()) == null || pcbAlias.isEmpty()) {
            String pcbName = pcb.getPcbName();
            if (pcbName == null || pcbName.isEmpty()) {
                pcbName = pcb.getLabel();
            }
            pcbAlias = pcbName;
            pcb.setName(pcbAlias);
        }
        if ((timestamp = pcb.getTimestamp()) == null || timestamp.isEmpty()) {
            pcb.setTimestamp("0000000000000");
        }
        this.handleSensegs(sSet, ssPosition, dbdName, pcb);
    }

    private void handleSensegs(StatementSet sSet, int ssPosition, String dbdName, PcbDBModel pcb) throws ImporterException, ModelException {
        Vector sensegs;
        Statement tempS = null;
        SensegType senseg = null;
        Hashtable<String, Vector<SensegType>> sensegHashtable = new Hashtable<String, Vector<SensegType>>();
        int i = ssPosition + 1;
        while (i < sSet.size) {
            tempS = (Statement)sSet.statements.get(i);
            if (tempS.type.equals("SENSEG")) {
                String segName = tempS.getParameterTokenByName("NAME", 0, 0, true);
                senseg = new SensegType();
                this.handleSenseg(sSet, i, segName, senseg, sensegHashtable, pcb);
            } else if (((Statement)sSet.statements.get((int)i)).type.equals("PCB") || ((Statement)sSet.statements.get((int)i)).type.equals("DBDGEN") || ((Statement)sSet.statements.get((int)i)).type.equals("FINISH") || ((Statement)sSet.statements.get((int)i)).type.equals("END")) break;
            ++i;
        }
        if ((sensegs = (Vector)sensegHashtable.get("0")) == null) {
            Object[] inserts = new Object[]{"Root Segment", sSet, "handleSensegs"};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("SENSEG_NOFND", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        SensegType jaxbRootSenseg = (SensegType)sensegs.get(0);
        SensegModel rootSenseg = new SensegModel(jaxbRootSenseg, null);
        pcb.setRootSenseg(rootSenseg);
        this.addChildSensegs(rootSenseg, sensegHashtable);
    }

    private void addChildSensegs(SensegModel parent, Hashtable<String, Vector<SensegType>> sensegHashtable) throws ModelException {
        Vector<SensegType> childVector = sensegHashtable.get(parent.getName());
        if (childVector != null && childVector.size() > 0) {
            int i = 0;
            while (i < childVector.size()) {
                SensegType jaxbChild = childVector.elementAt(i);
                SensegModel child = new SensegModel(jaxbChild, parent);
                parent.addChild(child);
                this.addChildSensegs(child, sensegHashtable);
                ++i;
            }
        }
    }

    private void handleSenseg(StatementSet sSet, int ssPosition, String sensegName, SensegType senseg, Hashtable<String, Vector<SensegType>> sensegHashtable, PcbDBModel pcb) throws ImporterException {
        String remarks;
        String parent;
        String ssptrs;
        Statement tempS = null;
        Object owningPsbName = null;
        tempS = (Statement)sSet.statements.get(ssPosition);
        if (!tempS.type.equals("SENSEG") || !tempS.getParameterTokenByName("NAME", 0, 0, true).equals(sensegName)) {
            Object[] inserts = new Object[]{sensegName, owningPsbName, "SensegMeta.handleSenseg"};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("SENSEG_NOFND", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        senseg.setName(sensegName);
        String procopt = tempS.getParameterTokenByName("PROCOPT", 0, 0, false);
        if (procopt != null) {
            senseg.setProcopt(procopt);
        }
        if ((ssptrs = tempS.getParameterByNameAsString("SSPTR", false)) != null) {
            List<SsptrType> list = senseg.getSsptr();
            IMSSourceImporter.parseSsptr(list, ssptrs);
        }
        if ((parent = tempS.getParameterTokenByName("PARENT", 0, 0, false)) == null) {
            parent = "0";
        }
        String indicesStr = tempS.getParameterByNameAsString("INDICES", false);
        IndicesType it = senseg.getIndices();
        if (it == null) {
            it = new IndicesType();
            senseg.setIndices(it);
        }
        List<String> indices = it.getIndex();
        if (indicesStr != null) {
            IMSSourceImporter.parseIndices(indices, indicesStr);
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            senseg.setRemarks(remarks);
        }
        this.handleSenflds(sSet, ssPosition, sensegName, senseg, pcb);
        if (sensegHashtable.containsKey(parent)) {
            sensegHashtable.get(parent).addElement(senseg);
        } else {
            Vector<SensegType> temp = new Vector<SensegType>();
            temp.addElement(senseg);
            sensegHashtable.put(parent, temp);
        }
    }

    private static void parseSsptr(List<SsptrType> list, String ssptrStr) {
        StringTokenizer tokr = new StringTokenizer(ssptrStr, "(), ", false);
        boolean state = false;
        int pointerNum = -1;
        try {
            String pointerSensitivity;
            while (tokr.hasMoreTokens()) {
                boolean sensitivityReceived;
                String nextTok = tokr.nextToken();
                if (!state) {
                    pointerNum = Integer.valueOf(nextTok);
                    if (pointerNum <= 0 || pointerNum >= 9) {
                        System.out.println("ERROR");
                    }
                    state = true;
                    continue;
                }
                if ("U".equalsIgnoreCase(nextTok) || "R".equalsIgnoreCase(nextTok)) {
                    pointerSensitivity = nextTok;
                    sensitivityReceived = true;
                } else {
                    pointerSensitivity = "R";
                    sensitivityReceived = false;
                }
                SsptrType newSsptr = new SsptrType();
                newSsptr.setSsptrNum(pointerNum);
                newSsptr.setSsptrSensitivity(SsptrSensitivityType.valueOf(pointerSensitivity));
                list.add(newSsptr);
                if (sensitivityReceived) {
                    state = false;
                    continue;
                }
                pointerNum = Integer.valueOf(nextTok);
                if (pointerNum > 0 && pointerNum < 9) continue;
                System.out.println("ERROR");
            }
            if (state) {
                pointerSensitivity = "R";
                SsptrType newSsptr = new SsptrType();
                newSsptr.setSsptrNum(pointerNum);
                newSsptr.setSsptrSensitivity(SsptrSensitivityType.valueOf(pointerSensitivity));
                list.add(newSsptr);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private static void parseIndices(List<String> indices, String indicesStr) {
        StringTokenizer tokr = new StringTokenizer(indicesStr, "(), ", false);
        while (tokr.hasMoreTokens()) {
            String nextTok = tokr.nextToken();
            indices.add(nextTok);
        }
    }

    private void handleSenflds(StatementSet sSet, int ssPosition, String sensegName, SensegType senseg, PcbDBModel pcb) throws ImporterException {
        Statement tempS = null;
        SenfldType senfld = null;
        List<SenfldType> senfldList = senseg.getSenfld();
        tempS = (Statement)sSet.statements.get(ssPosition);
        if (!tempS.type.equals("SENSEG") || !tempS.getParameterTokenByName("NAME", 0, 0, false).equals(sensegName)) {
            Object[] inserts = new Object[]{sensegName, "should be PSB name", "SenfldMeta.CreateSenflds"};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("SENSEG_NOFND", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        int i = ssPosition + 1;
        while (i < sSet.size) {
            tempS = (Statement)sSet.statements.get(i);
            if (!tempS.type.equals("SENFLD")) break;
            String fldName = tempS.getParameterTokenByName("NAME", 0, 0, true);
            senfld = new SenfldType();
            if (senfld == null) {
                Object[] inserts = new Object[]{fldName, "handleSenflds"};
                ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("SENFLD_CREATE_FAIL", inserts), ImporterException.SEVERITY.WARNING);
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                throw e;
            }
            this.handleSenfld(sSet, i, senfld, fldName, senfldList, pcb);
            ++i;
        }
    }

    private void handleSenfld(StatementSet sSet, int ssPosition, SenfldType senfld, String fldName, List<SenfldType> senfldList, PcbDBModel pcb) throws ImporterException {
        Statement tempS = null;
        tempS = (Statement)sSet.statements.get(ssPosition);
        if (!tempS.type.equals("SENFLD") || !tempS.getParameterTokenByName("NAME", 0, 0, true).equals(fldName)) {
            Object[] inserts = new Object[]{fldName, "should be Senseg name", "should be PSB name", "SenfldMeta.handleSenfld"};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("SENFLD_NOFND", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        senfld.setName(fldName);
        String start = tempS.getParameterTokenByName("START", 0, 0, false);
        if (start != null) {
            senfld.setStart(Integer.valueOf(start));
        } else {
            senfld.setStart(0);
        }
        String replace = tempS.getParameterTokenByName("REPLACE", 0, 0, false);
        if (replace == null) {
            replace = tempS.getParameterTokenByName("REPL", 0, 0, false);
        }
        if (replace != null) {
            if (replace.equals("YES") || replace.equals("Y")) {
                senfld.setReplace(YesnoType.Y);
            } else if (replace.equals("NO") || replace.equals("N")) {
                senfld.setReplace(YesnoType.N);
            }
        } else {
            senfld.setReplace(YesnoType.Y);
        }
        String remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false);
        if (remarks != null) {
            senfld.setRemarks(remarks);
        }
        senfldList.add(senfld);
    }

    private Statement locatePcbInStatementSet(StatementSet sSet, int ssPosition, String dbdName) throws ImporterException {
        if (sSet == null || ssPosition < 0 || ssPosition >= sSet.size || dbdName == null || dbdName.equals("")) {
            Object[] inserts = new Object[]{"DbPcbMeta.locatePcbInStatementSet", dbdName};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("PCB_INVLD_PARMS", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        Statement tempS = null;
        tempS = (Statement)sSet.statements.get(ssPosition);
        if (!tempS.type.equals("PCB")) {
            Object[] inserts = new Object[]{dbdName, "DbPcbMeta.locatePcbInStatementSet"};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("PCB_NOFND", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        String token = tempS.getParameterTokenByName("DBDNAME", 0, 0, false);
        if (token == null) {
            token = tempS.getParameterTokenByName("NAME", 0, 0, false);
        }
        if (token == null || !token.equals(dbdName)) {
            Object[] inserts = new Object[]{dbdName, "DbPcbMeta.locatePcbInStatementSet"};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("PCB_NOFND", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        return tempS;
    }

    private Statement locatePcbInStatementSet(StatementSet sSet, int ssPosition) throws ImporterException {
        if (sSet == null || ssPosition < 0 || ssPosition >= sSet.size) {
            Object[] inserts = new Object[]{"DbPcbMeta.locatePcbInStatementSet", ""};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("PCB_INVLD_PARMS", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        Statement tempS = null;
        tempS = (Statement)sSet.statements.get(ssPosition);
        if (!tempS.type.equals("PCB")) {
            Object[] inserts = new Object[]{"", "DbPcbMeta.locatePcbInStatementSet"};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("PCB_NOFND", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        return tempS;
    }

    private void handleTPPcb(StatementSet sSet, PsbModel psb, int ssPosition, int pcbSeqNumber) throws ImporterException {
        String list;
        String express;
        String modify;
        String sametrm;
        String altresp;
        PcbTPModel pcb = new PcbTPModel();
        psb.addTPPcb(pcb);
        Statement tempS = this.locatePcbInStatementSet(sSet, ssPosition);
        if (tempS.label != null && tempS.getParameterTokenByName("PCBNAME", 0, 0, false) != null) {
            Object[] inserts = new Object[]{"", psb.getPsbName()};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("TOO_MANY_PCBNAMES", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        if (tempS.label != null && !tempS.label.isEmpty()) {
            pcb.setLabel(tempS.label);
            pcb.setName(pcb.getLabel());
        } else if (tempS.getParameterTokenByName("PCBNAME", 0, 0, false) != null) {
            pcb.setPcbName(tempS.getParameterTokenByName("PCBNAME", 0, 0, false));
            pcb.setName(pcb.getPcbName());
        }
        String lterm = tempS.getParameterTokenByName("LTERM", 0, 0, false);
        if (lterm != null) {
            pcb.setLtermName(lterm);
        } else {
            lterm = tempS.getParameterTokenByName("NAME", 0, 0, false);
            if (lterm != null) {
                pcb.setTrancodeName(lterm);
            }
        }
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            pcb.setName(externalName);
        }
        if ((altresp = tempS.getParameterTokenByName("ALTRESP", 0, 0, false)) != null) {
            if (altresp.equalsIgnoreCase("YES")) {
                pcb.setAltresp(DBDConstants.Y);
            } else {
                pcb.setAltresp(DBDConstants.N);
            }
        }
        if ((sametrm = tempS.getParameterTokenByName("SAMETRM", 0, 0, false)) != null) {
            if (sametrm.equalsIgnoreCase("YES")) {
                pcb.setSametrm(DBDConstants.Y);
            } else {
                pcb.setSametrm(DBDConstants.N);
            }
        }
        if ((modify = tempS.getParameterTokenByName("MODIFY", 0, 0, false)) != null) {
            if (modify.equalsIgnoreCase("YES")) {
                pcb.setModify(DBDConstants.Y);
            } else {
                pcb.setModify(DBDConstants.N);
            }
        }
        if ((express = tempS.getParameterTokenByName("EXPRESS", 0, 0, false)) != null) {
            if (express.equalsIgnoreCase("YES")) {
                pcb.setExpress(DBDConstants.Y);
            } else {
                pcb.setExpress(DBDConstants.N);
            }
        }
        if ((list = tempS.getParameterTokenByName("LIST", 0, 0, false)) != null) {
            if (list.equalsIgnoreCase("YES")) {
                pcb.setList(DBDConstants.Y);
            } else {
                pcb.setList(DBDConstants.N);
            }
        } else {
            pcb.setList(DBDConstants.Y);
        }
        String remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false);
        if (remarks != null) {
            pcb.setRemarks(remarks);
        }
    }

    private void handleGsamPcb(StatementSet sSet, PsbModel psb, int ssPosition, String dbdName, int pcbSeqNumber) throws ImporterException {
        String remarks;
        String procopt;
        String list;
        PcbGsamModel pcb = new PcbGsamModel();
        pcb.setDbdName(dbdName);
        psb.addGSAMPcb(pcb);
        Statement tempS = this.locatePcbInStatementSet(sSet, ssPosition, dbdName);
        if (tempS.label != null && tempS.getParameterTokenByName("PCBNAME", 0, 0, false) != null) {
            Object[] inserts = new Object[]{dbdName, psb.getPsbName()};
            ImporterException e = new ImporterException(ModelErrorMessages.getModelBundle().getString("TOO_MANY_PCBNAMES", inserts), ImporterException.SEVERITY.WARNING);
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        if (tempS.label != null && !tempS.label.isEmpty()) {
            pcb.setLabel(tempS.label);
            pcb.setName(pcb.getLabel());
        } else if (tempS.getParameterTokenByName("PCBNAME", 0, 0, false) != null) {
            pcb.setPcbName(tempS.getParameterTokenByName("PCBNAME", 0, 0, false));
            pcb.setName(pcb.getPcbName());
        }
        String externalName = tempS.getParameterTokenByName("EXTERNALNAME", 0, 0, false);
        if (externalName != null) {
            pcb.setName(externalName);
        }
        if ((list = tempS.getParameterTokenByName("LIST", 0, 0, false)) != null) {
            if (list.equals("YES") || list.equals("Y")) {
                pcb.setList(DBDConstants.Y);
            } else if (list.equals("NO") || list.equals("N")) {
                pcb.setList(DBDConstants.N);
            }
        }
        if ((procopt = tempS.getParameterTokenByName("PROCOPT", 0, 0, false)) != null) {
            try {
                pcb.setProcopt(DBDConstants.fromValue(procopt));
            }
            catch (Throwable throwable) {
                String idStr = pcb.getLabel();
                if (idStr == null || idStr.isEmpty()) {
                    idStr = pcb.getPcbName();
                }
                if (idStr == null || idStr.isEmpty()) {
                    idStr = pcb.getDbdName();
                }
                Object[] inserts = new Object[]{"PROCOPT", "PCB", idStr};
                ImporterException ie = new ImporterException(WorkbenchModelBundle.getError().getString("IMPORT_WIZ_008", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)ie);
                throw ie;
            }
        }
        if ((remarks = tempS.getParameterTokenByName("REMARKS", 0, 0, false)) != null) {
            pcb.setRemarks(remarks);
        }
    }
}

