/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class FindRelatedPsbHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable<String, HashMap<String, PsbModel>> dbdToPsbList;
    private String projectName;

    public FindRelatedPsbHelper(String projectName) {
        this.projectName = projectName;
    }

    public List<String> findRelatedPsbNames(List<String> allProjectPsbList, List<String> newImportedDbds, IProgressMonitor monitor) throws CoreException, ModelException {
        ArrayList<String> resultPsbList = new ArrayList<String>();
        HashSet<String> resultPsbTable = new HashSet<String>();
        HashSet<String> dbdTable = new HashSet<String>();
        int i = 0;
        while (i < newImportedDbds.size()) {
            dbdTable.add(newImportedDbds.get(i));
            ++i;
        }
        PsbModel psbModel = null;
        int i2 = 0;
        while (i2 < allProjectPsbList.size()) {
            psbModel = ProjectTreeFileHelper.unmarshalPsb(allProjectPsbList.get(i2), this.projectName);
            String psbName = psbModel.getPsbName();
            List<PcbDBModel> pcbList = psbModel.getDBPcbList();
            if (pcbList != null) {
                int j = 0;
                while (j < pcbList.size()) {
                    PcbDBModel currPcb = pcbList.get(j);
                    String currDbdName = currPcb.getDbdName();
                    if (dbdTable.contains(currDbdName) && !resultPsbTable.contains(psbName)) {
                        resultPsbTable.add(psbName);
                    }
                    ++j;
                }
            }
            monitor.subTask("Calculating Database Views for:" + psbName);
            monitor.worked(1);
            ++i2;
        }
        Iterator iter = resultPsbTable.iterator();
        while (iter.hasNext()) {
            resultPsbList.add((String)iter.next());
        }
        psbModel = null;
        return resultPsbList;
    }

    public Collection<PsbModel> findRelatedPsbs(List<PsbModel> psbList, List<String> listDbd) throws CoreException, ModelException {
        HashMap<String, PsbModel> resultPsbList = new HashMap<String, PsbModel>();
        this.buildDbdToPsbTable(psbList);
        int i = 0;
        while (i < listDbd.size()) {
            String currDbdName = listDbd.get(i);
            HashMap<String, PsbModel> currPsbList = this.dbdToPsbList.get(currDbdName);
            if (currPsbList != null) {
                for (String currPsbName : currPsbList.keySet()) {
                    if (resultPsbList.containsKey(currPsbName)) continue;
                    resultPsbList.put(currPsbName, currPsbList.get(currPsbName));
                }
            }
            ++i;
        }
        return resultPsbList.values();
    }

    private void buildDbdToPsbTable(List<PsbModel> psbList) throws CoreException, ModelException {
        this.dbdToPsbList = new Hashtable();
        int i = 0;
        while (i < psbList.size()) {
            PsbModel psb = psbList.get(i);
            List<PcbDBModel> pcbList = psb.getDBPcbList();
            if (pcbList != null) {
                int j = 0;
                while (j < pcbList.size()) {
                    DbdModel tempDbd;
                    PcbDBModel currPcb = pcbList.get(j);
                    String currDbdName = currPcb.getDbdName();
                    boolean currDbdAlreadyProcessed = this.addEntryForDbd(psb, currDbdName);
                    if (!currDbdAlreadyProcessed && (tempDbd = ProjectTreeFileHelper.unmarshalDbd(currDbdName, this.projectName)) != null && tempDbd.getAccessType() == DBDConstants.LOGICAL) {
                        for (String dbName : tempDbd.getLogicalSourceDbds()) {
                            this.addEntryForDbd(psb, dbName);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private boolean addEntryForDbd(PsbModel psb, String currDbdName) {
        boolean retVal = false;
        if (!this.dbdToPsbList.containsKey(currDbdName)) {
            HashMap<String, PsbModel> newEntry = new HashMap<String, PsbModel>();
            newEntry.put(psb.getPsbName(), psb);
            this.dbdToPsbList.put(currDbdName, newEntry);
        } else {
            retVal = true;
            HashMap<String, PsbModel> currEntry = this.dbdToPsbList.get(currDbdName);
            if (!currEntry.containsKey(psb.getPsbName())) {
                currEntry.put(psb.getPsbName(), psb);
            }
        }
        return retVal;
    }
}

