/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.metadata.dbd.DependingOnFieldValueType;
import com.ibm.im.ims.metadata.dbd.HdamAndHidamDataSetType;
import com.ibm.im.ims.metadata.dbd.IndexType;
import com.ibm.im.ims.metadata.dbd.PhysicalDatatypeType;
import com.ibm.im.ims.metadata.dbd.ValueDatatypeType;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.model.AreaStmt;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DataExitRoutine;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.HidamDataSetModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DatabaseDDLGenerator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015-2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String currentDatasetLabel;
    private static ArrayList<String> usedDatasetLabels;
    private static boolean isDropCommand;
    private static boolean generateComments;
    private static String CR;
    private static String TAB;
    private static String END;
    private static final String QUOTE = "\"";
    private static Vector<FieldModel> fieldsWithRemarks;
    private static Vector<LogicalChildModel> lchildWithRemarks;
    private static Vector<MappingModel> mapsWithRemarks;
    private static Vector<Object[]> casesWithRemarks;
    private static Vector<Object[]> caseFieldsWithRemarks;

    static {
        isDropCommand = false;
        generateComments = true;
        CR = System.getProperty("line.separator");
        TAB = "    ";
        END = ";";
    }

    public static void setStatementFormat(boolean needFormat) {
        if (!needFormat) {
            CR = "";
            TAB = " ";
            END = System.getProperty("line.separator");
        }
    }

    public static String getStatementEnd() {
        return END;
    }

    public static synchronized String genDbdDdl(DbdModel dbdModel, boolean generateTable, boolean genDrop, boolean genComments) throws ModelException {
        Object genDbdSource = "";
        isDropCommand = genDrop;
        generateComments = genComments;
        if (dbdModel.getAccessType() != DBDConstants.MSDB) {
            String dbdStmt = DatabaseDDLGenerator.genDBDStmt(dbdModel);
            String datasetSegmStmts = "";
            String areaStmts = "";
            if (generateTable) {
                if (dbdModel.getAccessType() == DBDConstants.HSAM || dbdModel.getAccessType() == DBDConstants.SHSAM || dbdModel.getAccessType() == DBDConstants.GSAM || dbdModel.getAccessType() == DBDConstants.HISAM || dbdModel.getAccessType() == DBDConstants.SHISAM || dbdModel.getAccessType() == DBDConstants.INDEX || dbdModel.getAccessType() == DBDConstants.PSINDEX || dbdModel.getAccessType() == DBDConstants.PHDAM || dbdModel.getAccessType() == DBDConstants.PHIDAM || dbdModel.getAccessType() == DBDConstants.DEDB || dbdModel.getAccessType() == DBDConstants.LOGICAL) {
                    if (dbdModel.getAccessType() == DBDConstants.DEDB) {
                        areaStmts = DatabaseDDLGenerator.genAreaStmts(dbdModel);
                    }
                    datasetSegmStmts = DatabaseDDLGenerator.genDatasetSegmStmts(dbdModel);
                } else if (dbdModel.getAccessType() == DBDConstants.HDAM || dbdModel.getAccessType() == DBDConstants.HIDAM) {
                    datasetSegmStmts = DatabaseDDLGenerator.genHdamDatasetSegmStmts(dbdModel);
                }
            }
            genDbdSource = !isDropCommand ? (dbdModel.getAccessType() == DBDConstants.DEDB ? dbdStmt + areaStmts + datasetSegmStmts : (dbdModel.getAccessType() == DBDConstants.INDEX ? dbdStmt + datasetSegmStmts : dbdStmt + datasetSegmStmts)) : (dbdModel.getAccessType() == DBDConstants.DEDB ? datasetSegmStmts + areaStmts + dbdStmt : (dbdModel.getAccessType() == DBDConstants.INDEX ? datasetSegmStmts + dbdStmt : datasetSegmStmts + dbdStmt));
        }
        return genDbdSource;
    }

    private static String genAreaStmts(DbdModel dbdModel) {
        Object areaStmts = null;
        Iterator<AreaStmt> areaIter = dbdModel.getAreaList().iterator();
        if (areaIter.hasNext()) {
            areaStmts = "";
        }
        while (areaIter.hasNext()) {
            String areaStmt;
            AreaStmt newArea = areaIter.next();
            if (!isDropCommand) {
                String comments;
                areaStmt = "CREATE TABLESPACE " + newArea.getDd1() + " IN " + dbdModel.getDBDName() + CR + TAB;
                areaStmt = areaStmt + "SIZE PRIMARY " + newArea.getSize();
                areaStmt = areaStmt + " UOW(" + newArea.getUowNumber1() + "," + newArea.getUowOverflow1() + ")";
                areaStmt = areaStmt + " ROOT(" + newArea.getRootNumber2() + "," + newArea.getRootOverflow2() + ")";
                areaStmts = (String)areaStmts + DatabaseDDLGenerator.wrapStmt(areaStmt);
                if (newArea.getJaxbArea() == null || !generateComments || (comments = newArea.getJaxbArea().getRemarks()) == null || comments.isEmpty()) continue;
                areaStmts = (String)areaStmts + DatabaseDDLGenerator.wrapStmt("COMMENT ON TABLESPACE " + newArea.getDd1() + " IN " + dbdModel.getDBDName() + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper(comments));
                continue;
            }
            areaStmt = "DROP TABLESPACE " + newArea.getDd1() + " IN " + dbdModel.getDBDName() + CR + TAB;
            areaStmts = (String)areaStmts + DatabaseDDLGenerator.wrapStmt(areaStmt);
        }
        return areaStmts;
    }

    public static synchronized String genSegmDdl(DbdModel dbdModel, String segmentName, boolean isDrop) throws ModelException, IOException {
        isDropCommand = isDrop;
        String genSrcDbd = null;
        if (dbdModel.getAccessType() != DBDConstants.MSDB) {
            ArrayList<String> segmFieldLchildXdfldStmts = new ArrayList<String>();
            DatabaseDDLGenerator.genSegmStmts(dbdModel.getSegment(segmentName), segmFieldLchildXdfldStmts, false);
            genSrcDbd = DatabaseDDLGenerator.stringArrayToString(segmFieldLchildXdfldStmts);
        }
        return genSrcDbd;
    }

    private static String stringArrayToString(ArrayList<String> list) {
        Object string = "";
        for (String element : list) {
            string = (String)string + element;
        }
        return string;
    }

    private static String genDatasetSegmStmts(DbdModel dbdModel) throws ModelException {
        ArrayList<String> segmFieldLchildXdfldStmts = new ArrayList<String>();
        Object datasetSegmStmts = "";
        if (dbdModel.getAccessType() != DBDConstants.DEDB && dbdModel.getAccessType() != DBDConstants.PSINDEX && dbdModel.getAccessType() != DBDConstants.PHDAM && dbdModel.getAccessType() != DBDConstants.PHIDAM && dbdModel.getAccessType() != DBDConstants.LOGICAL) {
            String datasetStmt = DatabaseDDLGenerator.genDatasetStmt(dbdModel);
            datasetSegmStmts = datasetStmt;
        }
        if (dbdModel.getRootSegment() != null) {
            DatabaseDDLGenerator.genSegmStmts(dbdModel.getRootSegment(), segmFieldLchildXdfldStmts, true);
        }
        int i = 0;
        while (i < segmFieldLchildXdfldStmts.size()) {
            datasetSegmStmts = (String)datasetSegmStmts + segmFieldLchildXdfldStmts.get(i);
            ++i;
        }
        return datasetSegmStmts;
    }

    private static String genHdamDatasetSegmStmts(DbdModel dbdModel) throws ModelException {
        ArrayList<HidamDataSetModel> hdamDatasets = dbdModel.getHidamDataset();
        currentDatasetLabel = hdamDatasets.get(0).getLabel();
        if (currentDatasetLabel == null || currentDatasetLabel.indexOf("GENDS") == 0) {
            currentDatasetLabel = hdamDatasets.get(0).getDdname1();
        }
        ArrayList<String> segmFieldLchildXdfldStmts = new ArrayList<String>();
        usedDatasetLabels = new ArrayList();
        DatabaseDDLGenerator.genHdamSegmStmts(hdamDatasets, dbdModel.getRootSegment(), segmFieldLchildXdfldStmts);
        Object hdamDatasetSegmStmts = "";
        int i = 0;
        while (i < segmFieldLchildXdfldStmts.size()) {
            hdamDatasetSegmStmts = (String)hdamDatasetSegmStmts + segmFieldLchildXdfldStmts.get(i);
            ++i;
        }
        return hdamDatasetSegmStmts;
    }

    private static void genHdamDatasetStmt(ArrayList<HidamDataSetModel> hdamDatasets, SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        String dbdName = segmentModel.getDbdName();
        boolean found = false;
        String datasetLabel = segmentModel.getDatasetLabel();
        if (segmentModel.isRoot()) {
            segmFieldLchildXdfldStmts.add(DatabaseDDLGenerator.genHdamDatasetStmt(hdamDatasets.get(0), dbdName));
        } else if (!datasetLabel.equals(currentDatasetLabel)) {
            currentDatasetLabel = datasetLabel;
            int i = 0;
            while (i < hdamDatasets.size() && !found) {
                String actualLabel = hdamDatasets.get(i).getLabel();
                if (actualLabel == null) {
                    if (hdamDatasets.get(i).getGeneratedLabel().equals(datasetLabel)) {
                        found = true;
                        segmFieldLchildXdfldStmts.add(DatabaseDDLGenerator.genHdamDatasetStmt(hdamDatasets.get(i), dbdName));
                    }
                } else if (actualLabel.equals(datasetLabel)) {
                    found = true;
                    segmFieldLchildXdfldStmts.add(DatabaseDDLGenerator.genHdamDatasetStmt(hdamDatasets.get(i), dbdName));
                }
                ++i;
            }
        }
    }

    private static void genHdamSegmStmts(ArrayList<HidamDataSetModel> hdamDatasets, SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        String dbdName = segmentModel.getDbdName();
        if (!isDropCommand) {
            DatabaseDDLGenerator.genHdamDatasetStmt(hdamDatasets, segmentModel, segmFieldLchildXdfldStmts);
        }
        mapsWithRemarks = new Vector();
        casesWithRemarks = new Vector();
        fieldsWithRemarks = new Vector();
        lchildWithRemarks = new Vector();
        caseFieldsWithRemarks = new Vector();
        Object tableName = segmentModel.getName();
        if (tableName == null || ((String)tableName).isEmpty()) {
            tableName = segmentModel.getImsName();
        }
        if (Utility.isQuoteNeeded((String)tableName)) {
            tableName = QUOTE + (String)tableName + QUOTE;
        }
        if (!isDropCommand) {
            int numberOfChildren = segmentModel.getSegmentType().getFieldOrMappingOrLchild().size();
            Object segmStmt = "CREATE TABLE " + (String)tableName + (numberOfChildren > 0 | segmentModel.getParent() != null ? " (" : "");
            segmFieldLchildXdfldStmts.add((String)segmStmt);
            DatabaseDDLGenerator.genFieldStmts(segmentModel, segmFieldLchildXdfldStmts);
            DatabaseDDLGenerator.genLchildStmts(segmentModel, segmFieldLchildXdfldStmts);
            DatabaseDDLGenerator.genMaps(segmentModel, segmFieldLchildXdfldStmts);
            segmStmt = DatabaseDDLGenerator.addPARENT("", segmentModel, dbdAccessType);
            segmStmt = (String)segmStmt + (numberOfChildren > 0 | segmentModel.getParent() != null ? ") " : " ") + "IN " + dbdName + "." + DatabaseDDLGenerator.getCurrentDatasetName(segmentModel) + CR + TAB;
            Object internalName = segmentModel.getImsName();
            if (Utility.isQuoteNeeded((String)internalName)) {
                internalName = QUOTE + (String)internalName + QUOTE;
            }
            segmStmt = (String)segmStmt + "INTERNALNAME " + (String)internalName + CR + TAB;
            segmStmt = segmentModel.getMaxBytes() == -1 ? DatabaseDDLGenerator.addSOURCE((String)segmStmt, segmentModel, dbdAccessType) : DatabaseDDLGenerator.addBYTES((String)segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addLPARENT((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addFREQ((String)segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addPOINTER((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addRULES((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addSEGMEXIT((String)segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addCOMPRTN((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addSEGMEncoding((String)segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addSEGMRemarks((String)segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addMapRemarks((String)segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addFieldRemarks((String)segmStmt);
            segmStmt = DatabaseDDLGenerator.addLChildRemarks((String)segmStmt, segmentModel);
            segmFieldLchildXdfldStmts.add((String)segmStmt);
        } else {
            String segmStmt = DatabaseDDLGenerator.wrapStmt("DROP TABLE " + (String)tableName + " IN " + segmentModel.getDbdName());
            segmFieldLchildXdfldStmts.add(segmStmt);
            DatabaseDDLGenerator.genHdamDatasetStmt(hdamDatasets, segmentModel, segmFieldLchildXdfldStmts);
        }
        for (SegmentModel child : segmentModel.getChildSegments()) {
            DatabaseDDLGenerator.genHdamSegmStmts(hdamDatasets, child, segmFieldLchildXdfldStmts);
        }
    }

    private static String getCurrentDatasetName(SegmentModel segmentModel) {
        String retVal = currentDatasetLabel;
        ArrayList<HidamDataSetModel> hdamDatasets = segmentModel.getDbdModel().getHidamDataset();
        int i = 0;
        while (i < hdamDatasets.size()) {
            HidamDataSetModel currentModel = hdamDatasets.get(i);
            String label = currentModel.getLabel();
            if (label == null) {
                label = currentModel.getGeneratedLabel();
            }
            if (label.equals(currentDatasetLabel)) {
                retVal = currentModel.getDdname1();
                break;
            }
            ++i;
        }
        return retVal;
    }

    private static void genMaps(SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        Iterator<MappingModel> mappings = segmentModel.getMappingList();
        while (mappings.hasNext()) {
            MappingModel fieldMap = mappings.next();
            DatabaseDDLGenerator.genDFSMAPStmts(fieldMap, segmentModel, segmFieldLchildXdfldStmts);
            Iterator<MappingCaseModel> mappingCaseIter = fieldMap.getMappingCases();
            while (mappingCaseIter.hasNext()) {
                MappingCaseModel mappingCase = mappingCaseIter.next();
                DatabaseDDLGenerator.genDFSCASEStmts(fieldMap, mappingCase, segmentModel, segmFieldLchildXdfldStmts);
                DatabaseDDLGenerator.genCaseFieldStmts(fieldMap, mappingCase, segmentModel, segmFieldLchildXdfldStmts);
                if (mappingCaseIter.hasNext()) {
                    segmFieldLchildXdfldStmts.add(CR + TAB + TAB + ")," + CR + TAB + TAB);
                    continue;
                }
                segmFieldLchildXdfldStmts.add(CR + TAB + TAB + ")");
            }
            if (mappings.hasNext() || !segmentModel.isRoot()) {
                segmFieldLchildXdfldStmts.add(CR + TAB + ")," + CR + TAB);
                continue;
            }
            segmFieldLchildXdfldStmts.add(CR + TAB + ") ");
        }
    }

    private static void genSegmStmts(SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts, boolean includeChildren) throws ModelException {
        Object segmStmt;
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        mapsWithRemarks = new Vector();
        casesWithRemarks = new Vector();
        fieldsWithRemarks = new Vector();
        lchildWithRemarks = new Vector();
        caseFieldsWithRemarks = new Vector();
        Object tableName = segmentModel.getName();
        if (tableName == null || ((String)tableName).isEmpty()) {
            tableName = segmentModel.getImsName();
        }
        if (Utility.isQuoteNeeded((String)tableName)) {
            tableName = QUOTE + (String)tableName + QUOTE;
        }
        if (!isDropCommand) {
            segmStmt = "CREATE TABLE " + (String)tableName;
            int numberOfChildren = segmentModel.getSegmentType().getFieldOrMappingOrLchild().size();
            boolean needCloseParent = numberOfChildren > 0 | segmentModel.getParent() != null;
            if (dbdAccessType != DBDConstants.LOGICAL) {
                if (needCloseParent) {
                    segmStmt = (String)segmStmt + " (";
                }
                segmFieldLchildXdfldStmts.add((String)segmStmt);
                DatabaseDDLGenerator.genFieldStmts(segmentModel, segmFieldLchildXdfldStmts);
                if (dbdAccessType != DBDConstants.GSAM) {
                    DatabaseDDLGenerator.genLchildStmts(segmentModel, segmFieldLchildXdfldStmts);
                    DatabaseDDLGenerator.genMaps(segmentModel, segmFieldLchildXdfldStmts);
                }
            } else {
                if (segmentModel.getParent() != null) {
                    needCloseParent = true;
                    segmStmt = (String)segmStmt + " (" + CR + TAB;
                } else {
                    needCloseParent = false;
                }
                segmFieldLchildXdfldStmts.add((String)segmStmt);
            }
            segmStmt = DatabaseDDLGenerator.addPARENT((String)(needCloseParent ? "" : CR + TAB), segmentModel, dbdAccessType);
            segmStmt = (String)segmStmt + (needCloseParent ? ") " : "") + "IN DATABASE " + segmentModel.getDbdName() + CR + TAB;
            if (dbdAccessType != DBDConstants.GSAM) {
                Object internalName = segmentModel.getImsName();
                if (Utility.isQuoteNeeded((String)internalName)) {
                    internalName = QUOTE + (String)internalName + QUOTE;
                }
                segmStmt = (String)segmStmt + "INTERNALNAME " + (String)internalName + CR + TAB;
            }
            if (dbdAccessType != DBDConstants.GSAM) {
                segmStmt = DatabaseDDLGenerator.addSegmInfo((String)segmStmt, segmentModel, dbdAccessType);
            }
            segmStmt = DatabaseDDLGenerator.addSEGMEncoding((String)segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addSEGMRemarks((String)segmStmt, segmentModel);
            if (dbdAccessType != DBDConstants.GSAM) {
                segmStmt = DatabaseDDLGenerator.addMapRemarks((String)segmStmt, segmentModel);
            }
            segmStmt = DatabaseDDLGenerator.addFieldRemarks((String)segmStmt);
            if (dbdAccessType != DBDConstants.GSAM) {
                segmStmt = DatabaseDDLGenerator.addLChildRemarks((String)segmStmt, segmentModel);
            }
        } else {
            segmStmt = DatabaseDDLGenerator.wrapStmt("DROP TABLE " + (String)tableName + " IN " + segmentModel.getDbdName());
        }
        segmFieldLchildXdfldStmts.add((String)segmStmt);
        if (includeChildren) {
            for (SegmentModel child : segmentModel.getChildSegments()) {
                DatabaseDDLGenerator.genSegmStmts(child, segmFieldLchildXdfldStmts, true);
            }
        }
    }

    private static String addSegmInfo(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        if (dbdAccessType == DBDConstants.HSAM || dbdAccessType == DBDConstants.SHSAM) {
            segmStmt = DatabaseDDLGenerator.addBYTES(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addFREQ(segmStmt, segmentModel);
        } else if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM) {
            segmStmt = segmentModel.getMaxBytes() == -1 ? DatabaseDDLGenerator.addSOURCE(segmStmt, segmentModel, dbdAccessType) : DatabaseDDLGenerator.addBYTES(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addLPARENT(segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addFREQ(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addPOINTER(segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addRULES(segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addSEGMEXIT(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addCOMPRTN(segmStmt, segmentModel, dbdAccessType);
        } else if (dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
            segmStmt = DatabaseDDLGenerator.addLPARENT(segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addBYTES(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addFREQ(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addPOINTER(segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addRULES(segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addSEGMEXIT(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addDSGROUP(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addCOMPRTN(segmStmt, segmentModel, dbdAccessType);
        } else if (dbdAccessType == DBDConstants.DEDB) {
            segmStmt = DatabaseDDLGenerator.addBYTES(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addRULES(segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addTYPE(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addSSPTR(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addSEGMEXIT(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addCOMPRTN(segmStmt, segmentModel, dbdAccessType);
        } else if (dbdAccessType == DBDConstants.INDEX) {
            segmStmt = DatabaseDDLGenerator.addBYTES(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addFREQ(segmStmt, segmentModel);
        } else if (dbdAccessType == DBDConstants.PSINDEX) {
            segmStmt = DatabaseDDLGenerator.addBYTES(segmStmt, segmentModel);
            segmStmt = DatabaseDDLGenerator.addFREQ(segmStmt, segmentModel);
        } else if (dbdAccessType == DBDConstants.LOGICAL) {
            segmStmt = DatabaseDDLGenerator.addSOURCE(segmStmt, segmentModel, dbdAccessType);
            segmStmt = DatabaseDDLGenerator.addFREQ(segmStmt, segmentModel);
        }
        return segmStmt;
    }

    private static void genFieldStmts(SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        Vector<FieldModel> fieldList = segmentModel.getFieldList(true, false);
        Vector<FieldModel> sysRelFields = segmentModel.getSysRelFieldList();
        if (sysRelFields != null) {
            fieldList.addAll(sysRelFields);
        }
        Iterator<FieldModel> fieldIter = fieldList.iterator();
        while (fieldIter.hasNext()) {
            FieldModel fieldModel = fieldIter.next();
            DatabaseDDLGenerator.genOneFieldStmt(segmentModel, fieldModel, segmFieldLchildXdfldStmts);
            String fieldStmt = CR + TAB;
            if (fieldIter.hasNext() || !segmentModel.getLogicalChildList().isEmpty() || !segmentModel.isRoot()) {
                fieldStmt = "," + (String)(!fieldIter.hasNext() ? fieldStmt : "");
            }
            segmFieldLchildXdfldStmts.add(fieldStmt);
        }
    }

    private static void genOneFieldStmt(SegmentModel segmentModel, FieldModel fieldModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        if (!fieldModel.getName().isEmpty()) {
            Object fieldStmt = CR + TAB;
            if (dbdAccessType == DBDConstants.HSAM || dbdAccessType == DBDConstants.SHSAM || dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM || dbdAccessType == DBDConstants.DEDB || dbdAccessType == DBDConstants.INDEX || dbdAccessType == DBDConstants.PSINDEX || dbdAccessType == DBDConstants.GSAM) {
                String remarks;
                fieldStmt = DatabaseDDLGenerator.addFieldNAME((String)fieldStmt, fieldModel, "");
                fieldStmt = DatabaseDDLGenerator.addFieldDataTYPE((String)fieldStmt, fieldModel);
                fieldStmt = DatabaseDDLGenerator.addFieldBYTES((String)fieldStmt, fieldModel, segmentModel);
                fieldStmt = DatabaseDDLGenerator.addFieldSTART((String)fieldStmt, fieldModel, segmentModel, "");
                fieldStmt = DatabaseDDLGenerator.addMinMaxOccursDependsOn((String)fieldStmt, fieldModel, "");
                fieldStmt = DatabaseDDLGenerator.addFieldTYPE((String)fieldStmt, fieldModel, "");
                fieldStmt = DatabaseDDLGenerator.addFieldInternalNAME((String)fieldStmt, fieldModel, "");
                fieldStmt = DatabaseDDLGenerator.addFieldKEY((String)fieldStmt, fieldModel, "");
                fieldStmt = DatabaseDDLGenerator.addFieldParent((String)fieldStmt, fieldModel, "");
                fieldStmt = DatabaseDDLGenerator.addRedefines((String)fieldStmt, fieldModel, "");
                if (dbdAccessType != DBDConstants.LOGICAL && (remarks = fieldModel.getRemarks()) != null && !remarks.isEmpty()) {
                    fieldsWithRemarks.add(fieldModel);
                }
            }
            segmFieldLchildXdfldStmts.add((String)fieldStmt);
        }
        DatabaseDDLGenerator.genDFSMARSHStmts(fieldModel, segmFieldLchildXdfldStmts, "");
    }

    private static void genCaseFieldStmts(MappingModel mappingModel, MappingCaseModel mappingCase, SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        Object fieldStmt = null;
        String mapPadding = TAB + TAB;
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        Vector<FieldModel> caseFieldList = mappingCase.getFieldList(true);
        Iterator caseFieldIt = caseFieldList.iterator();
        while (caseFieldIt.hasNext()) {
            FieldModel fieldModel = (FieldModel)caseFieldIt.next();
            if (!fieldModel.getName().isEmpty()) {
                String remarks;
                fieldStmt = CR + TAB;
                if (dbdAccessType == DBDConstants.HSAM || dbdAccessType == DBDConstants.SHSAM || dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM || dbdAccessType == DBDConstants.DEDB || dbdAccessType == DBDConstants.INDEX || dbdAccessType == DBDConstants.PSINDEX) {
                    fieldStmt = DatabaseDDLGenerator.addFieldNAME((String)fieldStmt, fieldModel, mapPadding);
                    fieldStmt = DatabaseDDLGenerator.addFieldDataTYPE((String)fieldStmt, fieldModel);
                    fieldStmt = DatabaseDDLGenerator.addFieldBYTES((String)fieldStmt, fieldModel, segmentModel);
                    fieldStmt = DatabaseDDLGenerator.addFieldSTART((String)fieldStmt, fieldModel, segmentModel, mapPadding);
                    fieldStmt = DatabaseDDLGenerator.addMinMaxOccursDependsOn((String)fieldStmt, fieldModel, mapPadding);
                    fieldStmt = DatabaseDDLGenerator.addFieldTYPE((String)fieldStmt, fieldModel, mapPadding);
                    fieldStmt = DatabaseDDLGenerator.addFieldInternalNAME((String)fieldStmt, fieldModel, mapPadding);
                    fieldStmt = DatabaseDDLGenerator.addFieldKEY((String)fieldStmt, fieldModel, mapPadding);
                    fieldStmt = DatabaseDDLGenerator.addFieldParent((String)fieldStmt, fieldModel, mapPadding);
                    fieldStmt = DatabaseDDLGenerator.addRedefines((String)fieldStmt, fieldModel, mapPadding);
                }
                if (dbdAccessType != DBDConstants.LOGICAL && (remarks = fieldModel.getRemarks()) != null && !remarks.isEmpty()) {
                    caseFieldsWithRemarks.add(new Object[]{fieldModel, mappingModel, mappingCase, segmentModel});
                }
                segmFieldLchildXdfldStmts.add((String)fieldStmt);
            }
            DatabaseDDLGenerator.genDFSMARSHStmts(fieldModel, segmFieldLchildXdfldStmts, mapPadding);
            if (!caseFieldIt.hasNext()) continue;
            segmFieldLchildXdfldStmts.add(",");
        }
    }

    private static void genDFSCASEStmts(MappingModel currentMap, MappingCaseModel currentCase, SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) {
        String dfscaseStmt = null;
        String caseName = currentCase.getName();
        DependingOnFieldValueType dependingOnField = currentCase.getDependingOnFieldValue();
        Object caseId = dependingOnField.getValue();
        ValueDatatypeType caseIdType = dependingOnField.getValueDatatype();
        if (caseName != null) {
            String caseComments;
            caseId = "'" + (String)caseId + "'";
            if (caseIdType == ValueDatatypeType.X) {
                caseId = "X" + (String)caseId;
            }
            dfscaseStmt = "CASE " + (String)caseId + " AS " + caseName + "(";
            if (generateComments && (caseComments = currentCase.getRemarks()) != null && !caseComments.isEmpty()) {
                casesWithRemarks.add(new Object[]{currentMap.getName(), currentCase});
            }
            segmFieldLchildXdfldStmts.add(dfscaseStmt);
        }
    }

    private static void genDFSMAPStmts(MappingModel newMap, SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) {
        String dependingOnField;
        String dfsmapStmt = null;
        String newMapName = newMap.getName();
        if (newMapName != null & (dependingOnField = newMap.getDependingOnField()) != null) {
            String mapComments;
            dfsmapStmt = "MAP " + dependingOnField + " AS " + newMapName + "(" + CR + TAB + TAB;
            if (generateComments && (mapComments = newMap.getRemarks()) != null && !mapComments.isEmpty()) {
                mapsWithRemarks.add(newMap);
            }
            segmFieldLchildXdfldStmts.add(dfsmapStmt);
        }
    }

    private static void genDFSMARSHStmts(FieldModel fieldModel, ArrayList<String> segmFieldLchildXdfldStmts, String mapPadding) {
        PhysicalDatatypeType typeConverter = fieldModel.getTypeConverter();
        String userTypeConverter = fieldModel.getUserTypeConverter();
        String pattern = fieldModel.getPattern();
        if (pattern != null || typeConverter != null || userTypeConverter != null) {
            DBDConstants fieldDataType;
            String dfsmarshStmt = CR + TAB + TAB;
            int numProperties = fieldModel.getPropertyListSize();
            if (typeConverter != null) {
                dfsmarshStmt = dfsmarshStmt + mapPadding + "INTERNAL TYPECONVERTER " + String.valueOf((Object)typeConverter);
            } else if (userTypeConverter != null) {
                dfsmarshStmt = dfsmarshStmt + mapPadding + "USER TYPECONVERTER" + CR + TAB + TAB + TAB + mapPadding + "'" + userTypeConverter + "'";
                if (numProperties > 0) {
                    dfsmarshStmt = dfsmarshStmt + CR + TAB + TAB + TAB + mapPadding + "PROPERTIES (" + CR + TAB + TAB + TAB + TAB + mapPadding;
                    int i = 0;
                    while (i < numProperties) {
                        String name = fieldModel.getPropertyName(i);
                        String value = fieldModel.getPropertyValue(i);
                        String newStr = "'" + name + "'='" + value + "'";
                        dfsmarshStmt = i == numProperties - 1 ? dfsmarshStmt + newStr + CR + TAB + TAB + TAB + mapPadding : dfsmarshStmt + newStr + ", " + CR + TAB + TAB + TAB + TAB + mapPadding;
                        ++i;
                    }
                    dfsmarshStmt = dfsmarshStmt + ")";
                }
            }
            String fieldEncodingOverride = fieldModel.getEncoding();
            if (fieldEncodingOverride != null && !fieldEncodingOverride.isEmpty() && typeConverter == PhysicalDatatypeType.CHAR) {
                dfsmarshStmt = dfsmarshStmt + CR + TAB + TAB + mapPadding;
                dfsmarshStmt = dfsmarshStmt + "CCSID '" + fieldEncodingOverride + "'";
            }
            if ((fieldDataType = fieldModel.getAppDatatype()) == DBDConstants.DECIMAL && fieldModel.getIsSigned() != null) {
                dfsmarshStmt = dfsmarshStmt + CR + TAB + TAB + mapPadding;
                String isSigned = "YES";
                if (fieldModel.getIsSigned() == DBDConstants.N) {
                    isSigned = "NO";
                }
                dfsmarshStmt = dfsmarshStmt + "ISSIGNED" + isSigned;
            }
            if (pattern != null && !pattern.isEmpty()) {
                dfsmarshStmt = dfsmarshStmt + CR + TAB + TAB + mapPadding;
                char beginChar = pattern.charAt(0);
                char endChar = pattern.charAt(pattern.length() - 1);
                dfsmarshStmt = beginChar != '\'' ? dfsmarshStmt + "PATTERN '" + pattern : dfsmarshStmt + "PATTERN " + pattern;
                if (endChar != '\'') {
                    dfsmarshStmt = dfsmarshStmt + "'";
                }
            }
            if (fieldDataType == DBDConstants.CHAR && fieldModel.getIsDbcs() != null) {
                dfsmarshStmt = dfsmarshStmt + CR + TAB + TAB + mapPadding;
                String isPureDbcs = "NO";
                if (fieldModel.getIsDbcs() == DBDConstants.Y) {
                    isPureDbcs = "YES";
                }
                dfsmarshStmt = dfsmarshStmt + "PUREDBCS" + isPureDbcs;
            }
            segmFieldLchildXdfldStmts.add(dfsmarshStmt);
        }
    }

    private static void genLchildStmts(SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) {
        List<LogicalChildModel> lchildList;
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        if ((dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM || dbdAccessType == DBDConstants.INDEX || dbdAccessType == DBDConstants.DEDB || dbdAccessType == DBDConstants.PSINDEX) && (lchildList = segmentModel.getLogicalChildList()) != null) {
            Object lchildStmt = null;
            Iterator<LogicalChildModel> lchildIter = lchildList.iterator();
            while (lchildIter.hasNext()) {
                LogicalChildModel lchildModel = lchildIter.next();
                lchildStmt = "";
                if (dbdAccessType == DBDConstants.HISAM) {
                    lchildStmt = DatabaseDDLGenerator.addLchildNAME((String)lchildStmt, lchildModel);
                    lchildStmt = DatabaseDDLGenerator.addLchildPOINTER((String)lchildStmt, lchildModel, segmentModel);
                    lchildStmt = DatabaseDDLGenerator.addLchildPAIR((String)lchildStmt, lchildModel);
                    lchildStmt = DatabaseDDLGenerator.addLchildRULES((String)lchildStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM) {
                    lchildStmt = DatabaseDDLGenerator.addLchildNAME((String)lchildStmt, lchildModel);
                    lchildStmt = DatabaseDDLGenerator.addLchildPOINTER((String)lchildStmt, lchildModel, segmentModel);
                    lchildStmt = DatabaseDDLGenerator.addLchildPAIR((String)lchildStmt, lchildModel);
                    lchildStmt = DatabaseDDLGenerator.addLchildRULES((String)lchildStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.DEDB) {
                    lchildStmt = DatabaseDDLGenerator.addLchildNAME((String)lchildStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.INDEX) {
                    lchildStmt = DatabaseDDLGenerator.addLchildNAME((String)lchildStmt, lchildModel);
                    lchildStmt = lchildModel.getDedbSecondIxDbdNames() != null ? DatabaseDDLGenerator.addFPLchildNAME((String)lchildStmt, lchildModel) : DatabaseDDLGenerator.addLchildPOINTER((String)lchildStmt, lchildModel, segmentModel);
                    lchildStmt = DatabaseDDLGenerator.addLchildINDEX((String)lchildStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.PSINDEX) {
                    lchildStmt = DatabaseDDLGenerator.addLchildNAME((String)lchildStmt, lchildModel);
                    lchildStmt = DatabaseDDLGenerator.addLchildINDEX((String)lchildStmt, lchildModel);
                    lchildStmt = DatabaseDDLGenerator.addLchildRKSIZE((String)lchildStmt, lchildModel);
                }
                lchildStmt = DatabaseDDLGenerator.addLchildRemarks((String)lchildStmt, lchildModel);
                String xdfldName = lchildModel.getXdfldName();
                if (xdfldName == null || xdfldName.isEmpty()) {
                    xdfldName = lchildModel.getXdfldImsName();
                }
                if (segmentModel.getParent() != null || lchildIter.hasNext() || xdfldName != null || segmentModel.getMapList().size() > 0) {
                    lchildStmt = (String)lchildStmt + ",";
                }
                segmFieldLchildXdfldStmts.add((String)lchildStmt + CR + TAB);
                if (xdfldName == null) continue;
                Object xdfldStmt = "";
                if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM) {
                    xdfldStmt = DatabaseDDLGenerator.addXdfldNAME((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldSEGMENT((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldCONST((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldSRCH((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldSUBSEQ((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldDDATA((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldNULLVAL((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldEXTRTN((String)xdfldStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
                    xdfldStmt = DatabaseDDLGenerator.addXdfldNAME((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldSEGMENT((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldSRCH((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldSUBSEQ((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldDDATA((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldNULLVAL((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldEXTRTN((String)xdfldStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.DEDB) {
                    xdfldStmt = DatabaseDDLGenerator.addXdfldNAME((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldSEGMENT((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldSRCH((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldSUBSEQ((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldDDATA((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldNULLVAL((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldEXTRTN((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldPSELRTN((String)xdfldStmt, lchildModel);
                    xdfldStmt = DatabaseDDLGenerator.addXdfldPSELOPT((String)xdfldStmt, lchildModel);
                }
                if (((String)xdfldStmt).isEmpty()) continue;
                if (segmentModel.getParent() != null || lchildIter.hasNext() || segmentModel.getMapList().size() > 0) {
                    xdfldStmt = (String)xdfldStmt + ",";
                }
                segmFieldLchildXdfldStmts.add((String)xdfldStmt + CR + TAB);
            }
        }
    }

    private static String addXdfldPSELOPT(String xdfldStmt, LogicalChildModel lchildModel) {
        String pselopt = lchildModel.getPselopt();
        if (pselopt != null) {
            if (pselopt.equals(DBDConstants.M.value())) {
                xdfldStmt = (String)xdfldStmt + " PSELMULT";
            } else if (pselopt.equals(DBDConstants.S.value())) {
                xdfldStmt = (String)xdfldStmt + " PSELSNGL";
            }
        }
        return xdfldStmt;
    }

    private static String addXdfldPSELRTN(String xdfldStmt, LogicalChildModel lchildModel) {
        String pselrtn = lchildModel.getPselrtn();
        if (pselrtn != null) {
            xdfldStmt = (String)xdfldStmt + " PSELRTN " + pselrtn;
        }
        return xdfldStmt;
    }

    private static String addXdfldNULLVAL(String xdfldStmt, LogicalChildModel lchildModel) {
        String nullval = lchildModel.getXfldNullval();
        if (nullval != null) {
            if (nullval.indexOf("X'") == -1) {
                nullval = DatabaseDDLGenerator.convertToHex(nullval);
            }
            xdfldStmt = (String)xdfldStmt + " NULLVAL " + nullval;
        }
        return xdfldStmt;
    }

    private static String convertToHex(String nullval) {
        Object retVal = nullval;
        if (nullval.equals("BLANK")) {
            retVal = "X'40'";
        } else if (nullval.equals("ZERO")) {
            retVal = "X'00'";
        } else if (nullval.indexOf("B'") == 0) {
            retVal = "X'" + (String)((nullval = Integer.toHexString(Integer.parseInt(nullval.substring(2, nullval.length() - 1), 2)).toUpperCase()).length() < 2 ? "0" + nullval : nullval) + "'";
        } else if (nullval.indexOf("C'") == 0) {
            nullval = Utility.getEBCDICValue(nullval.substring(2, 3).charAt(0));
            retVal = "X'" + nullval + "'";
        } else if (nullval.length() == 1) {
            nullval = Utility.getEBCDICValue(nullval.charAt(0));
            retVal = "X'" + nullval + "'";
        } else {
            retVal = Utility.isStringNumeric(nullval) ? "X'" + (String)((nullval = Integer.toHexString(Integer.parseInt(nullval, 10)).toUpperCase()).length() < 2 ? "0" + nullval : nullval) + "'" : "X'" + nullval + "'";
        }
        return retVal;
    }

    private static String addXdfldEXTRTN(String xdfldStmt, LogicalChildModel lchildModel) {
        Object extrtn = lchildModel.getXfldIndexExitRoutine();
        if (extrtn != null) {
            if (Utility.isQuoteNeeded((String)extrtn)) {
                extrtn = QUOTE + (String)extrtn + QUOTE;
            }
            xdfldStmt = (String)xdfldStmt + " EXTRTN " + (String)extrtn;
        }
        return xdfldStmt;
    }

    public static String getXdfldSRCHString(LogicalChildModel lchildModel) {
        String retVal = DatabaseDDLGenerator.addXdfldSRCH("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addXdfldSRCH(String xdfldStmt, LogicalChildModel lchildModel) {
        List<String> srchList = lchildModel.getSearch();
        if (srchList != null) {
            xdfldStmt = (String)xdfldStmt + CR + TAB + TAB + "SRCH(";
            Iterator<String> srchIter = srchList.iterator();
            while (srchIter.hasNext()) {
                Object srch = srchIter.next();
                if (Utility.isQuoteNeeded((String)srch)) {
                    srch = QUOTE + (String)srch + QUOTE;
                }
                xdfldStmt = (String)xdfldStmt + (String)srch;
                if (!srchIter.hasNext()) continue;
                xdfldStmt = (String)xdfldStmt + ",";
            }
            xdfldStmt = (String)xdfldStmt + ")";
        }
        return xdfldStmt;
    }

    public static String getXdfldSUBSEQString(LogicalChildModel lchildModel) {
        String retVal = DatabaseDDLGenerator.addXdfldSUBSEQ("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addXdfldSUBSEQ(String xdfldStmt, LogicalChildModel lchildModel) {
        List<String> subseqList = lchildModel.getSubsequence();
        if (subseqList != null) {
            xdfldStmt = (String)xdfldStmt + CR + TAB + TAB + "SUBSEQ(";
            Iterator<String> subseqIter = subseqList.iterator();
            while (subseqIter.hasNext()) {
                Object subseq = subseqIter.next();
                if (Utility.isQuoteNeeded((String)subseq)) {
                    subseq = QUOTE + (String)subseq + QUOTE;
                }
                xdfldStmt = (String)xdfldStmt + (String)subseq;
                if (!subseqIter.hasNext()) continue;
                xdfldStmt = (String)xdfldStmt + ",";
            }
            xdfldStmt = (String)xdfldStmt + ")";
        }
        return xdfldStmt;
    }

    public static String getXdfldDDATAString(LogicalChildModel lchildModel) {
        String retVal = DatabaseDDLGenerator.addXdfldDDATA("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addXdfldDDATA(String xdfldStmt, LogicalChildModel lchildModel) {
        List<String> ddataList = lchildModel.getDuplicateData();
        if (ddataList != null) {
            xdfldStmt = (String)xdfldStmt + CR + TAB + TAB + "DDATA(";
            Iterator<String> ddataIter = ddataList.iterator();
            while (ddataIter.hasNext()) {
                Object ddata = ddataIter.next();
                if (Utility.isQuoteNeeded((String)ddata)) {
                    ddata = QUOTE + (String)ddata + QUOTE;
                }
                xdfldStmt = (String)xdfldStmt + (String)ddata;
                if (!ddataIter.hasNext()) continue;
                xdfldStmt = (String)xdfldStmt + ",";
            }
            xdfldStmt = (String)xdfldStmt + ")";
        }
        return xdfldStmt;
    }

    private static String addXdfldCONST(String xdfldStmt, LogicalChildModel lchildModel) {
        String xdfldconst = lchildModel.getXfldConst();
        if (xdfldconst != null) {
            if (xdfldconst.indexOf("X'") == -1) {
                xdfldconst = DatabaseDDLGenerator.convertToHex(xdfldconst);
            }
            xdfldStmt = (String)xdfldStmt + " CONST " + xdfldconst;
        }
        return xdfldStmt;
    }

    private static String addXdfldNAME(String xdfldStmt, LogicalChildModel lchildModel) {
        Object name = lchildModel.getXdfldName();
        String internalName = lchildModel.getXdfldImsName();
        if (name == null || ((String)name).isEmpty()) {
            name = internalName;
        }
        if (name != null) {
            if (Utility.isQuoteNeeded((String)name)) {
                name = QUOTE + (String)name + QUOTE;
            }
            xdfldStmt = (String)xdfldStmt + "XDFLD " + (String)name;
            if (internalName != null && !internalName.equals(name)) {
                xdfldStmt = (String)xdfldStmt + " INTERNALNAME " + internalName;
            }
        }
        return xdfldStmt;
    }

    private static String addXdfldSEGMENT(String xdfldStmt, LogicalChildModel lchildModel) {
        Object segment = lchildModel.getXfldSourceSegment();
        if (segment != null) {
            if (Utility.isQuoteNeeded((String)segment)) {
                segment = QUOTE + (String)segment + QUOTE;
            }
            xdfldStmt = (String)xdfldStmt + " SEGMENT " + (String)segment;
        }
        return xdfldStmt;
    }

    public static String getFPLchildNAME(LogicalChildModel lchildModel) {
        String retVal = DatabaseDDLGenerator.addFPLchildNAME("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(12);
    }

    private static String addFPLchildNAME(String lchildStmt, LogicalChildModel lchildModel) {
        Iterator<String> iter;
        List<String> indexDbnames = lchildModel.getDedbSecondIxDbdNames();
        if (indexDbnames != null && (iter = indexDbnames.iterator()).hasNext()) {
            Object spacing = CR + TAB + TAB;
            if (((String)lchildStmt).charAt(((String)lchildStmt).length() - 1) == ' ') {
                spacing = "";
            }
            lchildStmt = (String)lchildStmt + (String)spacing + "FPINDEX(";
            while (iter.hasNext()) {
                String dbname = iter.next();
                lchildStmt = (String)lchildStmt + dbname;
                if (!iter.hasNext()) continue;
                lchildStmt = (String)lchildStmt + ",";
            }
            lchildStmt = (String)lchildStmt + ")";
        }
        return lchildStmt;
    }

    private static String addLchildRemarks(String lchildStmt, LogicalChildModel lchildModel) {
        if (generateComments) {
            String comments = lchildModel.getLchildRemarks();
            if (comments != null && !comments.isEmpty()) {
                lchildWithRemarks.add(lchildModel);
            } else if (lchildModel.getXdfld() != null && (comments = lchildModel.getXdfldRemarks()) != null && !comments.isEmpty()) {
                lchildWithRemarks.add(lchildModel);
            }
        }
        return lchildStmt;
    }

    private static String addLchildRULES(String lchildStmt, LogicalChildModel lchildModel) {
        DBDConstants rules = lchildModel.getRules();
        if (rules != null) {
            String padding = CR + TAB + TAB;
            if (rules == DBDConstants.LAST) {
                lchildStmt = (String)lchildStmt + padding + "AMBIGUOUS INSERT LAST";
            } else if (rules == DBDConstants.FIRST) {
                lchildStmt = (String)lchildStmt + padding + "AMBIGUOUS INSERT FIRST";
            } else if (rules == DBDConstants.HERE) {
                lchildStmt = (String)lchildStmt + padding + "AMBIGUOUS INSERT HERE";
            }
        }
        return lchildStmt;
    }

    private static String addLchildPAIR(String lchildStmt, LogicalChildModel lchildModel) {
        String pair = lchildModel.getPair();
        if (pair != null) {
            lchildStmt = (String)lchildStmt + CR + TAB + TAB + "PAIR " + pair;
        }
        return lchildStmt;
    }

    private static String addLchildINDEX(String lchildStmt, LogicalChildModel lchildModel) {
        Object index = lchildModel.getIndex();
        if (index != null) {
            if (Utility.isQuoteNeeded((String)index)) {
                index = QUOTE + (String)index + QUOTE;
            }
            Object spacing = CR + TAB + TAB;
            if (((String)lchildStmt).charAt(((String)lchildStmt).length() - 1) == ' ') {
                spacing = "";
            }
            lchildStmt = (String)lchildStmt + (String)spacing + "INDEXFIELD " + (String)index;
        }
        return lchildStmt;
    }

    private static String addLchildRKSIZE(String lchildStmt, LogicalChildModel lchildModel) {
        Integer rksize = lchildModel.getRootKeySize();
        if (rksize != null) {
            Object spacing = CR + TAB + TAB;
            if (((String)lchildStmt).charAt(((String)lchildStmt).length() - 1) == ' ') {
                spacing = "";
            }
            lchildStmt = (String)lchildStmt + (String)spacing + "RKSIZE " + String.valueOf(rksize);
        }
        return lchildStmt;
    }

    private static String addLchildPOINTER(String lchildStmt, LogicalChildModel lchildModel, SegmentModel segmentModel) {
        DBDConstants pointer = lchildModel.getPointer();
        if (pointer != null) {
            String ptrString = pointer.name();
            if (pointer == DBDConstants.SNGL) {
                ptrString = "SINGLE";
            } else if (pointer == DBDConstants.DBLE) {
                ptrString = "DOUBLE";
            } else if (pointer == DBDConstants.INDX) {
                ptrString = "INDEX";
            } else if (pointer == DBDConstants.SYMB) {
                ptrString = "SYMBOL";
            }
            lchildStmt = (String)lchildStmt + ptrString;
        }
        return lchildStmt;
    }

    public static String getLchildNAME(LogicalChildModel lchildModel) {
        String retVal = DatabaseDDLGenerator.addLchildNAME("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(12);
    }

    private static String addLchildNAME(String lchildStmt, LogicalChildModel lchildModel) {
        String dbname;
        Object name = lchildModel.getName();
        if (Utility.isQuoteNeeded((String)name)) {
            name = QUOTE + (String)name + QUOTE;
        }
        lchildStmt = (dbname = lchildModel.getDbd()) == null ? (String)lchildStmt + "LCHILD " + (String)name : (String)lchildStmt + "LCHILD " + dbname + "." + (String)name;
        lchildStmt = (String)lchildStmt + CR + TAB + TAB;
        return lchildStmt;
    }

    private static String addFieldNAME(String fieldStmt, FieldModel fieldModel, String mapPadding) {
        Object externalName = fieldModel.getName();
        if (externalName == null || ((String)externalName).isEmpty()) {
            externalName = fieldModel.getImsName();
        }
        if (Utility.isQuoteNeeded((String)externalName)) {
            externalName = QUOTE + (String)externalName + QUOTE;
        }
        fieldStmt = (String)fieldStmt + mapPadding + (String)externalName;
        return fieldStmt;
    }

    private static String addFieldInternalNAME(String fieldStmt, FieldModel fieldModel, String mapPadding) {
        Object internalName;
        DBDConstants dataType = fieldModel.getPhysicalOrAppDataType();
        if ((fieldModel.isSysRelField() || !dataType.equals((Object)DBDConstants.ARRAY) && fieldModel.getParentField() == null && fieldModel.getBytes() <= 255 && fieldModel.getStartPos() > 0) && (internalName = fieldModel.getImsName()) != null && !((String)internalName).isEmpty()) {
            if (Utility.isQuoteNeeded((String)internalName)) {
                internalName = QUOTE + (String)internalName + QUOTE;
            }
            fieldStmt = (String)fieldStmt + CR + TAB + TAB + mapPadding + "INTERNALNAME " + (String)internalName;
        }
        return fieldStmt;
    }

    private static String addFieldKEY(String fieldStmt, FieldModel fieldModel, String mapPadding) {
        DBDConstants keyType = fieldModel.getSeqType();
        if (keyType != null) {
            fieldStmt = (String)fieldStmt + CR + TAB + TAB + mapPadding + "PRIMARY KEY";
            if (keyType == DBDConstants.M) {
                fieldStmt = (String)fieldStmt + " NON UNIQUE";
            }
        }
        return fieldStmt;
    }

    private static String addFieldRemarks(String segmStmt) {
        if (generateComments && fieldsWithRemarks != null) {
            for (FieldModel fieldModel : fieldsWithRemarks) {
                Object fieldName;
                Object comments = fieldModel.getRemarks();
                if (comments == null || ((String)comments).isEmpty()) continue;
                SegmentModel segmentModel = fieldModel.getSegmentModel();
                Object segmentName = segmentModel.getName();
                if (Utility.isQuoteNeeded((String)segmentName)) {
                    segmentName = QUOTE + (String)segmentName + QUOTE;
                }
                if (Utility.isQuoteNeeded((String)(fieldName = fieldModel.getName()))) {
                    fieldName = QUOTE + (String)fieldName + QUOTE;
                }
                comments = "COMMENT ON COLUMN " + (String)segmentName + "." + (String)fieldName + " IN " + segmentModel.getDbdName() + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper((String)comments) + ";";
                segmStmt = (String)segmStmt + DatabaseDDLGenerator.wrapStmt((String)comments);
            }
        }
        if (generateComments && caseFieldsWithRemarks != null) {
            for (Object[] currentField : caseFieldsWithRemarks) {
                Object fieldName;
                FieldModel fieldModel = (FieldModel)currentField[0];
                MappingModel mappingModel = (MappingModel)currentField[1];
                MappingCaseModel caseModel = (MappingCaseModel)currentField[2];
                SegmentModel segmentModel = (SegmentModel)currentField[3];
                String dbdName = segmentModel.getDbdName();
                Object segmentName = segmentModel.getName();
                String mapName = mappingModel.getName();
                String caseName = caseModel.getName();
                Object comments = fieldModel.getRemarks();
                if (comments == null || ((String)comments).isEmpty()) continue;
                if (Utility.isQuoteNeeded((String)segmentName)) {
                    segmentName = QUOTE + (String)segmentName + QUOTE;
                }
                if (Utility.isQuoteNeeded((String)(fieldName = fieldModel.getName()))) {
                    fieldName = QUOTE + (String)fieldName + QUOTE;
                }
                comments = "COMMENT ON COLUMN " + (String)segmentName + "." + mapName + "." + caseName + "." + (String)fieldName + " IN " + dbdName + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper((String)comments) + ";";
                segmStmt = (String)segmStmt + DatabaseDDLGenerator.wrapStmt((String)comments);
            }
        }
        return segmStmt;
    }

    private static String addLChildRemarks(String segmStmt, SegmentModel segmentModel) {
        if (generateComments && lchildWithRemarks != null) {
            for (LogicalChildModel lchildModel : lchildWithRemarks) {
                Object fieldName;
                Object lchildName;
                Object segmentName;
                Object comments = lchildModel.getLchildRemarks();
                if (comments != null && !((String)comments).isEmpty()) {
                    Object fieldName2;
                    segmentName = segmentModel.getName();
                    if (Utility.isQuoteNeeded((String)segmentName)) {
                        segmentName = QUOTE + (String)segmentName + QUOTE;
                    }
                    if (Utility.isQuoteNeeded((String)(fieldName2 = lchildModel.getName()))) {
                        fieldName2 = QUOTE + (String)fieldName2 + QUOTE;
                    }
                    comments = "COMMENT ON LCHILD " + (String)segmentName + "." + (String)fieldName2 + " IN " + segmentModel.getDbdName() + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper((String)comments) + ";";
                    segmStmt = (String)segmStmt + DatabaseDDLGenerator.wrapStmt((String)comments);
                }
                if (lchildModel.getXdfld() == null || (comments = lchildModel.getXdfldRemarks()) == null || ((String)comments).isEmpty()) continue;
                segmentName = segmentModel.getName();
                if (Utility.isQuoteNeeded((String)segmentName)) {
                    segmentName = QUOTE + (String)segmentName + QUOTE;
                }
                if (Utility.isQuoteNeeded((String)(lchildName = lchildModel.getName()))) {
                    lchildName = QUOTE + (String)lchildName + QUOTE;
                }
                if ((fieldName = lchildModel.getXdfldName()) == null || ((String)fieldName).isEmpty()) {
                    fieldName = lchildModel.getXdfldImsName();
                }
                if (Utility.isQuoteNeeded((String)fieldName)) {
                    fieldName = QUOTE + (String)fieldName + QUOTE;
                }
                comments = "COMMENT ON XDFLD " + (String)segmentName + "." + (String)lchildName + "." + (String)fieldName + " IN " + segmentModel.getDbdName() + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper((String)comments) + ";";
                segmStmt = (String)segmStmt + DatabaseDDLGenerator.wrapStmt((String)comments);
            }
        }
        return segmStmt;
    }

    private static String addMapRemarks(String segmStmt, SegmentModel segmentModel) {
        if (generateComments && mapsWithRemarks != null) {
            for (MappingModel mappingModel : mapsWithRemarks) {
                Object comments = mappingModel.getRemarks();
                if (comments != null && !((String)comments).isEmpty()) {
                    Object segmentName = segmentModel.getName();
                    Object mappingName = mappingModel.getName();
                    if (Utility.isQuoteNeeded((String)segmentName)) {
                        segmentName = QUOTE + (String)segmentName + QUOTE;
                    }
                    if (Utility.isQuoteNeeded((String)mappingName)) {
                        mappingName = QUOTE + (String)mappingName + QUOTE;
                    }
                    comments = "COMMENT ON MAP " + (String)segmentName + "." + (String)mappingName + " IN " + segmentModel.getDbdName() + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper((String)comments) + ";";
                    segmStmt = (String)segmStmt + DatabaseDDLGenerator.wrapStmt((String)comments);
                }
                segmStmt = DatabaseDDLGenerator.addCaseRemarks((String)segmStmt, segmentModel, mappingModel.getName());
            }
        }
        return segmStmt;
    }

    private static String addCaseRemarks(String segmStmt, SegmentModel segmentModel, String mappingName) {
        if (generateComments && casesWithRemarks != null) {
            for (Object[] currentObject : casesWithRemarks) {
                MappingCaseModel mappingCaseModel;
                Object comments;
                String currentMappingName = (String)currentObject[0];
                if (!((String)mappingName).equals(currentMappingName) || (comments = (mappingCaseModel = (MappingCaseModel)currentObject[1]).getRemarks()) == null || ((String)comments).isEmpty()) continue;
                Object segmentName = segmentModel.getName();
                Object mappingCaseName = mappingCaseModel.getName();
                if (Utility.isQuoteNeeded((String)segmentName)) {
                    segmentName = QUOTE + (String)segmentName + QUOTE;
                }
                if (Utility.isQuoteNeeded((String)mappingName)) {
                    mappingName = QUOTE + (String)mappingName + QUOTE;
                }
                if (Utility.isQuoteNeeded((String)mappingCaseName)) {
                    mappingCaseName = QUOTE + (String)mappingCaseName + QUOTE;
                }
                comments = "COMMENT ON CASE " + (String)segmentName + "." + (String)mappingName + "." + (String)mappingCaseName + " IN " + segmentModel.getDbdName() + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper((String)comments) + ";";
                segmStmt = (String)segmStmt + DatabaseDDLGenerator.wrapStmt((String)comments);
            }
        }
        return segmStmt;
    }

    private static String addRedefines(String fieldStmt, FieldModel fieldModel, String mapPadding) {
        Object redefinesName = fieldModel.getRedefines();
        if (redefinesName != null) {
            if (Utility.isQuoteNeeded((String)redefinesName)) {
                redefinesName = QUOTE + (String)redefinesName + QUOTE;
            }
            fieldStmt = (String)fieldStmt + CR + TAB + TAB + mapPadding + "REDEFINES " + (String)redefinesName;
        }
        return fieldStmt;
    }

    private static String addFieldParent(String fieldStmt, FieldModel fieldModel, String mapPadding) {
        FieldModel parentField = fieldModel.getParentField();
        if (parentField != null) {
            Object parentName = parentField.getName();
            if (Utility.isQuoteNeeded((String)parentName)) {
                parentName = QUOTE + (String)parentName + QUOTE;
            }
            fieldStmt = (String)fieldStmt + CR + TAB + TAB + mapPadding + "IN " + (String)parentName;
        }
        return fieldStmt;
    }

    private static String addMinMaxOccursDependsOn(String fieldStmt, FieldModel fieldModel, String mapPadding) {
        DBDConstants dataType = fieldModel.getAppDatatype();
        if (dataType == DBDConstants.ARRAY) {
            String dependsOnField;
            Integer maxOccurs;
            String padding = "";
            Integer minOccurs = fieldModel.getMinOccurs();
            if (minOccurs != null) {
                fieldStmt = (String)fieldStmt + CR + TAB + TAB + mapPadding;
                fieldStmt = (String)fieldStmt + "MINOCCURS " + minOccurs.toString();
                padding = " ";
            }
            if ((maxOccurs = fieldModel.getMaxOccurs()) != null) {
                if (padding.isEmpty()) {
                    fieldStmt = (String)fieldStmt + CR + TAB + TAB + mapPadding;
                }
                fieldStmt = (String)fieldStmt + padding + "MAXOCCURS " + maxOccurs.toString();
                padding = " ";
            }
            if ((dependsOnField = fieldModel.getDependsOn()) != null && !dependsOnField.isEmpty()) {
                fieldStmt = (String)fieldStmt + CR + TAB + TAB + TAB + mapPadding + "DEPENDSON " + dependsOnField;
            }
        }
        return fieldStmt;
    }

    private static String addFieldDataTYPE(String fieldStmt, FieldModel fieldModel) {
        DBDConstants dataType = fieldModel.getAppDatatype();
        if (dataType == null && fieldModel.isSysRelField()) {
            dataType = DBDConstants.CHAR;
        }
        if (dataType != null) {
            Object dataTypeStr = dataType.value();
            if (dataType == DBDConstants.DECIMAL) {
                Integer precision = fieldModel.getPrecision();
                Integer scale = fieldModel.getScale();
                if (precision != null && scale != null) {
                    dataTypeStr = (String)dataTypeStr + "(";
                    if (precision != null) {
                        dataTypeStr = (String)dataTypeStr + String.valueOf(precision);
                    }
                    dataTypeStr = (String)dataTypeStr + ",";
                    if (scale != null) {
                        dataTypeStr = (String)dataTypeStr + String.valueOf(scale);
                    }
                    dataTypeStr = (String)dataTypeStr + ") ";
                } else {
                    dataTypeStr = DBDConstants.BINARY.value();
                }
            }
            fieldStmt = (String)fieldStmt + " " + (String)dataTypeStr;
        }
        return fieldStmt;
    }

    private static String addFieldTYPE(String fieldStmt, FieldModel fieldModel, String mapPadding) {
        DBDConstants type = fieldModel.getImsDatatype();
        if (type != null) {
            fieldStmt = (String)fieldStmt + CR + TAB + TAB + mapPadding + "TYPE " + String.valueOf((Object)type);
        }
        return fieldStmt;
    }

    private static String addFieldSTART(String fieldStmt, FieldModel fieldModel, SegmentModel segmentModel, String mapPadding) {
        int startPos = fieldModel.getStartPos();
        String startAfterField = fieldModel.getStartAfter();
        int relativeStartPos = fieldModel.getRelativeStart();
        String padding = CR + TAB + TAB;
        if (startPos > 0) {
            fieldStmt = (String)fieldStmt + padding + mapPadding + "START " + Integer.toString(startPos);
        } else if (startAfterField != null && !startAfterField.isEmpty()) {
            fieldStmt = (String)fieldStmt + padding + mapPadding + "STARTAFTER " + startAfterField;
        } else if (relativeStartPos > 0) {
            fieldStmt = (String)fieldStmt + padding + mapPadding + "RELSTART " + Integer.toString(relativeStartPos);
        }
        return fieldStmt;
    }

    private static String addFieldBYTES(String fieldStmt, FieldModel fieldModel, SegmentModel segmentModel) {
        int bytes = fieldModel.getBytes();
        int maxBytes = fieldModel.getMaxBytes();
        char padding = ((String)fieldStmt).charAt(((String)fieldStmt).length() - 1);
        if (bytes > 0) {
            if (fieldModel.getAppDatatype() == DBDConstants.CHAR) {
                fieldStmt = (String)fieldStmt + "(" + Integer.toString(bytes) + ")";
            } else if (fieldModel.getAppDatatype() != DBDConstants.BIT && fieldModel.getAppDatatype() != DBDConstants.BYTE && fieldModel.getAppDatatype() != DBDConstants.UBYTE && fieldModel.getAppDatatype() != DBDConstants.SHORT && fieldModel.getAppDatatype() != DBDConstants.USHORT && fieldModel.getAppDatatype() != DBDConstants.INT && fieldModel.getAppDatatype() != DBDConstants.UINT && fieldModel.getAppDatatype() != DBDConstants.LONG && fieldModel.getAppDatatype() != DBDConstants.ULONG && fieldModel.getAppDatatype() != DBDConstants.FLOAT && fieldModel.getAppDatatype() != DBDConstants.DOUBLE) {
                fieldStmt = padding != ' ' && padding != '\t' ? (String)fieldStmt + " BYTES " + Integer.toString(bytes) : (String)fieldStmt + "BYTES " + Integer.toString(bytes);
            }
        } else if (maxBytes > 0) {
            fieldStmt = padding != ' ' && padding != '\t' ? (String)fieldStmt + " MAXBYTES " + Integer.toString(maxBytes) : (String)fieldStmt + "MAXBYTES " + Integer.toString(maxBytes);
        }
        return fieldStmt;
    }

    public static String getSSPTRString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addSSPTR("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addSSPTR(String segmStmt, SegmentModel segmentModel) {
        int ssptr = segmentModel.getSsptr();
        if (ssptr != -1) {
            char padding = ((String)segmStmt).charAt(((String)segmStmt).length() - 1);
            segmStmt = padding != ' ' && padding != '\t' ? (String)segmStmt + " SSPTR " + Integer.toString(ssptr) + CR + TAB : (String)segmStmt + "SSPTR " + Integer.toString(ssptr) + CR + TAB;
        }
        return segmStmt;
    }

    public static String getTYPEString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addTYPE("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addTYPE(String segmStmt, SegmentModel segmentModel) {
        String type;
        if (segmentModel.getParent() != null && (type = segmentModel.getDedbDependentSegmentType()) != null) {
            if (type.equals(DBDConstants.DIR.value())) {
                segmStmt = (String)segmStmt + "DIRECT DEPENDENT" + CR + TAB;
            } else if (type.equals(DBDConstants.SEQ.value())) {
                segmStmt = (String)segmStmt + "SEQUENTIAL DEPENDENT" + CR + TAB;
            }
        }
        return segmStmt;
    }

    public static String getDSGROUPString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addDSGROUP("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(9);
    }

    private static String addDSGROUP(String segmStmt, SegmentModel segmentModel) {
        String dsgroup = segmentModel.getDsgroup();
        if (dsgroup != null) {
            segmStmt = (String)segmStmt + "DSGROUP " + dsgroup + CR + TAB;
        }
        return segmStmt;
    }

    public static String getCOMPRTNString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addCOMPRTN("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(9);
    }

    private static String addCOMPRTN(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
            if (segmentModel.getComprtnRoutineName() != null) {
                String maxBytesNum;
                segmStmt = (String)segmStmt + "EDITPROC (" + segmentModel.getComprtnRoutineName() + " WITH ";
                String modify = segmentModel.getComprtnModify();
                segmStmt = modify != null ? (String)segmStmt + modify : (String)segmStmt + "DATA";
                DBDConstants init = segmentModel.getComprtnInit();
                if (init != null && init == DBDConstants.Y) {
                    segmStmt = (String)segmStmt + " INIT";
                }
                if ((maxBytesNum = segmentModel.getComprtnMaxBytesNumber()) != null && maxBytesNum != "-1") {
                    segmStmt = (String)segmStmt + " " + maxBytesNum;
                    DBDConstants pad = segmentModel.getComprtnMaxBytesPad();
                    if (pad != null && pad == DBDConstants.Y) {
                        segmStmt = (String)segmStmt + " PAD";
                    }
                }
                segmStmt = (String)segmStmt + ")" + CR + TAB;
            }
        } else if (dbdAccessType == DBDConstants.DEDB && segmentModel.getComprtnRoutineName() != null) {
            segmStmt = (String)segmStmt + "EDITPROC (" + segmentModel.getComprtnRoutineName();
            DBDConstants init = segmentModel.getDedbComprtnInit();
            DBDConstants data = segmentModel.getDedbComprtnData();
            if (init != null && data != null) {
                boolean withAdded = false;
                if (data == DBDConstants.Y) {
                    segmStmt = (String)segmStmt + " WITH DATA";
                    withAdded = true;
                }
                if (init == DBDConstants.Y) {
                    segmStmt = (String)segmStmt + (!withAdded ? " WITH " : " ") + "INIT";
                }
            } else if (init != null) {
                if (init == DBDConstants.Y) {
                    segmStmt = (String)segmStmt + "WITH INIT";
                }
            } else if (data != null && data == DBDConstants.Y) {
                segmStmt = (String)segmStmt + "WITH DATA";
            }
            segmStmt = (String)segmStmt + ")" + CR + TAB;
        }
        return segmStmt;
    }

    public static String getRULESString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addRULES("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addRULES(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
            String insertRule = segmentModel.getInsertionRule();
            String insertLocation = segmentModel.getInsertionLocation();
            if (insertRule != null || insertLocation != null) {
                String replaceRule;
                segmStmt = (String)segmStmt + "INSERT ";
                insertRule = insertRule != null ? (insertRule.startsWith("V") ? "VIRTUAL" : (insertRule.startsWith("L") ? "LOGICAL" : "PHYSICAL")) : "LOGICAL";
                segmStmt = (String)segmStmt + insertRule;
                String deleteRule = segmentModel.getDeletionRule();
                if (deleteRule != null) {
                    segmStmt = (String)segmStmt + " DELETE ";
                    deleteRule = deleteRule.startsWith("V") ? "VIRTUAL" : (deleteRule.startsWith("L") ? "LOGICAL" : (deleteRule.startsWith("B") ? "BIDIRECTIONAL" : "PHYSICAL"));
                    segmStmt = (String)segmStmt + deleteRule;
                }
                if ((replaceRule = segmentModel.getReplacementRule()) != null) {
                    segmStmt = (String)segmStmt + " REPLACE ";
                    replaceRule = replaceRule.startsWith("V") ? "VIRTUAL" : (replaceRule.startsWith("L") ? "LOGICAL" : "PHYSICAL");
                    segmStmt = (String)segmStmt + replaceRule;
                }
                segmStmt = (String)segmStmt + CR + TAB;
                segmStmt = insertLocation != null ? (String)segmStmt + "AMBIGUOUS INSERT " + insertLocation : (String)segmStmt + "AMBIGUOUS INSERT LAST";
                segmStmt = (String)segmStmt + CR + TAB;
            }
        } else if (dbdAccessType == DBDConstants.DEDB) {
            String insertLocation = segmentModel.getInsertionLocation();
            if (insertLocation != null) {
                segmStmt = (String)segmStmt + "AMBIGUOUS INSERT " + insertLocation + CR + TAB;
            } else {
                String dedbSegmentType = segmentModel.getDedbDependentSegmentType();
                if (dedbSegmentType == null || dedbSegmentType.equals("DIR")) {
                    segmStmt = (String)segmStmt + "AMBIGUOUS INSERT HERE" + CR + TAB;
                } else if (dedbSegmentType.equals("SEQ")) {
                    segmStmt = (String)segmStmt + "AMBIGUOUS INSERT FIRST" + CR + TAB;
                }
            }
        }
        return segmStmt;
    }

    public static String getPOINTERString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addPOINTER("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(9);
    }

    private static String addPOINTER(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        DBDConstants physPtr = segmentModel.getPhysicalPointer();
        DBDConstants logPtr = segmentModel.getLogicalPointer();
        DBDConstants LparntVal = segmentModel.getLparnt();
        DBDConstants CtrVal = segmentModel.getCtr();
        DBDConstants PairedVal = segmentModel.getPaired();
        boolean firstParm = true;
        if (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM) {
            if (physPtr != null || logPtr != null || LparntVal == DBDConstants.Y || CtrVal == DBDConstants.Y || PairedVal == DBDConstants.Y) {
                if (physPtr != null) {
                    segmStmt = (String)segmStmt + String.valueOf((Object)physPtr);
                    firstParm = false;
                }
                if (logPtr != null) {
                    if (firstParm) {
                        segmStmt = (String)segmStmt + String.valueOf((Object)logPtr);
                        firstParm = false;
                    } else {
                        segmStmt = (String)segmStmt + " " + String.valueOf((Object)logPtr);
                    }
                }
                if (LparntVal == DBDConstants.Y) {
                    if (firstParm) {
                        segmStmt = (String)segmStmt + "LPARNTYES";
                        firstParm = false;
                    } else {
                        segmStmt = (String)segmStmt + " LPARNTYES";
                    }
                }
                if (CtrVal == DBDConstants.Y) {
                    if (firstParm) {
                        segmStmt = (String)segmStmt + "CTRYES";
                        firstParm = false;
                    } else {
                        segmStmt = (String)segmStmt + " CTRYES";
                    }
                }
                if (PairedVal == DBDConstants.Y) {
                    if (firstParm) {
                        segmStmt = (String)segmStmt + "PAIREDYES";
                        firstParm = false;
                    } else {
                        segmStmt = (String)segmStmt + " PAIREDYES";
                    }
                }
                segmStmt = (String)segmStmt + CR + TAB;
            }
        } else if (!(dbdAccessType != DBDConstants.PHDAM && dbdAccessType != DBDConstants.PHIDAM || physPtr == null && LparntVal != DBDConstants.Y && PairedVal != DBDConstants.Y)) {
            if (physPtr != null) {
                segmStmt = (String)segmStmt + String.valueOf((Object)physPtr);
                firstParm = false;
            }
            if (LparntVal == DBDConstants.Y) {
                if (firstParm) {
                    segmStmt = (String)segmStmt + "LPARNTYES";
                    firstParm = false;
                } else {
                    segmStmt = (String)segmStmt + " LPARNTYES";
                }
            }
            if (PairedVal == DBDConstants.Y) {
                if (firstParm) {
                    segmStmt = (String)segmStmt + "PAIREDYES";
                    firstParm = false;
                } else {
                    segmStmt = (String)segmStmt + " PAIREDYES";
                    firstParm = false;
                }
            }
            segmStmt = (String)segmStmt + CR + TAB;
        }
        return segmStmt;
    }

    public static String getSOURCEString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addSOURCE("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addSOURCE(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        if (dbdAccessType == DBDConstants.LOGICAL) {
            if (segmentModel.getLogicalChildSourceSegName() == null) {
                Object sourceSegName = segmentModel.getSegmentSourceSegName();
                if (Utility.isQuoteNeeded((String)sourceSegName)) {
                    sourceSegName = QUOTE + (String)sourceSegName + QUOTE;
                }
                segmStmt = (String)segmStmt + "SOURCE(" + segmentModel.getSegmentSourceDBName() + "." + (String)sourceSegName;
                DBDConstants sourceChildData = segmentModel.getSegmentSourceData();
                if (sourceChildData != null) {
                    segmStmt = sourceChildData == DBDConstants.Y ? (String)segmStmt + " DATA" : (String)segmStmt + " KEY";
                }
                segmStmt = (String)segmStmt + ")" + CR + TAB;
            } else {
                Object targetParentSegName;
                Object sourceSegName = segmentModel.getLogicalChildSourceSegName();
                if (Utility.isQuoteNeeded((String)sourceSegName)) {
                    sourceSegName = QUOTE + (String)sourceSegName + QUOTE;
                }
                segmStmt = (String)segmStmt + "SOURCE(" + segmentModel.getLogicalChildSourceDBName() + "." + (String)sourceSegName;
                DBDConstants sourceChildData = segmentModel.getLogicalChildSourceData();
                if (sourceChildData != null) {
                    segmStmt = sourceChildData == DBDConstants.Y ? (String)segmStmt + " DATA" : (String)segmStmt + " KEY";
                }
                if ((targetParentSegName = segmentModel.getTargetParentSourceSegName()) != null) {
                    if (Utility.isQuoteNeeded((String)targetParentSegName)) {
                        targetParentSegName = QUOTE + (String)targetParentSegName + QUOTE;
                    }
                    segmStmt = (String)segmStmt + ", " + segmentModel.getTargetParentSourceDBName() + "." + (String)targetParentSegName;
                    DBDConstants targetParentData = segmentModel.getTargetParentSourceData();
                    if (targetParentData != null) {
                        segmStmt = targetParentData == DBDConstants.Y ? (String)segmStmt + " DATA" : (String)segmStmt + " KEY";
                    }
                }
                segmStmt = (String)segmStmt + ")" + CR + TAB;
            }
        } else {
            Object sourceSegName = segmentModel.getSegmentSourceSegName();
            if (Utility.isQuoteNeeded((String)sourceSegName)) {
                sourceSegName = QUOTE + (String)sourceSegName + QUOTE;
            }
            segmStmt = (String)segmStmt + "SOURCE(" + segmentModel.getSegmentSourceDBName() + "." + (String)sourceSegName;
            DBDConstants sourceChildData = segmentModel.getSegmentSourceData();
            if (sourceChildData != null) {
                segmStmt = sourceChildData == DBDConstants.Y ? (String)segmStmt + " DATA" : (String)segmStmt + " KEY";
            }
            segmStmt = (String)segmStmt + ")" + CR + TAB;
        }
        return segmStmt;
    }

    public static String getFREQString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addFREQ("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addFREQ(String segmStmt, SegmentModel segmentModel) {
        BigDecimal freq = segmentModel.getFreq();
        if (freq != null) {
            segmStmt = (String)segmStmt + "FREQ " + String.valueOf(freq) + CR + TAB;
        }
        return segmStmt;
    }

    private static String addBYTES(String segmStmt, SegmentModel segmentModel) {
        int maxBytes = segmentModel.getMaxBytes();
        int minBytes = segmentModel.getMinBytes();
        segmStmt = minBytes == -1 ? (String)segmStmt + "MAXBYTES " + maxBytes + CR + TAB : (String)segmStmt + "MAXBYTES " + maxBytes + " MINBYTES " + minBytes + CR + TAB;
        return segmStmt;
    }

    public static String getPARENTString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addPARENT("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addPARENT(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        SegmentModel parent;
        if ((dbdAccessType == DBDConstants.HSAM || dbdAccessType == DBDConstants.LOGICAL || dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM || dbdAccessType == DBDConstants.DEDB) && (parent = segmentModel.getParent()) != null) {
            String physicalChildPointer;
            Object parentName = parent.getName();
            if (Utility.isQuoteNeeded((String)parentName)) {
                parentName = QUOTE + (String)parentName + QUOTE;
            }
            if ((physicalChildPointer = segmentModel.getPhysicalChildPointer()) != null && (dbdAccessType == DBDConstants.DEDB || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM)) {
                parentName = physicalChildPointer.equals("DBLE") ? (String)parentName + " DOUBLE" : (String)parentName + " SINGLE";
            }
            segmStmt = (String)segmStmt + "FOREIGN KEY REFERENCES " + (String)parentName + CR + TAB;
        }
        return segmStmt;
    }

    private static String addLPARENT(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        Object logicalParentStr;
        if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM) {
            Object logicalParentStr2 = segmentModel.getLogicalParentName();
            if (logicalParentStr2 != null) {
                Object logicalParentDbdStr;
                String lpckStr;
                if (Utility.isQuoteNeeded((String)logicalParentStr2)) {
                    logicalParentStr2 = QUOTE + (String)logicalParentStr2 + QUOTE;
                }
                if ((lpckStr = segmentModel.getLogicalParentLpck()) == null) {
                    lpckStr = "VIRTUAL";
                }
                logicalParentDbdStr = (logicalParentDbdStr = segmentModel.getLogicalParentDbdName()) == null ? "" : (String)logicalParentDbdStr + ".";
                segmStmt = (String)segmStmt + "LPARENT " + (String)logicalParentDbdStr + (String)logicalParentStr2 + " " + lpckStr + CR + TAB;
            }
        } else if ((dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM) && (logicalParentStr = segmentModel.getLogicalParentName()) != null) {
            Object logicalParentDbdStr;
            String lpckStr;
            if (Utility.isQuoteNeeded((String)logicalParentStr)) {
                logicalParentStr = QUOTE + (String)logicalParentStr + QUOTE;
            }
            if ((lpckStr = segmentModel.getLogicalParentLpck()) == null) {
                if (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM) {
                    lpckStr = "VIRTUAL";
                } else if (dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
                    lpckStr = "PHYSICAL";
                }
            }
            logicalParentDbdStr = (logicalParentDbdStr = segmentModel.getLogicalParentDbdName()) == null ? "" : (String)logicalParentDbdStr + ".";
            segmStmt = (String)segmStmt + "LPARENT " + (String)logicalParentDbdStr + (String)logicalParentStr + " " + lpckStr + CR + TAB;
        }
        return segmStmt;
    }

    public static String getBLOCKString(DbdModel dbdModel) {
        String retVal = DatabaseDDLGenerator.addBLOCK("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addBLOCK(String datasetStmt, DbdModel dbdModel) {
        int blkfact1 = dbdModel.getBLOCKBlkfact1();
        if (blkfact1 > 0) {
            int blkfact2;
            datasetStmt = (String)datasetStmt + "BLOCK PRIMARY " + Integer.toString(blkfact1);
            if (dbdModel.getAccessType() != DBDConstants.GSAM && (blkfact2 = dbdModel.getBLOCKBlkfact2()) > 0) {
                datasetStmt = (String)datasetStmt + " BLOCK SECONDARY " + Integer.toString(blkfact2);
            }
            datasetStmt = (String)datasetStmt + CR + TAB;
        }
        return datasetStmt;
    }

    public static String getRECORDString(DbdModel dbdModel) {
        String retVal = DatabaseDDLGenerator.addRECORD("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addRECORD(String datasetStmt, DbdModel dbdModel) {
        Integer reclen1Int = dbdModel.getRECORDReclen1();
        if (reclen1Int != null && reclen1Int != 0) {
            String reclen1 = reclen1Int.toString();
            datasetStmt = (String)datasetStmt + "RECORD(" + reclen1;
            Integer reclen2Int = dbdModel.getRECORDReclen2();
            if (reclen2Int == 0) {
                reclen2Int = reclen1Int;
            }
            String reclen2 = reclen2Int.toString();
            datasetStmt = (String)datasetStmt + "," + reclen2;
            datasetStmt = (String)datasetStmt + ")" + CR + TAB;
        }
        return datasetStmt;
    }

    public static String getOVFLWString(DbdModel dbdModel) {
        String retVal = DatabaseDDLGenerator.addOVFLW("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addOVFLW(String datasetStmt, DbdModel dbdModel) {
        String ovflw = dbdModel.getOvflw();
        if (ovflw != null) {
            datasetStmt = (String)datasetStmt + "OVERFLOW(" + dbdModel.getOvflw() + ")" + CR + TAB;
        }
        return datasetStmt;
    }

    public static String getSizeString(DbdModel dbdModel) {
        String retVal = DatabaseDDLGenerator.addSIZE("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addRECFM(String datasetStmt, DbdModel dbdModel) {
        datasetStmt = (String)datasetStmt + "FORMAT ";
        String retVal = datasetStmt;
        DBDConstants format = dbdModel.getRecfm();
        retVal = format.equals((Object)DBDConstants.F) ? retVal + "FIXED" : (format.equals((Object)DBDConstants.FB) ? retVal + "FIXEDBLOCK" : (format.equals((Object)DBDConstants.V) ? retVal + "VARIABLE" : (format.equals((Object)DBDConstants.VB) ? retVal + "VARIABLEBLOCK" : retVal + "UNDEFINED")));
        return retVal;
    }

    private static String addSIZE(String datasetStmt, DbdModel dbdModel) {
        Integer size1Int;
        if (dbdModel.getAccessType() == DBDConstants.GSAM) {
            Integer size1Int2 = dbdModel.getSize1();
            if (size1Int2 != null && size1Int2 > 0) {
                String size1 = size1Int2.toString();
                datasetStmt = (String)datasetStmt + "SIZE PRIMARY " + size1 + CR + TAB;
            }
        } else if ((dbdModel.getAccessType() == DBDConstants.HISAM || dbdModel.getAccessType() == DBDConstants.SHISAM || dbdModel.getAccessType() == DBDConstants.INDEX) && (size1Int = dbdModel.getSize1()) != null && size1Int > 0) {
            String size1 = size1Int.toString();
            datasetStmt = (String)datasetStmt + "SIZE PRIMARY " + size1;
            Integer size2Int = dbdModel.getSize2();
            if (size2Int != null && size2Int > 0) {
                String size2 = size2Int.toString();
                datasetStmt = (String)datasetStmt + " SIZE SECONDARY " + size2;
            }
            datasetStmt = (String)datasetStmt + CR + TAB;
        }
        return datasetStmt;
    }

    private static String genHdamDatasetStmt(HidamDataSetModel hdamDataset, String dbdName) {
        Object datasetStmt = "";
        String label = hdamDataset.getLabel();
        if (label == null) {
            label = hdamDataset.getGeneratedLabel();
        }
        boolean labelUsedAlready = false;
        if (label != null) {
            int i = 0;
            while (i < usedDatasetLabels.size() && !labelUsedAlready) {
                if (label.equals(usedDatasetLabels.get(i))) {
                    labelUsedAlready = true;
                }
                ++i;
            }
        }
        if (!isDropCommand) {
            if (!labelUsedAlready) {
                Integer searcha;
                Integer fspf;
                Integer fbff;
                Integer cyls;
                if (label != null) {
                    usedDatasetLabels.add(label);
                }
                datasetStmt = "CREATE TABLESPACE " + hdamDataset.getDdname1() + " IN " + dbdName + CR + TAB;
                int blockSize0 = hdamDataset.getSize0();
                int sizeSize1 = hdamDataset.getSize1();
                if (blockSize0 > 0 && sizeSize1 <= 0) {
                    datasetStmt = (String)datasetStmt + "BLOCK PRIMARY " + Integer.toString(blockSize0) + CR + TAB;
                }
                if (sizeSize1 > 0 && blockSize0 <= 0) {
                    datasetStmt = (String)datasetStmt + "SIZE PRIMARY " + Integer.toString(sizeSize1) + CR + TAB;
                }
                if ((cyls = hdamDataset.getCyls()) != null && cyls >= 0) {
                    datasetStmt = (String)datasetStmt + "SCAN " + Integer.toString(cyls) + CR + TAB;
                }
                if ((fbff = hdamDataset.getFbff()) != null && fbff > 0) {
                    datasetStmt = (String)datasetStmt + "FREEBLOCK " + Integer.toString(fbff) + CR + TAB;
                }
                if ((fspf = hdamDataset.getFspf()) != null && fspf > 0) {
                    datasetStmt = (String)datasetStmt + "FREESPACE " + Integer.toString(fspf) + CR + TAB;
                }
                if ((searcha = hdamDataset.getSearcha()) != null && searcha > 0) {
                    datasetStmt = (String)datasetStmt + "SEARCHA " + Integer.toString(searcha) + CR + TAB;
                }
            }
            if (!((String)datasetStmt).isEmpty()) {
                String comments;
                datasetStmt = DatabaseDDLGenerator.wrapStmt((String)datasetStmt);
                HdamAndHidamDataSetType dataset = hdamDataset.getDataSet();
                if (dataset != null && (comments = dataset.getRemarks()) != null && !comments.isEmpty()) {
                    datasetStmt = (String)datasetStmt + DatabaseDDLGenerator.wrapStmt("COMMENT ON TABLESPACE " + hdamDataset.getDdname1() + " IN " + dbdName + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper(comments));
                }
            }
        } else {
            datasetStmt = DatabaseDDLGenerator.wrapStmt("DROP TABLESPACE " + hdamDataset.getDdname1() + " IN " + dbdName);
        }
        return datasetStmt;
    }

    private static String genDatasetStmt(DbdModel dbdModel) {
        Object datasetStmt = null;
        if (!isDropCommand) {
            datasetStmt = "CREATE TABLESPACE " + dbdModel.getDataSetDdname1() + " IN " + dbdModel.getDBDName();
            if (dbdModel.getAccessType() == DBDConstants.HSAM || dbdModel.getAccessType() == DBDConstants.SHSAM) {
                datasetStmt = (String)datasetStmt + CR + TAB + "OUTPUT(" + dbdModel.getDdname2() + ")" + CR + TAB;
                datasetStmt = DatabaseDDLGenerator.addRECORD((String)datasetStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.GSAM) {
                datasetStmt = dbdModel.getDdname2() != null ? (String)datasetStmt + CR + TAB + "OUTPUT(" + dbdModel.getDdname2() + ")" + CR + TAB : (String)datasetStmt + CR + TAB;
                datasetStmt = DatabaseDDLGenerator.addRECORD((String)datasetStmt, dbdModel);
                datasetStmt = DatabaseDDLGenerator.addBLOCK((String)datasetStmt, dbdModel);
                datasetStmt = DatabaseDDLGenerator.addSIZE((String)datasetStmt, dbdModel);
                datasetStmt = DatabaseDDLGenerator.addRECFM((String)datasetStmt, dbdModel) + CR + TAB;
            } else if (dbdModel.getAccessType() == DBDConstants.HISAM || dbdModel.getAccessType() == DBDConstants.SHISAM || dbdModel.getAccessType() == DBDConstants.INDEX) {
                datasetStmt = (String)datasetStmt + CR + TAB;
                datasetStmt = DatabaseDDLGenerator.addRECORD((String)datasetStmt, dbdModel);
                datasetStmt = DatabaseDDLGenerator.addBLOCK((String)datasetStmt, dbdModel);
                datasetStmt = DatabaseDDLGenerator.addSIZE((String)datasetStmt, dbdModel);
                if (dbdModel.getAccessType() != DBDConstants.SHISAM) {
                    datasetStmt = DatabaseDDLGenerator.addOVFLW((String)datasetStmt, dbdModel);
                }
            }
            if (!((String)datasetStmt).isEmpty()) {
                datasetStmt = DatabaseDDLGenerator.wrapStmt((String)datasetStmt);
                String comments = dbdModel.getDatasetRemarks();
                if (comments != null && !comments.isEmpty()) {
                    datasetStmt = (String)datasetStmt + DatabaseDDLGenerator.wrapStmt("COMMENT ON TABLESPACE " + dbdModel.getDataSetDdname1() + " IN " + dbdModel.getDBDName() + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper(comments));
                }
            }
        } else {
            datasetStmt = "DROP TABLESPACE ";
            datasetStmt = dbdModel.getAccessType() == DBDConstants.LOGICAL ? (String)datasetStmt + "LOGICAL" : (String)datasetStmt + dbdModel.getDataSetDdname1() + " IN " + dbdModel.getDBDName();
        }
        return datasetStmt;
    }

    public static String getACCESSString(DbdModel dbdModel) {
        Object accessType = dbdModel.getAccessType().value();
        if (dbdModel.getAccessType() == DBDConstants.GSAM || dbdModel.getAccessType() == DBDConstants.HDAM || dbdModel.getAccessType() == DBDConstants.PHDAM || dbdModel.getAccessType() == DBDConstants.HIDAM || dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            accessType = "(" + (String)accessType + "," + dbdModel.getOsAccess() + ")";
        } else if (dbdModel.getAccessType() == DBDConstants.INDEX || dbdModel.getAccessType() == DBDConstants.PSINDEX) {
            IndexType indexType = dbdModel.getDbd().getAccess().getIndex();
            accessType = indexType != null ? "(" + (String)accessType + "," + String.valueOf((Object)indexType.getOsAccess()) : "(" + (String)accessType + ",VSAM";
            accessType = DatabaseDDLGenerator.addPROT((String)accessType, dbdModel);
            if (dbdModel.getAccessType() == DBDConstants.INDEX) {
                accessType = DatabaseDDLGenerator.addDOSCOMP((String)accessType, dbdModel);
            }
            accessType = (String)accessType + ")";
        }
        return accessType;
    }

    private static String genDBDStmt(DbdModel dbdModel) {
        Object dbdStmt = null;
        if (!isDropCommand) {
            String osAccess = dbdModel.getOsAccess();
            dbdStmt = "CREATE DATABASE " + dbdModel.getDBDName();
            if (dbdModel.getAccessType() == DBDConstants.HSAM) {
                dbdStmt = (String)dbdStmt + " ACCESS HSAM" + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.SHSAM) {
                dbdStmt = (String)dbdStmt + " ACCESS SHSAM" + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.GSAM) {
                dbdStmt = (String)dbdStmt + " ACCESS  GSAM ";
                dbdStmt = (String)dbdStmt + osAccess + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                if (osAccess.equals(DBDConstants.VSAM.value())) {
                    dbdStmt = DatabaseDDLGenerator.addPASSWD((String)dbdStmt, dbdModel);
                }
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.HISAM) {
                dbdStmt = (String)dbdStmt + " ACCESS HISAM" + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addPASSWD((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addDBDEXIT((String)dbdStmt, dbdModel.getDataCaptureExitRoutines(), dbdModel.getAccessType());
            } else if (dbdModel.getAccessType() == DBDConstants.SHISAM) {
                dbdStmt = (String)dbdStmt + " ACCESS SHISAM" + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addPASSWD((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addDBDEXIT((String)dbdStmt, dbdModel.getDataCaptureExitRoutines(), dbdModel.getAccessType());
            } else if (dbdModel.getAccessType() == DBDConstants.HDAM) {
                dbdStmt = (String)dbdStmt + " ACCESS HDAM ";
                dbdStmt = (String)dbdStmt + osAccess + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addHdamRMNAME((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                if (osAccess.equals(DBDConstants.VSAM.value())) {
                    dbdStmt = DatabaseDDLGenerator.addPASSWD((String)dbdStmt, dbdModel);
                }
                dbdStmt = DatabaseDDLGenerator.addDBDEXIT((String)dbdStmt, dbdModel.getDataCaptureExitRoutines(), dbdModel.getAccessType());
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.PHDAM) {
                dbdStmt = (String)dbdStmt + " ACCESS PHDAM ";
                dbdStmt = (String)dbdStmt + osAccess + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addPSNAME((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addHdamRMNAME((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                if (osAccess.equals(DBDConstants.VSAM.value())) {
                    dbdStmt = DatabaseDDLGenerator.addPASSWD((String)dbdStmt, dbdModel);
                }
                dbdStmt = DatabaseDDLGenerator.addDBDEXIT((String)dbdStmt, dbdModel.getDataCaptureExitRoutines(), dbdModel.getAccessType());
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.HIDAM) {
                dbdStmt = (String)dbdStmt + " ACCESS HIDAM ";
                dbdStmt = (String)dbdStmt + osAccess + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                if (osAccess.equals(DBDConstants.VSAM.value())) {
                    dbdStmt = DatabaseDDLGenerator.addPASSWD((String)dbdStmt, dbdModel);
                }
                dbdStmt = DatabaseDDLGenerator.addDBDEXIT((String)dbdStmt, dbdModel.getDataCaptureExitRoutines(), dbdModel.getAccessType());
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.PHIDAM) {
                dbdStmt = (String)dbdStmt + " ACCESS PHIDAM ";
                dbdStmt = (String)dbdStmt + osAccess + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addPSNAME((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                if (osAccess.equals(DBDConstants.VSAM.value())) {
                    dbdStmt = DatabaseDDLGenerator.addPASSWD((String)dbdStmt, dbdModel);
                }
                dbdStmt = DatabaseDDLGenerator.addDBDEXIT((String)dbdStmt, dbdModel.getDataCaptureExitRoutines(), dbdModel.getAccessType());
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.DEDB) {
                dbdStmt = (String)dbdStmt + " ACCESS DEDB" + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addDedbRMNAME((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addDBDEXIT((String)dbdStmt, dbdModel.getDataCaptureExitRoutines(), dbdModel.getAccessType());
            } else if (dbdModel.getAccessType() == DBDConstants.INDEX) {
                dbdStmt = (String)dbdStmt + " ACCESS INDEX ";
                dbdStmt = (String)dbdStmt + osAccess + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addSecondaryIxDBDNames((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addFPINDEX((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addPROT((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addDOSCOMP((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                if (osAccess.equals(DBDConstants.VSAM.value())) {
                    dbdStmt = DatabaseDDLGenerator.addPASSWD((String)dbdStmt, dbdModel);
                }
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.PSINDEX) {
                dbdStmt = (String)dbdStmt + " ACCESS PSINDEX" + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addPROT((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addPASSWD((String)dbdStmt, dbdModel);
                dbdStmt = DatabaseDDLGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            } else if (dbdModel.getAccessType() == DBDConstants.LOGICAL) {
                dbdStmt = (String)dbdStmt + " ACCESS LOGICAL" + CR + TAB;
                dbdStmt = DatabaseDDLGenerator.addVERSION((String)dbdStmt, dbdModel);
            }
            dbdStmt = DatabaseDDLGenerator.addDBDEncoding((String)dbdStmt, dbdModel);
            dbdStmt = DatabaseDDLGenerator.addDBDRemarks((String)dbdStmt, dbdModel);
        } else {
            dbdStmt = DatabaseDDLGenerator.wrapStmt("DROP DATABASE " + dbdModel.getDBDName());
        }
        return dbdStmt;
    }

    private static String addDBDRemarks(String dbdStmt, DbdModel dbdModel) {
        Object comments = dbdModel.getRemarks();
        if (comments != null && !((String)comments).isEmpty()) {
            comments = "COMMENT ON DATABASE " + dbdModel.getDBDName() + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper((String)comments);
            dbdStmt = (String)dbdStmt + DatabaseDDLGenerator.wrapStmt((String)comments);
        }
        return dbdStmt;
    }

    private static String addDBDEncoding(String dbdStmt, DbdModel dbdModel) {
        String dbdEncoding = dbdModel.getEncoding();
        dbdStmt = dbdEncoding != null && !dbdEncoding.isEmpty() ? (String)dbdStmt + "CCSID '" + dbdEncoding + "'" : (String)dbdStmt + "CCSID 'Cp1047'";
        return DatabaseDDLGenerator.wrapStmt((String)dbdStmt);
    }

    private static String addSEGMRemarks(String segmStmt, SegmentModel segmentModel) {
        Object comments;
        if (generateComments && (comments = segmentModel.getRemarks()) != null && !((String)comments).isEmpty()) {
            Object segmentName = segmentModel.getName();
            if (Utility.isQuoteNeeded((String)segmentName)) {
                segmentName = QUOTE + (String)segmentName + QUOTE;
            }
            comments = "COMMENT ON TABLE " + (String)segmentName + " IN " + segmentModel.getDbdName() + " IS " + CR + TAB + DatabaseDDLGenerator.remarksHelper((String)comments);
            segmStmt = (String)segmStmt + DatabaseDDLGenerator.wrapStmt((String)comments);
        }
        return segmStmt;
    }

    private static String addSEGMEncoding(String segmStmt, SegmentModel segmModel) {
        String segmEncoding = segmModel.getEncoding();
        if (segmEncoding != null && !segmEncoding.isEmpty()) {
            segmStmt = (String)segmStmt + "CCSID '" + segmEncoding + "'";
        }
        return DatabaseDDLGenerator.wrapStmt((String)segmStmt);
    }

    private static String addFPINDEX(String dbdStmt, DbdModel dbdModel) {
        YesnoType fpIndex = dbdModel.getFPindex();
        if (fpIndex != null) {
            dbdStmt = fpIndex.equals((Object)YesnoType.Y) ? (String)dbdStmt + "FPINDEXYES" + CR + TAB : (String)dbdStmt + "FPINDEXNO" + CR + TAB;
        }
        return dbdStmt;
    }

    private static String addPASSWD(String dbdStmt, DbdModel dbdModel) {
        String passWd = dbdModel.isPassword();
        YesnoType passYN = YesnoType.valueOf(passWd);
        if (passWd != null) {
            if (passYN.equals((Object)YesnoType.Y)) {
                dbdStmt = (String)dbdStmt + "PASSWDYES" + CR + TAB;
            } else if (passYN.equals((Object)YesnoType.N)) {
                dbdStmt = (String)dbdStmt + "PASSWDNO" + CR + TAB;
            }
        }
        return dbdStmt;
    }

    public static String getDBDEXITString(DbdModel dbdModel) {
        String retVal = DatabaseDDLGenerator.addDBDEXIT("", dbdModel.getDataCaptureExitRoutines(), dbdModel.getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(13);
    }

    public static String getSEGMEXITString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addDBDEXIT("", segmentModel.getDataCaptureExitRoutines(), segmentModel.getDBDAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(13);
    }

    private static String addDBDEXIT(String dbdStmt, List<DataExitRoutine> extiRoutineList, DBDConstants accessType) {
        if (extiRoutineList != null && extiRoutineList.size() != 0) {
            dbdStmt = (String)dbdStmt + "DATA CAPTURE CHANGES (" + CR + TAB + TAB;
            Iterator<DataExitRoutine> iter = extiRoutineList.iterator();
            while (iter.hasNext()) {
                DBDConstants ynInpos;
                DataExitRoutine exitRoutine = iter.next();
                Object exitName = exitRoutine.getExitName();
                if (Utility.isStringNumeric((String)exitName)) {
                    exitName = QUOTE + (String)exitName + QUOTE;
                }
                dbdStmt = (String)dbdStmt + (String)(exitName != null && !((String)exitName).equals("*") ? exitName : "");
                if (exitRoutine.getLog() != null) {
                    dbdStmt = (String)dbdStmt + " " + (exitRoutine.getLog() == DBDConstants.Y ? "LOG" : "NOLOG");
                }
                if (exitRoutine.getExitKey() != null) {
                    dbdStmt = (String)dbdStmt + " " + (exitRoutine.getExitKey() == DBDConstants.Y ? "KEY" : "NOKEY");
                }
                if (exitRoutine.getExitPath() != null) {
                    dbdStmt = (String)dbdStmt + " " + (exitRoutine.getExitPath() == DBDConstants.Y ? "PATH" : "NOPATH");
                }
                if (exitRoutine.getExitData() != null) {
                    dbdStmt = (String)dbdStmt + " " + (exitRoutine.getExitData() == DBDConstants.Y ? "DATA" : "NODATA");
                }
                if (accessType == DBDConstants.DEDB) {
                    DBDConstants ynSspcmd;
                    Object tempString = "";
                    if (exitRoutine.getBefore() != null) {
                        tempString = (String)tempString + " " + (exitRoutine.getBefore() == DBDConstants.Y ? "BEFORE" : "NOBEFORE");
                    }
                    if (exitRoutine.getDlet() != null) {
                        tempString = (String)tempString + " " + (exitRoutine.getDlet() == DBDConstants.Y ? "DLET" : "NODLET");
                    }
                    if ((ynSspcmd = exitRoutine.getSspcmd()) == DBDConstants.Y) {
                        tempString = (String)tempString + " SSPCMD";
                    } else if (ynSspcmd == DBDConstants.N) {
                        tempString = (String)tempString + " NOSSPCMD";
                    }
                    DBDConstants ynFld = exitRoutine.getFld();
                    if (ynFld == DBDConstants.Y) {
                        tempString = (String)tempString + " FLD";
                    } else if (ynFld == DBDConstants.N) {
                        tempString = (String)tempString + " NOFLD";
                    }
                    if (!((String)tempString).isEmpty()) {
                        dbdStmt = (String)dbdStmt + CR + TAB + TAB + (String)tempString;
                    }
                }
                if ((ynInpos = exitRoutine.getInpos()) == DBDConstants.Y) {
                    dbdStmt = (String)dbdStmt + " INPOS";
                } else if (ynInpos == DBDConstants.N) {
                    dbdStmt = (String)dbdStmt + " NOINPOS";
                }
                if (exitRoutine.getDoCascade() == DBDConstants.Y) {
                    dbdStmt = (String)dbdStmt + CR + TAB + TAB;
                    DBDConstants cKey = exitRoutine.getCascadeKey();
                    DBDConstants cPath = exitRoutine.getCascadePath();
                    DBDConstants cData = exitRoutine.getCascadeData();
                    dbdStmt = (String)dbdStmt + " " + (cKey == DBDConstants.N ? "CNOKEY" : "CKEY");
                    dbdStmt = (String)dbdStmt + " " + (cPath == DBDConstants.Y ? "CPATH" : "CNOPATH");
                    dbdStmt = (String)dbdStmt + " " + (cData == DBDConstants.N ? "CNODATA" : "CDATA");
                } else if (exitRoutine.getDoCascade() == DBDConstants.N) {
                    dbdStmt = (String)dbdStmt + " NOCASCADE";
                }
                if (!iter.hasNext()) continue;
                dbdStmt = (String)dbdStmt + ", ";
            }
            dbdStmt = (String)dbdStmt + ") ";
        } else {
            dbdStmt = (String)dbdStmt + "DATA CAPTURE NONE ";
        }
        return dbdStmt;
    }

    public static String getEXITString(SegmentModel segmentModel) {
        String retVal = DatabaseDDLGenerator.addSEGMEXIT("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addSEGMEXIT(String segmStmt, SegmentModel segmentModel) {
        if (segmentModel.isDataCaptureExitNone()) {
            segmStmt = (String)segmStmt + "DATA CAPTURE NONE" + CR + TAB;
        } else {
            List<DataExitRoutine> extiRoutineList = segmentModel.getDataCaptureExitRoutines();
            if (extiRoutineList != null && extiRoutineList.size() != 0) {
                segmStmt = (String)segmStmt + "DATA CAPTURE CHANGES (" + CR + TAB + TAB;
                Iterator<DataExitRoutine> iter = extiRoutineList.iterator();
                while (iter.hasNext()) {
                    DBDConstants ynInpos;
                    DataExitRoutine exitRoutine = iter.next();
                    String exitName = exitRoutine.getExitName();
                    segmStmt = (String)segmStmt + (exitName != null && !exitName.equals("*") ? exitName : "");
                    if (exitRoutine.getLog() != null) {
                        segmStmt = (String)segmStmt + " " + (exitRoutine.getLog() == DBDConstants.Y ? "LOG" : "NOLOG");
                    }
                    if (exitRoutine.getExitKey() != null) {
                        segmStmt = (String)segmStmt + " " + (exitRoutine.getExitKey() == DBDConstants.Y ? "KEY" : "NOKEY");
                    }
                    if (exitRoutine.getExitPath() != null) {
                        segmStmt = (String)segmStmt + " " + (exitRoutine.getExitPath() == DBDConstants.Y ? "PATH" : "NOPATH");
                    }
                    if (exitRoutine.getExitData() != null) {
                        segmStmt = (String)segmStmt + " " + (exitRoutine.getExitData() == DBDConstants.Y ? "DATA" : "NODATA");
                    }
                    if (segmentModel.getDBDAccessType() == DBDConstants.DEDB) {
                        DBDConstants ynSspcmd;
                        Object tempString = "";
                        if (exitRoutine.getBefore() != null) {
                            tempString = (String)tempString + " " + (exitRoutine.getBefore() == DBDConstants.Y ? "BEFORE" : "NOBEFORE");
                        }
                        if (exitRoutine.getDlet() != null) {
                            tempString = (String)tempString + " " + (exitRoutine.getDlet() == DBDConstants.Y ? "DLET" : "NODLET");
                        }
                        if ((ynSspcmd = exitRoutine.getSspcmd()) == DBDConstants.Y) {
                            tempString = (String)tempString + " SSPCMD";
                        } else if (ynSspcmd == DBDConstants.N) {
                            tempString = (String)tempString + " NOSSPCMD";
                        }
                        DBDConstants ynFld = exitRoutine.getFld();
                        if (ynFld == DBDConstants.Y) {
                            tempString = (String)tempString + " FLD";
                        } else if (ynFld == DBDConstants.N) {
                            tempString = (String)tempString + " NOFLD";
                        }
                        if (!((String)tempString).isEmpty()) {
                            segmStmt = (String)segmStmt + CR + TAB + TAB + (String)tempString;
                        }
                    }
                    if ((ynInpos = exitRoutine.getInpos()) == DBDConstants.Y) {
                        segmStmt = (String)segmStmt + " INPOS";
                    } else if (ynInpos == DBDConstants.N) {
                        segmStmt = (String)segmStmt + " NOINPOS";
                    }
                    if (exitRoutine.getDoCascade() == DBDConstants.Y) {
                        segmStmt = (String)segmStmt + CR + TAB + TAB;
                        DBDConstants cKey = exitRoutine.getCascadeKey();
                        DBDConstants cPath = exitRoutine.getCascadePath();
                        DBDConstants cData = exitRoutine.getCascadeData();
                        segmStmt = (String)segmStmt + " " + (cKey == DBDConstants.N ? "CNOKEY" : "CKEY");
                        segmStmt = (String)segmStmt + " " + (cPath == DBDConstants.Y ? "CPATH" : "CNOPATH");
                        segmStmt = (String)segmStmt + " " + (cData == DBDConstants.N ? "CNODATA" : "CDATA");
                    } else if (exitRoutine.getDoCascade() == DBDConstants.N) {
                        segmStmt = (String)segmStmt + " NOCASCADE";
                    }
                    if (!iter.hasNext()) continue;
                    segmStmt = (String)segmStmt + ", ";
                }
                segmStmt = (String)segmStmt + ")" + CR + TAB;
            }
        }
        return segmStmt;
    }

    private static String addVERSION(String dbdStmt, DbdModel dbdModel) {
        String version = dbdModel.getVersion();
        if (version != null) {
            dbdStmt = (String)dbdStmt + "VERSION '" + version + "'" + CR + TAB;
        }
        return dbdStmt;
    }

    private static String addDATXEXIT(String dbdStmt, DbdModel dbdModel) {
        String datxexit = dbdModel.isDatxexit();
        if (datxexit != null) {
            if (datxexit.equals("N")) {
                dbdStmt = (String)dbdStmt + "DATXEXITNO" + CR + TAB;
            } else if (datxexit.equals("Y")) {
                dbdStmt = (String)dbdStmt + "DATXEXITYES" + CR + TAB;
            }
        }
        return dbdStmt;
    }

    public static String getHdamRMNAMEString(DbdModel dbdModel) {
        String retVal = DatabaseDDLGenerator.addHdamRMNAME("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addHdamRMNAME(String dbdStmt, DbdModel dbdModel) {
        String mod = dbdModel.getRMName();
        if (mod != null) {
            dbdStmt = (String)dbdStmt + "RMNAME(" + mod;
            Integer anchorPoints = dbdModel.getRmNameAnchorPoints();
            Integer rbn = dbdModel.getRmNameMaxRBN();
            Integer bytes = dbdModel.getRmNameBytes();
            if (anchorPoints != null && anchorPoints > 0 || rbn != null && rbn > 0 || bytes != null && bytes > 0) {
                if (anchorPoints != null && anchorPoints > 0) {
                    dbdStmt = (String)dbdStmt + " RMANCH " + anchorPoints.toString();
                }
                if (rbn != null && rbn > 0) {
                    dbdStmt = (String)dbdStmt + " RMRBN " + rbn.toString();
                }
                if (bytes != null && bytes > 0) {
                    dbdStmt = (String)dbdStmt + " RMBYTES " + bytes.toString();
                }
            }
            dbdStmt = (String)dbdStmt + ")" + CR + TAB;
        }
        return dbdStmt;
    }

    public static String getDedbRMNAMEString(DbdModel dbdModel) {
        String retVal = DatabaseDDLGenerator.addDedbRMNAME("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addDedbRMNAME(String dbdStmt, DbdModel dbdModel) {
        String mod = dbdModel.getRMName();
        if (mod != null) {
            dbdStmt = (String)dbdStmt + "RMNAME(" + mod;
            Integer anchorPoints = dbdModel.getRmNameAnchorPoints();
            String XCI = dbdModel.getXCI();
            if (anchorPoints != null && anchorPoints > 0 || XCI != null) {
                if (anchorPoints != null && anchorPoints > 0) {
                    dbdStmt = (String)dbdStmt + " RMANCH " + anchorPoints.toString();
                    if (XCI != null && XCI.equals(YesnoType.Y.value())) {
                        dbdStmt = (String)dbdStmt + " XCIYES";
                    } else if (XCI != null && XCI.equals(YesnoType.N.value())) {
                        dbdStmt = (String)dbdStmt + " XCINO";
                    }
                } else if (XCI != null && XCI.equals(YesnoType.Y.value())) {
                    dbdStmt = (String)dbdStmt + " XCIYES";
                } else if (XCI != null && XCI.equals(YesnoType.N.value())) {
                    dbdStmt = (String)dbdStmt + " XCINO";
                }
            }
            dbdStmt = (String)dbdStmt + ")" + CR + TAB;
        }
        return dbdStmt;
    }

    private static String addPSNAME(String dbdStmt, DbdModel dbdModel) {
        String psname = dbdModel.getPsname();
        if (psname != null) {
            dbdStmt = (String)dbdStmt + "PSNAME " + psname + CR + TAB;
        }
        return dbdStmt;
    }

    private static String addSecondaryIxDBDNames(String dbdStmt, DbdModel dbdModel) {
        List<String> dbnames = dbdModel.getSecondaryIxDBDNames();
        if (dbnames != null) {
            dbdStmt = (String)dbdStmt + "SHAREDINDEXDBS(";
            Iterator<String> iter = dbnames.iterator();
            while (iter.hasNext()) {
                String dbname = iter.next();
                dbdStmt = (String)dbdStmt + dbname;
                if (!iter.hasNext()) continue;
                dbdStmt = (String)dbdStmt + ", ";
            }
            dbdStmt = (String)dbdStmt + ")" + CR + TAB;
        }
        return dbdStmt;
    }

    private static String addPROT(String dbdStmt, DbdModel dbdModel) {
        DBDConstants prot = dbdModel.isProt();
        if (prot != null) {
            if (prot == DBDConstants.Y) {
                dbdStmt = (String)dbdStmt + "PROTYES" + CR + TAB;
            } else if (prot == DBDConstants.N) {
                dbdStmt = (String)dbdStmt + "PROTNO" + CR + TAB;
            }
        }
        return dbdStmt;
    }

    private static String addDOSCOMP(String dbdStmt, DbdModel dbdModel) {
        DBDConstants doscomp = dbdModel.isDoscomp();
        if (doscomp != null) {
            if (doscomp == DBDConstants.Y) {
                dbdStmt = (String)dbdStmt + "DOSCOMPYES" + CR + TAB;
            } else if (doscomp == DBDConstants.N) {
                dbdStmt = (String)dbdStmt + "DOSCOMPNO" + CR + TAB;
            }
        }
        return dbdStmt;
    }

    protected static String wrapStmt(String stmt) {
        Object wrappedStmt = stmt;
        if (!stmt.isEmpty()) {
            if (stmt.substring(stmt.length() - 1).equals(CR)) {
                wrappedStmt = stmt.substring(0, stmt.length() - CR.length());
            } else if (stmt.substring(stmt.length() - TAB.length()).equals(TAB)) {
                wrappedStmt = stmt.substring(0, stmt.length() - TAB.length() - CR.length());
            }
            if (((String)wrappedStmt).length() > 0 && ((String)wrappedStmt).charAt(((String)wrappedStmt).length() - 1) != ';') {
                wrappedStmt = (String)wrappedStmt + END;
            }
            wrappedStmt = (String)wrappedStmt + CR + CR;
        }
        return wrappedStmt;
    }

    public static String remarksHelper(String comments) {
        int commentsLen = comments.length();
        StringBuffer cbuf = new StringBuffer(commentsLen + 10);
        cbuf.append(comments);
        int i = 0;
        while (i < commentsLen) {
            char currentChar = cbuf.charAt(i);
            if (currentChar == '\'') {
                cbuf.insert(i + 1, '\'');
                ++commentsLen;
                ++i;
            }
            ++i;
        }
        cbuf.insert(0, '\'');
        cbuf.insert(commentsLen + 1, '\'');
        return cbuf.toString();
    }
}

