/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.FieldModelImpl;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.DatabaseViewGeneratorException;
import com.ibm.im.ims.workbench.model.utilities.LineSetWriter;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class DLIDatabaseViewGenerator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private PsbModel currentPsb = null;
    private HashMap<String, DbdModel> dbdList = new HashMap();
    private String pcbName = null;
    ArrayList<FieldModel> uniqueFields = null;
    Hashtable<String, String> htFields = null;
    LineSetWriter lw = null;
    DbdModel dbdModel = null;
    String projectName = null;
    StringBuffer bufPCBMethods = null;
    StringBuffer bufTypeInfoMethods = null;
    StringBuffer bufConstructor = null;
    private Vector<DatabaseViewGeneratorException> dbViewExceptions = null;

    public DLIDatabaseViewGenerator(String projectName) {
        this.projectName = projectName;
    }

    public String generateDBViewClass(PsbModel aPsb) throws DatabaseViewGeneratorException, ModelException, CoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "generateDBViewClass", new Object[0]);
        }
        this.currentPsb = aPsb;
        this.bufConstructor = new StringBuffer();
        this.bufPCBMethods = new StringBuffer();
        this.bufTypeInfoMethods = new StringBuffer();
        String psbName = aPsb.getPsbName();
        psbName = DLIDatabaseViewGenerator.ensureValidJavaName(psbName);
        List<PcbDBModel> dbpcbList = aPsb.getDBPcbList();
        if (dbpcbList != null) {
            int i = 0;
            while (i < dbpcbList.size()) {
                String pcbName;
                PcbDBModel currPcb = dbpcbList.get(i);
                String label = currPcb.getLabel();
                if (label != null && !label.isEmpty()) {
                    currPcb.setOrigLabel(label);
                    currPcb.setLabel(DLIDatabaseViewGenerator.ensureValidJavaName(label));
                }
                if ((pcbName = currPcb.getPcbName()) != null && !pcbName.isEmpty()) {
                    currPcb.setOrigPcbName(pcbName);
                    currPcb.setPcbName(DLIDatabaseViewGenerator.ensureValidJavaName(pcbName));
                }
                ++i;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PSBName: " + psbName);
        }
        String className = psbName + "DatabaseView";
        this.lw = new LineSetWriter();
        this.bufConstructor.append("package ").append(psbName.toLowerCase()).append(";");
        this.bufConstructor.append("\n");
        this.bufConstructor.append("\nimport com.ibm.ims.db.*;\n");
        this.bufConstructor.append("import com.ibm.ims.base.*;\n");
        this.bufConstructor.append("\npublic class ").append(className).append(" extends DLIDatabaseView {\n");
        this.bufConstructor.append("    // This class describes the data view of PSB: ").append(psbName);
        BoolHolder boolHolder = new BoolHolder();
        boolean hasDbPcbs = false;
        boolean hasGsamPcbs = false;
        List<PcbDBModel> dbPcbList = aPsb.getDBPcbList();
        if (dbPcbList == null) {
            logger.finest("PSBName: " + psbName + " does not have DB PCBs.");
        } else {
            hasDbPcbs = true;
            this.printDBPcbList(dbPcbList, psbName);
        }
        List<PcbGsamModel> gsamPcbList = aPsb.getGsamPcbList();
        if (gsamPcbList == null) {
            logger.finest("PSBName: " + psbName + " does not have GSAM PCBs.");
        } else {
            hasGsamPcbs = true;
            this.printGsamPcbList(gsamPcbList);
        }
        if (!hasGsamPcbs && !hasDbPcbs) {
            Object[] inserts = new Object[]{new String(Character.toChars(8482))};
            throw new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1663", inserts), psbName);
        }
        this.bufConstructor.append("    \n    // Constructor \n ");
        this.bufConstructor.append("    public " + className + "() {\n");
        this.bufConstructor.append("        super(\"2.0.4\",\"");
        this.bufConstructor.append(aPsb.getPsbName());
        this.bufConstructor.append("\");\n");
        if (dbPcbList != null) {
            this.processDbPcbList(dbPcbList, boolHolder);
        }
        if (gsamPcbList != null) {
            this.processGsamPcbList(gsamPcbList, boolHolder);
        }
        if (hasGsamPcbs && hasDbPcbs && !boolHolder.atLeastOneDbPcbHasName && !boolHolder.atLeastOneGsamPcbHasName || !hasGsamPcbs && hasDbPcbs && !boolHolder.atLeastOneDbPcbHasName || hasGsamPcbs && !hasDbPcbs && !boolHolder.atLeastOneGsamPcbHasName) {
            Object[] inserts = new Object[]{new String(Character.toChars(8482))};
            throw new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1658", inserts), psbName);
        }
        if (hasGsamPcbs && hasDbPcbs && !boolHolder.atLeastOneDbdIsInProject && !boolHolder.atLeastOneGsamDbdIsInProject || !hasGsamPcbs && hasDbPcbs && !boolHolder.atLeastOneDbdIsInProject || hasGsamPcbs && !hasDbPcbs && !boolHolder.atLeastOneGsamDbdIsInProject) {
            Object[] inserts = new Object[]{new String(Character.toChars(8482)), psbName};
            throw new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1659", inserts), psbName);
        }
        this.bufConstructor.append("      }\n");
        this.lw.storeLine(this.bufConstructor);
        this.bufConstructor.delete(0, this.bufConstructor.length());
        this.lw.storeLine(this.bufConstructor);
        this.lw.storeLine(this.bufPCBMethods);
        this.lw.storeLine(this.bufTypeInfoMethods);
        this.bufTypeInfoMethods.append("\n");
        this.lw.storeLine(this.bufTypeInfoMethods);
        this.lw.storeLine("} // end " + className + " class definition");
        dbpcbList = aPsb.getDBPcbList();
        if (dbpcbList != null) {
            int i = 0;
            while (i < dbpcbList.size()) {
                String origPcbName;
                PcbDBModel currPcb = dbpcbList.get(i);
                String origLabel = currPcb.getOrigLabel();
                if (origLabel != null && !origLabel.isEmpty()) {
                    currPcb.setLabel(origLabel);
                }
                if ((origPcbName = currPcb.getOrigPcbName()) != null && !origPcbName.isEmpty()) {
                    currPcb.setPcbName(origPcbName);
                }
                ++i;
            }
        }
        return psbName;
    }

    private static String ensureValidJavaName(String name) {
        Object retVal = name;
        if (DLIDatabaseViewGenerator.isFirstCharNumeric((String)retVal)) {
            String firstChar = ((String)retVal).substring(0, 1);
            retVal = "N" + firstChar + "_" + ((String)retVal).substring(1, ((String)retVal).length());
        }
        retVal = DLIDatabaseViewGenerator.replaceBadChar("@", "_atSign_", (String)retVal);
        retVal = DLIDatabaseViewGenerator.replaceBadChar("#", "_poundSign_", (String)retVal);
        return retVal;
    }

    private static String replaceBadChar(String badChar, String replacementStr, String name) {
        Object tempStr = name;
        while (((String)tempStr).contains(badChar)) {
            int index = ((String)tempStr).indexOf(badChar);
            tempStr = index == 0 ? replacementStr + ((String)tempStr).substring(1) : (index == ((String)tempStr).length() ? ((String)tempStr).substring(0, index) + replacementStr : ((String)tempStr).substring(0, index) + replacementStr + ((String)tempStr).substring(index + 1));
        }
        return tempStr;
    }

    private static boolean isFirstCharNumeric(String name) {
        boolean retVal = true;
        String firstChar = name.substring(0, 1);
        try {
            Integer.valueOf(firstChar);
        }
        catch (Exception exception) {
            retVal = false;
        }
        return retVal;
    }

    private void processDbPcbList(List<PcbDBModel> dbPcbList, BoolHolder boolHolder) throws ModelException, DatabaseViewGeneratorException, CoreException {
        Iterator<PcbDBModel> it = dbPcbList.iterator();
        for (PcbDBModel pcbDB : dbPcbList) {
            DatabaseViewGeneratorException db;
            String pcbAlias = pcbDB.getExternalName();
            String dbdName = pcbDB.getDbdName();
            Object dbAccessType = "";
            if (dbdName == null) continue;
            DbdModel dbdModel = this.getDBDfromPCBList(dbdName);
            if (dbdModel != null) {
                boolHolder.atLeastOneDbdIsInProject = true;
                dbAccessType = (String)dbAccessType + ", DBType." + dbdModel.getAccessType().value();
            }
            this.pcbName = pcbDB.getPcbName();
            if (this.pcbName == null) {
                this.pcbName = pcbDB.getLabel();
            }
            if (this.pcbName == null) {
                String[] dbError = new String[]{this.currentPsb.getPsbName()};
                db = new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1655"), dbError[0]);
                logger.throwing(this.getClass().getName(), "generateDBViewClass(PsbModel aPsb)", (Throwable)db);
                continue;
            }
            if (Character.isDigit(this.pcbName.charAt(0))) {
                Object[] inserts = new String[]{this.pcbName};
                db = new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("IMPORT_WIZ_009", inserts));
                logger.throwing(this.getClass().getName(), "generateDBViewClass(PsbModel aPsb)", (Throwable)db);
                throw db;
            }
            boolHolder.atLeastOneDbPcbHasName = true;
            this.bufConstructor.append("\n");
            this.bufConstructor.append("        create").append(this.pcbName).append("(); \n");
            this.bufPCBMethods.append("\n");
            this.bufPCBMethods.append("    // initialization method for PCB ").append(this.pcbName);
            this.bufPCBMethods.append("\n");
            this.bufPCBMethods.append("    private void create").append(this.pcbName).append("( ) {\n");
            if (this.generateForPcb(pcbDB, boolHolder)) {
                if (!((String)dbAccessType).isEmpty()) {
                    dbAccessType = (String)dbAccessType + ", " + boolHolder.atLeastOneDirectAccessSegment;
                }
                if (pcbAlias == null) {
                    pcbAlias = this.pcbName;
                }
                this.bufPCBMethods.append("\n");
                this.bufPCBMethods.append("        addDatabase(\"").append(pcbAlias).append("\", \"").append(this.pcbName).append("\", ").append(this.pcbName + "array").append(", \"").append(pcbDB.getProcopt()).append("\"").append((String)dbAccessType).append(");\n");
                this.bufPCBMethods.append("     }");
                continue;
            }
            this.bufPCBMethods.append("    }\n");
        }
    }

    private void printDBPcbList(List<PcbDBModel> pcbs, String psbName) {
        Iterator<PcbDBModel> it = pcbs.iterator();
        if (!it.hasNext()) {
            logger.fine("PSBName: " + psbName + " does not have DB PCBs.");
            return;
        }
        this.bufConstructor.append("\n");
        this.bufConstructor.append("    // PSB ").append(psbName).append(" has database PCBs with 8-char PCBNAME or label: \n");
        while (it.hasNext()) {
            PcbDBModel p = it.next();
            this.pcbName = p.getPcbName();
            if (this.pcbName == null) {
                this.pcbName = p.getLabel();
            }
            if (this.pcbName != null) {
                this.bufConstructor.append("    //       ").append(this.pcbName);
            }
            this.bufConstructor.append("\n");
        }
    }

    private void printGsamPcbList(List<PcbGsamModel> gsamPcbs) {
        for (PcbGsamModel gsamPcb : gsamPcbs) {
            String gsamPcbName = gsamPcb.getPcbName();
            if (gsamPcbName == null) {
                gsamPcbName = gsamPcb.getLabel();
            }
            if (gsamPcbName != null) {
                this.bufConstructor.append("    //       ").append(gsamPcbName);
            }
            this.bufConstructor.append("\n");
        }
    }

    public byte[] getByteArray() throws DatabaseViewGeneratorException {
        this.lw.storeLine("");
        return this.lw.getByteArray();
    }

    private void processGsamPcbList(List<PcbGsamModel> gsamPcbs, BoolHolder boolHolder) throws ModelException, DatabaseViewGeneratorException {
        for (PcbGsamModel gsamPcb : gsamPcbs) {
            String gPcbName = gsamPcb.getPcbName();
            if (gPcbName == null) {
                gPcbName = gsamPcb.getLabel();
            }
            if (gPcbName == null) {
                String[] dbError = new String[]{this.currentPsb.getPsbName()};
                DatabaseViewGeneratorException db = new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1655"), dbError[0]);
                logger.throwing(this.getClass().getName(), "The following PSBs have DB PCBs that are missing a name or a label: ", (Throwable)db);
                continue;
            }
            boolHolder.atLeastOneGsamPcbHasName = true;
            this.bufConstructor.append("\n");
            this.bufConstructor.append("        create").append(gPcbName).append("(); \n");
            this.bufPCBMethods.append("\n");
            this.bufPCBMethods.append("    // initialization method for PCB ").append(gPcbName);
            this.bufPCBMethods.append("\n");
            this.bufPCBMethods.append("    private void create").append(gPcbName).append("( ) {\n");
            if (this.generateForGsam(gsamPcb, gPcbName)) {
                boolHolder.atLeastOneGsamDbdIsInProject = true;
            }
            this.bufPCBMethods.append("\n");
            this.bufPCBMethods.append("        addDatabase(\"").append(gPcbName).append("\", \"").append(gPcbName).append("\", ").append(gPcbName + "array").append(", \"").append((Object)gsamPcb.getProcopt()).append("\");\n");
            this.bufPCBMethods.append("     }\n\n");
        }
    }

    private boolean genDLITypeInfoLine(FieldModel fld, long offset, long sFldStart, int hierLevel, boolean procSeqSet, boolean aFirstLineWritten, SegmentModel segmentModel) throws DatabaseViewGeneratorException, CoreException, ModelException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "genDLITypeInfoLine", new Object[0]);
        }
        String uniqueName = null;
        boolean firstLineWritten = aFirstLineWritten;
        String fldName = fld.getImsName();
        String jfldName = fld.getName();
        String jfldType = null;
        DBDConstants physDataType = fld.getPhysicalDataType();
        DBDConstants appDataType = fld.getAppDatatype();
        String jfldTypeQual = null;
        if (physDataType != null) {
            jfldType = physDataType.toString();
        } else if (appDataType != null) {
            jfldType = appDataType.toString();
        }
        if (physDataType == DBDConstants.ARRAY || appDataType == DBDConstants.ARRAY) {
            jfldType = DBDConstants.BINARY.toString();
        }
        if (appDataType == DBDConstants.STRUCT) {
            jfldType = this.allSubfieldsAreChar(fld) ? DBDConstants.CHAR.toString() : DBDConstants.BINARY.toString();
        } else if (appDataType == DBDConstants.DATE || appDataType == DBDConstants.TIME || appDataType == DBDConstants.TIMESTAMP) {
            jfldType = appDataType.toString();
            jfldTypeQual = fld.getPattern();
            if (jfldTypeQual == null || jfldTypeQual.isEmpty()) {
                jfldTypeQual = "unknown";
                dbError = new String[]{fldName, segmentModel.getDbdModel().getDBDName()};
                String missingResource = WorkbenchModelBundle.getError().getString("DHB1661", dbError);
                db = new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1660"), missingResource);
                logger.throwing(this.getClass().getName(), missingResource, (Throwable)db);
            }
        } else if (appDataType == DBDConstants.DECIMAL) {
            if (physDataType == DBDConstants.PACKEDDECIMAL || physDataType == DBDConstants.ZONEDDECIMAL || physDataType == DBDConstants.BINARY) {
                jfldType = physDataType.toString();
                jfldTypeQual = fld.getDecimalPattern();
            }
            if (jfldTypeQual == null || jfldTypeQual.isEmpty()) {
                jfldTypeQual = null;
                jfldType = DBDConstants.BINARY.toString();
                dbError = new String[]{fldName, segmentModel.getDbdModel().getDBDName()};
                String missingResource = WorkbenchModelBundle.getError().getString("DHB1661", dbError);
                db = new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1660"), missingResource);
                logger.throwing(this.getClass().getName(), missingResource, (Throwable)db);
            }
        } else if (appDataType == DBDConstants.OTHER) {
            jfldType = DBDConstants.BINARY.toString();
        }
        long fldStart = sFldStart > 0L ? sFldStart : (long)fld.getStartPos() + offset;
        long fldLen = fld.getBytes();
        if (jfldType == null) {
            jfldType = "CHAR";
        }
        if (jfldType.equals("INT")) {
            jfldType = "INTEGER";
        } else if (jfldType.equals("SHORT")) {
            jfldType = "SMALLINT";
        } else if (jfldType.equals("BYTE")) {
            jfldType = "TINYINT";
        } else if (jfldType.equals("LONG")) {
            jfldType = "BIGINT";
        } else if (jfldType.equals("UINT")) {
            jfldType = "UINTEGER";
        } else if (jfldType.equals("USHORT")) {
            jfldType = "USMALLINT";
        } else if (jfldType.equals("UBYTE")) {
            jfldType = "UTINYINT";
        } else if (jfldType.equals("ULONG")) {
            jfldType = "UBIGINT";
        } else if (jfldType.equals("USER")) {
            jfldType = "BINARY";
        } else if (jfldType.equals("XML_CLOB")) {
            jfldType = "CLOB";
        } else if (fld.getIsDbcs() == DBDConstants.Y) {
            jfldType = "DBCS";
        }
        String javaKeyStr = "";
        String javaKeySep = "";
        DBDConstants isKey = fld.getSeqType();
        Boolean fromDbd = false;
        if (fld.getImsName() != null) {
            fromDbd = true;
        }
        if (isKey != null) {
            javaKeyStr = isKey.equals((Object)DBDConstants.U) ? "DLITypeInfo.UNIQUE_KEY" : "DLITypeInfo.NON_UNIQUE_KEY";
            javaKeySep = ", ";
        }
        if (fromDbd.booleanValue() && jfldTypeQual == null) {
            if (jfldName == null) {
                jfldName = fldName;
            }
            firstLineWritten = true;
            uniqueName = this.htFields.get(jfldName);
            if (uniqueName != null) {
                jfldName = uniqueName;
            }
            this.bufTypeInfoMethods.append("              new DLITypeInfo(\"");
            this.bufTypeInfoMethods.append(jfldName);
            this.bufTypeInfoMethods.append("\"");
            this.bufTypeInfoMethods.append(", DLITypeInfo." + jfldType + ", ");
            this.bufTypeInfoMethods.append(fldStart + ", " + fldLen);
            if (fldName != null && !fldName.isEmpty()) {
                this.bufTypeInfoMethods.append(", \"" + fldName + "\"" + javaKeySep + javaKeyStr);
            }
            this.bufTypeInfoMethods.append(", DBType." + segmentModel.getDbdModel().getAccessType().toString() + ", ");
            this.bufTypeInfoMethods.append(this.isRoot(segmentModel, fld, hierLevel));
            this.bufTypeInfoMethods.append("),\n");
        } else if (fromDbd.booleanValue() && jfldTypeQual != null) {
            if (jfldName == null) {
                jfldName = fldName;
            }
            firstLineWritten = true;
            uniqueName = this.htFields.get(jfldName);
            if (uniqueName != null) {
                jfldName = uniqueName;
            }
            this.bufTypeInfoMethods.append("              new DLITypeInfo(");
            this.bufTypeInfoMethods.append("\"" + jfldName + "\", ");
            this.bufTypeInfoMethods.append("\"" + jfldTypeQual + "\", ");
            this.bufTypeInfoMethods.append("DLITypeInfo." + jfldType + ", ");
            this.bufTypeInfoMethods.append(fldStart + ", ");
            this.bufTypeInfoMethods.append(fldLen);
            if (fldName != null && !fldName.isEmpty()) {
                this.bufTypeInfoMethods.append(", \"" + fldName + "\"" + javaKeySep + javaKeyStr);
            }
            this.bufTypeInfoMethods.append(", DBType." + segmentModel.getDbdModel().getAccessType().toString() + ", ");
            this.bufTypeInfoMethods.append(this.isRoot(segmentModel, fld, hierLevel));
            this.bufTypeInfoMethods.append("),\n");
        } else if (!fromDbd.booleanValue() && jfldTypeQual == null) {
            if (jfldName == null) {
                jfldName = "unknown";
            }
            firstLineWritten = true;
            uniqueName = this.htFields.get(jfldName);
            if (uniqueName != null) {
                jfldName = uniqueName;
            }
            this.bufTypeInfoMethods.append("              new DLITypeInfo(").append("\"" + jfldName + "\", ").append("DLITypeInfo." + jfldType + ", ").append(fldStart + ", ").append(fldLen).append("),\n");
        } else if (!fromDbd.booleanValue() && jfldTypeQual != null) {
            if (jfldName == null) {
                jfldName = "unknown";
            }
            firstLineWritten = true;
            uniqueName = this.htFields.get(jfldName);
            if (uniqueName != null) {
                jfldName = uniqueName;
            }
            this.bufTypeInfoMethods.append("              new DLITypeInfo(").append("\"" + jfldName + "\", ").append("\"" + jfldTypeQual + "\", ").append("DLITypeInfo." + jfldType + ", ").append(fldStart + ", ").append(fldLen).append("),\n");
        }
        return firstLineWritten;
    }

    private boolean allSubfieldsAreChar(FieldModel fld) throws ModelException {
        boolean retVal = true;
        Vector<FieldModel> children = fld.getFieldList();
        int i = 0;
        while (i < children.size()) {
            FieldModel currChild = children.get(i);
            DBDConstants currAdt = currChild.getAppDatatype();
            if (currAdt != DBDConstants.CHAR && currAdt != DBDConstants.CLOB) {
                if (currAdt == DBDConstants.DECIMAL) {
                    currPdt = currChild.getPhysicalDataType();
                    if (currPdt != DBDConstants.ZONEDDECIMAL) {
                        retVal = false;
                        break;
                    }
                } else if (currAdt == DBDConstants.DATE || currAdt == DBDConstants.TIME || currAdt == DBDConstants.TIMESTAMP) {
                    currPdt = currChild.getPhysicalDataType();
                    if (currPdt != DBDConstants.CHAR) {
                        retVal = false;
                        break;
                    }
                } else {
                    retVal = false;
                    break;
                }
            }
            ++i;
        }
        return retVal;
    }

    public void genDLITypeInfoXDFLD(SensegModel sSeg, SegmentModel seg, long xdfldLen, boolean firstLineWritten) throws DatabaseViewGeneratorException {
        Iterator<String> it2;
        String jFldName;
        PcbDBModel currPcb;
        String procSeqStr;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "genDLITypeInfoXDFLD", new Object[0]);
        }
        if (((procSeqStr = (currPcb = this.currentPsb.getDBPcb(this.pcbName)).getProcSequence()) == null || procSeqStr.isEmpty()) && ((procSeqStr = currPcb.getProcSequenceD()) == null || procSeqStr.isEmpty())) {
            return;
        }
        boolean found = false;
        LogicalChildModel lchild2 = null;
        List<LogicalChildModel> logicalChildren = seg.getLogicalChildList();
        for (LogicalChildModel lchild2 : logicalChildren) {
            String indexDbdName;
            if (!lchild2.hasXdfld() || !procSeqStr.equals(indexDbdName = lchild2.getDbd())) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        String fldName = lchild2.getXdfldImsName();
        if (fldName == null) {
            fldName = "unknown";
        }
        if ((jFldName = lchild2.getXdfldName()) == null) {
            jFldName = fldName;
        }
        if (!(it2 = lchild2.getSearch().iterator()).hasNext()) {
            Object[] dbError = new String[]{seg.getImsName(), lchild2.getDbd()};
            DatabaseViewGeneratorException db = new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1650", dbError));
            logger.throwing(this.getClass().getName(), "genDLITypeInfoXDFLD()", (Throwable)db);
            logger.error((Throwable)db);
            throw db;
        }
        String srcSegName = lchild2.getXfldSourceSegment();
        if (srcSegName == null) {
            srcSegName = seg.getImsName();
        }
        String searchFieldArray = this.pcbName + seg.getName() + "Keys";
        firstLineWritten = true;
        this.bufTypeInfoMethods.append("              new SecondaryIndexInfo(").append("\"" + jFldName + "\",").append("\"" + srcSegName + "\",").append(searchFieldArray).append(", \"" + fldName + "\", ").append(xdfldLen).append("),\n");
    }

    public long genSecondaryIndexSearchArray(SensegModel sSeg, SegmentModel root, String aDBSegmentName) throws DatabaseViewGeneratorException, ModelException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "genSecondaryIndexSearchArray", new Object[0]);
        }
        PcbDBModel currPcb = this.currentPsb.getDBPcb(this.pcbName);
        String procSeqStr = null;
        if (currPcb != null && ((procSeqStr = currPcb.getProcSequence()) == null || procSeqStr.isEmpty()) && ((procSeqStr = currPcb.getProcSequenceD()) == null || procSeqStr.isEmpty())) {
            return 0L;
        }
        boolean found = false;
        SegmentModel sourceSeg = null;
        LogicalChildModel lchild2 = null;
        List<LogicalChildModel> logicalChildren = root.getLogicalChildList();
        for (LogicalChildModel lchild2 : logicalChildren) {
            if (!lchild2.hasXdfld()) continue;
            String indexDbdName = lchild2.getDbd();
            if (procSeqStr == null || !procSeqStr.equals(indexDbdName)) continue;
            this.bufTypeInfoMethods.append("\n");
            this.bufTypeInfoMethods.append("    // PCB: " + this.pcbName + " specifies a ").append("secondary processing sequence using index DBD: ").append(lchild2.getDbd()).append("\n");
            found = true;
            break;
        }
        if (!found) {
            return 0L;
        }
        List<String> srcFlds = lchild2.getSearch();
        Iterator<String> it2 = srcFlds.iterator();
        if (!it2.hasNext()) {
            Object[] dbError = new String[]{root.getImsName(), lchild2.getDbd()};
            DatabaseViewGeneratorException db = new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1650", dbError));
            logger.throwing(this.getClass().getName(), "genSecondaryIndexSearchArray()", (Throwable)db);
            logger.error((Throwable)db);
            throw db;
        }
        this.bufTypeInfoMethods.append("    // The following describes the search fields for the secondary\n").append("    // index for PCB: ").append(this.pcbName).append(" (\"").append(this.pcbName).append("\")\n");
        String arrayName = this.pcbName + root.getName() + "Keys";
        this.bufTypeInfoMethods.append("        String[] ").append(arrayName).append("= {");
        sourceSeg = lchild2.getXfldSourceSegment() != null && lchild2.getXfldSourceSegment().length() > 0 ? this.findPhysicalSegment(root, lchild2.getXfldSourceSegment()) : root;
        long searchFieldLength = 0L;
        boolean firstLineWritten = false;
        while (it2.hasNext()) {
            String fld = it2.next();
            FieldModel dbdField = this.findField(sourceSeg, fld);
            if (dbdField == null) {
                Object[] dbError = new String[]{fld, sourceSeg.getImsName(), sourceSeg.getDbdName()};
                String errMsg = WorkbenchModelBundle.getError().getString("DHB1662", dbError);
                DatabaseViewGeneratorException db = new DatabaseViewGeneratorException(errMsg);
                logger.throwing(this.getClass().getName(), "genSecondaryIndexSearchArray()", (Throwable)db);
                throw db;
            }
            searchFieldLength += (long)dbdField.getBytes();
            String fldname = dbdField.getName();
            if (fldname == null || fldname == "") {
                fldname = dbdField.getImsName();
            }
            if (fldname == null || fldname == "") {
                fldname = "unknown";
            }
            if (firstLineWritten) {
                this.bufTypeInfoMethods.append(", ");
            }
            firstLineWritten = true;
            this.bufTypeInfoMethods.append("\"").append(fldname).append("\"");
        }
        this.bufTypeInfoMethods.append("};\n");
        return searchFieldLength;
    }

    private FieldModel findField(SegmentModel seg, String searchField) throws ModelException {
        return seg.getFieldWithImsNameOrAlias(searchField);
    }

    /*
     * Unable to fully structure code
     */
    public int sequenceSensegs2(List<SensegModel> sensegs, SensegModel senseg, int parent, int startingSeq, int startingLevel) {
        senseg.setParentSeqNo(parent);
        senseg.setHierLevel(startingLevel);
        thisSeqNo = startingSeq;
        senseg.setSeqNo(thisSeqNo);
        childs = senseg.getChildren();
        it = childs.iterator();
        current = thisSeqNo;
        if (it.hasNext()) ** GOTO lbl12
        return current;
lbl-1000:
        // 1 sources

        {
            child = it.next();
            current = this.sequenceSensegs2(sensegs, child, thisSeqNo, current + 1, startingLevel + 1);
lbl12:
            // 2 sources

            ** while (it.hasNext())
        }
lbl13:
        // 1 sources

        return current;
    }

    private long genDLITypeInfoArraySegs(SensegModel sSeg, SegmentWorkArea workSeg, long searchFldLen, String dliSegmentName, boolean writeLine) throws DatabaseViewGeneratorException, CoreException, ModelException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "genDLITypeInfoArraySegs", new Object[]{workSeg.physicalSegment.getName()});
        }
        int segLength = 0;
        boolean firstLineWritten = false;
        boolean procSeqSet = searchFldLen != 0L;
        SegmentModel seg = workSeg.physicalSegment;
        SegmentModel logSeg = null;
        if (writeLine) {
            this.bufTypeInfoMethods.append("           DLITypeInfo[] " + dliSegmentName + "Array").append("=  {\n");
        }
        if (writeLine) {
            Vector<FieldModel> flds = this.getUnmappedFieldList(workSeg);
            firstLineWritten = this.genDLITypeInfoArray(sSeg, seg, flds, 0, procSeqSet, false, dliSegmentName);
        }
        if (this.dbdModel.getAccessType() == DBDConstants.LOGICAL) {
            logSeg = workSeg.logicalSegment;
            if (logSeg.hasConcatenatedSegmentSource()) {
                if (logSeg.getLogicalChildSourceData() == DBDConstants.Y) {
                    segLength = workSeg.logicalChildSourceSeg.getMaxBytes();
                }
                if (logSeg.getTargetParentSourceData() == DBDConstants.Y) {
                    segLength += workSeg.targetParentSourceSeg.getMaxBytes();
                }
            } else {
                segLength = seg.getMaxBytes();
            }
        } else {
            segLength = seg.getMaxBytes();
        }
        if (searchFldLen != 0L && writeLine) {
            this.genDLITypeInfoXDFLD(sSeg, seg, searchFldLen, firstLineWritten);
        }
        if (writeLine) {
            this.bufTypeInfoMethods.append("           };\n");
            this.bufTypeInfoMethods.append("           return ").append(dliSegmentName).append("Array;\n");
            this.bufTypeInfoMethods.append("        }\n");
        }
        return segLength;
    }

    private int countFieldsForSeg(List<FieldModel> fields, boolean keyFieldsOnly) {
        int count = 0;
        for (FieldModel fld : fields) {
            if (fld.getImsNameOrAlias() != null && fld.getImsNameOrAlias().charAt(0) == '/' || keyFieldsOnly && fld.getSeqType() == null) continue;
            ++count;
        }
        return count;
    }

    private int genDLITypeInfoArraySenflds(SensegModel sSeg, SegmentWorkArea workSeg, long searchFldLen, String dliSegmentName, boolean writeLine) throws DatabaseViewGeneratorException, ModelException, CoreException {
        boolean procSeqSet;
        SegmentModel seg = workSeg.physicalSegment;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "genDLITypeInfoArraySenflds", new Object[]{seg.getName()});
        }
        String dbdName = seg.getDbdName();
        boolean firstLineWritten = false;
        boolean bl = procSeqSet = searchFldLen != 0L;
        if (writeLine) {
            this.bufTypeInfoMethods.append("           DLITypeInfo[] " + dliSegmentName + "Array").append("=  {\n");
        }
        int hierLevel = sSeg.getHierLevel();
        int arrayLength = 0;
        SenfieldModel sFld2 = null;
        FieldModel fld = null;
        for (SenfieldModel sFld2 : sSeg.getSenfields()) {
            if (sFld2.getName().isEmpty() || sFld2.getName().charAt(0) == '/') continue;
            fld = seg.getFieldWithImsNameOrAlias(sFld2.getName());
            if (fld == null && workSeg.targetParentSourceSeg != null) {
                fld = workSeg.targetParentSourceSeg.getFieldWithAlias(sFld2.getName(), null);
            }
            if (fld == null) {
                Object[] dbError = new String[]{sFld2.getName(), workSeg.physicalSegment.getImsName(), this.currentPsb.getPsbName(), dbdName};
                String errMsg = WorkbenchModelBundle.getError().getString("DHB1657", dbError);
                DatabaseViewGeneratorException db = new DatabaseViewGeneratorException(errMsg);
                logger.throwing(this.getClass().getName(), "genDLITypeInfoArraySenflds()", (Throwable)db);
                throw db;
            }
            int sFldStart = sFld2.getStart();
            int fldStart = fld.getStartPos();
            int fldLength = fld.getBytes();
            int currRightMostByte = sFldStart > 0 ? fldLength - 1 + sFldStart : fldLength - 1 + fldStart;
            if (currRightMostByte > arrayLength) {
                arrayLength = currRightMostByte;
            }
            long offset = 0L;
            if (!writeLine) continue;
            firstLineWritten = this.genDLITypeInfoLine(fld, offset, sFldStart, hierLevel, procSeqSet, firstLineWritten, seg);
        }
        if (searchFldLen != 0L && writeLine) {
            this.genDLITypeInfoXDFLD(sSeg, seg, searchFldLen, firstLineWritten);
        }
        if (writeLine) {
            this.bufTypeInfoMethods.append("           };\n");
            this.bufTypeInfoMethods.append("           return ").append(dliSegmentName).append("Array;\n");
            this.bufTypeInfoMethods.append("        }\n");
        }
        return arrayLength;
    }

    public boolean generateForSenseg(SegmentWorkArea workSeg, SensegModel sSeg, List<String> dsNames, List<String> dsParentSeqs) throws DatabaseViewGeneratorException, ModelException, CoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "generateForSenseg ", new Object[]{workSeg.physicalSegment.getName()});
        }
        this.uniqueFields = new ArrayList();
        this.htFields = new Hashtable();
        SegmentModel seg = workSeg.physicalSegment;
        String segName = sSeg.getName();
        if (segName == null) {
            segName = "unknown";
        }
        String jsegName = seg.getName();
        long xdfldLen = 0L;
        if (sSeg.getSeqNo() == 0) {
            xdfldLen = this.genSecondaryIndexSearchArray(sSeg, seg, segName);
        }
        String dliSegmentName = this.pcbName + segName;
        if (workSeg.physicalSegment.isVirtualLogicalChild()) {
            this.bufPCBMethods.append("\n");
            this.bufPCBMethods.append("    // Segment " + segName + " is ommitted because it is a Virtual Logical Child.\n");
            return false;
        }
        this.bufPCBMethods.append("\n        DLITypeInfo[] ").append(dliSegmentName).append("Array = ").append(dliSegmentName).append("Array (); \n");
        this.bufTypeInfoMethods.append("\n    // The following describes").append(" Segment: " + segName + " (\"" + jsegName + "\")").append(" in PCB: " + this.pcbName + " (\"" + this.pcbName + "\")\n");
        this.bufTypeInfoMethods.append("\n        private DLITypeInfo[] ").append(dliSegmentName).append("Array").append("() {\n");
        Object dliSegmentParentSequenceString = sSeg.getParent() == null ? "DLIDatabaseView.ROOT" : "" + sSeg.getParentSeqNo();
        dsParentSeqs.add((String)dliSegmentParentSequenceString);
        Iterator<SenfieldModel> it = sSeg.getSenfields().iterator();
        long arrayLength = 0L;
        boolean checkFieldLevel = false;
        if (!seg.getDbdModel().getAccessType().equals((Object)DBDConstants.DEDB) && !seg.getDbdModel().getAccessType().equals((Object)DBDConstants.MSDB) && it.hasNext()) {
            arrayLength = this.genDLITypeInfoArraySenflds(sSeg, workSeg, xdfldLen, dliSegmentName, true);
            checkFieldLevel = this.checkSenseFieldLevel(sSeg, seg);
        } else {
            arrayLength = this.genDLITypeInfoArraySegs(sSeg, workSeg, xdfldLen, dliSegmentName, true);
            checkFieldLevel = this.checkFieldLevel(sSeg, seg);
        }
        Object minBytes = "";
        if (seg.isPhysicalSegment() && seg.getMinBytes() > 0) {
            minBytes = (String)minBytes + String.valueOf(seg.getMinBytes()) + ",";
        }
        dsNames.add(dliSegmentName + "Segment");
        String fullSegmentName = dliSegmentName + "Segment";
        this.bufPCBMethods.append("        DLISegment " + fullSegmentName + " = new DLISegment");
        this.bufPCBMethods.append(" (\"" + jsegName + "\",\"" + segName + "\",").append(this.pcbName + segName + "Array,").append((String)minBytes).append(arrayLength).append(",DBType." + seg.getDbdModel().getAccessType().value()).append("," + checkFieldLevel).append(");\n");
        String encoding = seg.getEncoding();
        if (encoding == null || encoding.isEmpty()) {
            encoding = seg.getDbdModel().getEncoding();
        }
        if (encoding != null && !encoding.isEmpty()) {
            this.bufPCBMethods.append("        ").append(fullSegmentName).append(".setDefaultEncoding(");
            this.bufPCBMethods.append("\"").append(encoding).append("\"").append(");\n");
        }
        return checkFieldLevel;
    }

    private boolean generateForGsam(PcbGsamModel p, String pcbName) throws ModelException, DatabaseViewGeneratorException {
        boolean dbdIsInProject = false;
        String gsamDbdName = p.getDbdName();
        String gsamRecord = p.getPcbAlias() == null || p.getPcbAlias().equalsIgnoreCase("") ? p.getPcbName() + "Record" : p.getPcbAlias() + "Record";
        this.bufPCBMethods.append("    // The following describes GSAM Record: " + gsamDbdName + " (\"" + gsamDbdName + "\") in PCB: " + p.getPcbName() + " (\"" + p.getPcbAlias() + "\")\n");
        this.bufPCBMethods.append("        DLITypeInfo[] ").append(pcbName).append(gsamDbdName).append("Array= { };\n");
        String dbdName = p.getDbdName();
        this.dbdModel = this.getDBDfromPCBList(dbdName);
        if (this.dbdModel != null) {
            dbdIsInProject = true;
            this.bufPCBMethods.append("        GSAMRecord ").append(gsamRecord).append("= new GSAMRecord ");
            Integer recordlen = this.dbdModel.getRECORDReclen1();
            if (recordlen == null) {
                recordlen = 32760;
            }
            this.bufPCBMethods.append(" (\"").append(gsamRecord).append("\",").append(pcbName).append(p.getDbdName()).append("Array,").append(recordlen).append(");\n");
            this.bufPCBMethods.append("    // An array of DLISegmentInfo objects follows to describe").append(" the view for PCB: ").append(pcbName).append(" (\"").append(p.getPcbAlias()).append("\")\n");
            this.bufPCBMethods.append("        DLISegmentInfo[] ").append(pcbName).append("array = { ");
            this.bufPCBMethods.append("  new DLISegmentInfo(").append(gsamRecord).append(", DLIDatabaseView.ROOT) };\n");
        }
        return dbdIsInProject;
    }

    private boolean genDLITypeInfoArray(SensegModel sSeg, SegmentModel seg, List<FieldModel> flds, int offset, boolean procSeqSet, boolean firstLineWritten, String dliSegmentName) throws DatabaseViewGeneratorException, CoreException, ModelException {
        int hierLevel = sSeg.getHierLevel();
        if (flds == null) {
            return firstLineWritten;
        }
        FieldModel fld = null;
        Iterator<FieldModel> it = flds.iterator();
        int i = 1;
        while (it.hasNext()) {
            fld = it.next();
            if (fld.getImsNameOrAlias() != null && fld.getImsNameOrAlias().charAt(0) == '/') continue;
            FieldModel duplicateField = this.getDuplicateFieldName(fld);
            if (duplicateField != null) {
                this.htFields.put(duplicateField.getImsNameOrAlias(), duplicateField.getImsNameOrAlias() + i++);
            }
            this.uniqueFields.add(fld);
            firstLineWritten = this.genDLITypeInfoLine(fld, offset, 0L, hierLevel, procSeqSet, firstLineWritten, seg);
        }
        return firstLineWritten;
    }

    public boolean generateForPcb(PcbDBModel pcbDB, BoolHolder boolHolder) throws ModelException, DatabaseViewGeneratorException, CoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "generateForPcb ", new Object[0]);
        }
        SegmentModel rootSeg = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("generateForPcb " + this.pcbName);
        }
        String arrayName = this.pcbName + "array";
        this.bufPCBMethods.append("\n");
        this.bufPCBMethods.append("    // An array of DLISegmentInfo objects follows to describe").append(" the view for PCB: ").append(this.pcbName).append(" (\"").append(this.pcbName).append("\")\n");
        SensegModel rootSenseg = pcbDB.getRootSenseg();
        String segName = rootSenseg.getName();
        if (segName == null) {
            segName = "unknown";
        }
        ArrayList<SensegModel> sensegs = rootSenseg.getChildren();
        this.sequenceSensegs2(sensegs, rootSenseg, 0, 0, 0);
        String dbdName = pcbDB.getDbdName();
        this.dbdModel = this.getDBDfromPCBList(dbdName);
        if (this.dbdModel == null) {
            return false;
        }
        rootSeg = this.findPhysicalSegment(this.dbdModel.getRootSegment(), rootSenseg.getName());
        SegmentWorkArea workSeg = null;
        if (this.dbdModel.getAccessType() == DBDConstants.LOGICAL) {
            if (rootSeg.hasSegmentSource()) {
                workSeg = this.returnSegSourceForLogicalDBD(rootSeg, rootSenseg.getName());
                if (workSeg == null) {
                    return false;
                }
                rootSenseg.setSegmentModel(workSeg.logicalSegment);
                workSeg.logicalSegment.setLchildSourceSeg(workSeg.logicalChildSourceSeg);
                workSeg.logicalSegment.setTargetParentSourceSeg(workSeg.targetParentSourceSeg);
                workSeg.logicalSegment.setLogicalSourceSeg(workSeg.physicalSegment);
            } else if (rootSeg.hasConcatenatedSegmentSource()) {
                workSeg = this.returnConcatSegSourceForLogicalDBD(rootSeg, rootSeg.getImsName());
                if (workSeg == null) {
                    return false;
                }
                workSeg.logicalSegment = rootSeg;
            }
        } else {
            workSeg = new SegmentWorkArea();
            workSeg.physicalSegment = rootSeg;
            rootSenseg.setSegmentModel(rootSeg);
        }
        rootSeg.setProjectName(this.projectName);
        ArrayList<String> dsNames = new ArrayList<String>();
        ArrayList<String> dsParentSeqs = new ArrayList<String>();
        boolHolder.atLeastOneDirectAccessSegment = this.generateForSenseg(workSeg, rootSenseg, dsNames, dsParentSeqs);
        this.processSenseg(this.lw, rootSenseg, dsNames, dsParentSeqs);
        this.bufPCBMethods.append("\n        DLISegmentInfo[] " + arrayName + " = new DLISegmentInfo[" + dsNames.size() + "];\n");
        int i = 0;
        while (i < dsNames.size()) {
            this.bufPCBMethods.append("        " + arrayName + "[" + i + "] =").append(" new DLISegmentInfo(").append((String)dsNames.get(i)).append(",").append((String)dsParentSeqs.get(i)).append(");\n");
            ++i;
        }
        return true;
    }

    private void processSenseg(LineSetWriter lw, SensegModel parent, List<String> dsNames, List<String> dsParentSeqs) throws ModelException, DatabaseViewGeneratorException, CoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "processSenseg - Segment " + parent.getName(), new Object[0]);
        }
        Iterator<SensegModel> it = parent.getChildren().iterator();
        SegmentModel seg = null;
        SegmentWorkArea workSeg = null;
        String segName = null;
        while (it.hasNext()) {
            SensegModel sseg = it.next();
            if (this.dbdModel.getAccessType() == DBDConstants.LOGICAL) {
                workSeg = this.findPhysicalSegmentFromLogicalDBD(this.dbdModel.getRootSegment(), sseg.getName());
                if (workSeg == null) {
                    return;
                }
                sseg.setSegmentModel(workSeg.logicalSegment);
                workSeg.logicalSegment.setLchildSourceSeg(workSeg.logicalChildSourceSeg);
                workSeg.logicalSegment.setTargetParentSourceSeg(workSeg.targetParentSourceSeg);
                workSeg.logicalSegment.setLogicalSourceSeg(workSeg.physicalSegment);
            } else {
                seg = this.findPhysicalSegment(this.dbdModel.getRootSegment(), sseg.getName());
                if (seg == null) {
                    return;
                }
                workSeg = new SegmentWorkArea();
                workSeg.physicalSegment = seg;
                sseg.setSegmentModel(seg);
            }
            sseg.getSegModel().setProjectName(this.projectName);
            segName = sseg.getName();
            if (segName == null) {
                segName = "unknown";
            }
            this.generateForSenseg(workSeg, sseg, dsNames, dsParentSeqs);
            this.processSenseg(lw, sseg, dsNames, dsParentSeqs);
        }
    }

    private SegmentWorkArea findPhysicalSegmentFromLogicalDBD(SegmentModel root, String segName) throws ModelException, DatabaseViewGeneratorException {
        SegmentModel seg2 = null;
        SegmentWorkArea workSeg = null;
        if (root.getImsName().equalsIgnoreCase(segName)) {
            if (root.hasSegmentSource()) {
                return this.returnSegSourceForLogicalDBD(root, segName);
            }
            if (root.hasConcatenatedSegmentSource()) {
                return this.returnConcatSegSourceForLogicalDBD(root, segName);
            }
        }
        for (SegmentModel seg2 : root.getChildSegments()) {
            if (seg2.getImsName().equalsIgnoreCase(segName)) {
                if (seg2.hasSegmentSource()) {
                    return this.returnSegSourceForLogicalDBD(seg2, segName);
                }
                if (seg2.hasConcatenatedSegmentSource()) {
                    return this.returnConcatSegSourceForLogicalDBD(seg2, segName);
                }
            } else {
                workSeg = this.findPhysicalSegmentFromLogicalDBD(seg2, segName);
            }
            if (workSeg == null) continue;
            return workSeg;
        }
        return null;
    }

    private SegmentWorkArea returnSegSourceForLogicalDBD(SegmentModel seg, String segName) throws ModelException, DatabaseViewGeneratorException {
        SegmentWorkArea workSeg = null;
        DbdModel dbd = this.getDBDfromPCBList(seg.getSegmentSourceDBName());
        if (dbd != null) {
            workSeg = new SegmentWorkArea();
            workSeg.physicalSegment = this.findPhysicalSegment(dbd.getRootSegment(), seg.getSegmentSourceSegName());
            workSeg.logicalSegment = seg;
        }
        return workSeg;
    }

    private SegmentWorkArea returnConcatSegSourceForLogicalDBD(SegmentModel seg, String segName) throws ModelException, DatabaseViewGeneratorException {
        DbdModel dbd = null;
        SegmentWorkArea workSeg = new SegmentWorkArea();
        workSeg.logicalSegment = seg;
        dbd = this.getDBDfromPCBList(seg.getLogicalChildSourceDBName());
        if (dbd == null) {
            return null;
        }
        workSeg.logicalChildSourceSeg = this.findPhysicalSegment(dbd.getRootSegment(), seg.getLogicalChildSourceSegName());
        dbd = this.getDBDfromPCBList(seg.getTargetParentSourceDBName());
        if (dbd == null) {
            return null;
        }
        workSeg.targetParentSourceSeg = this.findPhysicalSegment(dbd.getRootSegment(), seg.getTargetParentSourceSegName());
        workSeg.physicalSegment = workSeg.logicalSegment.getLogicalChildSourceData() == DBDConstants.Y ? workSeg.logicalChildSourceSeg : workSeg.targetParentSourceSeg;
        return workSeg;
    }

    private SegmentModel findPhysicalSegment(SegmentModel root, String segName) {
        if (root.getImsName().equalsIgnoreCase(segName) || root.getName().equalsIgnoreCase(segName)) {
            return root;
        }
        Iterator<SegmentModel> it = root.getChildSegments().iterator();
        SegmentModel seg = null;
        while (it.hasNext()) {
            seg = it.next();
            if (seg.getImsName().equalsIgnoreCase(segName) || seg.getName().equalsIgnoreCase(segName)) {
                return seg;
            }
            if ((seg = this.findPhysicalSegment(seg, segName)) == null) continue;
            return seg;
        }
        return null;
    }

    private DbdModel buildDbdModel(String projectName, String dbdName) throws ModelException, DatabaseViewGeneratorException {
        DbdModel dbdModel = null;
        try {
            IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile(projectName, dbdName);
            if (!dbdFile.exists()) {
                Object[] dbError = new String[]{dbdName, this.currentPsb.getPsbName()};
                String missingResource = WorkbenchModelBundle.getError().getString("DHB1656", dbError);
                Object[] inserts = new Object[]{new String(Character.toChars(8482))};
                DatabaseViewGeneratorException db = new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1652W", inserts), missingResource);
                logger.throwing(this.getClass().getName(), "buildDbdModel(String projectName, String dbdName)", (Throwable)db);
            } else {
                dbdModel = new DbdModel(dbdFile.getContents());
            }
            return dbdModel;
        }
        catch (CoreException e) {
            Object[] dbError = new String[]{dbdName};
            DatabaseViewGeneratorException db = new DatabaseViewGeneratorException(WorkbenchModelBundle.getError().getString("DHB1653", dbError));
            db.initCause(e);
            logger.throwing(this.getClass().getName(), "Unexpected Core Exception when reading DBD source file", (Throwable)db);
            throw db;
        }
    }

    private DbdModel getDBDfromPCBList(String dbdName) throws ModelException, DatabaseViewGeneratorException {
        DbdModel dbd = this.dbdList.get(dbdName);
        if (dbd == null && (dbd = this.buildDbdModel(this.projectName, dbdName)) != null) {
            this.dbdList.put(dbd.getDBDName(), dbd);
        }
        return dbd;
    }

    private void addWarningMessage(DatabaseViewGeneratorException e, String projectName) {
        String resource = null;
        boolean found = false;
        boolean exceptionMsgAdded = false;
        if (this.dbViewExceptions == null) {
            this.dbViewExceptions = new Vector();
            this.dbViewExceptions.add(e);
        } else {
            int i = 0;
            while (i < this.dbViewExceptions.size()) {
                if (e.getMessage().equals(this.dbViewExceptions.get(i).getMessage())) {
                    exceptionMsgAdded = true;
                }
                if (exceptionMsgAdded) {
                    List<String> temp = this.dbViewExceptions.get(i).getResourceList();
                    int j = 0;
                    while (j < temp.size()) {
                        resource = temp.get(j);
                        if (e.getResourceList().get(0).equalsIgnoreCase(resource)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!found && exceptionMsgAdded) {
                    this.dbViewExceptions.get(i).getResourceList().add(e.getResourceList().get(0));
                    break;
                }
                ++i;
            }
            if (!exceptionMsgAdded) {
                this.dbViewExceptions.add(e);
            }
        }
    }

    private FieldModel getDuplicateFieldName(FieldModel currentField) {
        Iterator<FieldModel> it = this.uniqueFields.iterator();
        while (it != null && it.hasNext()) {
            FieldModel field = it.next();
            if (field.getImsNameOrAlias() == null || !field.getImsNameOrAlias().equals(currentField.getImsNameOrAlias())) continue;
            return field;
        }
        return null;
    }

    public Vector<DatabaseViewGeneratorException> getDBViewExceptions() {
        return this.dbViewExceptions;
    }

    private boolean isRoot(SegmentModel seg, FieldModel fld, int hierLevel) {
        Boolean isKey = fld.isSeq();
        Boolean isUnique = fld.isSeq() && fld.getSeqType().equals((Object)DBDConstants.U);
        DBDConstants accessType = seg.getDbdModel().getAccessType();
        return isUnique != null && isUnique != false && isKey != null && isKey != false && (accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.PHIDAM) || accessType.equals((Object)DBDConstants.DEDB)) && hierLevel == 0;
    }

    private boolean checkSenseFieldLevel(SensegModel sSeg, SegmentModel seg) throws ModelException, CoreException {
        for (SenfieldModel sFld : sSeg.getSenfields()) {
            FieldModel fld = sFld.getFieldModel();
            if (!this.isRoot(seg, fld, sSeg.getHierLevel())) continue;
            return true;
        }
        return false;
    }

    private boolean checkFieldLevel(SensegModel sSeg, SegmentModel seg) throws ModelException {
        for (FieldModel fld : seg.getTopLevelFieldList()) {
            if (!this.isRoot(seg, fld, sSeg.getHierLevel())) continue;
            return true;
        }
        return false;
    }

    private Vector<FieldModel> getLogicalSegmentFieldList(SegmentWorkArea workSeg) throws ModelException {
        Vector<FieldModel> retVal = null;
        SegmentModel lchildSrcSeg = workSeg.logicalChildSourceSeg;
        SegmentModel targetParentSrcSeg = workSeg.targetParentSourceSeg;
        retVal = lchildSrcSeg != null && targetParentSrcSeg != null ? workSeg.logicalSegment.getConcatenatedFieldList(lchildSrcSeg, targetParentSrcSeg, this.pcbName, true) : workSeg.physicalSegment.getFieldList(true, false);
        return retVal;
    }

    private Vector<FieldModel> getUnmappedFieldList(SegmentWorkArea workSeg) throws ModelException {
        Vector<FieldModel> retVal;
        boolean isVarLengthSegment = false;
        boolean llFieldExists = false;
        if (workSeg.physicalSegment.getMinBytes() > 0) {
            isVarLengthSegment = true;
        }
        Vector<FieldModel> fields = null;
        fields = this.dbdModel.getAccessType() == DBDConstants.LOGICAL ? this.getLogicalSegmentFieldList(workSeg) : workSeg.physicalSegment.getFieldList(false, false);
        boolean arrayFieldPresent = false;
        int i = 0;
        while (i < fields.size()) {
            FieldModel currField = fields.get(i);
            if (isVarLengthSegment && currField.getStartPos() == 1 && currField.getAppDatatype() == DBDConstants.SHORT) {
                llFieldExists = true;
            }
            if (currField.getAppDatatype() == DBDConstants.ARRAY) {
                arrayFieldPresent = true;
                if (!isVarLengthSegment) break;
            }
            ++i;
        }
        FieldModelImpl llFieldModel = null;
        if (isVarLengthSegment && !llFieldExists) {
            String generatedLLFieldName = this.genLLFieldName(workSeg.physicalSegment);
            llFieldModel = new FieldModelImpl();
            llFieldModel.setName(generatedLLFieldName);
            llFieldModel.setAppDatatype(DBDConstants.SHORT);
            llFieldModel.setStartPos(1);
            llFieldModel.setBytes(2);
        }
        if (arrayFieldPresent) {
            retVal = new Vector();
            if (isVarLengthSegment && !llFieldExists) {
                retVal.add(llFieldModel);
            }
            fields = workSeg.physicalSegment.getTopLevelFieldList();
            int i2 = 0;
            while (i2 < fields.size()) {
                FieldModel currField = fields.get(i2);
                DBDConstants adt = currField.getAppDatatype();
                int currFieldMaxBytes = currField.getMaxBytes();
                int currFieldStartPos = currField.getStartPos();
                if (adt == DBDConstants.ARRAY && currFieldMaxBytes == 0 && currFieldStartPos > 0) {
                    this.expandArray(currField, "", retVal, currFieldStartPos - 1);
                } else if (adt == DBDConstants.STRUCT && currFieldMaxBytes == 0 && currFieldStartPos > 0) {
                    this.flattenStruct(currField, "", retVal, currFieldStartPos - 1);
                } else if (currFieldMaxBytes == 0 && currFieldStartPos > 0) {
                    FieldModelImpl childReplacementField = new FieldModelImpl(SegmentModel.cloneFieldType(currField.getFieldType()));
                    retVal.add(childReplacementField);
                }
                ++i2;
            }
        } else {
            retVal = fields;
            if (isVarLengthSegment && !llFieldExists) {
                retVal.add(llFieldModel);
            }
        }
        return retVal;
    }

    private String genLLFieldName(SegmentModel segmentModel) throws ModelException {
        String baseNewFieldName;
        FieldModel nameCollisionField = null;
        String newFieldName = baseNewFieldName = segmentModel.getName() + "_LL";
        int iterations = 0;
        do {
            if ((nameCollisionField = segmentModel.getFieldWithAlias(newFieldName, null)) != null) {
                newFieldName = iterations > 0 ? baseNewFieldName + "_NEW" + Integer.toString(iterations) : newFieldName + "_NEW";
            }
            ++iterations;
        } while (nameCollisionField != null);
        return newFieldName;
    }

    private void expandArray(FieldModel arrayField, String prependName, Vector<FieldModel> retVal, int arrayStartPos) throws ModelException {
        FieldModelImpl replacementField = new FieldModelImpl(SegmentModel.cloneFieldType(arrayField.getFieldType()));
        replacementField.setAppDatatype(DBDConstants.BINARY);
        String subFieldPrependName = prependName + arrayField.getName();
        replacementField.setName(subFieldPrependName);
        if (replacementField.getRelativeStart() > 0) {
            replacementField.setStartPos(arrayStartPos + 1);
            replacementField.setRelativeStart(0);
        }
        retVal.add(replacementField);
        int numArrayElements = arrayField.getMaxOccurs();
        int arrayElementSize = arrayField.getBytes() / numArrayElements;
        Vector<FieldModel> childFields = arrayField.getChildFields();
        if (childFields == null || childFields.size() == 0) {
            Object[] inserts = new Object[]{replacementField.getAlias()};
            throw new ModelException(WorkbenchModelBundle.getError().getString("MANAGEFIELDS_CNTRL_ERR0R01", inserts));
        }
        int i = 1;
        while (i <= numArrayElements) {
            if (childFields != null) {
                int j = 0;
                while (j < childFields.size()) {
                    FieldModel currField = childFields.get(j);
                    DBDConstants adt = currField.getAppDatatype();
                    int currFieldMaxBytes = currField.getMaxBytes();
                    if (adt == DBDConstants.ARRAY && currFieldMaxBytes == 0) {
                        this.expandArray(currField, subFieldPrependName + "_" + i + "_", retVal, arrayStartPos + currField.getRelativeStart() - 1 + (i - 1) * arrayElementSize);
                    } else if (adt == DBDConstants.STRUCT && currFieldMaxBytes == 0) {
                        this.flattenStruct(currField, subFieldPrependName + "_" + i + "_", retVal, arrayStartPos + currField.getRelativeStart() - 1 + (i - 1) * arrayElementSize);
                    } else if (currFieldMaxBytes == 0) {
                        FieldModelImpl childReplacementField = new FieldModelImpl(SegmentModel.cloneFieldType(currField.getFieldType()));
                        childReplacementField.setName(subFieldPrependName + "_" + i + "_" + childReplacementField.getName());
                        childReplacementField.setStartPos(arrayStartPos + currField.getRelativeStart() + (i - 1) * arrayElementSize);
                        childReplacementField.setRelativeStart(0);
                        retVal.add(childReplacementField);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void flattenStruct(FieldModel structField, String prependName, Vector<FieldModel> retVal, int structStartPos) throws ModelException {
        FieldModelImpl replacementField = new FieldModelImpl(SegmentModel.cloneFieldType(structField.getFieldType()));
        replacementField.setName(prependName + structField.getName());
        if (replacementField.getRelativeStart() > 0) {
            replacementField.setStartPos(structStartPos + 1);
            replacementField.setRelativeStart(0);
        }
        retVal.add(replacementField);
        Vector<FieldModel> childFields = structField.getChildFields();
        logger.finest("flattening struct: " + structField.getName());
        if (childFields != null) {
            int i = 0;
            while (i < childFields.size()) {
                FieldModel currField = childFields.get(i);
                DBDConstants adt = currField.getAppDatatype();
                int currFieldMaxBytes = currField.getMaxBytes();
                if (adt == DBDConstants.ARRAY && currFieldMaxBytes == 0) {
                    int currFieldStartPos = currField.getRelativeStart() > 0 ? structStartPos + currField.getRelativeStart() - 1 : currField.getStartPos() - 1;
                    this.expandArray(currField, prependName, retVal, currFieldStartPos);
                } else if (adt == DBDConstants.STRUCT && currFieldMaxBytes == 0) {
                    int currFieldStartPos = currField.getRelativeStart() > 0 ? structStartPos + currField.getRelativeStart() - 1 : currField.getStartPos() - 1;
                    this.flattenStruct(currField, prependName, retVal, currFieldStartPos);
                } else if (currFieldMaxBytes == 0) {
                    FieldModelImpl childReplacementField = new FieldModelImpl(SegmentModel.cloneFieldType(currField.getFieldType()));
                    childReplacementField.setName(prependName + childReplacementField.getName());
                    if (currField.getRelativeStart() > 0) {
                        childReplacementField.setStartPos(structStartPos + currField.getRelativeStart());
                        childReplacementField.setRelativeStart(0);
                    }
                    retVal.add(childReplacementField);
                }
                ++i;
            }
        }
    }

    public class BoolHolder {
        public boolean atLeastOneDbPcbHasName = false;
        public boolean atLeastOneDbdIsInProject = false;
        public boolean atLeastOneGsamPcbHasName = false;
        public boolean atLeastOneGsamDbdIsInProject = false;
        public boolean atLeastOneDirectAccessSegment = false;
    }

    private class SegmentWorkArea {
        SegmentModel physicalSegment;
        SegmentModel logicalSegment;
        SegmentModel logicalChildSourceSeg;
        SegmentModel targetParentSourceSeg;

        private SegmentWorkArea() {
        }
    }
}

