/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.metadata.dbd.DependingOnFieldValueType;
import com.ibm.im.ims.metadata.dbd.IndexType;
import com.ibm.im.ims.metadata.dbd.MarshallerType;
import com.ibm.im.ims.metadata.dbd.PhysicalDatatypeType;
import com.ibm.im.ims.metadata.dbd.PropertyType;
import com.ibm.im.ims.metadata.dbd.ValueDatatypeType;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.model.AreaStmt;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DataExitRoutine;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.HidamDataSetModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DBDSourceGenerator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String currentDatasetLabel;
    private static ArrayList<String> usedDatasetLabels;
    private static boolean catalogEnabled;

    public static synchronized ByteArrayInputStream genDbdSrc(DbdModel dbdModel, boolean genOption) throws ModelException {
        ByteArrayInputStream genSrcDbdInputStream = null;
        String datasetSegmStmts = null;
        String areaStmts = null;
        catalogEnabled = genOption;
        String dbdStmt = DBDSourceGenerator.genDBDStmt(dbdModel);
        if (dbdModel.getAccessType() == DBDConstants.HSAM || dbdModel.getAccessType() == DBDConstants.SHSAM || dbdModel.getAccessType() == DBDConstants.GSAM || dbdModel.getAccessType() == DBDConstants.HISAM || dbdModel.getAccessType() == DBDConstants.SHISAM || dbdModel.getAccessType() == DBDConstants.INDEX || dbdModel.getAccessType() == DBDConstants.PSINDEX || dbdModel.getAccessType() == DBDConstants.PHDAM || dbdModel.getAccessType() == DBDConstants.PHIDAM || dbdModel.getAccessType() == DBDConstants.DEDB || dbdModel.getAccessType() == DBDConstants.LOGICAL || dbdModel.getAccessType() == DBDConstants.MSDB) {
            if (dbdModel.getAccessType() == DBDConstants.DEDB) {
                areaStmts = DBDSourceGenerator.genAreaStmts(dbdModel);
            }
            datasetSegmStmts = DBDSourceGenerator.genDatasetSegmStmts(dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.HDAM || dbdModel.getAccessType() == DBDConstants.HIDAM) {
            datasetSegmStmts = DBDSourceGenerator.genHdamDatasetSegmStmts(dbdModel);
        }
        String genDbdSource = dbdModel.getAccessType() == DBDConstants.DEDB ? dbdStmt + areaStmts + datasetSegmStmts + "\n         DBDGEN                                                         \n         FINISH                                                         \n         END                                                            " : (dbdModel.getAccessType() == DBDConstants.INDEX ? dbdStmt + datasetSegmStmts + "\n         DBDGEN                                                         \n         FINISH                                                         \n         END                                                            " : dbdStmt + datasetSegmStmts + "\n         DBDGEN                                                         \n         FINISH                                                         \n         END                                                            ");
        genSrcDbdInputStream = new ByteArrayInputStream(genDbdSource.getBytes());
        return genSrcDbdInputStream;
    }

    private static String genAreaStmts(DbdModel dbdModel) {
        Object areaStmts = null;
        Iterator<AreaStmt> areaIter = dbdModel.getAreaList().iterator();
        if (areaIter.hasNext()) {
            areaStmts = "";
        }
        while (areaIter.hasNext()) {
            AreaStmt newArea = areaIter.next();
            String areaStmt = "\n         AREA  DD1=" + newArea.getDd1();
            areaStmt = areaStmt + ",SIZE=" + newArea.getSize();
            areaStmt = areaStmt + ",UOW=(" + newArea.getUowNumber1() + "," + newArea.getUowOverflow1() + ")";
            areaStmt = areaStmt + ",ROOT=(" + newArea.getRootNumber2() + "," + newArea.getRootOverflow2() + ")";
            String comments = newArea.getRemarks();
            if (comments != null && !comments.isEmpty()) {
                areaStmt = areaStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(comments);
            }
            areaStmts = (String)areaStmts + DBDSourceGenerator.wrapStmt(areaStmt);
        }
        return areaStmts;
    }

    private static String genDatasetSegmStmts(DbdModel dbdModel) throws ModelException {
        ArrayList<String> segmFieldLchildXdfldStmts = new ArrayList<String>();
        Object datasetSegmStmts = null;
        if (dbdModel.getAccessType() != DBDConstants.DEDB && dbdModel.getAccessType() != DBDConstants.PSINDEX && dbdModel.getAccessType() != DBDConstants.PHDAM && dbdModel.getAccessType() != DBDConstants.PHIDAM) {
            String datasetStmt = DBDSourceGenerator.genDatasetStmt(dbdModel);
            datasetSegmStmts = datasetStmt;
        } else {
            datasetSegmStmts = "";
        }
        DBDSourceGenerator.genSegmStmts(dbdModel.getRootSegment(), segmFieldLchildXdfldStmts);
        int i = 0;
        while (i < segmFieldLchildXdfldStmts.size()) {
            datasetSegmStmts = (String)datasetSegmStmts + segmFieldLchildXdfldStmts.get(i);
            ++i;
        }
        return datasetSegmStmts;
    }

    private static String genHdamDatasetSegmStmts(DbdModel dbdModel) throws ModelException {
        ArrayList<HidamDataSetModel> hdamDatasets = dbdModel.getHidamDataset();
        currentDatasetLabel = hdamDatasets.get(0).getLabel();
        if (currentDatasetLabel == null) {
            currentDatasetLabel = hdamDatasets.get(0).getGeneratedLabel();
        }
        ArrayList<String> segmFieldLchildXdfldStmts = new ArrayList<String>();
        usedDatasetLabels = new ArrayList();
        DBDSourceGenerator.genHdamSegmStmts(hdamDatasets, dbdModel.getRootSegment(), segmFieldLchildXdfldStmts);
        Object hdamDatasetSegmStmts = "";
        int i = 0;
        while (i < segmFieldLchildXdfldStmts.size()) {
            hdamDatasetSegmStmts = (String)hdamDatasetSegmStmts + segmFieldLchildXdfldStmts.get(i);
            ++i;
        }
        return hdamDatasetSegmStmts;
    }

    private static void genHdamSegmStmts(ArrayList<HidamDataSetModel> hdamDatasets, SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        boolean found = false;
        String datasetLabel = segmentModel.getDatasetLabel();
        if (segmentModel.isRoot()) {
            segmFieldLchildXdfldStmts.add(DBDSourceGenerator.genHdamDatasetStmt(hdamDatasets.get(0)));
        } else if (!datasetLabel.equals(currentDatasetLabel)) {
            currentDatasetLabel = datasetLabel;
            int i = 0;
            while (i < hdamDatasets.size() && !found) {
                String actualLabel = hdamDatasets.get(i).getLabel();
                if (actualLabel == null) {
                    if (hdamDatasets.get(i).getGeneratedLabel().equals(datasetLabel)) {
                        found = true;
                        segmFieldLchildXdfldStmts.add(DBDSourceGenerator.genHdamDatasetStmt(hdamDatasets.get(i)));
                    }
                } else if (actualLabel.equals(datasetLabel)) {
                    found = true;
                    segmFieldLchildXdfldStmts.add(DBDSourceGenerator.genHdamDatasetStmt(hdamDatasets.get(i)));
                }
                ++i;
            }
        }
        String segName = segmentModel.getImsName();
        Object segmStmt = "\n         SEGM  NAME=" + segName;
        if (catalogEnabled) {
            String segNameAlias = segmentModel.getName();
            segmStmt = segNameAlias != null ? (String)segmStmt + ",EXTERNALNAME=" + segNameAlias : (String)segmStmt + ",EXTERNALNAME=" + segName;
        }
        segmStmt = DBDSourceGenerator.addPARENT((String)segmStmt, segmentModel, dbdAccessType);
        segmStmt = segmentModel.getMaxBytes() == -1 ? DBDSourceGenerator.addSOURCE((String)segmStmt, segmentModel, dbdAccessType) : DBDSourceGenerator.addBYTES((String)segmStmt, segmentModel);
        segmStmt = DBDSourceGenerator.addFREQ((String)segmStmt, segmentModel);
        segmStmt = DBDSourceGenerator.addPOINTER((String)segmStmt, segmentModel, dbdAccessType);
        segmStmt = DBDSourceGenerator.addRULES((String)segmStmt, segmentModel, dbdAccessType);
        segmStmt = DBDSourceGenerator.addSEGMEXIT((String)segmStmt, segmentModel);
        segmStmt = DBDSourceGenerator.addCOMPRTN((String)segmStmt, segmentModel, dbdAccessType);
        if (catalogEnabled) {
            String comments;
            String segmentEncodingOverride = segmentModel.getEncoding();
            if (segmentEncodingOverride != null && !segmentEncodingOverride.isEmpty()) {
                segmStmt = (String)segmStmt + ",ENCODING=" + segmentEncodingOverride;
            }
            if ((comments = segmentModel.getRemarks()) != null && !comments.isEmpty()) {
                char aChar = comments.charAt(0);
                char zChar = comments.charAt(comments.length() - 1);
                segmStmt = aChar != '\'' ? (String)segmStmt + ",REMARKS='" + comments : (String)segmStmt + ",REMARKS=" + comments;
                if (zChar != '\'') {
                    segmStmt = (String)segmStmt + "'";
                }
            }
        }
        segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt((String)segmStmt));
        DBDSourceGenerator.genFieldStmts(segmentModel, segmFieldLchildXdfldStmts);
        DBDSourceGenerator.genLchildStmts(segmentModel, segmFieldLchildXdfldStmts);
        if (catalogEnabled) {
            DBDSourceGenerator.genMaps(segmentModel, segmFieldLchildXdfldStmts);
        }
        for (SegmentModel child : segmentModel.getChildSegments()) {
            DBDSourceGenerator.genHdamSegmStmts(hdamDatasets, child, segmFieldLchildXdfldStmts);
        }
    }

    private static void genMaps(SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        Iterator<MappingModel> mappings = segmentModel.getMappingList();
        while (mappings.hasNext()) {
            MappingModel fieldMap = mappings.next();
            DBDSourceGenerator.genDFSMAPStmts(fieldMap, segmentModel, segmFieldLchildXdfldStmts);
            Iterator<MappingCaseModel> mappingCaseIter = fieldMap.getMappingCases();
            while (mappingCaseIter.hasNext()) {
                MappingCaseModel mappingCase = mappingCaseIter.next();
                DBDSourceGenerator.genDFSCASEStmts(fieldMap, mappingCase, segmentModel, segmFieldLchildXdfldStmts);
                DBDSourceGenerator.genCaseFieldStmts(mappingCase, segmentModel, segmFieldLchildXdfldStmts);
            }
        }
    }

    private static void genSegmStmts(SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        if (segmentModel == null) {
            return;
        }
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        Object segmStmt = null;
        String segName = segmentModel.getImsName();
        segmStmt = segName != null ? "\n         SEGM  NAME=" + segName + "," : "\n         SEGM  ";
        if (catalogEnabled || dbdAccessType == DBDConstants.GSAM) {
            String segNameAlias = segmentModel.getName();
            segmStmt = segNameAlias != null ? (String)segmStmt + "EXTERNALNAME=" + segNameAlias : (String)segmStmt + "EXTERNALNAME=" + segName;
        }
        if (dbdAccessType == DBDConstants.HSAM || dbdAccessType == DBDConstants.SHSAM) {
            segmStmt = DBDSourceGenerator.addPARENT((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addBYTES((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addFREQ((String)segmStmt, segmentModel);
        } else if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM) {
            segmStmt = DBDSourceGenerator.addPARENT((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = segmentModel.getMaxBytes() == -1 ? DBDSourceGenerator.addSOURCE((String)segmStmt, segmentModel, dbdAccessType) : DBDSourceGenerator.addBYTES((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addFREQ((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addPOINTER((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addRULES((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addSEGMEXIT((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addCOMPRTN((String)segmStmt, segmentModel, dbdAccessType);
        } else if (dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
            segmStmt = DBDSourceGenerator.addPARENT((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addBYTES((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addFREQ((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addPOINTER((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addRULES((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addSEGMEXIT((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addDSGROUP((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addCOMPRTN((String)segmStmt, segmentModel, dbdAccessType);
        } else if (dbdAccessType == DBDConstants.MSDB) {
            segmStmt = DBDSourceGenerator.addBYTES((String)segmStmt, segmentModel);
        } else if (dbdAccessType == DBDConstants.DEDB) {
            segmStmt = DBDSourceGenerator.addPARENT((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addBYTES((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addTYPE((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addRULES((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addSSPTR((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addSEGMEXIT((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addCOMPRTN((String)segmStmt, segmentModel, dbdAccessType);
        } else if (dbdAccessType == DBDConstants.INDEX) {
            segmStmt = DBDSourceGenerator.addPARENT((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addBYTES((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addFREQ((String)segmStmt, segmentModel);
        } else if (dbdAccessType == DBDConstants.PSINDEX) {
            segmStmt = DBDSourceGenerator.addPARENT((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addBYTES((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addFREQ((String)segmStmt, segmentModel);
        } else if (dbdAccessType == DBDConstants.LOGICAL) {
            segmStmt = DBDSourceGenerator.addPARENT((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addSOURCE((String)segmStmt, segmentModel, dbdAccessType);
            segmStmt = DBDSourceGenerator.addFREQ((String)segmStmt, segmentModel);
        }
        if (catalogEnabled) {
            segmStmt = DBDSourceGenerator.addSegmEncoding((String)segmStmt, segmentModel);
            segmStmt = DBDSourceGenerator.addSegmRemarks((String)segmStmt, segmentModel);
        }
        segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt((String)segmStmt));
        DBDSourceGenerator.genFieldStmts(segmentModel, segmFieldLchildXdfldStmts);
        DBDSourceGenerator.genLchildStmts(segmentModel, segmFieldLchildXdfldStmts);
        if (catalogEnabled) {
            DBDSourceGenerator.genMaps(segmentModel, segmFieldLchildXdfldStmts);
        }
        for (SegmentModel child : segmentModel.getChildSegments()) {
            DBDSourceGenerator.genSegmStmts(child, segmFieldLchildXdfldStmts);
        }
    }

    private static void genFieldStmts(SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        Vector<FieldModel> fieldList = segmentModel.getFieldList(true, false);
        Vector<FieldModel> sysRelFields = segmentModel.getSysRelFieldList();
        if (sysRelFields != null) {
            fieldList.addAll(sysRelFields);
        }
        for (FieldModel fieldModel : fieldList) {
            DBDSourceGenerator.genOneFieldStmt(segmentModel, fieldModel, segmFieldLchildXdfldStmts);
        }
    }

    private static void genOneFieldStmt(SegmentModel segmentModel, FieldModel fieldModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        String fieldStmt = null;
        if (catalogEnabled || !fieldModel.getImsName().equals("") || dbdAccessType == DBDConstants.GSAM) {
            fieldStmt = "\n         ";
            if (dbdAccessType == DBDConstants.HSAM || dbdAccessType == DBDConstants.SHSAM || dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM || dbdAccessType == DBDConstants.MSDB || dbdAccessType == DBDConstants.DEDB || dbdAccessType == DBDConstants.INDEX || dbdAccessType == DBDConstants.PSINDEX || dbdAccessType == DBDConstants.GSAM) {
                fieldStmt = DBDSourceGenerator.addFieldNAME(fieldStmt, fieldModel, dbdAccessType);
                fieldStmt = DBDSourceGenerator.addFieldBYTES(fieldStmt, fieldModel, segmentModel);
                fieldStmt = DBDSourceGenerator.addFieldSTART(fieldStmt, fieldModel, segmentModel);
                fieldStmt = DBDSourceGenerator.addFieldTYPE(fieldStmt, fieldModel);
                if (catalogEnabled) {
                    fieldStmt = DBDSourceGenerator.addFieldDataTYPE(fieldStmt, fieldModel);
                    if (dbdAccessType != DBDConstants.MSDB && dbdAccessType != DBDConstants.GSAM) {
                        fieldStmt = DBDSourceGenerator.addDependsOn(fieldStmt, fieldModel);
                        fieldStmt = DBDSourceGenerator.addMinoccurs(fieldStmt, fieldModel);
                        fieldStmt = DBDSourceGenerator.addMaxoccurs(fieldStmt, fieldModel);
                        fieldStmt = DBDSourceGenerator.addFieldParent(fieldStmt, fieldModel);
                        fieldStmt = DBDSourceGenerator.addRedefines(fieldStmt, fieldModel);
                    }
                    fieldStmt = DBDSourceGenerator.addFieldRemarks(fieldStmt, fieldModel);
                }
            }
            segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt(fieldStmt));
        }
        if (catalogEnabled) {
            DBDSourceGenerator.genDFSMARSHStmts(fieldModel, segmFieldLchildXdfldStmts);
        }
    }

    private static void genArrayStructFieldStmts(SegmentModel segmentModel, FieldModel fieldModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        String fieldStmt = null;
        Vector<FieldModel> childFieldModelList = fieldModel.getFieldList();
        for (FieldModel childFieldModel : childFieldModelList) {
            if (childFieldModel.getImsName().equals("")) continue;
            fieldStmt = "\n         ";
            if (dbdAccessType == DBDConstants.HSAM || dbdAccessType == DBDConstants.SHSAM || dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM || dbdAccessType == DBDConstants.MSDB || dbdAccessType == DBDConstants.DEDB || dbdAccessType == DBDConstants.INDEX || dbdAccessType == DBDConstants.PSINDEX) {
                fieldStmt = DBDSourceGenerator.addFieldNAME(fieldStmt, childFieldModel, dbdAccessType);
                fieldStmt = DBDSourceGenerator.addFieldBYTES(fieldStmt, childFieldModel, segmentModel);
                fieldStmt = DBDSourceGenerator.addFieldSTART(fieldStmt, childFieldModel, segmentModel);
                fieldStmt = DBDSourceGenerator.addFieldTYPE(fieldStmt, childFieldModel);
                if (catalogEnabled) {
                    fieldStmt = DBDSourceGenerator.addFieldDataTYPE(fieldStmt, childFieldModel);
                    if (dbdAccessType != DBDConstants.MSDB) {
                        fieldStmt = DBDSourceGenerator.addDependsOn(fieldStmt, childFieldModel);
                        fieldStmt = DBDSourceGenerator.addMinoccurs(fieldStmt, childFieldModel);
                        fieldStmt = DBDSourceGenerator.addMaxoccurs(fieldStmt, childFieldModel);
                        fieldStmt = DBDSourceGenerator.addFieldParent(fieldStmt, fieldModel);
                        fieldStmt = DBDSourceGenerator.addRedefines(fieldStmt, childFieldModel);
                    }
                    fieldStmt = DBDSourceGenerator.addFieldRemarks(fieldStmt, childFieldModel);
                }
            }
            segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt(fieldStmt));
        }
    }

    private static void genCaseFieldStmts(MappingCaseModel mappingCase, SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) throws ModelException {
        String fieldStmt = null;
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        Vector<FieldModel> caseFieldList = mappingCase.getFieldList(true);
        for (FieldModel fieldModel : caseFieldList) {
            if (!fieldModel.getImsName().equals("") || !fieldModel.getName().equals("")) {
                fieldStmt = "\n         ";
                if (dbdAccessType == DBDConstants.HSAM || dbdAccessType == DBDConstants.SHSAM || dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM || dbdAccessType == DBDConstants.MSDB || dbdAccessType == DBDConstants.DEDB || dbdAccessType == DBDConstants.INDEX || dbdAccessType == DBDConstants.PSINDEX) {
                    fieldStmt = DBDSourceGenerator.addFieldNAME(fieldStmt, fieldModel, dbdAccessType);
                    fieldStmt = DBDSourceGenerator.addFieldBYTES(fieldStmt, fieldModel, segmentModel);
                    fieldStmt = DBDSourceGenerator.addFieldSTART(fieldStmt, fieldModel, segmentModel);
                    fieldStmt = DBDSourceGenerator.addFieldTYPE(fieldStmt, fieldModel);
                    if (catalogEnabled) {
                        fieldStmt = DBDSourceGenerator.addFieldDataTYPE(fieldStmt, fieldModel);
                        fieldStmt = DBDSourceGenerator.addCaseName(fieldStmt, mappingCase);
                        if (dbdAccessType != DBDConstants.MSDB) {
                            fieldStmt = DBDSourceGenerator.addDependsOn(fieldStmt, fieldModel);
                            fieldStmt = DBDSourceGenerator.addMinoccurs(fieldStmt, fieldModel);
                            fieldStmt = DBDSourceGenerator.addMaxoccurs(fieldStmt, fieldModel);
                            fieldStmt = DBDSourceGenerator.addFieldParent(fieldStmt, fieldModel);
                            fieldStmt = DBDSourceGenerator.addRedefines(fieldStmt, fieldModel);
                        }
                        fieldStmt = DBDSourceGenerator.addFieldRemarks(fieldStmt, fieldModel);
                    }
                }
                segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt(fieldStmt));
            }
            DBDSourceGenerator.genDFSMARSHStmts(fieldModel, segmFieldLchildXdfldStmts);
        }
    }

    private static void genDFSCASEStmts(MappingModel currentMap, MappingCaseModel currentCase, SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) {
        Object dfscaseStmt = null;
        String caseName = currentCase.getName();
        DependingOnFieldValueType dependingOnField = currentCase.getDependingOnFieldValue();
        String caseId = dependingOnField.getValue();
        ValueDatatypeType caseIdType = dependingOnField.getValueDatatype();
        String mapName = currentMap.getName();
        String caseComments = currentCase.getRemarks();
        if (caseName != null) {
            dfscaseStmt = "\n         DFSCASE ";
            dfscaseStmt = (String)dfscaseStmt + "NAME=" + caseName;
        }
        dfscaseStmt = (String)dfscaseStmt + ",CASEID=" + caseId;
        dfscaseStmt = (String)dfscaseStmt + ",CASEIDTYPE=" + String.valueOf((Object)caseIdType);
        dfscaseStmt = (String)dfscaseStmt + ",MAPNAME=" + mapName;
        if (caseComments != null && !caseComments.isEmpty()) {
            dfscaseStmt = (String)dfscaseStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(caseComments);
        }
        segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt((String)dfscaseStmt));
    }

    private static void genDFSMAPStmts(MappingModel newMap, SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) {
        Object dfsmapStmt = null;
        String newMapName = newMap.getName();
        String dependingOnField = newMap.getDependingOnField();
        String mapComments = newMap.getRemarks();
        String ctlSegnm = newMap.getControlSegmentName();
        if (newMapName != null & dependingOnField != null) {
            dfsmapStmt = "\n         DFSMAP ";
            dfsmapStmt = (String)dfsmapStmt + "NAME=" + newMapName;
        }
        dfsmapStmt = (String)dfsmapStmt + ",DEPENDINGON=" + dependingOnField;
        if (mapComments != null && !mapComments.isEmpty()) {
            dfsmapStmt = (String)dfsmapStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(mapComments);
        }
        if (ctlSegnm != null && !ctlSegnm.isEmpty() && !segmentModel.getImsName().equals(ctlSegnm)) {
            dfsmapStmt = (String)dfsmapStmt + ",CTLSEGNM=" + ctlSegnm;
        }
        segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt((String)dfsmapStmt));
    }

    private static void genDFSMARSHStmts(FieldModel fieldModel, ArrayList<String> segmFieldLchildXdfldStmts) {
        PhysicalDatatypeType typeConverter = fieldModel.getTypeConverter();
        String userTypeConverter = fieldModel.getUserTypeConverter();
        String pattern = fieldModel.getPattern();
        if (pattern != null || typeConverter != null || userTypeConverter != null) {
            String comments;
            String urlStr;
            MarshallerType marshallerType;
            DBDConstants isDbcs;
            Object dfsmarshStmt = null;
            int numProperties = fieldModel.getPropertyListSize();
            dfsmarshStmt = "\n         DFSMARSH ";
            String fieldEncodingOverride = fieldModel.getEncoding();
            if (fieldEncodingOverride != null && !fieldEncodingOverride.isEmpty() && typeConverter == PhysicalDatatypeType.CHAR) {
                dfsmarshStmt = (String)dfsmarshStmt + "ENCODING=" + fieldEncodingOverride;
            }
            if (typeConverter != null) {
                dfsmarshStmt = (String)dfsmarshStmt + ",INTERNALTYPECONVERTER=" + String.valueOf((Object)typeConverter);
            } else if (userTypeConverter != null) {
                dfsmarshStmt = (String)dfsmarshStmt + ",USERTYPECONVERTER=" + userTypeConverter;
                if (numProperties > 0) {
                    dfsmarshStmt = (String)dfsmarshStmt + ",PROPERTIES=(";
                    String name1 = fieldModel.getPropertyName(0);
                    String value1 = fieldModel.getPropertyValue(0);
                    String newStr1 = name1 + "=" + value1;
                    dfsmarshStmt = (String)dfsmarshStmt + newStr1;
                    int i = 1;
                    while (i < numProperties) {
                        String name = fieldModel.getPropertyName(i);
                        String value = fieldModel.getPropertyValue(i);
                        String newStr = name + "=" + value;
                        dfsmarshStmt = (String)dfsmarshStmt + "," + newStr;
                        ++i;
                    }
                    dfsmarshStmt = (String)dfsmarshStmt + ")";
                }
            }
            DBDConstants fieldDataType = fieldModel.getAppDatatype();
            if (fieldDataType == DBDConstants.CHAR && (isDbcs = fieldModel.getIsDbcs()) != null) {
                dfsmarshStmt = isDbcs == DBDConstants.Y ? (String)dfsmarshStmt + ",PUREDBCS=Y" : (String)dfsmarshStmt + ",PUREDBCS=N";
            }
            if (fieldDataType == DBDConstants.DECIMAL) {
                dfsmarshStmt = fieldModel.getIsSigned() != null ? (String)dfsmarshStmt + ",ISSIGNED=" + String.valueOf((Object)fieldModel.getIsSigned()) : (String)dfsmarshStmt + ",ISSIGNED=Y";
            }
            if (pattern != null && !pattern.isEmpty()) {
                char beginChar = pattern.charAt(0);
                char endChar = pattern.charAt(pattern.length() - 1);
                dfsmarshStmt = beginChar != '\'' ? (String)dfsmarshStmt + ",PATTERN='" + pattern : (String)dfsmarshStmt + ",PATTERN=" + pattern;
                if (endChar != '\'') {
                    dfsmarshStmt = (String)dfsmarshStmt + "'";
                }
            }
            if ((marshallerType = fieldModel.getMarshaller()) != null && (urlStr = marshallerType.getUrl()) != null && !urlStr.isEmpty()) {
                dfsmarshStmt = (String)dfsmarshStmt + ",URL='" + urlStr + "'";
            }
            if ((comments = fieldModel.getMarshallerRemarks()) != null && !comments.isEmpty()) {
                dfsmarshStmt = (String)dfsmarshStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(comments);
            }
            segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt((String)dfsmarshStmt));
        }
    }

    private static void genLchildStmts(SegmentModel segmentModel, ArrayList<String> segmFieldLchildXdfldStmts) {
        List<LogicalChildModel> lchildList;
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        if ((dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM || dbdAccessType == DBDConstants.INDEX || dbdAccessType == DBDConstants.DEDB || dbdAccessType == DBDConstants.PSINDEX) && (lchildList = segmentModel.getLogicalChildList()) != null) {
            String lchildStmt = null;
            for (LogicalChildModel lchildModel : lchildList) {
                lchildStmt = "\n         ";
                if (dbdAccessType == DBDConstants.HISAM) {
                    lchildStmt = DBDSourceGenerator.addLchildNAME(lchildStmt, lchildModel);
                    lchildStmt = DBDSourceGenerator.addLchildPOINTER(lchildStmt, lchildModel, segmentModel);
                    lchildStmt = DBDSourceGenerator.addLchildPAIR(lchildStmt, lchildModel);
                    lchildStmt = DBDSourceGenerator.addLchildRULES(lchildStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM) {
                    lchildStmt = DBDSourceGenerator.addLchildNAME(lchildStmt, lchildModel);
                    lchildStmt = DBDSourceGenerator.addLchildPOINTER(lchildStmt, lchildModel, segmentModel);
                    lchildStmt = DBDSourceGenerator.addLchildPAIR(lchildStmt, lchildModel);
                    lchildStmt = DBDSourceGenerator.addLchildRULES(lchildStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.DEDB) {
                    lchildStmt = DBDSourceGenerator.addFPLchildNAME(lchildStmt, lchildModel);
                    lchildStmt = DBDSourceGenerator.addLchildMULTISEG(lchildStmt, lchildModel);
                    lchildStmt = DBDSourceGenerator.addLchildPOINTER(lchildStmt, lchildModel, segmentModel);
                } else if (dbdAccessType == DBDConstants.INDEX) {
                    lchildStmt = DBDSourceGenerator.addLchildNAME(lchildStmt, lchildModel);
                    lchildStmt = DBDSourceGenerator.addLchildPOINTER(lchildStmt, lchildModel, segmentModel);
                    lchildStmt = DBDSourceGenerator.addLchildINDEX(lchildStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.PSINDEX) {
                    lchildStmt = DBDSourceGenerator.addLchildNAME(lchildStmt, lchildModel);
                    lchildStmt = DBDSourceGenerator.addLchildINDEX(lchildStmt, lchildModel);
                    lchildStmt = DBDSourceGenerator.addLchildRKSIZE(lchildStmt, lchildModel);
                }
                if (catalogEnabled) {
                    lchildStmt = DBDSourceGenerator.addLchildRemarks(lchildStmt, lchildModel);
                }
                segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt(lchildStmt));
                String xdfldName = lchildModel.getXdfldImsName();
                if (xdfldName == null) continue;
                String xdfldStmt = "\n         ";
                if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM) {
                    xdfldStmt = DBDSourceGenerator.addXdfldNAME(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldSEGMENT(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldCONST(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldSRCH(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldSUBSEQ(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldDDATA(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldNULLVAL(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldEXTRTN(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldREMARKS(xdfldStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
                    xdfldStmt = DBDSourceGenerator.addXdfldNAME(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldSEGMENT(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldSRCH(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldSUBSEQ(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldDDATA(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldNULLVAL(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldEXTRTN(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldREMARKS(xdfldStmt, lchildModel);
                } else if (dbdAccessType == DBDConstants.DEDB) {
                    xdfldStmt = DBDSourceGenerator.addXdfldNAME(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldSEGMENT(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldSRCH(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldSUBSEQ(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldDDATA(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldNULLVAL(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldEXTRTN(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldPSELRTN(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldPSELOPT(xdfldStmt, lchildModel);
                    xdfldStmt = DBDSourceGenerator.addXdfldREMARKS(xdfldStmt, lchildModel);
                }
                segmFieldLchildXdfldStmts.add(DBDSourceGenerator.wrapStmt(xdfldStmt));
            }
        }
    }

    private static String addXdfldPSELOPT(String xdfldStmt, LogicalChildModel lchildModel) {
        String pselopt = lchildModel.getPselopt();
        if (pselopt != null) {
            if (pselopt.equals(DBDConstants.M.value())) {
                xdfldStmt = (String)xdfldStmt + ",PSELOPT=MULT";
            } else if (pselopt.equals(DBDConstants.S.value())) {
                xdfldStmt = (String)xdfldStmt + ",PSELOPT=SNGL";
            }
        }
        return xdfldStmt;
    }

    private static String addXdfldPSELRTN(String xdfldStmt, LogicalChildModel lchildModel) {
        String pselrtn = lchildModel.getPselrtn();
        if (pselrtn != null) {
            xdfldStmt = (String)xdfldStmt + ",PSELRTN=" + pselrtn;
        }
        return xdfldStmt;
    }

    private static String addXdfldNULLVAL(String xdfldStmt, LogicalChildModel lchildModel) {
        String nullval = lchildModel.getXfldNullval();
        if (nullval != null) {
            xdfldStmt = (String)xdfldStmt + ",NULLVAL=" + nullval;
        }
        return xdfldStmt;
    }

    private static String addXdfldEXTRTN(String xdfldStmt, LogicalChildModel lchildModel) {
        String extrtn = lchildModel.getXfldIndexExitRoutine();
        if (extrtn != null) {
            xdfldStmt = (String)xdfldStmt + ",EXTRTN=" + extrtn;
        }
        return xdfldStmt;
    }

    public static String getXdfldSRCHString(LogicalChildModel lchildModel) {
        String retVal = DBDSourceGenerator.addXdfldSRCH("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addXdfldSRCH(String xdfldStmt, LogicalChildModel lchildModel) {
        List<String> srchList = lchildModel.getSearch();
        if (srchList != null) {
            if (srchList.size() == 1) {
                xdfldStmt = (String)xdfldStmt + ",SRCH=" + srchList.get(0);
            } else if (srchList.size() > 1) {
                boolean firstOne = true;
                for (String srch : srchList) {
                    if (firstOne) {
                        xdfldStmt = (String)xdfldStmt + ",SRCH=(" + srch;
                        firstOne = false;
                        continue;
                    }
                    xdfldStmt = (String)xdfldStmt + "," + srch;
                }
                xdfldStmt = (String)xdfldStmt + ")";
            }
        }
        return xdfldStmt;
    }

    public static String getXdfldSUBSEQString(LogicalChildModel lchildModel) {
        String retVal = DBDSourceGenerator.addXdfldSUBSEQ("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addXdfldSUBSEQ(String xdfldStmt, LogicalChildModel lchildModel) {
        List<String> subseqList = lchildModel.getSubsequence();
        if (subseqList != null) {
            if (subseqList.size() == 1) {
                xdfldStmt = (String)xdfldStmt + ",SUBSEQ=" + subseqList.get(0);
            } else if (subseqList.size() > 1) {
                boolean firstOne = true;
                for (String subseq : subseqList) {
                    if (firstOne) {
                        xdfldStmt = (String)xdfldStmt + ",SUBSEQ=(" + subseq;
                        firstOne = false;
                        continue;
                    }
                    xdfldStmt = (String)xdfldStmt + "," + subseq;
                }
                xdfldStmt = (String)xdfldStmt + ")";
            }
        }
        return xdfldStmt;
    }

    public static String getXdfldDDATAString(LogicalChildModel lchildModel) {
        String retVal = DBDSourceGenerator.addXdfldDDATA("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addXdfldDDATA(String xdfldStmt, LogicalChildModel lchildModel) {
        List<String> ddataList = lchildModel.getDuplicateData();
        if (ddataList != null) {
            if (ddataList.size() == 1) {
                xdfldStmt = (String)xdfldStmt + ",DDATA=" + ddataList.get(0);
            } else if (ddataList.size() > 1) {
                boolean firstOne = true;
                for (String ddata : ddataList) {
                    if (firstOne) {
                        xdfldStmt = (String)xdfldStmt + ",DDATA=(" + ddata;
                        firstOne = false;
                        continue;
                    }
                    xdfldStmt = (String)xdfldStmt + "," + ddata;
                }
                xdfldStmt = (String)xdfldStmt + ")";
            }
        }
        return xdfldStmt;
    }

    private static String addXdfldCONST(String xdfldStmt, LogicalChildModel lchildModel) {
        String xdfldconst = lchildModel.getXfldConst();
        if (xdfldconst != null) {
            xdfldStmt = (String)xdfldStmt + ",CONST=" + xdfldconst;
        }
        return xdfldStmt;
    }

    private static String addXdfldNAME(String xdfldStmt, LogicalChildModel lchildModel) {
        String name = lchildModel.getXdfldImsName();
        if (name != null) {
            String extName;
            xdfldStmt = (String)xdfldStmt + "XDFLD NAME=" + name;
            if (catalogEnabled && (extName = lchildModel.getXdfldName()) != null && !extName.equals(name)) {
                xdfldStmt = (String)xdfldStmt + ",EXTERNALNAME=" + extName;
            }
        }
        return xdfldStmt;
    }

    private static String addXdfldSEGMENT(String xdfldStmt, LogicalChildModel lchildModel) {
        String segment = lchildModel.getXfldSourceSegment();
        if (segment != null) {
            xdfldStmt = (String)xdfldStmt + ",SEGMENT=" + segment;
        }
        return xdfldStmt;
    }

    private static String addXdfldREMARKS(String xdfldStmt, LogicalChildModel lchildModel) {
        String remarks = lchildModel.getXdfldRemarks();
        if (remarks != null) {
            xdfldStmt = (String)xdfldStmt + ",REMARKS='" + remarks + "'";
        }
        return xdfldStmt;
    }

    private static String addLchildMULTISEG(String lchildStmt, LogicalChildModel lchildModel) {
        String multiseg = lchildModel.getMultiSeg();
        if (multiseg != null) {
            if (multiseg.equals("N")) {
                lchildStmt = (String)lchildStmt + ",MULTISEG=NO";
            } else if (multiseg.equals("Y")) {
                lchildStmt = (String)lchildStmt + ",MULTISEG=YES";
            }
        }
        return lchildStmt;
    }

    public static String getFPLchildNAME(LogicalChildModel lchildModel) {
        String retVal = DBDSourceGenerator.addFPLchildNAME("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(12);
    }

    private static String addFPLchildNAME(String lchildStmt, LogicalChildModel lchildModel) {
        String name = lchildModel.getName();
        if (name != null) {
            lchildStmt = (String)lchildStmt + "LCHILD NAME=(" + name;
            List<String> indexDbnames = lchildModel.getDedbSecondIxDbdNames();
            if (indexDbnames != null) {
                Iterator<String> iter = indexDbnames.iterator();
                if (indexDbnames.size() > 1) {
                    lchildStmt = (String)lchildStmt + ",(";
                    String dbname1 = iter.next();
                    lchildStmt = (String)lchildStmt + dbname1;
                    while (iter.hasNext()) {
                        String dbname = iter.next();
                        lchildStmt = (String)lchildStmt + "," + dbname;
                    }
                    lchildStmt = (String)lchildStmt + ")";
                } else {
                    lchildStmt = (String)lchildStmt + ",";
                    String dbname1 = iter.next();
                    lchildStmt = (String)lchildStmt + dbname1;
                }
            }
            lchildStmt = (String)lchildStmt + ")";
        }
        return lchildStmt;
    }

    private static String addLchildRemarks(String lchildStmt, LogicalChildModel lchildModel) {
        String comments = lchildModel.getLchildRemarks();
        if (comments != null && !comments.isEmpty()) {
            lchildStmt = (String)lchildStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(comments);
        }
        return lchildStmt;
    }

    private static String addLchildRULES(String lchildStmt, LogicalChildModel lchildModel) {
        DBDConstants rules = lchildModel.getRules();
        if (rules != null) {
            if (rules == DBDConstants.LAST) {
                lchildStmt = (String)lchildStmt + ",RULES=LAST";
            } else if (rules == DBDConstants.FIRST) {
                lchildStmt = (String)lchildStmt + ",RULES=FIRST";
            } else if (rules == DBDConstants.HERE) {
                lchildStmt = (String)lchildStmt + ",RULES=HERE";
            }
        } else {
            lchildStmt = (String)lchildStmt + ",RULES=LAST";
        }
        return lchildStmt;
    }

    private static String addLchildPAIR(String lchildStmt, LogicalChildModel lchildModel) {
        String pair = lchildModel.getPair();
        if (pair != null) {
            lchildStmt = (String)lchildStmt + ",PAIR=" + pair;
        }
        return lchildStmt;
    }

    private static String addLchildINDEX(String lchildStmt, LogicalChildModel lchildModel) {
        String index = lchildModel.getIndex();
        if (index != null) {
            lchildStmt = (String)lchildStmt + ",INDEX=" + index;
        }
        return lchildStmt;
    }

    private static String addLchildRKSIZE(String lchildStmt, LogicalChildModel lchildModel) {
        Integer rksize = lchildModel.getRootKeySize();
        if (rksize != null) {
            lchildStmt = (String)lchildStmt + ",RKSIZE=" + String.valueOf(rksize);
        }
        return lchildStmt;
    }

    private static String addLchildPOINTER(String lchildStmt, LogicalChildModel lchildModel, SegmentModel segmentModel) {
        DBDConstants pointer = lchildModel.getPointer();
        if (pointer != null) {
            lchildStmt = (String)lchildStmt + ",POINTER=" + String.valueOf((Object)pointer);
        }
        return lchildStmt;
    }

    public static String getLchildNAME(LogicalChildModel lchildModel) {
        String retVal = DBDSourceGenerator.addLchildNAME("", lchildModel);
        return retVal.isEmpty() ? "" : retVal.substring(12);
    }

    private static String addLchildNAME(String lchildStmt, LogicalChildModel lchildModel) {
        String name = lchildModel.getName();
        String dbname = lchildModel.getDbd();
        lchildStmt = dbname == null ? (String)lchildStmt + "LCHILD NAME=(" + name + ")" : (String)lchildStmt + "LCHILD NAME=(" + name + "," + dbname + ")";
        return lchildStmt;
    }

    private static String addFieldNAME(String fieldStmt, FieldModel fieldModel, DBDConstants dbdAccessType) {
        String name = fieldModel.getImsName();
        DBDConstants seqType = fieldModel.getSeqType();
        String fieldNameAlias = fieldModel.getName();
        if (name != null && name.length() > 0) {
            fieldStmt = (String)fieldStmt + "FIELD NAME=(" + name;
            if (seqType != null) {
                fieldStmt = (String)fieldStmt + ",SEQ," + String.valueOf((Object)seqType);
            }
            fieldStmt = (String)fieldStmt + ")";
            if (catalogEnabled && fieldNameAlias != null) {
                fieldStmt = (String)fieldStmt + ",EXTERNALNAME=" + fieldNameAlias;
            }
        } else if ((catalogEnabled || dbdAccessType == DBDConstants.GSAM) && fieldNameAlias != null) {
            fieldStmt = (String)fieldStmt + "FIELD EXTERNALNAME=" + fieldNameAlias;
        }
        return fieldStmt;
    }

    private static String addFieldRemarks(String fieldStmt, FieldModel fieldModel) {
        String comments = fieldModel.getRemarks();
        if (comments != null && !comments.isEmpty()) {
            fieldStmt = (String)fieldStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(comments);
        }
        return fieldStmt;
    }

    private static String addRedefines(String fieldStmt, FieldModel fieldModel) {
        String redefinesName = fieldModel.getRedefines();
        if (redefinesName != null) {
            fieldStmt = (String)fieldStmt + ",REDEFINES=" + redefinesName;
        }
        return fieldStmt;
    }

    private static String addFieldParent(String fieldStmt, FieldModel fieldModel) {
        FieldModel parentField = fieldModel.getParentField();
        if (parentField != null) {
            String parentName = parentField.getName();
            fieldStmt = (String)fieldStmt + ",PARENT=" + parentName;
        }
        return fieldStmt;
    }

    private static String addMaxoccurs(String fieldStmt, FieldModel fieldModel) {
        Integer maxOccurs;
        DBDConstants dataType = fieldModel.getAppDatatype();
        if (dataType == DBDConstants.ARRAY && (maxOccurs = fieldModel.getMaxOccurs()) != null) {
            fieldStmt = (String)fieldStmt + ",MAXOCCURS=" + maxOccurs.toString();
        }
        return fieldStmt;
    }

    private static String addMinoccurs(String fieldStmt, FieldModel fieldModel) {
        Integer minOccurs;
        DBDConstants dataType = fieldModel.getAppDatatype();
        if (dataType == DBDConstants.ARRAY && (minOccurs = fieldModel.getMinOccurs()) != null) {
            fieldStmt = (String)fieldStmt + ",MINOCCURS=" + minOccurs.toString();
        }
        return fieldStmt;
    }

    private static String addDependsOn(String fieldStmt, FieldModel fieldModel) {
        String dependsOnField = fieldModel.getDependsOn();
        if (dependsOnField != null && !dependsOnField.isEmpty()) {
            fieldStmt = (String)fieldStmt + ",DEPENDSON=" + dependsOnField;
        }
        return fieldStmt;
    }

    private static String addCaseName(String fieldStmt, MappingCaseModel mappingCase) {
        String caseName = mappingCase.getName();
        if (caseName != null) {
            fieldStmt = (String)fieldStmt + ",CASENAME=" + caseName;
        }
        return fieldStmt;
    }

    private static String addFieldDataTYPE(String fieldStmt, FieldModel fieldModel) {
        DBDConstants dataType = fieldModel.getAppDatatype();
        if (dataType != null) {
            if (dataType == DBDConstants.DECIMAL) {
                MarshallerType marshallerType;
                Integer precision = fieldModel.getPrecision();
                Integer scale = fieldModel.getScale();
                if (precision != null && scale != null) {
                    fieldStmt = (String)fieldStmt + ",DATATYPE=" + String.valueOf((Object)dataType);
                    fieldStmt = (String)fieldStmt + "(";
                    if (precision != null) {
                        if (precision == 0) {
                            precision = fieldModel.getBytes();
                        }
                        fieldStmt = (String)fieldStmt + String.valueOf(precision);
                    }
                    fieldStmt = (String)fieldStmt + ",";
                    if (scale != null) {
                        fieldStmt = (String)fieldStmt + String.valueOf(scale);
                    }
                    fieldStmt = (String)fieldStmt + ")";
                } else if (precision == null && scale == null && (marshallerType = fieldModel.getMarshaller()) != null && marshallerType.getUserTypeConverter() != null) {
                    List<PropertyType> properties = marshallerType.getProperty();
                    boolean scaleFound = false;
                    boolean precisionFound = false;
                    String scaleStr = null;
                    String precisionStr = null;
                    int i = 0;
                    while (i < properties.size()) {
                        if (properties.get(i).getName().trim().equalsIgnoreCase("scale")) {
                            scaleFound = true;
                            scaleStr = properties.get(i).getValue();
                        }
                        if (properties.get(i).getName().trim().equalsIgnoreCase("precision")) {
                            precisionFound = true;
                            precisionStr = properties.get(i).getValue();
                        }
                        if (scaleFound && precisionFound) break;
                        ++i;
                    }
                    Integer scale2 = 0;
                    Integer precision2 = 0;
                    if (scaleFound && precisionFound && scaleStr != null && precisionStr != null) {
                        try {
                            scale2 = Integer.valueOf(scaleStr);
                            precision2 = Integer.valueOf(precisionStr);
                        }
                        catch (NumberFormatException numberFormatException) {
                            scale2 = 0;
                            precision2 = 0;
                        }
                    }
                    fieldStmt = (String)fieldStmt + ",DATATYPE=" + String.valueOf((Object)dataType);
                    fieldStmt = (String)fieldStmt + "(";
                    if (precision2 != null) {
                        if (precision2 == 0) {
                            precision2 = fieldModel.getBytes();
                        }
                        fieldStmt = (String)fieldStmt + String.valueOf(precision2);
                    }
                    fieldStmt = (String)fieldStmt + ",";
                    if (scale2 != null) {
                        fieldStmt = (String)fieldStmt + String.valueOf(scale2);
                    }
                    fieldStmt = (String)fieldStmt + ")";
                }
            } else {
                fieldStmt = (String)fieldStmt + ",DATATYPE=" + String.valueOf((Object)dataType);
            }
        }
        return fieldStmt;
    }

    private static String addFieldTYPE(String fieldStmt, FieldModel fieldModel) {
        DBDConstants type = fieldModel.getImsDatatype();
        if (type != null) {
            fieldStmt = (String)fieldStmt + ",TYPE=" + String.valueOf((Object)type);
        }
        return fieldStmt;
    }

    private static String addFieldSTART(String fieldStmt, FieldModel fieldModel, SegmentModel segmentModel) {
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        int startPos = fieldModel.getStartPos();
        String startAfterField = fieldModel.getStartAfter();
        int relativeStartPos = fieldModel.getRelativeStart();
        DBDConstants appDataType = fieldModel.getAppDatatype();
        if (startPos > 0 || appDataType == DBDConstants.XML) {
            fieldStmt = (String)fieldStmt + ",START=" + Integer.toString(startPos);
        } else if (catalogEnabled && dbdAccessType != DBDConstants.MSDB) {
            if (startPos > 0) {
                fieldStmt = (String)fieldStmt + ",START=" + Integer.toString(startPos);
            } else if (startAfterField != null && !startAfterField.isEmpty()) {
                fieldStmt = (String)fieldStmt + ",STARTAFTER=" + startAfterField;
            } else if (relativeStartPos > 0) {
                fieldStmt = (String)fieldStmt + ",RELSTART=" + Integer.toString(relativeStartPos);
            }
        }
        return fieldStmt;
    }

    private static String addFieldBYTES(String fieldStmt, FieldModel fieldModel, SegmentModel segmentModel) {
        DBDConstants dbdAccessType = segmentModel.getDbdModel().getAccessType();
        int bytes = fieldModel.getBytes();
        int maxBytes = fieldModel.getMaxBytes();
        DBDConstants appDataType = fieldModel.getAppDatatype();
        if (bytes > 0 || appDataType == DBDConstants.XML) {
            fieldStmt = (String)fieldStmt + ",BYTES=" + Integer.toString(bytes);
        } else if (catalogEnabled && dbdAccessType != DBDConstants.MSDB && (maxBytes != 0 || !fieldModel.isSysRelField())) {
            fieldStmt = (String)fieldStmt + ",MAXBYTES=" + Integer.toString(maxBytes);
        }
        return fieldStmt;
    }

    public static String getSSPTRString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addSSPTR("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addSSPTR(String segmStmt, SegmentModel segmentModel) {
        int ssptr = segmentModel.getSsptr();
        if (ssptr != -1) {
            segmStmt = (String)segmStmt + ",SSPTR=" + Integer.toString(ssptr);
        }
        return segmStmt;
    }

    public static String getTYPEString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addTYPE("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addTYPE(String segmStmt, SegmentModel segmentModel) {
        String type = segmentModel.getDedbDependentSegmentType();
        if (type != null) {
            segmStmt = (String)segmStmt + ",TYPE=" + type;
        } else if (segmentModel.getParent() != null) {
            segmStmt = (String)segmStmt + ",TYPE=DIR";
        }
        return segmStmt;
    }

    public static String getDSGROUPString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addDSGROUP("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(9);
    }

    private static String addDSGROUP(String segmStmt, SegmentModel segmentModel) {
        String dsgroup = segmentModel.getDsgroup();
        segmStmt = dsgroup != null ? (String)segmStmt + ",DSGROUP=" + dsgroup : (String)segmStmt + ",DSGROUP=A";
        return segmStmt;
    }

    public static String getCOMPRTNString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addCOMPRTN("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(9);
    }

    private static String addCOMPRTN(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
            if (segmentModel.getComprtnRoutineName() != null) {
                String maxBytesNum;
                segmStmt = (String)segmStmt + ",COMPRTN=(" + segmentModel.getComprtnRoutineName();
                String modify = segmentModel.getComprtnModify();
                segmStmt = modify != null ? (String)segmStmt + "," + modify : (String)segmStmt + ",DATA";
                DBDConstants init = segmentModel.getComprtnInit();
                if (init != null && init == DBDConstants.Y) {
                    segmStmt = (String)segmStmt + ",INIT";
                }
                if ((maxBytesNum = segmentModel.getComprtnMaxBytesNumber()) != null && maxBytesNum != "-1") {
                    segmStmt = (String)segmStmt + "," + maxBytesNum;
                    DBDConstants pad = segmentModel.getComprtnMaxBytesPad();
                    if (pad != null && pad == DBDConstants.Y) {
                        segmStmt = (String)segmStmt + ",PAD";
                    }
                }
                segmStmt = (String)segmStmt + ")";
            }
        } else if (dbdAccessType == DBDConstants.DEDB && segmentModel.getComprtnRoutineName() != null) {
            segmStmt = (String)segmStmt + ",COMPRTN=(" + segmentModel.getDedbComprtnRoutineName();
            DBDConstants init = segmentModel.getDedbComprtnInit();
            DBDConstants data = segmentModel.getDedbComprtnData();
            if (init != null && data != null) {
                if (data == DBDConstants.Y) {
                    segmStmt = (String)segmStmt + ",DATA";
                }
                if (init == DBDConstants.Y) {
                    segmStmt = (String)segmStmt + ",INIT";
                }
            } else if (init != null) {
                if (init == DBDConstants.Y) {
                    segmStmt = (String)segmStmt + ",INIT";
                }
            } else if (data != null && data == DBDConstants.Y) {
                segmStmt = (String)segmStmt + ",DATA";
            }
            segmStmt = (String)segmStmt + ")";
        }
        return segmStmt;
    }

    public static String getRULESString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addRULES("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addRULES(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM || dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
            if (segmentModel.getInsertionRule() != null || segmentModel.getInsertionLocation() != null) {
                segmStmt = (String)segmStmt + ",RULES=(";
                if (segmentModel.getInsertionRule() != null) {
                    segmStmt = (String)segmStmt + segmentModel.getInsertionRule();
                    segmStmt = (String)segmStmt + segmentModel.getDeletionRule();
                    segmStmt = (String)segmStmt + segmentModel.getReplacementRule();
                }
                segmStmt = segmentModel.getInsertionLocation() != null ? (String)segmStmt + "," + segmentModel.getInsertionLocation() + ")" : (String)segmStmt + ",LAST)";
            }
        } else if (dbdAccessType == DBDConstants.DEDB) {
            segmStmt = (String)segmStmt + ",RULES=";
            if (segmentModel.getInsertionLocation() != null) {
                segmStmt = (String)segmStmt + "(," + segmentModel.getInsertionLocation() + ")";
            } else {
                String dedbSegmentType = segmentModel.getDedbDependentSegmentType();
                if (dedbSegmentType == null || dedbSegmentType.equals("DIR")) {
                    segmStmt = (String)segmStmt + "(,HERE)";
                } else if (dedbSegmentType.equals("SEQ")) {
                    segmStmt = (String)segmStmt + "(,FIRST)";
                }
            }
        }
        return segmStmt;
    }

    public static String getPOINTERString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addPOINTER("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(9);
    }

    private static String addPOINTER(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        DBDConstants physPtr = segmentModel.getPhysicalPointer();
        DBDConstants logPtr = segmentModel.getLogicalPointer();
        DBDConstants LparntVal = segmentModel.getLparnt();
        DBDConstants CtrVal = segmentModel.getCtr();
        DBDConstants PairedVal = segmentModel.getPaired();
        boolean firstParm = true;
        if (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM) {
            if (physPtr != null || logPtr != null || LparntVal == DBDConstants.Y || CtrVal == DBDConstants.Y || PairedVal == DBDConstants.Y) {
                segmStmt = (String)segmStmt + ",POINTER=(";
                if (physPtr != null) {
                    segmStmt = (String)segmStmt + String.valueOf((Object)physPtr);
                    firstParm = false;
                }
                if (logPtr != null) {
                    if (firstParm) {
                        segmStmt = (String)segmStmt + String.valueOf((Object)logPtr);
                        firstParm = false;
                    } else {
                        segmStmt = (String)segmStmt + "," + String.valueOf((Object)logPtr);
                    }
                }
                if (LparntVal == DBDConstants.Y) {
                    if (firstParm) {
                        segmStmt = (String)segmStmt + "LPARNT";
                        firstParm = false;
                    } else {
                        segmStmt = (String)segmStmt + ",LPARNT";
                    }
                }
                if (CtrVal == DBDConstants.Y) {
                    if (firstParm) {
                        segmStmt = (String)segmStmt + "CTR";
                        firstParm = false;
                    } else {
                        segmStmt = (String)segmStmt + ",CTR";
                    }
                }
                if (PairedVal == DBDConstants.Y) {
                    if (firstParm) {
                        segmStmt = (String)segmStmt + "PAIRED";
                        firstParm = false;
                    } else {
                        segmStmt = (String)segmStmt + ",PAIRED";
                    }
                }
                segmStmt = (String)segmStmt + ")";
            }
        } else if (!(dbdAccessType != DBDConstants.PHDAM && dbdAccessType != DBDConstants.PHIDAM || physPtr == null && LparntVal != DBDConstants.Y && PairedVal != DBDConstants.Y)) {
            segmStmt = (String)segmStmt + ",POINTER=(";
            if (physPtr != null) {
                segmStmt = (String)segmStmt + String.valueOf((Object)physPtr);
                firstParm = false;
            }
            if (LparntVal == DBDConstants.Y) {
                if (firstParm) {
                    segmStmt = (String)segmStmt + "LPARNT";
                    firstParm = false;
                } else {
                    segmStmt = (String)segmStmt + ",LPARNT";
                }
            }
            if (PairedVal == DBDConstants.Y) {
                if (firstParm) {
                    segmStmt = (String)segmStmt + "PAIRED";
                    firstParm = false;
                } else {
                    segmStmt = (String)segmStmt + ",PAIRED";
                    firstParm = false;
                }
            }
            segmStmt = (String)segmStmt + ")";
        }
        return segmStmt;
    }

    public static String getSOURCEString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addSOURCE("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addSOURCE(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        if (dbdAccessType == DBDConstants.LOGICAL) {
            if (segmentModel.getLogicalChildSourceSegName() == null) {
                segmStmt = (String)segmStmt + ",SOURCE=((" + segmentModel.getSegmentSourceSegName();
                DBDConstants sourceChildData = segmentModel.getSegmentSourceData();
                if (sourceChildData != null) {
                    segmStmt = sourceChildData == DBDConstants.Y ? (String)segmStmt + ",DATA," : (String)segmStmt + ",KEY,";
                }
                segmStmt = (String)segmStmt + segmentModel.getSegmentSourceDBName() + ")";
            } else {
                segmStmt = (String)segmStmt + ",SOURCE=((" + segmentModel.getLogicalChildSourceSegName();
                DBDConstants sourceChildData = segmentModel.getLogicalChildSourceData();
                if (sourceChildData != null) {
                    segmStmt = sourceChildData == DBDConstants.Y ? (String)segmStmt + ",DATA," : (String)segmStmt + ",KEY,";
                }
                segmStmt = (String)segmStmt + segmentModel.getLogicalChildSourceDBName() + "),";
                String targetParentSegName = segmentModel.getTargetParentSourceSegName();
                if (targetParentSegName != null) {
                    segmStmt = (String)segmStmt + "(" + targetParentSegName;
                    DBDConstants targetParentData = segmentModel.getTargetParentSourceData();
                    if (targetParentData != null) {
                        segmStmt = targetParentData == DBDConstants.Y ? (String)segmStmt + ",DATA," : (String)segmStmt + ",KEY,";
                    }
                    segmStmt = (String)segmStmt + segmentModel.getTargetParentSourceDBName() + ")";
                }
            }
        } else {
            segmStmt = (String)segmStmt + ",SOURCE=((" + segmentModel.getSegmentSourceSegName();
            DBDConstants sourceChildData = segmentModel.getSegmentSourceData();
            if (sourceChildData != null) {
                segmStmt = sourceChildData == DBDConstants.Y ? (String)segmStmt + ",DATA," : (String)segmStmt + ",KEY,";
            }
            segmStmt = (String)segmStmt + segmentModel.getSegmentSourceDBName() + ")";
        }
        segmStmt = (String)segmStmt + ")";
        return segmStmt;
    }

    public static String getFREQString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addFREQ("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addSegmEncoding(String segmStmt, SegmentModel segmentModel) {
        String segmentEncodingOverride = segmentModel.getEncoding();
        if (segmentEncodingOverride != null && !segmentEncodingOverride.isEmpty()) {
            segmStmt = (String)segmStmt + ",ENCODING=" + segmentEncodingOverride;
        }
        return segmStmt;
    }

    private static String addSegmRemarks(String segmStmt, SegmentModel segmentModel) {
        String comments = segmentModel.getRemarks();
        if (comments != null && !comments.isEmpty()) {
            segmStmt = (String)segmStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(comments);
        }
        return segmStmt;
    }

    private static String addFREQ(String segmStmt, SegmentModel segmentModel) {
        BigDecimal freq = segmentModel.getFreq();
        if (freq != null) {
            segmStmt = (String)segmStmt + ",FREQ=" + String.valueOf(freq);
        }
        return segmStmt;
    }

    private static String addBYTES(String segmStmt, SegmentModel segmentModel) {
        int maxBytes = segmentModel.getMaxBytes();
        int minBytes = segmentModel.getMinBytes();
        segmStmt = minBytes == -1 ? (String)segmStmt + ",BYTES=" + maxBytes : (String)segmStmt + ",BYTES=(" + maxBytes + "," + minBytes + ")";
        return segmStmt;
    }

    public static String getPARENTString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addPARENT("", segmentModel, segmentModel.getDbdModel().getAccessType());
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addPARENT(String segmStmt, SegmentModel segmentModel, DBDConstants dbdAccessType) {
        if (segmentModel.getParent() == null) {
            segmStmt = (String)segmStmt + ",PARENT=0";
        } else if (dbdAccessType == DBDConstants.HSAM || dbdAccessType == DBDConstants.LOGICAL) {
            segmStmt = (String)segmStmt + ",PARENT=" + segmentModel.getParent().getImsName();
        } else if (dbdAccessType == DBDConstants.INDEX || dbdAccessType == DBDConstants.PSINDEX) {
            segmStmt = (String)segmStmt + ",PARENT=0";
        } else if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM) {
            String logicalParentStr = segmentModel.getLogicalParentName();
            if (logicalParentStr == null) {
                segmStmt = (String)segmStmt + ",PARENT=" + segmentModel.getParent().getImsName();
            } else {
                String lpckStr = segmentModel.getLogicalParentLpck();
                String logicalParentDbdStr = segmentModel.getLogicalParentDbdName();
                segmStmt = (String)segmStmt + ",PARENT=(" + segmentModel.getParent().getImsName();
                segmStmt = (String)segmStmt + ",(" + logicalParentStr;
                segmStmt = lpckStr != null ? (String)segmStmt + "," + lpckStr : (String)segmStmt + ",VIRTUAL";
                if (logicalParentDbdStr != null) {
                    segmStmt = (String)segmStmt + "," + logicalParentDbdStr;
                }
                segmStmt = (String)segmStmt + "))";
            }
        } else if (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.HIDAM || dbdAccessType == DBDConstants.PHIDAM) {
            segmStmt = (String)segmStmt + ",PARENT=((" + segmentModel.getParent().getImsName();
            String physicalChildPointer = segmentModel.getPhysicalChildPointer();
            if (physicalChildPointer != null) {
                segmStmt = (String)segmStmt + "," + physicalChildPointer;
            }
            segmStmt = (String)segmStmt + ")";
            String logicalParentStr = segmentModel.getLogicalParentName();
            if (logicalParentStr != null) {
                String lpckStr = segmentModel.getLogicalParentLpck();
                String logicalParentDbdStr = segmentModel.getLogicalParentDbdName();
                segmStmt = (String)segmStmt + ",(" + logicalParentStr;
                if (lpckStr != null) {
                    segmStmt = (String)segmStmt + "," + lpckStr;
                } else {
                    if (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM) {
                        segmStmt = (String)segmStmt + ",VIRTUAL";
                    }
                    if (dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
                        segmStmt = (String)segmStmt + ",PHYSICAL";
                    }
                }
                if (logicalParentDbdStr != null) {
                    segmStmt = (String)segmStmt + "," + logicalParentDbdStr;
                }
                segmStmt = (String)segmStmt + ")";
            }
            segmStmt = (String)segmStmt + ")";
        } else if (dbdAccessType == DBDConstants.DEDB) {
            segmStmt = (String)segmStmt + ",PARENT=((" + segmentModel.getParent().getImsName();
            String physicalChildPointer = segmentModel.getPhysicalChildPointer();
            if (physicalChildPointer != null) {
                segmStmt = (String)segmStmt + "," + physicalChildPointer;
            }
            segmStmt = (String)segmStmt + "))";
        }
        return segmStmt;
    }

    public static String getBLOCKString(DbdModel dbdModel) {
        String retVal = DBDSourceGenerator.addBLOCK("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addBLOCK(String datasetStmt, DbdModel dbdModel) {
        int blkfact1 = dbdModel.getBLOCKBlkfact1();
        if (blkfact1 != -1) {
            int blkfact2;
            datasetStmt = (String)datasetStmt + ",BLOCK=(" + Integer.toString(blkfact1);
            if (dbdModel.getAccessType() != DBDConstants.GSAM && (blkfact2 = dbdModel.getBLOCKBlkfact2()) != -1) {
                datasetStmt = (String)datasetStmt + "," + Integer.toString(blkfact2);
            }
            datasetStmt = (String)datasetStmt + ")";
        }
        return datasetStmt;
    }

    private static String addDEVICE(String datasetStmt, DbdModel dbdModel) {
        String device = dbdModel.getDevice();
        datasetStmt = (String)datasetStmt + ",DEVICE=" + device;
        return datasetStmt;
    }

    public static String getRECORDString(DbdModel dbdModel) {
        String retVal = DBDSourceGenerator.addRECORD("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addRECORD(String datasetStmt, DbdModel dbdModel) {
        Integer reclen1Int = dbdModel.getRECORDReclen1();
        if (reclen1Int != null && reclen1Int != 0) {
            String reclen1 = reclen1Int.toString();
            datasetStmt = (String)datasetStmt + ",RECORD=(" + reclen1;
            Integer reclen2Int = dbdModel.getRECORDReclen2();
            if (dbdModel.getAccessType() != DBDConstants.INDEX && reclen2Int != 0) {
                String reclen2 = reclen2Int.toString();
                datasetStmt = (String)datasetStmt + "," + reclen2;
            }
            datasetStmt = (String)datasetStmt + ")";
        }
        return datasetStmt;
    }

    public static String getOVFLWString(DbdModel dbdModel) {
        String retVal = DBDSourceGenerator.addOVFLW("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(7);
    }

    private static String addOVFLW(String datasetStmt, DbdModel dbdModel) {
        String ovflw = dbdModel.getOvflw();
        if (ovflw != null) {
            datasetStmt = (String)datasetStmt + ",OVFLW=" + dbdModel.getOvflw();
        }
        return datasetStmt;
    }

    public static String getSizeString(DbdModel dbdModel) {
        String retVal = DBDSourceGenerator.addSIZE("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addSIZE(String datasetStmt, DbdModel dbdModel) {
        Integer size1Int;
        if (dbdModel.getAccessType() == DBDConstants.GSAM) {
            Integer size1Int2 = dbdModel.getSize1();
            if (size1Int2 != null) {
                String size1 = size1Int2.toString();
                datasetStmt = (String)datasetStmt + ",SIZE=" + size1;
            }
        } else if ((dbdModel.getAccessType() == DBDConstants.HISAM || dbdModel.getAccessType() == DBDConstants.SHISAM || dbdModel.getAccessType() == DBDConstants.INDEX) && (size1Int = dbdModel.getSize1()) != null) {
            String size1 = size1Int.toString();
            datasetStmt = (String)datasetStmt + ",SIZE=(" + size1;
            Integer size2Int = dbdModel.getSize2();
            if (size2Int != null && size2Int > 0) {
                String size2 = size2Int.toString();
                datasetStmt = (String)datasetStmt + "," + size2;
            }
            datasetStmt = (String)datasetStmt + ")";
        }
        return datasetStmt;
    }

    private static String genHdamDatasetStmt(HidamDataSetModel hdamDataset) {
        Object datasetStmt = null;
        String label = hdamDataset.getLabel();
        boolean labelUsedAlready = false;
        if (label == null) {
            datasetStmt = "\n         DATASET";
        } else {
            int spacesNeeded = 9 - label.length();
            Object spaces = "";
            int j = 0;
            while (j < spacesNeeded) {
                spaces = (String)spaces + " ";
                ++j;
            }
            datasetStmt = "\n" + label + (String)spaces + "DATASET";
            int i = 0;
            while (i < usedDatasetLabels.size() && !labelUsedAlready) {
                if (label.equals(usedDatasetLabels.get(i))) {
                    labelUsedAlready = true;
                }
                ++i;
            }
        }
        if (!labelUsedAlready) {
            if (label != null) {
                usedDatasetLabels.add(label);
            }
            datasetStmt = (String)datasetStmt + " DD1=" + hdamDataset.getDdname1();
            datasetStmt = (String)datasetStmt + ",DEVICE=" + hdamDataset.getDevice();
            int blockSize0 = hdamDataset.getSize0();
            int sizeSize1 = hdamDataset.getSize1();
            if (blockSize0 > 0 && sizeSize1 <= 0) {
                datasetStmt = (String)datasetStmt + ",BLOCK=" + Integer.toString(blockSize0);
            }
            if (sizeSize1 > 0 && blockSize0 <= 0) {
                datasetStmt = (String)datasetStmt + ",SIZE=" + Integer.toString(sizeSize1);
            }
            int cyls = hdamDataset.getCyls();
            datasetStmt = (String)datasetStmt + ",SCAN=" + Integer.toString(cyls);
            int fbff = hdamDataset.getFbff();
            int fspf = hdamDataset.getFspf();
            datasetStmt = (String)datasetStmt + ",FRSPC=(" + Integer.toString(fbff) + "," + Integer.toString(fspf) + ")";
            int searcha = hdamDataset.getSearcha();
            datasetStmt = (String)datasetStmt + ",SEARCHA=" + Integer.toString(searcha);
            if (catalogEnabled) {
                datasetStmt = DBDSourceGenerator.addHdamDatasetRemarks((String)datasetStmt, hdamDataset);
            }
        }
        return DBDSourceGenerator.wrapStmt((String)datasetStmt);
    }

    private static String genDatasetStmt(DbdModel dbdModel) {
        Object datasetStmt = null;
        if (dbdModel.getAccessType() == DBDConstants.HSAM || dbdModel.getAccessType() == DBDConstants.SHSAM) {
            datasetStmt = "\n         DATASET DD1=" + dbdModel.getDataSetDdname1();
            datasetStmt = (String)datasetStmt + ",DD2=" + dbdModel.getDdname2();
            datasetStmt = DBDSourceGenerator.addDEVICE((String)datasetStmt, dbdModel);
            datasetStmt = DBDSourceGenerator.addBLOCK((String)datasetStmt, dbdModel);
            datasetStmt = DBDSourceGenerator.addRECORD((String)datasetStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.GSAM) {
            datasetStmt = "\n         DATASET DD1=" + dbdModel.getDataSetDdname1();
            if (dbdModel.getDdname2() != null) {
                datasetStmt = (String)datasetStmt + ",DD2=" + dbdModel.getDdname2();
            }
            datasetStmt = DBDSourceGenerator.addDEVICE((String)datasetStmt, dbdModel);
            datasetStmt = DBDSourceGenerator.addBLOCK((String)datasetStmt, dbdModel);
            datasetStmt = DBDSourceGenerator.addSIZE((String)datasetStmt, dbdModel);
            datasetStmt = DBDSourceGenerator.addRECORD((String)datasetStmt, dbdModel);
            datasetStmt = (String)datasetStmt + ",RECFM=" + dbdModel.getRecfm().toString();
        } else if (dbdModel.getAccessType() == DBDConstants.HISAM || dbdModel.getAccessType() == DBDConstants.SHISAM || dbdModel.getAccessType() == DBDConstants.INDEX) {
            datasetStmt = "\n         DATASET DD1=" + dbdModel.getDataSetDdname1();
            datasetStmt = DBDSourceGenerator.addDEVICE((String)datasetStmt, dbdModel);
            datasetStmt = DBDSourceGenerator.addOVFLW((String)datasetStmt, dbdModel);
            datasetStmt = DBDSourceGenerator.addBLOCK((String)datasetStmt, dbdModel);
            datasetStmt = DBDSourceGenerator.addSIZE((String)datasetStmt, dbdModel);
            datasetStmt = DBDSourceGenerator.addRECORD((String)datasetStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.MSDB) {
            datasetStmt = "\n         DATASET ,REL=(" + dbdModel.getRelType();
            String fldnm = dbdModel.getRelFldnm();
            if (fldnm != null) {
                datasetStmt = (String)datasetStmt + "," + fldnm;
            }
            datasetStmt = (String)datasetStmt + ")";
        } else if (dbdModel.getAccessType() == DBDConstants.LOGICAL) {
            datasetStmt = "\n         DATASET LOGICAL";
        }
        if (catalogEnabled) {
            datasetStmt = DBDSourceGenerator.addDatasetRemarks((String)datasetStmt, dbdModel);
        }
        return DBDSourceGenerator.wrapStmt((String)datasetStmt);
    }

    public static String getACCESSString(DbdModel dbdModel) {
        Object accessType = dbdModel.getAccessType().value();
        if (dbdModel.getAccessType() == DBDConstants.GSAM || dbdModel.getAccessType() == DBDConstants.HISAM || dbdModel.getAccessType() == DBDConstants.SHISAM || dbdModel.getAccessType() == DBDConstants.HDAM || dbdModel.getAccessType() == DBDConstants.PHDAM || dbdModel.getAccessType() == DBDConstants.HIDAM || dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            accessType = "(" + (String)accessType + "," + dbdModel.getOsAccess() + ")";
        } else if (dbdModel.getAccessType() == DBDConstants.INDEX || dbdModel.getAccessType() == DBDConstants.PSINDEX) {
            IndexType indexType = dbdModel.getDbd().getAccess().getIndex();
            accessType = indexType != null ? "(" + (String)accessType + "," + String.valueOf((Object)indexType.getOsAccess()) : "(" + (String)accessType + ",VSAM";
            accessType = DBDSourceGenerator.addPROT((String)accessType, dbdModel);
            if (dbdModel.getAccessType() == DBDConstants.INDEX) {
                accessType = DBDSourceGenerator.addDOSCOMP((String)accessType, dbdModel);
            }
            accessType = (String)accessType + ")";
        }
        return accessType;
    }

    private static String genDBDStmt(DbdModel dbdModel) {
        Object dbdStmt = null;
        dbdStmt = "         DBD   NAME=";
        if (dbdModel.getAccessType() == DBDConstants.HSAM) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=HSAM";
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.SHSAM) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=SHSAM";
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.GSAM) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=(GSAM,";
            dbdStmt = (String)dbdStmt + dbdModel.getOsAccess() + ")";
            dbdStmt = DBDSourceGenerator.addPASSWD((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.HISAM) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=(HISAM,";
            dbdStmt = (String)dbdStmt + dbdModel.getOsAccess() + ")";
            dbdStmt = DBDSourceGenerator.addPASSWD((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBDEXIT((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.SHISAM) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=(SHISAM,";
            dbdStmt = (String)dbdStmt + dbdModel.getOsAccess() + ")";
            dbdStmt = DBDSourceGenerator.addPASSWD((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBDEXIT((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.HDAM) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=(HDAM,";
            dbdStmt = (String)dbdStmt + dbdModel.getOsAccess() + ")";
            dbdStmt = DBDSourceGenerator.addHdamRMNAME((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addPASSWD((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBDEXIT((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBVER((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.PHDAM) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=(PHDAM,";
            dbdStmt = (String)dbdStmt + dbdModel.getOsAccess() + ")";
            dbdStmt = DBDSourceGenerator.addHdamRMNAME((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addPASSWD((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBDEXIT((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBVER((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addPSNAME((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.HIDAM) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=(HIDAM,";
            dbdStmt = (String)dbdStmt + dbdModel.getOsAccess() + ")";
            dbdStmt = DBDSourceGenerator.addPASSWD((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBDEXIT((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBVER((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=(PHIDAM,";
            dbdStmt = (String)dbdStmt + dbdModel.getOsAccess() + ")";
            dbdStmt = DBDSourceGenerator.addPASSWD((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBDEXIT((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBVER((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addPSNAME((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.MSDB) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=MSDB";
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = (String)dbdStmt + ",PASSWD=NO";
        } else if (dbdModel.getAccessType() == DBDConstants.DEDB) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=DEDB";
            dbdStmt = DBDSourceGenerator.addDedbRMNAME((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBDEXIT((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBVER((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.INDEX) {
            dbdStmt = "         DBD   NAME=(" + dbdModel.getDBDName();
            dbdStmt = DBDSourceGenerator.addSecondaryIxDBDNames((String)dbdStmt, dbdModel);
            dbdStmt = (String)dbdStmt + "),";
            dbdStmt = (String)dbdStmt + "ACCESS=(INDEX,";
            dbdStmt = (String)dbdStmt + dbdModel.getOsAccess();
            dbdStmt = DBDSourceGenerator.addPROT((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDOSCOMP((String)dbdStmt, dbdModel);
            dbdStmt = (String)dbdStmt + ")";
            dbdStmt = DBDSourceGenerator.addPASSWD((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addFPINDEX((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.PSINDEX) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=(PSINDEX,VSAM";
            dbdStmt = DBDSourceGenerator.addPROT((String)dbdStmt, dbdModel);
            dbdStmt = (String)dbdStmt + ")";
            dbdStmt = DBDSourceGenerator.addPASSWD((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDATXEXIT((String)dbdStmt, dbdModel);
        } else if (dbdModel.getAccessType() == DBDConstants.LOGICAL) {
            dbdStmt = (String)dbdStmt + dbdModel.getDBDName() + ",";
            dbdStmt = (String)dbdStmt + "ACCESS=LOGICAL";
            dbdStmt = DBDSourceGenerator.addVERSION((String)dbdStmt, dbdModel);
            dbdStmt = (String)dbdStmt + ",PASSWD=NO";
        }
        if (catalogEnabled) {
            dbdStmt = DBDSourceGenerator.addDBDEncoding((String)dbdStmt, dbdModel);
            dbdStmt = DBDSourceGenerator.addDBDRemarks((String)dbdStmt, dbdModel);
        }
        return DBDSourceGenerator.wrapStmt((String)dbdStmt);
    }

    private static String addDBDRemarks(String dbdStmt, DbdModel dbdModel) {
        String comments = dbdModel.getRemarks();
        if (comments != null && !comments.isEmpty()) {
            dbdStmt = (String)dbdStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(comments);
        }
        return dbdStmt;
    }

    private static String addHdamDatasetRemarks(String datasetStmt, HidamDataSetModel dataset) {
        String comments = dataset.getRemarks();
        if (comments != null && !comments.isEmpty()) {
            datasetStmt = (String)datasetStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(comments);
        }
        return datasetStmt;
    }

    private static String addDatasetRemarks(String datasetStmt, DbdModel dbdModel) {
        String comments = dbdModel.getDatasetRemarks();
        if (comments != null && !comments.isEmpty()) {
            datasetStmt = (String)datasetStmt + ",REMARKS=" + DBDSourceGenerator.remarksHelper(comments);
        }
        return datasetStmt;
    }

    private static String addDBDEncoding(String dbdStmt, DbdModel dbdModel) {
        String dbdEncoding = dbdModel.getEncoding();
        dbdStmt = dbdEncoding != null && !dbdEncoding.isEmpty() ? (String)dbdStmt + ",ENCODING=" + dbdEncoding : (String)dbdStmt + ",ENCODING=Cp1047";
        return dbdStmt;
    }

    private static String addFPINDEX(String dbdStmt, DbdModel dbdModel) {
        YesnoType fpIndex = dbdModel.getFPindex();
        if (fpIndex != null && fpIndex.equals((Object)YesnoType.Y)) {
            dbdStmt = (String)dbdStmt + ",FPINDEX=YES";
        }
        return dbdStmt;
    }

    private static String addPASSWD(String dbdStmt, DbdModel dbdModel) {
        String passWd = dbdModel.isPassword();
        YesnoType passYN = YesnoType.valueOf(passWd);
        if (passWd != null) {
            if (passYN.equals((Object)YesnoType.Y)) {
                dbdStmt = (String)dbdStmt + ",PASSWD=YES";
            } else if (passYN.equals((Object)YesnoType.N)) {
                dbdStmt = (String)dbdStmt + ",PASSWD=NO";
            }
        }
        return dbdStmt;
    }

    public static String getDBDEXITString(DbdModel dbdModel) {
        String retVal = DBDSourceGenerator.addDBDEXIT("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addDBDEXIT(String dbdStmt, DbdModel dbdModel) {
        List<DataExitRoutine> extiRoutineList = dbdModel.getDataCaptureExitRoutines();
        if (extiRoutineList != null && extiRoutineList.size() != 0) {
            dbdStmt = (String)dbdStmt + ",EXIT=";
            Iterator<DataExitRoutine> iter = extiRoutineList.iterator();
            while (iter.hasNext()) {
                DBDConstants cascade;
                DBDConstants ynInpos;
                DataExitRoutine extiRoutine = iter.next();
                dbdStmt = (String)dbdStmt + "(" + extiRoutine.getExitName();
                if (extiRoutine.getLog() != null) {
                    dbdStmt = (String)dbdStmt + "," + (extiRoutine.getLog() == DBDConstants.Y ? "LOG" : "NOLOG");
                }
                if (extiRoutine.getExitKey() != null) {
                    dbdStmt = (String)dbdStmt + "," + (extiRoutine.getExitKey() == DBDConstants.Y ? "KEY" : "NOKEY");
                }
                if (extiRoutine.getExitPath() != null) {
                    dbdStmt = (String)dbdStmt + "," + (extiRoutine.getExitPath() == DBDConstants.Y ? "PATH" : "NOPATH");
                }
                if (extiRoutine.getExitData() != null) {
                    dbdStmt = (String)dbdStmt + "," + (extiRoutine.getExitData() == DBDConstants.Y ? "DATA" : "NODATA");
                }
                if (dbdModel.getAccessType() == DBDConstants.DEDB) {
                    DBDConstants ynFld;
                    DBDConstants ynSspcmd;
                    if (extiRoutine.getBefore() != null) {
                        dbdStmt = (String)dbdStmt + "," + (extiRoutine.getBefore() == DBDConstants.Y ? "BEFORE" : "NOBEFORE");
                    }
                    if (extiRoutine.getDlet() != null) {
                        dbdStmt = (String)dbdStmt + "," + (extiRoutine.getDlet() == DBDConstants.Y ? "DLET" : "NODLET");
                    }
                    if ((ynSspcmd = extiRoutine.getSspcmd()) != null) {
                        dbdStmt = ynSspcmd == DBDConstants.Y ? (String)dbdStmt + ",SSPCMD" : (String)dbdStmt + ",NOSSPCMD";
                    }
                    if ((ynFld = extiRoutine.getFld()) != null) {
                        dbdStmt = ynFld == DBDConstants.Y ? (String)dbdStmt + ",FLD" : (String)dbdStmt + ",NOFLD";
                    }
                }
                if ((ynInpos = extiRoutine.getInpos()) != null) {
                    dbdStmt = ynInpos == DBDConstants.Y ? (String)dbdStmt + ",INPOS" : (String)dbdStmt + ",NOINPOS";
                }
                if ((cascade = extiRoutine.getDoCascade()) != null) {
                    DBDConstants cascadeKey = extiRoutine.getCascadeKey();
                    DBDConstants cascadePath = extiRoutine.getCascadePath();
                    DBDConstants cascadeData = extiRoutine.getCascadeData();
                    boolean parenthesisNeeded = cascadeKey != null || cascadePath != null || cascadeData != null;
                    dbdStmt = (String)dbdStmt + ",";
                    if (parenthesisNeeded) {
                        dbdStmt = (String)dbdStmt + "(";
                    }
                    dbdStmt = (String)dbdStmt + (cascade == DBDConstants.Y ? "CASCADE" : "NOCASCADE");
                    if (cascadeKey != null) {
                        dbdStmt = (String)dbdStmt + "," + (cascadeKey == DBDConstants.Y ? "KEY" : "NOKEY");
                    }
                    if (cascadePath != null) {
                        dbdStmt = (String)dbdStmt + "," + (cascadePath == DBDConstants.Y ? "PATH" : "NOPATH");
                    }
                    if (cascadeData != null) {
                        dbdStmt = (String)dbdStmt + "," + (cascadeData == DBDConstants.Y ? "DATA" : "NODATA");
                    }
                    if (parenthesisNeeded) {
                        dbdStmt = (String)dbdStmt + ")";
                    }
                }
                dbdStmt = iter.hasNext() ? (String)dbdStmt + "," : (String)dbdStmt + ")";
            }
        }
        return dbdStmt;
    }

    public static String getEXITString(SegmentModel segmentModel) {
        String retVal = DBDSourceGenerator.addSEGMEXIT("", segmentModel);
        return retVal.isEmpty() ? "" : retVal.substring(6);
    }

    private static String addSEGMEXIT(String dbdStmt, SegmentModel segmentModel) {
        if (segmentModel.isDataCaptureExitNone()) {
            dbdStmt = (String)dbdStmt + ",EXIT=(NONE)";
        } else {
            List<DataExitRoutine> extiRoutineList = segmentModel.getDataCaptureExitRoutines();
            if (extiRoutineList != null && extiRoutineList.size() != 0) {
                dbdStmt = (String)dbdStmt + ",EXIT=";
                Iterator<DataExitRoutine> iter = extiRoutineList.iterator();
                while (iter.hasNext()) {
                    DBDConstants cascade;
                    DBDConstants ynInpos;
                    DataExitRoutine extiRoutine = iter.next();
                    dbdStmt = (String)dbdStmt + "(" + extiRoutine.getExitName();
                    if (extiRoutine.getLog() != null) {
                        dbdStmt = (String)dbdStmt + "," + (extiRoutine.getLog() == DBDConstants.Y ? "LOG" : "NOLOG");
                    }
                    if (extiRoutine.getExitKey() != null) {
                        dbdStmt = (String)dbdStmt + "," + (extiRoutine.getExitKey() == DBDConstants.Y ? "KEY" : "NOKEY");
                    }
                    if (extiRoutine.getExitPath() != null) {
                        dbdStmt = (String)dbdStmt + "," + (extiRoutine.getExitPath() == DBDConstants.Y ? "PATH" : "NOPATH");
                    }
                    if (extiRoutine.getExitData() != null) {
                        dbdStmt = (String)dbdStmt + "," + (extiRoutine.getExitData() == DBDConstants.Y ? "DATA" : "NODATA");
                    }
                    if (segmentModel.getDbdModel().getAccessType() == DBDConstants.DEDB) {
                        DBDConstants ynFld;
                        DBDConstants ynSspcmd;
                        if (extiRoutine.getBefore() != null) {
                            dbdStmt = (String)dbdStmt + "," + (extiRoutine.getBefore() == DBDConstants.Y ? "BEFORE" : "NOBEFORE");
                        }
                        if (extiRoutine.getDlet() != null) {
                            dbdStmt = (String)dbdStmt + "," + (extiRoutine.getDlet() == DBDConstants.Y ? "DLET" : "NODLET");
                        }
                        if ((ynSspcmd = extiRoutine.getSspcmd()) != null) {
                            dbdStmt = ynSspcmd == DBDConstants.Y ? (String)dbdStmt + ",SSPCMD" : (String)dbdStmt + ",NOSSPCMD";
                        }
                        if ((ynFld = extiRoutine.getFld()) != null) {
                            dbdStmt = ynFld == DBDConstants.Y ? (String)dbdStmt + ",FLD" : (String)dbdStmt + ",NOFLD";
                        }
                    }
                    if ((ynInpos = extiRoutine.getInpos()) != null) {
                        dbdStmt = ynInpos == DBDConstants.Y ? (String)dbdStmt + ",INPOS" : (String)dbdStmt + ",NOINPOS";
                    }
                    if ((cascade = extiRoutine.getDoCascade()) != null) {
                        DBDConstants cascadeKey = extiRoutine.getCascadeKey();
                        DBDConstants cascadePath = extiRoutine.getCascadePath();
                        DBDConstants cascadeData = extiRoutine.getCascadeData();
                        boolean parenthesisNeeded = cascadeKey != null || cascadePath != null || cascadeData != null;
                        dbdStmt = (String)dbdStmt + ",";
                        if (parenthesisNeeded) {
                            dbdStmt = (String)dbdStmt + "(";
                        }
                        dbdStmt = (String)dbdStmt + (cascade == DBDConstants.Y ? "CASCADE" : "NOCASCADE");
                        if (cascadeKey != null) {
                            dbdStmt = (String)dbdStmt + "," + (cascadeKey == DBDConstants.Y ? "KEY" : "NOKEY");
                        }
                        if (cascadePath != null) {
                            dbdStmt = (String)dbdStmt + "," + (cascadePath == DBDConstants.Y ? "PATH" : "NOPATH");
                        }
                        if (cascadeData != null) {
                            dbdStmt = (String)dbdStmt + "," + (cascadeData == DBDConstants.Y ? "DATA" : "NODATA");
                        }
                        if (parenthesisNeeded) {
                            dbdStmt = (String)dbdStmt + ")";
                        }
                    }
                    dbdStmt = iter.hasNext() ? (String)dbdStmt + ")," : (String)dbdStmt + ")";
                }
            }
        }
        return dbdStmt;
    }

    private static String addVERSION(String dbdStmt, DbdModel dbdModel) {
        String version = dbdModel.getVersion();
        if (version != null) {
            dbdStmt = (String)dbdStmt + ",VERSION='" + version;
            dbdStmt = (String)dbdStmt + "'";
        }
        return dbdStmt;
    }

    private static String addDBVER(String dbdStmt, DbdModel dbdModel) {
        Integer dbverInt = dbdModel.getUserVersion();
        if (dbverInt != null) {
            dbdStmt = (String)dbdStmt + ",DBVER=" + dbverInt.toString();
        }
        return dbdStmt;
    }

    private static String addDATXEXIT(String dbdStmt, DbdModel dbdModel) {
        String datxexit = dbdModel.isDatxexit();
        if (datxexit != null) {
            if (datxexit.equals("N")) {
                dbdStmt = (String)dbdStmt + ",DATXEXIT=NO";
            } else if (datxexit.equals("Y")) {
                dbdStmt = (String)dbdStmt + ",DATXEXIT=YES";
            }
        }
        return dbdStmt;
    }

    public static String getHdamRMNAMEString(DbdModel dbdModel) {
        String retVal = DBDSourceGenerator.addHdamRMNAME("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addHdamRMNAME(String dbdStmt, DbdModel dbdModel) {
        String mod = dbdModel.getRMName();
        if (mod != null) {
            dbdStmt = (String)dbdStmt + ",RMNAME=(" + mod;
            Integer anchorPoints = dbdModel.getRmNameAnchorPoints();
            Integer rbn = dbdModel.getRmNameMaxRBN();
            Integer bytes = dbdModel.getRmNameBytes();
            if (anchorPoints != null && anchorPoints != -1 || rbn != null && rbn != -1 || bytes != null && bytes != -1) {
                dbdStmt = anchorPoints != null && anchorPoints != -1 ? (String)dbdStmt + "," + anchorPoints.toString() : (String)dbdStmt + ",";
                dbdStmt = rbn != null && rbn != -1 ? (String)dbdStmt + "," + rbn.toString() : (String)dbdStmt + ",";
                if (bytes != null && bytes != -1 && bytes != 0) {
                    dbdStmt = (String)dbdStmt + "," + bytes.toString();
                }
            }
            dbdStmt = (String)dbdStmt + ")";
        }
        return dbdStmt;
    }

    public static String getDedbRMNAMEString(DbdModel dbdModel) {
        String retVal = DBDSourceGenerator.addDedbRMNAME("", dbdModel);
        return retVal.isEmpty() ? "" : retVal.substring(8);
    }

    private static String addDedbRMNAME(String dbdStmt, DbdModel dbdModel) {
        String mod = dbdModel.getRMName();
        if (mod != null) {
            dbdStmt = (String)dbdStmt + ",RMNAME=(" + mod;
            Integer anchorPoints = dbdModel.getRmNameAnchorPoints();
            String XCI = dbdModel.getXCI();
            if (anchorPoints != null && anchorPoints != -1 || XCI != null) {
                if (anchorPoints != null && anchorPoints != -1) {
                    dbdStmt = (String)dbdStmt + "," + anchorPoints.toString();
                    if (XCI != null && XCI.equals(YesnoType.Y.value())) {
                        dbdStmt = (String)dbdStmt + ",,,XCI";
                    }
                } else if (XCI != null && XCI.equals(YesnoType.Y.value())) {
                    dbdStmt = (String)dbdStmt + ",,,,XCI";
                }
            }
            dbdStmt = (String)dbdStmt + ")";
        }
        return dbdStmt;
    }

    private static String addPSNAME(String dbdStmt, DbdModel dbdModel) {
        String psname = dbdModel.getPsname();
        if (psname != null) {
            dbdStmt = (String)dbdStmt + ",PSNAME=(" + psname + ")";
        }
        return dbdStmt;
    }

    public static String addSecondaryIxDBDNames(String dbdStmt, DbdModel dbdModel) {
        List<String> dbnames = dbdModel.getSecondaryIxDBDNames();
        if (dbnames != null) {
            for (String dbname : dbnames) {
                dbdStmt = (String)dbdStmt + "," + dbname;
            }
        }
        return dbdStmt;
    }

    private static String addPROT(String dbdStmt, DbdModel dbdModel) {
        DBDConstants prot = dbdModel.isProt();
        if (prot != null) {
            if (prot == DBDConstants.Y) {
                dbdStmt = (String)dbdStmt + ",PROT";
            } else if (prot == DBDConstants.N) {
                dbdStmt = (String)dbdStmt + ",NOPROT";
            }
        }
        return dbdStmt;
    }

    private static String addDOSCOMP(String dbdStmt, DbdModel dbdModel) {
        DBDConstants doscomp = dbdModel.isDoscomp();
        if (doscomp != null && doscomp == DBDConstants.Y) {
            dbdStmt = (String)dbdStmt + ",DOSCOMP";
        }
        return dbdStmt;
    }

    protected static String wrapStmt(String stmt) {
        String fifteenSpaces = "               ";
        String wrappedStmt = "";
        int stmtLen = stmt.length();
        int parenthesesCount = 0;
        int startLineValue = 0;
        int colCount = 0;
        int quoteCount = 0;
        if (!stmt.isEmpty()) {
            StringBuffer sb = new StringBuffer(stmtLen * 3);
            int remarksStart = stmt.indexOf("REMARKS");
            if (remarksStart > 0) {
                int i = 0;
                while (i < stmtLen) {
                    char currentChar = stmt.charAt(i);
                    if (currentChar != '\n') {
                        ++colCount;
                    }
                    if (colCount == 72) {
                        sb.append(stmt.substring(startLineValue, i));
                        sb.append("X").append("\n").append(fifteenSpaces);
                        startLineValue = i--;
                        colCount = 15;
                    } else if (currentChar == '(') {
                        ++parenthesesCount;
                    } else if (currentChar == ')') {
                        --parenthesesCount;
                    } else if (currentChar == '\'') {
                        ++quoteCount;
                    } else if (currentChar == '\'') {
                        --quoteCount;
                    } else if (currentChar == ',' && parenthesesCount == 0 && quoteCount == 0) {
                        sb.append(stmt.substring(startLineValue, i + 1));
                        startLineValue = i + 1;
                        while (colCount < 71) {
                            sb.append(" ");
                            ++colCount;
                        }
                        sb.append("X").append("\n").append(fifteenSpaces);
                        colCount = 15;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < stmtLen) {
                    char currentChar = stmt.charAt(i);
                    if (currentChar != '\n') {
                        ++colCount;
                    }
                    if (colCount == 72) {
                        sb.append(stmt.substring(startLineValue, i));
                        sb.append("X").append("\n").append(fifteenSpaces);
                        startLineValue = i--;
                        colCount = 15;
                    } else if (currentChar == '(') {
                        ++parenthesesCount;
                    } else if (currentChar == ')') {
                        --parenthesesCount;
                    } else if (currentChar == ',' && parenthesesCount == 0) {
                        sb.append(stmt.substring(startLineValue, i + 1));
                        startLineValue = i + 1;
                        while (colCount < 71) {
                            sb.append(" ");
                            ++colCount;
                        }
                        sb.append("X").append("\n").append(fifteenSpaces);
                        colCount = 15;
                    }
                    ++i;
                }
            }
            sb.append(stmt.substring(startLineValue, stmtLen));
            wrappedStmt = sb.toString();
        }
        return wrappedStmt;
    }

    public static String remarksHelper(String comments) {
        int commentsLen = comments.length();
        StringBuffer cbuf = new StringBuffer(commentsLen + 10);
        cbuf.append(comments);
        int i = 0;
        while (i < commentsLen) {
            char currentChar = cbuf.charAt(i);
            if (currentChar == '\'') {
                cbuf.insert(i + 1, '\'');
                ++commentsLen;
                ++i;
            }
            ++i;
        }
        cbuf.insert(0, '\'');
        cbuf.insert(commentsLen + 1, '\'');
        return cbuf.toString();
    }
}

