/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.ims.metadata.db.connections.ConnectionProfile;
import java.io.ByteArrayInputStream;
import org.eclipse.core.resources.IFile;

public class ConnectionMetadataHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static PsbModel getPsb(ConnectionProfile connProf) throws Exception {
        PsbModel retVal = null;
        IFile psbFile = ConnectionMetadataHelper.getPsbFile(connProf);
        if (psbFile != null) {
            retVal = new PsbModel(psbFile.getContents());
        }
        return retVal;
    }

    public static IFile getPsbFile(ConnectionProfile connProf) throws Exception {
        IFile retVal = null;
        if (!connProf.isCatalogEnabled) {
            String psbName;
            String projectName = connProf.projectName;
            if (projectName != null && (psbName = connProf.psbName) != null) {
                psbName = psbName.toUpperCase();
                retVal = ProjectTreeFileHelper.getPsbMetadataFile(projectName, psbName);
            }
        } else {
            IImsDbConnection conn = ImsDbUtils.getConnectionByName((String)connProf.profileName, (boolean)true);
            String psbName = connProf.psbName;
            byte[] xmlFileBytes = conn.getPsbXml(psbName);
            PsbModel psbModel = new PsbModel(new ByteArrayInputStream(xmlFileBytes));
            retVal = ProjectTreeFileHelper.getPsbCatalogMetadataFile(psbModel);
        }
        return retVal;
    }

    public static IFile getDbdFile(ConnectionProfile connProf, String dbdName) throws Exception {
        IFile retVal = null;
        if (!connProf.isCatalogEnabled) {
            dbdName = dbdName.toUpperCase();
            retVal = ProjectTreeFileHelper.getDbdMetadataFile(connProf.projectName, dbdName);
        } else {
            IImsDbConnection conn = ImsDbUtils.getConnectionByName((String)connProf.profileName, (boolean)true);
            byte[] xmlFileBytes = conn.getDbdXml(dbdName);
            DbdModel dbdModel = new DbdModel(new ByteArrayInputStream(xmlFileBytes));
            retVal = ProjectTreeFileHelper.marshallDbdToReadOnlyProject(dbdModel);
        }
        return retVal;
    }
}

