/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.model.PsbModel;
import java.util.HashMap;

public class CatPsbCache {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final HashMap<String, PsbModel> psbCache = new HashMap();

    public static PsbModel getPsbModel(String ipAddr, String port, String dataStoreName, String psbName) {
        PsbModel retVal = null;
        String keyStr = CatPsbCache.buildKeyStr(ipAddr, port, dataStoreName, psbName);
        retVal = psbCache.get(keyStr);
        return retVal;
    }

    public static void putPsbModel(PsbModel psbModel, String ipAddr, String port, String dataStoreName, String psbName) {
        String keyStr = CatPsbCache.buildKeyStr(ipAddr, port, dataStoreName, psbName);
        psbCache.put(keyStr, psbModel);
    }

    public static PsbModel removePsbModel(String ipAddr, String port, String dataStoreName, String psbName) {
        PsbModel retVal = null;
        String keyStr = CatPsbCache.buildKeyStr(ipAddr, port, dataStoreName, psbName);
        retVal = psbCache.remove(keyStr);
        return retVal;
    }

    public static String buildKeyStr(String ipAddr, String port, String dataStoreName, String psbName) {
        String retVal = ipAddr + ":" + port + ":" + dataStoreName + ":" + psbName;
        return retVal;
    }

    public static void clearCache() {
        psbCache.clear();
    }
}

