/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model.utilities;

import com.ibm.im.ims.workbench.model.DbdModel;
import java.util.HashMap;

public class CatDbdCache {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final HashMap<String, DbdModel> dbdCache = new HashMap();

    public static DbdModel getDbdModel(String ipAddr, String port, String dataStoreName, String dbdName) {
        DbdModel retVal = null;
        String keyStr = CatDbdCache.buildKeyStr(ipAddr, port, dataStoreName, dbdName);
        retVal = dbdCache.get(keyStr);
        return retVal;
    }

    public static void putDbdModel(DbdModel dbdModel, String ipAddr, String port, String dataStoreName, String dbdName) {
        String keyStr = CatDbdCache.buildKeyStr(ipAddr, port, dataStoreName, dbdName);
        dbdCache.put(keyStr, dbdModel);
    }

    public static DbdModel removeDbdModel(String ipAddr, String port, String dataStoreName, String dbdName) {
        DbdModel retVal = null;
        String keyStr = CatDbdCache.buildKeyStr(ipAddr, port, dataStoreName, dbdName);
        retVal = dbdCache.remove(keyStr);
        return retVal;
    }

    public static String buildKeyStr(String ipAddr, String port, String dataStoreName, String psbName) {
        String retVal = ipAddr + ":" + port + ":" + dataStoreName + ":" + psbName;
        return retVal;
    }

    public static void clearCache() {
        dbdCache.clear();
    }
}

