/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.imsresourcetemplates.ReplacementStringType;
import com.ibm.im.ims.metadata.imsresourcetemplates.TemplateType;
import java.util.ArrayList;
import java.util.List;

public class TemplateModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TemplateType jaxbTemplate = null;

    public TemplateModel() {
        this.jaxbTemplate = new TemplateType();
    }

    public TemplateModel(TemplateType templateType) {
        this.jaxbTemplate = templateType;
    }

    public TemplateModel(String templateName) {
        this.jaxbTemplate = new TemplateType();
        this.jaxbTemplate.setName(templateName);
    }

    public TemplateModel(String templateName, String varString, List<ReplacementStringType> repStrings) {
        this.jaxbTemplate = new TemplateType();
        this.jaxbTemplate.setName(templateName);
        this.jaxbTemplate.setVariableString(varString);
        this.jaxbTemplate.getReplacementString().addAll(repStrings);
    }

    public TemplateModel(TemplateModel originalTemplate) {
        this.jaxbTemplate = new TemplateType();
        TemplateType originalJaxbTemplate = originalTemplate.getTemplateType();
        if (originalJaxbTemplate != null) {
            this.jaxbTemplate.setName(originalJaxbTemplate.getName());
            this.jaxbTemplate.setVariableString(originalJaxbTemplate.getVariableString());
            this.jaxbTemplate.getReplacementString().addAll(originalJaxbTemplate.getReplacementString());
        }
    }

    public TemplateType getTemplateType() {
        return this.jaxbTemplate;
    }

    public String getTemplateName() {
        String retVal = this.jaxbTemplate.getName();
        if (retVal == null) {
            retVal = "";
        }
        return retVal;
    }

    public void setTemplateName(String templateName) {
        this.jaxbTemplate.setName(templateName);
    }

    public String getVarString() {
        String retVal = this.jaxbTemplate.getVariableString();
        if (retVal == null) {
            retVal = "";
        }
        return retVal;
    }

    public void setVarString(String varString) {
        this.jaxbTemplate.setVariableString(varString);
    }

    public ArrayList<String> getRepStrings() {
        List<ReplacementStringType> jaxbReplacementStrings = this.jaxbTemplate.getReplacementString();
        ArrayList<String> replacementStrings = null;
        if (jaxbReplacementStrings != null) {
            replacementStrings = new ArrayList<String>();
            int i = 0;
            while (i < jaxbReplacementStrings.size()) {
                replacementStrings.add(jaxbReplacementStrings.get(i).getValue());
                ++i;
            }
        }
        return replacementStrings;
    }

    public void addReplacementString(String replacementString) {
        ReplacementStringType jaxbReplacementString = new ReplacementStringType();
        jaxbReplacementString.setValue(replacementString);
        this.jaxbTemplate.getReplacementString().add(jaxbReplacementString);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public void removeReplacementString(String replStr) {
        List<ReplacementStringType> jaxbReplacementStrings = this.jaxbTemplate.getReplacementString();
        int i = 0;
        while (i < jaxbReplacementStrings.size()) {
            String currentReplString = jaxbReplacementStrings.get(i).getValue();
            if (currentReplString.equals(replStr)) {
                jaxbReplacementStrings.remove(i);
                return;
            }
            ++i;
        }
    }
}

