/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.psb.IndicesType;
import com.ibm.im.ims.metadata.psb.SenfldType;
import com.ibm.im.ims.metadata.psb.SensegType;
import com.ibm.im.ims.metadata.psb.SsptrSensitivityType;
import com.ibm.im.ims.metadata.psb.SsptrType;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;

public class SensegModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SensegType jaxbSenseg;
    private SensegModel parent;
    private ArrayList<SensegModel> childSensegs = null;
    private ArrayList<SenfieldModel> senfields = new ArrayList();
    private SegmentModel segModel;
    private int hierLevel = 0;
    private int parentSeqNo = 0;
    private int seqNo = 0;

    public SensegModel(SegmentModel segmentModel) throws ModelException {
        this.childSensegs = new ArrayList();
        this.jaxbSenseg = new SensegType();
        this.jaxbSenseg.setName(segmentModel.getImsName());
    }

    public SensegModel(SensegModel another) {
        this.segModel = another.getSegModel();
        this.jaxbSenseg = this.cloneJaxbSenseg(another.getJaxbSenseg());
    }

    public SensegModel(SensegType senSeg, SensegModel parent) throws ModelException {
        this.init(senSeg, parent, null);
    }

    private SensegType cloneJaxbSenseg(SensegType fromSensegType) {
        SensegType toSensegType = new SensegType();
        toSensegType.setName(fromSensegType.getName());
        this.cloneSenfldList(fromSensegType, toSensegType);
        return toSensegType;
    }

    private void cloneSenfldList(SensegType fromSegmentType, SensegType toSegmentType) {
        List<SenfldType> list = fromSegmentType.getSenfld();
        int i = 0;
        while (i < list.size()) {
            SenfldType item = list.get(i);
            toSegmentType.getSenfld().add(SensegModel.cloneSenfldType(item));
            ++i;
        }
    }

    public static SenfldType cloneSenfldType(SenfldType fromSenfldType) {
        SenfldType toSenfldType = new SenfldType();
        toSenfldType.setName(fromSenfldType.getName());
        toSenfldType.setRemarks(fromSenfldType.getRemarks());
        toSenfldType.setReplace(fromSenfldType.getReplace());
        toSenfldType.setStart(fromSenfldType.getStart());
        return toSenfldType;
    }

    private void init(SensegType senSeg, SensegModel parent, SegmentModel segModel) throws ModelException {
        this.parent = parent;
        this.jaxbSenseg = senSeg;
        this.childSensegs = new ArrayList();
        this.segModel = segModel;
        List<SensegType> childJaxbSensegs = senSeg.getSenseg();
        if (childJaxbSensegs != null) {
            for (SensegType childJaxbSenseg : childJaxbSensegs) {
                this.childSensegs.add(new SensegModel(childJaxbSenseg, this));
            }
        }
    }

    public void setSegmentModel(SegmentModel segModel) {
        this.segModel = segModel;
        if (this.senfields != null) {
            int i = 0;
            while (i < this.senfields.size()) {
                SenfieldModel currSenfieldModel = this.senfields.get(i);
                currSenfieldModel.setSegmentModel(segModel);
                ++i;
            }
        }
    }

    public void addChild(SensegModel child) {
        this.childSensegs.add(child);
        this.jaxbSenseg.getSenseg().add(child.getJaxbSenseg());
    }

    public void addField(SenfieldModel field) {
        this.senfields.add(field);
        this.jaxbSenseg.getSenfld().add(field.getJaxbSenfield());
    }

    private void clearSenfldList() {
        if (this.senfields != null) {
            this.senfields.clear();
        }
        this.senfields = new ArrayList();
    }

    public void replaceSenflds(SensegModel another) throws ModelException {
        this.removeAllSenflds();
        this.senfields.addAll(another.getSenfields());
        this.jaxbSenseg.getSenfld().addAll(another.getJaxbSenflds());
    }

    public List<SenfldType> getJaxbSenflds() {
        return this.jaxbSenseg.getSenfld();
    }

    public void removeAllSenflds() {
        this.clearSenfldList();
        this.jaxbSenseg.getSenfld().clear();
    }

    public void removeChild(SensegModel child) {
        this.childSensegs.remove(child);
        this.jaxbSenseg.getSenseg().remove(child.getJaxbSenseg());
    }

    public void removeField(SenfieldModel senfldModel) {
        this.senfields.remove(senfldModel);
        this.jaxbSenseg.getSenfld().remove(senfldModel.getJaxbSenfield());
    }

    public SensegType getJaxbSenseg() {
        return this.jaxbSenseg;
    }

    public ArrayList<SensegModel> getChildren() {
        return this.childSensegs;
    }

    public ArrayList<SenfieldModel> getSenfields() {
        if (this.senfields == null || this.senfields.isEmpty()) {
            this.buildSenfldList();
        }
        if (this.senfields == null) {
            this.senfields = new ArrayList();
        }
        return this.senfields;
    }

    public ArrayList<SenfieldModel> getDefaultSenflds() throws ModelException {
        List<FieldModel> imsFields = this.segModel.getIMSFields();
        ArrayList<SenfieldModel> retVal = new ArrayList<SenfieldModel>(imsFields.size());
        int i = 0;
        while (i < imsFields.size()) {
            FieldModel currField = imsFields.get(i);
            retVal.add(new SenfieldModel(currField, this.segModel));
            ++i;
        }
        return retVal;
    }

    public boolean allSenfldsAreDefault() throws ModelException {
        boolean retVal = true;
        List<FieldModel> fieldModels = this.segModel.getIMSFields();
        ArrayList<SenfieldModel> senflds = this.getSenfields();
        if (fieldModels.size() == senflds.size()) {
            int i = 0;
            while (i < fieldModels.size()) {
                FieldModel currFieldModel = fieldModels.get(i);
                SenfieldModel currSenfld = this.getSenfldWithName(currFieldModel.getImsName(), senflds);
                if (currSenfld == null) {
                    retVal = false;
                    break;
                }
                if (currFieldModel.getStartPos() != currSenfld.getStart()) {
                    retVal = false;
                    break;
                }
                if (currSenfld.getReplace() != DBDConstants.Y) {
                    retVal = false;
                    break;
                }
                String remarks = currSenfld.getRemarks();
                if (remarks != null && !remarks.isEmpty()) {
                    retVal = false;
                    break;
                }
                ++i;
            }
        } else {
            retVal = false;
        }
        return retVal;
    }

    private SenfieldModel getSenfldWithName(String imsName, List<SenfieldModel> senfldModels) {
        SenfieldModel retVal = null;
        int i = 0;
        while (i < senfldModels.size()) {
            SenfieldModel currSenfld = senfldModels.get(i);
            if (imsName.equals(currSenfld.getName())) {
                retVal = currSenfld;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public void writeDefaultSenfldsToJaxbForEdit() throws ModelException {
        ArrayList<SenfieldModel> senfldModels = this.getDefaultSenflds();
        int i = 0;
        while (i < senfldModels.size()) {
            SenfieldModel currSenfldModel = (SenfieldModel)senfldModels.get(i);
            List<SenfldType> jaxbSenflds = this.jaxbSenseg.getSenfld();
            jaxbSenflds.add(currSenfldModel.getJaxbSenfield());
            ++i;
        }
    }

    private void buildSenfldList() {
        List<SenfldType> jaxbSenflds = this.jaxbSenseg.getSenfld();
        int numSenflds = jaxbSenflds.size();
        if (numSenflds > 0) {
            this.senfields = new ArrayList(numSenflds);
            int i = 0;
            while (i < numSenflds) {
                SenfldType currJaxbSenfld = jaxbSenflds.get(i);
                SenfieldModel newSenfld = new SenfieldModel(currJaxbSenfld, this.segModel);
                if (this.senfields.isEmpty()) {
                    this.senfields.add(newSenfld);
                } else {
                    int startPos = newSenfld.getStart();
                    boolean senfldAdded = false;
                    int j = 0;
                    while (j < this.senfields.size()) {
                        SenfieldModel currSenfld = this.senfields.get(j);
                        int currStart = currSenfld.getStart();
                        if (startPos < currStart) {
                            this.senfields.add(j, newSenfld);
                            senfldAdded = true;
                            break;
                        }
                        ++j;
                    }
                    if (!senfldAdded) {
                        this.senfields.add(newSenfld);
                    }
                }
                ++i;
            }
        }
    }

    public SenfieldModel getSenfield(String fieldName, String startStr, String replaceStr) throws ModelException {
        SenfieldModel retVal = null;
        if (this.senfields == null) {
            this.buildSenfldList();
        }
        if (this.senfields != null) {
            int i = 0;
            while (i < this.senfields.size()) {
                SenfieldModel currField = this.senfields.get(i);
                if (currField.getName().equalsIgnoreCase(fieldName)) {
                    int startInt = Integer.parseInt(startStr);
                    if (currField.getStart() == startInt) {
                        DBDConstants replace = DBDConstants.valueOf(replaceStr);
                        if (currField.getReplace() == replace) {
                            retVal = currField;
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        return retVal;
    }

    public String getName() {
        return this.jaxbSenseg.getName();
    }

    public List<String> getIndices() {
        IndicesType inType = this.jaxbSenseg.getIndices();
        if (inType == null) {
            inType = new IndicesType();
            this.jaxbSenseg.setIndices(inType);
        }
        return inType.getIndex();
    }

    public String getProcopt() {
        return this.jaxbSenseg.getProcopt();
    }

    public SensegModel getParent() {
        return this.parent;
    }

    public void setName(String name) {
        this.jaxbSenseg.setName(name);
    }

    public void setProcopt(String value) {
        this.jaxbSenseg.setProcopt(value);
    }

    public void setSeqNo(int n) {
        this.seqNo = n;
    }

    public int getSeqNo() {
        return this.seqNo;
    }

    public void setParentSeqNo(int parent) {
        this.parentSeqNo = parent;
    }

    public int getParentSeqNo() {
        return this.parentSeqNo;
    }

    public int getHierLevel() {
        return this.hierLevel;
    }

    public void setHierLevel(int n) {
        this.hierLevel = n;
    }

    public void buildModelLayer() throws ModelException {
        List<SensegType> jaxbChildren = this.jaxbSenseg.getSenseg();
        this.childSensegs = new ArrayList(jaxbChildren.size());
        int i = 0;
        while (i < jaxbChildren.size()) {
            SensegType jaxbChild = jaxbChildren.get(i);
            SensegModel newChild = new SensegModel(jaxbChild, this);
            this.childSensegs.add(newChild);
            newChild.buildModelLayer();
            ++i;
        }
    }

    public void setParent(SensegModel parent) {
        this.parent = parent;
    }

    public void clearAllSsptrs() {
        this.jaxbSenseg.getSsptr().clear();
    }

    public int getSsptrNum(int index) {
        int retVal = 0;
        List<SsptrType> ssptrList = this.jaxbSenseg.getSsptr();
        if (index < ssptrList.size()) {
            retVal = ssptrList.get(index).getSsptrNum();
        }
        return retVal;
    }

    public String getSsptrSensitivity(int index) {
        String retVal = "";
        List<SsptrType> ssptrList = this.jaxbSenseg.getSsptr();
        if (index < ssptrList.size()) {
            retVal = ssptrList.get(index).getSsptrSensitivity().toString();
        }
        return retVal;
    }

    public void addSsptrSensitivity(String value, int i) {
        List<SsptrType> ssptrList = this.jaxbSenseg.getSsptr();
        SsptrType newSsptr = new SsptrType();
        newSsptr.setSsptrSensitivity(SsptrSensitivityType.fromValue(value));
        newSsptr.setSsptrNum(i);
        ssptrList.add(newSsptr);
    }

    public int getSsptrListSize() {
        return this.jaxbSenseg.getSsptr().size();
    }

    public void populateSenfieldsWithSegmentModels(SegmentModel segModel) {
        this.setSegmentModel(segModel);
        int i = 0;
        while (i < this.childSensegs.size()) {
            SensegModel currSenseg = this.childSensegs.get(i);
            String currSensegName = currSenseg.getName();
            SegmentModel currChildSegModel = segModel.getChildSegment(currSensegName);
            if (currChildSegModel != null) {
                currSenseg.populateSenfieldsWithSegmentModels(currChildSegModel);
            } else {
                logger.finer("Source problem: There is no matching segment for senseg name: " + currSensegName + " parent segment name: " + segModel.getImsName() + " in DBD: " + segModel.getDbdName());
            }
            ++i;
        }
    }

    public SegmentModel getSegModel() {
        return this.segModel;
    }

    public void setRemarks(String remarks) {
        this.jaxbSenseg.setRemarks(remarks);
    }

    public String getRemarks() {
        return this.jaxbSenseg.getRemarks();
    }

    public String toString() {
        Object retVal = this.segModel != null ? this.getName() + " aka " + this.segModel.getName() : this.getName();
        return retVal;
    }
}

