/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.psb.SenfldType;
import com.ibm.im.ims.metadata.psb.YesnoType;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import org.eclipse.core.runtime.CoreException;

public class SenfieldModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SenfldType jaxbSenfield;
    private SegmentModel segModel;
    private FieldModel fieldModel;

    public SenfieldModel(SenfldType senfield, SegmentModel segModel) {
        this.jaxbSenfield = senfield;
        this.segModel = segModel;
        if (segModel != null) {
            this.fieldModel = segModel.getFieldWithImsNameOrAlias(senfield.getName());
        }
    }

    public SenfieldModel(FieldModel field, SegmentModel segModel) {
        this.jaxbSenfield = new SenfldType();
        this.fieldModel = field;
        this.jaxbSenfield.setName(field.getImsName());
        this.jaxbSenfield.setStart(field.getStartPos());
        this.jaxbSenfield.setReplace(YesnoType.Y);
        this.segModel = segModel;
    }

    public SenfieldModel(SenfieldModel another) {
        this.jaxbSenfield = SensegModel.cloneSenfldType(another.getJaxbSenfield());
        this.segModel = another.getSegmentModel();
    }

    public SegmentModel getSegmentModel() {
        return this.segModel;
    }

    public SenfieldModel(String value) {
        this.jaxbSenfield = new SenfldType();
        this.jaxbSenfield.setName(value);
    }

    public String getName() {
        return this.jaxbSenfield.getName();
    }

    public void setName(String value) {
        this.jaxbSenfield.setName(value);
    }

    public int getStart() {
        return this.jaxbSenfield.getStart();
    }

    public void setStart(int value) {
        this.jaxbSenfield.setStart(value);
    }

    public DBDConstants getReplace() {
        if (this.jaxbSenfield.getReplace() == null) {
            return DBDConstants.Y;
        }
        return DBDConstants.fromValue(this.jaxbSenfield.getReplace().value());
    }

    public void setReplace(DBDConstants value) {
        this.jaxbSenfield.setReplace(YesnoType.valueOf(value.toString()));
    }

    public SenfldType getJaxbSenfield() {
        return this.jaxbSenfield;
    }

    public boolean isLogicalChild() {
        return this.segModel != null && (this.segModel.isRealLogicalChild() || this.segModel.isVirtualLogicalChild());
    }

    public void setSegmentModel(SegmentModel segModel) {
        this.segModel = segModel;
    }

    public void setRemarks(String remarks) {
        this.jaxbSenfield.setRemarks(remarks);
    }

    public FieldModel getFieldModel() throws ModelException, CoreException {
        if (this.fieldModel == null || !this.fieldModel.getImsName().equals(this.getName())) {
            if (this.segModel.getDBDAccessType() == DBDConstants.LOGICAL) {
                if (this.segModel.hasSegmentSource()) {
                    this.fieldModel = this.segModel.getLogicalSourceSegment().getFieldWithImsNameOrAlias(this.getName());
                } else if (this.segModel.hasConcatenatedSegmentSource()) {
                    this.fieldModel = this.segModel.getLChildSourceSegment().getFieldWithImsNameOrAlias(this.getName());
                    if (this.fieldModel == null) {
                        this.fieldModel = this.segModel.getTargetParentSourceSegment().getFieldWithImsNameOrAlias(this.getName());
                    }
                }
            } else {
                this.fieldModel = this.segModel.getFieldWithImsNameOrAlias(this.getName());
            }
        }
        return this.fieldModel;
    }

    public void setFieldModel(FieldModel newFieldModel) {
        this.fieldModel = newFieldModel;
    }

    public String getRemarks() {
        return this.jaxbSenfield.getRemarks();
    }

    public String toString() {
        Object retVal = this.getName();
        if (this.fieldModel != null) {
            retVal = (String)retVal + " aka " + this.fieldModel.getName();
        }
        return retVal;
    }

    public boolean equals(Object aThat) {
        SenfieldModel otherSenfld;
        boolean retVal = false;
        if (aThat instanceof SenfieldModel && (otherSenfld = (SenfieldModel)aThat).getName().equals(this.getName()) && otherSenfld.getStart() == this.getStart() && otherSenfld.getReplace() == this.getReplace()) {
            retVal = true;
        }
        return retVal;
    }
}

