/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.dbd.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.dbd.CascadeType;
import com.ibm.im.ims.metadata.dbd.ComprtnType;
import com.ibm.im.ims.metadata.dbd.ConcatenatedSegmentSourceType;
import com.ibm.im.ims.metadata.dbd.DataCaptureExitRoutineType;
import com.ibm.im.ims.metadata.dbd.DatatypeType;
import com.ibm.im.ims.metadata.dbd.DedbComprtnType;
import com.ibm.im.ims.metadata.dbd.DedbDependentSegmentType;
import com.ibm.im.ims.metadata.dbd.DedbSegType;
import com.ibm.im.ims.metadata.dbd.DeletionRuleType;
import com.ibm.im.ims.metadata.dbd.DependingOnFieldValueType;
import com.ibm.im.ims.metadata.dbd.DsgroupType;
import com.ibm.im.ims.metadata.dbd.ExitContainerType;
import com.ibm.im.ims.metadata.dbd.FieldListType;
import com.ibm.im.ims.metadata.dbd.FieldType;
import com.ibm.im.ims.metadata.dbd.HdamAndHidamPointerType;
import com.ibm.im.ims.metadata.dbd.HdamAndHidamSegType;
import com.ibm.im.ims.metadata.dbd.HisamAndShisamPointerType;
import com.ibm.im.ims.metadata.dbd.HisamAndShisamSegType;
import com.ibm.im.ims.metadata.dbd.HsamAndShsamSegType;
import com.ibm.im.ims.metadata.dbd.IndexSegType;
import com.ibm.im.ims.metadata.dbd.InsertionAndReplacementRuleType;
import com.ibm.im.ims.metadata.dbd.InsertionLocationType;
import com.ibm.im.ims.metadata.dbd.LchildPointerType;
import com.ibm.im.ims.metadata.dbd.LfhRulesType;
import com.ibm.im.ims.metadata.dbd.LogicalChildType;
import com.ibm.im.ims.metadata.dbd.LogicalParentType;
import com.ibm.im.ims.metadata.dbd.LogicalPointerType;
import com.ibm.im.ims.metadata.dbd.LogicalSegType;
import com.ibm.im.ims.metadata.dbd.LpckType;
import com.ibm.im.ims.metadata.dbd.MappingCaseType;
import com.ibm.im.ims.metadata.dbd.MappingType;
import com.ibm.im.ims.metadata.dbd.MarshallerType;
import com.ibm.im.ims.metadata.dbd.MaxBytesType;
import com.ibm.im.ims.metadata.dbd.MinAndMaxBytesType;
import com.ibm.im.ims.metadata.dbd.MsdbSegType;
import com.ibm.im.ims.metadata.dbd.ObjectFactory;
import com.ibm.im.ims.metadata.dbd.PhdamAndPhidamPhysicalPointerType;
import com.ibm.im.ims.metadata.dbd.PhdamAndPhidamPointerType;
import com.ibm.im.ims.metadata.dbd.PhdamAndPhidamSegType;
import com.ibm.im.ims.metadata.dbd.PhysicalChildPointerType;
import com.ibm.im.ims.metadata.dbd.PhysicalPointerType;
import com.ibm.im.ims.metadata.dbd.PropertyType;
import com.ibm.im.ims.metadata.dbd.PsindexSegType;
import com.ibm.im.ims.metadata.dbd.RecfmType;
import com.ibm.im.ims.metadata.dbd.RulesType;
import com.ibm.im.ims.metadata.dbd.SegmentSourceType;
import com.ibm.im.ims.metadata.dbd.SegmentType;
import com.ibm.im.ims.metadata.dbd.SubOptionsType;
import com.ibm.im.ims.metadata.dbd.SysRelFieldType;
import com.ibm.im.ims.metadata.dbd.XdfldType;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.controller.field.ManageFieldsController;
import com.ibm.im.ims.workbench.model.BooleanBean;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DataExitRoutine;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.FieldModelImpl;
import com.ibm.im.ims.workbench.model.IFieldContainer;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SysRelFieldModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import org.eclipse.core.runtime.CoreException;

public class SegmentModel
implements IFieldContainer {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SegmentType jaxbSegment;
    private ArrayList<SegmentModel> childSegments;
    private Vector<FieldModel> topLevelFieldList = null;
    private Vector<FieldModel> sysRelFieldList = null;
    private ArrayList<LogicalChildModel> lChildList = null;
    private SegmentModel parent = null;
    private String projectName;
    private SegmentModel logicalSourceSeg;
    private SegmentModel lchildSourceSeg;
    private SegmentModel targetParentSourceSeg;
    private ArrayList<DataExitRoutine> dataCaptureExitRoutines = null;
    private Vector<FieldModel> commonFieldList = null;
    private LinkedHashMap<String, MappingModel> mappingList;
    DbdModel dbdModel;
    ObjectFactory objFactory = new ObjectFactory();

    public SegmentModel() {
        this.jaxbSegment = this.objFactory.createSegmentType();
        this.childSegments = new ArrayList();
        this.buildMappingList();
    }

    public SegmentModel(DbdModel dbdModel) throws ModelException {
        this.jaxbSegment = this.objFactory.createSegmentType();
        this.childSegments = new ArrayList();
        this.dbdModel = dbdModel;
        this.buildLChildList();
        this.buildMappingList();
    }

    public SegmentModel(SegmentModel parent, SegmentType segmentType, DbdModel dbdModel, BooleanBean atLeastOneSegmentDidNotHaveAlias) throws ModelException {
        this.parent = parent;
        this.jaxbSegment = segmentType;
        this.dbdModel = dbdModel;
        String segmentAlias = this.jaxbSegment.getName();
        if (segmentAlias == null || segmentAlias.isEmpty()) {
            this.jaxbSegment.setName(this.jaxbSegment.getImsName());
            if (atLeastOneSegmentDidNotHaveAlias != null) {
                atLeastOneSegmentDidNotHaveAlias.myBool = true;
            }
        }
        this.childSegments = new ArrayList();
        List<SegmentType> childJaxbSegments = segmentType.getSegment();
        if (childJaxbSegments != null) {
            for (SegmentType jaxbSegment : childJaxbSegments) {
                this.childSegments.add(new SegmentModel(this, jaxbSegment, dbdModel, atLeastOneSegmentDidNotHaveAlias));
            }
        }
        this.buildLChildList();
        this.buildExitList();
        this.buildMappingList();
    }

    public SegmentModel(SegmentModel parent, DbdModel dbdModel) throws ModelException {
        this.parent = parent;
        this.jaxbSegment = new SegmentType();
        this.dbdModel = dbdModel;
        this.childSegments = new ArrayList();
        this.setSegmentType(dbdModel.getAccessType());
        this.buildMappingList();
    }

    public SegmentModel(SegmentModel another) throws ModelException {
        this.dbdModel = another.getDbdModel();
        this.jaxbSegment = this.cloneJaxbSegment(another.getSegmentType());
        this.childSegments = new ArrayList();
        this.parent = another.getParent();
        this.buildLChildList();
        this.buildExitList();
        this.buildMappingList();
    }

    public List<String> getIndices() {
        Iterator<Object> fieldOrChildIter;
        Vector<String> retVal = new Vector<String>();
        List<Object> fieldOrChildList = this.jaxbSegment.getFieldOrMappingOrLchild();
        if (fieldOrChildList != null && (fieldOrChildIter = fieldOrChildList.iterator()) != null) {
            while (fieldOrChildIter.hasNext()) {
                LogicalChildType lChild;
                Object fieldOrChild = fieldOrChildIter.next();
                if (!(fieldOrChild instanceof LogicalChildType) || (lChild = (LogicalChildType)fieldOrChild).getXdfld() == null) continue;
                retVal.add(lChild.getDbd());
            }
        }
        return retVal;
    }

    private SegmentType cloneJaxbSegment(SegmentType fromSegmentType) {
        SegmentType toSegmentType = new SegmentType();
        toSegmentType.setName(fromSegmentType.getName());
        toSegmentType.setImsName(fromSegmentType.getImsName());
        toSegmentType.setEncoding(fromSegmentType.getEncoding());
        toSegmentType.setRemarks(fromSegmentType.getRemarks());
        this.cloneAccessType(fromSegmentType, toSegmentType);
        this.cloneChoiceList(fromSegmentType, toSegmentType);
        return toSegmentType;
    }

    public void updateJaxbSegment(SegmentType fromSegmentType) {
        this.jaxbSegment.setName(fromSegmentType.getName());
        this.jaxbSegment.setEncoding(fromSegmentType.getEncoding());
        this.jaxbSegment.setRemarks(fromSegmentType.getRemarks());
        this.cloneAccessType(fromSegmentType, this.jaxbSegment);
    }

    private void cloneAccessType(SegmentType fromSegmentType, SegmentType toSegmentType) {
        if (fromSegmentType.getHsam() != null) {
            toSegmentType.setHsam(this.cloneHsamandShsamSegType(fromSegmentType.getHsam()));
        } else if (fromSegmentType.getShsam() != null) {
            toSegmentType.setShsam(this.cloneHsamandShsamSegType(fromSegmentType.getShsam()));
        } else if (fromSegmentType.getHisam() != null) {
            toSegmentType.setHisam(this.cloneHisamAndShisamSegType(fromSegmentType.getHisam()));
        } else if (fromSegmentType.getShisam() != null) {
            toSegmentType.setShisam(this.cloneHisamAndShisamSegType(fromSegmentType.getShisam()));
        } else if (fromSegmentType.getHdam() != null) {
            toSegmentType.setHdam(this.cloneHdamAndHidamSegType(fromSegmentType.getHdam()));
        } else if (fromSegmentType.getPhdam() != null) {
            toSegmentType.setPhdam(this.clonePhdamAndPhidamSegType(fromSegmentType.getPhdam()));
        } else if (fromSegmentType.getHidam() != null) {
            toSegmentType.setHidam(this.cloneHdamAndHidamSegType(fromSegmentType.getHidam()));
        } else if (fromSegmentType.getPhidam() != null) {
            toSegmentType.setPhidam(this.clonePhdamAndPhidamSegType(fromSegmentType.getPhidam()));
        } else if (fromSegmentType.getMsdb() != null) {
            toSegmentType.setMsdb(this.cloneMsdbSegType(fromSegmentType.getMsdb()));
        } else if (fromSegmentType.getDedb() != null) {
            toSegmentType.setDedb(this.cloneDedbSegType(fromSegmentType.getDedb()));
        } else if (fromSegmentType.getIndex() != null) {
            toSegmentType.setIndex(this.cloneIndexSegType(fromSegmentType.getIndex()));
        } else if (fromSegmentType.getPsindex() != null) {
            toSegmentType.setPsindex(this.clonePsindexSegType(fromSegmentType.getPsindex()));
        } else if (fromSegmentType.getLogical() != null) {
            toSegmentType.setLogical(this.cloneLogicalSegType(fromSegmentType.getLogical()));
        }
    }

    public boolean canBeLogicalRoot() {
        DBDConstants accessType = this.dbdModel.getAccessType();
        if (accessType == DBDConstants.LOGICAL || accessType == DBDConstants.INDEX) {
            return false;
        }
        return this.isRoot() || this.hasSecondaryIndexes();
    }

    private LogicalSegType cloneLogicalSegType(LogicalSegType fromLogicalSegType) {
        SegmentSourceType source;
        LogicalSegType toLogicalSegType = new LogicalSegType();
        ConcatenatedSegmentSourceType concatseg = fromLogicalSegType.getConcatenatedSegmentSource();
        if (concatseg != null) {
            toLogicalSegType.setConcatenatedSegmentSource(this.cloneConcatenatedSegmentSourceType(concatseg));
        }
        if ((source = fromLogicalSegType.getSegmentSource()) != null) {
            toLogicalSegType.setSegmentSource(this.cloneSegmentSourceType(source));
        }
        return toLogicalSegType;
    }

    private ConcatenatedSegmentSourceType cloneConcatenatedSegmentSourceType(ConcatenatedSegmentSourceType fromConcatenatedSegmentSourceType) {
        ConcatenatedSegmentSourceType toConcatenatedSegmentSourceType = new ConcatenatedSegmentSourceType();
        SegmentSourceType lchildSrc = fromConcatenatedSegmentSourceType.getLogicalChildSource();
        if (lchildSrc != null) {
            toConcatenatedSegmentSourceType.setLogicalChildSource(this.cloneSegmentSourceType(lchildSrc));
        }
        SegmentSourceType tparentSrc = fromConcatenatedSegmentSourceType.getTargetParentSource();
        if (lchildSrc != null) {
            toConcatenatedSegmentSourceType.setTargetParentSource(this.cloneSegmentSourceType(tparentSrc));
        }
        return toConcatenatedSegmentSourceType;
    }

    private PsindexSegType clonePsindexSegType(PsindexSegType fromPsindexSegType) {
        PsindexSegType toPsindexSegType = new PsindexSegType();
        toPsindexSegType.setFreq(fromPsindexSegType.getFreq());
        toPsindexSegType.setMaxBytes(fromPsindexSegType.getMaxBytes());
        return toPsindexSegType;
    }

    private IndexSegType cloneIndexSegType(IndexSegType fromIndexSegType) {
        IndexSegType toIndexSegType = new IndexSegType();
        toIndexSegType.setFreq(fromIndexSegType.getFreq());
        toIndexSegType.setMaxBytes(fromIndexSegType.getMaxBytes());
        return toIndexSegType;
    }

    private MsdbSegType cloneMsdbSegType(MsdbSegType fromMsdbSegType) {
        MsdbSegType toMsdbSegType = new MsdbSegType();
        toMsdbSegType.setMaxBytes(fromMsdbSegType.getMaxBytes());
        return toMsdbSegType;
    }

    private HsamAndShsamSegType cloneHsamandShsamSegType(HsamAndShsamSegType fromHsamSegType) {
        HsamAndShsamSegType toHsamSegType = new HsamAndShsamSegType();
        toHsamSegType.setFreq(fromHsamSegType.getFreq());
        toHsamSegType.setMaxBytes(fromHsamSegType.getMaxBytes());
        return toHsamSegType;
    }

    private PhdamAndPhidamSegType clonePhdamAndPhidamSegType(PhdamAndPhidamSegType fromPhdamAndPhidamSegType) {
        RulesType rules;
        PhdamAndPhidamPointerType ptr;
        LogicalParentType lparent;
        ExitContainerType exitcont;
        ComprtnType comprtn;
        PhdamAndPhidamSegType toPhdamAndPhidamSegType = new PhdamAndPhidamSegType();
        toPhdamAndPhidamSegType.setPhysicalChildPointer(fromPhdamAndPhidamSegType.getPhysicalChildPointer());
        toPhdamAndPhidamSegType.setDsgroup(fromPhdamAndPhidamSegType.getDsgroup());
        toPhdamAndPhidamSegType.setFreq(fromPhdamAndPhidamSegType.getFreq());
        MinAndMaxBytesType mnmbytes = fromPhdamAndPhidamSegType.getBytes();
        if (mnmbytes != null) {
            toPhdamAndPhidamSegType.setBytes(this.cloneMinAndMaxBytesType(mnmbytes));
        }
        if ((comprtn = fromPhdamAndPhidamSegType.getComprtn()) != null) {
            toPhdamAndPhidamSegType.setComprtn(this.cloneComprtnType(comprtn));
        }
        if ((exitcont = fromPhdamAndPhidamSegType.getExitContainer()) != null && exitcont.getDataCaptureExitRoutine().size() > 0) {
            toPhdamAndPhidamSegType.setExitContainer(this.cloneExitContainerType(exitcont));
        }
        if ((lparent = fromPhdamAndPhidamSegType.getLogicalParent()) != null) {
            toPhdamAndPhidamSegType.setLogicalParent(this.cloneLogicalParentType(lparent));
        }
        if ((ptr = fromPhdamAndPhidamSegType.getPointer()) != null) {
            toPhdamAndPhidamSegType.setPointer(this.clonePhdamAndPhidamPointerType(ptr));
        }
        if ((rules = fromPhdamAndPhidamSegType.getRules()) != null) {
            toPhdamAndPhidamSegType.setRules(this.cloneRulesType(rules));
        }
        return toPhdamAndPhidamSegType;
    }

    private PhdamAndPhidamPointerType clonePhdamAndPhidamPointerType(PhdamAndPhidamPointerType fromPhdamAndPhidamPointerType) {
        PhdamAndPhidamPointerType toPhdamAndPhidamPointerType = new PhdamAndPhidamPointerType();
        toPhdamAndPhidamPointerType.setLparnt(fromPhdamAndPhidamPointerType.getLparnt());
        toPhdamAndPhidamPointerType.setPaired(fromPhdamAndPhidamPointerType.getPaired());
        toPhdamAndPhidamPointerType.setPhysicalPointer(fromPhdamAndPhidamPointerType.getPhysicalPointer());
        return toPhdamAndPhidamPointerType;
    }

    private HisamAndShisamSegType cloneHisamAndShisamSegType(HisamAndShisamSegType fromHisamAndShisamSegType) {
        SegmentSourceType source;
        RulesType rules;
        LogicalParentType lparent;
        ExitContainerType exitcont;
        ComprtnType comprtn;
        HisamAndShisamSegType toHisamAndShisamSegType = new HisamAndShisamSegType();
        toHisamAndShisamSegType.setFreq(fromHisamAndShisamSegType.getFreq());
        toHisamAndShisamSegType.setPointer(fromHisamAndShisamSegType.getPointer());
        MinAndMaxBytesType mnmbytes = fromHisamAndShisamSegType.getBytes();
        if (mnmbytes != null) {
            toHisamAndShisamSegType.setBytes(this.cloneMinAndMaxBytesType(mnmbytes));
        }
        if ((comprtn = fromHisamAndShisamSegType.getComprtn()) != null) {
            toHisamAndShisamSegType.setComprtn(this.cloneComprtnType(comprtn));
        }
        if ((exitcont = fromHisamAndShisamSegType.getExitContainer()) != null && exitcont.getDataCaptureExitRoutine().size() > 0) {
            toHisamAndShisamSegType.setExitContainer(this.cloneExitContainerType(exitcont));
        }
        if ((lparent = fromHisamAndShisamSegType.getLogicalParent()) != null) {
            toHisamAndShisamSegType.setLogicalParent(this.cloneLogicalParentType(lparent));
        }
        if ((rules = fromHisamAndShisamSegType.getRules()) != null) {
            toHisamAndShisamSegType.setRules(this.cloneRulesType(rules));
        }
        if ((source = fromHisamAndShisamSegType.getSegmentSource()) != null) {
            toHisamAndShisamSegType.setSegmentSource(this.cloneSegmentSourceType(source));
        }
        return toHisamAndShisamSegType;
    }

    private HdamAndHidamSegType cloneHdamAndHidamSegType(HdamAndHidamSegType fromHdamAndHidamSegType) {
        SegmentSourceType source;
        RulesType rules;
        HdamAndHidamPointerType hnhptr;
        LogicalParentType lparent;
        ExitContainerType exitcont;
        ComprtnType comprtn;
        HdamAndHidamSegType toHdamAndHidamSegType = new HdamAndHidamSegType();
        toHdamAndHidamSegType.setLabel(fromHdamAndHidamSegType.getLabel());
        toHdamAndHidamSegType.setPhysicalChildPointer(fromHdamAndHidamSegType.getPhysicalChildPointer());
        toHdamAndHidamSegType.setFreq(fromHdamAndHidamSegType.getFreq());
        MinAndMaxBytesType mnmbytes = fromHdamAndHidamSegType.getBytes();
        if (mnmbytes != null) {
            toHdamAndHidamSegType.setBytes(this.cloneMinAndMaxBytesType(mnmbytes));
        }
        if ((comprtn = fromHdamAndHidamSegType.getComprtn()) != null) {
            toHdamAndHidamSegType.setComprtn(this.cloneComprtnType(comprtn));
        }
        if ((exitcont = fromHdamAndHidamSegType.getExitContainer()) != null && exitcont.getDataCaptureExitRoutine().size() > 0) {
            toHdamAndHidamSegType.setExitContainer(this.cloneExitContainerType(exitcont));
        }
        if ((lparent = fromHdamAndHidamSegType.getLogicalParent()) != null) {
            toHdamAndHidamSegType.setLogicalParent(this.cloneLogicalParentType(lparent));
        }
        if ((hnhptr = fromHdamAndHidamSegType.getPointer()) != null) {
            toHdamAndHidamSegType.setPointer(this.cloneHdamAndHidamPointerType(hnhptr));
        }
        if ((rules = fromHdamAndHidamSegType.getRules()) != null) {
            toHdamAndHidamSegType.setRules(this.cloneRulesType(rules));
        }
        if ((source = fromHdamAndHidamSegType.getSegmentSource()) != null) {
            toHdamAndHidamSegType.setSegmentSource(this.cloneSegmentSourceType(source));
        }
        return toHdamAndHidamSegType;
    }

    private SegmentSourceType cloneSegmentSourceType(SegmentSourceType fromSegmentSourceType) {
        SegmentSourceType toSegmentSourceType = new SegmentSourceType();
        toSegmentSourceType.setData(fromSegmentSourceType.getData());
        toSegmentSourceType.setDbname(fromSegmentSourceType.getDbname());
        toSegmentSourceType.setSegname(fromSegmentSourceType.getSegname());
        return toSegmentSourceType;
    }

    private RulesType cloneRulesType(RulesType fromRulesType) {
        RulesType toRulesType = new RulesType();
        toRulesType.setDeletionRule(fromRulesType.getDeletionRule());
        toRulesType.setInsertionLocation(fromRulesType.getInsertionLocation());
        toRulesType.setInsertionRule(fromRulesType.getInsertionRule());
        toRulesType.setReplacementRule(fromRulesType.getReplacementRule());
        return toRulesType;
    }

    private HdamAndHidamPointerType cloneHdamAndHidamPointerType(HdamAndHidamPointerType fromHdamAndHidamPointerType) {
        HdamAndHidamPointerType toHdamAndHidamPointerType = new HdamAndHidamPointerType();
        toHdamAndHidamPointerType.setCtr(fromHdamAndHidamPointerType.getCtr());
        toHdamAndHidamPointerType.setLogicalPointer(fromHdamAndHidamPointerType.getLogicalPointer());
        toHdamAndHidamPointerType.setLparnt(fromHdamAndHidamPointerType.getLparnt());
        toHdamAndHidamPointerType.setPaired(fromHdamAndHidamPointerType.getPaired());
        toHdamAndHidamPointerType.setPhysicalPointer(fromHdamAndHidamPointerType.getPhysicalPointer());
        return toHdamAndHidamPointerType;
    }

    private LogicalParentType cloneLogicalParentType(LogicalParentType fromLogicalParentType) {
        LogicalParentType toLogicalParentType = new LogicalParentType();
        toLogicalParentType.setDbd(fromLogicalParentType.getDbd());
        toLogicalParentType.setParent(fromLogicalParentType.getParent());
        toLogicalParentType.setLpck(fromLogicalParentType.getLpck());
        return toLogicalParentType;
    }

    private ExitContainerType cloneExitContainerType(ExitContainerType fromExitContainerType) {
        ExitContainerType toExitContainerType = new ExitContainerType();
        List<DataCaptureExitRoutineType> list = fromExitContainerType.getDataCaptureExitRoutine();
        int i = 0;
        while (i < list.size()) {
            DataCaptureExitRoutineType exit = list.get(i);
            toExitContainerType.getDataCaptureExitRoutine().add(this.cloneDataCaptureExitRoutineType(exit));
            ++i;
        }
        return toExitContainerType;
    }

    private DataCaptureExitRoutineType cloneDataCaptureExitRoutineType(DataCaptureExitRoutineType fromDataCaptureExitRoutineType) {
        SubOptionsType subopts;
        DataCaptureExitRoutineType toDataCaptureExitRoutineType = new DataCaptureExitRoutineType();
        toDataCaptureExitRoutineType.setExitRoutineLog(fromDataCaptureExitRoutineType.getExitRoutineLog());
        toDataCaptureExitRoutineType.setExitRoutineName(fromDataCaptureExitRoutineType.getExitRoutineName());
        CascadeType cascade = fromDataCaptureExitRoutineType.getCascade();
        if (cascade != null) {
            toDataCaptureExitRoutineType.setCascade(this.cloneCascadeType(cascade));
        }
        if ((subopts = fromDataCaptureExitRoutineType.getExitRoutineSubOptions()) != null) {
            toDataCaptureExitRoutineType.setExitRoutineSubOptions(this.cloneSubOptionsType(subopts));
        }
        return toDataCaptureExitRoutineType;
    }

    private SubOptionsType cloneSubOptionsType(SubOptionsType fromSubOptionsType) {
        SubOptionsType toSubOptionsType = new SubOptionsType();
        toSubOptionsType.setData(fromSubOptionsType.getData());
        toSubOptionsType.setKey(fromSubOptionsType.getKey());
        toSubOptionsType.setPath(fromSubOptionsType.getPath());
        toSubOptionsType.setBefore(fromSubOptionsType.getBefore());
        toSubOptionsType.setSspcmd(fromSubOptionsType.getSspcmd());
        toSubOptionsType.setFld(fromSubOptionsType.getFld());
        toSubOptionsType.setDlet(fromSubOptionsType.getDlet());
        toSubOptionsType.setInpos(fromSubOptionsType.getInpos());
        return toSubOptionsType;
    }

    private CascadeType cloneCascadeType(CascadeType fromCascadeType) {
        CascadeType toCascadeType = new CascadeType();
        toCascadeType.setDoCascade(fromCascadeType.getDoCascade());
        SubOptionsType subopts = fromCascadeType.getSubOptions();
        if (subopts != null) {
            toCascadeType.setSubOptions(this.cloneSubOptionsType(subopts));
        }
        return toCascadeType;
    }

    private ComprtnType cloneComprtnType(ComprtnType fromComprtnType) {
        ComprtnType toComprtnType = new ComprtnType();
        toComprtnType.setInit(fromComprtnType.getInit());
        toComprtnType.setData(fromComprtnType.getData());
        toComprtnType.setRoutineName(fromComprtnType.getRoutineName());
        MaxBytesType maxbytes = fromComprtnType.getMax();
        if (maxbytes != null) {
            toComprtnType.setMax(this.cloneMaxBytesType(maxbytes));
        }
        return toComprtnType;
    }

    private MaxBytesType cloneMaxBytesType(MaxBytesType fromMaxBytesType) {
        MaxBytesType toMaxBytesType = new MaxBytesType();
        toMaxBytesType.setMax(fromMaxBytesType.getMax());
        toMaxBytesType.setPad(fromMaxBytesType.getPad());
        return toMaxBytesType;
    }

    private MinAndMaxBytesType cloneMinAndMaxBytesType(MinAndMaxBytesType fromMinAndMaxBytesType) {
        MinAndMaxBytesType toMinAndMaxBytesType = new MinAndMaxBytesType();
        toMinAndMaxBytesType.setMaxBytes(fromMinAndMaxBytesType.getMaxBytes());
        toMinAndMaxBytesType.setMinBytes(fromMinAndMaxBytesType.getMinBytes());
        return toMinAndMaxBytesType;
    }

    private DedbSegType cloneDedbSegType(DedbSegType fromDedbSegType) {
        ExitContainerType exitcont;
        LfhRulesType rules;
        DedbComprtnType comprtn;
        Integer ssptr;
        DedbSegType toDedbSegType = new DedbSegType();
        MinAndMaxBytesType mnmbytes = fromDedbSegType.getBytes();
        if (mnmbytes != null) {
            toDedbSegType.setBytes(this.cloneMinAndMaxBytesType(mnmbytes));
        }
        if ((ssptr = fromDedbSegType.getSsptr()) != null) {
            toDedbSegType.setSsptr((int)ssptr);
        }
        if ((comprtn = fromDedbSegType.getComprtn()) != null) {
            toDedbSegType.setComprtn(this.cloneComprtn(comprtn));
        }
        if ((rules = fromDedbSegType.getRules()) != null) {
            toDedbSegType.setRules(rules);
        }
        if ((exitcont = fromDedbSegType.getExitContainer()) != null && exitcont.getDataCaptureExitRoutine().size() > 0) {
            toDedbSegType.setExitContainer(this.cloneExitContainerType(exitcont));
        }
        return toDedbSegType;
    }

    private DedbComprtnType cloneComprtn(DedbComprtnType comprtn) {
        DedbComprtnType retVal = new DedbComprtnType();
        retVal.setRoutineName(comprtn.getRoutineName());
        retVal.setInit(comprtn.getInit());
        retVal.setData(comprtn.getData());
        return retVal;
    }

    private void cloneChoiceList(SegmentType fromSegmentType, SegmentType toSegmentType) {
        List<Object> list = fromSegmentType.getFieldOrMappingOrLchild();
        int i = 0;
        while (i < list.size()) {
            Object item = list.get(i);
            if (item instanceof FieldType) {
                toSegmentType.getFieldOrMappingOrLchild().add(SegmentModel.cloneFieldType((FieldType)item));
            } else if (item instanceof LogicalChildType) {
                toSegmentType.getFieldOrMappingOrLchild().add(this.cloneLogicalChildType((LogicalChildType)item));
            } else if (item instanceof MappingType) {
                toSegmentType.getFieldOrMappingOrLchild().add(SegmentModel.cloneMappingType((MappingType)item));
            } else if (item instanceof SysRelFieldType) {
                toSegmentType.getFieldOrMappingOrLchild().add(SegmentModel.cloneSysRelFieldType((SysRelFieldType)item));
            }
            ++i;
        }
    }

    private LogicalChildType cloneLogicalChildType(LogicalChildType fromLogicalChildType) {
        LogicalChildType toLogicalChildType = new LogicalChildType();
        toLogicalChildType.setDbd(fromLogicalChildType.getDbd());
        toLogicalChildType.setIndex(fromLogicalChildType.getIndex());
        toLogicalChildType.setName(fromLogicalChildType.getName());
        toLogicalChildType.setPair(fromLogicalChildType.getPair());
        toLogicalChildType.setPointer(fromLogicalChildType.getPointer());
        toLogicalChildType.setRootKeySize(fromLogicalChildType.getRootKeySize());
        toLogicalChildType.setRules(fromLogicalChildType.getRules());
        XdfldType xdfld = fromLogicalChildType.getXdfld();
        if (xdfld != null) {
            toLogicalChildType.setXdfld(this.cloneXdfldType(xdfld));
        }
        return toLogicalChildType;
    }

    public static MappingType cloneMappingType(MappingType fromMappingType) {
        MappingType toMappingType = new MappingType();
        toMappingType.setName(fromMappingType.getName());
        toMappingType.setControlSegmentName(fromMappingType.getControlSegmentName());
        toMappingType.setDependingOnField(fromMappingType.getDependingOnField());
        toMappingType.setRemarks(fromMappingType.getRemarks());
        List<MappingCaseType> fromCaseList = fromMappingType.getCase();
        List<MappingCaseType> toCaseList = toMappingType.getCase();
        for (MappingCaseType mct : fromCaseList) {
            toCaseList.add(SegmentModel.cloneCaseType(mct));
        }
        return toMappingType;
    }

    public static MappingCaseType cloneCaseType(MappingCaseType fromCaseType) {
        MappingCaseType toCaseType = new MappingCaseType();
        toCaseType.setName(fromCaseType.getName());
        DependingOnFieldValueType fromDepType = fromCaseType.getDependingOnFieldValue();
        DependingOnFieldValueType toDepType = new DependingOnFieldValueType();
        toDepType.setValue(fromDepType.getValue());
        toDepType.setValueDatatype(fromDepType.getValueDatatype());
        toCaseType.setDependingOnFieldValue(toDepType);
        toCaseType.setRemarks(fromCaseType.getRemarks());
        List<FieldType> fromFieldList = fromCaseType.getField();
        List<FieldType> toFieldList = toCaseType.getField();
        for (FieldType fromFieldType : fromFieldList) {
            toFieldList.add(SegmentModel.cloneFieldType(fromFieldType));
        }
        return toCaseType;
    }

    private XdfldType cloneXdfldType(XdfldType fromXdfldType) {
        XdfldType toXdfldType = new XdfldType();
        toXdfldType.setConst(fromXdfldType.getConst());
        toXdfldType.setImsName(fromXdfldType.getImsName());
        toXdfldType.setIndexExitRoutine(fromXdfldType.getIndexExitRoutine());
        toXdfldType.setName(fromXdfldType.getName());
        toXdfldType.setNullValue(fromXdfldType.getNullValue());
        toXdfldType.setPselopt(fromXdfldType.getPselopt());
        toXdfldType.setPselrtn(fromXdfldType.getPselrtn());
        toXdfldType.setSourceSegment(fromXdfldType.getSourceSegment());
        FieldListType fromFieldListType = fromXdfldType.getDuplicateData();
        if (fromFieldListType != null && fromFieldListType.getField().size() > 0) {
            toXdfldType.setDuplicateData(this.cloneFieldListType(fromFieldListType));
        }
        fromFieldListType = null;
        fromFieldListType = fromXdfldType.getSearch();
        if (fromFieldListType != null && fromFieldListType.getField().size() > 0) {
            toXdfldType.setSearch(this.cloneFieldListType(fromFieldListType));
        }
        fromFieldListType = null;
        fromFieldListType = fromXdfldType.getSubsequence();
        if (fromFieldListType != null && fromFieldListType.getField().size() > 0) {
            toXdfldType.setSubsequence(this.cloneFieldListType(fromFieldListType));
        }
        return toXdfldType;
    }

    private FieldListType cloneFieldListType(FieldListType fromFieldListType) {
        FieldListType toFieldListType = new FieldListType();
        List<String> list = fromFieldListType.getField();
        int i = 0;
        while (i < list.size()) {
            String element = list.get(i);
            toFieldListType.getField().add(element);
            ++i;
        }
        return toFieldListType;
    }

    public static FieldType cloneFieldType(FieldType fromFieldType) {
        ApplicationDatatypeType fromAdt;
        FieldType toFieldType = new FieldType();
        toFieldType.setStartPos(fromFieldType.getStartPos());
        toFieldType.setRelativeStart(fromFieldType.getRelativeStart());
        toFieldType.setStartAfter(fromFieldType.getStartAfter());
        toFieldType.setBytes(fromFieldType.getBytes());
        toFieldType.setMaxBytes(fromFieldType.getMaxBytes());
        toFieldType.setRemarks(fromFieldType.getRemarks());
        MarshallerType marshaller = fromFieldType.getMarshaller();
        if (marshaller != null) {
            toFieldType.setMarshaller(SegmentModel.cloneMarshallerType(marshaller));
        }
        if ((fromAdt = fromFieldType.getApplicationDatatype()) != null) {
            ApplicationDatatypeType toAdt = new ApplicationDatatypeType();
            toAdt.setDatatype(fromAdt.getDatatype());
            toAdt.setPrecision(fromAdt.getPrecision());
            toAdt.setScale(fromAdt.getScale());
            toFieldType.setApplicationDatatype(toAdt);
        }
        Iterator<FieldType> subFieldIter = fromFieldType.getField().iterator();
        List<FieldType> toFieldTypeSubFieldList = toFieldType.getField();
        while (subFieldIter.hasNext()) {
            FieldType currSubField = subFieldIter.next();
            toFieldTypeSubFieldList.add(SegmentModel.cloneFieldType(currSubField));
        }
        toFieldType.setName(fromFieldType.getName());
        toFieldType.setImsName(fromFieldType.getImsName());
        toFieldType.setSeqType(fromFieldType.getSeqType());
        toFieldType.setImsDatatype(fromFieldType.getImsDatatype());
        toFieldType.setDependsOn(fromFieldType.getDependsOn());
        toFieldType.setRedefines(fromFieldType.getRedefines());
        toFieldType.setMinOccurs(fromFieldType.getMinOccurs());
        toFieldType.setMaxOccurs(fromFieldType.getMaxOccurs());
        return toFieldType;
    }

    public static SysRelFieldType cloneSysRelFieldType(SysRelFieldType fromFieldType) {
        SysRelFieldType toFieldType = new SysRelFieldType();
        toFieldType.setBytes(fromFieldType.getBytes());
        toFieldType.setImsName(fromFieldType.getImsName());
        toFieldType.setName(fromFieldType.getName());
        toFieldType.setStartPos(fromFieldType.getStartPos());
        toFieldType.setRemarks(fromFieldType.getRemarks());
        return toFieldType;
    }

    public static MarshallerType cloneMarshallerType(MarshallerType fromMarshallerType) {
        MarshallerType toMarshallerType = new MarshallerType();
        toMarshallerType.setEncoding(fromMarshallerType.getEncoding());
        toMarshallerType.setIsNullable(fromMarshallerType.getIsNullable());
        toMarshallerType.setIsSigned(fromMarshallerType.getIsSigned());
        toMarshallerType.setIsPuredDBCS(fromMarshallerType.getIsPuredDBCS());
        toMarshallerType.setOverflow(fromMarshallerType.getOverflow());
        toMarshallerType.setPattern(fromMarshallerType.getPattern());
        toMarshallerType.setUrl(fromMarshallerType.getUrl());
        toMarshallerType.setUserTypeConverter(fromMarshallerType.getUserTypeConverter());
        toMarshallerType.setTypeConverter(fromMarshallerType.getTypeConverter());
        List<PropertyType> fromPropList = fromMarshallerType.getProperty();
        List<PropertyType> toPropList = toMarshallerType.getProperty();
        int i = 0;
        while (i < fromPropList.size()) {
            PropertyType fromProp = fromPropList.get(i);
            PropertyType toProp = new PropertyType();
            toProp.setName(fromProp.getName());
            toProp.setValue(fromProp.getValue());
            toPropList.add(toProp);
            ++i;
        }
        return toMarshallerType;
    }

    public List<DataExitRoutine> getDataCaptureExitRoutines() {
        return this.dataCaptureExitRoutines;
    }

    public boolean isDataCaptureExitNone() {
        JAXBElement<String> segExitNone;
        boolean retVal = false;
        String dbAccType = this.dbdModel.getAccessType().toString();
        if (dbAccType.equalsIgnoreCase("SHISAM")) {
            JAXBElement<String> segExitNone2 = this.jaxbSegment.getShisam().getSegExitNone();
            if (segExitNone2 != null) {
                retVal = true;
            }
        } else if (dbAccType.equalsIgnoreCase("HISAM")) {
            JAXBElement<String> segExitNone3 = this.jaxbSegment.getHisam().getSegExitNone();
            if (segExitNone3 != null) {
                retVal = true;
            }
        } else if (dbAccType.equalsIgnoreCase("HDAM")) {
            JAXBElement<String> segExitNone4 = this.jaxbSegment.getHdam().getSegExitNone();
            if (segExitNone4 != null) {
                retVal = true;
            }
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            JAXBElement<String> segExitNone5 = this.jaxbSegment.getPhdam().getSegExitNone();
            if (segExitNone5 != null) {
                retVal = true;
            }
        } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
            JAXBElement<String> segExitNone6 = this.jaxbSegment.getHidam().getSegExitNone();
            if (segExitNone6 != null) {
                retVal = true;
            }
        } else if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            JAXBElement<String> segExitNone7 = this.jaxbSegment.getPhidam().getSegExitNone();
            if (segExitNone7 != null) {
                retVal = true;
            }
        } else if (dbAccType.equalsIgnoreCase("DEDB") && (segExitNone = this.jaxbSegment.getDedb().getSegExitNone()) != null) {
            retVal = true;
        }
        return retVal;
    }

    public void setDataCaptureExitNone() {
        JAXBElement<String> segExitNone;
        String dbAccType = this.dbdModel.getAccessType().toString();
        ObjectFactory factory = new ObjectFactory();
        if (dbAccType.equalsIgnoreCase("SHISAM")) {
            JAXBElement<String> segExitNone2 = this.jaxbSegment.getShisam().getSegExitNone();
            if (segExitNone2 == null) {
                segExitNone2 = factory.createHisamAndShisamSegTypeSegExitNone("");
                this.jaxbSegment.getShisam().setSegExitNone(segExitNone2);
            }
        } else if (dbAccType.equalsIgnoreCase("HISAM")) {
            JAXBElement<String> segExitNone3 = this.jaxbSegment.getHisam().getSegExitNone();
            if (segExitNone3 == null) {
                segExitNone3 = factory.createHisamAndShisamSegTypeSegExitNone("");
                this.jaxbSegment.getHisam().setSegExitNone(segExitNone3);
            }
        } else if (dbAccType.equalsIgnoreCase("HDAM")) {
            JAXBElement<String> segExitNone4 = this.jaxbSegment.getHdam().getSegExitNone();
            if (segExitNone4 == null) {
                segExitNone4 = factory.createHisamAndShisamSegTypeSegExitNone("");
                this.jaxbSegment.getHdam().setSegExitNone(segExitNone4);
            }
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            JAXBElement<String> segExitNone5 = this.jaxbSegment.getPhdam().getSegExitNone();
            if (segExitNone5 == null) {
                segExitNone5 = factory.createHisamAndShisamSegTypeSegExitNone("");
                this.jaxbSegment.getPhdam().setSegExitNone(segExitNone5);
            }
        } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
            JAXBElement<String> segExitNone6 = this.jaxbSegment.getHidam().getSegExitNone();
            if (segExitNone6 == null) {
                segExitNone6 = factory.createHisamAndShisamSegTypeSegExitNone("");
                this.jaxbSegment.getHidam().setSegExitNone(segExitNone6);
            }
        } else if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            JAXBElement<String> segExitNone7 = this.jaxbSegment.getPhidam().getSegExitNone();
            if (segExitNone7 == null) {
                segExitNone7 = factory.createHisamAndShisamSegTypeSegExitNone("");
                this.jaxbSegment.getPhidam().setSegExitNone(segExitNone7);
            }
        } else if (dbAccType.equalsIgnoreCase("DEDB") && (segExitNone = this.jaxbSegment.getDedb().getSegExitNone()) == null) {
            segExitNone = factory.createDedbSegTypeSegExitNone("");
            this.jaxbSegment.getDedb().setSegExitNone(segExitNone);
        }
    }

    public void addDataCaptureExitRoutine(DataExitRoutine exitRoutine) throws ModelException {
        if (this.dbdModel.getAccessType() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        if (this.dataCaptureExitRoutines == null) {
            this.dataCaptureExitRoutines = new ArrayList();
        }
        this.dataCaptureExitRoutines.add(exitRoutine);
        String dbAccType = this.dbdModel.getAccessType().toString();
        ExitContainerType exitContainer = null;
        if (dbAccType.equalsIgnoreCase("SHISAM")) {
            exitContainer = this.jaxbSegment.getShisam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getShisam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HISAM")) {
            exitContainer = this.jaxbSegment.getHisam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getHisam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HDAM")) {
            exitContainer = this.jaxbSegment.getHdam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getHdam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            exitContainer = this.jaxbSegment.getPhdam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getPhdam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
            exitContainer = this.jaxbSegment.getHidam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getHidam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            exitContainer = this.jaxbSegment.getPhidam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getPhidam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("DEDB")) {
            exitContainer = this.jaxbSegment.getDedb().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getDedb().setExitContainer(exitContainer);
            }
        } else {
            Object[] dbError = new String[]{dbAccType};
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1602", dbError));
        }
        exitContainer.getDataCaptureExitRoutine().add(exitRoutine.getJaxbExit());
    }

    public void addDataCaptureExitRoutine(DataExitRoutine exitRoutine, boolean clearExisting) throws ModelException {
        if (this.dbdModel.getAccessType() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        if (this.dataCaptureExitRoutines == null || clearExisting) {
            this.dataCaptureExitRoutines = new ArrayList();
        }
        this.dataCaptureExitRoutines.add(exitRoutine);
        String dbAccType = this.dbdModel.getAccessType().toString();
        ExitContainerType exitContainer = null;
        if (dbAccType.equalsIgnoreCase("SHISAM")) {
            exitContainer = this.jaxbSegment.getShisam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getShisam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HISAM")) {
            exitContainer = this.jaxbSegment.getHisam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getHisam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HDAM")) {
            exitContainer = this.jaxbSegment.getHdam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getHdam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            exitContainer = this.jaxbSegment.getPhdam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getPhdam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
            exitContainer = this.jaxbSegment.getHidam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getHidam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            exitContainer = this.jaxbSegment.getPhidam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getPhidam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("DEDB")) {
            exitContainer = this.jaxbSegment.getDedb().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.jaxbSegment.getDedb().setExitContainer(exitContainer);
            }
        } else {
            Object[] dbError = new String[]{dbAccType};
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1602", dbError));
        }
        if (clearExisting) {
            exitContainer.getDataCaptureExitRoutine().clear();
        }
        exitContainer.getDataCaptureExitRoutine().add(exitRoutine.getJaxbExit());
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String toString() {
        return this.jaxbSegment.getImsName() + " aka " + this.jaxbSegment.getName();
    }

    public SegmentModel getParent() {
        return this.parent;
    }

    public SegmentType getSegmentType() {
        return this.jaxbSegment;
    }

    public void replaceOrigMappingWithClone(MappingModel origMappingModel, MappingModel clonedMappingModel) {
        List<Object> objList = this.jaxbSegment.getFieldOrMappingOrLchild();
        for (Object currObj : objList) {
            if (!(currObj instanceof MappingType) || !((MappingType)currObj).getName().equals(origMappingModel.getName())) continue;
            objList.remove(currObj);
            objList.add(clonedMappingModel.getMappingType());
            break;
        }
        this.mappingList.remove(origMappingModel.getName());
        this.mappingList.put(clonedMappingModel.getName(), clonedMappingModel);
    }

    public void removeMapping(String mappingName) {
        List<Object> objList = this.jaxbSegment.getFieldOrMappingOrLchild();
        for (Object currObj : objList) {
            if (!(currObj instanceof MappingType) || !((MappingType)currObj).getName().equals(mappingName)) continue;
            objList.remove(currObj);
            break;
        }
        this.mappingList.remove(mappingName);
    }

    public void clearMappingList() {
        List<Object> objList = this.jaxbSegment.getFieldOrMappingOrLchild();
        int i = 0;
        while (i < objList.size()) {
            Object currObj = objList.get(i);
            if (currObj instanceof MappingType) {
                objList.remove(currObj);
                --i;
            }
            ++i;
        }
        if (this.mappingList != null) {
            this.mappingList.clear();
        }
    }

    public void addNewMappingModel(MappingModel newMappingModel) {
        this.jaxbSegment.getFieldOrMappingOrLchild().add(newMappingModel.getMappingType());
        this.mappingList.put(newMappingModel.getName(), newMappingModel);
    }

    public void addNewCaseModel(String mappingName, MappingCaseModel newMappingCaseModel) {
        MappingModel mappingModel = this.mappingList.get(mappingName);
        mappingModel.addNewCaseModel(newMappingCaseModel);
    }

    public void replaceOrigCaseWithClone(String mappingName, MappingCaseModel origCaseModel, MappingCaseModel clonedCaseModel) {
        MappingModel mappingModel = this.mappingList.get(mappingName);
        mappingModel.replaceOrigCaseWithClone(origCaseModel, clonedCaseModel);
    }

    public void setLogicalChildSourceData(DBDConstants value) {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL) {
            ConcatenatedSegmentSourceType concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource();
            if (concat == null) {
                concat = new ConcatenatedSegmentSourceType();
                this.jaxbSegment.getLogical().setConcatenatedSegmentSource(concat);
                concat.setLogicalChildSource(new SegmentSourceType());
                concat.setTargetParentSource(new SegmentSourceType());
            }
            concat.getLogicalChildSource().setData(YesnoType.valueOf(value.toString()));
        }
    }

    public void setLogicalChildSourceDBName(String value) {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL) {
            ConcatenatedSegmentSourceType concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource();
            if (concat == null) {
                concat = new ConcatenatedSegmentSourceType();
                this.jaxbSegment.getLogical().setConcatenatedSegmentSource(concat);
                concat.setLogicalChildSource(new SegmentSourceType());
                concat.setTargetParentSource(new SegmentSourceType());
            }
            concat.getLogicalChildSource().setDbname(value);
        }
    }

    public void setLogicalChildSourceSegName(String value) {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL) {
            ConcatenatedSegmentSourceType concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource();
            if (concat == null) {
                concat = new ConcatenatedSegmentSourceType();
                this.jaxbSegment.getLogical().setConcatenatedSegmentSource(concat);
                concat.setLogicalChildSource(new SegmentSourceType());
                concat.setTargetParentSource(new SegmentSourceType());
            }
            concat.getLogicalChildSource().setSegname(value);
        }
    }

    public void setTargetParentSourceData(DBDConstants value) {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL) {
            ConcatenatedSegmentSourceType concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource();
            if (concat == null) {
                concat = new ConcatenatedSegmentSourceType();
                this.jaxbSegment.getLogical().setConcatenatedSegmentSource(concat);
                concat.setLogicalChildSource(new SegmentSourceType());
                concat.setTargetParentSource(new SegmentSourceType());
            }
            concat.getTargetParentSource().setData(YesnoType.valueOf(value.toString()));
        }
    }

    public void setTargetParentSourceDBName(String value) {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL) {
            ConcatenatedSegmentSourceType concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource();
            if (concat == null) {
                concat = new ConcatenatedSegmentSourceType();
                this.jaxbSegment.getLogical().setConcatenatedSegmentSource(concat);
                concat.setLogicalChildSource(new SegmentSourceType());
                concat.setTargetParentSource(new SegmentSourceType());
            }
            concat.getTargetParentSource().setDbname(value);
        }
    }

    public void setTargetParentSourceSegName(String value) {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL) {
            ConcatenatedSegmentSourceType concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource();
            if (concat == null) {
                concat = new ConcatenatedSegmentSourceType();
                this.jaxbSegment.getLogical().setConcatenatedSegmentSource(concat);
                concat.setLogicalChildSource(new SegmentSourceType());
                concat.setTargetParentSource(new SegmentSourceType());
            }
            concat.getTargetParentSource().setSegname(value);
        }
    }

    public DBDConstants getLogicalChildSourceData() {
        ConcatenatedSegmentSourceType concat;
        DBDConstants retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL && (concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource()) != null) {
            retVal = DBDConstants.valueOf(concat.getLogicalChildSource().getData().toString());
        }
        return retVal;
    }

    public String getLogicalChildSourceDBName() {
        ConcatenatedSegmentSourceType concat;
        String retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL && (concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource()) != null) {
            retVal = concat.getLogicalChildSource().getDbname();
        }
        return retVal;
    }

    public String getLogicalChildSourceSegName() {
        ConcatenatedSegmentSourceType concat;
        String retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL && (concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource()) != null) {
            retVal = concat.getLogicalChildSource().getSegname();
        }
        return retVal;
    }

    public DBDConstants getTargetParentSourceData() {
        ConcatenatedSegmentSourceType concat;
        DBDConstants retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL && (concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource()) != null) {
            retVal = DBDConstants.valueOf(concat.getTargetParentSource().getData().toString());
        }
        return retVal;
    }

    public String getTargetParentSourceDBName() {
        ConcatenatedSegmentSourceType concat;
        String retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL && (concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource()) != null) {
            retVal = concat.getTargetParentSource().getDbname();
        }
        return retVal;
    }

    public String getTargetParentSourceSegName() {
        ConcatenatedSegmentSourceType concat;
        String retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL && (concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource()) != null) {
            retVal = concat.getTargetParentSource().getSegname();
        }
        return retVal;
    }

    public DBDConstants getDBDAccessType() {
        return this.dbdModel.getAccessType();
    }

    public boolean hasConcatenatedSegmentSource() {
        ConcatenatedSegmentSourceType concat;
        boolean retVal = false;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL && (concat = this.jaxbSegment.getLogical().getConcatenatedSegmentSource()) != null) {
            retVal = true;
        }
        return retVal;
    }

    public String getSegmentSourceSegName() {
        SegmentSourceType segmentSource = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            segmentSource = this.jaxbSegment.getHisam().getSegmentSource();
        } else if (access == DBDConstants.SHISAM) {
            segmentSource = this.jaxbSegment.getShisam().getSegmentSource();
        } else if (access == DBDConstants.HDAM) {
            segmentSource = this.jaxbSegment.getHdam().getSegmentSource();
        } else if (access == DBDConstants.HIDAM) {
            segmentSource = this.jaxbSegment.getHidam().getSegmentSource();
        } else if (access == DBDConstants.LOGICAL) {
            segmentSource = this.jaxbSegment.getLogical().getSegmentSource();
        }
        if (segmentSource != null) {
            return segmentSource.getSegname();
        }
        return null;
    }

    public DBDConstants getSegmentSourceData() {
        DBDConstants retVal = null;
        SegmentSourceType segmentSource = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            segmentSource = this.jaxbSegment.getHisam().getSegmentSource();
        } else if (access == DBDConstants.SHISAM) {
            segmentSource = this.jaxbSegment.getShisam().getSegmentSource();
        } else if (access == DBDConstants.HDAM) {
            segmentSource = this.jaxbSegment.getHdam().getSegmentSource();
        } else if (access == DBDConstants.HIDAM) {
            segmentSource = this.jaxbSegment.getHidam().getSegmentSource();
        } else if (access == DBDConstants.LOGICAL) {
            segmentSource = this.jaxbSegment.getLogical().getSegmentSource();
        }
        if (segmentSource != null) {
            return DBDConstants.fromValue(segmentSource.getData().toString());
        }
        return retVal;
    }

    public String getSegmentSourceDBName() {
        SegmentSourceType segmentSource = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            segmentSource = this.jaxbSegment.getHisam().getSegmentSource();
        } else if (access == DBDConstants.SHISAM) {
            segmentSource = this.jaxbSegment.getShisam().getSegmentSource();
        } else if (access == DBDConstants.HDAM) {
            segmentSource = this.jaxbSegment.getHdam().getSegmentSource();
        } else if (access == DBDConstants.HIDAM) {
            segmentSource = this.jaxbSegment.getHidam().getSegmentSource();
        } else if (access == DBDConstants.LOGICAL) {
            segmentSource = this.jaxbSegment.getLogical().getSegmentSource();
        }
        if (segmentSource != null) {
            return segmentSource.getDbname();
        }
        return null;
    }

    public boolean hasLogicalParent() {
        boolean retVal = false;
        if (this.isRealLogicalChild() || this.isVirtualLogicalChild()) {
            retVal = true;
        }
        return retVal;
    }

    public boolean hasLogicalChild() {
        List<Object> list = this.jaxbSegment.getFieldOrMappingOrLchild();
        for (Object item : list) {
            LchildPointerType ptrType;
            if (!(item instanceof LogicalChildType) || (ptrType = ((LogicalChildType)item).getPointer()) == LchildPointerType.INDX || ptrType == LchildPointerType.SYMB) continue;
            return true;
        }
        return false;
    }

    public void createLogicalParent() {
        LogicalParentType lParent = new LogicalParentType();
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            this.jaxbSegment.getHisam().setLogicalParent(lParent);
        } else if (access == DBDConstants.SHISAM) {
            this.jaxbSegment.getShisam().setLogicalParent(lParent);
        } else if (access == DBDConstants.HDAM) {
            this.jaxbSegment.getHdam().setLogicalParent(lParent);
        } else if (access == DBDConstants.HIDAM) {
            this.jaxbSegment.getHidam().setLogicalParent(lParent);
        } else if (access == DBDConstants.PHDAM) {
            this.jaxbSegment.getPhdam().setLogicalParent(lParent);
        } else if (access == DBDConstants.PHIDAM) {
            this.jaxbSegment.getPhidam().setLogicalParent(lParent);
        }
    }

    public String getLogicalParentName() {
        LogicalParentType lParent;
        String retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            LogicalParentType lParent2 = this.jaxbSegment.getHisam().getLogicalParent();
            if (lParent2 != null) {
                retVal = lParent2.getParent();
            }
        } else if (access == DBDConstants.SHISAM) {
            LogicalParentType lParent3 = this.jaxbSegment.getShisam().getLogicalParent();
            if (lParent3 != null) {
                retVal = lParent3.getParent();
            }
        } else if (access == DBDConstants.HDAM) {
            LogicalParentType lParent4 = this.jaxbSegment.getHdam().getLogicalParent();
            if (lParent4 != null) {
                retVal = lParent4.getParent();
            }
        } else if (access == DBDConstants.HIDAM) {
            LogicalParentType lParent5 = this.jaxbSegment.getHidam().getLogicalParent();
            if (lParent5 != null) {
                retVal = lParent5.getParent();
            }
        } else if (access == DBDConstants.PHDAM) {
            LogicalParentType lParent6 = this.jaxbSegment.getPhdam().getLogicalParent();
            if (lParent6 != null) {
                retVal = lParent6.getParent();
            }
        } else if (access == DBDConstants.PHIDAM && (lParent = this.jaxbSegment.getPhidam().getLogicalParent()) != null) {
            retVal = lParent.getParent();
        }
        return retVal;
    }

    public String getLogicalParentDbdName() {
        LogicalParentType lParent;
        String retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            LogicalParentType lParent2 = this.jaxbSegment.getHisam().getLogicalParent();
            if (lParent2 != null) {
                retVal = lParent2.getDbd();
            }
        } else if (access == DBDConstants.SHISAM) {
            LogicalParentType lParent3 = this.jaxbSegment.getShisam().getLogicalParent();
            if (lParent3 != null) {
                retVal = lParent3.getDbd();
            }
        } else if (access == DBDConstants.HDAM) {
            LogicalParentType lParent4 = this.jaxbSegment.getHdam().getLogicalParent();
            if (lParent4 != null) {
                retVal = lParent4.getDbd();
            }
        } else if (access == DBDConstants.HIDAM) {
            LogicalParentType lParent5 = this.jaxbSegment.getHidam().getLogicalParent();
            if (lParent5 != null) {
                retVal = lParent5.getDbd();
            }
        } else if (access == DBDConstants.PHDAM) {
            LogicalParentType lParent6 = this.jaxbSegment.getPhdam().getLogicalParent();
            if (lParent6 != null) {
                retVal = lParent6.getDbd();
            }
        } else if (access == DBDConstants.PHIDAM && (lParent = this.jaxbSegment.getPhidam().getLogicalParent()) != null) {
            retVal = lParent.getDbd();
        }
        return retVal;
    }

    public String getLogicalParentLpck() {
        LogicalParentType lParent;
        String retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            LogicalParentType lParent2 = this.jaxbSegment.getHisam().getLogicalParent();
            if (lParent2 != null && lParent2.getLpck() != null) {
                retVal = lParent2.getLpck().toString();
            }
        } else if (access == DBDConstants.SHISAM) {
            LogicalParentType lParent3 = this.jaxbSegment.getShisam().getLogicalParent();
            if (lParent3 != null && lParent3.getLpck() != null) {
                retVal = lParent3.getLpck().toString();
            }
        } else if (access == DBDConstants.HDAM) {
            LogicalParentType lParent4 = this.jaxbSegment.getHdam().getLogicalParent();
            if (lParent4 != null && lParent4.getLpck() != null) {
                retVal = lParent4.getLpck().toString();
            }
        } else if (access == DBDConstants.HIDAM) {
            LogicalParentType lParent5 = this.jaxbSegment.getHidam().getLogicalParent();
            if (lParent5 != null && lParent5.getLpck() != null) {
                retVal = lParent5.getLpck().toString();
            }
        } else if (access == DBDConstants.PHDAM) {
            LogicalParentType lParent6 = this.jaxbSegment.getPhdam().getLogicalParent();
            if (lParent6 != null && lParent6.getLpck() != null) {
                retVal = lParent6.getLpck().toString();
            }
        } else if (access == DBDConstants.PHIDAM && (lParent = this.jaxbSegment.getPhidam().getLogicalParent()) != null && lParent.getLpck() != null) {
            retVal = lParent.getLpck().toString();
        }
        return retVal;
    }

    public void setLogicalParentName(String value) {
        LogicalParentType lParent = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            lParent = this.jaxbSegment.getHisam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getHisam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.SHISAM) {
            lParent = this.jaxbSegment.getShisam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getShisam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.HDAM) {
            lParent = this.jaxbSegment.getHdam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getHdam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.HIDAM) {
            lParent = this.jaxbSegment.getHidam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getHidam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.PHDAM) {
            lParent = this.jaxbSegment.getPhdam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getPhdam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.PHIDAM && (lParent = this.jaxbSegment.getPhidam().getLogicalParent()) == null) {
            lParent = new LogicalParentType();
            this.jaxbSegment.getPhidam().setLogicalParent(lParent);
        }
        lParent.setParent(value);
    }

    public void setLogicalParentDbdName(String value) {
        LogicalParentType lParent = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            lParent = this.jaxbSegment.getHisam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getHisam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.SHISAM) {
            lParent = this.jaxbSegment.getShisam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getShisam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.HDAM) {
            lParent = this.jaxbSegment.getHdam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getHdam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.HIDAM) {
            lParent = this.jaxbSegment.getHidam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getHidam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.PHDAM) {
            lParent = this.jaxbSegment.getPhdam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getPhdam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.PHIDAM && (lParent = this.jaxbSegment.getPhidam().getLogicalParent()) == null) {
            lParent = new LogicalParentType();
            this.jaxbSegment.getPhidam().setLogicalParent(lParent);
        }
        lParent.setDbd(value);
    }

    public void setLogicalParentLpck(DBDConstants value) {
        LogicalParentType lParent = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            lParent = this.jaxbSegment.getHisam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getHisam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.SHISAM) {
            lParent = this.jaxbSegment.getShisam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getShisam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.HDAM) {
            lParent = this.jaxbSegment.getHdam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getHdam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.HIDAM) {
            lParent = this.jaxbSegment.getHidam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getHidam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.PHDAM) {
            lParent = this.jaxbSegment.getPhdam().getLogicalParent();
            if (lParent == null) {
                lParent = new LogicalParentType();
                this.jaxbSegment.getPhdam().setLogicalParent(lParent);
            }
        } else if (access == DBDConstants.PHIDAM && (lParent = this.jaxbSegment.getPhidam().getLogicalParent()) == null) {
            lParent = new LogicalParentType();
            this.jaxbSegment.getPhidam().setLogicalParent(lParent);
        }
        lParent.setLpck(LpckType.valueOf(value.toString()));
    }

    public void createConcatenatedSegmentSource() {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.LOGICAL) {
            if (this.jaxbSegment.getLogical().getConcatenatedSegmentSource() == null) {
                ConcatenatedSegmentSourceType jaxbSegSource = this.objFactory.createConcatenatedSegmentSourceType();
                this.jaxbSegment.getLogical().setConcatenatedSegmentSource(jaxbSegSource);
            }
            if (this.jaxbSegment.getLogical().getConcatenatedSegmentSource().getLogicalChildSource() == null) {
                SegmentSourceType jaxbChildSource = this.objFactory.createSegmentSourceType();
                this.jaxbSegment.getLogical().getConcatenatedSegmentSource().setLogicalChildSource(jaxbChildSource);
            }
            if (this.jaxbSegment.getLogical().getConcatenatedSegmentSource().getTargetParentSource() == null) {
                SegmentSourceType jaxbTargetParent = this.objFactory.createSegmentSourceType();
                this.jaxbSegment.getLogical().getConcatenatedSegmentSource().setTargetParentSource(jaxbTargetParent);
            }
        }
    }

    public void createSegmentSource() {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            SegmentSourceType segmentSource = new SegmentSourceType();
            this.jaxbSegment.getHisam().setSegmentSource(segmentSource);
        } else if (access == DBDConstants.SHISAM) {
            SegmentSourceType segmentSource = new SegmentSourceType();
            this.jaxbSegment.getShisam().setSegmentSource(segmentSource);
        } else if (access == DBDConstants.HDAM) {
            SegmentSourceType segmentSource = new SegmentSourceType();
            this.jaxbSegment.getHdam().setSegmentSource(segmentSource);
        } else if (access == DBDConstants.HIDAM) {
            SegmentSourceType segmentSource = new SegmentSourceType();
            this.jaxbSegment.getHidam().setSegmentSource(segmentSource);
        } else if (access == DBDConstants.LOGICAL) {
            SegmentSourceType segmentSource = new SegmentSourceType();
            this.jaxbSegment.getLogical().setSegmentSource(segmentSource);
        }
    }

    public void setSegmentSourceSegName(String value) {
        SegmentSourceType segmentSource = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            segmentSource = this.jaxbSegment.getHisam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getHisam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.SHISAM) {
            segmentSource = this.jaxbSegment.getShisam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getShisam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.HDAM) {
            segmentSource = this.jaxbSegment.getHdam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getHdam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.HIDAM) {
            segmentSource = this.jaxbSegment.getHidam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getHidam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.LOGICAL && (segmentSource = this.jaxbSegment.getLogical().getSegmentSource()) == null) {
            segmentSource = new SegmentSourceType();
            this.jaxbSegment.getLogical().setSegmentSource(segmentSource);
        }
        segmentSource.setSegname(value);
    }

    public void setSegmentSourceData(DBDConstants value) {
        SegmentSourceType segmentSource = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            segmentSource = this.jaxbSegment.getHisam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getHisam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.SHISAM) {
            segmentSource = this.jaxbSegment.getShisam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getShisam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.HDAM) {
            segmentSource = this.jaxbSegment.getHdam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getHdam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.HIDAM) {
            segmentSource = this.jaxbSegment.getHidam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getHidam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.LOGICAL && (segmentSource = this.jaxbSegment.getLogical().getSegmentSource()) == null) {
            segmentSource = new SegmentSourceType();
            this.jaxbSegment.getLogical().setSegmentSource(segmentSource);
        }
        segmentSource.setData(YesnoType.valueOf(value.toString()));
    }

    public void setSegmentSourceDbname(String value) {
        SegmentSourceType segmentSource = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            segmentSource = this.jaxbSegment.getHisam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getHisam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.SHISAM) {
            segmentSource = this.jaxbSegment.getShisam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getShisam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.HDAM) {
            segmentSource = this.jaxbSegment.getHdam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getHdam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.HIDAM) {
            segmentSource = this.jaxbSegment.getHidam().getSegmentSource();
            if (segmentSource == null) {
                segmentSource = new SegmentSourceType();
                this.jaxbSegment.getHidam().setSegmentSource(segmentSource);
            }
        } else if (access == DBDConstants.LOGICAL && (segmentSource = this.jaxbSegment.getLogical().getSegmentSource()) == null) {
            segmentSource = new SegmentSourceType();
            this.jaxbSegment.getLogical().setSegmentSource(segmentSource);
        }
        segmentSource.setDbname(value);
    }

    public boolean hasSegmentSource() {
        boolean retVal = false;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            if (this.jaxbSegment.getHisam().getSegmentSource() != null) {
                retVal = true;
            }
        } else if (access == DBDConstants.SHISAM) {
            if (this.jaxbSegment.getShisam().getSegmentSource() != null) {
                retVal = true;
            }
        } else if (access == DBDConstants.HDAM) {
            if (this.jaxbSegment.getHdam().getSegmentSource() != null) {
                retVal = true;
            }
        } else if (access == DBDConstants.HIDAM) {
            if (this.jaxbSegment.getHidam().getSegmentSource() != null) {
                retVal = true;
            }
        } else if (access == DBDConstants.LOGICAL && this.jaxbSegment.getLogical().getSegmentSource() != null) {
            retVal = true;
        }
        return retVal;
    }

    public List<SegmentModel> getChildSegments() {
        return this.childSegments;
    }

    public SegmentModel getChildSegment(String segmentName) {
        SegmentModel retVal = null;
        int i = 0;
        while (i < this.childSegments.size()) {
            SegmentModel tempSeg = this.childSegments.get(i);
            if (tempSeg.getImsName().equalsIgnoreCase(segmentName)) {
                retVal = tempSeg;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public Vector<FieldModel> getConcatenatedFieldList(SegmentModel lchildSourceSeg, SegmentModel targetParentSourceSeg, String pcbName, boolean updateTargetParentFieldStarts) throws ModelException {
        int i;
        Vector<FieldModel> retVal = null;
        Vector<FieldModel> lchildFields = null;
        Vector<FieldModel> targetParentFields = null;
        int totalNumFields = 0;
        DBDConstants lchildSourceData = this.getLogicalChildSourceData();
        DBDConstants targetParentSourceData = this.getTargetParentSourceData();
        if (lchildSourceData == DBDConstants.Y) {
            lchildFields = lchildSourceSeg.getFieldList(true, false);
            totalNumFields += lchildFields.size();
        }
        if (targetParentSourceData == DBDConstants.Y) {
            targetParentFields = targetParentSourceSeg.getFieldList(true, false);
            totalNumFields += targetParentFields.size();
        }
        if (lchildSourceData == DBDConstants.Y && targetParentSourceData == DBDConstants.Y) {
            int lchildSegSize = lchildSourceSeg.getMaxBytes();
            int i2 = 0;
            while (i2 < targetParentFields.size()) {
                FieldModel currTargetParentField = targetParentFields.get(i2);
                FieldModelImpl newField = new FieldModelImpl((FieldModelImpl)currTargetParentField);
                newField.setStartPos(newField.getStartPos() + lchildSegSize);
                targetParentFields.remove(i2);
                targetParentFields.add(i2, newField);
                ++i2;
            }
            i2 = 0;
            while (i2 < lchildFields.size()) {
                FieldModel currLchildField = lchildFields.get(i2);
                int j = 0;
                while (j < targetParentFields.size()) {
                    FieldModel currTargetParentField = targetParentFields.get(j);
                    if (currLchildField.getName().equals(currTargetParentField.getName())) {
                        String segName = targetParentSourceSeg.getName();
                        String fieldName = currTargetParentField.getName();
                        String newName = pcbName + "_" + segName + "_" + fieldName;
                        currTargetParentField.setName(newName);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        retVal = new Vector<FieldModel>(totalNumFields);
        if (lchildFields != null) {
            i = 0;
            while (i < lchildFields.size()) {
                retVal.add(lchildFields.get(i));
                ++i;
            }
        }
        if (targetParentFields != null) {
            i = 0;
            while (i < targetParentFields.size()) {
                retVal.add(targetParentFields.get(i));
                ++i;
            }
        }
        return retVal;
    }

    public void addNewSegment(SegmentModel newModelSegment) {
        this.childSegments.add(newModelSegment);
        newModelSegment.setParent(this);
        this.jaxbSegment.getSegment().add(newModelSegment.getSegmentType());
    }

    public void removeSegment(SegmentModel modelSegment) {
        this.jaxbSegment.getSegment().remove(modelSegment.getSegmentType());
        this.childSegments.remove(modelSegment);
    }

    public int getMaxBytes() {
        int retVal = -1;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HSAM) {
            retVal = this.jaxbSegment.getHsam().getMaxBytes();
        } else if (access == DBDConstants.SHSAM) {
            retVal = this.jaxbSegment.getShsam().getMaxBytes();
        } else if (access == DBDConstants.INDEX) {
            retVal = this.jaxbSegment.getIndex() != null ? this.jaxbSegment.getIndex().getMaxBytes() : this.jaxbSegment.getShisam().getBytes().getMaxBytes();
        } else if (access == DBDConstants.MSDB) {
            retVal = this.jaxbSegment.getMsdb().getMaxBytes();
        } else if (access == DBDConstants.PSINDEX) {
            retVal = this.jaxbSegment.getPsindex().getMaxBytes();
        } else if (access == DBDConstants.HISAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getHisam().getBytes();
            if (bytes != null) {
                retVal = bytes.getMaxBytes();
            }
        } else if (access == DBDConstants.SHISAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getShisam().getBytes();
            if (bytes != null) {
                retVal = bytes.getMaxBytes();
            }
        } else if (access == DBDConstants.HDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getHdam().getBytes();
            if (bytes != null) {
                retVal = bytes.getMaxBytes();
            }
        } else if (access == DBDConstants.HIDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getHidam().getBytes();
            if (bytes != null) {
                retVal = bytes.getMaxBytes();
            }
        } else if (access == DBDConstants.PHDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getPhdam().getBytes();
            if (bytes != null) {
                retVal = bytes.getMaxBytes();
            }
        } else if (access == DBDConstants.PHIDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getPhidam().getBytes();
            if (bytes != null) {
                retVal = bytes.getMaxBytes();
            }
        } else if (access == DBDConstants.DEDB) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getDedb().getBytes();
            if (bytes != null) {
                retVal = bytes.getMaxBytes();
            }
        } else if (access == DBDConstants.GSAM) {
            RecfmType recfm = this.dbdModel.getDbd().getAccess().getGsam().getDataSet().getRecfm();
            retVal = recfm.equals((Object)RecfmType.V) || recfm.equals((Object)RecfmType.VB) ? 32756 : 32760;
        }
        return retVal;
    }

    public int getMinBytes() {
        MinAndMaxBytesType bytes;
        Integer retVal = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            MinAndMaxBytesType bytes2 = this.jaxbSegment.getHisam().getBytes();
            if (bytes2 != null) {
                retVal = bytes2.getMinBytes();
            }
        } else if (access == DBDConstants.SHISAM) {
            MinAndMaxBytesType bytes3 = this.jaxbSegment.getShisam().getBytes();
            if (bytes3 != null) {
                retVal = bytes3.getMinBytes();
            }
        } else if (access == DBDConstants.HDAM) {
            MinAndMaxBytesType bytes4 = this.jaxbSegment.getHdam().getBytes();
            if (bytes4 != null) {
                retVal = bytes4.getMinBytes();
            }
        } else if (access == DBDConstants.HIDAM) {
            MinAndMaxBytesType bytes5 = this.jaxbSegment.getHidam().getBytes();
            if (bytes5 != null) {
                retVal = bytes5.getMinBytes();
            }
        } else if (access == DBDConstants.PHDAM) {
            MinAndMaxBytesType bytes6 = this.jaxbSegment.getPhdam().getBytes();
            if (bytes6 != null) {
                retVal = bytes6.getMinBytes();
            }
        } else if (access == DBDConstants.PHIDAM) {
            MinAndMaxBytesType bytes7 = this.jaxbSegment.getPhidam().getBytes();
            if (bytes7 != null) {
                retVal = bytes7.getMinBytes();
            }
        } else if (access == DBDConstants.DEDB && (bytes = this.jaxbSegment.getDedb().getBytes()) != null) {
            retVal = bytes.getMinBytes();
        }
        if (retVal == null) {
            return -1;
        }
        return retVal;
    }

    public void setEncoding(String encoding) {
        this.jaxbSegment.setEncoding(encoding);
    }

    public String getEncoding() {
        return this.jaxbSegment.getEncoding();
    }

    public void setImsName(String imsName) {
        this.jaxbSegment.setImsName(imsName);
    }

    public void setName(String name) {
        this.jaxbSegment.setName(name);
    }

    public String getName() {
        Object retVal = this.jaxbSegment.getName();
        if (retVal == null || ((String)retVal).isEmpty()) {
            retVal = this.jaxbSegment.getImsName();
            this.jaxbSegment.setName((String)retVal);
        }
        if (Utility.hasReservedSQLKeywords((String)retVal)) {
            retVal = (String)retVal + "1";
            this.jaxbSegment.setName((String)retVal);
        }
        return retVal;
    }

    public void setParent(SegmentModel parent) {
        this.parent = parent;
    }

    public void setMaxBytes(int maxBytes) {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HSAM) {
            this.jaxbSegment.getHsam().setMaxBytes(maxBytes);
        } else if (access == DBDConstants.SHSAM) {
            this.jaxbSegment.getShsam().setMaxBytes(maxBytes);
        } else if (access == DBDConstants.INDEX) {
            if (this.jaxbSegment.getIndex() != null) {
                this.jaxbSegment.getIndex().setMaxBytes(maxBytes);
            } else {
                this.jaxbSegment.getShisam().getBytes().setMaxBytes(maxBytes);
            }
        } else if (access == DBDConstants.MSDB) {
            this.jaxbSegment.getMsdb().setMaxBytes(maxBytes);
        } else if (access == DBDConstants.PSINDEX) {
            this.jaxbSegment.getPsindex().setMaxBytes(maxBytes);
        } else if (access == DBDConstants.HISAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getHisam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getHisam().setBytes(bytes);
            }
            bytes.setMaxBytes(maxBytes);
        } else if (access == DBDConstants.SHISAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getShisam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getShisam().setBytes(bytes);
            }
            bytes.setMaxBytes(maxBytes);
        } else if (access == DBDConstants.HDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getHdam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getHdam().setBytes(bytes);
            }
            bytes.setMaxBytes(maxBytes);
        } else if (access == DBDConstants.HIDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getHidam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getHidam().setBytes(bytes);
            }
            bytes.setMaxBytes(maxBytes);
        } else if (access == DBDConstants.PHDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getPhdam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getPhdam().setBytes(bytes);
            }
            bytes.setMaxBytes(maxBytes);
        } else if (access == DBDConstants.PHIDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getPhidam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getPhidam().setBytes(bytes);
            }
            bytes.setMaxBytes(maxBytes);
        } else if (access == DBDConstants.DEDB) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getDedb().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getDedb().setBytes(bytes);
            }
            bytes.setMaxBytes(maxBytes);
        }
    }

    public void setMinBytes(int minBytes) {
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getHisam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getHisam().setBytes(bytes);
            }
            bytes.setMinBytes(minBytes);
        } else if (access == DBDConstants.SHISAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getShisam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getShisam().setBytes(bytes);
            }
            bytes.setMinBytes(minBytes);
        } else if (access == DBDConstants.HDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getHdam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getHdam().setBytes(bytes);
            }
            bytes.setMinBytes(minBytes);
        } else if (access == DBDConstants.HIDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getHidam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getHidam().setBytes(bytes);
            }
            bytes.setMinBytes(minBytes);
        } else if (access == DBDConstants.PHDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getPhdam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getPhdam().setBytes(bytes);
            }
            bytes.setMinBytes(minBytes);
        } else if (access == DBDConstants.PHIDAM) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getPhidam().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getPhidam().setBytes(bytes);
            }
            bytes.setMinBytes(minBytes);
        } else if (access == DBDConstants.DEDB) {
            MinAndMaxBytesType bytes = this.jaxbSegment.getDedb().getBytes();
            if (bytes == null) {
                bytes = new MinAndMaxBytesType();
                this.jaxbSegment.getDedb().setBytes(bytes);
            }
            bytes.setMinBytes(minBytes);
        }
    }

    public String getDbdName() {
        return this.dbdModel.getDbd().getDbdName();
    }

    public DbdModel getDbdModel() {
        return this.dbdModel;
    }

    public String getImsName() {
        return this.jaxbSegment.getImsName();
    }

    public boolean isPhysicalSegment() {
        return this.dbdModel.getAccessType() != DBDConstants.LOGICAL && !this.isVirtualLogicalChild();
    }

    public boolean isLogicalSegment() {
        return this.dbdModel.getAccessType() == DBDConstants.LOGICAL;
    }

    public boolean hasSecondaryIndexes() {
        Iterator<Object> fieldOrChildIter;
        List<Object> fieldOrChildList = this.jaxbSegment.getFieldOrMappingOrLchild();
        if (fieldOrChildList != null && (fieldOrChildIter = fieldOrChildList.iterator()) != null) {
            while (fieldOrChildIter.hasNext()) {
                LogicalChildType lChild;
                Object fieldOrChild = fieldOrChildIter.next();
                if (!(fieldOrChild instanceof LogicalChildType) || (lChild = (LogicalChildType)fieldOrChild).getXdfld() == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTargetForProcseq(String procseq) {
        Iterator<Object> fieldOrChildIter;
        List<Object> fieldOrChildList = this.jaxbSegment.getFieldOrMappingOrLchild();
        if (fieldOrChildList != null && (fieldOrChildIter = fieldOrChildList.iterator()) != null) {
            while (fieldOrChildIter.hasNext()) {
                LogicalChildType lChild;
                Object fieldOrChild = fieldOrChildIter.next();
                if (!(fieldOrChild instanceof LogicalChildType) || (lChild = (LogicalChildType)fieldOrChild).getXdfld() == null || !lChild.getDbd().equalsIgnoreCase(procseq)) continue;
                return true;
            }
        }
        return false;
    }

    public FieldModel getUnmappedFieldWithDupImsNameOrAlias(FieldModel editedField, FieldModel ignoreField) throws ModelException {
        Vector<FieldModel> fieldList = this.getFieldList(false, true);
        FieldModel retVal = this.getFieldWithDuplicateNameOrAlias(editedField, ignoreField, fieldList);
        return retVal;
    }

    public void checkMappedFieldWithDupImsNameOrAlias(FieldModel editedField, FieldModel ignoreField) throws ModelException, InvalidInputException {
        FieldModel existingField = null;
        Vector<FieldModel> fieldList = null;
        Iterator<MappingModel> iterator = this.getMappingList();
        while (iterator.hasNext()) {
            MappingModel mappingModel = iterator.next();
            if (mappingModel == null) continue;
            Iterator<MappingCaseModel> caseIterator = mappingModel.getMappingCases();
            while (caseIterator.hasNext()) {
                MappingCaseModel caseModel = caseIterator.next();
                if (caseModel == null || (existingField = this.getFieldWithDuplicateNameOrAlias(editedField, ignoreField, fieldList = caseModel.getFieldList(true))) == null) continue;
                String editedImsName = editedField.getImsName();
                String existingImsName = existingField.getImsName();
                if (editedImsName != null && existingImsName != null && !editedImsName.isEmpty() && !existingImsName.isEmpty() && editedImsName.equals(existingImsName)) {
                    Object[] inserts = new Object[]{existingField.getName(), mappingModel.getName(), caseModel.getName()};
                    String[] attrs = new String[]{"IMS_NAME"};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_6A", inserts), attrs);
                }
                String editedAlias = editedField.getAlias();
                String existingAlias = existingField.getAlias();
                if (editedAlias == null || existingAlias == null || editedAlias.isEmpty() || existingAlias.isEmpty() || !editedAlias.equals(existingAlias)) continue;
                Object[] inserts = new Object[]{existingField.getName(), mappingModel.getName(), caseModel.getName()};
                String[] attrs = new String[]{"ALIAS"};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_5A", inserts), attrs);
            }
        }
    }

    public FieldModel getSysRelFieldWithDupImsNameOrAlias(FieldModel editedField, FieldModel ignoreField) throws ModelException {
        Vector<FieldModel> fieldList = this.getSysRelFieldList();
        FieldModel retVal = this.getFieldWithDuplicateNameOrAlias(editedField, ignoreField, fieldList);
        return retVal;
    }

    private FieldModel getFieldWithDuplicateNameOrAlias(FieldModel editedField, FieldModel ignoreField, Vector<FieldModel> fieldList) {
        FieldModel retVal = null;
        if (fieldList != null) {
            int i = 0;
            while (i < fieldList.size()) {
                FieldModel currField = fieldList.get(i);
                if (currField != ignoreField) {
                    String imsName = editedField.getImsName();
                    if (imsName != null && !imsName.isEmpty() && imsName.equals(currField.getImsName())) {
                        retVal = currField;
                        break;
                    }
                    String alias = editedField.getName();
                    if (alias != null && !alias.isEmpty() && alias.equals(currField.getName())) {
                        retVal = currField;
                        break;
                    }
                }
                ++i;
            }
        }
        return retVal;
    }

    public FieldModel getFieldWithDupAlias(String alias, FieldModel ignoreField) throws ModelException {
        FieldModel retVal = null;
        Vector<FieldModel> fieldList = this.getFieldList(false, true);
        int i = 0;
        while (i < fieldList.size()) {
            FieldModel currField = fieldList.get(i);
            if (currField != ignoreField && alias.equals(currField.getName())) {
                retVal = currField;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public FieldModel getSecondSeqField(FieldModel ignoreField) throws ModelException {
        FieldModel retVal = null;
        Vector<FieldModel> fieldList = this.getFieldList(false, true);
        int i = 0;
        while (i < fieldList.size()) {
            FieldModel currField = fieldList.get(i);
            if (currField != ignoreField && currField.isSeq()) {
                retVal = currField;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public FieldModel getSeqField() throws ModelException {
        FieldModel retVal = null;
        Vector<FieldModel> fieldList = this.getFieldList(false, true);
        int i = 0;
        while (i < fieldList.size()) {
            FieldModel currField = fieldList.get(i);
            if (currField.isSeq()) {
                retVal = currField;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public boolean isVirtualLogicalChild() {
        boolean retVal = false;
        SegmentSourceType segmentSource = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            segmentSource = this.jaxbSegment.getHisam().getSegmentSource();
            if (segmentSource != null && this.parent != null) {
                retVal = true;
            }
        } else if (access == DBDConstants.SHISAM) {
            segmentSource = this.jaxbSegment.getShisam().getSegmentSource();
            if (segmentSource != null && this.parent != null) {
                retVal = true;
            }
        } else if (access == DBDConstants.HDAM) {
            segmentSource = this.jaxbSegment.getHdam().getSegmentSource();
            if (segmentSource != null && this.parent != null) {
                retVal = true;
            }
        } else if (access == DBDConstants.HIDAM && (segmentSource = this.jaxbSegment.getHidam().getSegmentSource()) != null && this.parent != null) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isRealLogicalChild() {
        LogicalParentType lParent = null;
        DBDConstants access = this.dbdModel.getAccessType();
        if (access == DBDConstants.HISAM) {
            lParent = this.jaxbSegment.getHisam().getLogicalParent();
        } else if (access == DBDConstants.SHISAM) {
            lParent = this.jaxbSegment.getShisam().getLogicalParent();
        } else if (access == DBDConstants.HDAM) {
            lParent = this.jaxbSegment.getHdam().getLogicalParent();
        } else if (access == DBDConstants.HIDAM) {
            lParent = this.jaxbSegment.getHidam().getLogicalParent();
        } else if (access == DBDConstants.PHDAM) {
            lParent = this.jaxbSegment.getPhdam().getLogicalParent();
        } else if (access == DBDConstants.PHIDAM) {
            lParent = this.jaxbSegment.getPhidam().getLogicalParent();
        }
        return lParent != null && lParent.getParent() != null && lParent.getParent().length() > 0;
    }

    public List<LogicalChildModel> getLogicalChildList() {
        return this.lChildList;
    }

    @Override
    public Vector<FieldModel> getFieldList(boolean ensureSeqFieldFirst, boolean overlayFieldsAdded) throws ModelException {
        Vector clonedFieldList = null;
        if (this.commonFieldList == null || this.commonFieldList.isEmpty()) {
            if (overlayFieldsAdded) {
                this.updateFieldStartValues();
            }
            this.buildFieldList();
        }
        clonedFieldList = (Vector)this.commonFieldList.clone();
        if (ensureSeqFieldFirst) {
            FieldModel currField;
            int i;
            Vector<FieldModel> tempList = new Vector<FieldModel>(clonedFieldList.size());
            boolean seqFieldFound = false;
            block0: do {
                seqFieldFound = false;
                i = 0;
                while (i < clonedFieldList.size()) {
                    currField = (FieldModel)clonedFieldList.get(i);
                    if (currField.isSeq()) {
                        seqFieldFound = true;
                        clonedFieldList.remove(i);
                        SegmentModel.addFieldInOrder(tempList, currField);
                        continue block0;
                    }
                    ++i;
                }
            } while (seqFieldFound);
            i = 0;
            while (i < tempList.size()) {
                currField = (FieldModel)tempList.get(i);
                clonedFieldList.insertElementAt(currField, i);
                ++i;
            }
        }
        return clonedFieldList;
    }

    public SegmentModel getLogicalSourceSegment() throws CoreException, ModelException {
        if (this.hasSegmentSource() && this.logicalSourceSeg == null) {
            String dbName = this.getSegmentSourceDBName();
            String segName = this.getSegmentSourceSegName();
            this.logicalSourceSeg = this.getLogicalSourceSegment(dbName, segName);
        }
        return this.logicalSourceSeg;
    }

    public SegmentModel getLChildSourceSegment() throws CoreException, ModelException {
        if (this.hasConcatenatedSegmentSource() && this.lchildSourceSeg == null) {
            String lchildDbName = this.getLogicalChildSourceDBName();
            String lchildSegName = this.getLogicalChildSourceSegName();
            this.lchildSourceSeg = this.getLogicalSourceSegment(lchildDbName, lchildSegName);
        }
        return this.lchildSourceSeg;
    }

    public SegmentModel getTargetParentSourceSegment() throws CoreException, ModelException {
        if (this.hasConcatenatedSegmentSource() && this.targetParentSourceSeg == null) {
            String targetParentDbName = this.getTargetParentSourceDBName();
            String targetParentSegName = this.getTargetParentSourceSegName();
            this.targetParentSourceSeg = this.getLogicalSourceSegment(targetParentDbName, targetParentSegName);
        }
        return this.targetParentSourceSeg;
    }

    private SegmentModel getLogicalSourceSegment(String dbdName, String segName) throws CoreException, ModelException {
        SegmentModel retVal = null;
        DbdModel newDb = ProjectTreeFileHelper.unmarshalDbd(dbdName, this.projectName);
        retVal = newDb.getSegment(segName);
        return retVal;
    }

    public void changeFieldsToSysRelFields() {
        boolean sysrelFieldFound;
        block0: do {
            sysrelFieldFound = false;
            for (Object fieldObj : this.jaxbSegment.getFieldOrMappingOrLchild()) {
                Integer Bytes;
                FieldType currField;
                String imsName;
                if (!(fieldObj instanceof FieldType) || (imsName = (currField = (FieldType)fieldObj).getImsName()) == null || !imsName.startsWith("/SX") && !imsName.startsWith("/CK")) continue;
                SysRelFieldType newField = new SysRelFieldType();
                newField.setImsName(currField.getImsName());
                newField.setName(currField.getName());
                Integer StartPos = currField.getStartPos();
                if (StartPos != null) {
                    newField.setStartPos(StartPos);
                }
                if ((Bytes = currField.getBytes()) != null) {
                    newField.setStartPos(Bytes);
                }
                newField.setRemarks(currField.getRemarks());
                this.jaxbSegment.getFieldOrMappingOrLchild().add(newField);
                this.jaxbSegment.getFieldOrMappingOrLchild().remove(currField);
                sysrelFieldFound = true;
                continue block0;
            }
        } while (sysrelFieldFound);
    }

    private void updateFieldStartValues() throws ModelException {
        Iterator<Object> fieldIter = this.jaxbSegment.getFieldOrMappingOrLchild().iterator();
        ArrayList<FieldType> fieldTypeList = new ArrayList<FieldType>();
        while (fieldIter.hasNext()) {
            Object fieldObj = fieldIter.next();
            if (!(fieldObj instanceof FieldType)) continue;
            fieldTypeList.add((FieldType)fieldObj);
        }
        SegmentModel.updateFieldStartValues(fieldTypeList, null, false);
    }

    public void clearStartInfo(String mapName, String caseName) throws ModelException {
        List<FieldType> fieldList = mapName.equals(ManageFieldsController.COMMON_FIELDS) ? this.getTopLevelFieldTypes() : this.getTopLevelFieldsForCase(caseName);
        int i = 0;
        while (i < fieldList.size()) {
            List<FieldType> children;
            FieldType currField = fieldList.get(i);
            String currStartAfter = currField.getStartAfter();
            if (currStartAfter != null && !currStartAfter.isEmpty()) {
                currField.setStartPos(null);
                currField.setRelativeStart(null);
                currField.setStartAfter(null);
            }
            if ((children = currField.getField()) != null && !children.isEmpty()) {
                this.clearStartInfo(children);
            }
            ++i;
        }
    }

    private void clearStartInfo(List<FieldType> fields) {
        int i = 0;
        while (i < fields.size()) {
            FieldType currField = fields.get(i);
            currField.setStartPos(null);
            currField.setRelativeStart(null);
            currField.setStartAfter(null);
            List<FieldType> children = currField.getField();
            if (children != null && !children.isEmpty()) {
                this.clearStartInfo(children);
            }
            ++i;
        }
    }

    public static boolean updateFieldStartValues(List<FieldType> childFieldList, FieldType parentField, boolean dynBoundedStructureAbove) throws ModelException {
        DatatypeType dt;
        ApplicationDatatypeType adt;
        boolean inRelStartMode = false;
        boolean parentIsArray = false;
        boolean dynBoundedStructureHere = false;
        boolean dynBoundedStructureBelow = false;
        int prevFieldOrRedefinesGroupLength = 0;
        int totalSizeOfFields = 0;
        Iterator<FieldType> fieldIter = childFieldList.iterator();
        if (parentField != null && (adt = parentField.getApplicationDatatype()) != null && (dt = adt.getDatatype()) == DatatypeType.ARRAY) {
            parentIsArray = true;
        }
        if (parentIsArray || dynBoundedStructureAbove) {
            inRelStartMode = true;
        }
        if (inRelStartMode) {
            prevField = null;
            while (fieldIter.hasNext()) {
                List<FieldType> subFields;
                String currDependsField;
                currChildField = fieldIter.next();
                SegmentModel.updateEmptyStructOrArraySize(currChildField);
                if (dynBoundedStructureHere) {
                    if (SegmentModel.isRedefiningField(currChildField)) {
                        currChildField.setStartAfter(prevField.getStartAfter());
                        currChildField.setStartPos(null);
                        currChildField.setRelativeStart(null);
                    } else {
                        currChildField.setStartAfter(prevField.getName());
                        currChildField.setStartPos(null);
                        currChildField.setRelativeStart(null);
                    }
                } else if (SegmentModel.isRedefiningField(currChildField)) {
                    currChildField.setRelativeStart(prevField.getRelativeStart());
                    currChildField.setStartPos(null);
                    currChildField.setStartAfter(null);
                } else {
                    int relStart = 1;
                    if (prevField != null) {
                        relStart = prevField.getRelativeStart() + prevFieldOrRedefinesGroupLength;
                    }
                    currChildField.setRelativeStart(relStart);
                    currChildField.setStartPos(null);
                    currChildField.setStartAfter(null);
                }
                if (!dynBoundedStructureHere && (currDependsField = currChildField.getDependsOn()) != null && !currDependsField.isEmpty()) {
                    dynBoundedStructureHere = true;
                }
                if ((subFields = currChildField.getField()) != null && subFields.size() > 0) {
                    boolean dynBoundedStructureBelowCurr = SegmentModel.updateFieldStartValues(subFields, currChildField, parentIsArray || dynBoundedStructureHere || dynBoundedStructureAbove);
                    if (!dynBoundedStructureBelow) {
                        dynBoundedStructureBelow = dynBoundedStructureBelowCurr;
                    }
                    if (dynBoundedStructureBelowCurr) {
                        dynBoundedStructureHere = true;
                    }
                }
                int currLength = SegmentModel.getLength(currChildField);
                if (SegmentModel.isRedefiningField(currChildField)) {
                    if (currLength > prevFieldOrRedefinesGroupLength) {
                        totalSizeOfFields += currLength - prevFieldOrRedefinesGroupLength;
                        prevFieldOrRedefinesGroupLength = currLength;
                    }
                } else {
                    prevFieldOrRedefinesGroupLength = currLength;
                    totalSizeOfFields += prevFieldOrRedefinesGroupLength;
                }
                prevField = currChildField;
            }
        } else {
            prevField = null;
            while (fieldIter.hasNext()) {
                List<FieldType> subFields;
                String dependsOnField;
                DatatypeType dt2;
                ApplicationDatatypeType adt2;
                currChildField = fieldIter.next();
                SegmentModel.updateEmptyStructOrArraySize(currChildField);
                Integer currFieldStart = currChildField.getStartPos();
                if (!(currFieldStart != null && currFieldStart != 0 || SegmentModel.isXMLField(currChildField))) {
                    Integer relStart = currChildField.getRelativeStart();
                    if (relStart != null && relStart > 0) {
                        if (parentField != null) {
                            currChildField.setStartPos(parentField.getStartPos() + relStart - 1);
                            currChildField.setRelativeStart(null);
                            currChildField.setStartAfter(null);
                        } else {
                            currChildField.setStartPos(relStart);
                            currChildField.setRelativeStart(null);
                            currChildField.setStartAfter(null);
                        }
                    } else if (prevField == null) {
                        if (parentField != null) {
                            currChildField.setStartPos(parentField.getStartPos());
                            currChildField.setStartAfter(null);
                            currChildField.setRelativeStart(null);
                        } else {
                            currChildField.setStartPos(1);
                            currChildField.setStartAfter(null);
                            currChildField.setRelativeStart(null);
                        }
                    } else if (dynBoundedStructureHere) {
                        if (SegmentModel.isRedefiningField(currChildField)) {
                            String prevStartAfterStr = prevField.getStartAfter();
                            if (prevStartAfterStr != null && !prevStartAfterStr.isEmpty()) {
                                currChildField.setStartAfter(prevStartAfterStr);
                                currChildField.setStartPos(null);
                                currChildField.setRelativeStart(null);
                            } else {
                                currChildField.setStartAfter(null);
                                currChildField.setStartPos(prevField.getStartPos());
                                currChildField.setRelativeStart(null);
                            }
                        } else {
                            String prevStartAfterStr = prevField.getStartAfter();
                            if (prevStartAfterStr != null && !prevStartAfterStr.isEmpty() || SegmentModel.isDynamic(prevField)) {
                                currChildField.setStartAfter(prevField.getName());
                                currChildField.setStartPos(null);
                                currChildField.setRelativeStart(null);
                            } else {
                                currChildField.setStartAfter(null);
                                currChildField.setStartPos(prevField.getStartPos() + prevFieldOrRedefinesGroupLength);
                                currChildField.setRelativeStart(null);
                            }
                        }
                    } else if (SegmentModel.isRedefiningField(currChildField)) {
                        currChildField.setStartAfter(null);
                        currChildField.setStartPos(prevField.getStartPos());
                        currChildField.setRelativeStart(null);
                    } else {
                        currChildField.setStartAfter(null);
                        currChildField.setStartPos(prevField.getStartPos() + prevFieldOrRedefinesGroupLength);
                        currChildField.setRelativeStart(null);
                    }
                }
                if (!dynBoundedStructureHere && (adt2 = currChildField.getApplicationDatatype()) != null && (dt2 = adt2.getDatatype()) == DatatypeType.ARRAY && (dependsOnField = currChildField.getDependsOn()) != null && !dependsOnField.isEmpty()) {
                    dynBoundedStructureHere = true;
                }
                if ((subFields = currChildField.getField()) != null && subFields.size() > 0) {
                    boolean dynBoundedStructureBelowCurr = SegmentModel.updateFieldStartValues(subFields, currChildField, parentIsArray || dynBoundedStructureHere || dynBoundedStructureAbove);
                    if (!dynBoundedStructureBelow) {
                        dynBoundedStructureBelow = dynBoundedStructureBelowCurr;
                    }
                    if (dynBoundedStructureBelowCurr) {
                        dynBoundedStructureHere = true;
                    }
                }
                int currLength = SegmentModel.getLength(currChildField);
                if (SegmentModel.isRedefiningField(currChildField)) {
                    if (currLength > prevFieldOrRedefinesGroupLength) {
                        totalSizeOfFields += currLength - prevFieldOrRedefinesGroupLength;
                        prevFieldOrRedefinesGroupLength = currLength;
                    }
                } else {
                    prevFieldOrRedefinesGroupLength = currLength;
                    totalSizeOfFields += prevFieldOrRedefinesGroupLength;
                }
                prevField = currChildField;
            }
        }
        if (parentField != null) {
            SegmentModel.setFieldSize(parentField, childFieldList, totalSizeOfFields);
        }
        return dynBoundedStructureHere || dynBoundedStructureBelow;
    }

    private static int getLength(FieldType field) {
        int retVal = 0;
        Integer bytesInt = field.getBytes();
        if (bytesInt == null || bytesInt == 0) {
            Integer maxBytesInt = field.getMaxBytes();
            if (maxBytesInt != null) {
                retVal = maxBytesInt;
            }
        } else {
            retVal = bytesInt;
        }
        return retVal;
    }

    private static boolean isRedefiningField(FieldType field) {
        boolean retVal = false;
        String redefinedFieldStr = field.getRedefines();
        if (redefinedFieldStr != null && !redefinedFieldStr.isEmpty()) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isDynamic(FieldType field) {
        boolean retVal = false;
        Integer maxBytesInt = field.getMaxBytes();
        if (maxBytesInt != null && maxBytesInt > 0) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isXMLField(FieldType field) {
        boolean retVal = false;
        ApplicationDatatypeType adt = field.getApplicationDatatype();
        if (adt != null && adt.getDatatype() == DatatypeType.XML) {
            retVal = true;
        }
        return retVal;
    }

    private static void updateEmptyStructOrArraySize(FieldType fieldType) {
        DatatypeType adtt;
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        if (adt != null && ((adtt = adt.getDatatype()) == DatatypeType.ARRAY || adtt == DatatypeType.STRUCT) && fieldType.getField().isEmpty()) {
            fieldType.setBytes(0);
            fieldType.setMaxBytes(0);
        }
    }

    private static void setFieldSize(FieldType parentField, List<FieldType> childFields, int sizeOfChildFieldList) throws ModelException {
        Integer parentMaxOccurs;
        boolean dynLengthChildExists = false;
        boolean parentIsDynArray = false;
        String parentDependsOn = parentField.getDependsOn();
        if (parentDependsOn != null && !parentDependsOn.isEmpty()) {
            parentIsDynArray = true;
        }
        if ((parentMaxOccurs = parentField.getMaxOccurs()) == null || parentMaxOccurs == 0) {
            parentMaxOccurs = 1;
        }
        int i = 0;
        while (i < childFields.size()) {
            FieldType currChild = childFields.get(i);
            Integer maxBytes = currChild.getMaxBytes();
            if (maxBytes != null && maxBytes > 0) {
                dynLengthChildExists = true;
                break;
            }
            ++i;
        }
        if (dynLengthChildExists || parentIsDynArray) {
            parentField.setMaxBytes(sizeOfChildFieldList * parentMaxOccurs);
            parentField.setBytes(0);
        } else {
            parentField.setBytes(sizeOfChildFieldList * parentMaxOccurs);
            parentField.setMaxBytes(0);
        }
    }

    public Vector<FieldModel> getTopLevelFieldList(boolean ensureSeqFieldFirst, boolean overlayFieldsAdded) throws ModelException {
        if (this.topLevelFieldList == null || this.topLevelFieldList.isEmpty()) {
            if (this.topLevelFieldList == null) {
                this.topLevelFieldList = new Vector();
            }
            Vector<FieldModel> allFields = this.getFieldList(ensureSeqFieldFirst, overlayFieldsAdded);
            int i = 0;
            while (i < allFields.size()) {
                FieldModel currField = allFields.get(i);
                if (currField.getParentField() == null) {
                    this.topLevelFieldList.add(currField);
                }
                ++i;
            }
        }
        return this.topLevelFieldList;
    }

    public Vector<FieldModel> getTopLevelFieldList() throws ModelException {
        return this.getTopLevelFieldList(true, true);
    }

    @Override
    public Vector<FieldModel> getFieldsInRange(FieldModel field, boolean canBeRedefinesField, boolean mustBeIMSField) throws ModelException {
        FieldModel currField;
        int i;
        Vector<FieldModel> retVal = new Vector<FieldModel>();
        this.getFieldsInRange(field, this.getTopLevelFieldList(), retVal);
        if (!canBeRedefinesField) {
            i = 0;
            while (i < retVal.size()) {
                currField = retVal.get(i);
                String redefines = currField.getRedefines();
                if (redefines != null && !redefines.isEmpty()) {
                    retVal.remove(currField);
                    --i;
                }
                ++i;
            }
        }
        if (mustBeIMSField) {
            i = 0;
            while (i < retVal.size()) {
                currField = retVal.get(i);
                if (!currField.isIMSField()) {
                    retVal.remove(currField);
                    --i;
                }
                ++i;
            }
        }
        return retVal;
    }

    private void getFieldsInRange(FieldModel field, Vector<FieldModel> existingFieldList, Vector<FieldModel> retVal) {
        int i = 0;
        while (i < existingFieldList.size()) {
            FieldModel currField = existingFieldList.get(i);
            if (currField != field) {
                if (currField.getStartPos() == field.getStartPos() && currField.getBytes() == field.getBytes()) {
                    retVal.add(currField);
                }
                if (currField.hasSubFields() && currField.getChildFields() != null) {
                    this.getFieldsInRange(field, currField.getChildFields(), retVal);
                }
            }
            ++i;
        }
    }

    public Vector<FieldModel> getSysRelFieldList() throws ModelException {
        if (this.sysRelFieldList == null || this.sysRelFieldList.isEmpty()) {
            this.buildSysRelFieldList();
        }
        Vector retVal = null;
        if (this.sysRelFieldList != null) {
            retVal = (Vector)this.sysRelFieldList.clone();
        }
        return retVal;
    }

    public FieldModel getFieldWithImsNameOrAlias(String fieldName) {
        FieldModelImpl retVal = null;
        Iterator<Object> listIter = this.jaxbSegment.getFieldOrMappingOrLchild().iterator();
        boolean fieldFound = false;
        while (listIter.hasNext()) {
            Object currObj = listIter.next();
            if (currObj instanceof MappingType) {
                for (MappingCaseType currCase : ((MappingType)currObj).getCase()) {
                    for (FieldType currField : currCase.getField()) {
                        String name = currField.getImsName();
                        if (name == null || name.isEmpty()) {
                            name = currField.getName();
                        }
                        if (!name.equalsIgnoreCase(fieldName)) continue;
                        retVal = new FieldModelImpl(currField);
                        fieldFound = true;
                        break;
                    }
                    if (!fieldFound) {
                        continue;
                    }
                    break;
                }
            } else if (currObj instanceof FieldType) {
                FieldType currField = (FieldType)currObj;
                String name = currField.getImsName();
                if (name == null || name.isEmpty()) {
                    name = currField.getName();
                }
                if (name.equalsIgnoreCase(fieldName)) {
                    retVal = new FieldModelImpl(currField);
                    break;
                }
            }
            if (fieldFound) break;
        }
        return retVal;
    }

    @Override
    public FieldModel getFieldWithAlias(String fieldName, SegmentModel existingSegmentModel) throws ModelException {
        FieldModelImpl retVal = null;
        boolean fieldFound = false;
        FieldType fieldType = SegmentModel.getJaxbFieldWithAlias(this.getTopLevelFieldTypes(), fieldName);
        if (fieldType == null) {
            for (MappingModel currMap : this.mappingList.values()) {
                Iterator<MappingCaseModel> caseIter = currMap.getMappingCases();
                while (caseIter.hasNext()) {
                    MappingCaseModel currCase = caseIter.next();
                    List<FieldType> caseFieldTypes = currCase.getTopLevelFieldTypes();
                    fieldType = SegmentModel.getJaxbFieldWithAlias(caseFieldTypes, fieldName);
                    if (fieldType == null) continue;
                    fieldFound = true;
                    break;
                }
                if (fieldFound) break;
            }
        }
        if (fieldType != null) {
            retVal = new FieldModelImpl(fieldType);
        }
        return retVal;
    }

    public static FieldModel getFieldWithAlias(Vector<FieldModel> fieldList, String alias) {
        FieldModel retVal = null;
        int i = 0;
        while (i < fieldList.size()) {
            FieldModel currField = fieldList.get(i);
            if (currField.getName().equals(alias)) {
                retVal = currField;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public static FieldType getJaxbFieldWithAlias(List<FieldType> fieldList, String fieldName) {
        FieldType retVal = null;
        int i = 0;
        while (i < fieldList.size()) {
            FieldType currField = fieldList.get(i);
            String currFieldName = currField.getName();
            if (currFieldName != null && currFieldName.equals(fieldName)) {
                retVal = currField;
                break;
            }
            List<FieldType> subFields = currField.getField();
            if (subFields != null && subFields.size() > 0 && (retVal = SegmentModel.getJaxbFieldWithAlias(subFields, fieldName)) != null) break;
            ++i;
        }
        return retVal;
    }

    public FieldType getJaxbFieldWithAlias(String fieldName, String caseName) {
        ArrayList<FieldType> fieldList;
        if (caseName != null && !caseName.isEmpty()) {
            fieldList = this.getTopLevelFieldsForCase(caseName);
        } else {
            fieldList = new ArrayList();
            for (Object fieldObj : this.jaxbSegment.getFieldOrMappingOrLchild()) {
                if (!(fieldObj instanceof FieldType)) continue;
                FieldType currField = (FieldType)fieldObj;
                fieldList.add(currField);
            }
        }
        return SegmentModel.getJaxbFieldWithAlias(fieldList, fieldName);
    }

    private List<FieldType> getTopLevelFieldsForCase(String caseName) {
        List<Object> objList = this.jaxbSegment.getFieldOrMappingOrLchild();
        int i = 0;
        while (i < objList.size()) {
            Object currObj = objList.get(i);
            if (currObj instanceof MappingType) {
                MappingType currMap = (MappingType)currObj;
                List<MappingCaseType> cases = currMap.getCase();
                int j = 0;
                while (j < cases.size()) {
                    MappingCaseType currCase = cases.get(j);
                    if (currCase.getName().equals(caseName)) {
                        return currCase.getField();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return new ArrayList<FieldType>();
    }

    public void setRemarksForField(String remarksValue, String fieldName) {
        for (Object fieldObj : this.jaxbSegment.getFieldOrMappingOrLchild()) {
            FieldType currField;
            String currFieldName;
            if (!(fieldObj instanceof FieldType) || (currFieldName = (currField = (FieldType)fieldObj).getName()) == null || !currFieldName.equals(fieldName)) continue;
            currField.setRemarks(remarksValue);
            break;
        }
    }

    private void buildLChildList() {
        Iterator<Object> fieldIter = this.jaxbSegment.getFieldOrMappingOrLchild().iterator();
        this.lChildList = new ArrayList();
        while (fieldIter.hasNext()) {
            Object fieldObj = fieldIter.next();
            if (!(fieldObj instanceof LogicalChildType)) continue;
            LogicalChildType logicalChild = (LogicalChildType)fieldObj;
            LogicalChildModel lchild = new LogicalChildModel(logicalChild);
            this.lChildList.add(lchild);
        }
    }

    @Override
    public void addField(FieldModel newField) throws ModelException {
        newField.setSegmentModel(this);
        if (newField.isSysRelField()) {
            this.clearSysRelFieldList();
            this.jaxbSegment.getFieldOrMappingOrLchild().add(((SysRelFieldModel)newField).getSysRelFieldType());
        } else {
            this.clearFieldList();
            FieldModel parentField = newField.getParentField();
            if (parentField == null) {
                this.addTopLevelField(newField);
            } else {
                this.addSubField(newField);
            }
        }
    }

    public void replaceTopLevelMapField(FieldModel origField, FieldModel newField, String mapName, String caseName) throws ModelException {
        MappingModel map = this.getMapping(mapName);
        MappingCaseModel caseModel = map.getMappingCaseModel(caseName);
        String startAfter = newField.getStartAfter();
        FieldModel startAfterModel = null;
        if (startAfter != null && !startAfter.isEmpty()) {
            startAfterModel = caseModel.getFieldWithAlias(startAfter, null);
        }
        caseModel.replaceTopLevelMapField(origField, newField, startAfterModel);
    }

    public void replaceTopLevelField(FieldModel origField, FieldModel newField) throws ModelException {
        this.clearFieldList();
        this.clearSysRelFieldList();
        String startAfter = newField.getStartAfter();
        FieldModel startAfterModel = null;
        FieldType startAfterJaxbField = null;
        if (startAfter != null && !startAfter.isEmpty() && (startAfterModel = this.getFieldWithAlias(startAfter, null)) != null) {
            startAfterJaxbField = startAfterModel.getFieldType();
        }
        boolean origFieldFound = false;
        List<Object> objects = this.jaxbSegment.getFieldOrMappingOrLchild();
        int i = 0;
        while (i < objects.size()) {
            Object currObj = objects.get(i);
            if (currObj instanceof FieldType) {
                if (currObj == origField.getFieldType() && startAfterJaxbField == null) {
                    objects.remove(i);
                    objects.add(i, newField.isSysRelField() ? newField.getSysRelFieldType() : newField.getFieldType());
                    origFieldFound = true;
                    break;
                }
                if (startAfterJaxbField != null && startAfterJaxbField == currObj) {
                    objects.add(i + 1, newField.isSysRelField() ? newField.getSysRelFieldType() : newField.getFieldType());
                    origFieldFound = true;
                    break;
                }
            } else if (currObj instanceof SysRelFieldType && currObj == origField.getSysRelFieldType()) {
                objects.remove(i);
                objects.add(i, newField.getSysRelFieldType());
                origFieldFound = true;
                break;
            }
            ++i;
        }
        if (!origFieldFound) {
            objects.add(newField.getFieldType());
        }
    }

    private void addSubField(FieldModel newField) {
        FieldModel parentField = newField.getParentField();
        List<Object> topLevelObjects = this.jaxbSegment.getFieldOrMappingOrLchild();
        int i = 0;
        while (i < topLevelObjects.size()) {
            if (topLevelObjects.get(i) instanceof FieldType) {
                FieldType currFieldType = (FieldType)topLevelObjects.get(i);
                if (parentField.getName().equals(currFieldType.getName())) {
                    List<FieldType> peerFields = currFieldType.getField();
                    String startAfterField = newField.getStartAfter();
                    if (startAfterField == null || startAfterField.isEmpty()) {
                        newField.setStartAfter("");
                        newField.setStartPos(0);
                        newField.setRelativeStart(0);
                        peerFields.add(newField.getFieldType());
                        break;
                    }
                    SegmentModel.addStartAfterFieldToPeerGroup(peerFields, newField);
                    SegmentModel.resetPeerGroupStartPositions(peerFields);
                    break;
                }
                boolean parentFound = SegmentModel.addSubField(currFieldType.getField(), newField);
                if (parentFound) break;
            }
            ++i;
        }
    }

    public static boolean addSubField(List<FieldType> subFields, FieldModel newField) {
        boolean parentFound = false;
        FieldModel parentField = newField.getParentField();
        int i = 0;
        while (i < subFields.size()) {
            FieldType currFieldType = subFields.get(i);
            if (parentField.getName().equals(currFieldType.getName())) {
                parentFound = true;
                List<FieldType> peerFields = currFieldType.getField();
                String startAfterField = newField.getStartAfter();
                if (startAfterField == null || startAfterField.isEmpty()) {
                    newField.setStartAfter("");
                    newField.setStartPos(0);
                    newField.setRelativeStart(0);
                    peerFields.add(newField.getFieldType());
                    break;
                }
                SegmentModel.addStartAfterFieldToPeerGroup(peerFields, newField);
                SegmentModel.resetPeerGroupStartPositions(peerFields);
                break;
            }
            parentFound = SegmentModel.addSubField(currFieldType.getField(), newField);
            if (parentFound) break;
            ++i;
        }
        return parentFound;
    }

    public static void addStartAfterFieldToPeerGroup(List<FieldType> peerFields, FieldModel newField) {
        String startAfterField = newField.getStartAfter();
        if (startAfterField.equals(DBDConstants.NONE.toString())) {
            newField.setStartAfter("");
            newField.setStartPos(0);
            newField.setRelativeStart(0);
            peerFields.add(0, newField.getFieldType());
        } else {
            int i = 0;
            while (i < peerFields.size()) {
                FieldType currFieldType = peerFields.get(i);
                if (startAfterField.equals(currFieldType.getName())) {
                    if (i + 1 == peerFields.size()) {
                        peerFields.add(i + 1, newField.getFieldType());
                    } else {
                        String redefinesFieldName = newField.getRedefines();
                        if (redefinesFieldName != null && !redefinesFieldName.isEmpty()) {
                            int j = i;
                            while (j < peerFields.size()) {
                                currFieldType = peerFields.get(j);
                                if (j + 1 == peerFields.size()) {
                                    peerFields.add(j + 1, newField.getFieldType());
                                    break;
                                }
                                if (redefinesFieldName.equals(currFieldType.getName())) {
                                    peerFields.add(j + 1, newField.getFieldType());
                                    break;
                                }
                                ++j;
                            }
                        } else {
                            FieldType peekedNextPeerField = peerFields.get(i + 1);
                            String nextFieldRedefinesField = peekedNextPeerField.getRedefines();
                            if (nextFieldRedefinesField == null || nextFieldRedefinesField.isEmpty()) {
                                peerFields.add(i + 1, newField.getFieldType());
                            } else {
                                int j = i + 1;
                                while (j < peerFields.size()) {
                                    if (peerFields.get(j) instanceof FieldType) {
                                        FieldType potentialRedefinesGroupFieldType = peerFields.get(j);
                                        String potentialRefinedName = potentialRedefinesGroupFieldType.getRedefines();
                                        if (potentialRefinedName == null || potentialRefinedName.isEmpty()) {
                                            peerFields.add(j, newField.getFieldType());
                                            break;
                                        }
                                        if (j == peerFields.size() - 1) {
                                            peerFields.add(j + 1, newField.getFieldType());
                                            break;
                                        }
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                    newField.setStartAfter("");
                    newField.setStartPos(0);
                    newField.setRelativeStart(0);
                    break;
                }
                ++i;
            }
        }
    }

    public static void resetPeerGroupStartPositions(List<FieldType> peerFields) {
        int i = 0;
        while (i < peerFields.size()) {
            FieldType currFieldType = peerFields.get(i);
            currFieldType.setStartPos(0);
            currFieldType.setStartAfter("");
            currFieldType.setRelativeStart(0);
            ++i;
        }
    }

    public static boolean objectAtIxIsLastFieldType(int index, List<Object> jaxbFields) {
        boolean retVal = true;
        if (index + 1 < jaxbFields.size()) {
            int i = index + 1;
            while (i < jaxbFields.size()) {
                Object currObj = jaxbFields.get(i);
                if (currObj instanceof FieldType) {
                    retVal = false;
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    private void addTopLevelField(FieldModel newField) {
        List<Object> peerFields = this.jaxbSegment.getFieldOrMappingOrLchild();
        String startAfterField = newField.getStartAfter();
        int startPosInt = newField.getStartPos();
        if (startAfterField == null || startAfterField.isEmpty()) {
            if (newField.getAppDatatype() != null && !newField.getAppDatatype().equals((Object)DBDConstants.XML) && startPosInt == 0) {
                newField.setStartPos(1);
            }
            newField.setStartAfter("");
            newField.setRelativeStart(0);
            peerFields.add(newField.getFieldType());
        } else {
            int i = 0;
            while (i < peerFields.size()) {
                FieldType currFieldType;
                if (peerFields.get(i) instanceof FieldType && startAfterField.equals((currFieldType = (FieldType)peerFields.get(i)).getName())) {
                    if (SegmentModel.objectAtIxIsLastFieldType(i, peerFields)) {
                        peerFields.add(i + 1, newField.getFieldType());
                    } else {
                        String redefinesFieldName = newField.getRedefines();
                        if (redefinesFieldName != null && !redefinesFieldName.isEmpty()) {
                            int j = i;
                            while (j < peerFields.size()) {
                                currFieldType = (FieldType)peerFields.get(j);
                                if (SegmentModel.objectAtIxIsLastFieldType(j, peerFields)) {
                                    peerFields.add(j + 1, newField.getFieldType());
                                    break;
                                }
                                if (redefinesFieldName.equals(currFieldType.getName())) {
                                    peerFields.add(j + 1, newField.getFieldType());
                                    break;
                                }
                                ++j;
                            }
                        } else if (peerFields.get(i + 1) instanceof FieldType) {
                            FieldType peekedNextPeerField = (FieldType)peerFields.get(i + 1);
                            String nextFieldRedefinesField = peekedNextPeerField.getRedefines();
                            if (nextFieldRedefinesField == null || nextFieldRedefinesField.isEmpty()) {
                                peerFields.add(i + 1, newField.getFieldType());
                            } else {
                                int j = i + 1;
                                while (j < peerFields.size()) {
                                    if (peerFields.get(j) instanceof FieldType) {
                                        FieldType potentialRedefinesGroupFieldType = (FieldType)peerFields.get(j);
                                        String potentialRefinedName = potentialRedefinesGroupFieldType.getRedefines();
                                        if (potentialRefinedName == null || potentialRefinedName.isEmpty()) {
                                            peerFields.add(j, newField.getFieldType());
                                            break;
                                        }
                                        if (SegmentModel.objectAtIxIsLastFieldType(j, peerFields)) {
                                            peerFields.add(j + 1, newField.getFieldType());
                                            break;
                                        }
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                    newField.setStartAfter("");
                    newField.setStartPos(0);
                    newField.setRelativeStart(0);
                    break;
                }
                ++i;
            }
        }
    }

    public static boolean addStartAfterFieldInList(List<FieldType> fieldList, String startAfterField, FieldModel newField) {
        int i = 0;
        while (i < fieldList.size()) {
            FieldType currFieldType = fieldList.get(i);
            if (startAfterField.equals(currFieldType.getName())) {
                fieldList.add(i + 1, newField.getFieldType());
                SegmentModel.resetStartPostions(fieldList);
                return true;
            }
            List<FieldType> childFields = currFieldType.getField();
            int j = 0;
            while (j < childFields.size()) {
                SegmentModel.addStartAfterFieldInList(childFields, startAfterField, newField);
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static void resetStartPostions(List<FieldType> fieldList) {
        int i = 0;
        while (i < fieldList.size()) {
            FieldType currFieldType = fieldList.get(i);
            currFieldType.setStartPos(0);
            currFieldType.setRelativeStart(0);
            currFieldType.setStartAfter(null);
            ++i;
        }
    }

    public static boolean addFieldUnderParent(FieldModel newField, List<FieldType> subFieldList) {
        boolean retVal = false;
        String parentName = newField.getParentField().getName();
        int i = 0;
        while (i < subFieldList.size()) {
            FieldType currField = subFieldList.get(i);
            if (currField.getName().equals(parentName)) {
                retVal = true;
                currField.getField().add(newField.getFieldType());
                break;
            }
            List<FieldType> nextSubFieldList = currField.getField();
            if (!nextSubFieldList.isEmpty() && SegmentModel.addFieldUnderParent(newField, nextSubFieldList)) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public void addLogicalChild(LogicalChildModel newChild) {
        this.lChildList.add(newChild);
        this.jaxbSegment.getFieldOrMappingOrLchild().add(newChild.logicalChild);
    }

    public void removeLogicalChild(LogicalChildModel lChild) {
        this.jaxbSegment.getFieldOrMappingOrLchild().remove(lChild.logicalChild);
        this.lChildList.remove(lChild);
    }

    public void removeField(FieldModel fieldModel) {
        this.removeField(fieldModel, null, null);
    }

    public void removeField(FieldModel fieldModel, String mappingName, String caseName) {
        if (fieldModel.isSysRelField()) {
            this.jaxbSegment.getFieldOrMappingOrLchild().remove(fieldModel.getSysRelFieldType());
            this.clearSysRelFieldList();
        } else if (caseName != null && !caseName.isEmpty()) {
            MappingModel mappingModel = this.getMapping(mappingName);
            MappingCaseModel caseModel = mappingModel.getMappingCaseModel(caseName);
            caseModel.removeField(fieldModel);
        } else {
            this.removeFieldType(fieldModel.getFieldType());
            this.clearFieldList();
        }
    }

    public void removeFieldType(FieldType fieldType) {
        ArrayList<FieldType> fieldList = new ArrayList<FieldType>();
        for (Object fieldObj : this.jaxbSegment.getFieldOrMappingOrLchild()) {
            if (!(fieldObj instanceof FieldType)) continue;
            FieldType currField = (FieldType)fieldObj;
            if (currField == fieldType) {
                this.jaxbSegment.getFieldOrMappingOrLchild().remove(fieldType);
                return;
            }
            fieldList.add(currField);
        }
        SegmentModel.removeFieldType(fieldList, fieldType);
    }

    public static boolean removeFieldType(List<FieldType> fieldList, FieldType fieldType) {
        boolean fieldFound = false;
        int i = 0;
        while (i < fieldList.size()) {
            FieldType currField = fieldList.get(i);
            if (currField == fieldType) {
                fieldList.remove(fieldType);
                fieldFound = true;
                break;
            }
            List<FieldType> subFields = currField.getField();
            if (subFields != null && subFields.size() > 0 && (fieldFound = SegmentModel.removeFieldType(subFields, fieldType))) break;
            ++i;
        }
        return fieldFound;
    }

    public static void preconditionTopLevelFieldStartInfo(Vector<FieldModel> fields) {
        FieldModel prevField = fields.get(0);
        int i = 1;
        while (i < fields.size()) {
            FieldModel currField = fields.get(i);
            int currStartPos = currField.getStartPos();
            if (currStartPos < 1) {
                currField.setStartAfter(prevField.getName());
                currField.setStartAfterSelected(true);
            }
            prevField = currField;
            ++i;
        }
    }

    public void removeAllFields() throws ModelException {
        this.getFieldList(false, true);
        if (this.commonFieldList != null) {
            for (FieldModel fieldModel : this.commonFieldList) {
                this.jaxbSegment.getFieldOrMappingOrLchild().remove(fieldModel.getFieldType());
            }
            this.commonFieldList.removeAllElements();
        }
        this.getSysRelFieldList();
        if (this.sysRelFieldList != null) {
            for (FieldModel fieldModel : this.sysRelFieldList) {
                this.jaxbSegment.getFieldOrMappingOrLchild().remove(fieldModel.getSysRelFieldType());
            }
            this.sysRelFieldList.removeAllElements();
        }
    }

    private void buildFieldList() throws ModelException {
        Vector<FieldType> fieldTypeList = this.getTopLevelFieldTypes();
        this.commonFieldList = SegmentModel.buildOrderedFieldList(fieldTypeList, null, this, null);
    }

    public Vector<FieldType> getTopLevelFieldTypes() {
        Iterator<Object> fieldIter = this.jaxbSegment.getFieldOrMappingOrLchild().iterator();
        Vector<FieldType> fieldTypeList = new Vector<FieldType>();
        while (fieldIter.hasNext()) {
            Object fieldObj = fieldIter.next();
            if (!(fieldObj instanceof FieldType)) continue;
            fieldTypeList.addElement((FieldType)fieldObj);
        }
        return fieldTypeList;
    }

    public static Vector<FieldModel> buildOrderedFieldList(List<FieldType> fieldList, FieldModel parentField, SegmentModel segmentModel, MappingCaseModel caseModel) throws ModelException {
        Vector<FieldModel> retVal = new Vector<FieldModel>();
        Vector<FieldModel> firstLevelSubFields = new Vector<FieldModel>();
        for (FieldType fieldType : fieldList) {
            FieldModelImpl field = new FieldModelImpl(fieldType);
            field.setSegmentModel(segmentModel);
            field.setMappingCaseModel(caseModel);
            field.setParentField(parentField);
            if (parentField != null) {
                fieldType.setParentField(parentField.getName());
            }
            SegmentModel.addFieldInOrder(retVal, field);
            SegmentModel.addFieldInOrder(firstLevelSubFields, field);
        }
        if (parentField != null) {
            parentField.setChildFields(firstLevelSubFields);
        }
        int i = 0;
        while (i < retVal.size()) {
            FieldModel currField = retVal.get(i);
            if (currField.hasSubFields()) {
                Vector<FieldModel> subFields = SegmentModel.buildOrderedFieldList(currField.getFieldType().getField(), currField, segmentModel, caseModel);
                int j = 0;
                while (j < subFields.size()) {
                    FieldModel subField = subFields.get(j);
                    retVal.insertElementAt(subField, ++i);
                    ++j;
                }
            }
            ++i;
        }
        return retVal;
    }

    private void buildSysRelFieldList() throws ModelException {
        Iterator<Object> fieldIter = this.jaxbSegment.getFieldOrMappingOrLchild().iterator();
        if (fieldIter.hasNext()) {
            this.sysRelFieldList = new Vector();
            while (fieldIter.hasNext()) {
                Object currObj = fieldIter.next();
                if (!(currObj instanceof SysRelFieldType)) continue;
                SysRelFieldModel field = new SysRelFieldModel((SysRelFieldType)currObj);
                this.sysRelFieldList.add(field);
            }
        }
    }

    private void buildExitList() {
        this.dataCaptureExitRoutines = new ArrayList();
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        ExitContainerType jaxbExitContainer = null;
        if (dbdAccessType == DBDConstants.HDAM) {
            jaxbExitContainer = this.jaxbSegment.getHdam().getExitContainer();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            jaxbExitContainer = this.jaxbSegment.getPhdam().getExitContainer();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            jaxbExitContainer = this.jaxbSegment.getHidam().getExitContainer();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            jaxbExitContainer = this.jaxbSegment.getPhidam().getExitContainer();
        } else if (dbdAccessType == DBDConstants.HISAM) {
            jaxbExitContainer = this.jaxbSegment.getHisam().getExitContainer();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            jaxbExitContainer = this.jaxbSegment.getShisam().getExitContainer();
        } else if (dbdAccessType == DBDConstants.DEDB) {
            jaxbExitContainer = this.jaxbSegment.getDedb().getExitContainer();
        }
        if (jaxbExitContainer != null) {
            Iterator<DataCaptureExitRoutineType> jaxbExitRoutineIter = jaxbExitContainer.getDataCaptureExitRoutine().iterator();
            while (jaxbExitRoutineIter.hasNext()) {
                this.dataCaptureExitRoutines.add(new DataExitRoutine(jaxbExitRoutineIter.next()));
            }
        }
    }

    public String getDatasetLabel() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        if (dbdAccessType == DBDConstants.HDAM) {
            return this.jaxbSegment.getHdam().getLabel();
        }
        if (dbdAccessType == DBDConstants.HIDAM) {
            return this.jaxbSegment.getHidam().getLabel();
        }
        return null;
    }

    public void setDatasetLabel(String datasetLabel) throws ModelException {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        if (dbdAccessType == DBDConstants.HDAM) {
            this.jaxbSegment.getHdam().setLabel(datasetLabel);
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            this.jaxbSegment.getHidam().setLabel(datasetLabel);
        }
    }

    public void setSegmentType(DBDConstants value) throws ModelException {
        if (value == DBDConstants.HSAM) {
            HsamAndShsamSegType hsam = new HsamAndShsamSegType();
            this.jaxbSegment.setHsam(hsam);
        } else if (value == DBDConstants.SHSAM) {
            HsamAndShsamSegType shsam = new HsamAndShsamSegType();
            this.jaxbSegment.setShsam(shsam);
        } else if (value == DBDConstants.SHSAM) {
            HsamAndShsamSegType shsam = new HsamAndShsamSegType();
            this.jaxbSegment.setShsam(shsam);
        } else if (value == DBDConstants.HISAM) {
            HisamAndShisamSegType hisam = new HisamAndShisamSegType();
            RulesType rules = new RulesType();
            ComprtnType comp = new ComprtnType();
            this.jaxbSegment.setHisam(hisam);
            this.jaxbSegment.getHisam().setRules(rules);
            this.jaxbSegment.getHisam().setComprtn(comp);
        } else if (value == DBDConstants.SHISAM) {
            HisamAndShisamSegType shisam = new HisamAndShisamSegType();
            this.jaxbSegment.setShisam(shisam);
            RulesType rules = new RulesType();
            ComprtnType comp = new ComprtnType();
            this.jaxbSegment.getShisam().setRules(rules);
            this.jaxbSegment.getShisam().setComprtn(comp);
        } else if (value == DBDConstants.HDAM) {
            HdamAndHidamSegType hdam = new HdamAndHidamSegType();
            this.jaxbSegment.setHdam(hdam);
        } else if (value == DBDConstants.PHDAM) {
            PhdamAndPhidamSegType phdam = new PhdamAndPhidamSegType();
            this.jaxbSegment.setPhdam(phdam);
        } else if (value == DBDConstants.HIDAM) {
            HdamAndHidamSegType hidam = new HdamAndHidamSegType();
            this.jaxbSegment.setHidam(hidam);
        } else if (value == DBDConstants.PHIDAM) {
            PhdamAndPhidamSegType phidam = new PhdamAndPhidamSegType();
            this.jaxbSegment.setPhidam(phidam);
        } else if (value == DBDConstants.MSDB) {
            MsdbSegType msdb = new MsdbSegType();
            this.jaxbSegment.setMsdb(msdb);
        } else if (value == DBDConstants.DEDB) {
            DedbSegType dedb = new DedbSegType();
            DedbComprtnType comp = new DedbComprtnType();
            this.jaxbSegment.setDedb(dedb);
            this.jaxbSegment.getDedb().setComprtn(comp);
        } else if (value == DBDConstants.INDEX) {
            IndexSegType index = new IndexSegType();
            this.jaxbSegment.setIndex(index);
        } else if (value == DBDConstants.PSINDEX) {
            PsindexSegType psindex = new PsindexSegType();
            this.jaxbSegment.setPsindex(psindex);
        } else if (value == DBDConstants.LOGICAL) {
            LogicalSegType logical = new LogicalSegType();
            this.jaxbSegment.setLogical(logical);
        } else if (value != DBDConstants.GSAM) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1609"));
        }
    }

    public String getDedbDependentSegmentType() {
        DedbDependentSegmentType type = this.jaxbSegment.getDedb().getType();
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    public void setDedbDependentSegmentType(DBDConstants value) {
        this.jaxbSegment.getDedb().setType(DedbDependentSegmentType.valueOf(value.toString()));
    }

    public void setSsptr(int ssptr) {
        this.jaxbSegment.getDedb().setSsptr(ssptr);
    }

    public int getSsptr() {
        if (this.jaxbSegment.getDedb() != null && this.jaxbSegment.getDedb().getSsptr() != null) {
            return this.jaxbSegment.getDedb().getSsptr();
        }
        return -1;
    }

    public BigDecimal getFreq() {
        if (this.dbdModel.getAccessType() == DBDConstants.HSAM) {
            return this.jaxbSegment.getHsam().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.HISAM) {
            return this.jaxbSegment.getHisam().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.SHSAM) {
            return this.jaxbSegment.getShsam().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.SHISAM) {
            return this.jaxbSegment.getShisam().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.INDEX) {
            if (this.jaxbSegment.getIndex() != null) {
                return this.jaxbSegment.getIndex().getFreq();
            }
            return this.jaxbSegment.getShisam().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.PSINDEX) {
            return this.jaxbSegment.getPsindex().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.LOGICAL) {
            return this.jaxbSegment.getLogical().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            return this.jaxbSegment.getHdam().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            return this.jaxbSegment.getHidam().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.PHDAM) {
            return this.jaxbSegment.getPhdam().getFreq();
        }
        if (this.dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            return this.jaxbSegment.getPhidam().getFreq();
        }
        return null;
    }

    public void setFreq(BigDecimal value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HISAM) {
            this.jaxbSegment.getHisam().setFreq(value);
        } else if (this.dbdModel.getAccessType() == DBDConstants.HSAM) {
            this.jaxbSegment.getHsam().setFreq(value);
        } else if (this.dbdModel.getAccessType() == DBDConstants.SHSAM) {
            this.jaxbSegment.getShsam().setFreq(value);
        } else if (this.dbdModel.getAccessType() == DBDConstants.SHISAM) {
            this.jaxbSegment.getShisam().setFreq(value);
        } else if (this.dbdModel.getAccessType() == DBDConstants.INDEX) {
            if (this.jaxbSegment.getIndex() != null) {
                this.jaxbSegment.getIndex().setFreq(value);
            } else {
                this.jaxbSegment.getShisam().setFreq(value);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PSINDEX) {
            this.jaxbSegment.getPsindex().setFreq(value);
        } else if (this.dbdModel.getAccessType() == DBDConstants.LOGICAL) {
            this.jaxbSegment.getLogical().setFreq(value);
        } else if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            this.jaxbSegment.getHdam().setFreq(value);
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            this.jaxbSegment.getHidam().setFreq(value);
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHDAM) {
            this.jaxbSegment.getPhdam().setFreq(value);
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            this.jaxbSegment.getPhidam().setFreq(value);
        }
    }

    public void setLparnt(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HISAM) {
            if (value == DBDConstants.Y) {
                this.jaxbSegment.getHisam().getPointer().setLparnt(YesnoType.valueOf(value.toString()));
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.SHISAM) {
            if (value == DBDConstants.Y) {
                this.jaxbSegment.getShisam().getPointer().setLparnt(YesnoType.valueOf(value.toString()));
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            this.jaxbSegment.getHdam().getPointer().setLparnt(YesnoType.valueOf(value.toString()));
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHDAM) {
            this.jaxbSegment.getPhdam().getPointer().setLparnt(YesnoType.valueOf(value.toString()));
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            this.jaxbSegment.getHidam().getPointer().setLparnt(YesnoType.valueOf(value.toString()));
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            this.jaxbSegment.getPhidam().getPointer().setLparnt(YesnoType.valueOf(value.toString()));
        }
    }

    public void setCtr(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HISAM) {
            if (value == DBDConstants.Y) {
                this.jaxbSegment.getHisam().getPointer().setCtr(YesnoType.valueOf(value.toString()));
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.SHISAM) {
            if (value == DBDConstants.Y) {
                this.jaxbSegment.getShisam().getPointer().setCtr(YesnoType.valueOf(value.toString()));
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            this.jaxbSegment.getHdam().getPointer().setCtr(YesnoType.valueOf(value.toString()));
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            this.jaxbSegment.getHidam().getPointer().setCtr(YesnoType.valueOf(value.toString()));
        }
    }

    public DBDConstants getCtr() {
        HdamAndHidamPointerType ptr;
        DBDConstants retVal = DBDConstants.N;
        YesnoType ctr = null;
        if (this.dbdModel.getAccessType() == DBDConstants.HISAM) {
            HisamAndShisamPointerType ptr2 = this.jaxbSegment.getHisam().getPointer();
            if (ptr2 != null) {
                ctr = ptr2.getCtr();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.SHISAM) {
            HisamAndShisamPointerType ptr3 = this.jaxbSegment.getShisam().getPointer();
            if (ptr3 != null) {
                ctr = ptr3.getCtr();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr4 = this.jaxbSegment.getHdam().getPointer();
            if (ptr4 != null) {
                ctr = ptr4.getCtr();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM && (ptr = this.jaxbSegment.getHidam().getPointer()) != null) {
            ctr = ptr.getCtr();
        }
        if (ctr != null) {
            retVal = DBDConstants.fromValue(ctr.toString());
        }
        return retVal;
    }

    public void setPaired(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HISAM) {
            this.jaxbSegment.getHisam().getPointer().setPaired(YesnoType.valueOf(value.toString()));
        } else if (this.dbdModel.getAccessType() == DBDConstants.SHISAM) {
            this.jaxbSegment.getShisam().getPointer().setPaired(YesnoType.valueOf(value.toString()));
        } else if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            this.jaxbSegment.getHdam().getPointer().setPaired(YesnoType.valueOf(value.toString()));
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHDAM) {
            this.jaxbSegment.getPhdam().getPointer().setPaired(YesnoType.valueOf(value.toString()));
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            this.jaxbSegment.getHidam().getPointer().setPaired(YesnoType.valueOf(value.toString()));
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            this.jaxbSegment.getPhidam().getPointer().setPaired(YesnoType.valueOf(value.toString()));
        }
    }

    public DBDConstants getPaired() {
        PhdamAndPhidamPointerType ptr;
        DBDConstants retVal = DBDConstants.N;
        YesnoType paired = null;
        if (this.dbdModel.getAccessType() == DBDConstants.HISAM) {
            HisamAndShisamPointerType ptr2 = this.jaxbSegment.getHisam().getPointer();
            if (ptr2 != null) {
                paired = ptr2.getPaired();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.SHISAM) {
            HisamAndShisamPointerType ptr3 = this.jaxbSegment.getShisam().getPointer();
            if (ptr3 != null) {
                paired = ptr3.getPaired();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr4 = this.jaxbSegment.getHdam().getPointer();
            if (ptr4 != null) {
                paired = ptr4.getPaired();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHDAM) {
            PhdamAndPhidamPointerType ptr5 = this.jaxbSegment.getPhdam().getPointer();
            if (ptr5 != null) {
                paired = ptr5.getPaired();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr6 = this.jaxbSegment.getHidam().getPointer();
            if (ptr6 != null) {
                paired = ptr6.getPaired();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHIDAM && (ptr = this.jaxbSegment.getPhidam().getPointer()) != null) {
            paired = ptr.getPaired();
        }
        if (paired != null) {
            retVal = DBDConstants.fromValue(paired.toString());
        }
        return retVal;
    }

    public DBDConstants getLparnt() {
        PhdamAndPhidamPointerType ptr;
        DBDConstants retVal = DBDConstants.N;
        YesnoType lparnt = null;
        if (this.dbdModel.getAccessType() == DBDConstants.HISAM) {
            HisamAndShisamPointerType ptr2 = this.jaxbSegment.getHisam().getPointer();
            if (ptr2 != null) {
                lparnt = ptr2.getLparnt();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.SHISAM) {
            HisamAndShisamPointerType ptr3 = this.jaxbSegment.getShisam().getPointer();
            if (ptr3 != null) {
                lparnt = ptr3.getLparnt();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr4 = this.jaxbSegment.getHdam().getPointer();
            if (ptr4 != null) {
                lparnt = ptr4.getLparnt();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHDAM) {
            PhdamAndPhidamPointerType ptr5 = this.jaxbSegment.getPhdam().getPointer();
            if (ptr5 != null) {
                lparnt = ptr5.getLparnt();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr6 = this.jaxbSegment.getHidam().getPointer();
            if (ptr6 != null) {
                lparnt = ptr6.getLparnt();
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHIDAM && (ptr = this.jaxbSegment.getPhidam().getPointer()) != null) {
            lparnt = ptr.getLparnt();
        }
        if (lparnt != null) {
            retVal = DBDConstants.fromValue(lparnt.toString());
        }
        return retVal;
    }

    public void setTwin(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHdam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.TWIN);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHDAM) {
            PhdamAndPhidamPointerType ptr = this.jaxbSegment.getPhdam().getPointer();
            if (ptr == null) {
                ptr = new PhdamAndPhidamPointerType();
                this.jaxbSegment.getPhdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.TWIN);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHidam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.TWIN);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            PhdamAndPhidamPointerType ptr = this.jaxbSegment.getPhidam().getPointer();
            if (ptr == null) {
                ptr = new PhdamAndPhidamPointerType();
                this.jaxbSegment.getPhidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.TWIN);
            }
        }
    }

    public void setNotwin(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHdam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.NOTWIN);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHDAM) {
            PhdamAndPhidamPointerType ptr = this.jaxbSegment.getPhdam().getPointer();
            if (ptr == null) {
                ptr = new PhdamAndPhidamPointerType();
                this.jaxbSegment.getPhdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.NOTWIN);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHidam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.NOTWIN);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            PhdamAndPhidamPointerType ptr = this.jaxbSegment.getPhidam().getPointer();
            if (ptr == null) {
                ptr = new PhdamAndPhidamPointerType();
                this.jaxbSegment.getPhidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.NOTWIN);
            }
        }
    }

    public void setLtwin(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHdam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setLogicalPointer(LogicalPointerType.LTWIN);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHidam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setLogicalPointer(LogicalPointerType.LTWIN);
            }
        }
    }

    public void setLtwinbwd(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHdam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setLogicalPointer(LogicalPointerType.LTWINBWD);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHidam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setLogicalPointer(LogicalPointerType.LTWINBWD);
            }
        }
    }

    public void setTwinbwd(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHdam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.TWINBWD);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHDAM) {
            PhdamAndPhidamPointerType ptr = this.jaxbSegment.getPhdam().getPointer();
            if (ptr == null) {
                ptr = new PhdamAndPhidamPointerType();
                this.jaxbSegment.getPhdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.TWINBWD);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHidam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.TWINBWD);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.PHIDAM) {
            PhdamAndPhidamPointerType ptr = this.jaxbSegment.getPhidam().getPointer();
            if (ptr == null) {
                ptr = new PhdamAndPhidamPointerType();
                this.jaxbSegment.getPhidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.TWINBWD);
            }
        }
    }

    public void setHier(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHdam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.HIER);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHidam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.HIER);
            }
        }
    }

    public void setHierbwd(DBDConstants value) {
        if (this.dbdModel.getAccessType() == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHdam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHdam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.HIERBWD);
            }
        } else if (this.dbdModel.getAccessType() == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr = this.jaxbSegment.getHidam().getPointer();
            if (ptr == null) {
                ptr = new HdamAndHidamPointerType();
                this.jaxbSegment.getHidam().setPointer(ptr);
            }
            if (value == DBDConstants.Y) {
                ptr.setPhysicalPointer(PhysicalPointerType.HIERBWD);
            }
        }
    }

    public String getPhysicalChildPointer() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        PhysicalChildPointerType pcp = null;
        if (dbdAccessType == DBDConstants.HDAM) {
            pcp = this.jaxbSegment.getHdam().getPhysicalChildPointer();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            pcp = this.jaxbSegment.getPhdam().getPhysicalChildPointer();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            pcp = this.jaxbSegment.getHidam().getPhysicalChildPointer();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            pcp = this.jaxbSegment.getPhidam().getPhysicalChildPointer();
        } else if (dbdAccessType == DBDConstants.DEDB) {
            pcp = this.jaxbSegment.getDedb().getPhysicalChildPointer();
        }
        if (pcp == PhysicalChildPointerType.SNGL) {
            return "SNGL";
        }
        if (pcp == PhysicalChildPointerType.DBLE) {
            return "DBLE";
        }
        return null;
    }

    public DBDConstants getPhysicalPointer() {
        PhdamAndPhidamPointerType ptr;
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        DBDConstants retVal = null;
        if (dbdAccessType == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr2 = this.jaxbSegment.getHdam().getPointer();
            if (ptr2 != null && ptr2.getPhysicalPointer() != null) {
                retVal = DBDConstants.fromValue(ptr2.getPhysicalPointer().toString());
            }
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            PhdamAndPhidamPointerType ptr3 = this.jaxbSegment.getPhdam().getPointer();
            if (ptr3 != null && ptr3.getPhysicalPointer() != null) {
                retVal = DBDConstants.fromValue(ptr3.getPhysicalPointer().toString());
            }
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            HdamAndHidamPointerType ptr4 = this.jaxbSegment.getHidam().getPointer();
            if (ptr4 != null && ptr4.getPhysicalPointer() != null) {
                retVal = DBDConstants.fromValue(ptr4.getPhysicalPointer().toString());
            }
        } else if (dbdAccessType == DBDConstants.PHIDAM && (ptr = this.jaxbSegment.getPhidam().getPointer()) != null && ptr.getPhysicalPointer() != null) {
            retVal = DBDConstants.fromValue(ptr.getPhysicalPointer().toString());
        }
        return retVal;
    }

    public DBDConstants getLogicalPointer() {
        HdamAndHidamPointerType ptr;
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        DBDConstants retVal = null;
        Enum logicalPointer = null;
        if (dbdAccessType == DBDConstants.HDAM) {
            HdamAndHidamPointerType ptr2 = this.jaxbSegment.getHdam().getPointer();
            if (ptr2 != null) {
                logicalPointer = ptr2.getLogicalPointer();
            }
        } else if (dbdAccessType == DBDConstants.HIDAM && (ptr = this.jaxbSegment.getHidam().getPointer()) != null) {
            logicalPointer = ptr.getLogicalPointer();
        }
        if (logicalPointer != null) {
            retVal = DBDConstants.fromValue(logicalPointer.toString());
        }
        return retVal;
    }

    public void setPhysicalChildPointer(String physicalChildPointer) {
        DBDConstants dbdAccessType;
        if (!physicalChildPointer.equals("SNGL")) {
            physicalChildPointer.equals("DBLE");
        }
        if ((dbdAccessType = this.dbdModel.getAccessType()) == DBDConstants.HDAM) {
            if (physicalChildPointer.equals("SNGL")) {
                this.jaxbSegment.getHdam().setPhysicalChildPointer(PhysicalChildPointerType.SNGL);
            } else if (physicalChildPointer.equals("DBLE")) {
                this.jaxbSegment.getHdam().setPhysicalChildPointer(PhysicalChildPointerType.DBLE);
            }
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            if (physicalChildPointer.equals("SNGL")) {
                this.jaxbSegment.getPhdam().setPhysicalChildPointer(PhysicalChildPointerType.SNGL);
            } else if (physicalChildPointer.equals("DBLE")) {
                this.jaxbSegment.getPhdam().setPhysicalChildPointer(PhysicalChildPointerType.DBLE);
            }
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            if (physicalChildPointer.equals("SNGL")) {
                this.jaxbSegment.getHidam().setPhysicalChildPointer(PhysicalChildPointerType.SNGL);
            } else if (physicalChildPointer.equals("DBLE")) {
                this.jaxbSegment.getHidam().setPhysicalChildPointer(PhysicalChildPointerType.DBLE);
            }
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            if (physicalChildPointer.equals("SNGL")) {
                this.jaxbSegment.getPhidam().setPhysicalChildPointer(PhysicalChildPointerType.SNGL);
            } else if (physicalChildPointer.equals("DBLE")) {
                this.jaxbSegment.getPhidam().setPhysicalChildPointer(PhysicalChildPointerType.DBLE);
            }
        } else if (dbdAccessType == DBDConstants.DEDB) {
            if (physicalChildPointer.equals("SNGL")) {
                this.jaxbSegment.getDedb().setPhysicalChildPointer(PhysicalChildPointerType.SNGL);
            } else if (physicalChildPointer.equals("DBLE")) {
                this.jaxbSegment.getDedb().setPhysicalChildPointer(PhysicalChildPointerType.DBLE);
            }
        }
    }

    public String getDsgroup() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        DsgroupType dsgroup = null;
        if (dbdAccessType == DBDConstants.PHDAM) {
            dsgroup = this.jaxbSegment.getPhdam().getDsgroup();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            dsgroup = this.jaxbSegment.getPhidam().getDsgroup();
        }
        if (dsgroup == null) {
            return null;
        }
        return dsgroup.toString();
    }

    public void setDsgroup(String dsgroup) {
        block3: {
            DBDConstants dbdAccessType;
            block21: {
                block0: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block1: {
                                                            block11: {
                                                                block10: {
                                                                    block9: {
                                                                        block8: {
                                                                            block7: {
                                                                                block6: {
                                                                                    block5: {
                                                                                        block4: {
                                                                                            block2: {
                                                                                                dbdAccessType = this.dbdModel.getAccessType();
                                                                                                if (dsgroup == null) break block0;
                                                                                                if (dbdAccessType != DBDConstants.PHDAM) break block1;
                                                                                                if (!dsgroup.equals("A")) break block2;
                                                                                                this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.A);
                                                                                                break block3;
                                                                                            }
                                                                                            if (!dsgroup.equals("B")) break block4;
                                                                                            this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.B);
                                                                                            break block3;
                                                                                        }
                                                                                        if (!dsgroup.equals("C")) break block5;
                                                                                        this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.C);
                                                                                        break block3;
                                                                                    }
                                                                                    if (!dsgroup.equals("D")) break block6;
                                                                                    this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.D);
                                                                                    break block3;
                                                                                }
                                                                                if (!dsgroup.equals("E")) break block7;
                                                                                this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.E);
                                                                                break block3;
                                                                            }
                                                                            if (!dsgroup.equals("F")) break block8;
                                                                            this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.F);
                                                                            break block3;
                                                                        }
                                                                        if (!dsgroup.equals("G")) break block9;
                                                                        this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.G);
                                                                        break block3;
                                                                    }
                                                                    if (!dsgroup.equals("H")) break block10;
                                                                    this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.H);
                                                                    break block3;
                                                                }
                                                                if (!dsgroup.equals("I")) break block11;
                                                                this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.I);
                                                                break block3;
                                                            }
                                                            if (!dsgroup.equals("J")) break block3;
                                                            this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.J);
                                                            break block3;
                                                        }
                                                        if (dbdAccessType != DBDConstants.PHIDAM) break block3;
                                                        if (!dsgroup.equals("A")) break block12;
                                                        this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.A);
                                                        break block3;
                                                    }
                                                    if (!dsgroup.equals("B")) break block13;
                                                    this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.B);
                                                    break block3;
                                                }
                                                if (!dsgroup.equals("C")) break block14;
                                                this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.C);
                                                break block3;
                                            }
                                            if (!dsgroup.equals("D")) break block15;
                                            this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.D);
                                            break block3;
                                        }
                                        if (!dsgroup.equals("E")) break block16;
                                        this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.E);
                                        break block3;
                                    }
                                    if (!dsgroup.equals("F")) break block17;
                                    this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.F);
                                    break block3;
                                }
                                if (!dsgroup.equals("G")) break block18;
                                this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.G);
                                break block3;
                            }
                            if (!dsgroup.equals("H")) break block19;
                            this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.H);
                            break block3;
                        }
                        if (!dsgroup.equals("I")) break block20;
                        this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.I);
                        break block3;
                    }
                    if (!dsgroup.equals("J")) break block3;
                    this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.J);
                    break block3;
                }
                if (dbdAccessType != DBDConstants.PHDAM) break block21;
                this.jaxbSegment.getPhdam().setDsgroup(DsgroupType.A);
                break block3;
            }
            if (dbdAccessType != DBDConstants.PHIDAM) break block3;
            this.jaxbSegment.getPhidam().setDsgroup(DsgroupType.A);
        }
    }

    public void setPointer(String[] ptrKeywords) {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        boolean hierSet = false;
        boolean hierbwdSet = false;
        boolean twinSet = false;
        boolean twinbwdSet = false;
        boolean notwinSet = false;
        boolean ltwinSet = false;
        boolean ltwinbwdSet = false;
        boolean lparntSet = false;
        boolean ctrSet = false;
        boolean pairedSet = false;
        int i = 0;
        while (i < 5) {
            if (ptrKeywords[i] != null) {
                if (ptrKeywords[i].equals("HIER") || ptrKeywords[i].equals("H")) {
                    if (!hierSet) {
                        hierSet = true;
                    }
                } else if (ptrKeywords[i].equals("HIERBWD") || ptrKeywords[i].equals("HB")) {
                    if (!hierbwdSet) {
                        hierbwdSet = true;
                    }
                } else if (ptrKeywords[i].equals("TWIN") || ptrKeywords[i].equals("T")) {
                    if (!twinSet) {
                        twinSet = true;
                    }
                } else if (ptrKeywords[i].equals("TWINBWD") || ptrKeywords[i].equals("TB")) {
                    if (!twinbwdSet) {
                        twinbwdSet = true;
                    }
                } else if (ptrKeywords[i].equals("NOTWIN") || ptrKeywords[i].equals("NT")) {
                    if (!notwinSet) {
                        notwinSet = true;
                    }
                } else if (ptrKeywords[i].equals("LTWIN") || ptrKeywords[i].equals("LT")) {
                    if (!ltwinSet) {
                        ltwinSet = true;
                    }
                } else if (ptrKeywords[i].equals("LTWINBWD") || ptrKeywords[i].equals("LTB")) {
                    if (!ltwinbwdSet) {
                        ltwinbwdSet = true;
                    }
                } else if (ptrKeywords[i].equals("PAIRED")) {
                    if (!pairedSet) {
                        pairedSet = true;
                    }
                } else if (ptrKeywords[i].equals("LPARNT") || ptrKeywords[i].equals("LP")) {
                    if (!lparntSet) {
                        lparntSet = true;
                    }
                } else if ((ptrKeywords[i].equals("CTR") || ptrKeywords[i].equals("C")) && !ctrSet) {
                    ctrSet = true;
                }
            }
            ++i;
        }
        if (dbdAccessType == DBDConstants.HDAM || dbdAccessType == DBDConstants.HIDAM) {
            HdamAndHidamPointerType pointerType = new HdamAndHidamPointerType();
            if (hierSet) {
                if (hierbwdSet || twinSet || !twinbwdSet) {
                    // empty if block
                }
                pointerType.setPhysicalPointer(PhysicalPointerType.HIER);
            }
            if (hierbwdSet) {
                if (hierSet || twinSet || !twinbwdSet) {
                    // empty if block
                }
                pointerType.setPhysicalPointer(PhysicalPointerType.HIERBWD);
            }
            if (twinSet) {
                if (hierSet || hierbwdSet || !twinbwdSet) {
                    // empty if block
                }
                pointerType.setPhysicalPointer(PhysicalPointerType.TWIN);
            }
            if (twinbwdSet) {
                if (hierSet || hierbwdSet || !twinSet) {
                    // empty if block
                }
                pointerType.setPhysicalPointer(PhysicalPointerType.TWINBWD);
            }
            if (notwinSet) {
                if (hierSet || hierbwdSet || !twinSet) {
                    // empty if block
                }
                pointerType.setPhysicalPointer(PhysicalPointerType.NOTWIN);
            }
            if (ltwinSet) {
                pointerType.setLogicalPointer(LogicalPointerType.LTWIN);
            }
            if (ltwinbwdSet) {
                pointerType.setLogicalPointer(LogicalPointerType.LTWINBWD);
            }
            if (lparntSet) {
                pointerType.setLparnt(YesnoType.Y);
            }
            if (ctrSet) {
                pointerType.setCtr(YesnoType.Y);
            }
            if (pairedSet) {
                pointerType.setPaired(YesnoType.Y);
            }
            if (dbdAccessType == DBDConstants.HDAM) {
                this.jaxbSegment.getHdam().setPointer(pointerType);
            } else {
                this.jaxbSegment.getHidam().setPointer(pointerType);
            }
        } else if (dbdAccessType == DBDConstants.PHDAM || dbdAccessType == DBDConstants.PHIDAM) {
            PhdamAndPhidamPointerType pointerType = new PhdamAndPhidamPointerType();
            if (twinSet) {
                if (!twinbwdSet) {
                    // empty if block
                }
                pointerType.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.TWIN);
            }
            if (twinbwdSet) {
                if (!twinSet) {
                    // empty if block
                }
                pointerType.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.TWINBWD);
            }
            if (notwinSet) {
                if (!twinSet) {
                    // empty if block
                }
                pointerType.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.NOTWIN);
            }
            if (hierbwdSet) {
                pointerType.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.TWINBWD);
            } else if (hierSet) {
                pointerType.setPhysicalPointer(PhdamAndPhidamPhysicalPointerType.TWINBWD);
            }
            if (lparntSet) {
                pointerType.setLparnt(YesnoType.Y);
            }
            if (pairedSet) {
                pointerType.setPaired(YesnoType.Y);
            }
            if (dbdAccessType == DBDConstants.PHDAM) {
                this.jaxbSegment.getPhdam().setPointer(pointerType);
            } else {
                this.jaxbSegment.getPhidam().setPointer(pointerType);
            }
        } else if (dbdAccessType == DBDConstants.HISAM || dbdAccessType == DBDConstants.SHISAM) {
            HisamAndShisamPointerType pointerType = new HisamAndShisamPointerType();
            if (lparntSet) {
                pointerType.setLparnt(YesnoType.Y);
            }
            if (ctrSet) {
                pointerType.setCtr(YesnoType.Y);
            }
            if (pairedSet) {
                pointerType.setPaired(YesnoType.Y);
            }
            if (dbdAccessType == DBDConstants.HISAM) {
                this.jaxbSegment.getHisam().setPointer(pointerType);
            } else {
                this.jaxbSegment.getShisam().setPointer(pointerType);
            }
        }
    }

    public String[] getPhdamPhidamPointer() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        String[] retvals = new String[3];
        PhdamAndPhidamPointerType pointer = null;
        if (dbdAccessType == DBDConstants.PHDAM) {
            pointer = this.jaxbSegment.getPhdam().getPointer();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            pointer = this.jaxbSegment.getPhidam().getPointer();
        }
        if (pointer != null) {
            YesnoType paired;
            YesnoType lparnt;
            PhdamAndPhidamPhysicalPointerType physicalPointer = pointer.getPhysicalPointer();
            if (physicalPointer != null) {
                retvals[0] = physicalPointer.toString();
            }
            if ((lparnt = pointer.getLparnt()) != null) {
                retvals[1] = lparnt.toString();
            }
            if ((paired = pointer.getPaired()) != null) {
                retvals[2] = paired.toString();
            }
            return retvals;
        }
        return null;
    }

    public void setInsertionRule(char insertionRule) {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        InsertionAndReplacementRuleType rule = InsertionAndReplacementRuleType.L;
        if (insertionRule == 'P') {
            rule = InsertionAndReplacementRuleType.P;
        } else if (insertionRule == 'V') {
            rule = InsertionAndReplacementRuleType.V;
        }
        if (dbdAccessType == DBDConstants.HISAM) {
            if (this.jaxbSegment.getHisam().getRules() == null) {
                this.jaxbSegment.getHisam().setRules(new RulesType());
            }
            this.jaxbSegment.getHisam().getRules().setInsertionRule(rule);
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            if (this.jaxbSegment.getShisam().getRules() == null) {
                this.jaxbSegment.getShisam().setRules(new RulesType());
            }
            this.jaxbSegment.getShisam().getRules().setInsertionRule(rule);
        } else if (dbdAccessType == DBDConstants.HDAM) {
            if (this.jaxbSegment.getHdam().getRules() == null) {
                this.jaxbSegment.getHdam().setRules(new RulesType());
            }
            this.jaxbSegment.getHdam().getRules().setInsertionRule(rule);
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            if (this.jaxbSegment.getHidam().getRules() == null) {
                this.jaxbSegment.getHidam().setRules(new RulesType());
            }
            this.jaxbSegment.getHidam().getRules().setInsertionRule(rule);
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            if (this.jaxbSegment.getPhdam().getRules() == null) {
                this.jaxbSegment.getPhdam().setRules(new RulesType());
            }
            this.jaxbSegment.getPhdam().getRules().setInsertionRule(rule);
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            if (this.jaxbSegment.getPhidam().getRules() == null) {
                this.jaxbSegment.getPhidam().setRules(new RulesType());
            }
            this.jaxbSegment.getPhidam().getRules().setInsertionRule(rule);
        }
    }

    public void setDeletionRule(char deletionRule) {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        DeletionRuleType rule = DeletionRuleType.L;
        if (deletionRule == 'P') {
            rule = DeletionRuleType.P;
        } else if (deletionRule == 'V') {
            rule = DeletionRuleType.V;
        } else if (deletionRule == 'B') {
            rule = DeletionRuleType.B;
        }
        if (dbdAccessType == DBDConstants.HISAM) {
            if (this.jaxbSegment.getHisam().getRules() == null) {
                this.jaxbSegment.getHisam().setRules(new RulesType());
            }
            this.jaxbSegment.getHisam().getRules().setDeletionRule(rule);
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            if (this.jaxbSegment.getShisam().getRules() == null) {
                this.jaxbSegment.getShisam().setRules(new RulesType());
            }
            this.jaxbSegment.getShisam().getRules().setDeletionRule(rule);
        } else if (dbdAccessType == DBDConstants.HDAM) {
            if (this.jaxbSegment.getHdam().getRules() == null) {
                this.jaxbSegment.getHdam().setRules(new RulesType());
            }
            this.jaxbSegment.getHdam().getRules().setDeletionRule(rule);
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            if (this.jaxbSegment.getHidam().getRules() == null) {
                this.jaxbSegment.getHidam().setRules(new RulesType());
            }
            this.jaxbSegment.getHidam().getRules().setDeletionRule(rule);
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            if (this.jaxbSegment.getPhdam().getRules() == null) {
                this.jaxbSegment.getPhdam().setRules(new RulesType());
            }
            this.jaxbSegment.getPhdam().getRules().setDeletionRule(rule);
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            if (this.jaxbSegment.getPhidam().getRules() == null) {
                this.jaxbSegment.getPhidam().setRules(new RulesType());
            }
            this.jaxbSegment.getPhidam().getRules().setDeletionRule(rule);
        }
    }

    public void setReplacementRule(char replacementRule) {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        InsertionAndReplacementRuleType rule = InsertionAndReplacementRuleType.L;
        if (replacementRule == 'P') {
            rule = InsertionAndReplacementRuleType.P;
        } else if (replacementRule == 'V') {
            rule = InsertionAndReplacementRuleType.V;
        }
        if (dbdAccessType == DBDConstants.HISAM) {
            if (this.jaxbSegment.getHisam().getRules() == null) {
                this.jaxbSegment.getHisam().setRules(new RulesType());
            }
            this.jaxbSegment.getHisam().getRules().setReplacementRule(rule);
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            if (this.jaxbSegment.getShisam().getRules() == null) {
                this.jaxbSegment.getShisam().setRules(new RulesType());
            }
            this.jaxbSegment.getShisam().getRules().setReplacementRule(rule);
        } else if (dbdAccessType == DBDConstants.HDAM) {
            if (this.jaxbSegment.getHdam().getRules() == null) {
                this.jaxbSegment.getHdam().setRules(new RulesType());
            }
            this.jaxbSegment.getHdam().getRules().setReplacementRule(rule);
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            if (this.jaxbSegment.getHidam().getRules() == null) {
                this.jaxbSegment.getHidam().setRules(new RulesType());
            }
            this.jaxbSegment.getHidam().getRules().setReplacementRule(rule);
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            if (this.jaxbSegment.getPhdam().getRules() == null) {
                this.jaxbSegment.getPhdam().setRules(new RulesType());
            }
            this.jaxbSegment.getPhdam().getRules().setReplacementRule(rule);
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            if (this.jaxbSegment.getPhidam().getRules() == null) {
                this.jaxbSegment.getPhidam().setRules(new RulesType());
            }
            this.jaxbSegment.getPhidam().getRules().setReplacementRule(rule);
        }
    }

    public String getInsertionRule() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        RulesType rules = null;
        if (dbdAccessType == DBDConstants.HISAM) {
            rules = this.jaxbSegment.getHisam().getRules();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            rules = this.jaxbSegment.getShisam().getRules();
        } else if (dbdAccessType == DBDConstants.HDAM) {
            rules = this.jaxbSegment.getHdam().getRules();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            rules = this.jaxbSegment.getHidam().getRules();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            rules = this.jaxbSegment.getPhdam().getRules();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            rules = this.jaxbSegment.getPhidam().getRules();
        }
        if (rules == null) {
            return null;
        }
        if (rules.getInsertionRule() == null) {
            return null;
        }
        return rules.getInsertionRule().toString();
    }

    public String getDeletionRule() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        RulesType rules = null;
        if (dbdAccessType == DBDConstants.HISAM) {
            rules = this.jaxbSegment.getHisam().getRules();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            rules = this.jaxbSegment.getShisam().getRules();
        } else if (dbdAccessType == DBDConstants.HDAM) {
            rules = this.jaxbSegment.getHdam().getRules();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            rules = this.jaxbSegment.getHidam().getRules();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            rules = this.jaxbSegment.getPhdam().getRules();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            rules = this.jaxbSegment.getPhidam().getRules();
        }
        if (rules == null) {
            return null;
        }
        if (rules.getDeletionRule() == null) {
            return null;
        }
        return rules.getDeletionRule().toString();
    }

    public String getReplacementRule() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        RulesType rules = null;
        if (dbdAccessType == DBDConstants.HISAM) {
            rules = this.jaxbSegment.getHisam().getRules();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            rules = this.jaxbSegment.getShisam().getRules();
        } else if (dbdAccessType == DBDConstants.HDAM) {
            rules = this.jaxbSegment.getHdam().getRules();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            rules = this.jaxbSegment.getHidam().getRules();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            rules = this.jaxbSegment.getPhdam().getRules();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            rules = this.jaxbSegment.getPhidam().getRules();
        }
        if (rules == null) {
            return null;
        }
        if (rules.getReplacementRule() == null) {
            return null;
        }
        return rules.getReplacementRule().toString();
    }

    public String getInsertionLocation() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        RulesType rules = null;
        if (dbdAccessType == DBDConstants.HISAM) {
            rules = this.jaxbSegment.getHisam().getRules();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            rules = this.jaxbSegment.getShisam().getRules();
        } else if (dbdAccessType == DBDConstants.HDAM) {
            rules = this.jaxbSegment.getHdam().getRules();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            rules = this.jaxbSegment.getHidam().getRules();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            rules = this.jaxbSegment.getPhdam().getRules();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            rules = this.jaxbSegment.getPhidam().getRules();
        } else if (dbdAccessType == DBDConstants.DEDB) {
            LfhRulesType dedbRules = this.jaxbSegment.getDedb().getRules();
            if (dedbRules == null) {
                return null;
            }
            return dedbRules.toString();
        }
        if (rules == null) {
            return null;
        }
        if (rules.getInsertionLocation() == null) {
            return null;
        }
        return rules.getInsertionLocation().toString();
    }

    public void setRules(String rules1, String rules2) {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        RulesType rulesType = new RulesType();
        String insertionLocationStr = null;
        char insertionRule = '\u0000';
        char deletionRule = '\u0000';
        char replacementRule = '\u0000';
        boolean haveInsertionDeletionReplacementRules = false;
        if (rules1 != null && rules2 != null) {
            insertionRule = rules1.charAt(0);
            deletionRule = rules1.charAt(1);
            replacementRule = rules1.charAt(2);
            insertionLocationStr = rules2;
            haveInsertionDeletionReplacementRules = true;
        } else if (rules1 == null && rules2 != null) {
            insertionLocationStr = rules2;
        } else if (rules1 != null && rules2 == null) {
            if (rules1.equals("FIRST") || rules1.equals("F") || rules1.equals("LAST") || rules1.equals("L") || rules1.equals("HERE") || rules1.equals("H")) {
                insertionLocationStr = rules1;
            } else {
                insertionRule = rules1.charAt(0);
                deletionRule = rules1.charAt(1);
                replacementRule = rules1.charAt(2);
                haveInsertionDeletionReplacementRules = true;
            }
        }
        if (haveInsertionDeletionReplacementRules) {
            if (insertionRule == 'L') {
                rulesType.setInsertionRule(InsertionAndReplacementRuleType.L);
            } else if (insertionRule == 'P') {
                rulesType.setInsertionRule(InsertionAndReplacementRuleType.P);
            } else if (insertionRule == 'V') {
                rulesType.setInsertionRule(InsertionAndReplacementRuleType.V);
            }
            if (deletionRule == 'L') {
                rulesType.setDeletionRule(DeletionRuleType.L);
            } else if (deletionRule == 'P') {
                rulesType.setDeletionRule(DeletionRuleType.P);
            } else if (deletionRule == 'V') {
                rulesType.setDeletionRule(DeletionRuleType.V);
            } else if (deletionRule == 'B') {
                rulesType.setDeletionRule(DeletionRuleType.B);
            }
            if (replacementRule == 'L') {
                rulesType.setReplacementRule(InsertionAndReplacementRuleType.L);
            } else if (replacementRule == 'P') {
                rulesType.setReplacementRule(InsertionAndReplacementRuleType.P);
            } else if (replacementRule == 'V') {
                rulesType.setReplacementRule(InsertionAndReplacementRuleType.V);
            }
        }
        if (insertionLocationStr != null) {
            if (insertionLocationStr.equals("FIRST") || insertionLocationStr.equals("F")) {
                rulesType.setInsertionLocation(InsertionLocationType.FIRST);
            } else if (insertionLocationStr.equals("LAST") || insertionLocationStr.equals("L")) {
                rulesType.setInsertionLocation(InsertionLocationType.LAST);
            } else if (insertionLocationStr.equals("HERE") || insertionLocationStr.equals("H")) {
                rulesType.setInsertionLocation(InsertionLocationType.HERE);
            }
        }
        if (dbdAccessType == DBDConstants.HDAM) {
            this.jaxbSegment.getHdam().setRules(rulesType);
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            this.jaxbSegment.getHidam().setRules(rulesType);
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            this.jaxbSegment.getPhdam().setRules(rulesType);
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            this.jaxbSegment.getPhidam().setRules(rulesType);
        } else if (dbdAccessType != DBDConstants.PSINDEX) {
            if (dbdAccessType == DBDConstants.HISAM) {
                this.jaxbSegment.getHisam().setRules(rulesType);
            } else if (dbdAccessType == DBDConstants.SHISAM) {
                this.jaxbSegment.getShisam().setRules(rulesType);
            } else if (dbdAccessType == DBDConstants.DEDB) {
                InsertionLocationType insrtLoc = rulesType.getInsertionLocation();
                if (insrtLoc != null) {
                    if (rulesType.getInsertionLocation().equals((Object)InsertionLocationType.FIRST)) {
                        this.jaxbSegment.getDedb().setRules(LfhRulesType.FIRST);
                    } else if (rulesType.getInsertionLocation().equals((Object)InsertionLocationType.LAST)) {
                        this.jaxbSegment.getDedb().setRules(LfhRulesType.LAST);
                    } else if (rulesType.getInsertionLocation().equals((Object)InsertionLocationType.HERE)) {
                        this.jaxbSegment.getDedb().setRules(LfhRulesType.HERE);
                    }
                } else {
                    this.jaxbSegment.getDedb().setRules(LfhRulesType.HERE);
                }
            }
        }
    }

    public String getDedbSegmentType() {
        DedbDependentSegmentType dedbSegmentType = this.jaxbSegment.getDedb().getType();
        if (dedbSegmentType == null) {
            return null;
        }
        return dedbSegmentType.value();
    }

    public List<FieldModel> getIMSFields() throws ModelException {
        ArrayList<FieldModel> retVal = new ArrayList<FieldModel>();
        Vector<FieldModel> fullFieldList = this.getFieldList(false, true);
        int i = 0;
        while (i < fullFieldList.size()) {
            FieldModel currField = fullFieldList.get(i);
            if (currField.isIMSField()) {
                retVal.add(currField);
            }
            ++i;
        }
        return retVal;
    }

    public String getDedbComprtnRoutineName() {
        DedbComprtnType dedbComprtn = this.jaxbSegment.getDedb().getComprtn();
        return dedbComprtn.getRoutineName();
    }

    public DBDConstants getDedbComprtnInit() {
        DedbComprtnType dedbComprtn = this.jaxbSegment.getDedb().getComprtn();
        if (dedbComprtn == null) {
            return null;
        }
        YesnoType init = dedbComprtn.getInit();
        if (init == null) {
            return null;
        }
        return DBDConstants.fromValue(init.toString());
    }

    public DBDConstants getDedbComprtnData() {
        DedbComprtnType dedbComprtn = this.jaxbSegment.getDedb().getComprtn();
        if (dedbComprtn == null) {
            return null;
        }
        YesnoType data = dedbComprtn.getData();
        if (data == null) {
            return null;
        }
        return DBDConstants.fromValue(data.toString());
    }

    public String getComprtnRoutineName() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        ComprtnType comprtnType = null;
        DedbComprtnType dedbComprtnType = null;
        String comprtnRoutineName = null;
        if (dbdAccessType == DBDConstants.HISAM) {
            comprtnType = this.jaxbSegment.getHisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            comprtnType = this.jaxbSegment.getShisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HDAM) {
            comprtnType = this.jaxbSegment.getHdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            comprtnType = this.jaxbSegment.getHidam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            comprtnType = this.jaxbSegment.getPhdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            comprtnType = this.jaxbSegment.getPhidam().getComprtn();
        } else if (dbdAccessType == DBDConstants.DEDB) {
            dedbComprtnType = this.jaxbSegment.getDedb().getComprtn();
        }
        if (comprtnType != null) {
            comprtnRoutineName = comprtnType.getRoutineName();
        } else if (dedbComprtnType != null) {
            comprtnRoutineName = dedbComprtnType.getRoutineName();
        }
        return comprtnRoutineName;
    }

    public String getComprtnModify() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        ComprtnType comprtnType = null;
        if (dbdAccessType == DBDConstants.HISAM) {
            comprtnType = this.jaxbSegment.getHisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            comprtnType = this.jaxbSegment.getShisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HDAM) {
            comprtnType = this.jaxbSegment.getHdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            comprtnType = this.jaxbSegment.getHidam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            comprtnType = this.jaxbSegment.getPhdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            comprtnType = this.jaxbSegment.getPhidam().getComprtn();
        }
        if (comprtnType == null) {
            return null;
        }
        if (comprtnType.getData() == null) {
            return null;
        }
        if (comprtnType.getData() == YesnoType.N) {
            return "KEY";
        }
        if (comprtnType.getData() == YesnoType.Y) {
            return "DATA";
        }
        return null;
    }

    public DBDConstants getComprtnInit() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        ComprtnType comprtnType = null;
        if (dbdAccessType == DBDConstants.HISAM) {
            comprtnType = this.jaxbSegment.getHisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            comprtnType = this.jaxbSegment.getShisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HDAM) {
            comprtnType = this.jaxbSegment.getHdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            comprtnType = this.jaxbSegment.getHidam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            comprtnType = this.jaxbSegment.getPhdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            comprtnType = this.jaxbSegment.getPhidam().getComprtn();
        }
        if (comprtnType == null) {
            return null;
        }
        YesnoType init = comprtnType.getInit();
        if (init == null) {
            return null;
        }
        return DBDConstants.fromValue(init.toString());
    }

    public String getComprtnMaxBytesNumber() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        ComprtnType comprtnType = null;
        if (dbdAccessType == DBDConstants.HISAM) {
            comprtnType = this.jaxbSegment.getHisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            comprtnType = this.jaxbSegment.getShisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HDAM) {
            comprtnType = this.jaxbSegment.getHdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            comprtnType = this.jaxbSegment.getHidam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            comprtnType = this.jaxbSegment.getPhdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            comprtnType = this.jaxbSegment.getPhidam().getComprtn();
        }
        if (comprtnType == null) {
            return null;
        }
        MaxBytesType maxBytes = comprtnType.getMax();
        if (maxBytes == null) {
            return null;
        }
        return Integer.toString(maxBytes.getMax());
    }

    public DBDConstants getComprtnMaxBytesPad() {
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        ComprtnType comprtnType = null;
        if (dbdAccessType == DBDConstants.HISAM) {
            comprtnType = this.jaxbSegment.getHisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            comprtnType = this.jaxbSegment.getShisam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HDAM) {
            comprtnType = this.jaxbSegment.getHdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            comprtnType = this.jaxbSegment.getHidam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            comprtnType = this.jaxbSegment.getPhdam().getComprtn();
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            comprtnType = this.jaxbSegment.getPhidam().getComprtn();
        }
        if (comprtnType == null) {
            return null;
        }
        MaxBytesType maxBytes = comprtnType.getMax();
        YesnoType pad = null;
        if (maxBytes != null) {
            pad = maxBytes.getPad();
        }
        if (pad == null) {
            return null;
        }
        return DBDConstants.fromValue(pad.toString());
    }

    public void setDedbComprtn(String[] comprtnKeywords) {
        DedbComprtnType comprtnType = new DedbComprtnType();
        comprtnType.setRoutineName(comprtnKeywords[0]);
        if (comprtnKeywords[1] != null) {
            if (comprtnKeywords[1].equals("INIT")) {
                comprtnType.setInit(YesnoType.Y);
            } else if (comprtnKeywords[1].equals("DATA")) {
                comprtnType.setData(YesnoType.Y);
                if (comprtnKeywords[2] != null && comprtnKeywords[2].equals("INIT")) {
                    comprtnType.setInit(YesnoType.Y);
                }
            }
        }
        this.jaxbSegment.getDedb().setComprtn(comprtnType);
    }

    public void setComprtn(String[] comprtnKeywords) {
        MaxBytesType maxByteType;
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        ComprtnType comprtnType = new ComprtnType();
        boolean maxSet = false;
        if (comprtnKeywords[0] != null && !comprtnKeywords[0].isEmpty()) {
            comprtnType.setRoutineName(comprtnKeywords[0]);
        }
        if (comprtnKeywords[1] != null) {
            if (comprtnKeywords[1].equals("KEY")) {
                comprtnType.setData(YesnoType.N);
            } else if (comprtnKeywords[1].equals("DATA")) {
                comprtnType.setData(YesnoType.Y);
            }
        }
        if (comprtnKeywords[2] != null && !comprtnKeywords[2].isEmpty()) {
            if (comprtnKeywords[2].equals("INIT")) {
                comprtnType.setInit(YesnoType.Y);
            } else {
                maxByteType = new MaxBytesType();
                maxByteType.setMax(Integer.valueOf(comprtnKeywords[2]));
                if (comprtnKeywords[3] != null && comprtnKeywords[3].equals("PAD")) {
                    maxByteType.setPad(YesnoType.Y);
                }
                comprtnType.setMax(maxByteType);
                maxSet = true;
            }
        }
        if (!maxSet && comprtnKeywords[3] != null && !comprtnKeywords[3].isEmpty()) {
            maxByteType = new MaxBytesType();
            maxByteType.setMax(Integer.valueOf(comprtnKeywords[3]));
            if (comprtnKeywords[4] != null && comprtnKeywords[4].equals("PAD")) {
                maxByteType.setPad(YesnoType.Y);
            }
            comprtnType.setMax(maxByteType);
        }
        if (dbdAccessType == DBDConstants.HDAM) {
            this.jaxbSegment.getHdam().setComprtn(comprtnType);
        } else if (dbdAccessType == DBDConstants.HIDAM) {
            this.jaxbSegment.getHidam().setComprtn(comprtnType);
        } else if (dbdAccessType == DBDConstants.PHDAM) {
            this.jaxbSegment.getPhdam().setComprtn(comprtnType);
        } else if (dbdAccessType == DBDConstants.PHIDAM) {
            this.jaxbSegment.getPhidam().setComprtn(comprtnType);
        } else if (dbdAccessType == DBDConstants.HISAM) {
            this.jaxbSegment.getHisam().setComprtn(comprtnType);
        } else if (dbdAccessType == DBDConstants.SHISAM) {
            this.jaxbSegment.getShisam().setComprtn(comprtnType);
        }
    }

    public String getRemarks() {
        return this.jaxbSegment.getRemarks();
    }

    public void setRemarks(String value) {
        this.jaxbSegment.setRemarks(value);
    }

    public Iterator<MappingModel> getMappingList() {
        return this.mappingList.values().iterator();
    }

    public List<MappingModel> getMapList() {
        ArrayList<MappingModel> maps = new ArrayList<MappingModel>();
        int size = this.mappingList.size();
        Iterator<MappingModel> tempIterator = this.mappingList.values().iterator();
        int i = 0;
        while (i < size) {
            maps.add(tempIterator.next());
            ++i;
        }
        return maps;
    }

    public MappingModel getMapping(String mappingName) {
        return this.mappingList.get(mappingName);
    }

    public MappingCaseModel getMappingCase(String mappingName, String caseName) {
        return this.mappingList.get(mappingName).getMappingCaseModel(caseName);
    }

    public boolean hasDFSmap() {
        return !this.mappingList.isEmpty();
    }

    private void buildMappingList() {
        Iterator<Object> iter = this.jaxbSegment.getFieldOrMappingOrLchild().iterator();
        Vector<MappingType> mappingTypeList = new Vector<MappingType>();
        this.mappingList = new LinkedHashMap();
        while (iter.hasNext()) {
            Object currObj = iter.next();
            if (!(currObj instanceof MappingType)) continue;
            mappingTypeList.add((MappingType)currObj);
        }
        int i = 0;
        while (i < mappingTypeList.size()) {
            MappingModel currMappingModel = new MappingModel((MappingType)mappingTypeList.get(i));
            this.mappingList.put(currMappingModel.getName(), currMappingModel);
            ++i;
        }
    }

    public List<FieldModel> getCaseFields(MappingCaseType mappingCaseType) {
        List<FieldType> caseFieldTypes = mappingCaseType.getField();
        Iterator<FieldType> it = caseFieldTypes.iterator();
        ArrayList<FieldModel> caseFieldModels = new ArrayList<FieldModel>();
        while (it.hasNext()) {
            FieldType fieldType = it.next();
            FieldModelImpl caseFieldModel = new FieldModelImpl(fieldType);
            caseFieldModel.setSegmentModel(this);
            caseFieldModels.add(caseFieldModel);
        }
        return caseFieldModels;
    }

    public void clearFieldList() {
        if (this.commonFieldList != null) {
            this.commonFieldList.removeAllElements();
        }
        if (this.topLevelFieldList != null) {
            this.topLevelFieldList.removeAllElements();
        }
        this.topLevelFieldList = null;
        this.commonFieldList = null;
    }

    public void clearSysRelFieldList() {
        if (this.sysRelFieldList != null) {
            this.sysRelFieldList.removeAllElements();
        }
        this.sysRelFieldList = null;
    }

    public static void addFieldInOrder(Vector<FieldModel> fieldList, FieldModel newField) throws ModelException {
        String redefinedField = newField.getRedefines();
        String startAfter = newField.getStartAfter();
        if (redefinedField != null && !redefinedField.isEmpty()) {
            SegmentModel.addFieldAfter(fieldList, redefinedField, newField);
        } else if (startAfter != null && !startAfter.isEmpty()) {
            SegmentModel.addFieldAfter(fieldList, startAfter, newField);
        } else if (fieldList.isEmpty()) {
            fieldList.add(newField);
        } else {
            int startPos = newField.getStartOrRelstart();
            int i = 0;
            while (i < fieldList.size()) {
                int currFieldStart;
                FieldModel currField = fieldList.get(i);
                String currStartAfter = currField.getStartAfter();
                if ((currStartAfter == null || currStartAfter.isEmpty()) && startPos < (currFieldStart = currField.getStartOrRelstart())) {
                    fieldList.insertElementAt(newField, i);
                    return;
                }
                ++i;
            }
            fieldList.add(newField);
        }
    }

    private static void addFieldAfter(Vector<FieldModel> fieldList, String startAfter, FieldModel newField) throws ModelException {
        boolean startAfterFieldFound = false;
        int i = 0;
        while (i < fieldList.size()) {
            FieldModel currField = fieldList.get(i);
            if (startAfter.equals(currField.getName())) {
                int j = i + 1;
                while (j < fieldList.size()) {
                    FieldModel potentialRedefinesGroupMember = fieldList.get(j);
                    Boolean potentialRedefined = potentialRedefinesGroupMember.getRedefines() != null && !potentialRedefinesGroupMember.getRedefines().isEmpty();
                    if (!potentialRedefined.booleanValue() || j >= fieldList.size() - 1) {
                        if (potentialRedefined.booleanValue()) {
                            fieldList.insertElementAt(newField, j + 1);
                        } else {
                            fieldList.insertElementAt(newField, j);
                        }
                        startAfterFieldFound = true;
                        break;
                    }
                    ++j;
                }
                if (startAfterFieldFound) break;
                fieldList.insertElementAt(newField, i + 1);
                startAfterFieldFound = true;
                break;
            }
            ++i;
        }
        if (!startAfterFieldFound) {
            throw new ModelException("Internal Error: While building field list the new field " + newField.getName() + " is supposed to start after " + startAfter + " , which was not found in the peer field list.");
        }
    }

    public void setLogicalSourceSeg(SegmentModel logicalSourceSeg) {
        this.logicalSourceSeg = logicalSourceSeg;
    }

    public void setLchildSourceSeg(SegmentModel lchildSourceSeg) {
        this.lchildSourceSeg = lchildSourceSeg;
    }

    public void setTargetParentSourceSeg(SegmentModel targetParentSourceSeg) {
        this.targetParentSourceSeg = targetParentSourceSeg;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public void addFieldWithIntactSubtree(FieldModel newField) throws ModelException {
        newField.setSegmentModel(this);
        this.clearFieldList();
        List<Object> peerFields = this.jaxbSegment.getFieldOrMappingOrLchild();
        peerFields.add(newField.getFieldType());
    }
}

