/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.imsresourcetemplates.ImsResourceTemplates;
import com.ibm.im.ims.metadata.imsresourcetemplates.TemplateType;
import com.ibm.im.ims.workbench.model.TemplateModel;
import java.util.ArrayList;
import java.util.List;

public class ResourceTemplatesModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ImsResourceTemplates imsResourceTemplates = null;
    private ArrayList<TemplateModel> templateModels = null;
    private ArrayList<TemplateModel> originalTemplateModels = null;

    public ResourceTemplatesModel() {
        this.templateModels = new ArrayList();
        this.originalTemplateModels = new ArrayList();
        this.imsResourceTemplates = new ImsResourceTemplates();
    }

    public ResourceTemplatesModel(ImsResourceTemplates imsResourceTemplates) {
        int i;
        this.imsResourceTemplates = imsResourceTemplates;
        List<TemplateType> templateTypes = imsResourceTemplates.getTemplate();
        if (templateTypes != null) {
            this.templateModels = new ArrayList();
            i = 0;
            while (i < templateTypes.size()) {
                TemplateType jaxbTemplate = templateTypes.get(i);
                this.templateModels.add(new TemplateModel(jaxbTemplate));
                ++i;
            }
        }
        this.originalTemplateModels = new ArrayList();
        i = 0;
        while (i < this.templateModels.size()) {
            TemplateModel tmCopy = new TemplateModel(this.templateModels.get(i));
            this.originalTemplateModels.add(tmCopy);
            ++i;
        }
    }

    public ArrayList<TemplateModel> getOriginalTemplateModels() {
        return this.originalTemplateModels;
    }

    public TemplateModel getOriginalTemplateModel(String templateName) {
        int i = 0;
        while (i < this.originalTemplateModels.size()) {
            if (this.originalTemplateModels.get(i).getTemplateName().equals(templateName)) {
                return this.originalTemplateModels.get(i);
            }
            ++i;
        }
        return null;
    }

    public ArrayList<TemplateModel> getTemplateModels() {
        return this.templateModels;
    }

    public TemplateModel getTemplateModel(String templateName) {
        if (this.templateModels != null && templateName != null) {
            int i = 0;
            while (i < this.templateModels.size()) {
                TemplateModel template = this.templateModels.get(i);
                if (template.getTemplateName().equals(templateName)) {
                    return template;
                }
                ++i;
            }
        }
        return null;
    }

    public ResourceTemplatesModel cloneResourceTemplatesModels() {
        ResourceTemplatesModel clonedResourceTemplatesModel = new ResourceTemplatesModel();
        clonedResourceTemplatesModel.setImsResourceTemplates(this.imsResourceTemplates);
        clonedResourceTemplatesModel.buildTemplateModels(this.imsResourceTemplates);
        return clonedResourceTemplatesModel;
    }

    private void setImsResourceTemplates(ImsResourceTemplates imsResourceTemplates) {
        this.imsResourceTemplates = imsResourceTemplates;
    }

    public ArrayList<TemplateModel> buildTemplateModels(ImsResourceTemplates imsResourceTemplates) {
        List<TemplateType> templateTypes = imsResourceTemplates.getTemplate();
        ArrayList<TemplateModel> clonedTemplateModels = null;
        if (templateTypes != null) {
            clonedTemplateModels = new ArrayList<TemplateModel>();
            int i = 0;
            while (i < templateTypes.size()) {
                clonedTemplateModels.add(new TemplateModel(templateTypes.get(i)));
                ++i;
            }
        }
        return clonedTemplateModels;
    }

    public void clearTemplateModels() {
        this.templateModels.clear();
    }

    public void replaceOrigTemplateWithClone(TemplateModel clonedTemplateModel, TemplateModel originalTemplateModel) {
        if (clonedTemplateModel != null && originalTemplateModel != null) {
            this.replaceTemplate(clonedTemplateModel, originalTemplateModel);
        }
    }

    private void replaceTemplate(TemplateModel clonedTemplateModel, TemplateModel originalTemplateModel) {
        List<TemplateType> jaxbTemplates = this.imsResourceTemplates.getTemplate();
        int i = 0;
        while (i < jaxbTemplates.size()) {
            TemplateType curJaxbTemplate = jaxbTemplates.get(i);
            if (curJaxbTemplate.getName().equals(originalTemplateModel.getTemplateName())) {
                jaxbTemplates.remove(i);
                jaxbTemplates.add(i, clonedTemplateModel.getTemplateType());
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.templateModels.size()) {
            TemplateModel currentTemplateModel = this.templateModels.get(i);
            if (currentTemplateModel.getTemplateName().equals(originalTemplateModel.getTemplateName())) {
                this.templateModels.remove(i);
                this.templateModels.add(i, clonedTemplateModel);
                break;
            }
            ++i;
        }
    }

    public void removeTemplateModel(String templateName) {
        List<TemplateType> jaxbTemplates = this.imsResourceTemplates.getTemplate();
        int i = 0;
        while (i < jaxbTemplates.size()) {
            TemplateType curJaxbTemplate = jaxbTemplates.get(i);
            if (curJaxbTemplate.getName().equals(templateName)) {
                jaxbTemplates.remove(i);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.templateModels.size()) {
            TemplateModel templateModel = this.templateModels.get(i);
            if (templateModel.getTemplateName().equals(templateName)) {
                this.templateModels.remove(i);
                break;
            }
            ++i;
        }
    }

    public void addTemplateModel(TemplateModel templateModel) {
        this.templateModels.add(templateModel);
        this.imsResourceTemplates.getTemplate().add(templateModel.getTemplateType());
    }

    public TemplateModel createTemplateModelForEdit(String originalTemplateName) {
        TemplateModel retVal = null;
        if (this.templateModels != null) {
            int i = 0;
            while (i < this.templateModels.size()) {
                TemplateModel currentTemplateModel = this.templateModels.get(i);
                if (currentTemplateModel.getTemplateName().equals(originalTemplateName)) {
                    retVal = new TemplateModel(currentTemplateModel);
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public ImsResourceTemplates getImsResourceTemplates() {
        return this.imsResourceTemplates;
    }
}

