/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.psb.DblevelType;
import com.ibm.im.ims.metadata.psb.IoeropnType;
import com.ibm.im.ims.metadata.psb.LangType;
import com.ibm.im.ims.metadata.psb.ObjectFactory;
import com.ibm.im.ims.metadata.psb.PcbDBType;
import com.ibm.im.ims.metadata.psb.PcbGSAMType;
import com.ibm.im.ims.metadata.psb.PcbTPType;
import com.ibm.im.ims.metadata.psb.Psb;
import com.ibm.im.ims.metadata.psb.YesnoType;
import com.ibm.im.ims.workbench.model.BooleanBean;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.IImsResourceModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PcbTPModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public class PsbModel
implements IImsResourceModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private JAXBContext psbContext;
    private Psb jaxbPsb = null;
    private List<PcbDBModel> dbPcbList = null;
    private List<PcbTPModel> tpPcbList = null;
    private List<PcbGsamModel> gsamPcbList = null;
    private BooleanBean atLeastOneDbpcbDidNotHaveName;
    private BooleanBean atLeastOneDbpcbDidNotHaveTimestamp;
    Marshaller psbMarshaller = null;

    public PsbModel() throws ModelException {
        try {
            this.psbContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.psb", (ClassLoader)ObjectFactory.class.getClassLoader());
            this.jaxbPsb = new Psb();
            this.jaxbPsb.setXmlSchemaVersion("1");
        }
        catch (JAXBException e) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1607"), e);
        }
    }

    public PsbModel(InputStream is) throws ModelException {
        try {
            this.psbContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.psb", (ClassLoader)ObjectFactory.class.getClassLoader());
            Unmarshaller psbUnmarshaller = this.psbContext.createUnmarshaller();
            this.jaxbPsb = (Psb)psbUnmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1607"), e);
        }
        this.buildTpPcbList();
        this.buildDbPcbList();
        this.buildGsamPcbList();
        this.updatePCBNums();
    }

    public String getDbdNameForPcb(String dbPcbName) {
        return null;
    }

    private void updatePCBNums() {
        int j;
        int i = 1;
        if (this.tpPcbList != null) {
            j = 0;
            while (j < this.tpPcbList.size()) {
                this.tpPcbList.get(j).setPcbNum(i);
                ++i;
                ++j;
            }
        }
        if (this.dbPcbList != null) {
            j = 0;
            while (j < this.dbPcbList.size()) {
                this.dbPcbList.get(j).setPcbNum(i);
                ++i;
                ++j;
            }
        }
        if (this.gsamPcbList != null) {
            j = 0;
            while (j < this.gsamPcbList.size()) {
                this.gsamPcbList.get(j).setPcbNum(i);
                ++i;
                ++j;
            }
        }
    }

    private void buildDbPcbList() throws ModelException {
        List<PcbDBType> jaxbPcbs = this.jaxbPsb.getDbPCB();
        if (jaxbPcbs == null || jaxbPcbs.size() == 0) {
            return;
        }
        this.atLeastOneDbpcbDidNotHaveName = new BooleanBean();
        this.atLeastOneDbpcbDidNotHaveTimestamp = new BooleanBean();
        this.atLeastOneDbpcbDidNotHaveName.myBool = false;
        this.atLeastOneDbpcbDidNotHaveTimestamp.myBool = false;
        this.dbPcbList = new ArrayList<PcbDBModel>();
        int i = 0;
        while (i < jaxbPcbs.size()) {
            PcbDBModel pcbModel = new PcbDBModel(jaxbPcbs.get(i), this.atLeastOneDbpcbDidNotHaveName, this.atLeastOneDbpcbDidNotHaveTimestamp);
            this.dbPcbList.add(pcbModel);
            ++i;
        }
    }

    public BooleanBean getAtLeastOneDbpcbDidNotHaveName() {
        return this.atLeastOneDbpcbDidNotHaveName;
    }

    public BooleanBean getAtLeastOneDbpcbDidNotHaveTimestamp() {
        return this.atLeastOneDbpcbDidNotHaveTimestamp;
    }

    private void buildGsamPcbList() {
        List<PcbGSAMType> jaxbPcbs = this.jaxbPsb.getGsamPCB();
        if (jaxbPcbs == null || jaxbPcbs.size() == 0) {
            return;
        }
        this.gsamPcbList = new ArrayList<PcbGsamModel>();
        int i = 0;
        while (i < jaxbPcbs.size()) {
            PcbGsamModel pcbModel = new PcbGsamModel(jaxbPcbs.get(i));
            this.gsamPcbList.add(pcbModel);
            ++i;
        }
    }

    private void buildTpPcbList() {
        List<PcbTPType> jaxbPcbs = this.jaxbPsb.getTpPCB();
        if (jaxbPcbs == null || jaxbPcbs.size() == 0) {
            return;
        }
        this.tpPcbList = new ArrayList<PcbTPModel>();
        int i = 0;
        while (i < jaxbPcbs.size()) {
            PcbTPModel pcbModel = new PcbTPModel(jaxbPcbs.get(i));
            this.tpPcbList.add(pcbModel);
            ++i;
        }
    }

    public void marshall(ByteArrayOutputStream psbOutputStream) throws ModelException {
        try {
            if (this.psbMarshaller == null) {
                this.psbMarshaller = this.psbContext.createMarshaller();
                this.psbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
            this.psbMarshaller.marshal((Object)this.jaxbPsb, (OutputStream)psbOutputStream);
        }
        catch (PropertyException e) {
            Object[] dbError = new String[]{"jaxb.formatted.output"};
            ModelException me = new ModelException(WorkbenchModelBundle.getError().getString("DHB1604", dbError));
            me.initCause(e);
            throw me;
        }
        catch (JAXBException e) {
            ModelException me = new ModelException(WorkbenchModelBundle.getError().getString("DHB1605"));
            me.initCause(e);
            throw me;
        }
    }

    public void marshall(File file) throws ModelException {
        try {
            if (this.psbMarshaller == null) {
                this.psbMarshaller = this.psbContext.createMarshaller();
                this.psbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
            this.psbMarshaller.marshal((Object)this.jaxbPsb, file);
        }
        catch (PropertyException e) {
            Object[] dbError = new String[]{"jaxb.formatted.output"};
            ModelException me = new ModelException(WorkbenchModelBundle.getError().getString("DHB1604", dbError));
            me.initCause(e);
            throw me;
        }
        catch (JAXBException e) {
            ModelException me = new ModelException(WorkbenchModelBundle.getError().getString("DHB1605"));
            me.initCause(e);
            throw me;
        }
    }

    public String getPsbName() {
        return this.jaxbPsb.getPsbName();
    }

    public Psb getJaxbPsb() {
        return this.jaxbPsb;
    }

    public void setPsbName(String value) {
        this.jaxbPsb.setPsbName(value);
    }

    public void setDblevel(String value) {
        if (value != null && !value.isEmpty()) {
            if (value.equals(DblevelType.BASE.toString())) {
                this.jaxbPsb.setDbLevel(DblevelType.BASE);
            } else {
                this.jaxbPsb.setDbLevel(DblevelType.CURR);
            }
        } else {
            this.jaxbPsb.setDbLevel(null);
        }
    }

    public String getDblevel() {
        if (this.jaxbPsb.getDbLevel() == null) {
            return null;
        }
        return this.jaxbPsb.getDbLevel().toString();
    }

    public String toString() {
        return "PsbName: " + this.getPsbName();
    }

    public void setLang(DBDConstants value) {
        this.jaxbPsb.setLang(LangType.valueOf(value.toString()));
    }

    public DBDConstants getLang() {
        if (this.jaxbPsb.getLang() == null) {
            return null;
        }
        return DBDConstants.valueOf(this.jaxbPsb.getLang().name());
    }

    public void setSsaSize(Integer value) {
        this.jaxbPsb.setSsaSize(value);
    }

    public Integer getSsaSize() {
        return this.jaxbPsb.getSsaSize();
    }

    public void setMaximumLock(Integer value) {
        this.jaxbPsb.setMaximumLock(value);
    }

    public Integer getMaximumLock() {
        return this.jaxbPsb.getMaximumLock();
    }

    public void setIoeropnConditionCode(Integer value) {
        IoeropnType ioeropn = this.jaxbPsb.getIoeropn();
        if (ioeropn == null) {
            ioeropn = new IoeropnType();
            this.jaxbPsb.setIoeropn(ioeropn);
        }
        ioeropn.setIoeropnConditionCode(value);
    }

    public Integer getIoeropnConditionCode() {
        Integer retVal = null;
        IoeropnType ioeropn = this.jaxbPsb.getIoeropn();
        if (ioeropn != null) {
            retVal = ioeropn.getIoeropnConditionCode();
        }
        return retVal;
    }

    public DBDConstants getIoeropnWTOR() {
        IoeropnType ioeropn = this.jaxbPsb.getIoeropn();
        if (ioeropn == null || ioeropn.getIoeropnWTOR() == null) {
            return null;
        }
        return DBDConstants.valueOf(ioeropn.getIoeropnWTOR().value());
    }

    public void setIoeropnWTOR(DBDConstants value) {
        IoeropnType ioeropn = this.jaxbPsb.getIoeropn();
        if (ioeropn == null) {
            ioeropn = new IoeropnType();
            this.jaxbPsb.setIoeropn(ioeropn);
        }
        ioeropn.setIoeropnWTOR(YesnoType.valueOf(value.toString()));
    }

    public DBDConstants getOnlineDBImageCopy() {
        if (this.jaxbPsb.getOnlineDBImageCopy() == null) {
            return null;
        }
        return DBDConstants.valueOf(this.jaxbPsb.getOnlineDBImageCopy().toString());
    }

    public void setOnlineDBImageCopy(DBDConstants value) {
        this.jaxbPsb.setOnlineDBImageCopy(YesnoType.valueOf(value.toString()));
    }

    public int getMaxq() {
        return this.jaxbPsb.getMaxq();
    }

    public void setMaxq(Integer value) {
        this.jaxbPsb.setMaxq(value);
    }

    public DBDConstants getCompat() {
        if (this.jaxbPsb.getCompat() == null) {
            return null;
        }
        return DBDConstants.valueOf(this.jaxbPsb.getCompat().toString());
    }

    public void setCompat(DBDConstants value) {
        this.jaxbPsb.setCompat(YesnoType.valueOf(value.toString()));
    }

    public Integer getIoAreaSize() {
        return this.jaxbPsb.getIoAreaSize();
    }

    public void setIoAreaSize(Integer value) {
        this.jaxbPsb.setIoAreaSize(value);
    }

    public String getTimestamp() {
        return this.jaxbPsb.getTimestamp();
    }

    public List<PcbDBModel> getDBPcbList() {
        return this.dbPcbList;
    }

    public ArrayList<String> getDbPcbAliases() {
        List<PcbDBModel> dbPcbs = this.getDBPcbList();
        ArrayList<String> retVal = new ArrayList<String>(dbPcbs.size());
        int i = 0;
        while (i < dbPcbs.size()) {
            PcbDBModel currPcb = dbPcbs.get(i);
            retVal.add(currPcb.getPcbAlias());
            ++i;
        }
        return retVal;
    }

    public PcbDBModel getDBPcb(String pcbIMSName) {
        PcbDBModel retVal = null;
        int i = 0;
        while (i < this.dbPcbList.size()) {
            PcbDBModel tempPcb = this.dbPcbList.get(i);
            String pcbName = tempPcb.getExternalName();
            if (pcbName == null || pcbName.isEmpty()) {
                pcbName = tempPcb.getLabel();
            }
            if (pcbName != null && pcbName.equalsIgnoreCase(pcbIMSName)) {
                retVal = tempPcb;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public List<PcbTPModel> getTPPcbList() {
        return this.tpPcbList;
    }

    public List<PcbGsamModel> getGsamPcbList() {
        return this.gsamPcbList;
    }

    public DBDConstants getGsamRollb() {
        if (this.jaxbPsb.getGsamRollb() == null) {
            return null;
        }
        return DBDConstants.valueOf(this.jaxbPsb.getGsamRollb().toString());
    }

    public void setGsamRollb(DBDConstants value) {
        this.jaxbPsb.setGsamRollb(YesnoType.valueOf(value.toString()));
    }

    public void addDBPcb(PcbDBModel dbPcb) {
        if (this.dbPcbList == null) {
            this.dbPcbList = new ArrayList<PcbDBModel>();
        }
        this.dbPcbList.add(dbPcb);
        this.jaxbPsb.getDbPCB().add(dbPcb.jaxbDBPcb);
        this.updatePCBNums();
    }

    public void addTPPcb(PcbTPModel tpPcb) {
        if (this.tpPcbList == null) {
            this.tpPcbList = new ArrayList<PcbTPModel>();
        }
        this.tpPcbList.add(tpPcb);
        this.jaxbPsb.getTpPCB().add(tpPcb.jaxbTPPcb);
        this.updatePCBNums();
    }

    public void addGSAMPcb(PcbGsamModel gsamPcb) {
        if (this.gsamPcbList == null) {
            this.gsamPcbList = new ArrayList<PcbGsamModel>();
        }
        this.gsamPcbList.add(gsamPcb);
        this.jaxbPsb.getGsamPCB().add(gsamPcb.jaxbGsamPcb);
        this.updatePCBNums();
    }

    public PcbTPModel getTpPcbWithNum(int pcbNum) {
        PcbTPModel retVal = null;
        int i = 0;
        while (i < this.tpPcbList.size()) {
            PcbTPModel currPcb = this.tpPcbList.get(i);
            if (currPcb.getPcbNum() == pcbNum) {
                retVal = currPcb;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public PcbDBModel getDbPcbWithNum(int pcbNum) {
        PcbDBModel retVal = null;
        int i = 0;
        while (i < this.dbPcbList.size()) {
            PcbDBModel currPcb = this.dbPcbList.get(i);
            if (currPcb.getPcbNum() == pcbNum) {
                retVal = currPcb;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public PcbGsamModel getGsamPcbWithNum(int pcbNum) {
        PcbGsamModel retVal = null;
        int i = 0;
        while (i < this.gsamPcbList.size()) {
            PcbGsamModel currPcb = this.gsamPcbList.get(i);
            if (currPcb.getPcbNum() == pcbNum) {
                retVal = currPcb;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public boolean removeTpPcbWithNum(int pcbNum) {
        boolean retVal = false;
        int i = 0;
        while (i < this.tpPcbList.size()) {
            PcbTPModel currPcb = this.tpPcbList.get(i);
            if (currPcb.getPcbNum() == pcbNum) {
                this.tpPcbList.remove(currPcb);
                retVal = true;
                break;
            }
            ++i;
        }
        if (retVal) {
            this.updatePCBNums();
        }
        return retVal;
    }

    public void removeTPPcb(int index) {
        PcbTPModel tpPcb = this.tpPcbList.get(index);
        if (this.tpPcbList != null) {
            this.tpPcbList.remove(tpPcb);
            this.jaxbPsb.getTpPCB().remove(tpPcb.jaxbTPPcb);
        }
        this.updatePCBNums();
    }

    public void removeTPPcb(PcbTPModel tpPcb) {
        if (this.tpPcbList != null) {
            this.tpPcbList.remove(tpPcb);
            this.jaxbPsb.getTpPCB().remove(tpPcb.jaxbTPPcb);
        }
        this.updatePCBNums();
    }

    public boolean removeDbPcbWithNum(int pcbNum) {
        boolean retVal = false;
        int i = 0;
        while (i < this.dbPcbList.size()) {
            PcbDBModel currPcb = this.dbPcbList.get(i);
            if (currPcb.getPcbNum() == pcbNum) {
                this.dbPcbList.remove(currPcb);
                retVal = true;
                break;
            }
            ++i;
        }
        if (retVal) {
            this.updatePCBNums();
        }
        return retVal;
    }

    public void removeDBPcb(int index) {
        PcbDBModel dbPcb = this.dbPcbList.get(index);
        if (this.dbPcbList != null) {
            this.dbPcbList.remove(dbPcb);
            this.jaxbPsb.getDbPCB().remove(dbPcb.jaxbDBPcb);
        }
        this.updatePCBNums();
    }

    public void removeDBPcb(PcbDBModel dbPcb) {
        if (this.dbPcbList != null) {
            this.dbPcbList.remove(dbPcb);
            this.jaxbPsb.getDbPCB().remove(dbPcb.jaxbDBPcb);
        }
        this.updatePCBNums();
    }

    public boolean removeGsamPcbWithNum(int pcbNum) {
        boolean retVal = false;
        int i = 0;
        while (i < this.gsamPcbList.size()) {
            PcbGsamModel currPcb = this.gsamPcbList.get(i);
            if (currPcb.getPcbNum() == pcbNum) {
                this.gsamPcbList.remove(currPcb);
                retVal = true;
                break;
            }
            ++i;
        }
        if (retVal) {
            this.updatePCBNums();
        }
        return retVal;
    }

    public void removeGsamPcb(int index) {
        PcbGsamModel gsamPcb = this.gsamPcbList.get(index);
        if (this.gsamPcbList != null) {
            this.gsamPcbList.remove(gsamPcb);
            this.jaxbPsb.getGsamPCB().remove(gsamPcb.jaxbGsamPcb);
        }
        this.updatePCBNums();
    }

    public void removeGsamPcb(PcbGsamModel gsamPcb) {
        if (this.gsamPcbList != null) {
            this.gsamPcbList.remove(gsamPcb);
            this.jaxbPsb.getGsamPCB().remove(gsamPcb.jaxbGsamPcb);
        }
        this.updatePCBNums();
    }

    public boolean moveTpPcbUp(int pcbNum) {
        boolean retVal = false;
        int index = -1;
        int j = 0;
        while (j < this.tpPcbList.size()) {
            PcbTPModel currPcb = this.tpPcbList.get(j);
            if (currPcb.getPcbNum() == pcbNum) {
                index = j;
                break;
            }
            ++j;
        }
        if (index > 0) {
            PcbTPModel temp = this.tpPcbList.get(index - 1);
            PcbTPModel movingPcb = this.tpPcbList.get(index);
            this.tpPcbList.set(index - 1, movingPcb);
            this.tpPcbList.set(index, temp);
            retVal = true;
        }
        if (retVal) {
            this.updatePCBNums();
        }
        return retVal;
    }

    public boolean moveDbPcbUp(int pcbNum) {
        boolean retVal = false;
        int index = -1;
        int j = 0;
        while (j < this.dbPcbList.size()) {
            PcbDBModel currPcb = this.dbPcbList.get(j);
            if (currPcb.getPcbNum() == pcbNum) {
                index = j;
                break;
            }
            ++j;
        }
        if (index > 0) {
            PcbDBModel temp = this.dbPcbList.get(index - 1);
            PcbDBModel movingPcb = this.dbPcbList.get(index);
            this.dbPcbList.set(index - 1, movingPcb);
            this.dbPcbList.set(index, temp);
            retVal = true;
        }
        if (retVal) {
            this.updatePCBNums();
        }
        return retVal;
    }

    public boolean moveGsamPcbUp(int pcbNum) {
        boolean retVal = false;
        int index = -1;
        int j = 0;
        while (j < this.gsamPcbList.size()) {
            PcbGsamModel currPcb = this.gsamPcbList.get(j);
            if (currPcb.getPcbNum() == pcbNum) {
                index = j;
                break;
            }
            ++j;
        }
        if (index > 0) {
            PcbGsamModel temp = this.gsamPcbList.get(index - 1);
            PcbGsamModel movingPcb = this.gsamPcbList.get(index);
            this.gsamPcbList.set(index - 1, movingPcb);
            this.gsamPcbList.set(index, temp);
            retVal = true;
        }
        if (retVal) {
            this.updatePCBNums();
        }
        return retVal;
    }

    public boolean moveTpPcbDown(int pcbNum) {
        boolean retVal = false;
        int index = -1;
        int j = 0;
        while (j < this.tpPcbList.size()) {
            PcbTPModel currPcb = this.tpPcbList.get(j);
            if (currPcb.getPcbNum() == pcbNum) {
                index = j;
                break;
            }
            ++j;
        }
        if (index >= 0 && index < this.tpPcbList.size() - 1) {
            PcbTPModel temp = this.tpPcbList.get(index + 1);
            PcbTPModel movingPcb = this.tpPcbList.get(index);
            this.tpPcbList.set(index + 1, movingPcb);
            this.tpPcbList.set(index, temp);
            retVal = true;
        }
        if (retVal) {
            this.updatePCBNums();
        }
        return retVal;
    }

    public boolean moveDbPcbDown(int pcbNum) {
        boolean retVal = false;
        int index = -1;
        int j = 0;
        while (j < this.dbPcbList.size()) {
            PcbDBModel currPcb = this.dbPcbList.get(j);
            if (currPcb.getPcbNum() == pcbNum) {
                index = j;
                break;
            }
            ++j;
        }
        if (index >= 0 && index < this.dbPcbList.size() - 1) {
            PcbDBModel temp = this.dbPcbList.get(index + 1);
            PcbDBModel movingPcb = this.dbPcbList.get(index);
            this.dbPcbList.set(index + 1, movingPcb);
            this.dbPcbList.set(index, temp);
            retVal = true;
        }
        if (retVal) {
            this.updatePCBNums();
        }
        return retVal;
    }

    public boolean moveGsamPcbDown(int pcbNum) {
        boolean retVal = false;
        int index = -1;
        int j = 0;
        while (j < this.gsamPcbList.size()) {
            PcbGsamModel currPcb = this.gsamPcbList.get(j);
            if (currPcb.getPcbNum() == pcbNum) {
                index = j;
                break;
            }
            ++j;
        }
        if (index >= 0 && index < this.gsamPcbList.size() - 1) {
            PcbGsamModel temp = this.gsamPcbList.get(index + 1);
            PcbGsamModel movingPcb = this.gsamPcbList.get(index);
            this.gsamPcbList.set(index + 1, movingPcb);
            this.gsamPcbList.set(index, temp);
            retVal = true;
        }
        if (retVal) {
            this.updatePCBNums();
        }
        return retVal;
    }

    @Override
    public boolean isDBD() {
        return false;
    }

    @Override
    public boolean isPSB() {
        return true;
    }

    public void setPsbRemarks(String remarks) {
        this.jaxbPsb.setRemarks(remarks);
    }

    public String getPsbRemarks() {
        return this.jaxbPsb.getRemarks();
    }

    public boolean hasVariableString(String varString) {
        String psbName = this.jaxbPsb.getPsbName();
        return psbName.contains(varString);
    }
}

