/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.psb.AccessFPIndexType;
import com.ibm.im.ims.metadata.psb.PcbDBType;
import com.ibm.im.ims.metadata.psb.PosType;
import com.ibm.im.ims.metadata.psb.ProcseqdType;
import com.ibm.im.ims.metadata.psb.PseloptType;
import com.ibm.im.ims.metadata.psb.SbType;
import com.ibm.im.ims.metadata.psb.ViewType;
import com.ibm.im.ims.metadata.psb.YesnoType;
import com.ibm.im.ims.workbench.model.BooleanBean;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import java.util.ArrayList;

public class PcbDBModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected PcbDBType jaxbDBPcb;
    private SensegModel rootSenseg;
    private DbdModel dbdModel;
    int pcbNum = -1;
    private String origLabel;
    private String origPcbName;

    public PcbDBModel() {
        this.jaxbDBPcb = new PcbDBType();
        String timestamp = this.jaxbDBPcb.getTimestamp();
        if (timestamp == null || timestamp.isEmpty()) {
            this.jaxbDBPcb.setTimestamp("0000000000000");
        }
    }

    public PcbDBModel(PcbDBType pcb, BooleanBean atLeastOneDbpcbDidNotHaveName, BooleanBean atLeastOneDbpcbDidNotHaveTimestamp) throws ModelException {
        String timestamp;
        String pcbAlias = pcb.getName();
        if (pcbAlias == null || pcbAlias.isEmpty()) {
            String pcbName;
            if (atLeastOneDbpcbDidNotHaveName != null) {
                atLeastOneDbpcbDidNotHaveName.myBool = true;
            }
            if ((pcbName = pcb.getPcbName()) == null || pcbName.isEmpty()) {
                pcbName = pcb.getLabel();
            }
            pcbAlias = pcbName;
            pcb.setName(pcbAlias);
        }
        if ((timestamp = pcb.getTimestamp()) == null || timestamp.isEmpty()) {
            pcb.setTimestamp("0000000000000");
            if (atLeastOneDbpcbDidNotHaveTimestamp != null) {
                atLeastOneDbpcbDidNotHaveTimestamp.myBool = true;
            }
        }
        this.jaxbDBPcb = pcb;
        this.rootSenseg = new SensegModel(pcb.getSenseg().get(0), null);
    }

    public String getTimestamp() {
        return this.jaxbDBPcb.getTimestamp();
    }

    public void setTimestamp(String timestamp) {
        this.jaxbDBPcb.setTimestamp(timestamp);
    }

    public void setDbdModel(DbdModel dbdModel) {
        this.dbdModel = dbdModel;
        this.updateSensegsWithSegmentModels(this.rootSenseg);
    }

    private void updateSensegsWithSegmentModels(SensegModel currSenseg) {
        currSenseg.setSegmentModel(this.dbdModel.getSegment(currSenseg.getName()));
        ArrayList<SensegModel> children = currSenseg.getChildren();
        int i = 0;
        while (i < children.size()) {
            SensegModel currChild = children.get(i);
            this.updateSensegsWithSegmentModels(currChild);
            ++i;
        }
    }

    public String getPcbName() {
        return this.jaxbDBPcb.getPcbName();
    }

    public String getPcbAlias() {
        return this.jaxbDBPcb.getName();
    }

    public String getLabel() {
        return this.jaxbDBPcb.getLabel();
    }

    public String getPcbNameOrLabel() {
        String retVal = null;
        retVal = this.jaxbDBPcb.getPcbName();
        if (!(retVal != null && retVal.trim().length() != 0 || (retVal = this.jaxbDBPcb.getLabel()) != null && retVal.trim().length() != 0)) {
            retVal = null;
        }
        return retVal;
    }

    public void setPcbName(String value) {
        this.jaxbDBPcb.setPcbName(value);
        if (value != null) {
            this.jaxbDBPcb.setLabel(null);
        }
    }

    public void setPcbAlias(String value) {
        this.jaxbDBPcb.setName(value);
    }

    public void setLabel(String value) {
        this.jaxbDBPcb.setLabel(value);
        if (value != null) {
            this.jaxbDBPcb.setPcbName(null);
        }
    }

    public String getDbdName() {
        return this.jaxbDBPcb.getDbdName();
    }

    public void setDbd(String value) {
        this.jaxbDBPcb.setDbdName(value);
    }

    public Integer getDbdVersion() {
        return this.jaxbDBPcb.getDbdUserVersion();
    }

    public void setDbdVersion(Integer value) {
        this.jaxbDBPcb.setDbdUserVersion(value);
    }

    public DBDConstants getList() {
        return DBDConstants.valueOf(this.jaxbDBPcb.getList().toString());
    }

    public void setList(DBDConstants value) {
        this.jaxbDBPcb.setList(YesnoType.valueOf(value.toString()));
    }

    public SensegModel getRootSenseg() {
        return this.rootSenseg;
    }

    public SensegModel getSensegModel(String sensegName) {
        return this.getSensegModel(sensegName, this.rootSenseg);
    }

    private SensegModel getSensegModel(String sensegName, SensegModel currSenseg) {
        if (sensegName.equalsIgnoreCase(currSenseg.getName())) {
            return currSenseg;
        }
        ArrayList<SensegModel> childSensegs = currSenseg.getChildren();
        int i = 0;
        while (i < childSensegs.size()) {
            SensegModel child = (SensegModel)childSensegs.get(i);
            SensegModel retVal = this.getSensegModel(sensegName, child);
            if (retVal != null) {
                return retVal;
            }
            ++i;
        }
        return null;
    }

    public void removeRootSenseg() {
        this.rootSenseg = null;
        this.jaxbDBPcb.getSenseg().remove(0);
    }

    public ArrayList<SensegModel> getSenseg() {
        return this.rootSenseg.getChildren();
    }

    public ArrayList<SensegModel> getFullSensegList() {
        ArrayList<SensegModel> retVal = new ArrayList<SensegModel>();
        retVal.add(this.rootSenseg);
        this.addChildSensegsToList(this.rootSenseg.getChildren(), retVal);
        return retVal;
    }

    private void addChildSensegsToList(ArrayList<SensegModel> children, ArrayList<SensegModel> list) {
        int i = 0;
        while (i < children.size()) {
            SensegModel currSenseg = children.get(i);
            list.add(currSenseg);
            this.addChildSensegsToList(currSenseg.getChildren(), list);
            ++i;
        }
    }

    public void setRootSenseg(SensegModel value) {
        this.rootSenseg = value;
        this.jaxbDBPcb.getSenseg().add(value.getJaxbSenseg());
    }

    public int getKeyLength() {
        return this.jaxbDBPcb.getKeyLength();
    }

    public void setKeyLength(int value) {
        this.jaxbDBPcb.setKeyLength(value);
    }

    public DBDConstants getPos() {
        if (this.jaxbDBPcb.getPos() == null) {
            return null;
        }
        return DBDConstants.valueOf(this.jaxbDBPcb.getPos().toString());
    }

    public void setPos(DBDConstants value) {
        this.jaxbDBPcb.setPos(PosType.valueOf(value.toString()));
    }

    public DBDConstants getView() {
        ViewType view = this.jaxbDBPcb.getView();
        if (view == null) {
            return null;
        }
        return DBDConstants.valueOf(view.toString());
    }

    public void setView(DBDConstants value) {
        if (value != null) {
            this.jaxbDBPcb.setView(ViewType.valueOf(value.toString()));
        } else {
            this.jaxbDBPcb.setView(null);
        }
    }

    public String toString() {
        return "DbPCB Name: " + this.getPcbName() + " Label: " + this.getLabel() + " Alias: " + this.getPcbAlias();
    }

    public String getProcSequence() {
        return this.jaxbDBPcb.getProcSequence();
    }

    public void setProcSequence(String value) {
        this.jaxbDBPcb.setProcSequence(value);
    }

    public String getProcopt() {
        return this.jaxbDBPcb.getProcopt();
    }

    public void setCopies(int value) {
        this.jaxbDBPcb.setCopies(value);
    }

    public void setProcopt(String value) {
        this.jaxbDBPcb.setProcopt(value);
    }

    public int getCopies() {
        return this.jaxbDBPcb.getCopies();
    }

    public DBDConstants getSb() {
        return DBDConstants.valueOf(this.jaxbDBPcb.getSb().toString());
    }

    public void setSb(DBDConstants value) {
        this.jaxbDBPcb.setSb(SbType.valueOf(value.toString()));
    }

    public int getPcbNum() {
        return this.pcbNum;
    }

    public void setPcbNum(int pcbNum) {
        this.pcbNum = pcbNum;
    }

    public void setRemarks(String remarks) {
        this.jaxbDBPcb.setRemarks(remarks);
    }

    public String getRemarks() {
        return this.jaxbDBPcb.getRemarks();
    }

    public void setName(String name) {
        this.jaxbDBPcb.setName(name);
    }

    public String getExternalName() {
        return this.jaxbDBPcb.getName();
    }

    public Integer getDbdUserVersion() {
        return this.jaxbDBPcb.getDbdUserVersion();
    }

    public void setDbdUserVersion(Integer dbdUserVersion) {
        this.jaxbDBPcb.setDbdUserVersion(dbdUserVersion);
    }

    public void setProcSequenceD(String value) {
        ProcseqdType procseqdType = new ProcseqdType();
        procseqdType.setIndexDbdName(value);
        this.jaxbDBPcb.setProcseqd(procseqdType);
    }

    public String getProcSequenceD() {
        ProcseqdType procseqd = this.jaxbDBPcb.getProcseqd();
        if (procseqd != null) {
            return procseqd.getIndexDbdName();
        }
        return null;
    }

    public void setPselOpt(PseloptType value) {
        ProcseqdType procseqd = this.jaxbDBPcb.getProcseqd();
        if (procseqd != null) {
            procseqd.setPselopt(PseloptType.valueOf(value.toString()));
        }
    }

    public String getPselOpt() {
        ProcseqdType procseqd = this.jaxbDBPcb.getProcseqd();
        if (procseqd != null) {
            PseloptType pselopt = procseqd.getPselopt();
            if (pselopt != null) {
                return pselopt.name();
            }
            return null;
        }
        return null;
    }

    public void setAccess(AccessFPIndexType value) {
        this.jaxbDBPcb.setAccessFPIndex(AccessFPIndexType.valueOf(value.toString()));
    }

    public String getAccess() {
        if (this.jaxbDBPcb.getAccessFPIndex() != null) {
            return this.jaxbDBPcb.getAccessFPIndex().name();
        }
        return null;
    }

    public static String createName(String pcbNameOrLabel, int pcbNum) {
        Object name = pcbNameOrLabel;
        if (name == null) {
            name = "(PCB#" + pcbNum + ")";
        }
        return name;
    }

    public String getOrigLabel() {
        return this.origLabel;
    }

    public void setOrigLabel(String origLabel) {
        this.origLabel = origLabel;
    }

    public String getOrigPcbName() {
        return this.origPcbName;
    }

    public void setOrigPcbName(String origPcbName) {
        this.origPcbName = origPcbName;
    }
}

