/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.DiffType;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MergeDbdDiff;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

public class MergeDbd {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private DbdModel left;
    private DbdModel right;
    private Vector<MergeDbdDiff> diffs;

    public MergeDbd(DbdModel left, DbdModel right) {
        this.left = left;
        this.right = right;
        this.diffs = new Vector();
    }

    public void compare() throws ModelException {
        SegmentModel leftRoot = this.left.getRootSegment();
        SegmentModel rightRoot = this.right.getRootSegment();
        if (leftRoot != null && rightRoot != null) {
            DBDConstants leftDbdAccessType = leftRoot.getDbdModel().getAccessType();
            DBDConstants rightDbdAccessType = rightRoot.getDbdModel().getAccessType();
            String leftName = "";
            String rightName = "";
            leftName = leftDbdAccessType == DBDConstants.GSAM ? leftRoot.getName() : leftRoot.getImsName();
            if (!leftName.equals(rightName = rightDbdAccessType == DBDConstants.GSAM ? rightRoot.getName() : rightRoot.getImsName())) {
                Object[] inserts = new Object[]{this.left.getDBDName()};
                throw new ModelException(WorkbenchModelBundle.getError().getString("DIALOG002", inserts));
            }
            this.handleSegments(leftRoot);
        }
        if (logger.isLoggable(Level.FINEST)) {
            this.traceDiffs();
        }
    }

    public void moveAllDiffsRight() throws ModelException {
        int i = 0;
        while (i < this.diffs.size()) {
            MergeDbdDiff currDiff = this.diffs.get(i);
            currDiff.moveRight();
            ++i;
        }
    }

    private void handleSegments(SegmentModel leftSeg) throws ModelException {
        SegmentModel rightSeg = this.getSeg(this.right.getRootSegment(), leftSeg.getImsName());
        if (rightSeg != null) {
            this.handleSegment(leftSeg, rightSeg);
        }
        List<SegmentModel> childSegs = leftSeg.getChildSegments();
        int i = 0;
        while (i < childSegs.size()) {
            this.handleSegments(childSegs.get(i));
            ++i;
        }
    }

    private void handleSegment(SegmentModel leftSeg, SegmentModel rightSeg) throws ModelException {
        Vector<FieldModel> fields = leftSeg.getFieldList(true, false);
        int i = 0;
        while (i < fields.size()) {
            FieldModel leftField = (FieldModel)fields.get(i);
            FieldModel rightField = this.getField(rightSeg, leftField.getImsNameOrAlias());
            if (rightField != null) {
                newDiff = new MergeDbdDiff();
                newDiff.diffType = DiffType.FIELD_DIFFERENCE;
                newDiff.leftSeg = leftSeg;
                newDiff.rightSeg = rightSeg;
                newDiff.leftField = leftField;
                newDiff.rightField = rightField;
                this.diffs.add(newDiff);
            } else {
                newDiff = new MergeDbdDiff();
                newDiff.diffType = DiffType.FIELD_MISSING_FROM_RIGHT;
                newDiff.leftSeg = leftSeg;
                newDiff.rightSeg = rightSeg;
                newDiff.leftField = leftField;
                this.diffs.add(newDiff);
            }
            ++i;
        }
    }

    private SegmentModel getSeg(SegmentModel currSeg, String segName) {
        if (currSeg == null || segName == null) {
            return null;
        }
        if (currSeg.getImsName() != null && currSeg.getImsName().equals(segName)) {
            return currSeg;
        }
        List<SegmentModel> childSegs = currSeg.getChildSegments();
        int i = 0;
        while (i < childSegs.size()) {
            SegmentModel retVal = this.getSeg(childSegs.get(i), segName);
            if (retVal != null) {
                return retVal;
            }
            ++i;
        }
        return null;
    }

    private FieldModel getField(SegmentModel seg, String fieldName) throws ModelException {
        Vector<FieldModel> fields = seg.getFieldList(true, false);
        int i = 0;
        while (i < fields.size()) {
            FieldModel currField = (FieldModel)fields.get(i);
            if (currField.getImsNameOrAlias().equals(fieldName)) {
                return currField;
            }
            ++i;
        }
        return null;
    }

    public Vector<MergeDbdDiff> getDiffs() {
        return this.diffs;
    }

    private void traceDiffs() {
        int i = 0;
        while (i < this.diffs.size()) {
            MergeDbdDiff currDiff = this.diffs.get(i);
            logger.finest("MergeDbdDiff[" + i + "]: " + String.valueOf(currDiff));
            ++i;
        }
    }
}

