/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.dbd.MappingCaseType;
import com.ibm.im.ims.metadata.dbd.MappingType;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class MappingModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MappingType mapping;
    private LinkedHashMap<String, MappingCaseModel> allMappingCases;

    public MappingModel() {
        this.mapping = new MappingType();
        this.buildMappingCaseList();
    }

    public MappingModel(MappingType mapping) {
        this.mapping = mapping;
        this.buildMappingCaseList();
    }

    public MappingModel(MappingModel fromMappingModel) {
        this.mapping = SegmentModel.cloneMappingType(fromMappingModel.getMappingType());
        this.buildMappingCaseList();
    }

    public String getRemarks() {
        String retVal = this.mapping.getRemarks();
        if (retVal == null) {
            retVal = "";
            this.mapping.setRemarks(retVal);
        }
        return retVal;
    }

    public void setRemarks(String value) {
        this.mapping.setRemarks(value);
    }

    public String getControlSegmentName() {
        return this.mapping.getControlSegmentName();
    }

    public String getDependingOnField() {
        return this.mapping.getDependingOnField();
    }

    public void setControlSegmentName(String value) {
        this.mapping.setControlSegmentName(value);
    }

    public void setDependingOnField(String value) {
        this.mapping.setDependingOnField(value);
    }

    public String getName() {
        return this.mapping.getName();
    }

    public void setName(String value) {
        this.mapping.setName(value);
    }

    public MappingCaseModel getMappingCaseModel(String caseName) {
        return this.allMappingCases.get(caseName);
    }

    public Iterator<MappingCaseModel> getMappingCases() {
        return this.allMappingCases.values().iterator();
    }

    private void buildMappingCaseList() {
        this.allMappingCases = new LinkedHashMap();
        for (MappingCaseType mct : this.mapping.getCase()) {
            MappingCaseModel mcm = new MappingCaseModel(mct);
            this.allMappingCases.put(mcm.getName(), mcm);
        }
    }

    public void replaceOrigCaseWithClone(MappingCaseModel origCaseModel, MappingCaseModel clonedCaseModel) {
        List<MappingCaseType> caseList = this.mapping.getCase();
        for (MappingCaseType currCaseType : caseList) {
            if (!currCaseType.getName().equals(origCaseModel.getName())) continue;
            caseList.remove(currCaseType);
            caseList.add(clonedCaseModel.getMappingCaseType());
            break;
        }
        this.allMappingCases.remove(origCaseModel.getName());
        this.allMappingCases.put(clonedCaseModel.getName(), clonedCaseModel);
    }

    public void addNewCaseModel(MappingCaseModel newCaseModel) {
        this.mapping.getCase().add(newCaseModel.getMappingCaseType());
        this.allMappingCases.put(newCaseModel.getName(), newCaseModel);
    }

    public MappingType getMappingType() {
        return this.mapping;
    }

    public boolean isCaseNameTaken(String caseName) {
        MappingCaseModel caseModel = this.allMappingCases.get(caseName);
        if (caseModel == null) {
            return false;
        }
        return caseName.equals(caseModel.getName());
    }

    public void removeCase(String caseName) {
        List<MappingCaseType> caseList = this.mapping.getCase();
        for (MappingCaseType currCase : caseList) {
            if (!currCase.getName().equals(caseName)) continue;
            caseList.remove(currCase);
            break;
        }
        this.allMappingCases.remove(caseName);
    }

    public List<MappingCaseModel> getMapCaseList() {
        ArrayList<MappingCaseModel> mapcases = new ArrayList<MappingCaseModel>();
        int size = this.allMappingCases.size();
        Iterator<MappingCaseModel> tempIterator = this.allMappingCases.values().iterator();
        int i = 0;
        while (i < size) {
            mapcases.add(tempIterator.next());
            ++i;
        }
        return mapcases;
    }
}

