/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.dbd.DependingOnFieldValueType;
import com.ibm.im.ims.metadata.dbd.FieldType;
import com.ibm.im.ims.metadata.dbd.MappingCaseType;
import com.ibm.im.ims.metadata.dbd.ValueDatatypeType;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.FieldModelImpl;
import com.ibm.im.ims.workbench.model.IFieldContainer;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class MappingCaseModel
implements IFieldContainer {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MappingCaseType mappingCase;
    private Vector<FieldModel> fieldList = null;
    private Vector<FieldModel> topLevelFieldList = null;

    public MappingCaseModel(MappingCaseType mappingCase) {
        this.mappingCase = mappingCase;
    }

    public MappingCaseModel() {
        this.mappingCase = new MappingCaseType();
    }

    public MappingCaseModel(MappingCaseModel fromMappingCaseModel) {
        this.mappingCase = SegmentModel.cloneCaseType(fromMappingCaseModel.getMappingCaseType());
    }

    public MappingCaseType getMappingCaseType() {
        return this.mappingCase;
    }

    public DependingOnFieldValueType getDependingOnFieldValue() {
        return this.mappingCase.getDependingOnFieldValue();
    }

    public void setDependingOnFieldValue(String value) {
        DependingOnFieldValueType valueType = this.mappingCase.getDependingOnFieldValue();
        if (valueType == null) {
            valueType = new DependingOnFieldValueType();
            this.mappingCase.setDependingOnFieldValue(valueType);
        }
        valueType.setValue(value);
    }

    public void setDependingOnFieldValueType(DBDConstants valueType) {
        DependingOnFieldValueType jaxbValue = this.mappingCase.getDependingOnFieldValue();
        if (valueType == null) {
            jaxbValue = new DependingOnFieldValueType();
            this.mappingCase.setDependingOnFieldValue(jaxbValue);
        }
        if (DBDConstants.X == valueType) {
            jaxbValue.setValueDatatype(ValueDatatypeType.X);
        } else {
            jaxbValue.setValueDatatype(ValueDatatypeType.C);
        }
    }

    public String getRemarks() {
        String retVal = this.mappingCase.getRemarks();
        if (retVal == null) {
            retVal = "";
            this.mappingCase.setRemarks(retVal);
        }
        return retVal;
    }

    public void setRemarks(String value) {
        this.mappingCase.setRemarks(value);
    }

    public String getName() {
        return this.mappingCase.getName();
    }

    public void setName(String value) {
        this.mappingCase.setName(value);
    }

    public Vector<FieldModel> getFieldList(boolean overlayFieldsAdded) throws ModelException {
        if (this.fieldList == null || this.fieldList.isEmpty()) {
            List<FieldType> fieldTypeList = this.mappingCase.getField();
            if (overlayFieldsAdded) {
                SegmentModel.updateFieldStartValues(fieldTypeList, null, false);
            }
            this.fieldList = SegmentModel.buildOrderedFieldList(fieldTypeList, null, null, this);
        }
        return (Vector)this.fieldList.clone();
    }

    public Vector<FieldModel> getTopLevelFieldList() throws ModelException {
        if (this.topLevelFieldList == null || this.topLevelFieldList.isEmpty()) {
            if (this.topLevelFieldList == null) {
                this.topLevelFieldList = new Vector();
            }
            Vector<FieldModel> allFields = this.getFieldList(false);
            int i = 0;
            while (i < allFields.size()) {
                FieldModel currField = allFields.get(i);
                if (currField.getParentField() == null) {
                    this.topLevelFieldList.add(currField);
                }
                ++i;
            }
        }
        return this.topLevelFieldList;
    }

    public void replaceTopLevelMapField(FieldModel origField, FieldModel newField, FieldModel startAfter) {
        this.clearFieldList();
        FieldType origJaxbField = origField.getFieldType();
        FieldType startAfterJaxbField = null;
        if (startAfter != null) {
            startAfterJaxbField = startAfter.getFieldType();
        }
        boolean origFieldFound = false;
        List<FieldType> fieldTypeList = this.mappingCase.getField();
        int i = 0;
        while (i < fieldTypeList.size()) {
            FieldType currObj = fieldTypeList.get(i);
            if (currObj == origJaxbField && startAfterJaxbField == null) {
                fieldTypeList.remove(i);
                fieldTypeList.add(i, newField.getFieldType());
                origFieldFound = true;
                break;
            }
            if (startAfterJaxbField != null && startAfterJaxbField == currObj) {
                fieldTypeList.add(i + 1, newField.getFieldType());
                origFieldFound = true;
                break;
            }
            ++i;
        }
        if (!origFieldFound) {
            fieldTypeList.add(newField.getFieldType());
        }
    }

    public void removeField(FieldModel fieldModel) {
        this.clearFieldList();
        SegmentModel.removeFieldType(this.mappingCase.getField(), fieldModel.getFieldType());
    }

    public void removeAllFields() throws ModelException {
        Vector<FieldModel> topLevelFields = this.getTopLevelFieldList();
        if (topLevelFields != null) {
            Iterator<FieldModel> iter = topLevelFields.iterator();
            List<FieldType> jaxbFields = this.mappingCase.getField();
            while (iter.hasNext()) {
                FieldModel fieldModel = iter.next();
                jaxbFields.remove(fieldModel.getFieldType());
            }
            this.clearFieldList();
        }
    }

    public void clearFieldList() {
        if (this.fieldList != null) {
            this.fieldList.removeAllElements();
        }
        if (this.topLevelFieldList != null) {
            this.topLevelFieldList.removeAllElements();
        }
        this.topLevelFieldList = null;
        this.fieldList = null;
    }

    @Override
    public Vector<FieldModel> getFieldsInRange(FieldModel field, boolean canBeRedefinesField, boolean mustBeIMSField) throws ModelException {
        return null;
    }

    @Override
    public FieldModel getFieldWithAlias(String fieldName, SegmentModel existingSegmentModel) throws ModelException {
        FieldModelImpl retVal = null;
        boolean fieldFound = false;
        FieldType fieldType = null;
        fieldType = SegmentModel.getJaxbFieldWithAlias(this.getTopLevelFieldTypes(), fieldName);
        if (fieldType == null && existingSegmentModel != null && (fieldType = SegmentModel.getJaxbFieldWithAlias(existingSegmentModel.getTopLevelFieldTypes(), fieldName)) == null) {
            List<MappingModel> mappingList = existingSegmentModel.getMapList();
            for (MappingModel currMap : mappingList) {
                Iterator<MappingCaseModel> caseIter = currMap.getMappingCases();
                while (caseIter.hasNext()) {
                    List<FieldType> caseFieldTypes;
                    MappingCaseModel currCase = caseIter.next();
                    if (currCase == this || (fieldType = SegmentModel.getJaxbFieldWithAlias(caseFieldTypes = currCase.getTopLevelFieldTypes(), fieldName)) == null) continue;
                    fieldFound = true;
                    break;
                }
                if (fieldFound) break;
            }
        }
        if (fieldType != null) {
            retVal = new FieldModelImpl(fieldType);
        }
        return retVal;
    }

    List<FieldType> getTopLevelFieldTypes() {
        return this.mappingCase.getField();
    }

    @Override
    public void addField(FieldModel newField) throws ModelException {
        newField.setMappingCaseModel(this);
        this.clearFieldList();
        FieldModel parentField = newField.getParentField();
        if (parentField == null) {
            this.addTopLevelField(newField);
        } else {
            this.addSubField(newField);
        }
    }

    public void addStartAfterField(String startAfterField, FieldModel newField) {
        this.clearFieldList();
        SegmentModel.addStartAfterFieldInList(this.getTopLevelFieldTypes(), startAfterField, newField);
    }

    private void addSubField(FieldModel newField) {
        FieldModel parentField = newField.getParentField();
        List<FieldType> topLevelObjects = this.mappingCase.getField();
        int i = 0;
        while (i < topLevelObjects.size()) {
            if (topLevelObjects.get(i) instanceof FieldType) {
                FieldType currFieldType = topLevelObjects.get(i);
                if (parentField.getName().equals(currFieldType.getName())) {
                    List<FieldType> peerFields = currFieldType.getField();
                    String startAfterField = newField.getStartAfter();
                    if (startAfterField == null || startAfterField.isEmpty()) {
                        newField.setStartAfter("");
                        newField.setStartPos(0);
                        newField.setRelativeStart(0);
                        peerFields.add(newField.getFieldType());
                        break;
                    }
                    SegmentModel.addStartAfterFieldToPeerGroup(peerFields, newField);
                    SegmentModel.resetPeerGroupStartPositions(peerFields);
                    break;
                }
                boolean parentFound = SegmentModel.addSubField(currFieldType.getField(), newField);
                if (parentFound) break;
            }
            ++i;
        }
    }

    private void addTopLevelField(FieldModel newField) {
        List<FieldType> peerFields = this.mappingCase.getField();
        String startAfterField = newField.getStartAfter();
        int startPosInt = newField.getStartPos();
        if (startAfterField == null || startAfterField.isEmpty()) {
            if (startPosInt == 0) {
                newField.setStartPos(1);
            }
            newField.setStartAfter("");
            newField.setRelativeStart(0);
            peerFields.add(newField.getFieldType());
        } else {
            SegmentModel.addStartAfterFieldToPeerGroup(peerFields, newField);
        }
    }

    @Override
    public Vector<FieldModel> getFieldList(boolean ensureSeqFieldFirst, boolean overlayFieldsAdded) throws ModelException {
        return this.getFieldList(overlayFieldsAdded);
    }

    @Override
    public void addFieldWithIntactSubtree(FieldModel newField) throws ModelException {
        newField.setMappingCaseModel(this);
        this.clearFieldList();
        List<FieldType> peerFields = this.mappingCase.getField();
        peerFields.add(newField.getFieldType());
    }
}

