/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.dbd.DedbSecondIxDbdNamesType;
import com.ibm.im.ims.metadata.dbd.FieldListType;
import com.ibm.im.ims.metadata.dbd.LchildPointerType;
import com.ibm.im.ims.metadata.dbd.LfhRulesType;
import com.ibm.im.ims.metadata.dbd.LogicalChildType;
import com.ibm.im.ims.metadata.dbd.PseloptType;
import com.ibm.im.ims.metadata.dbd.XdfldType;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.model.DBDConstants;
import java.util.List;

public class LogicalChildModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected LogicalChildType logicalChild;
    protected XdfldType xdfld;

    public LogicalChildModel() {
        this.logicalChild = new LogicalChildType();
    }

    public LogicalChildModel(LogicalChildType logicalChild) {
        this.logicalChild = logicalChild;
        this.xdfld = logicalChild.getXdfld();
    }

    public XdfldType getXdfld() {
        return this.xdfld;
    }

    public void createXdfld() {
        XdfldType xfld = new XdfldType();
        this.logicalChild.setXdfld(xfld);
    }

    public List<String> getSearch() {
        if (this.logicalChild.getXdfld() != null) {
            return this.logicalChild.getXdfld().getSearch().getField();
        }
        return null;
    }

    public void addSearchField(String value) {
        XdfldType xfld = this.logicalChild.getXdfld();
        FieldListType search = xfld.getSearch();
        if (search == null) {
            search = new FieldListType();
            xfld.setSearch(search);
        }
        search.getField().add(value);
    }

    public void clearSearchFields() {
        XdfldType xfld = this.logicalChild.getXdfld();
        xfld.setSearch(new FieldListType());
    }

    public String getXdfldName() {
        XdfldType xdfld = this.logicalChild.getXdfld();
        if (xdfld == null) {
            return null;
        }
        return xdfld.getName();
    }

    public void setXdfldName(String value) {
        this.logicalChild.getXdfld().setName(value);
    }

    public String getXdfldImsName() {
        XdfldType xdfld = this.logicalChild.getXdfld();
        if (xdfld == null) {
            return null;
        }
        return xdfld.getImsName();
    }

    public void setXdfldImsName(String value) {
        this.logicalChild.getXdfld().setImsName(value);
    }

    public List<String> getSubsequence() {
        FieldListType subseq;
        List<String> retVal = null;
        XdfldType xdfld = this.logicalChild.getXdfld();
        if (xdfld != null && (subseq = xdfld.getSubsequence()) != null) {
            retVal = subseq.getField();
        }
        return retVal;
    }

    public void addSubsequenceField(String value) {
        XdfldType xfld = this.logicalChild.getXdfld();
        FieldListType subsequence = xfld.getSubsequence();
        if (subsequence == null) {
            subsequence = new FieldListType();
            xfld.setSubsequence(subsequence);
        }
        this.logicalChild.getXdfld().getSubsequence().getField().add(value);
    }

    public void clearSubsequenceFields() {
        XdfldType xfld = this.logicalChild.getXdfld();
        xfld.setSubsequence(new FieldListType());
    }

    public List<String> getDuplicateData() {
        FieldListType dupdata;
        List<String> retVal = null;
        XdfldType xfld = this.logicalChild.getXdfld();
        if (xfld != null && (dupdata = xfld.getDuplicateData()) != null) {
            retVal = dupdata.getField();
        }
        return retVal;
    }

    public void addDuplicateDataField(String duplicateData) {
        XdfldType xfld = this.logicalChild.getXdfld();
        FieldListType dupdata = xfld.getDuplicateData();
        if (dupdata == null) {
            dupdata = new FieldListType();
            xfld.setDuplicateData(dupdata);
        }
        this.logicalChild.getXdfld().getDuplicateData().getField().add(duplicateData);
    }

    public void clearDuplicateDataFields() {
        XdfldType xfld = this.logicalChild.getXdfld();
        xfld.setDuplicateData(new FieldListType());
    }

    public String getXfldImsName() {
        return this.logicalChild.getXdfld().getImsName();
    }

    public void setXfldImsName(String value) {
        this.logicalChild.getXdfld().setImsName(value);
    }

    public String getXfldSourceSegment() {
        return this.logicalChild.getXdfld().getSourceSegment();
    }

    public void setXfldSourceSegment(String value) {
        this.logicalChild.getXdfld().setSourceSegment(value);
    }

    public String getXfldConst() {
        return this.logicalChild.getXdfld().getConst();
    }

    public void setXfldConst(String value) {
        this.logicalChild.getXdfld().setConst(value);
    }

    public String getXfldIndexExitRoutine() {
        return this.logicalChild.getXdfld().getIndexExitRoutine();
    }

    public void setXfldIndexExitRoutine(String value) {
        this.logicalChild.getXdfld().setIndexExitRoutine(value);
    }

    public String getXfldNullval() {
        return this.logicalChild.getXdfld().getNullValue();
    }

    public void setXfldNullval(String value) {
        this.logicalChild.getXdfld().setNullValue(value);
    }

    public void setIndex(String value) {
        this.logicalChild.setIndex(value);
    }

    public List<String> getDedbSecondIxDbdNames() {
        DedbSecondIxDbdNamesType dedb2ndIxDbNames = this.logicalChild.getDedbSecondIxDbdNames();
        if (dedb2ndIxDbNames != null) {
            return dedb2ndIxDbNames.getSecondIxDbdName();
        }
        return null;
    }

    public String getName() {
        return this.logicalChild.getName();
    }

    public void setName(String value) {
        this.logicalChild.setName(value);
    }

    public String getDbd() {
        return this.logicalChild.getDbd();
    }

    public void setDbd(String value) {
        this.logicalChild.setDbd(value);
    }

    public DBDConstants getPointer() {
        if (this.logicalChild.getPointer() == null) {
            return null;
        }
        return DBDConstants.valueOf(this.logicalChild.getPointer().toString());
    }

    public void setPointer(DBDConstants value) {
        this.logicalChild.setPointer(LchildPointerType.valueOf(value.toString()));
    }

    public String getPair() {
        return this.logicalChild.getPair();
    }

    public void setPair(String value) {
        this.logicalChild.setPair(value);
    }

    public DBDConstants getRules() {
        if (this.logicalChild.getRules() == null) {
            return null;
        }
        return DBDConstants.valueOf(this.logicalChild.getRules().toString());
    }

    public void setRules(DBDConstants value) {
        this.logicalChild.setRules(LfhRulesType.valueOf(value.value()));
    }

    public String getIndex() {
        return this.logicalChild.getIndex();
    }

    public Integer getRootKeySize() {
        return this.logicalChild.getRootKeySize();
    }

    public void setRootKeySize(Integer value) {
        this.logicalChild.setRootKeySize(value);
    }

    public boolean hasXdfld() {
        return this.logicalChild.getXdfld() != null;
    }

    public void setPselrtn(String pselRtn) {
        this.logicalChild.getXdfld().setPselrtn(pselRtn);
    }

    public String getPselrtn() {
        return this.logicalChild.getXdfld().getPselrtn();
    }

    public void setPselopt(String pselOpt) {
        if (pselOpt.equals("SNGL")) {
            this.logicalChild.getXdfld().setPselopt(PseloptType.S);
        } else {
            this.logicalChild.getXdfld().setPselopt(PseloptType.M);
        }
    }

    public String getPselopt() {
        String retVal = null;
        String pselRtn = this.getPselrtn();
        if (pselRtn != null && !pselRtn.isEmpty()) {
            retVal = this.logicalChild.getXdfld().getPselopt().value();
        }
        return retVal;
    }

    public void setXdfldRemarks(String remarks) {
        this.logicalChild.getXdfld().setRemarks(remarks);
    }

    public String getXdfldRemarks() {
        return this.logicalChild.getXdfld().getRemarks();
    }

    public void setLchildRemarks(String remarks) {
        this.logicalChild.setRemarks(remarks);
    }

    public String getLchildRemarks() {
        return this.logicalChild.getRemarks();
    }

    public void setMultiSeg(String value) {
        if (value.equals("YES")) {
            this.logicalChild.setMultiseg(YesnoType.Y);
        } else {
            this.logicalChild.setMultiseg(YesnoType.N);
        }
    }

    public String getMultiSeg() {
        if (this.logicalChild.getMultiseg() == null) {
            return null;
        }
        return this.logicalChild.getMultiseg().name();
    }

    public void setDedbSecondIxDbdNames(List<String> namesList) {
        DedbSecondIxDbdNamesType dedbSecondIxDbdNamesType = new DedbSecondIxDbdNamesType();
        dedbSecondIxDbdNamesType.getSecondIxDbdName().addAll(namesList);
        this.logicalChild.setDedbSecondIxDbdNames(dedbSecondIxDbdNamesType);
    }
}

