/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.dbd.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.dbd.DatatypeType;
import com.ibm.im.ims.metadata.dbd.FieldType;
import com.ibm.im.ims.metadata.dbd.ImsDatatypeType;
import com.ibm.im.ims.metadata.dbd.MarshallerType;
import com.ibm.im.ims.metadata.dbd.PhysicalDatatypeType;
import com.ibm.im.ims.metadata.dbd.PropertyType;
import com.ibm.im.ims.metadata.dbd.SeqTypeType;
import com.ibm.im.ims.metadata.dbd.SysRelFieldType;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class FieldModelImpl
implements FieldModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SegmentModel segmentModel;
    private MappingCaseModel caseModel;
    private FieldModel parentField;
    protected FieldType fieldType;
    private Vector<FieldModel> childFields;
    private boolean isIMSFieldSelected;
    private boolean isStartAfterSelected;
    private boolean isUserSelected;

    public FieldModelImpl(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public FieldModelImpl(FieldModelImpl origField) throws ModelException {
        this.fieldType = SegmentModel.cloneFieldType(origField.getFieldType());
        this.parentField = origField.getParentField();
        this.childFields = origField.getChildFields();
    }

    public FieldModelImpl() {
        this.fieldType = new FieldType();
    }

    @Override
    public String getName() {
        Object retVal = this.fieldType.getName();
        if (retVal == null || retVal != null && ((String)retVal).length() == 0) {
            retVal = this.fieldType.getImsName();
            this.fieldType.setName((String)retVal);
        }
        if (Utility.hasReservedSQLKeywords((String)retVal)) {
            retVal = (String)retVal + "1";
            this.fieldType.setName((String)retVal);
        }
        return retVal;
    }

    @Override
    public String getAlias() {
        return this.fieldType.getName();
    }

    @Override
    public void addField(FieldModel newField) throws ModelException {
        this.fieldType.getField().add(newField.getFieldType());
        if (this.segmentModel != null) {
            this.segmentModel.clearFieldList();
        }
        if (this.caseModel != null) {
            this.caseModel.clearFieldList();
        }
        this.clearFieldList();
    }

    @Override
    public void clearFieldList() {
        if (this.childFields != null) {
            this.childFields.removeAllElements();
        }
        this.childFields = null;
    }

    @Override
    public String getImsNameOrAlias() {
        String retVal = null;
        retVal = this.fieldType.getImsName();
        if (!(retVal != null && retVal.trim().length() != 0 || (retVal = this.fieldType.getName()) != null && retVal.trim().length() != 0)) {
            retVal = null;
        }
        return retVal;
    }

    @Override
    public void setName(String value) {
        this.fieldType.setName(value);
    }

    @Override
    public String getImsName() {
        String retVal = this.fieldType.getImsName();
        if (retVal == null) {
            retVal = "";
            this.fieldType.setImsName(retVal);
        }
        return retVal;
    }

    @Override
    public void setImsName(String value) {
        this.fieldType.setImsName(value);
    }

    @Override
    public int getBytes() {
        Integer bytes = this.fieldType.getBytes();
        if (bytes == null) {
            bytes = 0;
            this.fieldType.setBytes(bytes);
        }
        return bytes;
    }

    @Override
    public int getMaxBytes() {
        Integer maxBytes = this.fieldType.getMaxBytes();
        if (maxBytes == null) {
            maxBytes = 0;
            this.fieldType.setMaxBytes(maxBytes);
        }
        return maxBytes;
    }

    @Override
    public void setBytes(int value) {
        this.fieldType.setBytes(value);
        if (this.segmentModel != null) {
            this.segmentModel.clearFieldList();
        }
        if (this.caseModel != null) {
            this.caseModel.clearFieldList();
        }
    }

    @Override
    public int getStartPos() {
        int retVal = 0;
        Integer startPos = this.fieldType.getStartPos();
        if (startPos != null) {
            retVal = startPos;
        }
        return retVal;
    }

    @Override
    public int getStartOrRelstart() throws ModelException {
        int retVal = this.getStartPos();
        if (retVal == 0 && (retVal = this.getRelativeStart()) == 0 && !SegmentModel.isXMLField(this.fieldType)) {
            Object[] inserts = new Object[]{this.toString()};
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1611", inserts));
        }
        return retVal;
    }

    @Override
    public void setStartPos(int value) {
        this.fieldType.setStartPos(value);
        if (this.segmentModel != null) {
            this.segmentModel.clearFieldList();
        }
        if (this.caseModel != null) {
            this.caseModel.clearFieldList();
        }
    }

    @Override
    public DBDConstants getSeqType() {
        if (this.fieldType.getSeqType() == null) {
            return null;
        }
        return DBDConstants.valueOf(this.fieldType.getSeqType().toString());
    }

    @Override
    public boolean isSeq() {
        return this.getSeqType() != null;
    }

    @Override
    public void setSeqType(DBDConstants value) {
        if (value == null) {
            this.fieldType.setSeqType(null);
        } else {
            this.fieldType.setSeqType(SeqTypeType.valueOf(value.toString()));
        }
    }

    @Override
    public DBDConstants getImsDatatype() {
        if (this.fieldType.getImsDatatype() == null) {
            return null;
        }
        return DBDConstants.valueOf(this.fieldType.getImsDatatype().toString());
    }

    @Override
    public void setImsDatatype(DBDConstants value) {
        if (value == null) {
            this.fieldType.setImsDatatype(null);
        } else {
            this.fieldType.setImsDatatype(ImsDatatypeType.valueOf(value.toString()));
        }
    }

    @Override
    public void setEncoding(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        marshaller.setEncoding(value);
    }

    @Override
    public void setPhysicalDataType(DBDConstants value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        if (value == DBDConstants.USER) {
            marshaller.setTypeConverter(null);
        } else if (value != null) {
            marshaller.setTypeConverter(PhysicalDatatypeType.fromValue(value.toString()));
        } else {
            marshaller.setTypeConverter(null);
        }
    }

    @Override
    public DBDConstants getPhysicalDataType() {
        PhysicalDatatypeType physDatatype;
        DBDConstants retVal = null;
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null && (physDatatype = marshaller.getTypeConverter()) != null) {
            retVal = DBDConstants.fromValue(physDatatype.toString());
        }
        return retVal;
    }

    @Override
    public String getEncoding() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            return marshaller.getEncoding();
        }
        return null;
    }

    @Override
    public String getUrl() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            return marshaller.getUrl();
        }
        return null;
    }

    @Override
    public void setUrl(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        marshaller.setUrl(value);
    }

    @Override
    public String getOverflow() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            return marshaller.getOverflow();
        }
        return null;
    }

    @Override
    public void setOverflow(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        marshaller.setOverflow(value);
    }

    @Override
    public String getPattern() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            return marshaller.getPattern();
        }
        return null;
    }

    @Override
    public String getDecimalPattern() {
        logger.entering(this.getClass().getName(), "getDecimalPattern()", new Object[]{"field name: " + this.getImsName()});
        Object retVal = null;
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            return null;
        }
        PhysicalDatatypeType physDataType = marshaller.getTypeConverter();
        if (physDataType != PhysicalDatatypeType.PACKEDDECIMAL && physDataType != PhysicalDatatypeType.ZONEDDECIMAL && physDataType != PhysicalDatatypeType.BINARY) {
            return null;
        }
        retVal = marshaller.getIsSigned() == YesnoType.Y ? "S" : "";
        Integer precision = adt.getPrecision();
        Integer scale = adt.getScale();
        if (precision == null || scale == null) {
            return null;
        }
        int numDigitsBeforeDecimal = precision - scale;
        int i = 0;
        while (i < numDigitsBeforeDecimal) {
            retVal = (String)retVal + "9";
            ++i;
        }
        retVal = (String)retVal + "V";
        i = 0;
        while (i < scale) {
            retVal = (String)retVal + "9";
            ++i;
        }
        logger.exiting(this.getClass().getName(), "getDecimalPattern()", new Object[]{retVal});
        return retVal;
    }

    @Override
    public void setPattern(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        marshaller.setPattern(value);
    }

    @Override
    public void setPrecision(String value) {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        if (value == null) {
            adt.setPrecision(null);
        } else {
            adt.setPrecision(Integer.valueOf(value));
        }
    }

    @Override
    public Integer getPrecision() {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        return adt.getPrecision();
    }

    @Override
    public Integer getScale() {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        return adt.getScale();
    }

    @Override
    public void setScale(String value) {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        if (value == null) {
            adt.setScale(null);
        } else {
            adt.setScale(Integer.valueOf(value));
        }
    }

    @Override
    public void setIsSigned(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setIsSigned(null);
        } else {
            if (value.equalsIgnoreCase("YES")) {
                value = "Y";
            } else if (value.equalsIgnoreCase("NO")) {
                value = "N";
            }
            marshaller.setIsSigned(YesnoType.fromValue(value));
        }
    }

    @Override
    public void setIsDbcs(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setIsPuredDBCS(null);
        } else {
            value = value.length() >= 1 && value.substring(0, 1).equalsIgnoreCase("Y") ? "Y" : "N";
            marshaller.setIsPuredDBCS(YesnoType.fromValue(value));
        }
    }

    @Override
    public DBDConstants getIsDbcs() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            YesnoType ynType = marshaller.getIsPuredDBCS();
            if (ynType == null) {
                return null;
            }
            return DBDConstants.valueOf(ynType.toString());
        }
        return null;
    }

    @Override
    public void removeMarshallerIfEmpty() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            YesnoType ynType = marshaller.getIsSigned();
            YesnoType ynType1 = marshaller.getIsPuredDBCS();
            String userTypeConverterStr = marshaller.getUserTypeConverter();
            List<PropertyType> properties = marshaller.getProperty();
            String overFlowStr = marshaller.getOverflow();
            String urlStr = marshaller.getUrl();
            String pattern = marshaller.getPattern();
            String charEncoding = marshaller.getEncoding();
            if (!(ynType != null || ynType1 != null || userTypeConverterStr != null && !userTypeConverterStr.isEmpty() || properties != null && !properties.isEmpty() || overFlowStr != null && !overFlowStr.isEmpty() || urlStr != null && !urlStr.isEmpty() || pattern != null && !pattern.isEmpty() || charEncoding != null && !charEncoding.isEmpty())) {
                this.fieldType.setMarshaller(null);
            }
        }
    }

    @Override
    public DBDConstants getIsSigned() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            YesnoType ynType = marshaller.getIsSigned();
            if (ynType == null) {
                return null;
            }
            return DBDConstants.valueOf(ynType.toString());
        }
        return null;
    }

    @Override
    public void setPackeddecimalSubparms(String picString) {
        ApplicationDatatypeType adt;
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        int scale = 0;
        int index = -1;
        String expandedString = this.expandStringAndGetNumDigits(picString);
        index = expandedString.indexOf(86);
        if (index == -1) {
            index = expandedString.indexOf(118);
        }
        if (index != -1) {
            scale = expandedString.length() - index - 1;
        }
        if ((adt = this.fieldType.getApplicationDatatype()) == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        adt.setScale(scale);
    }

    private int determineScale(String picString) {
        int scale = 0;
        int index = -1;
        String expandedString = this.expandStringAndGetNumDigits(picString);
        index = expandedString.indexOf(86);
        if (index == -1) {
            index = expandedString.indexOf(118);
        }
        if (index != -1) {
            scale = expandedString.length() - index - 1;
            return scale;
        }
        return scale;
    }

    private String expandStringAndGetNumDigits(String pictureString) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        StringBuffer expandedString = new StringBuffer();
        int startingIndex = -1;
        int index = 0;
        int expandCount = 0;
        char expandChar = '\u0000';
        if (pictureString.startsWith("S") || pictureString.startsWith("s")) {
            pictureString = pictureString.substring(1);
            marshaller.setIsSigned(YesnoType.Y);
        } else {
            marshaller.setIsSigned(YesnoType.N);
        }
        while ((index = pictureString.indexOf(40, startingIndex)) != -1) {
            expandedString.append(pictureString.substring(startingIndex + 1, index));
            startingIndex = pictureString.indexOf(41, index);
            expandChar = pictureString.charAt(index - 1);
            expandCount = Integer.parseInt(pictureString.substring(index + 1, startingIndex));
            int i = 0;
            while (i < expandCount - 1) {
                expandedString.append(expandChar);
                ++i;
            }
        }
        expandedString.append(pictureString.substring(startingIndex + 1, pictureString.length()));
        int count = 0;
        int length = expandedString.length();
        int i = 0;
        while (i < length) {
            if (String.valueOf(expandedString.charAt(i)).equals("9")) {
                ++count;
            }
            ++i;
        }
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        adt.setPrecision(count);
        return expandedString.toString();
    }

    @Override
    public void setZoneddecimalSubparms(String picString) {
        int scale = this.determineScale(picString);
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        adt.setScale(scale);
    }

    private ArrayList<PropertyType> getPropertyList() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        ArrayList pv = (ArrayList)this.fieldType.getMarshaller().getProperty();
        return pv;
    }

    @Override
    public int getPropertyListSize() {
        ArrayList<PropertyType> pv = this.getPropertyList();
        return pv.size();
    }

    @Override
    public void clearProperties() {
        ArrayList<PropertyType> pv = this.getPropertyList();
        if (!pv.isEmpty()) {
            pv.clear();
        }
    }

    @Override
    public void addNewProperty(String name, String value) {
        ArrayList<PropertyType> pv = this.getPropertyList();
        PropertyType p = new PropertyType();
        p.setName(name);
        p.setValue(value);
        pv.add(p);
    }

    @Override
    public void removeAllProperties() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        ArrayList pv = (ArrayList)this.fieldType.getMarshaller().getProperty();
        pv.clear();
    }

    @Override
    public String getPropertyName(int pos) {
        PropertyType p = null;
        ArrayList<PropertyType> pv = this.getPropertyList();
        if (pv.isEmpty()) {
            return null;
        }
        if (pos < 0 || pos >= pv.size()) {
            return null;
        }
        p = pv.get(pos);
        return p.getName();
    }

    @Override
    public String getPropertyValue(int pos) {
        PropertyType p = null;
        ArrayList<PropertyType> pv = this.getPropertyList();
        if (pv.isEmpty()) {
            return null;
        }
        if (pos < 0 || pos >= pv.size()) {
            return null;
        }
        p = pv.get(pos);
        return p.getValue();
    }

    @Override
    public void setUserTypeConverer(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        this.fieldType.getMarshaller().setUserTypeConverter(value);
    }

    @Override
    public String getUserTypeConverter() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        return marshaller.getUserTypeConverter();
    }

    public String toString() {
        return this.getImsName() + " aka " + this.getName();
    }

    @Override
    public void setAppDatatype(DBDConstants value) {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        adt.setDatatype(DatatypeType.valueOf(value.toString()));
    }

    @Override
    public DBDConstants getAppDatatype() {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        DatatypeType dt = adt.getDatatype();
        if (dt == null) {
            return null;
        }
        return DBDConstants.valueOf(dt.toString());
    }

    @Override
    public void setMarshallerRemarks(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        marshaller.setRemarks(value);
    }

    @Override
    public String getMarshallerRemarks() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
        }
        return marshaller.getRemarks();
    }

    @Override
    public void setRemarks(String remarks) {
        this.fieldType.setRemarks(remarks);
    }

    @Override
    public String getRemarks() {
        String retVal = this.fieldType.getRemarks();
        if (retVal == null) {
            retVal = "";
            this.fieldType.setRemarks(retVal);
        }
        return retVal;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public MarshallerType getMarshaller() {
        return this.fieldType.getMarshaller();
    }

    @Override
    public boolean isIMSField() {
        boolean retVal = true;
        String fieldNameStr = this.fieldType.getImsName();
        if (fieldNameStr == null || fieldNameStr.isEmpty()) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public PhysicalDatatypeType getTypeConverter() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            return marshaller.getTypeConverter();
        }
        return null;
    }

    @Override
    public void setRedefines(String redefines) {
        this.fieldType.setRedefines(redefines);
    }

    @Override
    public String getRedefines() {
        return this.fieldType.getRedefines();
    }

    @Override
    public void setMaxOccurs(Integer maxOccurs) {
        this.fieldType.setMaxOccurs(maxOccurs);
    }

    @Override
    public Integer getMaxOccurs() {
        return this.fieldType.getMaxOccurs();
    }

    @Override
    public void setMinOccurs(Integer minOccurs) {
        this.fieldType.setMinOccurs(minOccurs);
    }

    @Override
    public Integer getMinOccurs() {
        return this.fieldType.getMinOccurs();
    }

    @Override
    public void setDependsOn(String dependsOn) {
        this.fieldType.setDependsOn(dependsOn);
    }

    @Override
    public String getDependsOn() {
        return this.fieldType.getDependsOn();
    }

    @Override
    public void setRelativeStart(int relStart) {
        this.fieldType.setRelativeStart(relStart);
    }

    @Override
    public int getRelativeStart() {
        int retVal = 0;
        Integer relStart = this.fieldType.getRelativeStart();
        if (relStart != null) {
            retVal = relStart;
        }
        return retVal;
    }

    @Override
    public void setStartAfter(String startAfter) {
        this.fieldType.setStartAfter(startAfter);
    }

    @Override
    public String getStartAfter() {
        return this.fieldType.getStartAfter();
    }

    @Override
    public void setMaxBytes(int maxBytes) {
        this.fieldType.setMaxBytes(maxBytes);
    }

    @Override
    public boolean hasSubFields() {
        boolean retVal = false;
        List<FieldType> fields = this.fieldType.getField();
        if (fields != null && !fields.isEmpty()) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public Vector<FieldModel> getFieldList() throws ModelException {
        Vector<FieldModel> retVal = new Vector<FieldModel>();
        List<FieldType> fields = this.fieldType.getField();
        int i = 0;
        while (i < fields.size()) {
            FieldType currFieldType = fields.get(i);
            FieldModelImpl newFieldModel = new FieldModelImpl(currFieldType);
            SegmentModel.addFieldInOrder(retVal, newFieldModel);
            ++i;
        }
        return retVal;
    }

    @Override
    public Vector<FieldModel> getFieldListUnOrdered() throws ModelException {
        Vector<FieldModel> retVal = new Vector<FieldModel>();
        List<FieldType> fields = this.fieldType.getField();
        int i = 0;
        while (i < fields.size()) {
            FieldType currFieldType = fields.get(i);
            FieldModelImpl newFieldModel = new FieldModelImpl(currFieldType);
            retVal.add(newFieldModel);
            ++i;
        }
        return retVal;
    }

    @Override
    public boolean isSysRelField() {
        return false;
    }

    @Override
    public void setSegmentModel(SegmentModel segmentModel) {
        this.segmentModel = segmentModel;
    }

    public MappingCaseModel getMappingCaseModel() {
        return this.caseModel;
    }

    public void setCaseModel(MappingCaseModel caseModel) {
        this.caseModel = caseModel;
    }

    @Override
    public SegmentModel getSegmentModel() {
        return this.segmentModel;
    }

    @Override
    public void setParentField(FieldModel parentField) {
        this.parentField = parentField;
    }

    @Override
    public FieldModel getParentField() {
        return this.parentField;
    }

    @Override
    public Vector<FieldModel> getChildFields() {
        return this.childFields;
    }

    @Override
    public void setChildFields(Vector<FieldModel> childFields) {
        this.childFields = childFields;
    }

    @Override
    public void removeAllSubFields() {
        this.clearFieldList();
        this.fieldType.getField().clear();
    }

    @Override
    public SysRelFieldType getSysRelFieldType() {
        return null;
    }

    @Override
    public void setMappingCaseModel(MappingCaseModel caseModel) {
        this.caseModel = caseModel;
    }

    @Override
    public void setIMSFieldSelected(boolean isIMSField) {
        this.isIMSFieldSelected = isIMSField;
    }

    @Override
    public boolean isIMSFieldSelected() {
        return this.isIMSFieldSelected;
    }

    @Override
    public void setStartAfterSelected(boolean isStartAfter) {
        this.isStartAfterSelected = isStartAfter;
    }

    @Override
    public boolean isStartAfterSelected() {
        return this.isStartAfterSelected;
    }

    @Override
    public void setUserSelected(boolean isUser) {
        this.isUserSelected = isUser;
    }

    @Override
    public boolean isUserSelected() {
        return this.isUserSelected;
    }

    @Override
    public DBDConstants getPhysicalOrAppDataType() {
        DBDConstants retVal = null;
        DBDConstants physDT = this.getPhysicalDataType();
        if (physDT != null) {
            retVal = physDT;
        } else {
            DBDConstants appDT = this.getAppDatatype();
            if (appDT != null) {
                retVal = appDT;
            }
        }
        return retVal;
    }
}

