/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.model;

import com.ibm.im.ims.metadata.dbd.AccessType;
import com.ibm.im.ims.metadata.dbd.AreaType;
import com.ibm.im.ims.metadata.dbd.AreasType;
import com.ibm.im.ims.metadata.dbd.BlockType;
import com.ibm.im.ims.metadata.dbd.DataCaptureExitRoutineType;
import com.ibm.im.ims.metadata.dbd.DbTypeType;
import com.ibm.im.ims.metadata.dbd.Dbd;
import com.ibm.im.ims.metadata.dbd.DedbRMNameType;
import com.ibm.im.ims.metadata.dbd.DedbType;
import com.ibm.im.ims.metadata.dbd.ExitContainerType;
import com.ibm.im.ims.metadata.dbd.GsamBlockType;
import com.ibm.im.ims.metadata.dbd.GsamDataSetType;
import com.ibm.im.ims.metadata.dbd.GsamOSAccessType;
import com.ibm.im.ims.metadata.dbd.GsamSizeType;
import com.ibm.im.ims.metadata.dbd.GsamType;
import com.ibm.im.ims.metadata.dbd.HdamAndHidamBlockType;
import com.ibm.im.ims.metadata.dbd.HdamAndHidamDataSetContainerType;
import com.ibm.im.ims.metadata.dbd.HdamAndHidamDataSetType;
import com.ibm.im.ims.metadata.dbd.HdamAndHidamFrspcType;
import com.ibm.im.ims.metadata.dbd.HdamAndHidamSizeType;
import com.ibm.im.ims.metadata.dbd.HdamAndPhdamRMNameType;
import com.ibm.im.ims.metadata.dbd.HdamType;
import com.ibm.im.ims.metadata.dbd.HidamType;
import com.ibm.im.ims.metadata.dbd.HisamAndShisamAndIndexDataSetType;
import com.ibm.im.ims.metadata.dbd.HisamAndShisamType;
import com.ibm.im.ims.metadata.dbd.HsamAndShsamDataSetType;
import com.ibm.im.ims.metadata.dbd.HsamType;
import com.ibm.im.ims.metadata.dbd.IndexOsAccessType;
import com.ibm.im.ims.metadata.dbd.IndexType;
import com.ibm.im.ims.metadata.dbd.MsdbDataSetType;
import com.ibm.im.ims.metadata.dbd.MsdbType;
import com.ibm.im.ims.metadata.dbd.ObjectFactory;
import com.ibm.im.ims.metadata.dbd.PhdamType;
import com.ibm.im.ims.metadata.dbd.PhidamType;
import com.ibm.im.ims.metadata.dbd.PsindexType;
import com.ibm.im.ims.metadata.dbd.RecfmType;
import com.ibm.im.ims.metadata.dbd.RecordType;
import com.ibm.im.ims.metadata.dbd.RelType;
import com.ibm.im.ims.metadata.dbd.RmNameSubOptions;
import com.ibm.im.ims.metadata.dbd.SecondIxDbdNamesType;
import com.ibm.im.ims.metadata.dbd.SegmentType;
import com.ibm.im.ims.metadata.dbd.ShsamType;
import com.ibm.im.ims.metadata.dbd.SizeType;
import com.ibm.im.ims.metadata.dbd.VoOSAccessType;
import com.ibm.im.ims.metadata.dbd.VsamOSAccessType;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.model.AreaStmt;
import com.ibm.im.ims.workbench.model.BooleanBean;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DataExitRoutine;
import com.ibm.im.ims.workbench.model.HidamDataSetModel;
import com.ibm.im.ims.workbench.model.IImsResourceModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public class DbdModel
implements IImsResourceModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SegmentModel rootSegment;
    private int datasetLabelCount = 1;
    ArrayList<String> existingLabels = new ArrayList();
    ArrayList<String> genedDatasetLabels = new ArrayList();
    private ArrayList<HidamDataSetModel> hdamAndHidamDataSets = null;
    private ArrayList<AreaStmt> areaModels = null;
    private ArrayList<DataExitRoutine> dataCaptureExitRoutines = null;
    private ObjectFactory dbdObjFactory;
    private Dbd dbd = null;
    private JAXBContext dbdContext;
    private Marshaller dbdMarshaller;
    private BooleanBean atLeastOneSegmentDidNotHaveAlias;
    private boolean partiallyParsed = false;

    public DbdModel(InputStream is) throws ModelException {
        try {
            this.dbdContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.dbd", (ClassLoader)Dbd.class.getClassLoader());
            Unmarshaller dbdUnmarshaller = this.dbdContext.createUnmarshaller();
            this.dbd = (Dbd)dbdUnmarshaller.unmarshal(is);
            this.init();
        }
        catch (JAXBException e) {
            ModelException me = new ModelException(e);
            logger.throwing(this.getClass().getName(), "DbdModel(String name)", (Throwable)me);
            throw me;
        }
    }

    public DbdModel(Dbd dbd) throws ModelException {
        this.dbd = dbd;
        this.init();
    }

    private void init() throws ModelException {
        this.atLeastOneSegmentDidNotHaveAlias = new BooleanBean();
        this.atLeastOneSegmentDidNotHaveAlias.myBool = false;
        this.initializeMetadataFactory();
        if (this.dbd.getSegment().size() > 0) {
            this.rootSegment = new SegmentModel(null, this.dbd.getSegment().get(0), this, this.atLeastOneSegmentDidNotHaveAlias);
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        List<HdamAndHidamDataSetType> dataSetList = null;
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            dataSetList = this.dbd.getAccess().getHdam().getDataSetContainer().getDataSet();
        } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
            dataSetList = this.dbd.getAccess().getHidam().getDataSetContainer().getDataSet();
        }
        if (dataSetList != null && !dataSetList.isEmpty()) {
            this.hdamAndHidamDataSets = new ArrayList();
            for (HdamAndHidamDataSetType hdamAndHidamDataSet : dataSetList) {
                String label = hdamAndHidamDataSet.getLabel();
                String dd1name = hdamAndHidamDataSet.getDdname();
                String size0 = null;
                HdamAndHidamBlockType block = hdamAndHidamDataSet.getBlock();
                if (block != null) {
                    size0 = Integer.toString(block.getSize());
                }
                String size1 = null;
                HdamAndHidamSizeType size = hdamAndHidamDataSet.getSize();
                if (size != null) {
                    size1 = Integer.toString(size.getSize());
                }
                String cyls = Integer.toString(hdamAndHidamDataSet.getScan());
                String fbff = null;
                String fspf = null;
                HdamAndHidamFrspcType frspc = hdamAndHidamDataSet.getFrspc();
                if (frspc != null) {
                    Integer fspfInt;
                    Integer fbffInt = frspc.getFbff();
                    if (fbffInt != null) {
                        fbff = Integer.toString(fbffInt);
                    }
                    if ((fspfInt = frspc.getFspf()) != null) {
                        fspf = Integer.toString(fspfInt);
                    }
                }
                String searcha = Integer.toString(hdamAndHidamDataSet.getSearchA());
                String device = hdamAndHidamDataSet.getDevice();
                String remarks = hdamAndHidamDataSet.getRemarks();
                HidamDataSetModel dataSetModel = new HidamDataSetModel(dd1name, size0, size1, cyls, fbff, fspf, searcha, label, device, remarks);
                boolean labelExists = false;
                if (label != null) {
                    int j = 0;
                    while (j < this.existingLabels.size()) {
                        if (label.equals(this.existingLabels.get(j))) {
                            labelExists = true;
                        }
                        ++j;
                    }
                    if (!labelExists) {
                        this.addToExistingLabels(label);
                    }
                } else {
                    String generatedLabel = this.generateDatasetLabel();
                    this.addToExistingLabels(generatedLabel);
                    dataSetModel.setGeneratedLabel(generatedLabel);
                }
                this.hdamAndHidamDataSets.add(dataSetModel);
            }
        }
        if (dbAccType.equalsIgnoreCase("DEDB")) {
            this.areaModels = new ArrayList();
            List<AreaType> areaList = this.dbd.getAccess().getDedb().getAreaContainer().getArea();
            Iterator<AreaType> it = areaList.iterator();
            while (it.hasNext()) {
                AreaStmt areaStmt = new AreaStmt(it.next());
                this.areaModels.add(areaStmt);
            }
        }
        if (dbAccType.equalsIgnoreCase("HISAM") || dbAccType.equalsIgnoreCase("SHISAM") || dbAccType.equalsIgnoreCase("HDAM") || dbAccType.equalsIgnoreCase("HIDAM") || dbAccType.equalsIgnoreCase("PHDAM") || dbAccType.equalsIgnoreCase("PHIDAM") || dbAccType.equalsIgnoreCase("DEDB")) {
            List<DataCaptureExitRoutineType> exitList;
            this.dataCaptureExitRoutines = new ArrayList();
            ExitContainerType exitContainerType = null;
            if (dbAccType.equalsIgnoreCase("HISAM")) {
                exitContainerType = this.dbd.getAccess().getHisam().getExitContainer();
            } else if (dbAccType.equalsIgnoreCase("SHISAM")) {
                exitContainerType = this.dbd.getAccess().getShisam().getExitContainer();
            } else if (dbAccType.equalsIgnoreCase("HDAM")) {
                exitContainerType = this.dbd.getAccess().getHdam().getExitContainer();
            } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
                exitContainerType = this.dbd.getAccess().getHidam().getExitContainer();
            } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
                exitContainerType = this.dbd.getAccess().getPhdam().getExitContainer();
            } else if (dbAccType.equalsIgnoreCase("PHIDAM")) {
                exitContainerType = this.dbd.getAccess().getPhidam().getExitContainer();
            } else if (dbAccType.equalsIgnoreCase("DEDB")) {
                exitContainerType = this.dbd.getAccess().getDedb().getExitContainer();
            }
            if (exitContainerType != null && (exitList = exitContainerType.getDataCaptureExitRoutine()) != null) {
                Iterator<DataCaptureExitRoutineType> it = exitList.iterator();
                while (it.hasNext()) {
                    DataExitRoutine dataExitRoutine = new DataExitRoutine(it.next());
                    this.dataCaptureExitRoutines.add(dataExitRoutine);
                }
            }
        }
    }

    public BooleanBean getAtLeastOneSegmentDidNotHaveAlias() {
        return this.atLeastOneSegmentDidNotHaveAlias;
    }

    public DbdModel(String name) throws ModelException {
        try {
            this.dbdContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.dbd", (ClassLoader)Dbd.class.getClassLoader());
            this.initializeMetadataFactory();
            this.dbd = this.dbdObjFactory.createDbd();
            this.dbd.setDbdName(name);
            this.createDefaultRootSegment(this);
            this.dbd.setXmlSchemaVersion("1");
        }
        catch (JAXBException e) {
            ModelException me = new ModelException(e);
            logger.throwing(this.getClass().getName(), "DbdModel(String name)", (Throwable)me);
            throw me;
        }
    }

    public DbdModel() throws ModelException {
        try {
            this.dbdContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.dbd", (ClassLoader)Dbd.class.getClassLoader());
            this.initializeMetadataFactory();
            this.dbd = this.dbdObjFactory.createDbd();
            this.dbd.setXmlSchemaVersion("1");
        }
        catch (JAXBException e) {
            ModelException me = new ModelException(e);
            logger.throwing(this.getClass().getName(), "DbdModel(String name)", (Throwable)me);
            throw me;
        }
    }

    private void initializeMetadataFactory() {
        if (this.dbdObjFactory == null) {
            this.dbdObjFactory = new ObjectFactory();
        }
    }

    public String getDBDName() {
        return this.dbd.getDbdName();
    }

    public void setDbdName(String name) {
        this.dbd.setDbdName(name);
    }

    public String getTimestamp() {
        return this.dbd.getTimestamp();
    }

    public Integer getUserVersion() {
        return this.dbd.getUserVersion();
    }

    public void setUserVersion(Integer userVersion) {
        this.dbd.setUserVersion(userVersion);
    }

    public void setTimestamp(String version) {
        this.dbd.setTimestamp(version);
    }

    public String getVersion() {
        return this.dbd.getVersion();
    }

    public void setVersion(String version) {
        this.dbd.setVersion(version);
    }

    public DBDConstants getAccessType() {
        if (this.dbd.getAccess() == null) {
            return null;
        }
        if (this.dbd.getAccess().getDbType() == null) {
            return null;
        }
        AccessType accType = this.dbd.getAccess();
        String dbAccType = accType.getDbType().toString();
        YesnoType prot = this.getProt();
        if (dbAccType.equals("SHISAM") && accType.getShisam().getOsAccess() == null && (prot == null || prot == YesnoType.Y)) {
            dbAccType = "INDEX";
        }
        return DBDConstants.valueOf(dbAccType);
    }

    public void setAccessType(String accessType) throws ModelException {
        this.dbd.setAccess(this.dbdObjFactory.createAccessType());
        try {
            this.dbd.getAccess().setDbType(DbTypeType.fromValue(accessType));
            if (accessType.equalsIgnoreCase(DbTypeType.PHIDAM.toString())) {
                PhidamType phidam = this.dbdObjFactory.createPhidamType();
                this.dbd.getAccess().setPhidam(phidam);
            } else if (accessType.equalsIgnoreCase(DbTypeType.DEDB.toString())) {
                DedbType dedb = this.dbdObjFactory.createDedbType();
                this.dbd.getAccess().setDedb(dedb);
                DedbRMNameType rm = this.dbdObjFactory.createDedbRMNameType();
                this.dbd.getAccess().getDedb().setRmName(rm);
                AreasType areas = new AreasType();
                dedb.setAreaContainer(areas);
                this.areaModels = new ArrayList();
            } else if (accessType.equalsIgnoreCase(DbTypeType.HISAM.toString())) {
                HisamAndShisamType hisam = new HisamAndShisamType();
                this.dbd.getAccess().setHisam(hisam);
                HisamAndShisamAndIndexDataSetType ds = new HisamAndShisamAndIndexDataSetType();
                hisam.setDataSet(ds);
            } else if (accessType.equalsIgnoreCase(DbTypeType.HSAM.toString())) {
                HsamType hsam = this.dbdObjFactory.createHsamType();
                this.dbd.getAccess().setHsam(hsam);
                HsamAndShsamDataSetType ds = new HsamAndShsamDataSetType();
                hsam.setDataSet(ds);
            } else if (accessType.equalsIgnoreCase(DbTypeType.SHISAM.toString())) {
                HisamAndShisamType shisam = this.dbdObjFactory.createHisamAndShisamType();
                this.dbd.getAccess().setShisam(shisam);
                HisamAndShisamAndIndexDataSetType ds = new HisamAndShisamAndIndexDataSetType();
                shisam.setDataSet(ds);
            } else if (accessType.equalsIgnoreCase(DbTypeType.SHSAM.toString())) {
                ShsamType shsam = this.dbdObjFactory.createShsamType();
                this.dbd.getAccess().setShsam(shsam);
                HsamAndShsamDataSetType ds = new HsamAndShsamDataSetType();
                shsam.setDataSet(ds);
            } else if (accessType.equalsIgnoreCase(DbTypeType.GSAM.toString())) {
                GsamType gsam = this.dbdObjFactory.createGsamType();
                this.dbd.getAccess().setGsam(gsam);
                GsamDataSetType ds = new GsamDataSetType();
                gsam.setDataSet(ds);
            } else if (accessType.equalsIgnoreCase(DbTypeType.HDAM.toString())) {
                HdamType hdam = this.dbdObjFactory.createHdamType();
                this.dbd.getAccess().setHdam(hdam);
                HdamAndHidamDataSetContainerType ct = new HdamAndHidamDataSetContainerType();
                hdam.setDataSetContainer(ct);
                this.hdamAndHidamDataSets = new ArrayList();
                HdamAndPhdamRMNameType rmName = new HdamAndPhdamRMNameType();
                RmNameSubOptions subOptions = new RmNameSubOptions();
                rmName.setSubOptions(subOptions);
                hdam.setRmName(rmName);
            } else if (accessType.equalsIgnoreCase(DbTypeType.HIDAM.toString())) {
                HidamType hidam = this.dbdObjFactory.createHidamType();
                this.dbd.getAccess().setHidam(hidam);
                HdamAndHidamDataSetContainerType ct = new HdamAndHidamDataSetContainerType();
                hidam.setDataSetContainer(ct);
                this.hdamAndHidamDataSets = new ArrayList();
            } else if (accessType.equalsIgnoreCase(DbTypeType.PHDAM.toString())) {
                PhdamType phdam = this.dbdObjFactory.createPhdamType();
                this.dbd.getAccess().setPhdam(phdam);
                HdamAndPhdamRMNameType rmName = new HdamAndPhdamRMNameType();
                RmNameSubOptions subOptions = new RmNameSubOptions();
                rmName.setSubOptions(subOptions);
                phdam.setRmName(rmName);
            } else if (accessType.equalsIgnoreCase(DbTypeType.MSDB.toString())) {
                MsdbType msdb = this.dbdObjFactory.createMsdbType();
                MsdbDataSetType msdbDS = this.dbdObjFactory.createMsdbDataSetType();
                msdb.setDataSet(msdbDS);
                this.dbd.getAccess().setMsdb(msdb);
            } else if (accessType.equalsIgnoreCase(DbTypeType.INDEX.toString())) {
                IndexType index = this.dbdObjFactory.createIndexType();
                this.dbd.getAccess().setIndex(index);
                HisamAndShisamAndIndexDataSetType ds = new HisamAndShisamAndIndexDataSetType();
                index.setDataSet(ds);
            } else if (accessType.equalsIgnoreCase(DbTypeType.PSINDEX.toString())) {
                PsindexType psindex = this.dbdObjFactory.createPsindexType();
                this.dbd.getAccess().setPsindex(psindex);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] inserts = new Object[]{this.dbd.getDbdName(), accessType};
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1600", inserts));
        }
    }

    public Collection<String> getLogicalSourceDbds() throws ModelException {
        Hashtable<String, String> referencedDBDs = new Hashtable<String, String>();
        SegmentModel root = this.getRootSegment();
        if (this.getAccessType() == DBDConstants.LOGICAL) {
            if (root.hasSegmentSource()) {
                String srcDbName = root.getSegmentSourceDBName();
                if (!referencedDBDs.containsKey(srcDbName)) {
                    referencedDBDs.put(srcDbName, srcDbName);
                }
            } else if (root.hasConcatenatedSegmentSource()) {
                String targetSrc;
                String lchildSrc = root.getLogicalChildSourceDBName();
                if (!referencedDBDs.containsKey(lchildSrc)) {
                    referencedDBDs.put(lchildSrc, lchildSrc);
                }
                if (!referencedDBDs.containsKey(targetSrc = root.getTargetParentSourceDBName())) {
                    referencedDBDs.put(targetSrc, targetSrc);
                }
            } else {
                throw new ModelException("Segment of a Logical Database does not contain source DBD ");
            }
            if (root != null) {
                this.getLogicalSourceDbdsinSegment(referencedDBDs, root);
            }
        }
        return referencedDBDs.values();
    }

    private void getLogicalSourceDbdsinSegment(Hashtable<String, String> referencedDBDs, SegmentModel segment) throws ModelException {
        for (SegmentModel seg : segment.getChildSegments()) {
            if (seg.hasSegmentSource()) {
                String srcDbName = seg.getSegmentSourceDBName();
                if (!referencedDBDs.containsKey(srcDbName)) {
                    referencedDBDs.put(srcDbName, srcDbName);
                }
            } else if (seg.hasConcatenatedSegmentSource()) {
                String targetSrc;
                String lchildSrc = seg.getLogicalChildSourceDBName();
                if (!referencedDBDs.containsKey(lchildSrc)) {
                    referencedDBDs.put(lchildSrc, lchildSrc);
                }
                if (!referencedDBDs.containsKey(targetSrc = seg.getTargetParentSourceDBName())) {
                    referencedDBDs.put(targetSrc, targetSrc);
                }
            } else {
                throw new ModelException("ERROR: DBD " + this.getDBDName() + " is a logical DBD, but its segment " + seg.getName() + " does not have a source or concatenated source specified.");
            }
            this.getLogicalSourceDbdsinSegment(referencedDBDs, seg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<String> getReferencedDBDs() throws ModelException {
        SegmentModel root;
        Hashtable<String, String> referencedDBDs;
        block7: {
            block5: {
                String targetSrc;
                block6: {
                    referencedDBDs = new Hashtable<String, String>();
                    root = this.getRootSegment();
                    if (this.getAccessType() != DBDConstants.LOGICAL) break block5;
                    if (!root.hasSegmentSource()) break block6;
                    String srcDbName = root.getSegmentSourceDBName();
                    if (!referencedDBDs.containsKey(srcDbName)) {
                        referencedDBDs.put(srcDbName, srcDbName);
                    }
                    break block7;
                }
                if (!root.hasConcatenatedSegmentSource()) throw new ModelException("Segment of a Logical Database does not contain source DBD ");
                String lchildSrc = root.getLogicalChildSourceDBName();
                if (!referencedDBDs.containsKey(lchildSrc)) {
                    referencedDBDs.put(lchildSrc, lchildSrc);
                }
                if (referencedDBDs.containsKey(targetSrc = root.getTargetParentSourceDBName())) break block7;
                referencedDBDs.put(targetSrc, targetSrc);
                break block7;
            }
            if (root != null) {
                List<LogicalChildModel> lchildList = root.getLogicalChildList();
                int i = 0;
                while (i < lchildList.size()) {
                    LogicalChildModel currLchild = lchildList.get(i);
                    String refDbdName = currLchild.getDbd();
                    if (refDbdName != null && !this.getDBDName().equalsIgnoreCase(refDbdName) && !referencedDBDs.containsKey(refDbdName)) {
                        referencedDBDs.put(refDbdName, refDbdName);
                    }
                    ++i;
                }
            }
        }
        if (root == null) return referencedDBDs.values();
        this.processReferencedDBDinSegment(referencedDBDs, root);
        return referencedDBDs.values();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processReferencedDBDinSegment(Hashtable<String, String> referencedDBDs, SegmentModel segment) throws ModelException {
        for (SegmentModel seg : segment.getChildSegments()) {
            if (seg.getDbdModel().getAccessType() == DBDConstants.LOGICAL) {
                if (seg.hasSegmentSource()) {
                    String srcDbName = seg.getSegmentSourceDBName();
                    if (!referencedDBDs.containsKey(srcDbName)) {
                        referencedDBDs.put(srcDbName, srcDbName);
                    }
                } else {
                    String targetSrc;
                    if (!seg.hasConcatenatedSegmentSource()) throw new ModelException("ERROR: DBD " + this.getDBDName() + " is a logical DBD, but its segment " + seg.getName() + " does not have a source or concatenated source specified.");
                    String lchildSrc = seg.getLogicalChildSourceDBName();
                    if (!referencedDBDs.containsKey(lchildSrc)) {
                        referencedDBDs.put(lchildSrc, lchildSrc);
                    }
                    if (!referencedDBDs.containsKey(targetSrc = seg.getTargetParentSourceDBName())) {
                        referencedDBDs.put(targetSrc, targetSrc);
                    }
                }
            } else {
                List<LogicalChildModel> lchildList = seg.getLogicalChildList();
                int i = 0;
                while (i < lchildList.size()) {
                    LogicalChildModel currLchild = lchildList.get(i);
                    String refDbdName = currLchild.getDbd();
                    if (refDbdName != null && !this.getDBDName().equalsIgnoreCase(refDbdName) && !referencedDBDs.containsKey(refDbdName)) {
                        referencedDBDs.put(refDbdName, refDbdName);
                    }
                    ++i;
                }
                String logicalParentDbdName = seg.getLogicalParentDbdName();
                if (logicalParentDbdName != null && !referencedDBDs.containsKey(logicalParentDbdName) && !this.getDBDName().equalsIgnoreCase(logicalParentDbdName)) {
                    referencedDBDs.put(logicalParentDbdName, logicalParentDbdName);
                }
            }
            this.processReferencedDBDinSegment(referencedDBDs, seg);
        }
    }

    public String getOsAccess() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            return this.dbd.getAccess().getPhidam().getOsAccess().toString();
        }
        if (dbAccType.equalsIgnoreCase("SHISAM")) {
            AccessType accType = this.dbd.getAccess();
            VsamOSAccessType osAccType = accType.getShisam().getOsAccess();
            YesnoType prot = this.getProt();
            if (osAccType == null && (prot == null || prot == YesnoType.Y)) {
                return "SHISAM";
            }
            return osAccType.toString();
        }
        if (dbAccType.equalsIgnoreCase("HISAM")) {
            return this.dbd.getAccess().getHisam().getOsAccess().toString();
        }
        if (dbAccType.equalsIgnoreCase("HIDAM")) {
            return this.dbd.getAccess().getHidam().getOsAccess().toString();
        }
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            return this.dbd.getAccess().getHdam().getOsAccess().toString();
        }
        if (dbAccType.equalsIgnoreCase("GSAM")) {
            return this.dbd.getAccess().getGsam().getOsAccess().toString();
        }
        if (dbAccType.equalsIgnoreCase("PHDAM")) {
            return this.dbd.getAccess().getPhdam().getOsAccess().toString();
        }
        if (dbAccType.equalsIgnoreCase("INDEX")) {
            return this.dbd.getAccess().getIndex().getOsAccess().toString();
        }
        if (dbAccType.equalsIgnoreCase("PSINDEX")) {
            return this.dbd.getAccess().getPsindex().getOsAccess().toString();
        }
        return null;
    }

    public void setOsAccess(String osAccess) throws ModelException {
        block13: {
            if (this.dbd.getAccess() == null) {
                throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
            }
            String dbAccType = this.dbd.getAccess().getDbType().toString();
            try {
                if (dbAccType.equalsIgnoreCase("PHIDAM")) {
                    this.dbd.getAccess().getPhidam().setOsAccess(VoOSAccessType.fromValue(osAccess));
                    break block13;
                }
                if (dbAccType.equalsIgnoreCase("SHISAM")) {
                    this.dbd.getAccess().getShisam().setOsAccess(VsamOSAccessType.fromValue(osAccess));
                    break block13;
                }
                if (dbAccType.equalsIgnoreCase("HISAM")) {
                    this.dbd.getAccess().getHisam().setOsAccess(VsamOSAccessType.fromValue(osAccess));
                    break block13;
                }
                if (dbAccType.equalsIgnoreCase("HIDAM")) {
                    this.dbd.getAccess().getHidam().setOsAccess(VoOSAccessType.fromValue(osAccess));
                    break block13;
                }
                if (dbAccType.equalsIgnoreCase("HDAM")) {
                    this.dbd.getAccess().getHdam().setOsAccess(VoOSAccessType.fromValue(osAccess));
                    break block13;
                }
                if (dbAccType.equalsIgnoreCase("GSAM")) {
                    this.dbd.getAccess().getGsam().setOsAccess(GsamOSAccessType.fromValue(osAccess));
                    break block13;
                }
                if (dbAccType.equalsIgnoreCase("PHDAM")) {
                    this.dbd.getAccess().getPhdam().setOsAccess(VoOSAccessType.fromValue(osAccess));
                    break block13;
                }
                if (dbAccType.equalsIgnoreCase("INDEX")) {
                    this.dbd.getAccess().getIndex().setOsAccess(IndexOsAccessType.fromValue(osAccess));
                    break block13;
                }
                if (dbAccType.equalsIgnoreCase("PSINDEX")) {
                    this.dbd.getAccess().getPsindex().setOsAccess(VsamOSAccessType.fromValue(osAccess));
                    break block13;
                }
                if (dbAccType.equalsIgnoreCase("HSAM") || dbAccType.equalsIgnoreCase("SHSAM") || dbAccType.equalsIgnoreCase("MSDB") || dbAccType.equalsIgnoreCase("DEDB") || dbAccType.equalsIgnoreCase("LOGICAL")) {
                    Object[] inserts = new Object[]{this.dbd.getDbdName(), osAccess, dbAccType};
                    throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1610", inserts));
                }
                Object[] inserts = new Object[]{this.dbd.getDbdName(), dbAccType};
                throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1600", inserts));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] inserts = new Object[]{this.dbd.getDbdName(), osAccess, dbAccType};
                throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1610", inserts));
            }
        }
    }

    public String isPassword() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            return this.dbd.getAccess().getPhidam().getPassword().toString();
        }
        if (dbAccType.equalsIgnoreCase("SHISAM")) {
            return this.dbd.getAccess().getShisam().getPassword().toString();
        }
        if (dbAccType.equalsIgnoreCase("HISAM")) {
            return this.dbd.getAccess().getHisam().getPassword().toString();
        }
        if (dbAccType.equalsIgnoreCase("HIDAM")) {
            return this.dbd.getAccess().getHidam().getPassword().toString();
        }
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            return this.dbd.getAccess().getHdam().getPassword().toString();
        }
        if (dbAccType.equalsIgnoreCase("GSAM")) {
            return this.dbd.getAccess().getGsam().getPassword().toString();
        }
        if (dbAccType.equalsIgnoreCase("PHDAM")) {
            return this.dbd.getAccess().getPhdam().getPassword().toString();
        }
        if (dbAccType.equalsIgnoreCase("INDEX")) {
            return this.dbd.getAccess().getIndex().getPassword().toString();
        }
        if (dbAccType.equalsIgnoreCase("PSINDEX")) {
            return this.dbd.getAccess().getPsindex().getPassword().toString();
        }
        return null;
    }

    public SegmentModel getSegment(String segmentImsName) {
        return this.getSegment(segmentImsName, this.rootSegment);
    }

    private SegmentModel getSegment(String segmentImsName, SegmentModel currSeg) {
        if (segmentImsName.equalsIgnoreCase(currSeg.getImsName()) || segmentImsName.equalsIgnoreCase(currSeg.getName())) {
            return currSeg;
        }
        List<SegmentModel> childSegs = currSeg.getChildSegments();
        int i = 0;
        while (i < childSegs.size()) {
            SegmentModel child = childSegs.get(i);
            SegmentModel retVal = this.getSegment(segmentImsName, child);
            if (retVal != null) {
                return retVal;
            }
            ++i;
        }
        return null;
    }

    public Vector<SegmentModel> getSegments() {
        Vector<SegmentModel> retVal = new Vector<SegmentModel>();
        this.addSegmentsToVector(this.rootSegment, retVal);
        return retVal;
    }

    private void addSegmentsToVector(SegmentModel seg, Vector<SegmentModel> list) {
        list.addElement(seg);
        List<SegmentModel> childSegs = seg.getChildSegments();
        int i = 0;
        while (i < childSegs.size()) {
            SegmentModel child = childSegs.get(i);
            this.addSegmentsToVector(child, list);
            ++i;
        }
    }

    public void setPassword(YesnoType password) {
        DbTypeType dbAccType = this.dbd.getAccess().getDbType();
        if (dbAccType == DbTypeType.PHIDAM) {
            this.dbd.getAccess().getPhidam().setPassword(password);
        } else if (dbAccType == DbTypeType.SHISAM) {
            this.dbd.getAccess().getShisam().setPassword(password);
        } else if (dbAccType == DbTypeType.HISAM) {
            this.dbd.getAccess().getHisam().setPassword(password);
        } else if (dbAccType == DbTypeType.HIDAM) {
            this.dbd.getAccess().getHidam().setPassword(password);
        } else if (dbAccType == DbTypeType.HDAM) {
            this.dbd.getAccess().getHdam().setPassword(password);
        } else if (dbAccType == DbTypeType.GSAM) {
            this.dbd.getAccess().getGsam().setPassword(password);
        } else if (dbAccType == DbTypeType.PHDAM) {
            this.dbd.getAccess().getPhdam().setPassword(password);
        } else if (dbAccType == DbTypeType.INDEX) {
            this.dbd.getAccess().getIndex().setPassword(password);
        } else if (dbAccType == DbTypeType.PSINDEX) {
            this.dbd.getAccess().getPsindex().setPassword(password);
        }
    }

    public YesnoType getPassword() {
        DbTypeType dbAccType = this.dbd.getAccess().getDbType();
        if (dbAccType == DbTypeType.PHIDAM) {
            return this.dbd.getAccess().getPhidam().getPassword();
        }
        if (dbAccType == DbTypeType.SHISAM) {
            return this.dbd.getAccess().getShisam().getPassword();
        }
        if (dbAccType == DbTypeType.HISAM) {
            return this.dbd.getAccess().getHisam().getPassword();
        }
        if (dbAccType == DbTypeType.HIDAM) {
            return this.dbd.getAccess().getHidam().getPassword();
        }
        if (dbAccType == DbTypeType.HDAM) {
            return this.dbd.getAccess().getHdam().getPassword();
        }
        if (dbAccType == DbTypeType.GSAM) {
            return this.dbd.getAccess().getGsam().getPassword();
        }
        if (dbAccType == DbTypeType.PHDAM) {
            return this.dbd.getAccess().getPhdam().getPassword();
        }
        if (dbAccType == DbTypeType.INDEX) {
            return this.dbd.getAccess().getIndex().getPassword();
        }
        return null;
    }

    public String isDatxexit() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            return this.dbd.getAccess().getPhidam().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("SHISAM")) {
            return this.dbd.getAccess().getShisam().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("HISAM")) {
            return this.dbd.getAccess().getHisam().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("HIDAM")) {
            return this.dbd.getAccess().getHidam().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            return this.dbd.getAccess().getHdam().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("GSAM")) {
            return this.dbd.getAccess().getGsam().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("PHDAM")) {
            return this.dbd.getAccess().getPhdam().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("HSAM")) {
            return this.dbd.getAccess().getHsam().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("SHSAM")) {
            return this.dbd.getAccess().getShsam().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("INDEX")) {
            return this.dbd.getAccess().getIndex().getDatxexit().toString();
        }
        if (dbAccType.equalsIgnoreCase("PSINDEX")) {
            return this.dbd.getAccess().getPsindex().getDatxexit().toString();
        }
        return null;
    }

    public void setDatxexit(YesnoType datxexit) {
        DbTypeType dbAccType = this.dbd.getAccess().getDbType();
        if (dbAccType == DbTypeType.PHIDAM) {
            this.dbd.getAccess().getPhidam().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.SHISAM) {
            this.dbd.getAccess().getShisam().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.HISAM) {
            this.dbd.getAccess().getHisam().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.HIDAM) {
            this.dbd.getAccess().getHidam().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.HDAM) {
            this.dbd.getAccess().getHdam().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.GSAM) {
            this.dbd.getAccess().getGsam().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.PHDAM) {
            this.dbd.getAccess().getPhdam().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.HSAM) {
            this.dbd.getAccess().getHsam().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.SHSAM) {
            this.dbd.getAccess().getShsam().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.INDEX) {
            this.dbd.getAccess().getIndex().setDatxexit(datxexit);
        } else if (dbAccType == DbTypeType.PSINDEX) {
            this.dbd.getAccess().getPsindex().setDatxexit(datxexit);
        }
    }

    public YesnoType getDatxexit() {
        DbTypeType dbAccType = this.dbd.getAccess().getDbType();
        if (dbAccType == DbTypeType.PHIDAM) {
            return this.dbd.getAccess().getPhidam().getDatxexit();
        }
        if (dbAccType == DbTypeType.SHISAM) {
            return this.dbd.getAccess().getShisam().getDatxexit();
        }
        if (dbAccType == DbTypeType.HISAM) {
            return this.dbd.getAccess().getHisam().getDatxexit();
        }
        if (dbAccType == DbTypeType.HIDAM) {
            return this.dbd.getAccess().getHidam().getDatxexit();
        }
        if (dbAccType == DbTypeType.HDAM) {
            return this.dbd.getAccess().getHdam().getDatxexit();
        }
        if (dbAccType == DbTypeType.GSAM) {
            return this.dbd.getAccess().getGsam().getDatxexit();
        }
        if (dbAccType == DbTypeType.PHDAM) {
            return this.dbd.getAccess().getPhdam().getDatxexit();
        }
        if (dbAccType == DbTypeType.HSAM) {
            return this.dbd.getAccess().getHsam().getDatxexit();
        }
        if (dbAccType == DbTypeType.SHSAM) {
            return this.dbd.getAccess().getShsam().getDatxexit();
        }
        if (dbAccType == DbTypeType.INDEX) {
            return this.dbd.getAccess().getIndex().getDatxexit();
        }
        if (dbAccType == DbTypeType.PSINDEX) {
            return this.dbd.getAccess().getPsindex().getDatxexit();
        }
        return null;
    }

    public void setProt(YesnoType prot) {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase(DbTypeType.INDEX.toString())) {
            this.dbd.getAccess().getIndex().setProt(prot);
        } else if (dbAccType.equalsIgnoreCase(DbTypeType.PSINDEX.toString())) {
            this.dbd.getAccess().getPsindex().setProt(prot);
        }
    }

    public void setDoscomp(YesnoType doscomp) {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase(DbTypeType.INDEX.toString())) {
            this.dbd.getAccess().getIndex().setDoscomp(doscomp);
        }
    }

    public YesnoType getDoscomp() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (!dbAccType.equalsIgnoreCase(DbTypeType.INDEX.toString())) {
            return null;
        }
        return this.dbd.getAccess().getIndex().getDoscomp();
    }

    public YesnoType getProt() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (!dbAccType.equalsIgnoreCase(DbTypeType.INDEX.toString())) {
            return null;
        }
        return this.dbd.getAccess().getIndex().getProt();
    }

    public void setRMName(String rmName) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("DEDB")) {
            this.dbd.getAccess().getDedb().getRmName().setName(rmName);
        } else if (dbAccType.equalsIgnoreCase("HDAM")) {
            this.dbd.getAccess().getHdam().getRmName().setName(rmName);
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            this.dbd.getAccess().getPhdam().getRmName().setName(rmName);
        }
    }

    public void setRmNameAnchorPoints(int anchorPoints) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("DEDB")) {
            this.dbd.getAccess().getDedb().getRmName().setAnchorPoints(anchorPoints);
        } else if (dbAccType.equalsIgnoreCase("HDAM")) {
            this.dbd.getAccess().getHdam().getRmName().getSubOptions().setAnchorPoints(anchorPoints);
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            this.dbd.getAccess().getPhdam().getRmName().getSubOptions().setAnchorPoints(anchorPoints);
        }
    }

    public void setXci(String xci) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("DEDB")) {
            if (xci.equalsIgnoreCase(DBDConstants.Y.toString())) {
                this.dbd.getAccess().getDedb().getRmName().setXCI(YesnoType.Y);
            } else {
                this.dbd.getAccess().getDedb().getRmName().setXCI(YesnoType.N);
            }
        }
    }

    public void setRmNameMaxRBN(int rbn) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            this.dbd.getAccess().getHdam().getRmName().getSubOptions().setMaxRBN(rbn);
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            this.dbd.getAccess().getPhdam().getRmName().getSubOptions().setMaxRBN(rbn);
        }
    }

    public void setRmNameBytes(int bytes) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            this.dbd.getAccess().getHdam().getRmName().getSubOptions().setBytes(bytes);
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            this.dbd.getAccess().getPhdam().getRmName().getSubOptions().setBytes(bytes);
        }
    }

    public String getRMName() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("DEDB")) {
            return this.dbd.getAccess().getDedb().getRmName().getName();
        }
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            return this.dbd.getAccess().getHdam().getRmName().getName();
        }
        if (dbAccType.equalsIgnoreCase("PHDAM")) {
            return this.dbd.getAccess().getPhdam().getRmName().getName();
        }
        return null;
    }

    public Integer getRmNameAnchorPoints() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("DEDB")) {
            return this.dbd.getAccess().getDedb().getRmName().getAnchorPoints();
        }
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            return this.dbd.getAccess().getHdam().getRmName().getSubOptions().getAnchorPoints();
        }
        if (dbAccType.equalsIgnoreCase("PHDAM")) {
            return this.dbd.getAccess().getPhdam().getRmName().getSubOptions().getAnchorPoints();
        }
        return null;
    }

    public Integer getRmNameMaxRBN() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            return this.dbd.getAccess().getHdam().getRmName().getSubOptions().getMaxRBN();
        }
        if (dbAccType.equalsIgnoreCase("PHDAM")) {
            return this.dbd.getAccess().getPhdam().getRmName().getSubOptions().getMaxRBN();
        }
        return null;
    }

    public Integer getRmNameBytes() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            return this.dbd.getAccess().getHdam().getRmName().getSubOptions().getBytes();
        }
        if (dbAccType.equalsIgnoreCase("PHDAM")) {
            return this.dbd.getAccess().getPhdam().getRmName().getSubOptions().getBytes();
        }
        return null;
    }

    public List<String> getSecondaryIxDBDNames() {
        SecondIxDbdNamesType secondIxDbdNamesType;
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("INDEX") && (secondIxDbdNamesType = this.dbd.getAccess().getIndex().getSecondIxDbdNames()) != null) {
            return secondIxDbdNamesType.getSecondIxDbdName();
        }
        return null;
    }

    public void setSecondaryIxDBDNames(List<String> names) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        DbTypeType dbAccType = this.dbd.getAccess().getDbType();
        if (dbAccType == DbTypeType.INDEX) {
            SecondIxDbdNamesType secondIxDbdNamesType = new SecondIxDbdNamesType();
            int i = 0;
            while (i < names.size()) {
                secondIxDbdNamesType.getSecondIxDbdName().add(names.get(i));
                ++i;
            }
            this.dbd.getAccess().getIndex().setSecondIxDbdNames(secondIxDbdNamesType);
        }
    }

    public DBDConstants isProt() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("INDEX")) {
            return DBDConstants.fromValue(this.dbd.getAccess().getIndex().getProt().toString());
        }
        if (dbAccType.equalsIgnoreCase("PSINDEX")) {
            return DBDConstants.fromValue(this.dbd.getAccess().getPsindex().getProt().toString());
        }
        return null;
    }

    public DBDConstants isDoscomp() {
        YesnoType isDoscomp;
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("INDEX") && (isDoscomp = this.dbd.getAccess().getIndex().getDoscomp()) != null) {
            return DBDConstants.fromValue(isDoscomp.toString());
        }
        return null;
    }

    public String getXCI() {
        YesnoType xci;
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("DEDB") && (xci = this.dbd.getAccess().getDedb().getRmName().getXCI()) != null) {
            return this.dbd.getAccess().getDedb().getRmName().getXCI().value();
        }
        return null;
    }

    public String getPsname() {
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("PHDAM")) {
            return this.dbd.getAccess().getPhdam().getPsname();
        }
        if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            return this.dbd.getAccess().getPhidam().getPsname();
        }
        return null;
    }

    public void setPsname(String psname) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("PHDAM")) {
            this.dbd.getAccess().getPhdam().setPsname(psname);
        } else if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            this.dbd.getAccess().getPhidam().setPsname(psname);
        }
    }

    public SegmentModel createDefaultRootSegment(DbdModel dbdModel) throws ModelException {
        this.rootSegment = new SegmentModel(null, new SegmentType(), dbdModel, null);
        this.rootSegment.setImsName(this.dbd.getDbdName());
        this.dbd.getSegment().add(this.rootSegment.getSegmentType());
        return this.rootSegment;
    }

    public void setArea(AreaStmt areaModel) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("DEDB")) {
            this.dbd.getAccess().getDedb().getAreaContainer().getArea().add(areaModel.getJaxbArea());
            this.areaModels.add(areaModel);
        }
    }

    public SegmentModel getTargetSegmentForProcseq(String procseq) {
        return this.getTargetSegmentForProcseqRecursively(this.rootSegment, procseq);
    }

    private SegmentModel getTargetSegmentForProcseqRecursively(SegmentModel currSeg, String procseq) {
        SegmentModel retVal = null;
        if (currSeg.isTargetForProcseq(procseq)) {
            return currSeg;
        }
        List<SegmentModel> childSegs = currSeg.getChildSegments();
        int i = 0;
        while (i < childSegs.size()) {
            SegmentModel currChildSeg = childSegs.get(i);
            retVal = this.getTargetSegmentForProcseqRecursively(currChildSeg, procseq);
            if (retVal != null) {
                return retVal;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<AreaStmt> getAreaList() {
        return this.areaModels;
    }

    public List<DataExitRoutine> getDataCaptureExitRoutines() {
        return this.dataCaptureExitRoutines;
    }

    public void addDataCaptureExitRoutine(DataExitRoutine exitRoutine) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        if (this.dataCaptureExitRoutines == null) {
            this.dataCaptureExitRoutines = new ArrayList();
        }
        this.dataCaptureExitRoutines.add(exitRoutine);
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        ExitContainerType exitContainer = null;
        if (dbAccType.equalsIgnoreCase("SHISAM")) {
            exitContainer = this.dbd.getAccess().getShisam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getShisam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HISAM")) {
            exitContainer = this.dbd.getAccess().getHisam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getHisam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HDAM")) {
            exitContainer = this.dbd.getAccess().getHdam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getHdam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            exitContainer = this.dbd.getAccess().getPhdam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getPhdam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
            exitContainer = this.dbd.getAccess().getHidam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getHidam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            exitContainer = this.dbd.getAccess().getPhidam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getPhidam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("DEDB")) {
            exitContainer = this.dbd.getAccess().getDedb().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getDedb().setExitContainer(exitContainer);
            }
        } else {
            Object[] dbError = new String[]{dbAccType};
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1602", dbError));
        }
        exitContainer.getDataCaptureExitRoutine().add(exitRoutine.getJaxbExit());
    }

    public void addDataCaptureExitRoutine(DataExitRoutine exitRoutine, boolean clearExisting) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        if (this.dataCaptureExitRoutines == null || clearExisting) {
            this.dataCaptureExitRoutines = new ArrayList();
        }
        this.dataCaptureExitRoutines.add(exitRoutine);
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        ExitContainerType exitContainer = null;
        if (dbAccType.equalsIgnoreCase("SHISAM")) {
            exitContainer = this.dbd.getAccess().getShisam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getShisam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HISAM")) {
            exitContainer = this.dbd.getAccess().getHisam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getHisam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HDAM")) {
            exitContainer = this.dbd.getAccess().getHdam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getHdam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("PHDAM")) {
            exitContainer = this.dbd.getAccess().getPhdam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getPhdam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
            exitContainer = this.dbd.getAccess().getHidam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getHidam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("PHIDAM")) {
            exitContainer = this.dbd.getAccess().getPhidam().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getPhidam().setExitContainer(exitContainer);
            }
        } else if (dbAccType.equalsIgnoreCase("DEDB")) {
            exitContainer = this.dbd.getAccess().getDedb().getExitContainer();
            if (exitContainer == null) {
                exitContainer = new ExitContainerType();
                this.dbd.getAccess().getDedb().setExitContainer(exitContainer);
            }
        } else {
            Object[] dbError = new String[]{dbAccType};
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1602", dbError));
        }
        if (clearExisting) {
            exitContainer.getDataCaptureExitRoutine().clear();
        }
        exitContainer.getDataCaptureExitRoutine().add(exitRoutine.getJaxbExit());
    }

    public String toString() {
        return this.dbd.getDbdName();
    }

    public Dbd getDbd() {
        return this.dbd;
    }

    public void setDbd(Dbd dbd) {
        this.dbd = dbd;
    }

    public SegmentModel getRootSegment() {
        return this.rootSegment;
    }

    public void setRootSegment(SegmentModel root) {
        this.rootSegment = root;
        this.dbd.getSegment().add(this.rootSegment.getSegmentType());
    }

    public void setHidamDataset(HidamDataSetModel value) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            this.dbd.getAccess().getHdam().getDataSetContainer().getDataSet().add(value.getDataSet());
        } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
            this.dbd.getAccess().getHidam().getDataSetContainer().getDataSet().add(value.getDataSet());
        } else {
            Object[] dbError = new String[]{dbAccType};
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1602", dbError));
        }
        this.hdamAndHidamDataSets.add(value);
    }

    public void setDevice(String value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            this.dbd.getAccess().getGsam().getDataSet().setDevice(value);
        } else if (access.equalsIgnoreCase("HSAM")) {
            this.dbd.getAccess().getHsam().getDataSet().setDevice(value);
        } else if (access.equalsIgnoreCase("SHSAM")) {
            this.dbd.getAccess().getShsam().getDataSet().setDevice(value);
        } else if (access.equalsIgnoreCase("HISAM")) {
            this.dbd.getAccess().getHisam().getDataSet().setDevice(value);
        } else if (access.equalsIgnoreCase("SHISAM")) {
            this.dbd.getAccess().getShisam().getDataSet().setDevice(value);
        } else if (access.equalsIgnoreCase("INDEX")) {
            this.dbd.getAccess().getIndex().getDataSet().setDevice(value);
        } else if (access.equalsIgnoreCase("MSDB")) {
            this.dbd.getAccess().getMsdb().getDataSet().setDevice(value);
        }
    }

    public void setDatasetRemarks(String value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            this.dbd.getAccess().getGsam().getDataSet().setRemarks(value);
        } else if (access.equalsIgnoreCase("HSAM")) {
            this.dbd.getAccess().getHsam().getDataSet().setRemarks(value);
        } else if (access.equalsIgnoreCase("SHSAM")) {
            this.dbd.getAccess().getShsam().getDataSet().setRemarks(value);
        } else if (access.equalsIgnoreCase("HISAM")) {
            this.dbd.getAccess().getHisam().getDataSet().setRemarks(value);
        } else if (access.equalsIgnoreCase("SHISAM")) {
            this.dbd.getAccess().getShisam().getDataSet().setRemarks(value);
        } else if (access.equalsIgnoreCase("INDEX")) {
            this.dbd.getAccess().getIndex().getDataSet().setRemarks(value);
        } else if (access.equalsIgnoreCase("MSDB")) {
            this.dbd.getAccess().getMsdb().getDataSet().setRemarks(value);
        } else {
            access.equalsIgnoreCase("LOGICAL");
        }
    }

    public String getDatasetRemarks() {
        String access = this.dbd.getAccess().getDbType().toString();
        String remarks = null;
        if (access.equalsIgnoreCase("GSAM")) {
            remarks = this.dbd.getAccess().getGsam().getDataSet().getRemarks();
        } else if (access.equalsIgnoreCase("HSAM")) {
            remarks = this.dbd.getAccess().getHsam().getDataSet().getRemarks();
        } else if (access.equalsIgnoreCase("SHSAM")) {
            remarks = this.dbd.getAccess().getShsam().getDataSet().getRemarks();
        } else if (access.equalsIgnoreCase("HISAM")) {
            remarks = this.dbd.getAccess().getHisam().getDataSet().getRemarks();
        } else if (access.equalsIgnoreCase("SHISAM")) {
            remarks = this.dbd.getAccess().getShisam().getDataSet().getRemarks();
        } else if (access.equalsIgnoreCase("INDEX")) {
            remarks = this.dbd.getAccess().getIndex().getDataSet().getRemarks();
        } else if (access.equalsIgnoreCase("MSDB")) {
            remarks = this.dbd.getAccess().getMsdb().getDataSet().getRemarks();
        } else {
            access.equalsIgnoreCase("LOGICAL");
        }
        return remarks;
    }

    public String getDevice() {
        String access = this.dbd.getAccess().getDbType().toString();
        String device = null;
        if (access.equalsIgnoreCase("GSAM")) {
            device = this.dbd.getAccess().getGsam().getDataSet().getDevice();
        } else if (access.equalsIgnoreCase("HSAM")) {
            device = this.dbd.getAccess().getHsam().getDataSet().getDevice();
        } else if (access.equalsIgnoreCase("SHSAM")) {
            device = this.dbd.getAccess().getShsam().getDataSet().getDevice();
        } else if (access.equalsIgnoreCase("HISAM")) {
            device = this.dbd.getAccess().getHisam().getDataSet().getDevice();
        } else if (access.equalsIgnoreCase("SHISAM")) {
            device = this.dbd.getAccess().getShisam().getDataSet().getDevice();
        } else if (access.equalsIgnoreCase("INDEX")) {
            device = this.dbd.getAccess().getIndex().getDataSet().getDevice();
        } else if (access.equalsIgnoreCase("MSDB")) {
            device = this.dbd.getAccess().getMsdb().getDataSet().getDevice();
        }
        return device;
    }

    public ArrayList<HidamDataSetModel> getHidamDataset() {
        return this.hdamAndHidamDataSets;
    }

    public String getDataSetDdname1() {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            return this.dbd.getAccess().getGsam().getDataSet().getDdname1();
        }
        if (access.equalsIgnoreCase("HSAM")) {
            return this.dbd.getAccess().getHsam().getDataSet().getDdname1();
        }
        if (access.equalsIgnoreCase("SHSAM")) {
            return this.dbd.getAccess().getShsam().getDataSet().getDdname1();
        }
        if (access.equalsIgnoreCase("HISAM")) {
            return this.dbd.getAccess().getHisam().getDataSet().getDdname();
        }
        if (access.equalsIgnoreCase("SHISAM")) {
            return this.dbd.getAccess().getShisam().getDataSet().getDdname();
        }
        if (access.equalsIgnoreCase("INDEX")) {
            return this.dbd.getAccess().getIndex().getDataSet().getDdname();
        }
        return null;
    }

    public void setDdname1(String value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            this.dbd.getAccess().getGsam().getDataSet().setDdname1(value);
        } else if (access.equalsIgnoreCase("HSAM")) {
            this.dbd.getAccess().getHsam().getDataSet().setDdname1(value);
        } else if (access.equalsIgnoreCase("SHSAM")) {
            this.dbd.getAccess().getShsam().getDataSet().setDdname1(value);
        } else if (access.equalsIgnoreCase("HISAM")) {
            this.dbd.getAccess().getHisam().getDataSet().setDdname(value);
        } else if (access.equalsIgnoreCase("SHISAM")) {
            this.dbd.getAccess().getShisam().getDataSet().setDdname(value);
        } else if (access.equalsIgnoreCase("INDEX")) {
            this.dbd.getAccess().getIndex().getDataSet().setDdname(value);
        }
    }

    public String getDdname2() {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            return this.dbd.getAccess().getGsam().getDataSet().getDdname2();
        }
        if (access.equalsIgnoreCase("HSAM")) {
            return this.dbd.getAccess().getHsam().getDataSet().getDdname2();
        }
        if (access.equalsIgnoreCase("SHSAM")) {
            return this.dbd.getAccess().getShsam().getDataSet().getDdname2();
        }
        return null;
    }

    public void setDdname2(String value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            this.dbd.getAccess().getGsam().getDataSet().setDdname2(value);
        } else if (access.equalsIgnoreCase("HSAM")) {
            this.dbd.getAccess().getHsam().getDataSet().setDdname2(value);
        } else if (access.equalsIgnoreCase("SHSAM")) {
            this.dbd.getAccess().getShsam().getDataSet().setDdname2(value);
        }
    }

    public Integer getRECORDReclen1() {
        String access = this.dbd.getAccess().getDbType().toString();
        RecordType record = null;
        if (access.equalsIgnoreCase("GSAM")) {
            record = this.dbd.getAccess().getGsam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("HSAM")) {
            record = this.dbd.getAccess().getHsam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("SHSAM")) {
            record = this.dbd.getAccess().getShsam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("HISAM")) {
            record = this.dbd.getAccess().getHisam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("SHISAM")) {
            record = this.dbd.getAccess().getShisam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("INDEX")) {
            record = this.dbd.getAccess().getIndex().getDataSet().getRecord();
        }
        if (record == null) {
            return null;
        }
        return record.getReclen1();
    }

    public void setRECORDReclen1(Integer value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            RecordType record = this.dbd.getAccess().getGsam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getGsam().getDataSet().setRecord(record);
            }
            record.setReclen1(value);
        } else if (access.equalsIgnoreCase("HSAM")) {
            RecordType record = this.dbd.getAccess().getHsam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getHsam().getDataSet().setRecord(record);
            }
            record.setReclen1(value);
        } else if (access.equalsIgnoreCase("SHSAM")) {
            RecordType record = this.dbd.getAccess().getShsam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getShsam().getDataSet().setRecord(record);
            }
            record.setReclen1(value);
        } else if (access.equalsIgnoreCase("HISAM")) {
            RecordType record = this.dbd.getAccess().getHisam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getHisam().getDataSet().setRecord(record);
            }
            record.setReclen1(value);
        } else if (access.equalsIgnoreCase("SHISAM")) {
            RecordType record = this.dbd.getAccess().getShisam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getShisam().getDataSet().setRecord(record);
            }
            record.setReclen1(value);
        } else if (access.equalsIgnoreCase("INDEX")) {
            RecordType record = this.dbd.getAccess().getIndex().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getIndex().getDataSet().setRecord(record);
            }
            record.setReclen1(value);
        }
    }

    public Integer getRECORDReclen2() {
        String access = this.dbd.getAccess().getDbType().toString();
        RecordType record = null;
        if (access.equalsIgnoreCase("GSAM")) {
            record = this.dbd.getAccess().getGsam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("HSAM")) {
            record = this.dbd.getAccess().getHsam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("SHSAM")) {
            record = this.dbd.getAccess().getShsam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("HISAM")) {
            record = this.dbd.getAccess().getHisam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("SHISAM")) {
            record = this.dbd.getAccess().getShisam().getDataSet().getRecord();
        } else if (access.equalsIgnoreCase("INDEX")) {
            record = this.dbd.getAccess().getIndex().getDataSet().getRecord();
        }
        if (record == null) {
            return null;
        }
        return record.getReclen2();
    }

    public void setRECORDReclen2(Integer value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            RecordType record = this.dbd.getAccess().getGsam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getGsam().getDataSet().setRecord(record);
            }
            record.setReclen2(value);
        } else if (access.equalsIgnoreCase("HSAM")) {
            RecordType record = this.dbd.getAccess().getHsam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getHsam().getDataSet().setRecord(record);
            }
            record.setReclen2(value);
        } else if (access.equalsIgnoreCase("SHSAM")) {
            RecordType record = this.dbd.getAccess().getShsam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getShsam().getDataSet().setRecord(record);
            }
            record.setReclen2(value);
        } else if (access.equalsIgnoreCase("HISAM")) {
            RecordType record = this.dbd.getAccess().getHisam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getHisam().getDataSet().setRecord(record);
            }
            record.setReclen2(value);
        } else if (access.equalsIgnoreCase("SHISAM")) {
            RecordType record = this.dbd.getAccess().getShisam().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getShisam().getDataSet().setRecord(record);
            }
            record.setReclen2(value);
        } else if (access.equalsIgnoreCase("INDEX")) {
            RecordType record = this.dbd.getAccess().getIndex().getDataSet().getRecord();
            if (record == null) {
                record = new RecordType();
                this.dbd.getAccess().getIndex().getDataSet().setRecord(record);
            }
            record.setReclen2(value);
        }
    }

    public void setRel(String relType, String fldnm) {
        MsdbDataSetType msdbDataSetType = this.dbd.getAccess().getMsdb().getDataSet();
        if (msdbDataSetType == null) {
            msdbDataSetType = new MsdbDataSetType();
            this.dbd.getAccess().getMsdb().setDataSet(msdbDataSetType);
        }
        if (relType.equalsIgnoreCase("NO")) {
            msdbDataSetType.setRelType(RelType.NO);
        } else if (relType.equalsIgnoreCase("TERM")) {
            msdbDataSetType.setFldnm(fldnm);
            msdbDataSetType.setRelType(RelType.TERM);
        } else if (relType.equalsIgnoreCase("FIXED")) {
            msdbDataSetType.setFldnm(fldnm);
            msdbDataSetType.setRelType(RelType.FIXED);
        } else if (relType.equalsIgnoreCase("DYNAMIC")) {
            msdbDataSetType.setFldnm(fldnm);
            msdbDataSetType.setRelType(RelType.DYNAMIC);
        }
    }

    public String getRelType() {
        if (this.dbd.getAccess().getMsdb() == null || this.dbd.getAccess().getMsdb().getDataSet() == null) {
            return null;
        }
        MsdbDataSetType msdbDataSetType = this.dbd.getAccess().getMsdb().getDataSet();
        RelType relType = msdbDataSetType.getRelType();
        return relType.toString();
    }

    public String getRelFldnm() {
        if (this.dbd.getAccess().getMsdb() == null || this.dbd.getAccess().getMsdb().getDataSet() == null) {
            return null;
        }
        MsdbDataSetType msdbDataSetType = this.dbd.getAccess().getMsdb().getDataSet();
        return msdbDataSetType.getFldnm();
    }

    public int getBLOCKBlkfact1() {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            GsamBlockType block = this.dbd.getAccess().getGsam().getDataSet().getBlock();
            if (block != null) {
                return block.getBlkfact();
            }
        } else {
            BlockType block = null;
            if (access.equalsIgnoreCase("HSAM")) {
                block = this.dbd.getAccess().getHsam().getDataSet().getBlock();
            } else if (access.equalsIgnoreCase("SHSAM")) {
                block = this.dbd.getAccess().getShsam().getDataSet().getBlock();
            } else if (access.equalsIgnoreCase("HISAM")) {
                block = this.dbd.getAccess().getHisam().getDataSet().getBlock();
            } else if (access.equalsIgnoreCase("SHISAM")) {
                block = this.dbd.getAccess().getShisam().getDataSet().getBlock();
            } else if (access.equalsIgnoreCase("INDEX")) {
                block = this.dbd.getAccess().getIndex().getDataSet().getBlock();
            }
            if (block != null) {
                return block.getBlkfact1();
            }
        }
        return -1;
    }

    public void setBLOCKBlkfact1(Integer value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            GsamBlockType block = this.dbd.getAccess().getGsam().getDataSet().getBlock();
            if (block == null) {
                block = new GsamBlockType();
                this.dbd.getAccess().getGsam().getDataSet().setBlock(block);
            }
            block.setBlkfact(value);
        } else {
            BlockType block = null;
            if (access.equalsIgnoreCase("HSAM")) {
                block = this.dbd.getAccess().getHsam().getDataSet().getBlock();
                if (block == null) {
                    block = new BlockType();
                    this.dbd.getAccess().getHsam().getDataSet().setBlock(block);
                }
            } else if (access.equalsIgnoreCase("SHSAM")) {
                block = this.dbd.getAccess().getShsam().getDataSet().getBlock();
                if (block == null) {
                    block = new BlockType();
                    this.dbd.getAccess().getShsam().getDataSet().setBlock(block);
                }
            } else if (access.equalsIgnoreCase("HISAM")) {
                block = this.dbd.getAccess().getHisam().getDataSet().getBlock();
                if (block == null) {
                    block = new BlockType();
                    this.dbd.getAccess().getHisam().getDataSet().setBlock(block);
                }
            } else if (access.equalsIgnoreCase("SHISAM")) {
                block = this.dbd.getAccess().getShisam().getDataSet().getBlock();
                if (block == null) {
                    block = new BlockType();
                    this.dbd.getAccess().getShisam().getDataSet().setBlock(block);
                }
            } else if (access.equalsIgnoreCase("INDEX") && (block = this.dbd.getAccess().getIndex().getDataSet().getBlock()) == null) {
                block = new BlockType();
                this.dbd.getAccess().getIndex().getDataSet().setBlock(block);
            }
            block.setBlkfact1(value);
        }
    }

    public int getBLOCKBlkfact2() {
        String access = this.dbd.getAccess().getDbType().toString();
        BlockType block = null;
        if (access.equalsIgnoreCase("HSAM")) {
            block = this.dbd.getAccess().getHsam().getDataSet().getBlock();
        } else if (access.equalsIgnoreCase("SHSAM")) {
            block = this.dbd.getAccess().getShsam().getDataSet().getBlock();
        } else if (access.equalsIgnoreCase("HISAM")) {
            block = this.dbd.getAccess().getHisam().getDataSet().getBlock();
        } else if (access.equalsIgnoreCase("SHISAM")) {
            block = this.dbd.getAccess().getShisam().getDataSet().getBlock();
        } else if (access.equalsIgnoreCase("INDEX")) {
            block = this.dbd.getAccess().getIndex().getDataSet().getBlock();
        }
        if (block != null) {
            return block.getBlkfact2();
        }
        return -1;
    }

    public void setBLOCKBlkfact2(Integer value) {
        String access = this.dbd.getAccess().getDbType().toString();
        BlockType block = null;
        if (!access.equalsIgnoreCase("GSAM")) {
            if (access.equalsIgnoreCase("HSAM")) {
                block = this.dbd.getAccess().getHsam().getDataSet().getBlock();
                if (block == null) {
                    block = new BlockType();
                    this.dbd.getAccess().getHsam().getDataSet().setBlock(block);
                }
            } else if (access.equalsIgnoreCase("SHSAM")) {
                block = this.dbd.getAccess().getShsam().getDataSet().getBlock();
                if (block == null) {
                    block = new BlockType();
                    this.dbd.getAccess().getShsam().getDataSet().setBlock(block);
                }
            } else if (access.equalsIgnoreCase("HISAM")) {
                block = this.dbd.getAccess().getHisam().getDataSet().getBlock();
                if (block == null) {
                    block = new BlockType();
                    this.dbd.getAccess().getHisam().getDataSet().setBlock(block);
                }
            } else if (access.equalsIgnoreCase("SHISAM")) {
                block = this.dbd.getAccess().getShisam().getDataSet().getBlock();
                if (block == null) {
                    block = new BlockType();
                    this.dbd.getAccess().getShisam().getDataSet().setBlock(block);
                }
            } else if (access.equalsIgnoreCase("INDEX") && (block = this.dbd.getAccess().getIndex().getDataSet().getBlock()) == null) {
                block = new BlockType();
                this.dbd.getAccess().getIndex().getDataSet().setBlock(block);
            }
            block.setBlkfact2(value);
        }
    }

    public Integer getSize1() {
        SizeType size;
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            GsamSizeType gsamSize = this.dbd.getAccess().getGsam().getDataSet().getSize();
            if (gsamSize != null) {
                return gsamSize.getSize();
            }
        } else if (access.equalsIgnoreCase("HISAM")) {
            SizeType size2 = this.dbd.getAccess().getHisam().getDataSet().getSize();
            if (size2 != null) {
                return size2.getSize1();
            }
        } else if (access.equalsIgnoreCase("SHISAM")) {
            SizeType size3 = this.dbd.getAccess().getShisam().getDataSet().getSize();
            if (size3 != null) {
                return size3.getSize1();
            }
        } else if (access.equalsIgnoreCase("INDEX") && (size = this.dbd.getAccess().getIndex().getDataSet().getSize()) != null) {
            return size.getSize1();
        }
        return null;
    }

    public Integer getSize2() {
        SizeType size;
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("HISAM")) {
            SizeType size2 = this.dbd.getAccess().getHisam().getDataSet().getSize();
            if (size2 != null) {
                return size2.getSize2();
            }
        } else if (access.equalsIgnoreCase("SHISAM")) {
            SizeType size3 = this.dbd.getAccess().getShisam().getDataSet().getSize();
            if (size3 != null) {
                return size3.getSize2();
            }
        } else if (access.equalsIgnoreCase("INDEX") && (size = this.dbd.getAccess().getIndex().getDataSet().getSize()) != null) {
            return size.getSize2();
        }
        return null;
    }

    public void setSize1(Integer value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            GsamSizeType gsamSize = this.dbd.getAccess().getGsam().getDataSet().getSize();
            if (gsamSize == null) {
                gsamSize = new GsamSizeType();
                this.dbd.getAccess().getGsam().getDataSet().setSize(gsamSize);
            }
            gsamSize.setSize(value);
        } else if (access.equalsIgnoreCase("HISAM")) {
            SizeType size = this.dbd.getAccess().getHisam().getDataSet().getSize();
            if (size == null) {
                size = new SizeType();
                this.dbd.getAccess().getHisam().getDataSet().setSize(size);
            }
            size.setSize1(value);
        } else if (access.equalsIgnoreCase("SHISAM")) {
            SizeType size = this.dbd.getAccess().getShisam().getDataSet().getSize();
            if (size == null) {
                size = new SizeType();
                this.dbd.getAccess().getShisam().getDataSet().setSize(size);
            }
            size.setSize1(value);
        } else if (access.equalsIgnoreCase("INDEX")) {
            SizeType size = this.dbd.getAccess().getIndex().getDataSet().getSize();
            if (size == null) {
                size = new SizeType();
                this.dbd.getAccess().getIndex().getDataSet().setSize(size);
            }
            size.setSize1(value);
        }
    }

    public void setSize2(Integer value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("HISAM")) {
            SizeType size = this.dbd.getAccess().getHisam().getDataSet().getSize();
            if (size == null) {
                size = new SizeType();
                this.dbd.getAccess().getHisam().getDataSet().setSize(size);
            }
            size.setSize2(value);
        } else if (access.equalsIgnoreCase("SHISAM")) {
            SizeType size = this.dbd.getAccess().getShisam().getDataSet().getSize();
            if (size == null) {
                size = new SizeType();
                this.dbd.getAccess().getShisam().getDataSet().setSize(size);
            }
            size.setSize2(value);
        } else if (access.equalsIgnoreCase("INDEX")) {
            SizeType size = this.dbd.getAccess().getIndex().getDataSet().getSize();
            if (size == null) {
                size = new SizeType();
                this.dbd.getAccess().getIndex().getDataSet().setSize(size);
            }
            size.setSize2(value);
        }
    }

    public DBDConstants getRecfm() {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            if (this.dbd.getAccess().getGsam().getDataSet().getRecfm() == null) {
                return null;
            }
            return DBDConstants.valueOf(this.dbd.getAccess().getGsam().getDataSet().getRecfm().toString());
        }
        return null;
    }

    public void setRecfm(DBDConstants value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("GSAM")) {
            this.dbd.getAccess().getGsam().getDataSet().setRecfm(RecfmType.valueOf(value.toString()));
        }
    }

    public void setOvflw(String value) {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("HISAM")) {
            this.dbd.getAccess().getHisam().getDataSet().setOvflw(value);
        } else if (access.equalsIgnoreCase("SHISAM")) {
            this.dbd.getAccess().getShisam().getDataSet().setOvflw(value);
        } else if (access.equalsIgnoreCase("INDEX")) {
            this.dbd.getAccess().getIndex().getDataSet().setOvflw(value);
        }
    }

    public String getOvflw() {
        String access = this.dbd.getAccess().getDbType().toString();
        if (access.equalsIgnoreCase("HISAM")) {
            return this.dbd.getAccess().getHisam().getDataSet().getOvflw();
        }
        if (access.equalsIgnoreCase("SHISAM")) {
            return this.dbd.getAccess().getShisam().getDataSet().getOvflw();
        }
        if (access.equalsIgnoreCase("INDEX")) {
            return this.dbd.getAccess().getIndex().getDataSet().getOvflw();
        }
        return null;
    }

    public void marshall(ByteArrayOutputStream dbdOutputStream) throws ModelException {
        try {
            if (this.dbdMarshaller == null) {
                this.dbdMarshaller = this.dbdContext.createMarshaller();
                this.dbdMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
            this.dbdMarshaller.marshal((Object)this.dbd, (OutputStream)dbdOutputStream);
        }
        catch (PropertyException e) {
            Object[] dbError = new String[]{"jaxb.formatted.output"};
            ModelException me = new ModelException(WorkbenchModelBundle.getError().getString("DHB1604", dbError));
            me.initCause(e);
            throw me;
        }
        catch (JAXBException e) {
            ModelException me = new ModelException(WorkbenchModelBundle.getError().getString("DHB1605"));
            me.initCause(e);
            throw me;
        }
    }

    public void marshall(File file) throws ModelException {
        try {
            if (this.dbdMarshaller == null) {
                this.dbdMarshaller = this.dbdContext.createMarshaller();
                this.dbdMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
            this.dbdMarshaller.marshal((Object)this.dbd, file);
        }
        catch (PropertyException e) {
            Object[] dbError = new String[]{"jaxb.formatted.output"};
            ModelException me = new ModelException(WorkbenchModelBundle.getError().getString("DHB1604", dbError));
            me.initCause(e);
            throw me;
        }
        catch (JAXBException e) {
            ModelException me = new ModelException(WorkbenchModelBundle.getError().getString("DHB1605"));
            me.initCause(e);
            throw me;
        }
    }

    public String generateDatasetLabel() {
        String newLabel;
        boolean labelCollide;
        do {
            newLabel = "GENDS" + Integer.toString(this.datasetLabelCount);
            labelCollide = false;
            int j = 0;
            while (j < this.existingLabels.size()) {
                if (newLabel.equals(this.existingLabels.get(j))) {
                    labelCollide = true;
                }
                ++j;
            }
            ++this.datasetLabelCount;
        } while (labelCollide);
        this.genedDatasetLabels.add(newLabel);
        return newLabel;
    }

    public ArrayList<String> getGenedDatasetLabels() {
        return this.genedDatasetLabels;
    }

    public ArrayList<String> getExistingLablels() {
        return this.existingLabels;
    }

    public void addToExistingLabels(String label) {
        this.existingLabels.add(label);
    }

    public void clearExistingLabels() {
        this.existingLabels.removeAll(this.existingLabels);
    }

    @Override
    public boolean isDBD() {
        return true;
    }

    @Override
    public boolean isPSB() {
        return false;
    }

    public boolean isPartiallyParsed() {
        return this.partiallyParsed;
    }

    public void setPartiallyParsed(boolean partiallyParsed) {
        this.partiallyParsed = partiallyParsed;
    }

    public List<SegmentModel> getIndexMultipleSegments() throws ModelException {
        List<SegmentType> indexSegmentTypes = this.getDbd().getAccess().getIndex().getSegment();
        Iterator<SegmentType> it = indexSegmentTypes.iterator();
        ArrayList<SegmentModel> indexSegmentModels = new ArrayList<SegmentModel>();
        while (it.hasNext()) {
            SegmentType segmentType = it.next();
            SegmentModel segmentModel = new SegmentModel(null, segmentType, this, null);
            indexSegmentModels.add(segmentModel);
        }
        return indexSegmentModels;
    }

    public void setIndexMultipleSegments(SegmentModel segmentModel) {
        SegmentType segmentType = segmentModel.getSegmentType();
        if (segmentType != null) {
            this.getDbd().getAccess().getIndex().getSegment().add(segmentType);
        }
    }

    public void setRemarks(String remarks) {
        this.dbd.setRemarks(remarks);
    }

    public String getRemarks() {
        return this.dbd.getRemarks();
    }

    public void setEncoding(String encoding) {
        this.dbd.setEncoding(encoding);
    }

    public String getEncoding() {
        return this.dbd.getEncoding();
    }

    public void setFieldRemarks(String remarksValue, String segmentImsName, String fieldName, SegmentModel rootSegment) {
        SegmentModel currSegment = this.getSegment(segmentImsName, rootSegment);
        if (currSegment != null) {
            currSegment.setRemarksForField(remarksValue, fieldName);
        }
    }

    public void setFPindex(String fpIndex) {
        String dbAccessType = this.dbd.getAccess().getDbType().value();
        if (dbAccessType.equalsIgnoreCase("INDEX")) {
            if (fpIndex != null && fpIndex.equalsIgnoreCase("YES")) {
                this.dbd.getAccess().getIndex().setFpindex(YesnoType.Y);
            } else {
                this.dbd.getAccess().getIndex().setFpindex(null);
            }
        }
    }

    public YesnoType getFPindex() {
        YesnoType retVal = null;
        IndexType indexType = this.dbd.getAccess().getIndex();
        if (indexType != null) {
            retVal = indexType.getFpindex();
        }
        return retVal;
    }

    public void setXMLSchemaVersion(String version) {
        this.dbd.setXmlSchemaVersion(version);
    }

    public String getXMLSchemaVersion() {
        return this.dbd.getXmlSchemaVersion();
    }

    public void setHidamDataset(List<HidamDataSetModel> values) throws ModelException {
        if (this.dbd.getAccess() == null) {
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1601"));
        }
        String dbAccType = this.dbd.getAccess().getDbType().toString();
        if (dbAccType.equalsIgnoreCase("HDAM")) {
            this.dbd.getAccess().getHdam().getDataSetContainer().getDataSet().clear();
        } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
            this.dbd.getAccess().getHidam().getDataSetContainer().getDataSet().clear();
        } else {
            Object[] dbError = new String[]{dbAccType};
            throw new ModelException(WorkbenchModelBundle.getError().getString("DHB1602", dbError));
        }
        int i = 0;
        while (i < values.size()) {
            HidamDataSetModel value = values.get(i);
            if (dbAccType.equalsIgnoreCase("HDAM")) {
                this.dbd.getAccess().getHdam().getDataSetContainer().getDataSet().add(value.getDataSet());
            } else if (dbAccType.equalsIgnoreCase("HIDAM")) {
                this.dbd.getAccess().getHidam().getDataSetContainer().getDataSet().add(value.getDataSet());
            }
            ++i;
        }
    }
}

