/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.workflow.field;

import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FieldImportWorkflowPopulateMetadataJob
extends Job {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldImportWorkflowController wfController;
    private IProgressMonitor monitor;

    public FieldImportWorkflowPopulateMetadataJob(FieldImportWorkflowController wfController) {
        super(WorkbenchModelBundle.getLabel().getString("WFM_TITLE"));
        this.wfController = wfController;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.monitor = monitor;
            int numDbds = this.wfController.getNumDBDs();
            int lastDbdFetchedIx = this.wfController.getLastDbdFetchedIx();
            monitor.beginTask(WorkbenchModelBundle.getLabel().getString("WFM_READING_DBD_METADATA"), numDbds - (lastDbdFetchedIx + 1));
            while (lastDbdFetchedIx + 1 < numDbds) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    this.wfController.fetchDbdsIntoMemory();
                    int previousDbdFetchedIx = lastDbdFetchedIx;
                    lastDbdFetchedIx = this.wfController.getLastDbdFetchedIx();
                    monitor.worked(lastDbdFetchedIx - previousDbdFetchedIx);
                    continue;
                }
                catch (Throwable e) {
                    logger.error(e);
                }
                break;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }
}

