/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.workflow.field;

import com.ibm.im.ims.cam.walkers.util.DataStructureContainer;
import com.ibm.im.ims.metadata.dbd.Dbd;
import com.ibm.im.ims.metadata.raa.LanguageType;
import com.ibm.im.ims.metadata.workflow.field.FieldImportWorkflow;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBDRefType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDataStructureType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSelectedDataStructureType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowStatusType;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class FieldImportWorkflowModelUtil {
    private static final String WORKFLOW_FILENAME = "ImportDataStructuresManager.wfm";
    public static final String WORKFLOW_ROOT_FOLDER = "WFM";
    private static final String WORKFLOW_DBDS_FOLDER = "WFDBDs";
    private static final String WORKFLOW_ORIG_DBDS_FOLDER = "ORIGDBDs";
    private static final String WORKFLOW_DS_FOLDER = "WFDS";
    private static final String WORKFLOW_DBD_EXT = ".xml";

    public static FieldImportWorkflow unmarshallWorkflow(URI fileURI) throws JAXBException, MalformedURLException, CoreException {
        JAXBContext context = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.workflow.field", (ClassLoader)FieldImportWorkflow.class.getClassLoader());
        Unmarshaller unmarshaller = context.createUnmarshaller();
        File workflowFile = new File(fileURI);
        FieldImportWorkflow workflow = (FieldImportWorkflow)unmarshaller.unmarshal(workflowFile);
        return workflow;
    }

    public static FieldImportWorkflow unmarshallWorkflow(String projectName) throws JAXBException, MalformedURLException, CoreException {
        IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile(projectName);
        FieldImportWorkflow workflow = FieldImportWorkflowModelUtil.unmarshallWorkflow(wfFile.getLocationURI());
        return workflow;
    }

    public static HashSet<String> getDsFileNames(String projectName, String dbdName) throws CoreException {
        IFolder wfDBDNameFolder;
        IFolder wfDsFolder;
        HashSet<String> retVal = new HashSet<String>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder wfRootFolder = project.getFolder(WORKFLOW_ROOT_FOLDER);
        if (!wfRootFolder.exists()) {
            wfRootFolder.create(true, true, null);
        }
        if (!(wfDsFolder = wfRootFolder.getFolder(WORKFLOW_DS_FOLDER)).exists()) {
            wfDsFolder.create(true, true, null);
        }
        if (!(wfDBDNameFolder = wfDsFolder.getFolder(dbdName)).exists()) {
            wfDBDNameFolder.create(true, true, null);
        } else {
            IResource[] containedResources = wfDBDNameFolder.members();
            int i = 0;
            while (i < containedResources.length) {
                if (containedResources[i] instanceof IFile) {
                    retVal.add(containedResources[i].getName());
                }
                ++i;
            }
        }
        return retVal;
    }

    public static IFolder getDSFolder(String projectName, String dbdName) throws CoreException {
        IFolder wfDsFolder;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder wfRootFolder = project.getFolder(WORKFLOW_ROOT_FOLDER);
        if (!wfRootFolder.exists()) {
            wfRootFolder.create(true, true, null);
        }
        if (!(wfDsFolder = wfRootFolder.getFolder(WORKFLOW_DS_FOLDER)).exists()) {
            wfDsFolder.create(true, true, null);
        }
        IFolder wfDBDNameFolder = wfDsFolder.getFolder(dbdName);
        return wfDBDNameFolder;
    }

    public static IFile getDsFile(String projectName, String dbdName, String fileName) throws CoreException {
        IFolder wfDBDNameFolder = FieldImportWorkflowModelUtil.getDSFolder(projectName, dbdName);
        IFile retVal = null;
        if (!wfDBDNameFolder.exists()) {
            wfDBDNameFolder.create(true, true, null);
        } else {
            IResource[] containedResources = wfDBDNameFolder.members();
            int i = 0;
            while (i < containedResources.length) {
                if (containedResources[i] instanceof IFile && containedResources[i].getName().equals(fileName)) {
                    retVal = (IFile)containedResources[i];
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public static DataStructureContainer updateDSContainerWithUniqueFileName(String projectName, String dbdName, DataStructureContainer dsContainer) throws CoreException {
        HashSet<String> existingDsFileNames = FieldImportWorkflowModelUtil.getDsFileNames(projectName, dbdName);
        String fileName = null;
        fileName = dsContainer.getLanguage() == LanguageType.COBOL ? dsContainer.getName() + ".cpy" : dsContainer.getName() + ".inc";
        if (existingDsFileNames.contains(fileName)) {
            boolean notNamed = true;
            int i = 1;
            do {
                if (!existingDsFileNames.contains(fileName = dsContainer.getLanguage() == LanguageType.COBOL ? dsContainer.getName() + "_" + i + ".cpy" : dsContainer.getName() + "_" + i + ".inc")) {
                    notNamed = false;
                    continue;
                }
                ++i;
            } while (notNamed);
        }
        dsContainer.setFileName(fileName);
        return dsContainer;
    }

    public static void saveDsFile(String projectName, String dbdName, DataStructureContainer dsContainer) throws CoreException, IOException {
        IFolder wfDBDNameFolder;
        IFolder wfDsFolder;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder wfRootFolder = project.getFolder(WORKFLOW_ROOT_FOLDER);
        if (!wfRootFolder.exists()) {
            wfRootFolder.create(true, true, null);
        }
        if (!(wfDsFolder = wfRootFolder.getFolder(WORKFLOW_DS_FOLDER)).exists()) {
            wfDsFolder.create(true, true, null);
        }
        if (!(wfDBDNameFolder = wfDsFolder.getFolder(dbdName)).exists()) {
            wfDBDNameFolder.create(true, true, null);
        }
        IFile file = wfDBDNameFolder.getFile(dsContainer.getFileName());
        file.create((InputStream)new ByteArrayInputStream(dsContainer.getSource().getBytes()), true, null);
    }

    public static void deleteDSFile(String projectName, String dbdName, String fileName) throws CoreException, IOException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder wfRootFolder = project.getFolder(WORKFLOW_ROOT_FOLDER);
        if (!wfRootFolder.exists()) {
            return;
        }
        IFolder wfDsFolder = wfRootFolder.getFolder(WORKFLOW_DS_FOLDER);
        if (!wfDsFolder.exists()) {
            return;
        }
        IFolder wfDBDNameFolder = wfDsFolder.getFolder(dbdName);
        if (!wfDBDNameFolder.exists()) {
            return;
        }
        IFile file = wfDBDNameFolder.getFile(fileName);
        if (file.exists()) {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IFile getFieldImportWorkflowFile(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile retVal = project.getFile((IPath)new Path(WORKFLOW_FILENAME));
        return retVal;
    }

    public static boolean isProjectWorkflowEnabled(String projectName) {
        boolean retVal = false;
        IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile(projectName);
        if (wfFile.exists()) {
            retVal = true;
        }
        return retVal;
    }

    public static IFile getDbdWorkflowFile(String projectName, String dbdName) throws CoreException {
        IFolder wfDbdsFolder;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder wfRootFolder = project.getFolder(WORKFLOW_ROOT_FOLDER);
        if (!wfRootFolder.exists()) {
            wfRootFolder.create(true, true, null);
        }
        if (!(wfDbdsFolder = wfRootFolder.getFolder(WORKFLOW_DBDS_FOLDER)).exists()) {
            wfDbdsFolder.create(true, true, null);
        }
        IFile retVal = wfDbdsFolder.getFile(dbdName + WORKFLOW_DBD_EXT);
        return retVal;
    }

    public static IFile getOriginalDbdFile(String projectName, String dbdName) throws CoreException {
        IFolder wfDbdsFolder;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder wfRootFolder = project.getFolder(WORKFLOW_ROOT_FOLDER);
        if (!wfRootFolder.exists()) {
            wfRootFolder.create(true, true, null);
        }
        if (!(wfDbdsFolder = wfRootFolder.getFolder(WORKFLOW_ORIG_DBDS_FOLDER)).exists()) {
            wfDbdsFolder.create(true, true, null);
        }
        IFile retVal = wfDbdsFolder.getFile(dbdName + ".dbd");
        return retVal;
    }

    public static void marshallWorkflow(FieldImportWorkflow workflow, String projectName, boolean marshallDBDs) throws JAXBException, CoreException {
        IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile(projectName);
        FieldImportWorkflowModelUtil.marshallWorkflow(workflow, wfFile.getLocationURI());
        wfFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        if (marshallDBDs) {
            for (WorkflowDBDRefType dbdRef : workflow.getWorkflowDBDRef()) {
                WorkflowDBD workflowDBD = dbdRef.getReference();
                if (workflowDBD == null) continue;
                FieldImportWorkflowModelUtil.marshallWorkflowDBD(workflowDBD, projectName);
            }
        }
    }

    public static void marshallWorkflow(FieldImportWorkflow workflow, URI fileURI) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.workflow.field", (ClassLoader)FieldImportWorkflow.class.getClassLoader());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)workflow, new File(fileURI));
    }

    public static WorkflowDBD unmarshallWorkflowDBD(String dbdName, String projectName) throws CoreException, JAXBException {
        IFile wfDbdFile = FieldImportWorkflowModelUtil.getDbdWorkflowFile(projectName, dbdName);
        return FieldImportWorkflowModelUtil.unmarshallWorkflowDBD(wfDbdFile.getLocationURI());
    }

    public static WorkflowDBD unmarshallWorkflowDBD(URI fileURI) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.workflow.field", (ClassLoader)WorkflowDBD.class.getClassLoader());
        Unmarshaller unmarshaller = context.createUnmarshaller();
        WorkflowDBD workflowDBD = (WorkflowDBD)unmarshaller.unmarshal(new File(fileURI));
        return workflowDBD;
    }

    public static void marshallWorkflowDBD(WorkflowDBD workflowDBD, String projectName) throws JAXBException, CoreException {
        IFile wfDbdFile = FieldImportWorkflowModelUtil.getDbdWorkflowFile(projectName, workflowDBD.getName());
        FieldImportWorkflowModelUtil.marshallWorkflowDBD(workflowDBD, wfDbdFile.getLocationURI());
        wfDbdFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void marshallWorkflowDBD(WorkflowDBD workflowDBD, URI fileURI) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.workflow.field", (ClassLoader)WorkflowDBD.class.getClassLoader());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)workflowDBD, new File(fileURI));
    }

    public static void marshallOriginalDBD(DbdModel dbdModel, String projectName) throws JAXBException, CoreException {
        IFile origDbdFile = FieldImportWorkflowModelUtil.getOriginalDbdFile(projectName, dbdModel.getDBDName());
        FieldImportWorkflowModelUtil.marshallOriginalDBD(dbdModel, origDbdFile.getLocationURI());
        origDbdFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void marshallOriginalDBD(DbdModel dbdModel, URI fileURI) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.dbd", (ClassLoader)Dbd.class.getClassLoader());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)dbdModel.getDbd(), new File(fileURI));
    }

    public static DbdModel unmarshallOriginalDBD(String dbdName, String projectName) throws JAXBException, CoreException, ModelException {
        IFile origDbdFile = FieldImportWorkflowModelUtil.getOriginalDbdFile(projectName, dbdName);
        return FieldImportWorkflowModelUtil.unmarshallOriginalDBD(origDbdFile.getLocationURI());
    }

    public static DbdModel unmarshallOriginalDBD(URI fileURI) throws JAXBException, CoreException, ModelException {
        JAXBContext context = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.dbd", (ClassLoader)Dbd.class.getClassLoader());
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Dbd origDbd = (Dbd)unmarshaller.unmarshal(new File(fileURI));
        DbdModel origDbdModel = new DbdModel(origDbd);
        return origDbdModel;
    }

    public static void updateParentChildRelationships(FieldImportWorkflow workflow) throws JAXBException {
        if (workflow.getWorkflowDBDRef() != null && !workflow.getWorkflowDBDRef().isEmpty()) {
            for (WorkflowDBDRefType dbdRef : workflow.getWorkflowDBDRef()) {
                WorkflowDBD workflowDBD = dbdRef.getReference();
                if (workflowDBD == null) continue;
                FieldImportWorkflowModelUtil.updateParentChildRelationships(workflow, workflowDBD);
            }
        }
    }

    public static void updateParentChildRelationships(FieldImportWorkflow workflow, WorkflowDBD workflowDBD) {
        if (workflowDBD == null) {
            return;
        }
        if (workflow != null) {
            workflowDBD.setParent(workflow);
        }
        if (workflowDBD.getWorkflowSegment() != null && !workflowDBD.getWorkflowSegment().isEmpty()) {
            for (WorkflowSegmentType workflowSegment : workflowDBD.getWorkflowSegment()) {
                workflowSegment.setParent(workflowDBD);
                FieldImportWorkflowModelUtil.updateParentChildRelationships(workflowSegment);
            }
        }
    }

    public static void updateParentChildRelationships(WorkflowSegmentType workflowSegment) {
        if (workflowSegment == null) {
            return;
        }
        if (workflowSegment.getWorkflowMapCase() != null && !workflowSegment.getWorkflowMapCase().isEmpty()) {
            for (WorkflowMapCaseType mapCase : workflowSegment.getWorkflowMapCase()) {
                mapCase.setParent(workflowSegment);
                FieldImportWorkflowModelUtil.updateParentChildRelationships(mapCase);
            }
        }
    }

    public static void updateParentChildRelationships(WorkflowMapCaseType mapCase) {
        if (mapCase == null) {
            return;
        }
        if (mapCase.getWorkflowSelectedDataStructure() != null) {
            mapCase.getWorkflowSelectedDataStructure().setParent(mapCase);
        }
    }

    public static boolean allMapCasesHaveSelectedDS(WorkflowSegmentType workflowSegment) {
        for (WorkflowMapCaseType workflowMapCase : workflowSegment.getWorkflowMapCase()) {
            WorkflowSelectedDataStructureType workflowSelectedDS = workflowMapCase.getWorkflowSelectedDataStructure();
            if (workflowSelectedDS != null && workflowSelectedDS.getName() != null && !workflowSelectedDS.getName().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean hasMultipleCandidateDS(WorkflowSegmentType workflowSegment) {
        int retVal = 0;
        List<WorkflowDataStructureType> candidateDSs = workflowSegment.getWorkflowCandidateDataStructure();
        retVal = candidateDSs.size();
        return retVal > 1;
    }

    public static int getCandidateDSCount(WorkflowSegmentType workflowSegment) {
        int retVal = 0;
        List<WorkflowDataStructureType> candidateDSs = workflowSegment.getWorkflowCandidateDataStructure();
        retVal = candidateDSs.size();
        return retVal;
    }

    public static int getManuallyImportedCandidateDSCount(WorkflowSegmentType workflowSegment) {
        int manuallyImported = 0;
        List<WorkflowDataStructureType> candidateDSs = workflowSegment.getWorkflowCandidateDataStructure();
        for (WorkflowDataStructureType candidateDS : candidateDSs) {
            if (!candidateDS.isManuallyImported().booleanValue()) continue;
            ++manuallyImported;
        }
        return manuallyImported;
    }

    public static boolean isEligibleForAutoImport(WorkflowSegmentType workflowSegment) {
        boolean retVal = false;
        if (FieldImportWorkflowModelUtil.getCandidateDSCount(workflowSegment) == 1 && FieldImportWorkflowModelUtil.getMapCaseCount(workflowSegment) == 1 && FieldImportWorkflowModelUtil.getFirstMapCase(workflowSegment).getWorkflowSelectedDataStructure() == null) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isEligibleForDiscovery(WorkflowSegmentType workflowSegment) {
        boolean retVal = false;
        if (FieldImportWorkflowModelUtil.getSegmentStatusAsInt(workflowSegment.getStatus()) > FieldImportWorkflowModelUtil.getSegmentStatusAsInt(WorkflowStatusType.DATA_STRUCTURE_SELECTED)) {
            retVal = true;
        }
        return retVal;
    }

    public static int getMapCaseCount(WorkflowSegmentType workflowSegment) {
        int retVal = 0;
        List<WorkflowMapCaseType> mapCases = workflowSegment.getWorkflowMapCase();
        if (mapCases != null) {
            retVal = mapCases.size();
        }
        return retVal;
    }

    public static WorkflowSegmentType getWorkflowSegmentByName(WorkflowDBD workflowDBD, String segmentName) {
        WorkflowSegmentType workflowSegment = null;
        for (WorkflowSegmentType nextWorkflowSegment : workflowDBD.getWorkflowSegment()) {
            if (!nextWorkflowSegment.getName().equalsIgnoreCase(segmentName)) continue;
            workflowSegment = nextWorkflowSegment;
            break;
        }
        return workflowSegment;
    }

    public static void addCandidateDS(WorkflowSegmentType workflowSegment, DataStructureContainer dsContainer, boolean manuallyImported) {
        List<WorkflowDataStructureType> candidateDSs = workflowSegment.getWorkflowCandidateDataStructure();
        WorkflowDataStructureType newCandidateDS = new WorkflowDataStructureType();
        newCandidateDS.setName(dsContainer.getName());
        newCandidateDS.setLocation(dsContainer.getFileName());
        newCandidateDS.setManuallyImported(manuallyImported);
        candidateDSs.add(newCandidateDS);
        Collections.sort(candidateDSs, new Comparator<WorkflowDataStructureType>(){

            @Override
            public int compare(WorkflowDataStructureType t1, WorkflowDataStructureType t2) {
                return t1.getName().compareTo(t2.getName());
            }
        });
    }

    public static boolean isSelectedDSValidAfterDiscovery(WorkflowMapCaseType workflowMapCase, List<DataStructureContainer> discoveredDSs) {
        if (workflowMapCase.getWorkflowSelectedDataStructure() == null) {
            return true;
        }
        WorkflowSelectedDataStructureType selectedDS = workflowMapCase.getWorkflowSelectedDataStructure();
        List<WorkflowDataStructureType> candidateDSs = workflowMapCase.getParent().getWorkflowCandidateDataStructure();
        for (WorkflowDataStructureType workflowDS : candidateDSs) {
            if (!workflowDS.getName().equals(selectedDS.getName()) || !workflowDS.isManuallyImported().booleanValue()) continue;
            return true;
        }
        for (DataStructureContainer discoveredDS : discoveredDSs) {
            if (!discoveredDS.getName().equals(selectedDS.getName())) continue;
            return true;
        }
        return false;
    }

    public static List<WorkflowDBD> getSelectedWorkflowDBDs(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        HashMap<String, WorkflowDBD> workflowDBDMap = new HashMap<String, WorkflowDBD>();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        for (Object selected : structuredSelection) {
            WorkflowDBD workflowDBD = null;
            if (selected instanceof WorkflowDBD) {
                workflowDBD = (WorkflowDBD)selected;
            } else if (selected instanceof WorkflowSegmentType) {
                WorkflowSegmentType workflowSegment = (WorkflowSegmentType)selected;
                workflowDBD = workflowSegment.getParent();
            } else if (selected instanceof WorkflowMapCaseType) {
                WorkflowMapCaseType workflowMapCase = (WorkflowMapCaseType)selected;
                WorkflowSegmentType workflowSegment = workflowMapCase.getParent();
                workflowDBD = workflowSegment.getParent();
            }
            if (workflowDBD == null || workflowDBDMap.containsKey(workflowDBD.getName())) continue;
            workflowDBDMap.put(workflowDBD.getName(), workflowDBD);
        }
        return new ArrayList<WorkflowDBD>(workflowDBDMap.values());
    }

    public static int getSegmentStatusAsInt(WorkflowStatusType status) {
        int retVal = -1;
        switch (status) {
            case SEGM_NOT_FOUND: {
                retVal = 6;
                break;
            }
            case NO_DATA_STRUCTURES_FOUND: {
                retVal = 5;
                break;
            }
            case MULTIPLE_DATA_STRUCTURES_FOUND: {
                retVal = 4;
                break;
            }
            case DBD_JUST_IMPORTED: {
                retVal = 3;
                break;
            }
            case DATA_STRUCTURE_SELECTED: {
                retVal = 2;
                break;
            }
            case TESTED_WITH_LOCAL_METADATA: {
                retVal = 1;
                break;
            }
            case TESTED_WITH_CATALOG_METADATA: {
                retVal = 0;
                break;
            }
        }
        return retVal;
    }

    public static WorkflowStatusType getSegmentStatusFromInt(int intValue) {
        WorkflowStatusType retVal = null;
        switch (intValue) {
            case 6: {
                retVal = WorkflowStatusType.SEGM_NOT_FOUND;
                break;
            }
            case 5: {
                retVal = WorkflowStatusType.NO_DATA_STRUCTURES_FOUND;
                break;
            }
            case 4: {
                retVal = WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND;
                break;
            }
            case 3: {
                retVal = WorkflowStatusType.DBD_JUST_IMPORTED;
                break;
            }
            case 2: {
                retVal = WorkflowStatusType.DATA_STRUCTURE_SELECTED;
                break;
            }
            case 1: {
                retVal = WorkflowStatusType.TESTED_WITH_LOCAL_METADATA;
                break;
            }
            case 0: {
                retVal = WorkflowStatusType.TESTED_WITH_CATALOG_METADATA;
                break;
            }
        }
        return retVal;
    }

    public static int getEndSegmentStatusAsInt() {
        return FieldImportWorkflowModelUtil.getSegmentStatusAsInt(WorkflowStatusType.TESTED_WITH_CATALOG_METADATA);
    }

    public static int getStartSegmentStatusAsInt() {
        return FieldImportWorkflowModelUtil.getSegmentStatusAsInt(WorkflowStatusType.DBD_JUST_IMPORTED);
    }

    public static WorkflowMapCaseType getFirstMapCase(WorkflowSegmentType workflowSegment) {
        WorkflowMapCaseType retVal = null;
        List<WorkflowMapCaseType> mapCases = workflowSegment.getWorkflowMapCase();
        if (mapCases != null && !mapCases.isEmpty()) {
            retVal = mapCases.get(0);
        }
        return retVal;
    }

    public static WorkflowDataStructureType getFirstCandidateDS(WorkflowSegmentType workflowSegment) {
        WorkflowDataStructureType retVal = null;
        List<WorkflowDataStructureType> candidateDSs = workflowSegment.getWorkflowCandidateDataStructure();
        if (candidateDSs != null && !candidateDSs.isEmpty()) {
            retVal = candidateDSs.get(0);
        }
        return retVal;
    }
}

