/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.workflow.field;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.im.ims.cam.walkers.util.DataStructureContainer;
import com.ibm.im.ims.metadata.workflow.field.FieldImportWorkflow;
import com.ibm.im.ims.metadata.workflow.field.RaaServerType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBDRefType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDataStructureType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSelectedDataStructureType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowStatusType;
import com.ibm.im.ims.workbench.controller.importer.datastructure.DSSA;
import com.ibm.im.ims.workbench.controller.importer.datastructure.ImportDsToDbdController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowControllerContainer;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowLock;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowPopulateMetadataJob;
import com.ibm.im.ims.workbench.controller.workflow.field.IFieldImportWorkflowEventListener;
import com.ibm.im.ims.workbench.controller.workflow.field.WFMStateChangeException;
import com.ibm.im.ims.workbench.imsdb.connections.utils.JDBCHelper;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.IFieldContainer;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ClearJDBCCacheJob;
import com.ibm.im.ims.workbench.model.utilities.DatabaseViewGeneratorException;
import com.ibm.im.ims.workbench.model.utilities.FieldImportWorkflowUtil;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.NOOPJobChangeListener;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class FieldImportWorkflowController
implements IWorkbenchListener {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static final int FETCH_SIZE = 100;
    private String projectName;
    private FieldImportWorkflow workflow;
    private int lastDbdFetched;
    private List<WorkflowDBD> workflowDBDs;
    private ConcurrentHashMap<String, FieldImportWorkflowLock> workflowDBDLocks = new ConcurrentHashMap();
    private FieldImportWorkflowLock populateWorkflowMetataLock = new FieldImportWorkflowLock();
    private List<IFieldImportWorkflowEventListener> workflowEventListeners;
    private FieldImportWorkflowPopulateMetadataJob populateWorkflowMetadataJob;
    private String projectUUID;
    public static final String UNMAPPED = "Unmapped";
    public static final String MAP_CASE_NAME_SEPARATOR = "/";
    private ResourceChangeListener resourceChangeListener;

    public FieldImportWorkflowController() {
        this.workflowDBDs = new ArrayList<WorkflowDBD>();
        this.addWorkbenchListeners();
    }

    public FieldImportWorkflowController(String projectName, IFile workflowFile, String projectUUID) {
        this();
        this.projectName = projectName;
        this.projectUUID = projectUUID;
        try {
            this.workflow = FieldImportWorkflowModelUtil.unmarshallWorkflow(workflowFile.getLocationURI());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        this.lastDbdFetched = -1;
        try {
            this.fetchDbdsIntoMemory();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public FieldImportWorkflowController(String projectName) {
        this();
        this.projectName = projectName;
        try {
            this.projectUUID = ProjectTreeFileHelper.getUUIDForProject(projectName, "com.ibm.im.ims.workbench");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        try {
            if (FieldImportWorkflowModelUtil.isProjectWorkflowEnabled(projectName)) {
                this.workflow = FieldImportWorkflowModelUtil.unmarshallWorkflow(projectName);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void createEmptyWorkflow() {
        this.workflow = new FieldImportWorkflow();
        this.workflow.setRaaServer(new RaaServerType());
    }

    public void fetchDbdsIntoMemory() throws JAXBException, CoreException {
        List<WorkflowDBDRefType> dbdRefs = this.workflow.getWorkflowDBDRef();
        int totalDbdRefs = dbdRefs.size();
        if (this.lastDbdFetched < totalDbdRefs - 1) {
            int firstFetched = this.lastDbdFetched + 1;
            while (this.lastDbdFetched - firstFetched + 1 < 100 && this.lastDbdFetched < totalDbdRefs - 1) {
                ++this.lastDbdFetched;
                WorkflowDBDRefType currDbdRef = dbdRefs.get(this.lastDbdFetched);
                WorkflowDBD currWfDbd = FieldImportWorkflowModelUtil.unmarshallWorkflowDBD(currDbdRef.getRefName(), this.projectName);
                FieldImportWorkflowModelUtil.updateParentChildRelationships(this.workflow, currWfDbd);
                this.workflowDBDs.add(currWfDbd);
            }
            this.notifyDBDsAdded();
        }
    }

    public int getNumDBDs() {
        return this.workflow.getWorkflowDBDRef().size();
    }

    public int getLastDbdFetchedIx() {
        return this.lastDbdFetched;
    }

    public void addDBDsToWorkflow(Object[] dbdNames, IProgressMonitor monitor) throws MalformedURLException, JAXBException, CoreException, ModelException {
        List<WorkflowDBDRefType> dbdRefList = this.workflow.getWorkflowDBDRef();
        Object[] objectArray = dbdNames;
        int n = dbdNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object dbdName = objectArray[n2];
            IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile(this.projectName, (String)dbdName);
            DbdModel dbd = new DbdModel(dbdFile.getContents());
            WorkflowDBDRefType currRef = new WorkflowDBDRefType();
            currRef.setRefName((String)dbdName);
            dbdRefList.add(currRef);
            WorkflowDBD currWfDbd = new WorkflowDBD();
            currWfDbd.setName((String)dbdName);
            this.populateInitialWorkflowDBDSegments(currWfDbd, dbd);
            FieldImportWorkflowModelUtil.marshallWorkflowDBD(currWfDbd, this.projectName);
            if (this.workflowDBDs != null) {
                FieldImportWorkflowModelUtil.updateParentChildRelationships(this.workflow, currWfDbd);
                this.workflowDBDs.add(currWfDbd);
            }
            monitor.worked(1);
            ++n2;
        }
        this.notifyDBDsAdded();
    }

    public void refreshDSEConnections() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        Vector profiles = JDBCHelper.getIMSConnectionProfilesBasedOnProject((String)this.projectName);
        if (profiles.size() > 0) {
            ClearJDBCCacheJob clearJob = new ClearJDBCCacheJob("Clearing JDBC metadata cache for connections using metadata from project: " + this.projectName, profiles);
            logger.finer("Scheduling job to clear the JDBC driver's metadata cache for connections using metadata from project: " + this.projectName);
            clearJob.schedule();
        }
    }

    public void removeDBDsFromWorkflow(Object[] selectedWorkflowDBDs, IProgressMonitor monitor) throws MalformedURLException, JAXBException, CoreException, ModelException {
        List<WorkflowDBDRefType> dbdRefList = this.workflow.getWorkflowDBDRef();
        Object[] objectArray = selectedWorkflowDBDs;
        int n = selectedWorkflowDBDs.length;
        int n2 = 0;
        while (n2 < n) {
            WorkflowDBDRefType dbdRefType;
            IFile dbdWfmFile;
            IFile origDbdFile;
            IFile dbdFile;
            Object workflowDBD = objectArray[n2];
            String dbdName = ((WorkflowDBD)workflowDBD).getName();
            if (this.workflowDBDs != null) {
                this.workflowDBDs.remove(workflowDBD);
            }
            if ((dbdFile = ProjectTreeFileHelper.getDbdMetadataFile(this.projectName, dbdName)).exists()) {
                dbdFile.delete(true, monitor);
            }
            if ((origDbdFile = FieldImportWorkflowModelUtil.getOriginalDbdFile(this.projectName, dbdName)).exists()) {
                origDbdFile.delete(true, monitor);
            }
            if ((dbdWfmFile = FieldImportWorkflowModelUtil.getDbdWorkflowFile(this.projectName, dbdName)).exists()) {
                dbdWfmFile.delete(true, monitor);
            }
            HashSet<String> dsFileNames = FieldImportWorkflowModelUtil.getDsFileNames(this.projectName, dbdName);
            this.deleteWfmDSFile(this.projectName, dbdName, dsFileNames, monitor);
            IFolder dbdDsFolder = FieldImportWorkflowModelUtil.getDSFolder(this.projectName, dbdName);
            if (dbdDsFolder.exists()) {
                dbdDsFolder.delete(true, monitor);
            }
            if ((dbdRefType = this.getWorkflowDBDRefType(dbdRefList, dbdName)) != null) {
                dbdRefList.remove(dbdRefType);
            }
            monitor.worked(1);
            ++n2;
        }
        this.notifyDBDsAdded();
    }

    private WorkflowDBDRefType getWorkflowDBDRefType(List<WorkflowDBDRefType> dbdRefList, String dbdName) {
        WorkflowDBDRefType retVal = null;
        int i = 0;
        while (i < dbdRefList.size()) {
            WorkflowDBDRefType currentDBDRef = dbdRefList.get(i);
            if (currentDBDRef.getRefName().equals(dbdName)) {
                retVal = currentDBDRef;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private void deleteWfmDSFile(String projectName, String dbdName, HashSet<String> dsFileNames, IProgressMonitor monitor) throws CoreException {
        Iterator<String> iter = dsFileNames.iterator();
        while (iter.hasNext()) {
            IFile wfmDsFile = FieldImportWorkflowModelUtil.getDsFile(projectName, dbdName, iter.next());
            if (!wfmDsFile.exists()) continue;
            wfmDsFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void populateInitialWorkflowDBDSegments(WorkflowDBD wfDbd, DbdModel dbd) throws CoreException, ModelException {
        List<WorkflowSegmentType> segList = wfDbd.getWorkflowSegment();
        this.recursPopulateWfDbdSegments(segList, dbd.getRootSegment());
    }

    private void recursPopulateWfDbdSegments(List<WorkflowSegmentType> segList, SegmentModel segment) {
        if (segment == null) {
            return;
        }
        WorkflowSegmentType wfSeg = new WorkflowSegmentType();
        DBDConstants dbdAccessType = segment.getDbdModel().getAccessType();
        if (dbdAccessType == DBDConstants.GSAM) {
            wfSeg.setName(segment.getName());
        } else {
            wfSeg.setName(segment.getImsName());
        }
        wfSeg.setStatus(WorkflowStatusType.DBD_JUST_IMPORTED);
        WorkflowMapCaseType currMapCase = new WorkflowMapCaseType();
        currMapCase.setName(UNMAPPED);
        wfSeg.getWorkflowMapCase().add(currMapCase);
        Iterator<MappingModel> mapIter = segment.getMappingList();
        while (mapIter.hasNext()) {
            MappingModel map = mapIter.next();
            Iterator<MappingCaseModel> mapCaseIter = map.getMappingCases();
            while (mapCaseIter.hasNext()) {
                MappingCaseModel mapCase = mapCaseIter.next();
                currMapCase = new WorkflowMapCaseType();
                currMapCase.setName(this.createMapCaseName(map, mapCase));
                wfSeg.getWorkflowMapCase().add(currMapCase);
            }
        }
        segList.add(wfSeg);
        List<SegmentModel> childSegs = segment.getChildSegments();
        for (SegmentModel currChildSeg : childSegs) {
            this.recursPopulateWfDbdSegments(segList, currChildSeg);
        }
    }

    private String createMapCaseName(MappingModel map, MappingCaseModel mapCase) {
        return map.getName() + MAP_CASE_NAME_SEPARATOR + mapCase.getName();
    }

    public void mapCasesEdited(WorkflowSegmentType wfSeg, SegmentModel segment) {
        List<WorkflowMapCaseType> origMapCaseTypeList = this.cloneMapCaseTypeList(wfSeg.getWorkflowMapCase());
        wfSeg.getWorkflowMapCase().clear();
        WorkflowMapCaseType currMapCase = new WorkflowMapCaseType();
        currMapCase.setName(UNMAPPED);
        WorkflowMapCaseType origMapCaseType = this.getOrigMapCaseType(origMapCaseTypeList, UNMAPPED);
        if (origMapCaseType != null) {
            currMapCase.setWorkflowSelectedDataStructure(origMapCaseType.getWorkflowSelectedDataStructure());
        }
        wfSeg.getWorkflowMapCase().add(currMapCase);
        currMapCase.setParent(wfSeg);
        Iterator<MappingModel> mapIter = segment.getMappingList();
        while (mapIter.hasNext()) {
            MappingModel map = mapIter.next();
            Iterator<MappingCaseModel> mapCaseIter = map.getMappingCases();
            while (mapCaseIter.hasNext()) {
                MappingCaseModel mapCase = mapCaseIter.next();
                currMapCase = new WorkflowMapCaseType();
                currMapCase.setName(this.createMapCaseName(map, mapCase));
                origMapCaseType = this.getOrigMapCaseType(origMapCaseTypeList, currMapCase.getName());
                if (origMapCaseType != null) {
                    currMapCase.setWorkflowSelectedDataStructure(origMapCaseType.getWorkflowSelectedDataStructure());
                }
                wfSeg.getWorkflowMapCase().add(currMapCase);
                currMapCase.setParent(wfSeg);
            }
        }
    }

    private WorkflowMapCaseType getOrigMapCaseType(List<WorkflowMapCaseType> list, String mapCaseName) {
        WorkflowMapCaseType retVal = null;
        for (WorkflowMapCaseType workflowMapCaseType : list) {
            if (!workflowMapCaseType.getName().equals(mapCaseName)) continue;
            retVal = workflowMapCaseType;
            break;
        }
        return retVal;
    }

    private List<WorkflowMapCaseType> cloneMapCaseTypeList(List<WorkflowMapCaseType> origList) {
        ArrayList<WorkflowMapCaseType> retVal = new ArrayList<WorkflowMapCaseType>(origList.size());
        for (WorkflowMapCaseType currMapCaseType : origList) {
            retVal.add(currMapCaseType);
        }
        return retVal;
    }

    public void saveWorkflowDBD(WorkflowDBD workflowDBD) throws JAXBException, CoreException {
        FieldImportWorkflowModelUtil.marshallWorkflowDBD(workflowDBD, this.projectName);
    }

    public void saveWorkflow() throws MalformedURLException, JAXBException, CoreException {
        FieldImportWorkflowModelUtil.marshallWorkflow(this.workflow, this.projectName, false);
    }

    public DataStructureContainer saveDatastructureFile(String dbdName, DataStructureContainer dsContainer) throws CoreException, IOException {
        if (!dsContainer.isTopLevel()) {
            dsContainer.makeTopLevel();
        }
        FieldImportWorkflowModelUtil.updateDSContainerWithUniqueFileName(this.projectName, dbdName, dsContainer);
        FieldImportWorkflowModelUtil.saveDsFile(this.projectName, dbdName, dsContainer);
        return dsContainer;
    }

    public void startPopulateWorkflowMetadataJob() {
        this.populateWorkflowMetataLock.acquireLock((IProgressMonitor)new NullProgressMonitor());
        this.populateWorkflowMetadataJob = new FieldImportWorkflowPopulateMetadataJob(this);
        this.populateWorkflowMetadataJob.addJobChangeListener(new NOOPJobChangeListener(){

            @Override
            public void done(IJobChangeEvent event) {
                FieldImportWorkflowController.this.populateWorkflowMetataLock.releaseLock(true);
            }
        });
        this.populateWorkflowMetadataJob.schedule();
    }

    public void stopPopulateWorkflowMetadataJob() {
        if (this.populateWorkflowMetadataJob == null) {
            return;
        }
        IProgressMonitor monitor = this.populateWorkflowMetadataJob.getMonitor();
        if (monitor != null) {
            monitor.setCanceled(true);
        }
        try {
            this.populateWorkflowMetadataJob.join();
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
        }
    }

    public void checkSegmentStatusChange(WorkflowSegmentType workflowSegment, WorkflowStatusType newWorkflowStatus) throws WFMStateChangeException {
        WorkflowStatusType currStatus = workflowSegment.getStatus();
        if (currStatus == WorkflowStatusType.DBD_JUST_IMPORTED) {
            if (newWorkflowStatus == WorkflowStatusType.NO_DATA_STRUCTURES_FOUND) {
                Object[] descriptionInserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.NO_DATA_STRUCTURES_FOUND)};
                String descriptionMsg = WorkbenchModelBundle.getDescription().getString("IDSWM_STATE_CHANGE_TO_NO_DS_FOUND", descriptionInserts);
                Object[] inserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DBD_JUST_IMPORTED), FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.NO_DATA_STRUCTURES_FOUND), descriptionMsg};
                throw new WFMStateChangeException(WorkbenchModelBundle.getDescription().getString("IDSWM_BAD_STATE_CHANGE_ERROR", inserts), WFMStateChangeException.ExceptionType.ERROR);
            }
            if (newWorkflowStatus == WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND) {
                Object[] descriptionInserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND)};
                String descriptionMsg = WorkbenchModelBundle.getDescription().getString("IDSWM_STATE_CHANGE_TO_MULTI_DS_FOUND", descriptionInserts);
                Object[] inserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DBD_JUST_IMPORTED), FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND), descriptionMsg};
                throw new WFMStateChangeException(WorkbenchModelBundle.getDescription().getString("IDSWM_BAD_STATE_CHANGE_ERROR", inserts), WFMStateChangeException.ExceptionType.ERROR);
            }
            if (newWorkflowStatus == WorkflowStatusType.DATA_STRUCTURE_SELECTED) {
                Object[] descriptionInserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DATA_STRUCTURE_SELECTED)};
                String descriptionMsg = WorkbenchModelBundle.getDescription().getString("IDSWM_STATE_CHANGE_TO_DS_SELECTED", descriptionInserts);
                Object[] inserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DBD_JUST_IMPORTED), FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DATA_STRUCTURE_SELECTED), descriptionMsg};
                throw new WFMStateChangeException(WorkbenchModelBundle.getDescription().getString("IDSWM_BAD_STATE_CHANGE_WARNING", inserts), WFMStateChangeException.ExceptionType.WARNING);
            }
        } else if (currStatus == WorkflowStatusType.DATA_STRUCTURE_SELECTED) {
            if (newWorkflowStatus == WorkflowStatusType.NO_DATA_STRUCTURES_FOUND) {
                Object[] descriptionInserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.NO_DATA_STRUCTURES_FOUND)};
                String descriptionMsg = WorkbenchModelBundle.getDescription().getString("IDSWM_STATE_CHANGE_TO_NO_DS_FOUND", descriptionInserts);
                Object[] inserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DATA_STRUCTURE_SELECTED), FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.NO_DATA_STRUCTURES_FOUND), descriptionMsg};
                throw new WFMStateChangeException(WorkbenchModelBundle.getDescription().getString("IDSWM_BAD_STATE_CHANGE_ERROR", inserts), WFMStateChangeException.ExceptionType.ERROR);
            }
            if (newWorkflowStatus == WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND) {
                Object[] descriptionInserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND)};
                String descriptionMsg = WorkbenchModelBundle.getDescription().getString("IDSWM_STATE_CHANGE_TO_MULTI_DS_FOUND", descriptionInserts);
                Object[] inserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DATA_STRUCTURE_SELECTED), FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND), descriptionMsg};
                throw new WFMStateChangeException(WorkbenchModelBundle.getDescription().getString("IDSWM_BAD_STATE_CHANGE_ERROR", inserts), WFMStateChangeException.ExceptionType.ERROR);
            }
        } else if (currStatus == WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND) {
            if (newWorkflowStatus == WorkflowStatusType.NO_DATA_STRUCTURES_FOUND) {
                Object[] descriptionInserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.NO_DATA_STRUCTURES_FOUND)};
                String descriptionMsg = WorkbenchModelBundle.getDescription().getString("IDSWM_STATE_CHANGE_TO_NO_DS_FOUND", descriptionInserts);
                Object[] inserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND), FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.NO_DATA_STRUCTURES_FOUND), descriptionMsg};
                throw new WFMStateChangeException(WorkbenchModelBundle.getDescription().getString("IDSWM_BAD_STATE_CHANGE_ERROR", inserts), WFMStateChangeException.ExceptionType.ERROR);
            }
            if (newWorkflowStatus == WorkflowStatusType.DATA_STRUCTURE_SELECTED) {
                Object[] descriptionInserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DATA_STRUCTURE_SELECTED)};
                String descriptionMsg = WorkbenchModelBundle.getDescription().getString("IDSWM_STATE_CHANGE_TO_DS_SELECTED", descriptionInserts);
                Object[] inserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND), FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DATA_STRUCTURE_SELECTED), descriptionMsg};
                throw new WFMStateChangeException(WorkbenchModelBundle.getDescription().getString("IDSWM_BAD_STATE_CHANGE_WARNING", inserts), WFMStateChangeException.ExceptionType.WARNING);
            }
        } else if (currStatus == WorkflowStatusType.NO_DATA_STRUCTURES_FOUND) {
            if (newWorkflowStatus == WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND) {
                Object[] descriptionInserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND)};
                String descriptionMsg = WorkbenchModelBundle.getDescription().getString("IDSWM_STATE_CHANGE_TO_MULTI_DS_FOUND", descriptionInserts);
                Object[] inserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.NO_DATA_STRUCTURES_FOUND), FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND), descriptionMsg};
                throw new WFMStateChangeException(WorkbenchModelBundle.getDescription().getString("IDSWM_BAD_STATE_CHANGE_ERROR", inserts), WFMStateChangeException.ExceptionType.ERROR);
            }
            if (newWorkflowStatus == WorkflowStatusType.DATA_STRUCTURE_SELECTED) {
                Object[] descriptionInserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DATA_STRUCTURE_SELECTED)};
                String descriptionMsg = WorkbenchModelBundle.getDescription().getString("IDSWM_STATE_CHANGE_TO_DS_SELECTED", descriptionInserts);
                Object[] inserts = new Object[]{FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.NO_DATA_STRUCTURES_FOUND), FieldImportWorkflowUtil.getTranslatedStatusText(WorkflowStatusType.DATA_STRUCTURE_SELECTED), descriptionMsg};
                throw new WFMStateChangeException(WorkbenchModelBundle.getDescription().getString("IDSWM_BAD_STATE_CHANGE_WARNING", inserts), WFMStateChangeException.ExceptionType.WARNING);
            }
        }
    }

    public void setSegmentStatus(WorkflowSegmentType workflowSegment, WorkflowStatusType workflowStatus) {
        WorkflowStatusType dbdStatusOld;
        workflowSegment.setStatus(workflowStatus);
        WorkflowDBD workflowDBD = workflowSegment.getParent();
        int statusDSSelected = FieldImportWorkflowModelUtil.getSegmentStatusAsInt(WorkflowStatusType.DATA_STRUCTURE_SELECTED);
        WorkflowStatusType dbdStatusNew = dbdStatusOld = workflowDBD.getStatus();
        int maxSegStatus = 0;
        for (WorkflowSegmentType segment : workflowDBD.getWorkflowSegment()) {
            maxSegStatus = Math.max(maxSegStatus, FieldImportWorkflowModelUtil.getSegmentStatusAsInt(segment.getStatus()));
        }
        if (maxSegStatus <= statusDSSelected) {
            dbdStatusNew = WorkflowStatusType.DBD_IMPORT_COMPLETE;
        } else if (maxSegStatus > statusDSSelected) {
            dbdStatusNew = WorkflowStatusType.DBD_IMPORT_NOT_COMPLETE;
        }
        if (dbdStatusNew != dbdStatusOld) {
            workflowDBD.setStatus(dbdStatusNew);
            this.notifyDBDChanged(workflowDBD);
        } else {
            this.notifySegmentChanged(workflowSegment);
        }
    }

    public void setDBDStatus(WorkflowDBD workflowDBD, WorkflowStatusType workflowStatus) {
        WorkflowStatusType dbdStatusNew = workflowStatus;
        workflowDBD.setStatus(dbdStatusNew);
        switch (dbdStatusNew) {
            default: 
        }
        this.notifyDBDChanged(workflowDBD);
    }

    public void clearDiscoveredCandidateDSs(WorkflowSegmentType workflowSegment) {
        WorkflowDBD workflowDBD = workflowSegment.getParent();
        ArrayList<WorkflowDataStructureType> candidateDSsToRemove = new ArrayList<WorkflowDataStructureType>();
        List<WorkflowDataStructureType> candidateDSs = workflowSegment.getWorkflowCandidateDataStructure();
        for (WorkflowDataStructureType candidateDS : candidateDSs) {
            try {
                if (candidateDS.isManuallyImported().booleanValue()) continue;
                FieldImportWorkflowModelUtil.deleteDSFile(this.projectName, workflowDBD.getName(), candidateDS.getLocation());
                candidateDSsToRemove.add(candidateDS);
            }
            catch (IOException | CoreException e) {
                logger.error(e);
            }
        }
        candidateDSs.removeAll(candidateDSsToRemove);
    }

    public void notifyDBDChanged(WorkflowDBD workflowDBD) {
        if (this.workflowEventListeners != null) {
            for (IFieldImportWorkflowEventListener workflowEventListener : this.workflowEventListeners) {
                workflowEventListener.dbdChanged(workflowDBD);
            }
        }
    }

    private void notifyDBDsAdded() {
        if (this.workflowEventListeners != null) {
            for (IFieldImportWorkflowEventListener workflowEventListener : this.workflowEventListeners) {
                workflowEventListener.dbdsAdded();
            }
        }
    }

    public void notifySegmentChanged(WorkflowSegmentType workflowSegment) {
        if (this.workflowEventListeners != null) {
            for (IFieldImportWorkflowEventListener workflowEventListener : this.workflowEventListeners) {
                workflowEventListener.segmentChanged(workflowSegment);
            }
        }
    }

    public boolean isDBDLocked(WorkflowSegmentType workflowSegment) {
        return this.isDBDLocked(workflowSegment.getParent().getName());
    }

    public boolean isDBDLocked(WorkflowMapCaseType workflowMapCase) {
        return this.isDBDLocked(workflowMapCase.getParent().getParent().getName());
    }

    public boolean isDBDLocked(WorkflowDBD workflowDBD) {
        return this.isDBDLocked(workflowDBD.getName());
    }

    public boolean isDBDLocked(String dbdName) {
        FieldImportWorkflowLock lock = this.workflowDBDLocks.get(dbdName);
        if (lock == null) {
            lock = new FieldImportWorkflowLock();
            this.workflowDBDLocks.put(dbdName, lock);
        }
        return lock.isLockHeld();
    }

    public void acquireDBDLock(String dbdName) {
        this.acquireDBDLock(dbdName, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean acquireDBDLock(String dbdName, IProgressMonitor monitor) {
        FieldImportWorkflowLock lock = this.workflowDBDLocks.get(dbdName);
        if (lock == null) {
            lock = new FieldImportWorkflowLock();
            this.workflowDBDLocks.put(dbdName, lock);
        }
        return lock.acquireLock(monitor);
    }

    public void releaseDBDLock(String dbdName) {
        FieldImportWorkflowLock lock = this.workflowDBDLocks.get(dbdName);
        if (lock == null) {
            throw new IllegalStateException();
        }
        lock.releaseLock(true);
    }

    public FieldImportWorkflow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(FieldImportWorkflow workflow) {
        this.workflow = workflow;
    }

    public List<WorkflowDBD> getWorkflowDBDs() {
        if (this.workflowDBDs == null) {
            this.workflowDBDs = new ArrayList<WorkflowDBD>();
        }
        return this.workflowDBDs;
    }

    public List<IFieldImportWorkflowEventListener> getWorkflowEventListeners() {
        if (this.workflowEventListeners == null) {
            this.workflowEventListeners = new ArrayList<IFieldImportWorkflowEventListener>();
        }
        return this.workflowEventListeners;
    }

    public void importDataStructure(WorkflowMapCaseType workflowMapCase, WorkflowDataStructureType workflowCandidateDS, boolean isJDBCEnable) throws CoreException, ModelException, JAXBException, ConnectionException, IOException {
        String mapCaseName;
        WorkflowSegmentType workflowSegment = workflowMapCase.getParent();
        WorkflowDBD wfDbd = workflowSegment.getParent();
        String dbdName = wfDbd.getName();
        DbdModel currDbd = ProjectTreeFileHelper.unmarshalDbd(dbdName, this.projectName);
        SegmentModel currSegment = currDbd.getSegment(workflowSegment.getName());
        IFile origDbdFile = FieldImportWorkflowModelUtil.getOriginalDbdFile(this.projectName, dbdName);
        if (!origDbdFile.exists()) {
            FieldImportWorkflowModelUtil.marshallOriginalDBD(currDbd, this.projectName);
        } else {
            DbdModel origDbd = FieldImportWorkflowModelUtil.unmarshallOriginalDBD(dbdName, this.projectName);
            DBDConstants dbdAccessType = currSegment.getDbdModel().getAccessType();
            SegmentModel origSegment = dbdAccessType == DBDConstants.GSAM ? origDbd.getSegment(currSegment.getName()) : origDbd.getSegment(currSegment.getImsName());
            mapCaseName = workflowMapCase.getName();
            if (!mapCaseName.equals(UNMAPPED)) {
                String mappingName = this.getMapName(mapCaseName);
                String caseName = this.getCaseName(mapCaseName);
                MappingModel map = currSegment.getMapping(mappingName);
                MappingCaseModel mapCase = map.getMappingCaseModel(caseName);
                mapCase.removeAllFields();
                MappingModel origMap = origSegment.getMapping(mappingName);
                if (origMap != null) {
                    MappingCaseModel origMapCase = origMap.getMappingCaseModel(caseName);
                    Vector<FieldModel> origFields = origMapCase.getTopLevelFieldList();
                    this.addOrigFields(origFields, mapCase);
                }
            } else {
                currSegment.removeAllFields();
                Vector<FieldModel> origFields = origSegment.getTopLevelFieldList(false, false);
                this.addOrigFields(origFields, currSegment);
                Vector<FieldModel> origSysRelField = origSegment.getSysRelFieldList();
                this.addSysrelFields(origSysRelField, currSegment);
            }
        }
        if (workflowCandidateDS != null) {
            ImportDsToDbdController controller = new ImportDsToDbdController(currSegment, currDbd, this.projectName);
            controller.setLocalImport(true);
            IFolder dsFolder = FieldImportWorkflowModelUtil.getDSFolder(this.projectName, dbdName);
            controller.setFolderName(dsFolder.getRawLocation().toOSString());
            controller.setFileName(workflowCandidateDS.getLocation());
            controller.prepareForInitialParse();
            controller.parseDataStructureSourceFile((IProgressMonitor)new NullProgressMonitor());
            DSSA newDssa = new DSSA();
            newDssa.dataStructureName = controller.getDataStructureNames()[0];
            newDssa.segmentName = workflowSegment.getName();
            newDssa.dsFileName = controller.getFullFileName();
            mapCaseName = workflowMapCase.getName();
            if (!mapCaseName.equals(UNMAPPED)) {
                newDssa.mapName = this.getMapName(mapCaseName);
                newDssa.caseName = this.getCaseName(mapCaseName);
            }
            controller.addDsSegmentAssociation(newDssa);
            controller.doFinishModel();
            ProjectTreeFileHelper.marshallDBD(currDbd, this.projectName);
            this.saveRelatedSources(currDbd, this.projectName, isJDBCEnable);
            WorkflowSelectedDataStructureType selectedDS = new WorkflowSelectedDataStructureType();
            selectedDS.setName(workflowCandidateDS.getName());
            selectedDS.setLocation(workflowCandidateDS.getLocation());
            selectedDS.setManuallyImported(workflowCandidateDS.isManuallyImported());
            selectedDS.setParent(workflowMapCase);
            workflowMapCase.setWorkflowSelectedDataStructure(selectedDS);
        } else {
            workflowMapCase.setWorkflowSelectedDataStructure(null);
        }
        ProjectTreeFileHelper.marshallDBD(currDbd, this.projectName);
        this.saveRelatedSources(currDbd, this.projectName, isJDBCEnable);
        this.updateSegmentStatus(workflowSegment);
    }

    private String getMapName(String mapCaseName) {
        return mapCaseName.substring(0, mapCaseName.indexOf(MAP_CASE_NAME_SEPARATOR));
    }

    private String getCaseName(String mapCaseName) {
        return mapCaseName.substring(mapCaseName.indexOf(MAP_CASE_NAME_SEPARATOR) + MAP_CASE_NAME_SEPARATOR.length());
    }

    public WorkflowStatusType updateSegmentStatus(WorkflowSegmentType workflowSegment) {
        WorkflowStatusType retVal = WorkflowStatusType.DBD_JUST_IMPORTED;
        int totalDSCount = FieldImportWorkflowModelUtil.getCandidateDSCount(workflowSegment);
        retVal = FieldImportWorkflowModelUtil.allMapCasesHaveSelectedDS(workflowSegment) ? WorkflowStatusType.DATA_STRUCTURE_SELECTED : (totalDSCount >= 1 ? WorkflowStatusType.MULTIPLE_DATA_STRUCTURES_FOUND : (totalDSCount == 0 ? WorkflowStatusType.NO_DATA_STRUCTURES_FOUND : WorkflowStatusType.DBD_JUST_IMPORTED));
        this.setSegmentStatus(workflowSegment, retVal);
        return retVal;
    }

    private void addOrigFields(Vector<FieldModel> origFields, IFieldContainer currSegment) throws ModelException {
        int i = 0;
        while (i < origFields.size()) {
            FieldModel currOrigField = origFields.get(i);
            currSegment.addFieldWithIntactSubtree(currOrigField);
            ++i;
        }
    }

    private void addSysrelFields(Vector<FieldModel> origFields, SegmentModel currSegment) throws ModelException {
        if (origFields != null) {
            List<Object> allFields = currSegment.getSegmentType().getFieldOrMappingOrLchild();
            int i = 0;
            while (i < origFields.size()) {
                allFields.add(origFields.get(i).getSysRelFieldType());
                ++i;
            }
        }
    }

    public void editorIsClosing() {
        this.stopPopulateWorkflowMetadataJob();
        FieldImportWorkflowControllerContainer.getSingletonInstance().releaseController(this.projectUUID);
    }

    public void postShutdown(IWorkbench arg0) {
    }

    public boolean preShutdown(IWorkbench arg0, boolean arg1) {
        this.editorIsClosing();
        return true;
    }

    public void addWorkbenchListeners() {
        if (PlatformUI.isWorkbenchRunning()) {
            this.removeWorkbenchListeners();
            PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
            this.resourceChangeListener = new ResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        }
    }

    public void removeWorkbenchListeners() {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this);
            if (this.resourceChangeListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
            }
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void editorOpenedSuccessfully() throws Exception {
        FieldImportWorkflowControllerContainer.getSingletonInstance().putController(this.projectUUID, this);
    }

    public RaaServerType getRaaServer() {
        if (this.workflow.getRaaServer() == null) {
            this.workflow.setRaaServer(new RaaServerType());
        }
        return this.workflow.getRaaServer();
    }

    private void saveRelatedSources(DbdModel dbdModel, String projectName, boolean isJDBCEnable) throws CoreException, ModelException, FileNotFoundException, JAXBException {
        ProjectTreeFileHelper.marshallCatalogEnabledGeneratedDbdFile(projectName, dbdModel);
        ProjectTreeFileHelper.marshallDBD(dbdModel, projectName);
        ProjectTreeFileHelper.marshallGeneratedDbdFile(projectName, dbdModel);
        ProjectTreeFileHelper.marshallGeneratedDdlFile(projectName, dbdModel);
        if (isJDBCEnable) {
            ArrayList<String> dbdNames = new ArrayList<String>();
            dbdNames.add(dbdModel.getDBDName());
            List<PsbModel> psbModels = ProjectTreeFileHelper.findRelatedPSBs(projectName, dbdNames);
            Vector<DatabaseViewGeneratorException> exceptions = new Vector<DatabaseViewGeneratorException>();
            int i = 0;
            while (i < psbModels.size()) {
                Vector<DatabaseViewGeneratorException> exception = ProjectTreeFileHelper.marshallGeneratedDbView(projectName, psbModels.get(i).getPsbName());
                if (exception != null) {
                    exceptions.addAll(exception);
                }
                ++i;
            }
            exceptions.size();
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                logger.error((Throwable)e);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !(delta.getResource() instanceof IProject)) {
                return true;
            }
            if (delta.getKind() == 2 && delta.getMovedToPath() != null) {
                IProject targetProject;
                block5: {
                    targetProject = ProjectTreeFileHelper.getProject(delta.getMovedToPath().segments()[0]);
                    String targetProjectUUID = ProjectTreeFileHelper.getUUIDForProject(targetProject, "com.ibm.im.ims.workbench");
                    if (FieldImportWorkflowController.this.projectUUID.equals(targetProjectUUID)) break block5;
                    return true;
                }
                try {
                    FieldImportWorkflowController.this.projectName = targetProject.getName();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            return false;
        }
    }
}

