/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.workflow.field;

import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowControllerContainer;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import java.net.MalformedURLException;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class EnablementController {
    private FieldImportWorkflowController controller;
    private String projectName;
    private String projectUUID;

    public EnablementController(String projectName, String projectUUID) throws MalformedURLException, JAXBException, CoreException {
        this.projectName = projectName;
        this.projectUUID = projectUUID;
        this.controller = this.getWorkflowController();
    }

    public void workflowEnableProject() {
        if (!this.isProjectWorkflowEnabled()) {
            this.controller.createEmptyWorkflow();
        }
    }

    public void addImportedDBDsToWorkflow(Object[] dbdNames, IProgressMonitor monitor) throws MalformedURLException, JAXBException, CoreException, ModelException {
        this.controller.addDBDsToWorkflow(dbdNames, monitor);
        this.controller.saveWorkflow();
    }

    public boolean isProjectWorkflowEnabled() {
        boolean retVal = FieldImportWorkflowModelUtil.isProjectWorkflowEnabled(this.projectName);
        return retVal;
    }

    private FieldImportWorkflowController getWorkflowController() throws MalformedURLException, JAXBException, CoreException {
        FieldImportWorkflowController retVal = null;
        retVal = FieldImportWorkflowControllerContainer.getSingletonInstance().getController(this.projectUUID);
        if (retVal == null) {
            retVal = new FieldImportWorkflowController(this.projectName);
        }
        return retVal;
    }
}

