/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.template;

import com.ibm.im.ims.workbench.model.ResourceTemplatesModel;
import com.ibm.im.ims.workbench.model.TemplateModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;

public class ManageTemplateController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String projectName;
    private ResourceTemplatesModel resourceTemplatesModel;
    private List<String> deletedPsbNames = new ArrayList<String>();
    private boolean hasBeenEdited = false;
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public ManageTemplateController(String projectName) throws ModelException {
        this.setProjectName(projectName);
        try {
            this.resourceTemplatesModel = ProjectTreeFileHelper.unmarshallTemplate(projectName);
        }
        catch (Exception e) {
            ModelException me = new ModelException(e);
            logger.throwing(this.getClass().getName(), "TemplateModel(String name)", (Throwable)me);
            throw me;
        }
    }

    public List<TemplateModel> getTemplates() {
        return this.resourceTemplatesModel.getTemplateModels();
    }

    public boolean hasBeenEdited() {
        return this.hasBeenEdited;
    }

    public void setHasBeenEdited(boolean hasBeenEdited) {
        this.hasBeenEdited = hasBeenEdited;
    }

    public TemplateModel cloneTemplate(TemplateModel originalTemplate) {
        return new TemplateModel(originalTemplate);
    }

    public void removeTemplate(String[] templateNames) {
        String[] stringArray = templateNames;
        int n = templateNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tName = stringArray[n2];
            this.removeTemplate(tName);
            ++n2;
        }
    }

    public void removeTemplate(String templateName) {
        if (templateName != null) {
            this.resourceTemplatesModel.removeTemplateModel(templateName);
            this.hasBeenEdited = true;
        }
    }

    public TemplateModel createTemplateModelForAdd(String templateName) throws InvalidInputException {
        TemplateModel newTemplateModel = null;
        if (templateName != null && this.templateExists(templateName)) {
            Object[] inserts = new String[]{templateName};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_3", inserts));
        }
        newTemplateModel = new TemplateModel(templateName);
        return newTemplateModel;
    }

    public boolean templateExists(String templateName) {
        return this.resourceTemplatesModel.getTemplateModel(templateName) != null;
    }

    public TemplateModel createTemplateModelForAdd() {
        return new TemplateModel();
    }

    public TemplateModel getClonedTemplateForEdit(String templateName) {
        if (templateName != null) {
            return this.resourceTemplatesModel.createTemplateModelForEdit(templateName);
        }
        return null;
    }

    public void replaceOrigTemplateModel(TemplateModel clonedTemplateModel, TemplateModel originalTemplateModel) {
        this.resourceTemplatesModel.replaceOrigTemplateWithClone(clonedTemplateModel, originalTemplateModel);
        this.hasBeenEdited = true;
    }

    public void replaceOrigTemplateModel(TemplateModel clonedTemplateModel, String originalTemplateName) {
        TemplateModel originalTemplateModel = this.resourceTemplatesModel.getTemplateModel(originalTemplateName);
        if (originalTemplateModel != null) {
            this.resourceTemplatesModel.replaceOrigTemplateWithClone(clonedTemplateModel, originalTemplateModel);
        }
        this.hasBeenEdited = true;
    }

    public void performFinish() throws JAXBException, IOException, CoreException, ModelException {
        ArrayList<TemplateModel> originalTemplateModels = this.resourceTemplatesModel.getOriginalTemplateModels();
        if (originalTemplateModels != null) {
            if (originalTemplateModels.size() > 0) {
                this.removeMetadataFilesForTemplateChanges(originalTemplateModels);
            } else {
                this.removeMetadataFilesForTemplateChanges(this.resourceTemplatesModel.getTemplateModels());
            }
        }
        ProjectTreeFileHelper.marshallTemplate(this.resourceTemplatesModel, this.projectName);
    }

    private void removeMetadataFilesForTemplateChanges(ArrayList<TemplateModel> originalTemplateModels) throws CoreException {
        this.deletedPsbNames.clear();
        Vector<String> psbNames = ProjectTreeFileHelper.getPSBNamesInProject(this.projectName);
        int i = 0;
        while (i < psbNames.size()) {
            String currentPsbName = psbNames.get(i);
            int j = 0;
            while (j < originalTemplateModels.size()) {
                TemplateModel currentTemplateModel = originalTemplateModels.get(j);
                this.removeMetadataFilesForPsbNameAndTemplate(currentPsbName, currentTemplateModel);
                ++j;
            }
            ++i;
        }
    }

    private void removeMetadataFilesForPsbNameAndTemplate(String psbName, TemplateModel templateModel) throws CoreException {
        String varString = templateModel.getVarString();
        if (psbName.contains("@") || psbName.contains("#")) {
            ArrayList<String> replStrings = templateModel.getRepStrings();
            int k = 0;
            while (k < replStrings.size()) {
                String replString = replStrings.get(k);
                String psbNameToBeDeleted = new String(psbName);
                if (ProjectTreeFileHelper.deletePSBMetadataFile(this.projectName, psbNameToBeDeleted = psbNameToBeDeleted.replace(varString, replString))) {
                    this.deletedPsbNames.add(psbNameToBeDeleted);
                }
                if (ProjectTreeFileHelper.deletePSBMetadataFile(this.projectName, psbName)) {
                    this.deletedPsbNames.add(psbName);
                }
                ++k;
            }
        }
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void addTemplateModel(TemplateModel templateModel) throws ModelException {
        this.resourceTemplatesModel.addTemplateModel(templateModel);
        this.hasBeenEdited = true;
    }
}

