/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.template;

import com.ibm.im.ims.workbench.controller.template.ManageTemplateController;
import com.ibm.im.ims.workbench.model.TemplateModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.util.ArrayList;

public class EditTemplateController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManageTemplateController manageTemplateController;
    private TemplateModel templateModel;
    private String originalTemplateName;
    private String originalVariableString;
    private String actionType;
    public static final String EDIT = "EDIT";
    public static final String ADD = "ADD";
    public static final String ALL = "ALL";
    public static final String TEMPLATE_NAME = "TEMPLATE_NAME";
    public static final String VARIABLE_STRING = "VARIABLE_STRING";
    public static final String REPLACEMENT_STRING = "REPLACEMENT_STRING";
    private boolean hasBeenEdited = false;

    public EditTemplateController(ManageTemplateController manageTemplateController, String templateName, String actionType) throws InvalidInputException {
        this.manageTemplateController = manageTemplateController;
        this.originalTemplateName = templateName;
        this.actionType = actionType;
        if (actionType.equals(ADD)) {
            this.templateModel = manageTemplateController.createTemplateModelForAdd(templateName);
            this.originalVariableString = "";
        } else {
            this.templateModel = manageTemplateController.getClonedTemplateForEdit(templateName);
            this.originalVariableString = this.templateModel.getVarString();
        }
    }

    public void performFinish() throws ModelException {
        if (this.actionType.equals(ADD)) {
            this.manageTemplateController.addTemplateModel(this.templateModel);
        } else {
            this.manageTemplateController.replaceOrigTemplateModel(this.templateModel, this.originalTemplateName);
        }
    }

    public TemplateModel getTemplateModel() {
        return this.templateModel;
    }

    public void setTemplateModel(TemplateModel templateModel) {
        this.templateModel = templateModel;
        this.hasBeenEdited = true;
    }

    public void setTemplateName(String templateName) throws InvalidInputException {
        if (!templateName.equals(this.originalTemplateName)) {
            this.templateModel.setTemplateName(templateName);
        }
        this.hasBeenEdited = true;
    }

    public String getTemplateName() {
        return this.templateModel.getTemplateName();
    }

    public void setVarString(String varString) throws InvalidInputException {
        this.templateModel.setVarString(varString);
        this.hasBeenEdited = true;
    }

    public String getVarString() {
        return this.templateModel.getVarString();
    }

    public void addReplacementString(String replacementString) throws InvalidInputException {
        this.templateModel.addReplacementString(replacementString.toUpperCase());
        this.hasBeenEdited = true;
    }

    public ArrayList<String> getReplacementStrings() {
        return this.templateModel.getRepStrings();
    }

    public boolean containsReplacementString(String s) {
        return this.templateModel.getRepStrings() != null && this.templateModel.getRepStrings().contains(s.toUpperCase());
    }

    private boolean isInputHasSpaces(String inputString) throws InvalidInputException {
        return inputString.contains(" ");
    }

    public boolean hasBeenEdited() {
        return this.hasBeenEdited;
    }

    public void setHasBeenEdited(boolean hasBeenEdited) {
        this.hasBeenEdited = hasBeenEdited;
    }

    public void removeReplacementString(String replStr) {
        this.templateModel.removeReplacementString(replStr);
        this.setHasBeenEdited(true);
    }

    public String getActionType() {
        return this.actionType;
    }

    public void validateRequiredFields(String[] attrsToCheck) throws ModelException, InvalidInputException {
        int i = 0;
        while (i < attrsToCheck.length) {
            block8: {
                ArrayList<String> replacementStrs;
                String currAttr;
                block9: {
                    block7: {
                        currAttr = attrsToCheck[i];
                        if (!currAttr.equals(ALL) && !currAttr.equals(TEMPLATE_NAME)) break block7;
                        String tName = this.getTemplateName();
                        if (tName == null || tName.isEmpty() || !Utility.isValidName(tName) || this.isInputHasSpaces(tName)) {
                            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_TEMPLATE_WIZARD_LOCATION")};
                            String[] attrs = new String[]{TEMPLATE_NAME};
                            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_4", inserts), attrs);
                        }
                        if (currAttr.equals(TEMPLATE_NAME)) break block8;
                    }
                    if (!currAttr.equals(ALL) && !currAttr.equals(VARIABLE_STRING)) break block9;
                    String variableString = this.getVarString();
                    if (variableString == null || variableString.isEmpty()) {
                        Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_TEMPLATE_WIZ_10")};
                        String[] attrs = new String[]{VARIABLE_STRING};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_4", inserts), attrs);
                    }
                    if (currAttr.equals(VARIABLE_STRING)) break block8;
                }
                if ((currAttr.equals(ALL) || currAttr.equals(REPLACEMENT_STRING)) && ((replacementStrs = this.getReplacementStrings()) == null || replacementStrs.isEmpty())) {
                    Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_TEMPLATE_WIZ_4")};
                    String[] attrs = new String[]{REPLACEMENT_STRING};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_4", inserts), attrs);
                }
            }
            ++i;
        }
    }

    public void validateAllRequiredFields() throws ModelException, InvalidInputException {
        this.validateRequiredFields(new String[]{ALL});
    }

    public void semanticCheck() throws InvalidInputException, ModelException {
        String newTemplateName = this.templateModel.getTemplateName();
        this.validateEditedTemplateName(newTemplateName);
        String newVariableString = this.templateModel.getVarString();
        this.validateEditedVariableString(newVariableString);
        this.ValidateEditedReplacementStrings();
    }

    private void ValidateEditedReplacementStrings() throws InvalidInputException {
        int i = 0;
        while (i < this.templateModel.getRepStrings().size()) {
            String currReplString = this.templateModel.getRepStrings().get(i);
            if (currReplString.contains(" ")) {
                Object[] inserts = new Object[]{currReplString};
                String[] attrs = new String[]{REPLACEMENT_STRING};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_8", inserts), attrs);
            }
            ++i;
        }
    }

    private void validateEditedVariableString(String newVariableString) throws InvalidInputException {
        if (newVariableString == null || newVariableString.isEmpty()) {
            Object[] inserts = new Object[]{newVariableString};
            String[] attrs = new String[]{VARIABLE_STRING};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_4", inserts), attrs);
        }
        if (!newVariableString.equals(this.originalVariableString)) {
            for (TemplateModel tm : this.manageTemplateController.getTemplates()) {
                if (!tm.getVarString().equals(newVariableString)) continue;
                Object[] inserts = new Object[]{newVariableString};
                String[] attrs = new String[]{VARIABLE_STRING};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_9", inserts), attrs);
            }
        }
        if (newVariableString.contains(" ")) {
            Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("EDIT_TEMPLATE_WIZ_2")};
            String[] attrs = new String[]{VARIABLE_STRING};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_7", inserts), attrs);
        }
    }

    private void validateEditedTemplateName(String newTemplateName) throws InvalidInputException {
        if (!Utility.isValidName(newTemplateName)) {
            Object[] inserts = new Object[]{newTemplateName};
            String[] attrs = new String[]{TEMPLATE_NAME};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_5", inserts), attrs);
        }
        if (!newTemplateName.equals(this.originalTemplateName)) {
            for (TemplateModel tm : this.manageTemplateController.getTemplates()) {
                if (!tm.getTemplateName().equals(newTemplateName)) continue;
                Object[] inserts = new Object[]{newTemplateName};
                String[] attrs = new String[]{TEMPLATE_NAME};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_5", inserts), attrs);
            }
        }
        if (this.isInputHasSpaces(newTemplateName)) {
            Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("EDIT_TEMPLATE_WIZ_1")};
            String[] attrs = new String[]{VARIABLE_STRING};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_TEMPLATE_WIZ_7", inserts), attrs);
        }
    }

    public boolean isNewTemplateNameTaken(String newTemplateName) {
        int i = 0;
        while (i < this.manageTemplateController.getTemplates().size()) {
            TemplateModel currentTemplateModel = this.manageTemplateController.getTemplates().get(i);
            if (currentTemplateModel.getTemplateName().equals(newTemplateName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isNewVariableStringTaken(String newVariableString) {
        int i = 0;
        while (i < this.manageTemplateController.getTemplates().size()) {
            TemplateModel currentTemplateModel = this.manageTemplateController.getTemplates().get(i);
            if (currentTemplateModel.getVarString().equals(newVariableString)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isTemplateNameValid(String tname) {
        return Utility.isValidName(tname);
    }

    public boolean templateNameHasChanged(String templateNameStr) {
        return Utility.stringsDifferent(this.originalTemplateName, templateNameStr);
    }

    public boolean variableStringHasChanged(String variableStr) {
        return Utility.stringsDifferent(this.originalVariableString, variableStr);
    }
}

