/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.mapping;

import com.ibm.im.ims.workbench.controller.mapping.EditCaseController;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.util.Iterator;
import java.util.Vector;

public class ManageMappingController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SegmentModel origSegmentModel;
    private SegmentModel clonedSegmentModel;
    private boolean hasBeenEdited = false;
    private MappingCaseModel origCaseModel;
    private MappingModel origMappingModel;
    private boolean isReadOnly;

    public ManageMappingController(SegmentModel segmentModel, boolean isReadOnly) throws ModelException {
        this.origSegmentModel = segmentModel;
        this.clonedSegmentModel = new SegmentModel(segmentModel);
        this.isReadOnly = isReadOnly;
    }

    public Iterator<MappingModel> getMappings() {
        return this.clonedSegmentModel.getMappingList();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public MappingModel getMappingCloneForEdit(String mappingName) {
        this.origMappingModel = this.clonedSegmentModel.getMapping(mappingName);
        MappingModel clonedMappingModel = new MappingModel(this.origMappingModel);
        return clonedMappingModel;
    }

    public MappingModel getMapping(String mappingName) {
        MappingModel mappingModel = this.clonedSegmentModel.getMapping(mappingName);
        return mappingModel;
    }

    public void replaceOrigMappingWithClone(MappingModel clonedMappingModel) {
        this.hasBeenEdited = true;
        this.clonedSegmentModel.replaceOrigMappingWithClone(this.origMappingModel, clonedMappingModel);
    }

    public MappingCaseModel getCaseCloneForEdit(String mappingName, String caseName) {
        this.origCaseModel = this.clonedSegmentModel.getMapping(mappingName).getMappingCaseModel(caseName);
        MappingCaseModel clonedCaseModel = new MappingCaseModel(this.origCaseModel);
        return clonedCaseModel;
    }

    public void replaceOrigCaseWithClone(String mappingName, MappingCaseModel clonedCaseModel) {
        this.hasBeenEdited = true;
        this.clonedSegmentModel.replaceOrigCaseWithClone(mappingName, this.origCaseModel, clonedCaseModel);
    }

    public MappingModel createNewMappingModelForAdd() {
        return new MappingModel();
    }

    public MappingCaseModel createNewCaseModelForAdd() {
        return new MappingCaseModel();
    }

    public void addNewMappingModel(MappingModel newMappingModel) {
        this.hasBeenEdited = true;
        this.clonedSegmentModel.addNewMappingModel(newMappingModel);
    }

    public void addNewCaseModel(String mappingName, MappingCaseModel newMappingCaseModel) {
        this.hasBeenEdited = true;
        this.clonedSegmentModel.addNewCaseModel(mappingName, newMappingCaseModel);
    }

    public boolean isCaseNameTaken(String mappingName, String caseName) {
        MappingModel mappingModel = this.clonedSegmentModel.getMapping(mappingName);
        return mappingModel.isCaseNameTaken(caseName);
    }

    public boolean hasBeenEdited() {
        return this.hasBeenEdited;
    }

    public void removeCases(String mappingName, String[] caseNames) {
        this.hasBeenEdited = true;
        MappingModel mapping = this.clonedSegmentModel.getMapping(mappingName);
        int i = 0;
        while (i < caseNames.length) {
            mapping.removeCase(caseNames[i]);
            ++i;
        }
    }

    public void removeMappings(String[] mappingNames) {
        this.hasBeenEdited = true;
        int i = 0;
        while (i < mappingNames.length) {
            this.clonedSegmentModel.removeMapping(mappingNames[i]);
            ++i;
        }
    }

    public boolean checkCaseIdHexValid(String mappingName, String caseId, EditCaseController ecController) throws InvalidInputException, ModelException {
        MappingModel origMappingModel = this.clonedSegmentModel.getMapping(mappingName);
        String dependingOnField = origMappingModel.getDependingOnField();
        FieldModel controlField = this.clonedSegmentModel.getFieldWithAlias(dependingOnField, null);
        int fieldBytesLen = controlField.getBytes();
        int i = 0;
        while (i < caseId.length()) {
            if (caseId.charAt(i) != '0' && caseId.charAt(i) != '1' && caseId.charAt(i) != '2' && caseId.charAt(i) != '3' && caseId.charAt(i) != '4' && caseId.charAt(i) != '5' && caseId.charAt(i) != '6' && caseId.charAt(i) != '7' && caseId.charAt(i) != '8' && caseId.charAt(i) != '9' && caseId.charAt(i) != 'A' && caseId.charAt(i) != 'B' && caseId.charAt(i) != 'C' && caseId.charAt(i) != 'D' && caseId.charAt(i) != 'E' && caseId.charAt(i) != 'F') {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITCASE_ERR0R02"));
            }
            ++i;
        }
        if (caseId.length() != 2 * fieldBytesLen) {
            Object[] inserts = new Object[]{String.valueOf(2 * ecController.getControlFieldLength()), String.valueOf(ecController.getControlFieldLength()), ecController.getControlFieldName()};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITCASE_ERR0R03", inserts));
        }
        return true;
    }

    public boolean checkCaseIdCharValid(String mappingName, String caseId, EditCaseController ecController) throws InvalidInputException, ModelException {
        MappingModel origMappingModel = this.clonedSegmentModel.getMapping(mappingName);
        String dependingOnField = origMappingModel.getDependingOnField();
        FieldModel controlField = this.clonedSegmentModel.getFieldWithAlias(dependingOnField, null);
        if (controlField != null) {
            int fieldBytesLen = controlField.getBytes();
            if (caseId.length() > fieldBytesLen) {
                Object[] inserts = new Object[]{String.valueOf(ecController.getControlFieldLength()), ecController.getControlFieldName()};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITCASE_ERR0R04", inserts));
            }
        } else {
            return false;
        }
        return true;
    }

    public Vector<FieldModel> getCommonFieldList() throws ModelException {
        return this.clonedSegmentModel.getFieldList(false, true);
    }

    public boolean isMappingNameTaken(String mappingName) {
        Iterator<MappingModel> mappings = this.getMappings();
        while (mappings.hasNext()) {
            MappingModel currMapping = mappings.next();
            if (this.origMappingModel == currMapping) continue;
            String currMappingName = currMapping.getName();
            if (currMappingName == null) {
                currMappingName = "";
            }
            if (!currMappingName.equals(mappingName)) continue;
            return true;
        }
        return false;
    }

    public void performFinish() {
        this.origSegmentModel.clearMappingList();
        Iterator<MappingModel> mappingIt = this.clonedSegmentModel.getMappingList();
        while (mappingIt.hasNext()) {
            this.origSegmentModel.addNewMappingModel(mappingIt.next());
        }
    }

    public String getControlFieldName(String mappingName) throws ModelException {
        MappingModel origMappingModel = this.clonedSegmentModel.getMapping(mappingName);
        return origMappingModel.getDependingOnField();
    }

    public int getControlFieldLength(String mappingName) throws ModelException {
        int retVal = 0;
        MappingModel origMappingModel = this.clonedSegmentModel.getMapping(mappingName);
        String dependingOnField = origMappingModel.getDependingOnField();
        FieldModel controlField = this.clonedSegmentModel.getFieldWithAlias(dependingOnField, null);
        if (controlField != null) {
            retVal = controlField.getBytes();
        }
        return retVal;
    }

    public String getControlSegmentName(String mappingName) throws ModelException {
        MappingModel origMappingModel = this.clonedSegmentModel.getMapping(mappingName);
        return origMappingModel.getControlSegmentName();
    }

    public SegmentModel getClonedSegmentModel() {
        return this.clonedSegmentModel;
    }

    public String getControlFieldType(String mappingName) throws ModelException {
        String retVal = null;
        MappingModel origMappingModel = this.clonedSegmentModel.getMapping(mappingName);
        String dependingOnField = origMappingModel.getDependingOnField();
        FieldModel controlField = this.clonedSegmentModel.getFieldWithAlias(dependingOnField, null);
        if (controlField != null) {
            DBDConstants type = controlField.getPhysicalDataType();
            if (type == null) {
                type = controlField.getAppDatatype();
            }
            if (type != null) {
                retVal = type.toString();
            }
        }
        return retVal;
    }
}

