/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.mapping;

import com.ibm.im.ims.workbench.controller.mapping.ManageMappingController;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;

public class EditMappingController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManageMappingController mmController;
    private MappingModel mappingModel;
    private String actionType;
    private boolean isReadOnly;
    public static final String EDIT = "EDIT";
    public static final String ADD = "ADD";

    public EditMappingController(String mappingName, ManageMappingController mmController, String actionType) {
        this.mmController = mmController;
        this.actionType = actionType;
        this.isReadOnly = mmController.isReadOnly();
        this.mappingModel = actionType.equals(ADD) ? mmController.createNewMappingModelForAdd() : mmController.getMappingCloneForEdit(mappingName);
    }

    public void performFinish() {
        if (this.actionType.equals(ADD)) {
            this.mmController.addNewMappingModel(this.mappingModel);
        } else {
            this.mmController.replaceOrigMappingWithClone(this.mappingModel);
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getMappingName() {
        return this.mappingModel.getName();
    }

    public MappingModel getMappingModel() {
        return this.mappingModel;
    }

    public String getCtlSegment() {
        return this.mappingModel.getControlSegmentName();
    }

    public String getSegment() {
        String name = this.mmController.getClonedSegmentModel().getImsName();
        if (name == null || name.isEmpty()) {
            name = this.mmController.getClonedSegmentModel().getName();
        }
        return name;
    }

    public String getCtlField() {
        return this.mappingModel.getDependingOnField();
    }

    public Vector<FieldModel> getPotentialControlFieldList(String controlSegment) throws ModelException {
        SegmentModel clonedSegmentModel = this.mmController.getClonedSegmentModel();
        if (controlSegment != null && !controlSegment.isEmpty()) {
            DbdModel dbdModel = clonedSegmentModel.getDbdModel();
            clonedSegmentModel = dbdModel.getSegment(controlSegment);
        } else {
            controlSegment = this.getSegment();
        }
        Vector<Object> retVal = new Vector();
        if (!this.getSegment().equals(controlSegment)) {
            FieldModel seqField = clonedSegmentModel.getSeqField();
            if (seqField != null) {
                retVal.add(seqField);
            }
        } else {
            retVal = clonedSegmentModel.getTopLevelFieldList();
            int minBytes = clonedSegmentModel.getMinBytes();
            if (minBytes > 0) {
                Vector<FieldModel> commonFields = retVal;
                retVal = new Vector();
                int i = 0;
                while (i < commonFields.size()) {
                    int length;
                    FieldModel currField = commonFields.get(i);
                    int currStart = currField.getStartPos();
                    if (currStart + (length = currField.getBytes()) - 1 <= minBytes && (!this.getSegment().equals(controlSegment) && currField.isSeq() || this.getSegment().equals(controlSegment))) {
                        retVal.add(currField);
                    }
                    ++i;
                }
            }
        }
        return retVal;
    }

    public Vector<String> getPotentialControlSegmentList() throws ModelException {
        Vector<String> retVal = new Vector<String>();
        SegmentModel clonedSegmentModel = this.mmController.getClonedSegmentModel();
        retVal.add(clonedSegmentModel.getImsName());
        if (clonedSegmentModel.isRoot()) {
            return retVal;
        }
        SegmentModel parent = clonedSegmentModel.getParent();
        do {
            retVal.add(parent.getImsName());
        } while ((parent = parent.getParent()) != null);
        return retVal;
    }

    public boolean isValidName(String mappingName) {
        return Utility.isValidCaseOrMappingName(mappingName);
    }

    public boolean isMappingNameTaken(String mappingName) {
        return this.mmController.isMappingNameTaken(mappingName);
    }

    public void setMappingName(String mappingName) {
        this.mappingModel.setName(mappingName);
    }

    public void validateCtlSegment(String ctlSegment) throws InvalidInputException {
        if (ctlSegment.isEmpty()) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITMAP_WIZ_007"));
        }
    }

    public void validateCtlField(String ctlField) throws InvalidInputException {
        if (ctlField.isEmpty()) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITMAP_WIZ_004"));
        }
    }

    public void validateMappingName(String mappingNameStr) throws InvalidInputException {
        if (mappingNameStr.isEmpty()) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITMAP_WIZ_002"));
        }
        if (mappingNameStr.indexOf(" ") > -1) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITMAP_WIZ_003"));
        }
        if (!this.isValidName(mappingNameStr)) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITMAP_WIZ_001"));
        }
        if (this.mmController.getClonedSegmentModel().getName().equals(mappingNameStr)) {
            Object[] inserts = new Object[]{this.mmController.getClonedSegmentModel().getName()};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITMAP_WIZ_006", inserts));
        }
        if (this.isMappingNameTaken(mappingNameStr)) {
            Object[] messageArguments = new Object[]{"map name", mappingNameStr};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchModelBundle.getError().getString("IOGWB0003"));
            throw new InvalidInputException(formatter.format(messageArguments));
        }
    }

    public void setCtlSegment(String ctlSegmentName) {
        this.mappingModel.setControlSegmentName(ctlSegmentName);
    }

    public void setCtlField(String ctlFieldName) {
        this.mappingModel.setDependingOnField(ctlFieldName);
    }

    public String getRemarks() {
        return this.mappingModel.getRemarks();
    }

    public void setRemarks(String remarks) throws InvalidInputException {
        this.mappingModel.setRemarks(remarks);
    }
}

