/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.mapping;

import com.ibm.im.ims.metadata.dbd.DependingOnFieldValueType;
import com.ibm.im.ims.metadata.dbd.ValueDatatypeType;
import com.ibm.im.ims.workbench.controller.mapping.ManageMappingController;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;

public class EditCaseController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManageMappingController mmController;
    private MappingCaseModel caseModel;
    private String mappingName;
    private String actionType;
    private boolean isReadOnly;
    public static final String EDIT = "EDIT";
    public static final String ADD = "ADD";

    public EditCaseController(String mappingName, String caseName, ManageMappingController mmController, String actionType) {
        this.mmController = mmController;
        this.mappingName = mappingName;
        this.actionType = actionType;
        this.isReadOnly = mmController.isReadOnly();
        this.caseModel = actionType.equals(ADD) ? mmController.createNewCaseModelForAdd() : mmController.getCaseCloneForEdit(mappingName, caseName);
    }

    public void performFinish() {
        if (this.actionType.equals(ADD)) {
            this.mmController.addNewCaseModel(this.mappingName, this.caseModel);
        } else {
            this.mmController.replaceOrigCaseWithClone(this.mappingName, this.caseModel);
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getCaseName() {
        return this.caseModel.getName();
    }

    public String getCaseId() {
        DependingOnFieldValueType val = this.caseModel.getDependingOnFieldValue();
        return val.getValue();
    }

    private String getCaseId(MappingCaseModel cm) {
        DependingOnFieldValueType val = cm.getDependingOnFieldValue();
        return val.getValue();
    }

    public ValueDatatypeType getCaseIdType() {
        DependingOnFieldValueType val = this.caseModel.getDependingOnFieldValue();
        return val.getValueDatatype();
    }

    public String getRemarks() {
        return this.caseModel.getRemarks();
    }

    public void setCaseName(String caseName) throws InvalidInputException {
        if (caseName.isEmpty()) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("IOGWB0072"));
        }
        if (caseName.indexOf(" ") > -1) {
            throw new InvalidInputException("Name cannot contain space characters");
        }
        if (this.actionType.equals(ADD) && this.mmController.isCaseNameTaken(this.mappingName, caseName)) {
            Object[] messageArguments = new Object[]{"Case Name already exists, please use a different name.", caseName};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchModelBundle.getError().getString("IOGWB0003"));
            throw new InvalidInputException(formatter.format(messageArguments));
        }
        if (!Utility.isValidCaseOrMappingName(caseName)) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC8"));
        }
        this.caseModel.setName(caseName);
    }

    public void setCaseIdType() {
    }

    public void setCaseId(String caseId, DBDConstants idType) throws InvalidInputException {
        if (idType.equals((Object)DBDConstants.X)) {
            try {
                this.mmController.checkCaseIdHexValid(this.mappingName, caseId, this);
                this.caseModel.setDependingOnFieldValue(caseId);
                this.caseModel.setDependingOnFieldValueType(DBDConstants.X);
            }
            catch (ModelException me) {
                throw new InvalidInputException(me.getMessage());
            }
        }
        if (caseId.equals("")) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITCASE_ERR0R01"));
        }
        if (caseId.contains(" ")) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDITCASE_ERR0R05"));
        }
        if (this.isDuplicateCaseId(caseId)) {
            throw new InvalidInputException(this.getDuplicateCaseIdMessage(caseId));
        }
        try {
            this.mmController.checkCaseIdCharValid(this.mappingName, caseId, this);
            this.caseModel.setDependingOnFieldValue(caseId);
            this.caseModel.setDependingOnFieldValueType(DBDConstants.C);
        }
        catch (ModelException me) {
            throw new InvalidInputException(me.getMessage());
        }
    }

    private boolean isDuplicateCaseId(String caseId) {
        Iterator<MappingCaseModel> caseIter = this.mmController.getMapping(this.mappingName).getMappingCases();
        while (caseIter.hasNext()) {
            MappingCaseModel cm = caseIter.next();
            if (this.caseModel.getName() == null || cm.getName().equals(this.caseModel.getName()) || !this.getCaseId(cm).equals(caseId)) continue;
            return true;
        }
        return false;
    }

    private String getDuplicateCaseIdMessage(String caseId) {
        Object[] messageArguments = new Object[]{caseId};
        MessageFormat formatter = new MessageFormat("");
        formatter.setLocale(Locale.getDefault());
        formatter.applyPattern(WorkbenchModelBundle.getError().getString("EDITCASE_ERR0R06"));
        return formatter.format(messageArguments);
    }

    public void setRemarks(String remarks) throws InvalidInputException {
        this.caseModel.setRemarks(remarks);
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getControlFieldName() throws InvalidInputException {
        try {
            return this.mmController.getControlFieldName(this.mappingName);
        }
        catch (ModelException me) {
            throw new InvalidInputException(me.getMessage());
        }
    }

    public int getControlFieldLength() throws InvalidInputException {
        try {
            return this.mmController.getControlFieldLength(this.mappingName);
        }
        catch (ModelException me) {
            throw new InvalidInputException(me.getMessage());
        }
    }

    public String getControlFieldType() throws InvalidInputException {
        try {
            return this.mmController.getControlFieldType(this.mappingName);
        }
        catch (ModelException me) {
            throw new InvalidInputException(me.getMessage());
        }
    }
}

