/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.importer.source;

import com.ibm.im.ims.workbench.controller.importer.source.IMSResourceToImport;
import com.ibm.im.ims.workbench.controller.importer.source.ImportProvider;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceController;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.IImsResourceModel;
import com.ibm.im.ims.workbench.model.utilities.IMSSourceImporter;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalProvider
implements ImportProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private File lastDirUsed;
    private IMSSourceImporter importer;
    private Iterator<String> pathIterator;
    private IMSResourceToImport currentModel;
    private int totalSizeAllFiles;
    private HashMap<String, String> filesInDir;
    private ImportSourceController isController;

    public LocalProvider(ImportSourceController controller) {
        this.isController = controller;
        this.importer = new IMSSourceImporter();
    }

    public void setFilePaths(Vector<String> paths) throws IOException, ImporterException {
        this.totalSizeAllFiles = 0;
        int i = 0;
        while (i < paths.size()) {
            File currFile = new File(paths.get(i));
            this.totalSizeAllFiles = (int)((long)this.totalSizeAllFiles + currFile.length());
            ++i;
        }
        if (paths.size() > 0) {
            String filePath = paths.get(0);
            File file = new File(filePath);
            String dirPath = file.getParent();
            this.lastDirUsed = new File(dirPath);
            this.populateFilesInDir(this.lastDirUsed);
        }
        this.pathIterator = paths.iterator();
    }

    private void populateFilesInDir(File dir) {
        this.filesInDir = new HashMap();
        File[] fileList = dir.listFiles();
        int j = 0;
        while (j < fileList.length) {
            File currFile = fileList[j];
            if (currFile.isFile()) {
                String currFileName = this.removeFileType(currFile.getName());
                this.filesInDir.put(currFileName.toUpperCase(), currFile.getAbsolutePath());
            }
            ++j;
        }
    }

    private String removeFileType(String fileName) {
        if (fileName.indexOf(".") >= 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    private boolean resourceAlreadyImported(String resourcePath) {
        IMSResourceToImport existingResource;
        String resourceName = resourcePath.substring(resourcePath.lastIndexOf(File.separator) + 1);
        if (resourceName.contains(".")) {
            resourceName = resourceName.substring(0, resourceName.lastIndexOf("."));
        }
        return (existingResource = this.isController.getResourceAlreadyImported(resourceName.toUpperCase())) != null && existingResource.getPath().equalsIgnoreCase(resourcePath);
    }

    @Override
    public boolean hasMoreModels() throws IOException, ImporterException {
        do {
            String currentPath;
            if (!this.importer.hasMoreModels()) {
                boolean needNextPath = true;
                do {
                    if (!this.pathIterator.hasNext()) {
                        return false;
                    }
                    currentPath = this.pathIterator.next();
                    if (this.resourceAlreadyImported(currentPath)) continue;
                    this.importer.setImportResourcePath(new BufferedReader(new FileReader(currentPath)), currentPath);
                    needNextPath = false;
                } while (needNextPath);
            }
            while (this.importer.hasMoreModels()) {
                IImsResourceModel oneModel = this.importer.getNextResourceModel();
                currentPath = this.importer.getPath();
                if (oneModel == null) continue;
                this.currentModel = new IMSResourceToImport(oneModel, currentPath);
                return true;
            }
        } while (this.pathIterator.hasNext());
        return false;
    }

    public int getBytesRead() {
        return this.importer.getBytesRead();
    }

    @Override
    public IMSResourceToImport nextModel() {
        return this.currentModel;
    }

    public Vector<ImporterException> getImporterExceptions() {
        return this.importer.getImporterExceptions();
    }

    @Override
    public Vector<IMSResourceToImport> getDbdModels(Vector<String> dbdNamesToImport, IProgressMonitor monitor) throws IOException, ImporterException {
        Vector<IMSResourceToImport> retVal = new Vector<IMSResourceToImport>(dbdNamesToImport.size());
        int i = 0;
        while (i < dbdNamesToImport.size()) {
            File currFile;
            IMSResourceToImport foundDbd;
            if (monitor.isCanceled()) break;
            String currDbdName = dbdNamesToImport.get(i);
            String filePath = this.filesInDir.get(currDbdName);
            if (filePath != null && (foundDbd = this.getDbdInFile(currFile = new File(filePath), currDbdName)) != null) {
                retVal.add(foundDbd);
                Object[] inserts = new Object[]{foundDbd.getDbdName()};
                monitor.subTask(WorkbenchModelBundle.getLabel().getString("FOUND_DBD", inserts));
            }
            ++i;
        }
        return retVal;
    }

    private IMSResourceToImport getDbdInFile(File currFile, String currDbdName) throws IOException, ImporterException {
        IMSSourceImporter tempImporter = new IMSSourceImporter();
        String currFilePath = currFile.getAbsolutePath();
        tempImporter.setImportResourcePath(new BufferedReader(new FileReader(currFilePath)), currFilePath);
        while (tempImporter.hasMoreModels()) {
            IImsResourceModel oneModel = tempImporter.getNextResourceModel();
            if (oneModel == null || !oneModel.isDBD() || !((DbdModel)oneModel).getDBDName().equals(currDbdName)) continue;
            return new IMSResourceToImport(oneModel, currFilePath);
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getTotalSizeAllResources() {
        return this.totalSizeAllFiles;
    }

    @Override
    public void reset() {
        this.importer.resetSSReader();
    }
}

