/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.importer.source;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.im.ims.workbench.controller.importer.source.CatalogProvider;
import com.ibm.im.ims.workbench.controller.importer.source.HostProvider;
import com.ibm.im.ims.workbench.controller.importer.source.IMSResourceToImport;
import com.ibm.im.ims.workbench.controller.importer.source.ImportProvider;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceType;
import com.ibm.im.ims.workbench.controller.importer.source.LocalProvider;
import com.ibm.im.ims.workbench.controller.importer.source.ReferencedDbd;
import com.ibm.im.ims.workbench.controller.workflow.field.EnablementController;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.IImsResourceModel;
import com.ibm.im.ims.workbench.model.MergeDbd;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.DatabaseViewGeneratorException;
import com.ibm.im.ims.workbench.model.utilities.DatabaseViewGeneratorExceptionHelper;
import com.ibm.im.ims.workbench.model.utilities.IMSSourceImporter;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.Statement;
import com.ibm.im.ims.workbench.model.utilities.StatementSet;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ImportSourceController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private boolean autoImportRefDbds;
    private Vector<ImporterException> importerExceptions;
    private HashMap<String, IMSResourceToImport> psbToImportList;
    private HashMap<String, IMSResourceToImport> dbdToImportList;
    private HashMap<String, ReferencedDbd> referenceMap;
    private ImportSourceType sourceType = null;
    private ImportProvider localProvider;
    private ImportProvider hostProvider;
    private ImportProvider catalogProvider;
    private String projectName;
    private String defaultEncoding;
    private String instanceTSVers = null;
    private boolean reportDBViewWarnings = true;
    private DatabaseViewGeneratorExceptionHelper helper;
    private Vector<IMSResourceToImport> psbsAlreadyInProject = null;
    private Vector<IMSResourceToImport> dbdsAlreadyInProject = null;
    NullProgressMonitor nullMonitor;
    private List<String> psbNamesToGenDBViews = new ArrayList<String>();
    private boolean isNewProject = false;
    private boolean genDbView = false;
    private String projectUUID;

    public ImportSourceController() throws CoreException, IOException {
        this("Cp1047");
    }

    public ImportSourceController(String defaultEncoding) throws CoreException, IOException {
        this.psbToImportList = new HashMap();
        this.dbdToImportList = new HashMap();
        this.defaultEncoding = defaultEncoding;
        ProjectTreeFileHelper.createNewProject("IMS_Explorer_Catalog_ReadOnly");
        this.nullMonitor = new NullProgressMonitor();
    }

    public void setSpecificInstanceTSVers(String instanceTSVers) {
        this.instanceTSVers = instanceTSVers;
    }

    private ImportProvider getCurrentProvider() {
        if (this.sourceType == ImportSourceType.LOCAL) {
            return this.localProvider;
        }
        if (this.sourceType == ImportSourceType.CATALOG) {
            return this.catalogProvider;
        }
        return this.hostProvider;
    }

    private void monitorUpdateWorkDone(IProgressMonitor monitor) {
        ImportProvider provider = this.getCurrentProvider();
        if (this.sourceType == ImportSourceType.LOCAL) {
            int bytesRead = ((LocalProvider)provider).getBytesRead();
            logger.finest("bytesRead: " + bytesRead);
            monitor.worked(bytesRead);
        } else if (this.sourceType == ImportSourceType.CATALOG || this.sourceType == ImportSourceType.ZOS) {
            logger.finest("resourcesRead: 1");
            monitor.worked(1);
        }
    }

    private void monitorBeginTask(IProgressMonitor monitor) {
        ImportProvider provider = this.getCurrentProvider();
        int totalSizeAllResources = provider.getTotalSizeAllResources();
        logger.finest("totalSizeAllFiles: " + totalSizeAllResources);
        monitor.beginTask("", totalSizeAllResources);
    }

    public void processCancel() {
        ImportProvider provider = this.getCurrentProvider();
        provider.reset();
    }

    public void addIMSResources(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, IOException, ImporterException, CoreException, ModelException, ConnectionException {
        this.psbsAlreadyInProject = null;
        this.dbdsAlreadyInProject = null;
        ImportProvider provider = this.getCurrentProvider();
        if (this.instanceTSVers != null && !this.instanceTSVers.isEmpty()) {
            ((CatalogProvider)provider).setSpecificInstanceTSVers(this.instanceTSVers);
        }
        int c = 0;
        long startTime = System.currentTimeMillis();
        this.monitorBeginTask(monitor);
        while (provider.hasMoreModels()) {
            ++c;
            IMSResourceToImport currRes = provider.nextModel();
            if (currRes.isDBD()) {
                logger.finest("DBD Name: " + currRes.getDbdName());
            } else {
                logger.finest("PSB Name: " + currRes.getPsbName());
            }
            if (currRes.isPSB()) {
                inserts = new Object[]{currRes.getPsbName()};
                monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORTED_PSB", inserts));
            } else {
                inserts = new Object[]{currRes.getDbdName()};
                monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORTED_DBD", inserts));
                if (this.sourceType == ImportSourceType.CATALOG) {
                    ((DbdModel)currRes.getModel()).setVersion(null);
                }
            }
            this.addResourcesAndUpdateReferences(currRes);
            this.monitorUpdateWorkDone(monitor);
            if (this.autoImportRefDbds) {
                if (provider instanceof CatalogProvider) {
                    ((CatalogProvider)provider).setSpecificInstanceTSVers(null);
                }
                this.recursiveSearchForReferencedDbds(monitor);
            }
            if (c % 100 == 0) {
                Runtime.getRuntime().gc();
                long totalMemory = Runtime.getRuntime().totalMemory();
                long freeMemory = Runtime.getRuntime().freeMemory();
                int totalResourcesAdded = this.psbToImportList.size() + this.dbdToImportList.size();
                logger.finest(c + " resources explicitly added - " + totalResourcesAdded + " total resources added - totalMemory: " + totalMemory + " freeMemory: " + freeMemory);
            }
            if (!monitor.isCanceled()) continue;
            this.processCancel();
            throw new InterruptedException();
        }
        provider.reset();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        int totalResourcesAdded = this.psbToImportList.size() + this.dbdToImportList.size();
        logger.finest(c + " resources explicitly added - " + totalResourcesAdded + " total resources added - totalMemory: " + totalMemory + " freeMemory: " + freeMemory);
        long endTime = System.currentTimeMillis();
        long elapsedTime = (endTime - startTime) / 1000L;
        long mins = elapsedTime / 60L;
        long seconds = elapsedTime % 60L;
        logger.finest("Add process took: " + mins + " mins and " + seconds + " seconds.");
    }

    public Vector<String> getUnfoundCatalogDbds() {
        Vector<String> retVal = null;
        retVal = this.catalogProvider == null ? null : ((CatalogProvider)this.catalogProvider).getUnfoundCatalogDbds();
        return retVal;
    }

    private void recursiveSearchForReferencedDbds(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, IOException, ImporterException, CoreException, ModelException, ConnectionException {
        Vector<ReferencedDbd> dbdsNeedingSearch = this.getDbdsNeedingSearch();
        if (dbdsNeedingSearch.size() == 0) {
            return;
        }
        Vector<String> dbdNamesNeedingSearch = new Vector<String>(dbdsNeedingSearch.size());
        int i = 0;
        while (i < dbdsNeedingSearch.size()) {
            ReferencedDbd refDbd = dbdsNeedingSearch.get(i);
            refDbd.setSearchAlreadyDone(true);
            String currDbdName = refDbd.getDbdName();
            dbdNamesNeedingSearch.add(currDbdName);
            ++i;
        }
        Vector<IMSResourceToImport> foundDBDs = null;
        if (this.sourceType == ImportSourceType.LOCAL) {
            foundDBDs = this.localProvider.getDbdModels(dbdNamesNeedingSearch, monitor);
        } else if (this.sourceType == ImportSourceType.CATALOG) {
            ((CatalogProvider)this.catalogProvider).resetUnfoundCatalogDbds();
            foundDBDs = this.catalogProvider.getDbdModels(dbdNamesNeedingSearch, monitor);
        } else if (this.sourceType == ImportSourceType.ZOS) {
            foundDBDs = this.hostProvider.getDbdModels(dbdNamesNeedingSearch, monitor);
        }
        if (foundDBDs != null && !foundDBDs.isEmpty()) {
            int i2 = 0;
            while (i2 < foundDBDs.size()) {
                IMSResourceToImport currResource = foundDBDs.get(i2);
                boolean dbdAlreadyInProject = ProjectTreeFileHelper.checkDBDFileInProjectTree(this.projectName, currResource.getDbdName());
                DbdModel dbdModel = (DbdModel)currResource.getModel();
                if (dbdAlreadyInProject) {
                    this.marshallTempDbd(dbdModel);
                    currResource.resourceName = currResource.getDbdName();
                    currResource.model = null;
                    if (this.dbdsAlreadyInProject == null) {
                        this.dbdsAlreadyInProject = new Vector();
                    }
                    this.dbdsAlreadyInProject.add(currResource);
                } else {
                    this.dbdToImportList.put(currResource.getDbdName(), currResource);
                    this.updateReferenceMapForDBD(dbdModel);
                    this.marshallTempDbd(dbdModel);
                    currResource.resourceName = currResource.getDbdName();
                    currResource.model = null;
                }
                if (this.sourceType == ImportSourceType.ZOS) {
                    this.marshallTempOriginalSource(currResource);
                }
                ++i2;
            }
        }
        if (monitor.isCanceled()) {
            this.processCancel();
            throw new InterruptedException();
        }
        this.recursiveSearchForReferencedDbds(monitor);
    }

    private Vector<ReferencedDbd> getDbdsNeedingSearch() {
        Vector<ReferencedDbd> retVal = new Vector<ReferencedDbd>();
        for (ReferencedDbd refDbd : this.referenceMap.values()) {
            String currDbdName = refDbd.getDbdName();
            if (refDbd.isSearchAlreadyDone() || this.dbdToImportList.containsKey(currDbdName)) continue;
            retVal.add(refDbd);
        }
        return retVal;
    }

    private void addResourcesAndUpdateReferences(IMSResourceToImport resource) throws CoreException, ModelException, IOException {
        if (this.referenceMap == null) {
            this.referenceMap = new HashMap();
        }
        if (resource.isPSB()) {
            PsbModel psbModel = (PsbModel)resource.getModel();
            boolean psbAlreadyInProject = ProjectTreeFileHelper.checkPSBFileInProjectTree(this.projectName, psbModel.getPsbName());
            if (psbAlreadyInProject) {
                resource.resourceName = resource.getPsbName();
                resource.model = null;
                if (this.psbsAlreadyInProject == null) {
                    this.psbsAlreadyInProject = new Vector();
                }
                this.psbsAlreadyInProject.add(resource);
            } else {
                String psbName = psbModel.getPsbName();
                if (this.getSourceType() == ImportSourceType.LOCAL || this.getSourceType() == ImportSourceType.ZOS) {
                    IMSResourceToImport existingResource = this.psbToImportList.get(psbName);
                    if (existingResource != null) {
                        if (!existingResource.getPath().equalsIgnoreCase(resource.getPath())) {
                            this.removePsb(psbName);
                            this.psbToImportList.put(psbName, resource);
                        }
                    } else {
                        this.psbToImportList.put(psbName, resource);
                    }
                } else {
                    this.psbToImportList.put(psbName, resource);
                }
                this.updateReferenceMapForPSB(psbModel);
                this.marshallTempPsb(psbModel);
                resource.resourceName = resource.getPsbName();
                resource.model = null;
                if (this.getSourceType() == ImportSourceType.ZOS) {
                    this.marshallTempOriginalSource(resource);
                    resource.setHostInputStream(null);
                }
            }
        } else {
            DbdModel dbdModel = (DbdModel)resource.getModel();
            boolean dbdAlreadyInProject = ProjectTreeFileHelper.checkDBDFileInProjectTree(this.projectName, resource.getDbdName());
            String encoding = dbdModel.getEncoding();
            if (encoding == null || encoding.isEmpty()) {
                dbdModel.setEncoding(this.defaultEncoding.toUpperCase());
            }
            if (dbdAlreadyInProject) {
                this.marshallTempDbd(dbdModel);
                resource.resourceName = resource.getDbdName();
                resource.model = null;
                if (this.dbdsAlreadyInProject == null) {
                    this.dbdsAlreadyInProject = new Vector();
                }
                this.dbdsAlreadyInProject.add(resource);
            } else {
                String dbdName = dbdModel.getDBDName();
                if (this.getSourceType() == ImportSourceType.LOCAL || this.getSourceType() == ImportSourceType.ZOS) {
                    IMSResourceToImport existingResource = this.dbdToImportList.get(dbdName);
                    if (existingResource != null) {
                        if (!existingResource.getPath().equalsIgnoreCase(resource.getPath())) {
                            this.removePsb(dbdName);
                            this.dbdToImportList.put(dbdName, resource);
                        }
                    } else {
                        this.dbdToImportList.put(dbdName, resource);
                    }
                } else {
                    this.dbdToImportList.put(dbdName, resource);
                }
                this.updateReferenceMapForDBD(dbdModel);
                this.marshallTempDbd(dbdModel);
                resource.resourceName = resource.getDbdName();
                resource.model = null;
                if (this.getSourceType() == ImportSourceType.ZOS) {
                    this.marshallTempOriginalSource(resource);
                    resource.setHostInputStream(null);
                }
            }
        }
    }

    private void marshallTempOriginalSource(IMSResourceToImport resource) throws CoreException, IOException {
        ByteArrayInputStream inForMarshall = resource.getHostInputStream();
        if (resource.isDBD()) {
            String name = resource.getDbdName();
            ProjectTreeFileHelper.marshallImportedDbdFile("IMS_Explorer_Catalog_ReadOnly", name, inForMarshall);
        } else {
            String name = resource.getPsbName();
            ProjectTreeFileHelper.marshallImportedPsbFile("IMS_Explorer_Catalog_ReadOnly", name, inForMarshall);
        }
        inForMarshall.close();
    }

    private void updateReferenceMapForPSB(PsbModel psbModel) {
        Object pcbDB;
        List<PcbDBModel> pcbDBList = psbModel.getDBPcbList();
        List<PcbGsamModel> gsamPcbDBList = psbModel.getGsamPcbList();
        Vector<String> refDbdList = new Vector<String>();
        int i = 0;
        while (pcbDBList != null && i < pcbDBList.size()) {
            pcbDB = pcbDBList.get(i);
            refDbdList.add(((PcbDBModel)pcbDB).getDbdName());
            ++i;
        }
        i = 0;
        while (gsamPcbDBList != null && i < gsamPcbDBList.size()) {
            pcbDB = gsamPcbDBList.get(i);
            refDbdList.add(((PcbGsamModel)pcbDB).getDbdName());
            ++i;
        }
        int totalNumReferenced = refDbdList.size();
        if (totalNumReferenced > 0) {
            int i2 = 0;
            while (i2 < refDbdList.size()) {
                String currDbdName = (String)refDbdList.get(i2);
                ReferencedDbd refDbd = this.referenceMap.get(currDbdName);
                if (refDbd == null) {
                    refDbd = new ReferencedDbd(currDbdName, psbModel.getPsbName(), null);
                    this.referenceMap.put(currDbdName, refDbd);
                } else {
                    refDbd.addPsbReferencer(psbModel.getPsbName());
                }
                ++i2;
            }
        }
    }

    private void updateReferenceMapForDBD(DbdModel dbd) {
        try {
            Iterator<String> refDBDList = dbd.getReferencedDBDs().iterator();
            if (refDBDList != null && refDBDList.hasNext()) {
                while (refDBDList.hasNext()) {
                    String currDbdName = refDBDList.next();
                    ReferencedDbd refDbd = this.referenceMap.get(currDbdName);
                    if (refDbd == null) {
                        refDbd = new ReferencedDbd(currDbdName, null, dbd.getDBDName());
                        this.referenceMap.put(currDbdName, refDbd);
                        continue;
                    }
                    refDbd.addDbdReferencer(dbd.getDBDName());
                }
            }
        }
        catch (ModelException e) {
            logger.throwing(this.getClass().getName(), "getLogicalDBDList()", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    public void batchImport(String projectName, String dirPath, IProgressMonitor monitor, String defaultEncoding) throws InterruptedException, InvocationTargetException, CoreException, ConnectionException, IOException {
        this.projectName = projectName;
        ProjectTreeFileHelper.createNewProject("IMS_Explorer_Catalog_ReadOnly");
        ProjectTreeFileHelper.createNewProject(projectName);
        this.sourceType = ImportSourceType.LOCAL;
        File dir = new File(dirPath);
        File[] files = dir.listFiles();
        Vector<String> filesToImport = new Vector<String>(files.length);
        int i = 0;
        while (i < files.length) {
            filesToImport.add(files[i].getPath());
            ++i;
        }
        this.localProvider = new LocalProvider(this);
        try {
            ((LocalProvider)this.localProvider).setFilePaths(filesToImport);
            this.addIMSResources(monitor);
            this.performFinish(monitor);
        }
        catch (ImporterException e) {
            logger.throwing(this.getClass().getName(), "batchImport()", (Throwable)e);
            logger.error((Throwable)e);
        }
        catch (ModelException e) {
            logger.throwing(this.getClass().getName(), "batchImport()", (Throwable)e);
            logger.error((Throwable)e);
        }
        catch (IOException e) {
            logger.throwing(this.getClass().getName(), "batchImport()", (Throwable)e);
            logger.error((Throwable)e);
        }
        catch (JAXBException e) {
            logger.throwing(this.getClass().getName(), "batchImport()", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    public void batchImportOld(String projectName, String dirPath, IProgressMonitor monitor, String defaultEncoding) throws InterruptedException, InvocationTargetException {
        this.importerExceptions = new Vector();
        IMSSourceImporter importer = new IMSSourceImporter();
        ArrayList<StatementSet> sSetsForCurrFile = null;
        StatementSet sSet = null;
        int psbCounter = 0;
        int dbdCounter = 0;
        int badSSetCounter = 0;
        File dir = new File(dirPath);
        File[] files = dir.listFiles();
        int numFiles = files.length;
        logger.finest("Total files for batch import: " + numFiles);
        int numWorkedPerFile = 100 / numFiles;
        monitor.beginTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD007"), 100);
        int i = 0;
        while (i < files.length) {
            File currFile = files[i];
            String resourceFilePath = currFile.getPath();
            try {
                sSetsForCurrFile = importer.createStatementSets(resourceFilePath);
            }
            catch (IOException iOException) {
                Object[] inserts = new Object[]{resourceFilePath};
                this.importerExceptions.add(new ImporterException(WorkbenchModelBundle.getError().getString("IMPORT_WIZ_005", inserts)));
            }
            catch (ImporterException e) {
                this.importerExceptions.add(e);
            }
            try {
                if (sSetsForCurrFile != null) {
                    int j = 0;
                    while (j < sSetsForCurrFile.size()) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        sSet = sSetsForCurrFile.get(j);
                        IImsResourceModel resModel = importer.processStatementSet(sSet);
                        if (resModel != null) {
                            if (resModel.isPSB()) {
                                PsbModel psbModel = (PsbModel)resModel;
                                String psbName = psbModel.getPsbName();
                                IFile psbMetaFile = ProjectTreeFileHelper.getPsbMetadataFile(projectName, psbName);
                                String metaFilePath = psbMetaFile.getFullPath().toString();
                                monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD004") + ": " + metaFilePath);
                                ByteArrayOutputStream psbOutputStream = new ByteArrayOutputStream();
                                psbModel.marshall(psbOutputStream);
                                ByteArrayInputStream psbInputStream = new ByteArrayInputStream(psbOutputStream.toByteArray());
                                if (!psbMetaFile.exists()) {
                                    psbMetaFile.create((InputStream)psbInputStream, true, null);
                                    ++psbCounter;
                                } else {
                                    error = new String[]{psbName};
                                    e = new ImporterException(WorkbenchModelBundle.getError().getString("DHB1752", error));
                                    this.importerExceptions.add(e);
                                }
                            } else {
                                DbdModel dbdModel = (DbdModel)resModel;
                                String dbdName = dbdModel.getDBDName();
                                String encoding = dbdModel.getEncoding();
                                if (encoding == null || encoding.isEmpty()) {
                                    dbdModel.setEncoding(defaultEncoding.toUpperCase());
                                }
                                IFile dbdMetadataFile = ProjectTreeFileHelper.getDbdMetadataFile(projectName, dbdName);
                                monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD004") + ": " + dbdMetadataFile.getFullPath().toString());
                                ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
                                dbdModel.marshall(dbdOutputStream);
                                ByteArrayInputStream dbdInputStream = new ByteArrayInputStream(dbdOutputStream.toByteArray());
                                if (!dbdMetadataFile.exists()) {
                                    dbdMetadataFile.create((InputStream)dbdInputStream, true, null);
                                    ++dbdCounter;
                                } else {
                                    error = new String[]{dbdName};
                                    e = new ImporterException(WorkbenchModelBundle.getError().getString("DHB1752", error));
                                    this.importerExceptions.add(e);
                                }
                            }
                        } else {
                            ++badSSetCounter;
                            logger.fine("resModel is null for sSet with type: " + ((Statement)sSet.statements.get((int)0)).type + " in file: " + sSet.filePath);
                        }
                        ++j;
                    }
                    logger.fine(psbCounter + " PSBs added. " + dbdCounter + " DBDs added.");
                    logger.fine("In file: " + sSet.filePath + " there were " + badSSetCounter + " StatementSets that were neither a valid PSB nor DBD.");
                }
            }
            catch (ImporterException e) {
                this.importerExceptions.add(e);
            }
            catch (ModelException e) {
                throw new InvocationTargetException(e);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            monitor.worked(numWorkedPerFile);
            ++i;
        }
        if (this.importerExceptions != null && this.importerExceptions.size() > 0) {
            StringBuffer buf = new StringBuffer();
            int i2 = 0;
            while (i2 < this.importerExceptions.size()) {
                buf.append(this.importerExceptions.get(i2).getMessage());
                buf.append("\n\n");
                ++i2;
            }
            logger.warn(buf.toString(), new Object[0]);
        }
    }

    public void setLocalProvider(ImportProvider localProvider) {
        this.localProvider = localProvider;
    }

    public void setHostProvider(ImportProvider hostProvider) {
        this.hostProvider = hostProvider;
    }

    public ImportProvider getHostProvider() {
        return this.hostProvider;
    }

    public void setCatalogProvider(ImportProvider catalogProvider) {
        this.catalogProvider = catalogProvider;
    }

    public ImportProvider getLocalProvider() {
        return this.localProvider;
    }

    public ImportProvider getCatalogProvider() {
        return this.catalogProvider;
    }

    public ImportSourceType getSourceType() {
        return this.sourceType;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setDbView(boolean genDbView) {
        this.genDbView = genDbView;
    }

    public boolean getDbView() {
        return this.genDbView;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, ImporterException, IOException, ModelException, JAXBException {
        int numDbds = this.dbdToImportList.size();
        int numPsbs = this.psbToImportList.size();
        int totalWork = this.sourceType == ImportSourceType.ZOS ? 3 * numDbds + 3 * numPsbs + this.psbNamesToGenDBViews.size() : 2 * numDbds + 2 * numPsbs + this.psbNamesToGenDBViews.size();
        monitor.beginTask("", totalWork);
        if (this.sourceType == ImportSourceType.ZOS) {
            this.moveOriginalSources(monitor);
        }
        this.moveDBDModelsToProject(monitor);
        this.movePSBModelsToProject(monitor);
        this.marshallDbds(monitor);
        this.marshallPsbs(monitor);
        Vector<String> allProjectDbds = ProjectTreeFileHelper.getDbdNamesInProject(this.projectName);
        if (allProjectDbds != null && !allProjectDbds.isEmpty() && this.genDbView) {
            this.marshallGeneratedDbviews(this.projectName, this.psbNamesToGenDBViews, monitor);
        }
        monitor.subTask(WorkbenchModelBundle.getLabel().getString("CLEAN_TEMP_FILES"));
        ProjectTreeFileHelper.removeAllTempResources((IProgressMonitor)this.nullMonitor);
        EnablementController enabler = new EnablementController(this.projectName, this.projectUUID);
        boolean addDbdsToWorkflow = false;
        if (!enabler.isProjectWorkflowEnabled()) {
            if (this.isNewProject) {
                enabler.workflowEnableProject();
                addDbdsToWorkflow = true;
            }
        } else {
            addDbdsToWorkflow = true;
        }
        if (addDbdsToWorkflow) {
            Object[] dbdNames = this.dbdToImportList.keySet().toArray();
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("WF_ENABLING_DBDS"));
            enabler.addImportedDBDsToWorkflow(dbdNames, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void moveOriginalSources(IProgressMonitor monitor) throws CoreException {
        long freeMemory;
        long totalMemory;
        Object[] inserts;
        Iterator<IMSResourceToImport> iter = this.dbdToImportList.values().iterator();
        int c = 0;
        while (iter.hasNext()) {
            IMSResourceToImport currRes = iter.next();
            String currDbdName = currRes.getDbdName();
            ProjectTreeFileHelper.moveImportedDbdFileToTarget(this.projectName, currDbdName);
            inserts = new Object[]{currDbdName};
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("SAVED_DBD", inserts));
            monitor.worked(1);
            if (++c % 100 != 0) continue;
            Runtime.getRuntime().gc();
            totalMemory = Runtime.getRuntime().totalMemory();
            freeMemory = Runtime.getRuntime().freeMemory();
            logger.finest(c + " DBDs moved - totalMemory: " + totalMemory + " freeMemory: " + freeMemory);
        }
        for (IMSResourceToImport currRes : this.psbToImportList.values()) {
            String currPsbName = currRes.getPsbName();
            ProjectTreeFileHelper.moveImportedPsbFileToTarget(this.projectName, currPsbName);
            inserts = new Object[]{currPsbName};
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("SAVED_PSB", inserts));
            monitor.worked(1);
            if (++c % 100 != 0) continue;
            Runtime.getRuntime().gc();
            totalMemory = Runtime.getRuntime().totalMemory();
            freeMemory = Runtime.getRuntime().freeMemory();
            logger.finest(c + " PSBs moved - totalMemory: " + totalMemory + " freeMemory: " + freeMemory);
        }
    }

    public void calculateDBViews2(IProgressMonitor monitor) throws CoreException, FileNotFoundException, ModelException {
        List<String> newImportedPsbs = this.getInMemoryPsbs();
        Vector<String> allProjectPsbs = ProjectTreeFileHelper.getPSBNamesInProject(this.projectName);
        monitor.beginTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD010"), allProjectPsbs.size());
        this.psbNamesToGenDBViews = this.calculateDBViews(monitor, newImportedPsbs, allProjectPsbs);
    }

    private void marshallTempPsb(PsbModel psb) throws CoreException, ModelException {
        IFile psbMetaFile = ProjectTreeFileHelper.getPsbMetadataFile("IMS_Explorer_Catalog_ReadOnly", psb.getPsbName());
        ByteArrayOutputStream psbOutputStream = new ByteArrayOutputStream();
        psb.marshall(psbOutputStream);
        ByteArrayInputStream psbInputStream = new ByteArrayInputStream(psbOutputStream.toByteArray());
        if (!psbMetaFile.exists()) {
            psbMetaFile.create((InputStream)psbInputStream, true, null);
        } else {
            psbMetaFile.setContents((InputStream)psbInputStream, true, true, null);
        }
    }

    private void marshallTempDbd(DbdModel dbd) throws CoreException, ModelException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject("IMS_Explorer_Catalog_ReadOnly");
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        IFile metaFile = ProjectTreeFileHelper.getDbdMetadataFile("IMS_Explorer_Catalog_ReadOnly", dbd.getDBDName());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        dbd.marshall(outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        if (!metaFile.exists()) {
            metaFile.create((InputStream)inputStream, true, null);
        } else {
            metaFile.setContents((InputStream)inputStream, true, true, null);
        }
    }

    private void moveDBDModelsToProject(IProgressMonitor monitor) throws CoreException {
        Iterator<IMSResourceToImport> iter = this.dbdToImportList.values().iterator();
        int c = 0;
        IFile destFile = null;
        IFile srcFile = null;
        while (iter.hasNext()) {
            IMSResourceToImport currRes = iter.next();
            String currDbdName = currRes.getDbdName();
            destFile = ProjectTreeFileHelper.getDbdMetadataFile(this.projectName, currDbdName);
            srcFile = ProjectTreeFileHelper.getDbdMetadataFile("IMS_Explorer_Catalog_ReadOnly", currDbdName);
            if (destFile.exists()) {
                destFile.delete(true, (IProgressMonitor)this.nullMonitor);
            }
            srcFile.move(destFile.getFullPath(), true, (IProgressMonitor)this.nullMonitor);
            Object[] inserts = new Object[]{currDbdName};
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("SAVED_DBD", inserts));
            monitor.worked(1);
            if (++c % 100 != 0) continue;
            Runtime.getRuntime().gc();
            long totalMemory = Runtime.getRuntime().totalMemory();
            long freeMemory = Runtime.getRuntime().freeMemory();
            logger.finest(c + " DBDs moved - totalMemory: " + totalMemory + " freeMemory: " + freeMemory);
        }
    }

    private void movePSBModelsToProject(IProgressMonitor monitor) throws CoreException {
        Iterator<IMSResourceToImport> iter = this.psbToImportList.values().iterator();
        int c = 0;
        IFile destFile = null;
        IFile srcFile = null;
        while (iter.hasNext()) {
            IMSResourceToImport currRes = iter.next();
            String currPsbName = currRes.getPsbName();
            destFile = ProjectTreeFileHelper.getPsbMetadataFile(this.projectName, currPsbName);
            srcFile = ProjectTreeFileHelper.getPsbMetadataFile("IMS_Explorer_Catalog_ReadOnly", currPsbName);
            if (destFile.exists()) {
                destFile.delete(true, (IProgressMonitor)this.nullMonitor);
            }
            srcFile.move(destFile.getFullPath(), true, (IProgressMonitor)this.nullMonitor);
            Object[] inserts = new Object[]{currRes.getPsbName()};
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("SAVED_PSB", inserts));
            monitor.worked(1);
            if (++c % 100 != 0) continue;
            Runtime.getRuntime().gc();
            long totalMemory = Runtime.getRuntime().totalMemory();
            long freeMemory = Runtime.getRuntime().freeMemory();
            logger.finest(c + " PSBs moved - totalMemory: " + totalMemory + " freeMemory: " + freeMemory);
        }
    }

    private void marshallDbds(IProgressMonitor monitor) throws CoreException, IOException, ModelException {
        Iterator<IMSResourceToImport> iter = this.dbdToImportList.values().iterator();
        int c = 0;
        DbdModel dbdModel = null;
        while (iter.hasNext()) {
            String filePath;
            IMSResourceToImport currRes = iter.next();
            String currDbdName = currRes.getDbdName();
            dbdModel = ProjectTreeFileHelper.unmarshalDbd(currDbdName, this.projectName);
            if (this.sourceType == ImportSourceType.LOCAL && (filePath = currRes.getPath()) != null && !filePath.isEmpty()) {
                this.saveImportedFileContents(currRes, (IProgressMonitor)this.nullMonitor);
            }
            this.generateImportedDbd(dbdModel, (IProgressMonitor)this.nullMonitor);
            Object[] inserts = new Object[]{currDbdName};
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("GENERATED_DBD", inserts));
            monitor.worked(1);
            if (++c % 100 != 0) continue;
            Runtime.getRuntime().gc();
            long totalMemory = Runtime.getRuntime().totalMemory();
            long freeMemory = Runtime.getRuntime().freeMemory();
            logger.finest(c + " DbdModels generated - totalMemory: " + totalMemory + " freeMemory: " + freeMemory);
        }
    }

    private void marshallPsbs(IProgressMonitor monitor) throws CoreException, ModelException, IOException {
        Iterator<IMSResourceToImport> iter = this.psbToImportList.values().iterator();
        int c = 0;
        PsbModel psbModel = null;
        while (iter.hasNext()) {
            String filePath;
            IMSResourceToImport currRes = iter.next();
            String currPsbName = currRes.getPsbName();
            psbModel = ProjectTreeFileHelper.unmarshalPsb(currPsbName, this.projectName);
            if (this.sourceType == ImportSourceType.LOCAL && (filePath = currRes.getPath()) != null && !filePath.isEmpty()) {
                this.saveImportedFileContents(currRes, (IProgressMonitor)this.nullMonitor);
            }
            this.generateImportedPSB(psbModel, this.projectName, (IProgressMonitor)this.nullMonitor);
            Object[] inserts = new Object[]{currRes.getPsbName()};
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("GENERATED_PSB", inserts));
            monitor.worked(1);
            if (++c % 100 != 0) continue;
            Runtime.getRuntime().gc();
            long totalMemory = Runtime.getRuntime().totalMemory();
            long freeMemory = Runtime.getRuntime().freeMemory();
            logger.finest(c + " PsbModels marshalled - totalMemory: " + totalMemory + " freeMemory: " + freeMemory);
        }
    }

    private List<String> calculateDBViews(IProgressMonitor monitor, List<String> newImportedPsbs, List<String> allProjectPsbs) throws CoreException, FileNotFoundException, ModelException {
        HashSet<String> psbsToGenDBViews = new HashSet<String>();
        if (this.dbdToImportList != null && this.dbdToImportList.size() > 0) {
            ArrayList<String> newImportedDbds = this.getImportedDBDNames();
            List<String> psbNames = ProjectTreeFileHelper.findRelatedPSBNames(this.projectName, newImportedDbds, monitor, allProjectPsbs);
            int i = 0;
            while (i < psbNames.size()) {
                psbsToGenDBViews.add(psbNames.get(i));
                ++i;
            }
        }
        int i = 0;
        while (i < newImportedPsbs.size()) {
            String currPsbName = newImportedPsbs.get(i);
            if (!psbsToGenDBViews.contains(currPsbName)) {
                psbsToGenDBViews.add(currPsbName);
            }
            ++i;
        }
        ArrayList<String> psbNamesToGenDBViews = new ArrayList<String>();
        Iterator iter = psbsToGenDBViews.iterator();
        while (iter.hasNext()) {
            psbNamesToGenDBViews.add((String)iter.next());
        }
        return psbNamesToGenDBViews;
    }

    private void marshallGeneratedDbviews(String projectName, List<String> listPsb, IProgressMonitor monitor) throws CoreException, ModelException {
        int i = 0;
        while (i < listPsb.size()) {
            String currPsbName = listPsb.get(i);
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD003") + ": " + currPsbName);
            Vector<DatabaseViewGeneratorException> exceptions = ProjectTreeFileHelper.marshallGeneratedDbView(projectName, currPsbName);
            if (this.reportDBViewWarnings) {
                this.helper = new DatabaseViewGeneratorExceptionHelper();
                this.helper.addExceptions(exceptions);
            }
            monitor.worked(1);
            ++i;
        }
    }

    private List<String> getInMemoryPsbs() {
        ArrayList<String> inMemoryPsbs = new ArrayList<String>();
        if (this.psbToImportList.size() > 0) {
            for (IMSResourceToImport currRes : this.psbToImportList.values()) {
                inMemoryPsbs.add(currRes.getPsbName());
            }
        }
        return inMemoryPsbs;
    }

    private ArrayList<String> getImportedDBDNames() {
        ArrayList<String> listImportedDbdNames = new ArrayList<String>(this.dbdToImportList.size());
        for (IMSResourceToImport currRes : this.dbdToImportList.values()) {
            listImportedDbdNames.add(currRes.getDbdName());
        }
        return listImportedDbdNames;
    }

    public ArrayList<String> getImportedPSBNames() {
        ArrayList<String> listImportedPsbNames = new ArrayList<String>(this.psbToImportList.size());
        for (IMSResourceToImport currRes : this.psbToImportList.values()) {
            listImportedPsbNames.add(currRes.getPsbName());
        }
        return listImportedPsbNames;
    }

    public int getNumResourcesSelected() {
        int retVal = 0;
        retVal += this.psbToImportList.size();
        return retVal += this.dbdToImportList.size();
    }

    private void generateImportedPSB(PsbModel psbModel, String projectName, IProgressMonitor monitor) throws CoreException, IOException, ModelException {
        IFile generatedSrcPsbFile = ProjectTreeFileHelper.getGenedSrcPsbFile(projectName, psbModel.getPsbName());
        String genedSrcFilePath = generatedSrcPsbFile.getName();
        monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD005") + ": " + genedSrcFilePath);
        ProjectTreeFileHelper.marshallGeneratedPsbFile(projectName, psbModel);
        IFile generatedDdlFile = ProjectTreeFileHelper.getGenedSrcPsbFile(projectName, psbModel.getPsbName() + ".ddl");
        monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD005") + ": " + generatedDdlFile.getFullPath().toString());
        ProjectTreeFileHelper.marshallGeneratedDdlFile(projectName, psbModel);
        IFile generatedCatSrcPSBFile = ProjectTreeFileHelper.getGenedCatalogSrcPsbFile(projectName, psbModel.getPsbName());
        monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD005") + ": " + generatedCatSrcPSBFile.getFullPath().toString());
        ProjectTreeFileHelper.marshallCatalogEnabledGeneratedPsbFile(projectName, psbModel);
    }

    private DbdModel getExistingDbd(String projectName, String dbdName) throws CoreException, ModelException {
        IFile dbdMetadataFile = ProjectTreeFileHelper.getDbdMetadataFile(projectName, dbdName);
        DbdModel retVal = new DbdModel(dbdMetadataFile.getContents());
        return retVal;
    }

    private void generateImportedDbd(DbdModel dbdModel, IProgressMonitor monitor) throws CoreException, IOException, ModelException {
        IFile generatedSrcDbdFile = ProjectTreeFileHelper.getGenedSrcDbdFile(this.projectName, dbdModel.getDbd().getDbdName());
        monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD006") + ": " + generatedSrcDbdFile.getFullPath().toString());
        ProjectTreeFileHelper.marshallGeneratedDbdFile(this.projectName, dbdModel);
        IFile generatedDdlFile = ProjectTreeFileHelper.getGenedSrcDbdFile(this.projectName, dbdModel.getDbd().getDbdName() + ".ddl");
        monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD006") + ": " + generatedDdlFile.getFullPath().toString());
        ProjectTreeFileHelper.marshallGeneratedDdlFile(this.projectName, dbdModel);
        IFile generatedCatSrcDbdFile = ProjectTreeFileHelper.getGenedCatalogSrcDbdFile(this.projectName, dbdModel.getDbd().getDbdName());
        monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD006") + ": " + generatedCatSrcDbdFile.getFullPath().toString());
        ProjectTreeFileHelper.marshallCatalogEnabledGeneratedDbdFile(this.projectName, dbdModel);
    }

    private void saveImportedFileContents(IMSResourceToImport sourceToImport, IProgressMonitor monitor) throws CoreException, IOException {
        IFile newResource;
        Object unqualFileName = null;
        boolean isDBD = sourceToImport.isDBD();
        String fileName = sourceToImport.getPath();
        File srcFile = new File(fileName);
        FileInputStream is = new FileInputStream(srcFile);
        unqualFileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
        if (((String)unqualFileName).contains(".")) {
            int dotPos = ((String)unqualFileName).lastIndexOf(".") + 1;
            String extension = ((String)unqualFileName).substring(dotPos);
            unqualFileName = ((String)unqualFileName).substring(0, ((String)unqualFileName).lastIndexOf(".")) + "_" + extension;
        }
        if (isDBD) {
            logger.finest("DBD Name: " + sourceToImport.getDbdName());
            logger.finest("DBD File Name: " + (String)unqualFileName);
            newResource = ProjectTreeFileHelper.getImportedDbdSourceFile(this.projectName, (String)unqualFileName);
            ProjectTreeFileHelper.marshallImportedDbdFile(this.projectName, (String)unqualFileName, is);
        } else {
            logger.finest("PSB Name: " + sourceToImport.getPsbName());
            logger.finest("PSB File Name: " + (String)unqualFileName);
            newResource = ProjectTreeFileHelper.getImportedPsbSourceFile(this.projectName, (String)unqualFileName);
            ProjectTreeFileHelper.marshallImportedPsbFile(this.projectName, (String)unqualFileName, is);
        }
        ((InputStream)is).close();
        monitor.subTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD004") + ": " + newResource.getFullPath().toString());
    }

    public Iterator<IMSResourceToImport> getSelectedPSBList() {
        return this.psbToImportList.values().iterator();
    }

    public Iterator<IMSResourceToImport> getSelectedDBDList() {
        Collection<IMSResourceToImport> dbdColl = this.dbdToImportList.values();
        Vector<IMSResourceToImport> dbdVector = new Vector<IMSResourceToImport>(dbdColl.size());
        for (IMSResourceToImport currDbd : dbdColl) {
            dbdVector.add(currDbd);
            currDbd.referencerList = new ArrayList();
            ReferencedDbd refDbd = this.referenceMap.get(currDbd.getDbdName());
            if (refDbd == null) continue;
            HashSet<String> referencerNames = refDbd.getReferencerNames();
            for (String referencerName : referencerNames) {
                currDbd.referencerList.add(referencerName);
            }
        }
        return dbdVector.iterator();
    }

    public void removeDbd(String dbdName) {
        this.dbdToImportList.remove(dbdName);
        if (this.referenceMap != null) {
            Vector<String> refsToRemove = null;
            for (ReferencedDbd currRefDbd : this.referenceMap.values()) {
                boolean noReferencersRemain = currRefDbd.removeDbdReferencer(dbdName);
                if (!noReferencersRemain) continue;
                if (refsToRemove == null) {
                    refsToRemove = new Vector<String>();
                }
                refsToRemove.add(currRefDbd.getDbdName());
            }
            if (refsToRemove != null) {
                int i = 0;
                while (i < refsToRemove.size()) {
                    String currRefToRemove = (String)refsToRemove.get(i);
                    this.referenceMap.remove(currRefToRemove);
                    ++i;
                }
            }
        }
    }

    public void removePsb(String psbName) {
        this.psbToImportList.remove(psbName);
        if (this.referenceMap != null) {
            Vector<String> refsToRemove = null;
            for (ReferencedDbd currRefDbd : this.referenceMap.values()) {
                boolean noReferencersRemain = currRefDbd.removePsbReferencer(psbName);
                if (!noReferencersRemain) continue;
                if (refsToRemove == null) {
                    refsToRemove = new Vector<String>();
                }
                refsToRemove.add(currRefDbd.getDbdName());
            }
            if (refsToRemove != null) {
                int i = 0;
                while (i < refsToRemove.size()) {
                    String currRefToRemove = (String)refsToRemove.get(i);
                    this.referenceMap.remove(currRefToRemove);
                    ++i;
                }
            }
        }
    }

    public Iterator<IMSResourceToImport> getNeededDBDList() {
        Collection<ReferencedDbd> collection;
        Vector<IMSResourceToImport> neededDbdVector = new Vector<IMSResourceToImport>();
        if (this.referenceMap != null && (collection = this.referenceMap.values()) != null) {
            for (ReferencedDbd refDbd : collection) {
                String dbdName = refDbd.getDbdName();
                boolean dbdInProjectTree = this.findDBDInProjectTree(dbdName);
                if (this.dbdToImportList.containsKey(dbdName) || dbdInProjectTree) continue;
                IMSResourceToImport neededDbd = new IMSResourceToImport(null, null);
                neededDbdVector.add(neededDbd);
                neededDbd.resourceName = dbdName;
                neededDbd.referencerList = new ArrayList();
                for (String currRef : refDbd.getReferencerNames()) {
                    neededDbd.referencerList.add(currRef);
                }
            }
        }
        return neededDbdVector.iterator();
    }

    public void setAutoImportRefDbds(boolean autoImportRefDbds) throws CoreException {
        this.autoImportRefDbds = autoImportRefDbds;
    }

    public boolean isAutoImportRefDbds() {
        return this.autoImportRefDbds;
    }

    private boolean findDBDInProjectTree(String dbdName) {
        boolean dbdFound = false;
        try {
            dbdFound = ProjectTreeFileHelper.checkDBDFileInProjectTree(this.projectName, dbdName);
        }
        catch (CoreException e) {
            logger.throwing(this.getClass().getName(), "findDBDInProjectTree()", (Throwable)e);
            logger.error((Throwable)e);
        }
        return dbdFound;
    }

    public void setSourceType(ImportSourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void mergeNewDbdWithExisting(IMSResourceToImport dbdRes, IProgressMonitor monitor) throws ModelException, CoreException, InvocationTargetException, InterruptedException, IOException, ImporterException, ConnectionException {
        DbdModel existingDbd = this.getExistingDbd(this.projectName, dbdRes.getDbdName());
        DbdModel newDbd = this.getExistingDbd("IMS_Explorer_Catalog_ReadOnly", dbdRes.getDbdName());
        dbdRes.model = newDbd;
        MergeDbd merge = new MergeDbd(existingDbd, newDbd);
        merge.compare();
        merge.moveAllDiffsRight();
        this.dbdToImportList.put(dbdRes.getDbdName(), dbdRes);
        this.updateReferenceMapForDBD(newDbd);
        this.marshallTempDbd(newDbd);
        dbdRes.resourceName = dbdRes.getDbdName();
        dbdRes.model = null;
        if (this.autoImportRefDbds) {
            this.recursiveSearchForReferencedDbds(monitor);
        }
    }

    public IMSResourceToImport getResourceAlreadyImported(String resourceName) {
        IMSResourceToImport retVal = this.psbToImportList.get(resourceName);
        if (retVal == null) {
            retVal = this.dbdToImportList.get(resourceName);
        }
        return retVal;
    }

    public Vector<ImporterException> getImporterExceptions() {
        Vector<ImporterException> retVal = null;
        if (this.sourceType == ImportSourceType.LOCAL) {
            retVal = ((LocalProvider)this.localProvider).getImporterExceptions();
        } else if (this.sourceType == ImportSourceType.ZOS) {
            retVal = ((HostProvider)this.hostProvider).getImporterExceptions();
        }
        return retVal;
    }

    public Vector<IMSResourceToImport> getPsbsAlreadyInProject() {
        return this.psbsAlreadyInProject;
    }

    public Vector<IMSResourceToImport> getDbdsAlreadyInProject() {
        return this.dbdsAlreadyInProject;
    }

    public void setProjectUUID(String projectUUID) {
        this.projectUUID = projectUUID;
    }

    public void setNewProject(boolean isNewProject) {
        this.isNewProject = isNewProject;
    }
}

