/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.importer.source;

import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.IImsResourceModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;

public class IMSResourceToImport {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public String filePath;
    public IImsResourceModel model;
    public String resourceName;
    public ArrayList<String> referencerList;
    private boolean isDBD;
    private ByteArrayInputStream hostInputStreamForMarshall;

    public IMSResourceToImport(IImsResourceModel model, String filePath) {
        this.model = model;
        this.filePath = filePath;
        if (model != null) {
            this.isDBD = model.isDBD();
        }
    }

    public String getPath() {
        return this.filePath;
    }

    public String toString() {
        if (this.model.isDBD()) {
            return ((DbdModel)this.model).getDBDName();
        }
        return ((PsbModel)this.model).getPsbName();
    }

    public String getDbdName() {
        if (this.model != null) {
            return ((DbdModel)this.model).getDBDName();
        }
        return this.resourceName;
    }

    public String getPsbName() {
        if (this.model != null) {
            return ((PsbModel)this.model).getPsbName();
        }
        return this.resourceName;
    }

    public boolean isPSB() {
        if (this.model != null) {
            return this.model.isPSB();
        }
        return !this.isDBD;
    }

    public boolean isDBD() {
        if (this.model != null) {
            return this.model.isDBD();
        }
        return this.isDBD;
    }

    public IImsResourceModel getModel() {
        return this.model;
    }

    public void setModel(IImsResourceModel model) {
        this.model = model;
        if (model != null) {
            this.isDBD = model.isDBD();
        }
    }

    public void setHostInputStream(ByteArrayInputStream is) {
        this.hostInputStreamForMarshall = is;
    }

    public ByteArrayInputStream getHostInputStream() {
        return this.hostInputStreamForMarshall;
    }
}

