/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.importer.source;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.zos.comm.IZOSConstants;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.cics.zos.model.PermissionDeniedException;
import com.ibm.im.ims.workbench.controller.importer.source.IMSResourceToImport;
import com.ibm.im.ims.workbench.controller.importer.source.ImportProvider;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceController;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.IImsResourceModel;
import com.ibm.im.ims.workbench.model.utilities.IMSSourceImporter;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;

public class HostProvider
implements ImportProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IMSSourceImporter importer;
    private ImportSourceController isController;
    private IMSResourceToImport currentModel;
    private Vector<Member> zOSFiles;
    private int fileIx;
    private ByteArrayInputStream inputStreamForMarshall;
    private Vector<PartitionedDataSet> impliedPdsList;
    private HashMap<PartitionedDataSet, Vector<Member>> impliedPdsMembers;
    private Vector<PartitionedDataSet> searchPdsList;
    private HashMap<PartitionedDataSet, Vector<Member>> searchPdsMembers;

    public HostProvider(ImportSourceController controller) {
        this.isController = controller;
        this.importer = new IMSSourceImporter();
        this.fileIx = 0;
        this.impliedPdsList = new Vector();
        this.impliedPdsMembers = new HashMap();
        this.searchPdsList = new Vector();
        this.searchPdsMembers = new HashMap();
    }

    public void setDataEntries(Vector<Member> zOSFiles) throws IOException, ImporterException {
        this.zOSFiles = zOSFiles;
    }

    @Override
    public Vector<IMSResourceToImport> getDbdModels(Vector<String> dbdNamesToImport, IProgressMonitor monitor) throws IOException, ImporterException, ConnectionException {
        Vector<IMSResourceToImport> retVal = new Vector<IMSResourceToImport>(dbdNamesToImport.size());
        HashSet<IMSResourceToImport> foundDbds = new HashSet<IMSResourceToImport>(dbdNamesToImport.size());
        HashSet<String> dbdNamesSet = new HashSet<String>();
        int i = 0;
        while (i < dbdNamesToImport.size()) {
            dbdNamesSet.add(dbdNamesToImport.get(i));
            ++i;
        }
        boolean allDbdsFoundAlready = false;
        Iterator<PartitionedDataSet> itImplicitPds = this.impliedPdsList.iterator();
        while (itImplicitPds.hasNext() && !allDbdsFoundAlready) {
            if (monitor.isCanceled()) break;
            PartitionedDataSet currDS = itImplicitPds.next();
            Vector<Member> dataSetMembers = this.impliedPdsMembers.get(currDS);
            Iterator<Member> itMember = dataSetMembers.iterator();
            while (itMember.hasNext() && !allDbdsFoundAlready) {
                IMSResourceToImport foundDbd;
                Member currMember = itMember.next();
                if (!dbdNamesSet.contains(currMember.getName()) || foundDbds.contains(currMember.getName()) || (foundDbd = this.getDbdInMember(currMember, currMember.getName())) == null) continue;
                if (this.inputStreamForMarshall != null) {
                    foundDbd.setHostInputStream(this.inputStreamForMarshall);
                }
                foundDbds.add(foundDbd);
                Object[] inserts = new Object[]{foundDbd.getDbdName()};
                monitor.subTask(WorkbenchModelBundle.getLabel().getString("FOUND_DBD", inserts));
                if (foundDbds.size() != dbdNamesToImport.size()) continue;
                allDbdsFoundAlready = true;
            }
        }
        if (!allDbdsFoundAlready) {
            Iterator<PartitionedDataSet> itExplicitPds = this.searchPdsList.iterator();
            while (itExplicitPds.hasNext() && !allDbdsFoundAlready) {
                if (monitor.isCanceled()) break;
                PartitionedDataSet currDS = itExplicitPds.next();
                Vector<Member> dataSetMembers = this.searchPdsMembers.get(currDS);
                Iterator<Member> itMember = dataSetMembers.iterator();
                while (itMember.hasNext() && !allDbdsFoundAlready) {
                    IMSResourceToImport foundDbd;
                    Member currMember = itMember.next();
                    if (!dbdNamesSet.contains(currMember.getName()) || foundDbds.contains(currMember.getName()) || (foundDbd = this.getDbdInMember(currMember, currMember.getName())) == null) continue;
                    if (this.inputStreamForMarshall != null) {
                        foundDbd.setHostInputStream(this.inputStreamForMarshall);
                    }
                    foundDbds.add(foundDbd);
                    Object[] inserts = new Object[]{foundDbd.getDbdName()};
                    monitor.subTask(WorkbenchModelBundle.getLabel().getString("FOUND_DBD", inserts));
                    if (foundDbds.size() != dbdNamesToImport.size()) continue;
                    allDbdsFoundAlready = true;
                }
            }
        }
        Iterator it = foundDbds.iterator();
        while (it.hasNext()) {
            retVal.add((IMSResourceToImport)it.next());
        }
        return retVal;
    }

    public Vector<ImporterException> getImporterExceptions() {
        return this.importer.getImporterExceptions();
    }

    private IMSResourceToImport getDbdInMember(Member member, String currDbdName) throws IOException, ImporterException, ConnectionException {
        IMSSourceImporter tempImporter = new IMSSourceImporter();
        tempImporter.setImportResourcePath(this.getFileReader((DataEntry)member), member.getPath());
        while (tempImporter.hasMoreModels()) {
            IImsResourceModel oneModel = tempImporter.getNextResourceModel();
            if (oneModel == null || !oneModel.isDBD() || !((DbdModel)oneModel).getDBDName().equals(currDbdName)) continue;
            return new IMSResourceToImport(oneModel, member.getPath());
        }
        return null;
    }

    @Override
    public boolean hasMoreModels() throws IOException, ImporterException, ConnectionException {
        do {
            DataEntry currDataEntry = null;
            if (!this.importer.hasMoreModels()) {
                boolean needNextPath = true;
                do {
                    if (this.fileIx >= this.zOSFiles.size()) {
                        return false;
                    }
                    currDataEntry = (DataEntry)this.zOSFiles.get(this.fileIx);
                    ++this.fileIx;
                    if (this.resourceAlreadyImported(currDataEntry.getPath())) continue;
                    this.importer.setImportResourcePath(this.getFileReader(currDataEntry), currDataEntry.getPath());
                    needNextPath = false;
                } while (needNextPath);
            }
            while (this.importer.hasMoreModels()) {
                IImsResourceModel oneModel = this.importer.getNextResourceModel();
                if (oneModel == null) continue;
                String currentPath = this.importer.getPath();
                this.currentModel = new IMSResourceToImport(oneModel, currentPath);
                if (this.inputStreamForMarshall != null) {
                    this.currentModel.setHostInputStream(this.inputStreamForMarshall);
                }
                return true;
            }
        } while (this.fileIx < this.zOSFiles.size());
        return false;
    }

    private BufferedReader getFileReader(DataEntry dataEntry) throws FileNotFoundException, PermissionDeniedException, ConnectionException {
        ByteArrayOutputStream baos = dataEntry.getZOSConnectable().getContents(dataEntry, IZOSConstants.FileType.ASCII);
        byte[] ba = baos.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(ba);
        this.inputStreamForMarshall = new ByteArrayInputStream(ba);
        InputStreamReader reader = new InputStreamReader(in);
        return new BufferedReader(reader);
    }

    private boolean resourceAlreadyImported(String resourcePath) {
        IMSResourceToImport existingResource;
        String resourceName = resourcePath.substring(resourcePath.lastIndexOf(File.separator) + 1);
        if (resourceName.contains(".")) {
            resourceName = resourceName.substring(0, resourceName.lastIndexOf("."));
        }
        return (existingResource = this.isController.getResourceAlreadyImported(resourceName.toUpperCase())) != null && existingResource.getPath().equalsIgnoreCase(resourcePath);
    }

    @Override
    public IMSResourceToImport nextModel() {
        return this.currentModel;
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getTotalSizeAllResources() {
        return this.zOSFiles.size();
    }

    public void addSearchDataSet(PartitionedDataSet pds, Vector<Member> allPdsMembers) {
        this.searchPdsList.add(pds);
        this.searchPdsMembers.put(pds, allPdsMembers);
    }

    public void addImpliedDataSet(PartitionedDataSet pds, Vector<Member> allPdsMembers) {
        this.impliedPdsList.add(pds);
        this.impliedPdsMembers.put(pds, allPdsMembers);
    }

    public void removeSearchPds(int index) {
        this.searchPdsList.remove(index);
    }

    public void moveSearchPdsUp(int index) {
        PartitionedDataSet tempPds = this.searchPdsList.remove(index);
        this.searchPdsList.add(index - 1, tempPds);
    }

    public void moveSearchPdsDown(int index) {
        PartitionedDataSet tempPds = this.searchPdsList.remove(index);
        this.searchPdsList.add(index + 1, tempPds);
    }

    public Vector<PartitionedDataSet> getPdsSearchList() {
        return this.searchPdsList;
    }

    public void clearPreviousImpliedDatasets() {
        this.impliedPdsList.clear();
        this.impliedPdsMembers.clear();
    }

    @Override
    public void reset() {
        this.importer.resetSSReader();
        this.fileIx = 0;
        this.zOSFiles.clear();
    }
}

