/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.importer.source;

import com.ibm.im.ims.workbench.controller.importer.source.IMSResourceToImport;
import com.ibm.im.ims.workbench.controller.importer.source.ImportProvider;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceController;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CatalogProvider
implements ImportProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private String connProfileNameUsed;
    private String connUrl;
    private Iterator<String> psbNamesIterator;
    private Iterator<String> dbdNamesIterator;
    private IMSResourceToImport currentModel;
    private ImportSourceController isController;
    private int totalResourceNumber;
    private String instanceTSVers = null;
    private Vector<String> unfoundCatalogDbds = new Vector();
    private static final String SOURCE_NOT_DEFINED_IN_CATALOG = "AIB return code (AIBRETRN): 108 AIB reason code (AIBREASN): 338";

    public CatalogProvider(ImportSourceController controller) {
        this.isController = controller;
        this.totalResourceNumber = 0;
    }

    public void setSpecificInstanceTSVers(String instanceTSVers) {
        this.instanceTSVers = instanceTSVers;
    }

    private boolean resourceAlreadyImported(String resourceName) {
        return this.isController.getResourceAlreadyImported(resourceName) != null;
    }

    @Override
    public boolean hasMoreModels() {
        if (this.psbNamesIterator != null && this.psbNamesIterator.hasNext()) {
            String psbName = this.psbNamesIterator.next();
            this.currentModel = null;
            if (!this.resourceAlreadyImported(psbName)) {
                this.currentModel = this.getPsbModel(psbName, (IProgressMonitor)new NullProgressMonitor());
            }
            if (this.currentModel != null) {
                return true;
            }
            if (this.currentModel == null) {
                while (this.psbNamesIterator.hasNext()) {
                    psbName = this.psbNamesIterator.next();
                    if (this.resourceAlreadyImported(psbName)) continue;
                    this.currentModel = this.getPsbModel(this.psbNamesIterator.next(), (IProgressMonitor)new NullProgressMonitor());
                    if (this.currentModel == null) continue;
                    return true;
                }
            }
        }
        if (this.dbdNamesIterator != null && this.dbdNamesIterator.hasNext()) {
            String dbdName = this.dbdNamesIterator.next();
            this.currentModel = null;
            if (!this.resourceAlreadyImported(dbdName)) {
                this.currentModel = this.getDbdModel(dbdName, (IProgressMonitor)new NullProgressMonitor());
            }
            if (this.currentModel != null) {
                return true;
            }
            if (this.currentModel == null) {
                while (this.dbdNamesIterator.hasNext()) {
                    dbdName = this.dbdNamesIterator.next();
                    if (this.resourceAlreadyImported(dbdName)) continue;
                    this.currentModel = this.getDbdModel(this.dbdNamesIterator.next(), (IProgressMonitor)new NullProgressMonitor());
                    if (this.currentModel == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IMSResourceToImport nextModel() {
        return this.currentModel;
    }

    public void setPsbNamesToImport(Vector<String> psbNamesToImport) {
        this.psbNamesIterator = psbNamesToImport.iterator();
        this.totalResourceNumber += psbNamesToImport.size();
    }

    public void setDbdNamesToImport(Vector<String> dbdNamesToImport) {
        this.dbdNamesIterator = dbdNamesToImport.iterator();
        this.totalResourceNumber += dbdNamesToImport.size();
    }

    private IMSResourceToImport getPsbModel(String psbName, IProgressMonitor monitor) {
        IMSResourceToImport retVal = null;
        try {
            IImsDbConnection conn = ImsDbUtils.getConnectionByName((String)this.connProfileNameUsed, (boolean)true);
            byte[] psbXmlBytes = null;
            psbXmlBytes = this.instanceTSVers != null && !this.instanceTSVers.isEmpty() ? conn.getPsbXmlByTS(psbName, this.instanceTSVers) : conn.getPsbXml(psbName);
            PsbModel psbModel = new PsbModel(new ByteArrayInputStream(psbXmlBytes));
            retVal = new IMSResourceToImport(psbModel, null);
            Object[] inserts = new Object[]{psbName};
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("FOUND_PSB", inserts));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    public IMSResourceToImport getDbdModel(String dbdName, IProgressMonitor monitor) {
        IMSResourceToImport retVal = null;
        try {
            DbdModel dbdModel;
            String currXMLSchemaVersion;
            IImsDbConnection conn = ImsDbUtils.getConnectionByName((String)this.connProfileNameUsed, (boolean)true);
            byte[] xml = null;
            xml = this.instanceTSVers != null && !this.instanceTSVers.isEmpty() ? conn.getDbdXmlByTS(dbdName, this.instanceTSVers) : conn.getDbdXml(dbdName);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("XML string for DBD=" + dbdName + " from GUR: " + new String(xml, "Cp1047"));
            }
            if ((currXMLSchemaVersion = (dbdModel = new DbdModel(new ByteArrayInputStream(xml))).getXMLSchemaVersion()) == null || currXMLSchemaVersion.isEmpty()) {
                dbdModel.setXMLSchemaVersion("1");
            }
            retVal = new IMSResourceToImport(dbdModel, null);
            Object[] inserts = new Object[]{dbdName};
            monitor.subTask(WorkbenchModelBundle.getLabel().getString("FOUND_DBD", inserts));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    @Override
    public Vector<IMSResourceToImport> getDbdModels(Vector<String> dbdNamesToImport, IProgressMonitor monitor) {
        Vector<IMSResourceToImport> retVal;
        block9: {
            retVal = null;
            if (dbdNamesToImport == null || dbdNamesToImport.isEmpty()) {
                return null;
            }
            retVal = new Vector<IMSResourceToImport>(dbdNamesToImport.size());
            String dbdName = "";
            try {
                IImsDbConnection conn = ImsDbUtils.getConnectionByName((String)this.connProfileNameUsed, (boolean)true);
                int i = 0;
                while (i < dbdNamesToImport.size()) {
                    block10: {
                        DbdModel dbdModel;
                        String currXMLSchemaVersion;
                        if (monitor.isCanceled()) break block9;
                        dbdName = dbdNamesToImport.get(i);
                        byte[] xml = null;
                        try {
                            xml = conn.getDbdXml(dbdName);
                        }
                        catch (Exception e) {
                            if (!this.unfoundDbdExist(e, dbdName)) {
                                throw e;
                            }
                            break block10;
                        }
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("XML string for DBD=" + dbdName + " from GUR: " + new String(xml, "Cp1047"));
                        }
                        if ((currXMLSchemaVersion = (dbdModel = new DbdModel(new ByteArrayInputStream(xml))).getXMLSchemaVersion()) == null || currXMLSchemaVersion.isEmpty()) {
                            dbdModel.setXMLSchemaVersion("1");
                        }
                        retVal.add(new IMSResourceToImport(dbdModel, null));
                        Object[] inserts = new Object[]{dbdName};
                        monitor.subTask(WorkbenchModelBundle.getLabel().getString("FOUND_DBD", inserts));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        dbdNamesToImport = null;
        return retVal;
    }

    private boolean unfoundDbdExist(Exception e, String dbdName) {
        boolean retVal = false;
        String errorMsg = e.getMessage();
        if (errorMsg.contains("The DBD resource") && errorMsg.contains("requested by the GUR is not found in the IMS Catalog") && errorMsg.contains("AIB return code (AIBRETRN): 108 AIB reason code (AIBREASN): 344")) {
            this.unfoundCatalogDbds.add(dbdName);
            retVal = true;
        }
        return retVal;
    }

    public Vector<String> getUnfoundCatalogDbds() {
        return this.unfoundCatalogDbds;
    }

    public void resetUnfoundCatalogDbds() {
        this.unfoundCatalogDbds.clear();
    }

    public void setConnProfileNameUsed(String connProfileNameUsed) {
        this.connProfileNameUsed = connProfileNameUsed;
    }

    public void setConnUrl(String connUrl) {
        this.connUrl = connUrl;
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getTotalSizeAllResources() {
        return this.totalResourceNumber;
    }

    @Override
    public void reset() {
    }
}

