/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.importer.datastructure;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDataStructureType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSelectedDataStructureType;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import java.util.Scanner;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class PreviewAndSelectDSController {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private WorkflowMapCaseType workflowMapCase;
    private String projectName;
    private String[] dsNames;
    private String[] dsLocation;
    private WorkflowDataStructureType workflowDataStructure;
    private FieldImportWorkflowController fieldImportWorkflowController;

    public PreviewAndSelectDSController(WorkflowMapCaseType workflowMapCase, String projectName, FieldImportWorkflowController fieldImportWorkflowController) {
        this.workflowMapCase = workflowMapCase;
        this.projectName = projectName;
        this.fieldImportWorkflowController = fieldImportWorkflowController;
    }

    public String[] getWorkflowCandidateDSNames() {
        logger.entering(this.getClass().getName(), "getDataStructureNames()", new Object[0]);
        WorkflowSegmentType workflowSegment = this.workflowMapCase.getParent();
        List<WorkflowDataStructureType> list = workflowSegment.getWorkflowCandidateDataStructure();
        this.dsNames = new String[list.size()];
        this.dsLocation = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            WorkflowDataStructureType dsType = list.get(i);
            this.dsNames[i] = dsType.getName();
            this.dsLocation[i] = dsType.getLocation();
            ++i;
        }
        logger.exiting(this.getClass().getName(), "getDataStructureNames()", new Object[0]);
        return this.dsNames;
    }

    private String getDataStructureLocation(int selectionIndex) {
        logger.entering(this.getClass().getName(), "getDSLocation(String selectedDS)", new Object[0]);
        String retVal = null;
        WorkflowSegmentType workflowSegment = this.workflowMapCase.getParent();
        List<WorkflowDataStructureType> list = workflowSegment.getWorkflowCandidateDataStructure();
        for (WorkflowDataStructureType dsType : list) {
            if (!this.dsNames[selectionIndex].equals(dsType.getName()) || !this.dsLocation[selectionIndex].equals(dsType.getLocation())) continue;
            retVal = dsType.getLocation();
            this.workflowDataStructure = dsType;
            break;
        }
        logger.exiting(this.getClass().getName(), "getDSLocation(String selectedDS)", new Object[0]);
        return retVal;
    }

    public String getDataStructureContents(int dsSelectionIndex) {
        logger.entering(this.getClass().getName(), "getDataStructureContents(String dataStructureName)", new Object[0]);
        String retVal = "";
        WorkflowSegmentType workflowSegment = this.workflowMapCase.getParent();
        WorkflowDBD workflowDBD = workflowSegment.getParent();
        try {
            IFile dsFile = FieldImportWorkflowModelUtil.getDsFile(this.projectName, workflowDBD.getName(), this.getDataStructureLocation(dsSelectionIndex));
            if (dsFile != null) {
                Scanner scanner = new Scanner(dsFile.getContents(), dsFile.getCharset());
                retVal = scanner.useDelimiter("\\A").next();
                scanner.close();
            }
        }
        catch (CoreException e) {
            logger.throwing(this.getClass().getName(), "getDataStructureContents(String dataStructureName)", (Throwable)e);
            logger.error((Throwable)e);
        }
        logger.exiting(this.getClass().getName(), "getDataStructureContents(String dataStructureLocation)", new Object[0]);
        return retVal;
    }

    public void doFinish(boolean isJDBCEnable) throws CoreException, ModelException, JAXBException, ConnectionException, IOException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        WorkflowDataStructureType workflowCandidateDS;
        logger.entering(this.getClass().getName(), "doFinish()", new Object[0]);
        if (this.workflowMapCase.getWorkflowSelectedDataStructure() != null) {
            this.workflowMapCase.setWorkflowSelectedDataStructure(null);
        }
        if ((workflowCandidateDS = this.workflowDataStructure) != null) {
            WorkflowSelectedDataStructureType workflowSelectedDS = new WorkflowSelectedDataStructureType();
            workflowSelectedDS.setName(workflowCandidateDS.getName());
            workflowSelectedDS.setLocation(workflowCandidateDS.getLocation());
            this.workflowMapCase.setWorkflowSelectedDataStructure(workflowSelectedDS);
            this.fieldImportWorkflowController.importDataStructure(this.workflowMapCase, workflowSelectedDS, isJDBCEnable);
            FieldImportWorkflowModelUtil.marshallWorkflow(this.fieldImportWorkflowController.getWorkflow(), this.projectName, true);
        }
        logger.exiting(this.getClass().getName(), "doFinish()", new Object[0]);
    }
}

