/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.importer.datastructure;

import com.ibm.ccl.pli.BaseValues;
import com.ibm.ccl.pli.PLIClassifier;
import com.ibm.ccl.pli.PLIComposedType;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.ccl.pli.PLISimpleType;
import com.ibm.ccl.pli.StringTypeValues;
import com.ibm.ccl.pli.impl.PLIArrayImpl;
import com.ibm.ccl.pli.impl.PLICodedStringTypeImpl;
import com.ibm.ccl.pli.impl.PLIFixedBoundArrayImpl;
import com.ibm.ccl.pli.impl.PLIFixedLboundArrayImpl;
import com.ibm.ccl.pli.impl.PLIFloatTypeImpl;
import com.ibm.ccl.pli.impl.PLIIntegerTypeImpl;
import com.ibm.ccl.pli.impl.PLIPackedTypeImpl;
import com.ibm.ccl.pli.impl.PLIPictureTypeImpl;
import com.ibm.ccl.pli.impl.PLIPointerTypeImpl;
import com.ibm.ccl.pli.impl.PLIVariableBoundArrayImpl;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.zos.comm.IZOSConstants;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.etools.cobol.COBOLAlphaNumericType;
import com.ibm.etools.cobol.COBOLAlphabeticType;
import com.ibm.etools.cobol.COBOLClassifier;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.COBOLFixedLengthArray;
import com.ibm.etools.cobol.COBOLNumericEditedType;
import com.ibm.etools.cobol.COBOLNumericType;
import com.ibm.etools.cobol.COBOLRedefiningElement;
import com.ibm.etools.cobol.COBOLSimpleType;
import com.ibm.etools.cobol.COBOLUsageValues;
import com.ibm.etools.cobol.COBOLVariableLengthArray;
import com.ibm.etools.cobol.impl.COBOLNumericTypeImpl;
import com.ibm.etools.tdlang.TDLangElement;
import com.ibm.etools.typedescriptor.ArrayTD;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.im.ims.metadata.dbd.RecfmType;
import com.ibm.im.ims.workbench.controller.importer.datastructure.CobolImportHelper;
import com.ibm.im.ims.workbench.controller.importer.datastructure.DSSA;
import com.ibm.im.ims.workbench.controller.importer.datastructure.ImportAction;
import com.ibm.im.ims.workbench.controller.importer.datastructure.ImportParseException;
import com.ibm.im.ims.workbench.controller.importer.datastructure.InformationException;
import com.ibm.im.ims.workbench.controller.importer.datastructure.PliImportHelper;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.FieldModelImpl;
import com.ibm.im.ims.workbench.model.IFieldContainer;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.FieldHolder;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ParseException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.SegmentHolder;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ImportDsToDbdController {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SegmentModel segment;
    private DbdModel dbdModel;
    private String projectName;
    private boolean isLocalImport;
    private String lastDirectory = null;
    private String fileType = null;
    private Map<String, ArrayList<SegmentModel>> mapFileNameToDataStructures = new HashMap<String, ArrayList<SegmentModel>>();
    private Map<SegmentModel, TDLangElement> mapDataStructureToLangElement = new HashMap<SegmentModel, TDLangElement>();
    private Vector<PartitionedDataSet> pdsList = new Vector();
    private HashMap<PartitionedDataSet, Vector<Member>> allPdsMembers = new HashMap();
    private Member member;
    private Throwable currentException;
    public static final String PLI = "PL/I";
    public static final String COBOL = "COBOL";
    private String fileName;
    private String folderName;
    private String parseFileName;
    private File tempFile;
    private Vector<DSSA> dsSegmentAssociations = new Vector();
    private SegmentModel currDataStructure;
    private Vector<InformationException> informationExceptionList;
    public static final String COBOL_DS = WorkbenchModelBundle.getLabel().getString("WB496T1");
    public static final String COBOL_PROG = WorkbenchModelBundle.getLabel().getString("WB496T2");
    public static final String PLI_DS = WorkbenchModelBundle.getLabel().getString("WB496T3");
    public static final String PLI_PROG = WorkbenchModelBundle.getLabel().getString("WB496T4");
    public static final String[] fileTypes = new String[]{COBOL_DS, COBOL_PROG, PLI_DS, PLI_PROG};

    public ImportDsToDbdController(SegmentModel segment, DbdModel dbdModel, String projectName) {
        this.segment = segment;
        this.dbdModel = dbdModel;
        this.projectName = projectName;
    }

    public SegmentModel getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentModel seg) {
        this.segment = seg;
    }

    public Vector<SegmentModel> getSegmentModels() {
        return this.segment.getDbdModel().getSegments();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public static void moveFile(String projectName, IFile srcFile, IFile targetFile) throws IOException, CoreException {
        ByteArrayOutputStream out = ImportDsToDbdController.dupFile(srcFile.getRawLocation().toOSString());
        ImportDsToDbdController.putContentsInTempFile(targetFile, out);
        out.flush();
        out.close();
        Utility.deleteTempFile(srcFile);
    }

    private boolean isCOBOLOrPLIFile(String fileName) {
        return ImportDsToDbdController.isCOBOLFile(fileName) || ImportDsToDbdController.isPLIFile(fileName);
    }

    public static boolean isCOBOLFile(String fileName) {
        boolean retVal = false;
        if (fileName.indexOf(".cbl") > 0 || fileName.indexOf(".cpy") > 0 || fileName.indexOf(".ccp") > 0 || fileName.indexOf(".cob") > 0) {
            retVal = true;
        }
        return retVal;
    }

    protected static boolean isPLIFile(String fileName) {
        boolean retVal = false;
        if (fileName.indexOf(".pli") > 0 || fileName.indexOf(".inc") > 0 || fileName.indexOf(".mac") > 0) {
            retVal = true;
        }
        return retVal;
    }

    private static ByteArrayOutputStream dupFile(String fileName) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        File inFile = new File(fileName);
        FileInputStream in = new FileInputStream(inFile);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.flush();
        out.close();
        return out;
    }

    protected void createTempFileCopyOfLocalFile() throws IOException {
        String newExt = this.getExtensionForCurrFileType();
        this.tempFile = Utility.createFileWithNewExtension(this.folderName, this.fileName, newExt);
        File sourceFile = new File(this.folderName + File.separator + this.fileName);
        Utility.copy(sourceFile, this.tempFile);
    }

    public static String getFileType(String fileName) {
        String retVal = null;
        String lowerCaseFileName = fileName.toLowerCase();
        if (lowerCaseFileName.indexOf(".cbl") > 0) {
            retVal = COBOL_PROG;
        } else if (lowerCaseFileName.indexOf(".cpy") > 0) {
            retVal = COBOL_DS;
        } else if (lowerCaseFileName.indexOf(".pli") > 0) {
            retVal = PLI_PROG;
        } else if (lowerCaseFileName.indexOf(".inc") > 0) {
            retVal = PLI_DS;
        }
        return retVal;
    }

    private String getExtensionForCurrFileType() {
        String retVal = null;
        if (this.fileType.equals(fileTypes[0])) {
            retVal = ".cpy";
        } else if (this.fileType.equals(fileTypes[1])) {
            retVal = ".cbl";
        } else if (this.fileType.equals(fileTypes[2])) {
            retVal = ".inc";
        } else if (this.fileType.equals(fileTypes[3])) {
            retVal = ".pli";
        }
        return retVal;
    }

    public void prepareForInitialParse() throws ConnectionException, CoreException, IOException {
        if (this.tempFile != null && this.tempFile.exists()) {
            this.tempFile.delete();
        }
        this.tempFile = null;
        if (!this.isLocalImport) {
            Member de = this.getSelectedMember(this.folderName, this.fileName);
            this.tempFile = this.createTempDataEntryFile((DataEntry)de, this.fileName);
            this.parseFileName = this.tempFile.getAbsolutePath();
        } else {
            if (!this.isCOBOLOrPLIFile(this.fileName)) {
                this.createTempFileCopyOfLocalFile();
                this.parseFileName = this.tempFile.getAbsolutePath();
            } else {
                this.fileType = ImportDsToDbdController.getFileType(this.fileName);
                this.parseFileName = this.folderName + File.separator + this.fileName;
            }
            logger.info("Temp file for import: " + this.parseFileName, new Object[0]);
        }
    }

    public void prepareForReparse() throws IOException {
        if (this.tempFile == null) {
            this.createTempFileCopyOfLocalFile();
            this.parseFileName = this.tempFile.getAbsolutePath();
        } else {
            this.tempFile = Utility.renameFile(this.tempFile, this.getExtensionForCurrFileType());
            this.parseFileName = this.tempFile.getAbsolutePath();
        }
        logger.info("Temp file for import: " + this.parseFileName, new Object[0]);
    }

    public void addDsSegmentAssociation(DSSA newDssa) {
        this.dsSegmentAssociations.add(newDssa);
    }

    public void removeDsSegmentAssociation(DSSA dssaToRemove) {
        int index = this.getAssocationIndex(dssaToRemove);
        this.dsSegmentAssociations.remove(index);
    }

    public int getAssocationIndex(DSSA theDssa) {
        int retVal = -1;
        int i = 0;
        while (i < this.dsSegmentAssociations.size()) {
            DSSA currDssa = this.dsSegmentAssociations.get(i);
            if (ImportDsToDbdController.dssaValuesAreEqual(currDssa.dataStructureName, theDssa.dataStructureName) && ImportDsToDbdController.dssaValuesAreEqual(currDssa.segmentName, theDssa.segmentName) && ImportDsToDbdController.dssaValuesAreEqual(currDssa.mapName, theDssa.mapName) && ImportDsToDbdController.dssaValuesAreEqual(currDssa.caseName, theDssa.caseName) && ImportDsToDbdController.dssaValuesAreEqual(currDssa.dsFileName, theDssa.dsFileName)) {
                retVal = i;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private static boolean dssaValuesAreEqual(String firstVal, String secondValue) {
        boolean retVal = false;
        if (firstVal == null) {
            firstVal = "";
        }
        if (secondValue == null) {
            secondValue = "";
        }
        if (firstVal.equals(secondValue)) {
            retVal = true;
        }
        return retVal;
    }

    public void parseDataStructureSourceFile(IProgressMonitor monitor) {
        logger.entering(this.getClass().getName(), "populateDataStructureCombo()", new Object[0]);
        try {
            ArrayList<SegmentModel> segModels = null;
            monitor.beginTask(WorkbenchModelBundle.getLabel().getString("IMPORT_WIZARD001") + "...", -1);
            try {
                this.currentException = null;
                segModels = ImportDsToDbdController.isCOBOLFile(this.parseFileName) ? this.handleCOBOLFile(this.parseFileName, this.projectName) : this.handlePLIFile(this.parseFileName, this.projectName);
            }
            catch (Exception e) {
                this.currentException = e;
            }
            monitor.done();
            if (this.currentException == null) {
                this.updateFileNameToSegmentModelsTable(segModels, this.folderName, this.fileName);
                this.deleteTempFile();
            }
        }
        catch (Throwable e) {
            this.currentException = e;
        }
        logger.exiting(this.getClass().getName(), "populateDataStructureCombo()", new Object[0]);
    }

    public void deleteTempFile() {
        if (this.tempFile != null && this.tempFile.exists()) {
            this.tempFile.delete();
        }
        this.tempFile = null;
    }

    public String getParseErrorMessage() {
        MessageFormat formatter = new MessageFormat(WorkbenchModelBundle.getError().getString("IMPORT_ERR_04"), Locale.getDefault());
        String parseFileShortName = this.parseFileName.substring(this.parseFileName.lastIndexOf(File.separator) + 1);
        Object[] messageArguments = new Object[]{ImportDsToDbdController.isCOBOLFile(parseFileShortName) ? COBOL : PLI, parseFileShortName};
        return formatter.format(messageArguments);
    }

    private File createTempDataEntryFile(DataEntry de, String fileName) throws ConnectionException, CoreException, IOException {
        try {
            IFile tempFile = ProjectTreeFileHelper.getTempFile(this.projectName, ImportDsToDbdController.getTempFileName(this.fileType, Utility.removeFileExt(fileName)));
            if (tempFile != null) {
                IZOSConnectable zosConn = de.getZOSConnectable();
                ByteArrayOutputStream out = zosConn.getContents(de, IZOSConstants.FileType.ASCII);
                ImportDsToDbdController.putContentsInTempFile(tempFile, out);
                out.flush();
                out.close();
            }
            return new File(tempFile.getLocation().toOSString());
        }
        catch (FileNotFoundException e) {
            String path = de.getParentPath();
            String name = de.getName();
            Object[] error = new String[]{name, path};
            ImporterException db = new ImporterException(WorkbenchModelBundle.getError().getString("DHB1754", error));
            db.initCause(e);
            logger.throwing(this.getClass().getName(), "createTempDataEntryFile", (Throwable)db);
            return null;
        }
    }

    protected static String getTempFileName(String fileType, String fileName) {
        if (fileType.equals(fileTypes[0])) {
            fileName = (String)fileName + ".cpy";
        } else if (fileType.equals(fileTypes[1])) {
            fileName = (String)fileName + ".cbl";
        } else if (fileType.equals(fileTypes[2])) {
            fileName = (String)fileName + ".inc";
        } else if (fileType.equals(fileTypes[3])) {
            fileName = (String)fileName + ".pli";
        }
        return fileName;
    }

    public static void putContentsInTempFile(IFile tempFile, ByteArrayOutputStream out) throws CoreException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(out.toByteArray());
        if (tempFile.exists()) {
            tempFile.setContents((InputStream)bais, true, false, null);
        } else {
            tempFile.create((InputStream)bais, 4096, null);
        }
        bais.close();
    }

    public void updateFileNameToSegmentModelsTable(ArrayList<SegmentModel> segModels, String folderName, String fileName) {
        if (this.isLocalImport) {
            this.mapFileNameToDataStructures.put(folderName + File.separator + fileName, segModels);
        } else {
            this.mapFileNameToDataStructures.put(folderName + "(" + fileName + ")", segModels);
        }
    }

    public String getFullFileName() {
        String fullFileName = null;
        fullFileName = this.isLocalImport ? this.folderName + File.separator + this.fileName : this.folderName + "(" + this.fileName + ")";
        return fullFileName;
    }

    public ArrayList<SegmentModel> getDataStructures() {
        String fullFileName = this.getFullFileName();
        ArrayList<SegmentModel> segModels = this.mapFileNameToDataStructures.get(fullFileName);
        return segModels;
    }

    public ArrayList<SegmentModel> handleCOBOLFile(String fileName, String projectName) throws IOException, ParseException, ImportParseException, ModelException, CoreException {
        CobolImportHelper cobolImporter = CobolImportHelper.getInstance();
        cobolImporter.setProjectName(projectName);
        cobolImporter.setWrapperFileName(null);
        cobolImporter.setTempOrigFilePath(null);
        Resource cobolResource = cobolImporter.importCobol(fileName);
        if (cobolImporter.is01WrapperFileCreated()) {
            ImportDsToDbdController.remove01File(cobolResource.getURI().toFileString());
            if (cobolImporter.isTempFileCreated()) {
                ImportDsToDbdController.remove01File(cobolImporter.getTempOrigFilePath());
            }
        }
        return this.parseCobolCopyBookModel(cobolResource);
    }

    private static void remove01File(String fileName) throws CoreException {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static boolean isFileInProjectDir(String projectName, String fileName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile tempFile = project.getFile(fileName);
        return tempFile.exists();
    }

    public static IFile getTempFile(String projectName, String tempFileName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile tempFile = project.getFile(tempFileName);
        return tempFile;
    }

    public ArrayList<SegmentModel> handlePLIFile(String fileName, String projectName) throws IOException, ParseException, ImportParseException, ModelException, CoreException {
        PliImportHelper pliImporter = PliImportHelper.getInstance();
        pliImporter.setProjectName(projectName);
        pliImporter.setWrapperFileName(null);
        pliImporter.setTempOrigFilePath(null);
        Resource pliResource = pliImporter.importPLI(fileName);
        if (pliImporter.is01WrapperFileCreated()) {
            ImportDsToDbdController.remove01File(pliResource.getURI().toFileString());
            if (pliImporter.isTempFileCreated()) {
                ImportDsToDbdController.remove01File(pliImporter.getTempOrigFilePath());
            }
        }
        return this.parsePliIncludeModel(pliResource);
    }

    public String[] getDataStructureNames() {
        ArrayList<SegmentModel> dataStructures = this.getDataStructures();
        if (dataStructures != null) {
            String[] dataStructureNames = new String[dataStructures.size()];
            int i = 0;
            while (i < dataStructureNames.length) {
                dataStructureNames[i] = dataStructures.get(i).getName();
                ++i;
            }
            return dataStructureNames;
        }
        return null;
    }

    private Member getSelectedMember(String deName, String mName) {
        PartitionedDataSet pds = null;
        Member member = null;
        for (PartitionedDataSet de : this.pdsList) {
            if (!de.getPath().equals(deName)) continue;
            pds = de;
            break;
        }
        if (pds != null) {
            Vector<Member> mbrs = this.allPdsMembers.get(pds);
            for (Member m : mbrs) {
                String currMemberName = m.getName();
                if (!currMemberName.equals(mName)) continue;
                member = m;
                break;
            }
        } else {
            member = this.member;
        }
        return member;
    }

    public Vector<DSSA> getDsSegmentAssociations() {
        return this.dsSegmentAssociations;
    }

    public boolean doFinishModel() throws ModelException {
        boolean isDirty = false;
        int i = 0;
        while (i < this.dsSegmentAssociations.size()) {
            DSSA currDssa = this.dsSegmentAssociations.get(i);
            SegmentModel existingSegmentModel = this.getExistingSegmentModel(currDssa.segmentName);
            ArrayList<SegmentModel> segmentModels = this.mapFileNameToDataStructures.get(currDssa.dsFileName);
            SegmentModel newSegmentModel = this.getSegmentModel(segmentModels, currDssa.dataStructureName);
            if (this.mergeSegmentsModel(newSegmentModel, existingSegmentModel, currDssa.mapName, currDssa.caseName)) {
                isDirty = true;
                this.segment = existingSegmentModel;
            }
            ++i;
        }
        return isDirty;
    }

    public Vector<String> getAffectedSegmentNames() {
        Vector<String> retVal = new Vector<String>();
        for (DSSA currDssa : this.dsSegmentAssociations) {
            retVal.add(currDssa.segmentName);
        }
        return retVal;
    }

    public SegmentModel getExistingSegmentModel(String segmentIMSName) throws ModelException {
        SegmentModel rootSegment;
        if (this.segment == null) {
            rootSegment = new SegmentModel(this.dbdModel);
            rootSegment.setName(segmentIMSName);
            rootSegment.setSegmentType(DBDConstants.GSAM);
            RecfmType recfm = this.dbdModel.getDbd().getAccess().getGsam().getDataSet().getRecfm();
            rootSegment.setMaxBytes(32760);
            if (recfm.equals((Object)RecfmType.V) || recfm.equals((Object)RecfmType.VB)) {
                rootSegment.setMaxBytes(32756);
            }
        } else {
            if (this.segment.getDbdModel().getRootSegment() == null) {
                this.segment.getDbdModel().setRootSegment(this.segment);
            }
            rootSegment = this.segment.getDbdModel().getRootSegment();
        }
        return this.getSegmentWithIMSName(rootSegment, segmentIMSName);
    }

    public SegmentModel getSegmentWithIMSName(SegmentModel currSegment, String segmentName) {
        SegmentModel retVal = null;
        DBDConstants dbdAccessType = currSegment.getDbdModel().getAccessType();
        String currSegmentName = dbdAccessType == DBDConstants.GSAM ? currSegment.getName() : currSegment.getImsName();
        if (currSegmentName.equalsIgnoreCase(segmentName)) {
            retVal = currSegment;
        } else {
            List<SegmentModel> array = currSegment.getChildSegments();
            int i = 0;
            while (i < array.size()) {
                SegmentModel currChildSegment = array.get(i);
                retVal = this.getSegmentWithIMSName(currChildSegment, segmentName);
                if (retVal != null) break;
                ++i;
            }
        }
        return retVal;
    }

    private SegmentModel getSegmentModel(ArrayList<SegmentModel> segmentHolders, String dataStructureName) {
        for (SegmentModel segmentModel : segmentHolders) {
            if (!segmentModel.getName().equals(dataStructureName)) continue;
            return segmentModel;
        }
        return null;
    }

    private Vector<ImportAction> buildImportActionList(IFieldContainer existingFieldContainer, SegmentModel newSegmentModel, String mappingName, String caseName, SegmentModel existingSegmentModel) throws ModelException {
        Vector<ImportAction> retVal = new Vector<ImportAction>();
        newSegmentModel.getFieldList(false, true);
        Vector<FieldModel> newFields = newSegmentModel.getTopLevelFieldList();
        this.assignActions(newFields, newSegmentModel, existingFieldContainer, retVal, existingSegmentModel);
        return retVal;
    }

    private void assignActions(Vector<FieldModel> newFields, SegmentModel newSegmentModel, IFieldContainer existingFieldContainer, Vector<ImportAction> retVal, SegmentModel existingSegmentModel) throws ModelException {
        int i = 0;
        while (i < newFields.size()) {
            FieldModel currField = newFields.get(i);
            currField.setName(this.convertFieldName(currField.getName()));
            this.assignAction(currField, newSegmentModel, existingFieldContainer, retVal, existingSegmentModel);
            if (currField.hasSubFields() && currField.getChildFields() != null) {
                this.assignActions(currField.getChildFields(), newSegmentModel, existingFieldContainer, retVal, existingSegmentModel);
            }
            ++i;
        }
    }

    private void assignAction(FieldModel newField, SegmentModel newSegmentModel, IFieldContainer existingFieldContainer, Vector<ImportAction> retVal, SegmentModel existingSegmentModel) throws ModelException {
        DBDConstants appDatatype;
        Vector<FieldModel> existingFieldsInRange;
        boolean multNewFieldsInRange = false;
        boolean multExistingFieldsInRange = false;
        Vector<FieldModel> newFieldsInRange = newSegmentModel.getFieldsInRange(newField, false, false);
        if (newFieldsInRange != null && !newFieldsInRange.isEmpty()) {
            multNewFieldsInRange = true;
        }
        if ((existingFieldsInRange = existingFieldContainer.getFieldsInRange(newField, false, true)) != null && existingFieldsInRange.size() > 1) {
            multExistingFieldsInRange = true;
        }
        if (!((appDatatype = newField.getAppDatatype()) == DBDConstants.STRUCT || appDatatype == DBDConstants.ARRAY || multNewFieldsInRange || multExistingFieldsInRange || existingFieldsInRange == null || existingFieldsInRange.isEmpty())) {
            ImportAction action = new ImportAction();
            action.setAction(ImportAction.Action.MERGE);
            action.setExistingFieldContainer(existingFieldContainer);
            action.setNewField(newField);
            action.setMergeTarget(existingFieldsInRange.get(0));
            retVal.add(action);
            ImportAction addAction = new ImportAction();
            addAction.setAction(ImportAction.Action.ADD);
            addAction.setExistingFieldContainer(existingFieldContainer);
            addAction.setNewField(newField);
            retVal.add(addAction);
        } else {
            ImportAction action = new ImportAction();
            action.setAction(ImportAction.Action.ADD);
            action.setExistingFieldContainer(existingFieldContainer);
            action.setExistingSegmentModel(existingSegmentModel);
            FieldModelImpl addedNewField = new FieldModelImpl((FieldModelImpl)newField);
            addedNewField.setChildFields(null);
            action.setNewField(addedNewField);
            retVal.add(action);
        }
    }

    private String convertFieldName(String fieldName) {
        String newFieldName = fieldName;
        if (fieldName.indexOf(45) >= 0) {
            newFieldName = fieldName.replace('-', '_');
        }
        return newFieldName;
    }

    public boolean mergeSegmentsModel(SegmentModel newSegmentModel, SegmentModel existingSegmentModel, String mappingName, String caseName) throws ModelException {
        IFieldContainer existingFieldContainer;
        boolean isDirty = false;
        if (caseName != null && !caseName.isEmpty()) {
            MappingModel mappingModel = existingSegmentModel.getMapping(mappingName);
            MappingCaseModel caseModel = mappingModel.getMappingCaseModel(caseName);
            existingFieldContainer = caseModel;
        } else {
            existingFieldContainer = existingSegmentModel;
        }
        Vector<ImportAction> importActions = this.buildImportActionList(existingFieldContainer, newSegmentModel, mappingName, caseName, existingSegmentModel);
        if (importActions != null && !importActions.isEmpty()) {
            isDirty = true;
            Properties nameChanges = new Properties();
            int i = 0;
            while (i < importActions.size()) {
                ImportAction importAction = importActions.get(i);
                importAction.performAction(nameChanges);
                ++i;
            }
            existingFieldContainer.getFieldList(true, true);
        }
        return isDirty;
    }

    public boolean isLocalImport() {
        return this.isLocalImport;
    }

    public void setLocalImport(boolean isLocalImport) {
        this.isLocalImport = isLocalImport;
    }

    public TDLangElement getLangElement(DSSA dssa) {
        ArrayList<SegmentModel> segmentModels = this.mapFileNameToDataStructures.get(dssa.dsFileName);
        SegmentModel segmentModel = this.getSegmentModel(segmentModels, dssa.dataStructureName);
        return this.mapDataStructureToLangElement.get(segmentModel);
    }

    public String getLastDirectory() {
        return this.lastDirectory;
    }

    public void setLastDirectory(String lastDirectory) {
        this.lastDirectory = lastDirectory;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void addPdsAndMembers(PartitionedDataSet pds, Vector<Member> members) {
        this.pdsList.add(pds);
        this.allPdsMembers.put(pds, members);
    }

    public boolean pdsAlreadyInList(PartitionedDataSet pds) {
        boolean retVal = false;
        int i = 0;
        while (i < this.pdsList.size()) {
            if (pds.equals((Object)this.pdsList.get(i))) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public String getParseFileName() {
        return this.parseFileName;
    }

    public Throwable getCurrentException() {
        return this.currentException;
    }

    public String readFileToString(File file) throws IOException {
        StringBuffer sb;
        block6: {
            logger.entering(this.getClass().getName(), "readFileToString(File)", new Object[0]);
            sb = new StringBuffer();
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(file));
                    String currentLine = null;
                    while ((currentLine = br.readLine()) != null) {
                        sb.append("\n" + currentLine);
                    }
                }
                catch (IOException e) {
                    logger.throwing(this.getClass().getName(), "readFileToString(File)", (Throwable)e);
                    logger.error((Throwable)e);
                    br.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                br.close();
                throw throwable;
            }
            br.close();
        }
        logger.exiting(this.getClass().getName(), "readFileToString(File)", new Object[0]);
        return sb.toString();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public ArrayList<SegmentModel> parseCobolCopyBookModel(Resource res) throws ImportParseException, ModelException {
        ArrayList<SegmentModel> segments = new ArrayList<SegmentModel>();
        ArrayList<COBOLElement> redefinedCOBOLElements = new ArrayList<COBOLElement>();
        for (EObject refObject : res.getContents()) {
            if (!(refObject instanceof COBOLElement) || ((COBOLElement)refObject).getLevel().equals("77")) continue;
            COBOLElement element = (COBOLElement)refObject;
            SegmentModel segment = new SegmentModel();
            segment.setName(element.getName());
            FieldModel field = this.parseElementModel(element);
            if (((COBOLElement)refObject).getLevel().equals("01")) {
                if (((COBOLElement)refObject).getRedefined().booleanValue()) {
                    redefinedCOBOLElements.add((COBOLElement)refObject);
                }
                if (refObject instanceof COBOLRedefiningElement && ((COBOLRedefiningElement)element).getRedefines() != null) {
                    for (COBOLElement curCOBOLElement : redefinedCOBOLElements) {
                        if (((COBOLRedefiningElement)element).getRedefines().getName() != curCOBOLElement.getName()) continue;
                        FieldModel redefinedField = this.parseElementModel(curCOBOLElement);
                        Vector<FieldModel> redefinedFieldList = redefinedField.getFieldListUnOrdered();
                        SegmentModel.preconditionTopLevelFieldStartInfo(redefinedFieldList);
                        if (redefinedFieldList.size() != 1 || !redefinedField.getName().equals(redefinedFieldList.get(0).getName())) {
                            segment.addField(redefinedField);
                            break;
                        }
                        int i = 0;
                        while (i < redefinedFieldList.size()) {
                            FieldModel currRedefinedField = redefinedFieldList.get(i);
                            segment.addField(currRedefinedField);
                            ++i;
                        }
                        break block1;
                    }
                }
            }
            Vector<FieldModel> fieldList = field.getFieldListUnOrdered();
            SegmentModel.preconditionTopLevelFieldStartInfo(fieldList);
            if (refObject instanceof COBOLRedefiningElement && ((COBOLElement)refObject).getLevel().equals("01") && ((COBOLRedefiningElement)element).getRedefines() != null && !fieldList.get(0).getName().equals(field.getName())) {
                segment.addField(field);
                segments.add(segment);
            } else {
                int i = 0;
                while (i < fieldList.size()) {
                    FieldModel currField = fieldList.get(i);
                    segment.addField(currField);
                    ++i;
                }
                segments.add(segment);
            }
            this.mapDataStructureToLangElement.put(segment, (TDLangElement)element);
        }
        if (segments.size() == 0) {
            ImportParseException e = new ImportParseException(WorkbenchModelBundle.getError().getString("IMPORT_APP_001"));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        return segments;
    }

    public ArrayList<SegmentHolder> parsePliInclude(Resource res) throws ImportParseException {
        ArrayList<SegmentHolder> segments = new ArrayList<SegmentHolder>();
        for (EObject refObject : res.getContents()) {
            PLIElement element;
            if (!(refObject instanceof PLIElement) || (element = (PLIElement)refObject).getSharedType() instanceof PLIPointerTypeImpl) continue;
            SegmentHolder segH = new SegmentHolder();
            segH.segName = element.getName();
            segH.fields.addAll(this.parseElement(element));
            segments.add(segH);
        }
        return segments;
    }

    public ArrayList<SegmentModel> parsePliIncludeModel(Resource res) throws ImportParseException, ModelException {
        ArrayList<SegmentModel> segments = new ArrayList<SegmentModel>();
        for (EObject refObject : res.getContents()) {
            PLIElement element;
            PLIClassifier classifier;
            if (!(refObject instanceof PLIElement) || !((classifier = (element = (PLIElement)refObject).getSharedType()) instanceof PLIComposedType)) continue;
            this.currDataStructure = new SegmentModel();
            this.currDataStructure.setName(element.getName());
            FieldModel field = this.parseElementModel(element);
            Vector<FieldModel> fieldList = field.getFieldListUnOrdered();
            SegmentModel.preconditionTopLevelFieldStartInfo(fieldList);
            int i = 0;
            while (i < fieldList.size()) {
                FieldModel currField = fieldList.get(i);
                this.currDataStructure.addField(currField);
                ++i;
            }
            segments.add(this.currDataStructure);
            this.mapDataStructureToLangElement.put(this.currDataStructure, (TDLangElement)element);
        }
        if (segments.size() == 0) {
            ImportParseException e = new ImportParseException(WorkbenchModelBundle.getError().getString("IMPORT_APP_001"));
            logger.throwing(this.getClass().getName(), "", (Throwable)e);
            throw e;
        }
        return segments;
    }

    private String replaceHyphens(String value) {
        Object retVal = value;
        if (retVal != null && !((String)retVal).isEmpty()) {
            retVal = ((String)retVal).replace('-', '_');
        }
        if (Utility.hasReservedSQLKeywords((String)retVal)) {
            retVal = (String)retVal + "1";
        }
        retVal = ((String)retVal).toUpperCase();
        return retVal;
    }

    private FieldModel parseElementModel(COBOLElement element) throws ImportParseException, ModelException {
        COBOLClassifier classifier;
        COBOLElement redefines;
        String redefinedName;
        FieldModelImpl field = new FieldModelImpl();
        field.setName(this.replaceHyphens(element.getName()));
        this.parseTDBaseModel(field, element.getInstanceTDBase());
        COBOLFixedLengthArray array = element.getArray();
        if (array != null) {
            field.setAppDatatype(DBDConstants.ARRAY);
            int maxUpper = array.getMaxUpper();
            if (array instanceof COBOLVariableLengthArray) {
                COBOLVariableLengthArray varArray = (COBOLVariableLengthArray)array;
                field.setMinOccurs(varArray.getMinUpper());
                COBOLElement dependingOn = varArray.getDependingOn();
                field.setDependsOn(this.replaceHyphens(dependingOn.getName()));
                field.setMaxBytes(field.getBytes());
                field.setBytes(0);
            } else {
                field.setMinOccurs(maxUpper);
            }
            field.setMaxOccurs(maxUpper);
        }
        if (element instanceof COBOLRedefiningElement && (redefinedName = (redefines = ((COBOLRedefiningElement)element).getRedefines()).getName()) != null && !redefinedName.isEmpty()) {
            field.setRedefines(this.replaceHyphens(redefinedName));
        }
        if ((classifier = element.getSharedType()) instanceof COBOLSimpleType && array != null) {
            FieldModelImpl subField = new FieldModelImpl();
            subField.setName(field.getName() + "_SUB");
            String pictureString = ((COBOLSimpleType)classifier).getPictureString();
            subField.setBytes(this.getFieldLength(pictureString, ((COBOLSimpleType)classifier).getUsage()));
            field.addField(subField);
            this.parseSimpleModel(subField, (COBOLSimpleType)classifier);
        } else if (classifier instanceof COBOLSimpleType) {
            this.parseSimpleModel(field, (COBOLSimpleType)classifier);
        } else if (classifier instanceof COBOLComposedType) {
            if (field.getAppDatatype() != DBDConstants.ARRAY) {
                field.setAppDatatype(DBDConstants.STRUCT);
            }
            this.parseComposedModel((FieldModel)field, (COBOLComposedType)classifier);
        } else {
            throw new RuntimeException("COBOLClassifier not of known type");
        }
        logger.finer("Parsing complete for field: " + field.getName());
        return field;
    }

    private int getFieldLength(String pictureString, COBOLUsageValues usageValue) throws ImportParseException {
        int retVal = -1;
        if (pictureString != null) {
            if (pictureString.indexOf(88) >= 0 || pictureString.indexOf(120) >= 0 || pictureString.indexOf(65) >= 0 || pictureString.indexOf(97) >= 0 || pictureString.indexOf(71) >= 0 || pictureString.indexOf(103) >= 0) {
                retVal = this.getAlphaNumericPictureStringLength(pictureString);
            } else {
                retVal = this.getComputationalPictureStringLength(pictureString);
                if (usageValue.getValue() == 0) {
                    if (retVal >= 1 && retVal <= 4) {
                        retVal = 2;
                    } else if (retVal >= 5 && retVal <= 9) {
                        retVal = 4;
                    } else if (retVal >= 10 && retVal <= 18) {
                        retVal = 8;
                    }
                } else if (usageValue.getValue() == 8) {
                    retVal = (retVal + 2) / 2;
                }
            }
        } else {
            if (usageValue.getValue() == 4) {
                return 4;
            }
            if (usageValue.getValue() == 2) {
                return 8;
            }
        }
        return retVal;
    }

    private Vector<FieldHolder> parseElement(PLIElement element) throws ImportParseException {
        Vector<FieldHolder> fields = new Vector<FieldHolder>();
        FieldHolder fieldH = new FieldHolder();
        if (!element.getLevel().equals("1")) {
            fields.add(fieldH);
        }
        fieldH.javaName = element.getName();
        if (element.getArray().size() > 0) {
            PLIFixedBoundArrayImpl array = (PLIFixedBoundArrayImpl)element.getArray().get(0);
            fieldH.type = 17;
            int repeatingCount = array.getUBound();
            Vector<FieldHolder> repeatingFields = new Vector<FieldHolder>();
            PLIClassifier classifier = element.getSharedType();
            if (classifier instanceof PLISimpleType) {
                FieldHolder repeatingField = new FieldHolder();
                repeatingField.javaName = null;
                repeatingField.startByte = fieldH.startByte;
                repeatingField.length = fieldH.length / repeatingCount;
                repeatingFields.add(repeatingField);
            } else if (classifier instanceof PLIComposedType) {
                repeatingFields.addAll(this.parseComposed((PLIComposedType)classifier));
            } else {
                throw new RuntimeException("PLIClassifier not of known type");
            }
            int offset = 0;
            int count = 0;
            while (count < repeatingCount) {
                offset = fieldH.length / repeatingCount * count;
                for (FieldHolder repeatingField : repeatingFields) {
                    FieldHolder unrolledField = new FieldHolder();
                    unrolledField.javaName = repeatingField.javaName != null ? fieldH.javaName + "_" + (count + 1) + "_" + repeatingField.javaName : fieldH.javaName + "_" + (count + 1);
                    unrolledField.startByte = offset + repeatingField.startByte;
                    unrolledField.length = repeatingField.length;
                    unrolledField.type = repeatingField.type;
                    unrolledField.qualifier = repeatingField.qualifier;
                    unrolledField.secondary = repeatingField.secondary;
                    unrolledField.defaultVal = repeatingField.defaultVal;
                    unrolledField.XMLType = repeatingField.XMLType;
                    unrolledField.XMLStorageType = repeatingField.XMLStorageType;
                    fields.add(unrolledField);
                }
                ++count;
            }
        } else {
            PLIClassifier classifier = element.getSharedType();
            if (!(classifier instanceof PLISimpleType)) {
                if (classifier instanceof PLIComposedType) {
                    fieldH.type = 3;
                    fieldH.qualifier = "X(" + fieldH.length + ")";
                    fields.addAll(this.parseComposed((PLIComposedType)classifier));
                } else {
                    throw new RuntimeException("PLIClassifier not of known type");
                }
            }
        }
        return fields;
    }

    private FieldModel parseElementModel(PLIElement element) throws ImportParseException, ModelException {
        PLIClassifier classifier;
        int size;
        Object currArray;
        FieldModelImpl field = new FieldModelImpl();
        field.setName(element.getName().toUpperCase());
        this.parseTDBaseModel(field, element.getInstanceTDBase());
        EList elist = element.getArray();
        boolean elementIsArray = false;
        boolean isBitDataType = element.getInstanceTDBase().getAttributeInBit();
        if (elist.size() > 0 && (currArray = elist.get(0)) instanceof PLIArrayImpl) {
            field.setAppDatatype(DBDConstants.ARRAY);
            elementIsArray = true;
            if (currArray instanceof PLIFixedBoundArrayImpl) {
                Integer lBound = ((PLIFixedBoundArrayImpl)currArray).getLBound();
                Integer uBound = ((PLIFixedBoundArrayImpl)currArray).getUBound();
                if (!isBitDataType) {
                    if (lBound < 1) {
                        int addAmount = 1 - lBound;
                        int numElements = uBound + addAmount;
                        field.setMinOccurs(numElements);
                        field.setMaxOccurs(numElements);
                    } else if (lBound > 1) {
                        int subAmount = lBound - 1;
                        int numElements = uBound - subAmount;
                        field.setMinOccurs(numElements);
                        field.setMaxOccurs(numElements);
                    } else {
                        field.setMinOccurs(uBound);
                        field.setMaxOccurs(uBound);
                    }
                } else {
                    size = uBound / 8;
                    if (uBound % 8 > 0) {
                        ++size;
                    }
                    field.setBytes(size);
                }
            } else if (currArray instanceof PLIFixedLboundArrayImpl) {
                referredTo = ((PLIFixedLboundArrayImpl)currArray).getReferredTo();
                field.setDependsOn(this.replaceHyphens(referredTo.getName()));
                field.setMinOccurs(1);
                field.setMaxOccurs(2);
                this.informationExceptionHandling(field, "IMPORT_ERR_13");
            } else if (currArray instanceof PLIVariableBoundArrayImpl) {
                referredTo = ((PLIVariableBoundArrayImpl)currArray).getReferredTo();
                field.setDependsOn(this.replaceHyphens(referredTo.getName()));
                field.setMinOccurs(1);
                field.setMaxOccurs(2);
                this.informationExceptionHandling(field, "IMPORT_ERR_13");
            }
        }
        if ((classifier = element.getSharedType()) instanceof PLISimpleType && elementIsArray && !isBitDataType) {
            FieldModelImpl subField = new FieldModelImpl();
            subField.setName(field.getName() + "_SUB");
            try {
                InstanceTDBase instanceTdBase = element.getInstanceTDBase();
                size = Integer.valueOf(((ArrayTD)instanceTdBase.getArrayDescr().get(0)).getStride());
                subField.setBytes(size);
            }
            catch (Exception e) {
                logger.finest("PLI DS error importing array: " + e.getMessage());
            }
            field.addField(subField);
            this.parseSimpleModel(subField, (PLISimpleType)classifier, element);
        } else if (classifier instanceof PLISimpleType) {
            this.parseSimpleModel(field, (PLISimpleType)classifier, element);
        } else if (classifier instanceof PLIComposedType) {
            if (field.getAppDatatype() != DBDConstants.ARRAY) {
                field.setAppDatatype(DBDConstants.STRUCT);
            }
            this.parseComposedModel((FieldModel)field, (PLIComposedType)classifier);
        } else {
            throw new RuntimeException("PLIClassifier " + String.valueOf(classifier) + " not of known type");
        }
        logger.finer("Parsing complete for field: " + field.getName());
        return field;
    }

    private void parseTDBaseModel(FieldModel field, InstanceTDBase base) throws ImportParseException {
        String length = base.getSize();
        String startByte = base.getOffset();
        int lengthInt = 0;
        int startInt = 0;
        boolean lengthNotInt = false;
        boolean startNotInt = false;
        try {
            startInt = Integer.parseInt(startByte);
        }
        catch (NumberFormatException numberFormatException) {
            startNotInt = true;
        }
        try {
            lengthInt = Integer.parseInt(length);
        }
        catch (NumberFormatException numberFormatException) {
            lengthNotInt = true;
        }
        if (base.getAttributeInBit().booleanValue()) {
            int mod = startInt % 8;
            startInt /= 8;
            if (mod > 0) {
                ++startInt;
            }
            mod = lengthInt % 8;
            lengthInt /= 8;
            if (mod > 0) {
                ++lengthInt;
            }
        }
        if (!startNotInt) {
            field.setStartPos(startInt + 1);
        }
        if (!lengthNotInt) {
            field.setBytes(lengthInt);
        } else {
            field.setMaxBytes(2);
        }
    }

    private void parseComposedModel(FieldModel field, COBOLComposedType composed) throws ImportParseException, ModelException {
        Iterator iter = composed.getElement().iterator();
        while (iter.hasNext()) {
            field.addField(this.parseElementModel((COBOLElement)iter.next()));
        }
    }

    private Vector<FieldHolder> parseComposed(PLIComposedType composed) throws ImportParseException {
        Vector<FieldHolder> fields = new Vector<FieldHolder>();
        Iterator iter = composed.getElements().iterator();
        while (iter.hasNext()) {
            fields.addAll(this.parseElement((PLIElement)iter.next()));
        }
        return fields;
    }

    private void parseComposedModel(FieldModel field, PLIComposedType composed) throws ImportParseException, ModelException {
        FieldModel currField = null;
        FieldModel prevField = null;
        Boolean isUnion = composed.getUnion();
        Iterator iter = composed.getElements().iterator();
        while (iter.hasNext()) {
            currField = this.parseElementModel((PLIElement)iter.next());
            field.addField(currField);
            if (!isUnion.booleanValue()) continue;
            if (prevField != null) {
                currField.setRedefines(this.replaceHyphens(prevField.getName()));
            }
            prevField = currField;
        }
    }

    private void parseSimpleModel(FieldModel field, PLISimpleType simple, PLIElement element) throws ImportParseException {
        if (simple instanceof PLICodedStringTypeImpl) {
            StringTypeValues type = ((PLICodedStringTypeImpl)simple).getType();
            if (type.getValue() == 1) {
                field.setAppDatatype(DBDConstants.CHAR);
            } else if (type.getValue() == 0) {
                field.setAppDatatype(DBDConstants.BINARY);
            } else if (type.getValue() == 3) {
                field.setAppDatatype(DBDConstants.CHAR);
                field.setIsDbcs("YES");
                field.setPhysicalDataType(DBDConstants.CHAR);
            } else if (type.getValue() == 2) {
                field.setAppDatatype(DBDConstants.CHAR);
                field.setPhysicalDataType(DBDConstants.CHAR);
            }
        } else if (simple instanceof PLIPictureTypeImpl) {
            String picStr = ((PLIPictureTypeImpl)simple).getPictureString();
            boolean isZonedDecimal = true;
            boolean containsOverpunchChar = false;
            int i = 0;
            while (i < picStr.length()) {
                switch (picStr.charAt(i)) {
                    case '9': 
                    case 'V': {
                        break;
                    }
                    case 'R': 
                    case 'T': {
                        containsOverpunchChar = true;
                        break;
                    }
                    case '(': {
                        while (picStr.charAt(++i) != ')') {
                        }
                        break;
                    }
                    default: {
                        isZonedDecimal = false;
                    }
                }
                ++i;
            }
            if (containsOverpunchChar && !picStr.endsWith("T") && !picStr.endsWith("R")) {
                isZonedDecimal = false;
            }
            if (isZonedDecimal) {
                field.setAppDatatype(DBDConstants.DECIMAL);
                field.setPrecision(((PLIPictureTypeImpl)simple).getPrecision().toString());
                field.setScale(((PLIPictureTypeImpl)simple).getScale().toString());
                field.setPhysicalDataType(DBDConstants.ZONEDDECIMAL);
                field.setIsSigned("YES");
            } else {
                field.setAppDatatype(DBDConstants.CHAR);
            }
        } else if (simple instanceof PLIPackedTypeImpl) {
            field.setAppDatatype(DBDConstants.DECIMAL);
            field.setPrecision(((PLIPackedTypeImpl)simple).getPrecision().toString());
            field.setScale(((PLIPackedTypeImpl)simple).getScale().toString());
            field.setPhysicalDataType(DBDConstants.PACKEDDECIMAL);
            field.setIsSigned("YES");
        } else if (simple instanceof PLIIntegerTypeImpl) {
            Integer scale = ((PLIIntegerTypeImpl)simple).getScale();
            boolean signed = ((PLIIntegerTypeImpl)simple).isSigned();
            if (scale != 0) {
                Object[] inserts = new Object[]{element.getName()};
                ImportParseException e = new ImportParseException(WorkbenchModelBundle.getError().getString("IMPORT_APP_002", inserts));
                logger.throwing(this.getClass().getName(), "", (Throwable)e);
                logger.error((Throwable)e);
                throw e;
            }
            int bytes = field.getBytes();
            if (bytes == 1) {
                if (!signed) {
                    field.setAppDatatype(DBDConstants.UBYTE);
                } else {
                    field.setAppDatatype(DBDConstants.BYTE);
                }
            } else if (bytes == 2) {
                if (!signed) {
                    field.setAppDatatype(DBDConstants.USHORT);
                } else {
                    field.setAppDatatype(DBDConstants.SHORT);
                }
            } else if (bytes == 4) {
                if (!signed) {
                    field.setAppDatatype(DBDConstants.UINT);
                } else {
                    field.setAppDatatype(DBDConstants.INT);
                }
            } else if (bytes == 8) {
                if (!signed) {
                    field.setAppDatatype(DBDConstants.ULONG);
                } else {
                    field.setAppDatatype(DBDConstants.LONG);
                }
            }
        } else if (simple instanceof PLIFloatTypeImpl) {
            BaseValues bv = ((PLIFloatTypeImpl)simple).getBase();
            if (bv == BaseValues.DECIMAL_LITERAL) {
                field.setAppDatatype(DBDConstants.BINARY);
            } else {
                int bytes = field.getBytes();
                if (bytes == 4) {
                    field.setAppDatatype(DBDConstants.FLOAT);
                } else if (bytes == 8) {
                    field.setAppDatatype(DBDConstants.DOUBLE);
                } else {
                    field.setAppDatatype(DBDConstants.BINARY);
                }
            }
        }
    }

    private void parseSimpleModel(FieldModel field, COBOLSimpleType simple) throws ImportParseException {
        int fieldLength = field.getBytes();
        String qualifier = simple.getPictureString();
        int usageInt = simple.getUsage().getValue();
        switch (usageInt) {
            case 0: {
                if (!(simple instanceof COBOLNumericTypeImpl)) break;
                COBOLNumericTypeImpl numType = (COBOLNumericTypeImpl)simple;
                int scale = numType.getScale();
                boolean signed = numType.getSigned();
                int precision = numType.getPrecision();
                if (scale > 0) {
                    field.setAppDatatype(DBDConstants.DECIMAL);
                    field.setPrecision(Integer.toString(precision));
                    field.setScale(Integer.toString(scale));
                    field.setPhysicalDataType(DBDConstants.BINARY);
                    String isSigned = signed ? "Y" : "N";
                    field.setIsSigned(isSigned);
                    break;
                }
                if (precision <= 4) {
                    DBDConstants fieldType = !signed ? DBDConstants.USHORT : DBDConstants.SHORT;
                    field.setAppDatatype(fieldType);
                    if (fieldLength == 2) break;
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                    logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                    logger.error((Throwable)ipe);
                    throw ipe;
                }
                if (precision <= 9) {
                    DBDConstants fieldType = !signed ? DBDConstants.UINT : DBDConstants.INT;
                    field.setAppDatatype(fieldType);
                    if (fieldLength == 4) break;
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                    logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                    logger.error((Throwable)ipe);
                    throw ipe;
                }
                if (precision <= 18) {
                    DBDConstants fieldType = !signed ? DBDConstants.ULONG : DBDConstants.LONG;
                    field.setAppDatatype(fieldType);
                    if (fieldLength == 8) break;
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                    logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                    logger.error((Throwable)ipe);
                    throw ipe;
                }
                ImportParseException ipe = new ImportParseException("Binary numbers of length over 18 digits not supported");
                logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                logger.error((Throwable)ipe);
                throw ipe;
            }
            case 3: {
                if (simple instanceof COBOLAlphaNumericType || simple instanceof COBOLAlphabeticType) {
                    DBDConstants fieldType = DBDConstants.CHAR;
                    field.setAppDatatype(fieldType);
                    if (fieldLength == this.getAlphaNumericPictureStringLength(qualifier)) break;
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + " with type qualifier " + qualifier + ".");
                    logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                    logger.error((Throwable)ipe);
                    throw ipe;
                }
                if (simple instanceof COBOLNumericType) {
                    field.setAppDatatype(DBDConstants.DECIMAL);
                    DBDConstants fieldType = DBDConstants.ZONEDDECIMAL;
                    field.setPhysicalDataType(fieldType);
                    int picStrLength = this.getNumericPictureStringLength(qualifier);
                    if (((COBOLNumericType)simple).getSigned().booleanValue() && ((COBOLNumericType)simple).getSignSeparate().booleanValue()) {
                        ++picStrLength;
                    }
                    if (fieldLength != picStrLength) {
                        ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + " with type qualifier " + qualifier + ".");
                        logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                        logger.error((Throwable)ipe);
                        throw ipe;
                    }
                    field.setZoneddecimalSubparms(qualifier);
                    break;
                }
                if (simple instanceof COBOLNumericEditedType) {
                    DBDConstants fieldType = DBDConstants.CHAR;
                    field.setAppDatatype(fieldType);
                    break;
                }
                ImportParseException e = new ImportParseException("Field \"" + field.getName() + " is type \"" + simple.getClass().getSimpleName() + "\", which is an unsupported type for USAGE DISPLAY.");
                logger.throwing(this.getClass().getName(), "parseSimpleModel", (Throwable)e);
                logger.error((Throwable)e);
                throw e;
            }
            case 4: {
                DBDConstants fieldType = DBDConstants.FLOAT;
                field.setAppDatatype(fieldType);
                if (fieldLength == 4) break;
                ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                logger.error((Throwable)ipe);
                throw ipe;
            }
            case 2: {
                DBDConstants fieldType = DBDConstants.DOUBLE;
                field.setAppDatatype(fieldType);
                if (fieldLength == 8) break;
                ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                logger.error((Throwable)ipe);
                throw ipe;
            }
            case 8: {
                field.setAppDatatype(DBDConstants.DECIMAL);
                DBDConstants fieldType = DBDConstants.PACKEDDECIMAL;
                field.setPhysicalDataType(fieldType);
                if (fieldLength != (this.getNumericPictureStringLength(qualifier) + 2) / 2) {
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + " with type qualifier " + qualifier + ".");
                    logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                    logger.error((Throwable)ipe);
                    throw ipe;
                }
                field.setPackeddecimalSubparms(qualifier);
                break;
            }
            case 1: {
                DBDConstants fieldType = DBDConstants.DBCS;
                field.setAppDatatype(fieldType);
                field.setPhysicalDataType(DBDConstants.DBCS);
                field.setIsDbcs("YES");
                if (fieldLength == this.getAlphaNumericPictureStringLength(qualifier)) break;
                ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + " with type qualifier " + qualifier + ".");
                logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                logger.error((Throwable)ipe);
                throw ipe;
            }
            default: {
                ImportParseException ipe = new ImportParseException(simple.getUsage().getName().toUpperCase() + " not yet supported");
                logger.throwing(this.getClass().getName(), "", (Throwable)ipe);
                logger.error((Throwable)ipe);
                throw ipe;
            }
        }
    }

    private int getComputationalPictureStringLength(String pictureString) throws ImportParseException {
        int length = 0;
        int i = 0;
        while (i < pictureString.length()) {
            char charVal = pictureString.charAt(i);
            switch (charVal) {
                case '9': {
                    ++length;
                    break;
                }
                case '(': {
                    int starting = i++;
                    while (pictureString.charAt(i) != ')') {
                        ++i;
                    }
                    if (pictureString.charAt(starting - 1) == '9') {
                        length += Integer.parseInt(pictureString.substring(starting + 1, i)) - 1;
                        break;
                    }
                    throw new ImportParseException("Computational Picture String not of 9's");
                }
            }
            ++i;
        }
        return length;
    }

    private int getAlphaNumericPictureStringLength(String pictureString) throws ImportParseException {
        int length = 0;
        boolean isDBCS = false;
        int i = 0;
        while (i < pictureString.length()) {
            char charVal = pictureString.charAt(i);
            switch (charVal) {
                case 'A': 
                case 'X': 
                case 'a': 
                case 'x': {
                    ++length;
                    break;
                }
                case 'G': 
                case 'g': {
                    ++length;
                    isDBCS = true;
                    break;
                }
                case '(': {
                    int starting = i++;
                    while (pictureString.charAt(i) != ')') {
                        ++i;
                    }
                    length += Integer.parseInt(pictureString.substring(starting + 1, i)) - 1;
                    break;
                }
                default: {
                    throw new ImportParseException("Unsupported Picture String character: " + pictureString.charAt(i));
                }
            }
            ++i;
        }
        return isDBCS ? length * 2 : length;
    }

    private int getNumericPictureStringLength(String pictureString) throws ImportParseException {
        int length = 0;
        int i = 0;
        while (i < pictureString.length()) {
            switch (pictureString.charAt(i)) {
                case '.': 
                case '9': 
                case 'Z': 
                case 'z': {
                    ++length;
                }
                case 'P': 
                case 'S': 
                case 'V': 
                case 'p': 
                case 's': 
                case 'v': {
                    break;
                }
                case '(': {
                    int starting = i++;
                    while (pictureString.charAt(i) != ')') {
                        ++i;
                    }
                    if (pictureString.charAt(starting - 1) == '9') {
                        length += Integer.parseInt(pictureString.substring(starting + 1, i)) - 1;
                        break;
                    }
                    throw new ImportParseException("Invalid Picture String");
                }
                default: {
                    throw new ImportParseException("Unsupported Picture String character: " + pictureString.charAt(i));
                }
            }
            ++i;
        }
        return length;
    }

    private void informationExceptionHandling(FieldModel field, String message) {
        String currFieldName = field.getName();
        String ds = this.currDataStructure.getName() + ":" + currFieldName;
        if (this.informationExceptionList == null) {
            this.informationExceptionList = new Vector();
            InformationException e = new InformationException(WorkbenchModelBundle.getError().getString(message), ds);
            this.informationExceptionList.add(e);
        } else {
            Iterator<InformationException> iter = this.informationExceptionList.iterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                InformationException currException = iter.next();
                if (!currException.getMessage().equals(WorkbenchModelBundle.getError().getString(message))) continue;
                found = true;
                currException.addToResourceList(ds);
            }
            if (!found) {
                InformationException e = new InformationException(WorkbenchModelBundle.getError().getString(message), ds);
                this.informationExceptionList.add(e);
            }
        }
    }

    public Vector<InformationException> getInformationExceptionList() {
        return this.informationExceptionList;
    }

    public void setMember(Member member) {
        this.member = member;
    }
}

