/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.importer.datastructure;

import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.IFieldContainer;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import java.util.Properties;

public class ImportAction {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FieldModel newField;
    private FieldModel mergeTarget;
    private IFieldContainer existingFieldContainer;
    private SegmentModel existingSegmentModel;
    private Action action;

    public FieldModel getNewField() {
        return this.newField;
    }

    public void setNewField(FieldModel newField) {
        this.newField = newField;
    }

    public FieldModel getMergeTarget() {
        return this.mergeTarget;
    }

    public void setMergeTarget(FieldModel mergeTarget) {
        this.mergeTarget = mergeTarget;
    }

    public void setExistingFieldContainer(IFieldContainer existingFieldContainer) {
        this.existingFieldContainer = existingFieldContainer;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void performAction(Properties nameChanges) throws ModelException {
        if (this.action == Action.MERGE) {
            DBDConstants appDataType = this.newField.getAppDatatype();
            DBDConstants physicalDataType = this.newField.getPhysicalDataType();
            this.mergeTarget.setAppDatatype(appDataType);
            if (physicalDataType != null) {
                this.mergeTarget.setPhysicalDataType(physicalDataType);
            }
            if (physicalDataType == DBDConstants.ZONEDDECIMAL || physicalDataType == DBDConstants.PACKEDDECIMAL) {
                this.mergeTarget.setPrecision(this.newField.getPrecision().toString());
                this.mergeTarget.setScale(this.newField.getScale().toString());
                this.mergeTarget.setIsSigned(this.newField.getIsSigned().toString());
            }
        } else {
            String parentFieldName;
            Object newParentFieldName;
            FieldModel parentField;
            Object newStartAfterName;
            String startAfterStr;
            Object newDependsonName;
            String currDependson;
            Object newRedefinedFieldName;
            String currRedefines;
            if (this.newField.hasSubFields()) {
                this.newField.removeAllSubFields();
            }
            FieldModel nameCollisionField = null;
            String baseNewFieldName = this.newField.getName();
            Object newFieldName = baseNewFieldName;
            int iterations = 0;
            boolean changingCurrFieldName = false;
            do {
                if ((nameCollisionField = this.existingFieldContainer.getFieldWithAlias((String)newFieldName, this.existingSegmentModel)) != null) {
                    changingCurrFieldName = true;
                    newFieldName = iterations > 0 ? baseNewFieldName + "_NEW" + Integer.toString(iterations) : (String)newFieldName + "_NEW";
                }
                ++iterations;
            } while (nameCollisionField != null);
            if (changingCurrFieldName) {
                nameChanges.put(baseNewFieldName, newFieldName);
                this.newField.setName((String)newFieldName);
            }
            if ((currRedefines = this.newField.getRedefines()) != null && !currRedefines.isEmpty() && (newRedefinedFieldName = nameChanges.get(currRedefines)) != null) {
                this.newField.setRedefines((String)newRedefinedFieldName);
            }
            if ((currDependson = this.newField.getDependsOn()) != null && !currDependson.isEmpty() && (newDependsonName = nameChanges.get(currDependson)) != null) {
                this.newField.setDependsOn((String)newDependsonName);
            }
            if ((startAfterStr = this.newField.getStartAfter()) != null && !startAfterStr.isEmpty() && (newStartAfterName = nameChanges.get(startAfterStr)) != null) {
                this.newField.setStartAfter((String)newStartAfterName);
            }
            if (currRedefines != null && !currRedefines.isEmpty() && startAfterStr != null && !startAfterStr.isEmpty()) {
                Object newRedefinedFieldName2 = nameChanges.get(currRedefines);
                if (newRedefinedFieldName2 != null) {
                    this.newField.setStartAfter((String)newRedefinedFieldName2);
                } else {
                    this.newField.setStartAfter(currRedefines);
                }
            }
            if ((parentField = this.newField.getParentField()) != null && (newParentFieldName = nameChanges.get(parentFieldName = parentField.getName())) != null) {
                parentField.setName((String)newParentFieldName);
            }
            this.existingFieldContainer.addField(this.newField);
        }
    }

    public void setExistingSegmentModel(SegmentModel existingSegmentModel) {
        this.existingSegmentModel = existingSegmentModel;
    }

    public String toString() {
        return "Action: " + String.valueOf((Object)this.action) + " newField: " + String.valueOf(this.newField) + " mergeTarget: " + String.valueOf(this.mergeTarget);
    }

    public static enum Action {
        ADD,
        MERGE;

    }
}

