/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.field;

import com.ibm.im.ims.workbench.controller.editor.ResourceEditorController;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import java.util.ArrayList;

public class ManageSenfldsController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SensegModel origSensegModel;
    private SensegModel clonedSensegModel;
    private SenfieldModel origSenfldBeingEdited;
    private boolean hasBeenEdited = false;
    private ResourceEditorController reController;
    private boolean isReadOnly;

    public ManageSenfldsController(SensegModel sensegModel, ResourceEditorController reController, boolean isReadOnly) throws ModelException {
        this.origSensegModel = sensegModel;
        this.clonedSensegModel = new SensegModel(sensegModel);
        this.reController = reController;
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public ArrayList<SenfieldModel> getFreshSenfldList() throws ModelException {
        return this.clonedSensegModel.getSenfields();
    }

    public SenfieldModel createNewSenfldModelForAdd() {
        SenfieldModel retVal = new SenfieldModel("");
        retVal.setSegmentModel(this.origSensegModel.getSegModel());
        return retVal;
    }

    public SensegModel getSenseg() throws ModelException {
        return this.clonedSensegModel;
    }

    public SenfieldModel getSenfield(String fieldName, String startStr, String replaceStr) throws ModelException {
        return this.clonedSensegModel.getSenfield(fieldName, startStr, replaceStr);
    }

    public SenfieldModel getOrigSenfldBeingEdited() {
        return this.origSenfldBeingEdited;
    }

    public SenfieldModel getSenfieldCloneForEdit(SenfieldModel senfld) throws ModelException {
        this.origSenfldBeingEdited = senfld;
        return new SenfieldModel(this.origSenfldBeingEdited);
    }

    public void addNewSenfld(SenfieldModel newSenfld) {
        this.clonedSensegModel.addField(newSenfld);
        this.hasBeenEdited = true;
    }

    public void replaceOrigSenfldWithClone(SenfieldModel clonedSenfldModel) throws ModelException {
        this.clonedSensegModel.removeField(this.origSenfldBeingEdited);
        this.clonedSensegModel.addField(clonedSenfldModel);
        this.hasBeenEdited = true;
    }

    public boolean hasBeenEdited() {
        return this.hasBeenEdited;
    }

    public void performFinish() throws ModelException {
        if (this.clonedSensegModel.allSenfldsAreDefault()) {
            this.origSensegModel.removeAllSenflds();
        } else {
            this.origSensegModel.replaceSenflds(this.clonedSensegModel);
        }
    }

    public void removeSenfld(SenfieldModel senfld) {
        this.clonedSensegModel.removeField(senfld);
        this.hasBeenEdited = true;
    }

    public String getProjectName() {
        return this.reController.getProjectName();
    }
}

